# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.hybridconnectivity.aio import HybridConnectivityMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestHybridConnectivityMgmtPublicCloudConnectorsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(HybridConnectivityMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_public_cloud_connectors_get(self, resource_group):
        response = await self.client.public_cloud_connectors.get(
            resource_group_name=resource_group.name,
            public_cloud_connector="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_public_cloud_connectors_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.public_cloud_connectors.begin_create_or_update(
                resource_group_name=resource_group.name,
                public_cloud_connector="str",
                resource={
                    "location": "str",
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "awsCloudProfile": {
                            "accountId": "str",
                            "excludedAccounts": ["str"],
                            "isOrganizationalAccount": bool,
                        },
                        "hostType": "str",
                        "connectorPrimaryIdentifier": "str",
                        "provisioningState": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_public_cloud_connectors_update(self, resource_group):
        response = await self.client.public_cloud_connectors.update(
            resource_group_name=resource_group.name,
            public_cloud_connector="str",
            properties={
                "id": "str",
                "name": "str",
                "properties": {"awsCloudProfile": {"excludedAccounts": ["str"]}},
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_public_cloud_connectors_delete(self, resource_group):
        response = await self.client.public_cloud_connectors.delete(
            resource_group_name=resource_group.name,
            public_cloud_connector="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_public_cloud_connectors_list_by_resource_group(self, resource_group):
        response = self.client.public_cloud_connectors.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_public_cloud_connectors_list_by_subscription(self, resource_group):
        response = self.client.public_cloud_connectors.list_by_subscription()
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_public_cloud_connectors_begin_test_permissions(self, resource_group):
        response = await (
            await self.client.public_cloud_connectors.begin_test_permissions(
                resource_group_name=resource_group.name,
                public_cloud_connector="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
