/*
 * Decompiled with CFR 0.152.
 */
package adql.search;

import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.ADQLQuery;
import adql.search.ISearchHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;

public abstract class SimpleSearchHandler
implements ISearchHandler {
    private boolean recursive = false;
    private boolean firstMatch = false;
    protected final ArrayList<ADQLObject> results = new ArrayList();

    public SimpleSearchHandler() {
    }

    public SimpleSearchHandler(boolean recursive) {
        this();
        this.recursive = recursive;
    }

    public SimpleSearchHandler(boolean recursive, boolean onlyFirstMatch) {
        this(recursive);
        this.firstMatch = onlyFirstMatch;
    }

    public final boolean isRecursive() {
        return this.recursive;
    }

    public final void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public final boolean onlyFirstMatch() {
        return this.firstMatch;
    }

    public final void setOnlyFirstMatch(boolean firstMatch) {
        this.firstMatch = firstMatch;
    }

    @Override
    public final Iterator<ADQLObject> iterator() {
        return this.results.iterator();
    }

    @Override
    public final int getNbMatch() {
        return this.results.size();
    }

    protected boolean isFinished() {
        return this.firstMatch && !this.results.isEmpty();
    }

    protected boolean goInto(ADQLObject obj) {
        return this.recursive || !(obj instanceof ADQLQuery);
    }

    protected void addMatch(ADQLObject matchObj, ADQLIterator it) {
        this.results.add(matchObj);
    }

    protected void reset() {
        this.results.clear();
    }

    @Override
    public final void search(ADQLObject startObj) {
        this.reset();
        if (startObj == null) {
            return;
        }
        if (this.match(startObj)) {
            this.addMatch(startObj, null);
        }
        Stack<ADQLIterator> stackIt = new Stack<ADQLIterator>();
        ADQLObject obj = null;
        ADQLIterator it = startObj.adqlIterator();
        while (!this.isFinished()) {
            do {
                if (it != null && it.hasNext()) {
                    obj = (ADQLObject)it.next();
                    continue;
                }
                if (!stackIt.isEmpty()) {
                    it = (ADQLIterator)stackIt.pop();
                    continue;
                }
                return;
            } while (obj == null);
            if (this.match(obj)) {
                this.addMatch(obj, it);
            }
            if (this.goInto(obj)) {
                stackIt.push(it);
                it = obj.adqlIterator();
            }
            obj = null;
        }
    }

    protected abstract boolean match(ADQLObject var1);
}

