/*
 * Decompiled with CFR 0.152.
 */
package adql.translator;

import adql.query.operand.ADQLOperand;
import adql.query.operand.function.ADQLFunction;
import adql.translator.ADQLTranslator;
import adql.translator.TranslationException;
import java.text.ParseException;
import java.util.ArrayDeque;

public final class TranslationPattern {
    private TranslationPattern() {
    }

    private static void checkArgIndex(int argIndex, int nbParams, int textPos) throws ParseException {
        if (argIndex < 1 || argIndex > nbParams) {
            throw new ParseException("[c." + textPos + "] Incorrect argument index: '$" + argIndex + "'. Expected: an integer between [1;" + nbParams + "].", textPos);
        }
    }

    public static String check(String transPattern, final int nbMaxParams) throws NullPointerException, ParseException {
        try {
            return TranslationPattern.apply(transPattern, new ParameterTranslator(){
                private final int NB_PARAMS;
                {
                    this.NB_PARAMS = Math.max(0, nbMaxParams);
                }

                @Override
                public String translate(int paramIndex) throws TranslationException {
                    return "$" + paramIndex;
                }

                @Override
                public int getNbParameters() {
                    return this.NB_PARAMS;
                }
            });
        }
        catch (NullPointerException | ParseException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ParseException(ex.getMessage(), -1);
        }
    }

    public static String apply(String transPattern, final ADQLFunction fct, final ADQLTranslator translator) throws NullPointerException, TranslationException {
        if (fct == null) {
            throw new NullPointerException("Missing the ADQL function to translate!");
        }
        if (translator == null) {
            throw new NullPointerException("Missing the ADQL translation to use!");
        }
        try {
            return TranslationPattern.apply(transPattern, new ParameterTranslator(){

                @Override
                public String translate(int paramIndex) throws TranslationException {
                    ADQLOperand arg = fct.getParameter(paramIndex - 1);
                    return translator.translate(arg);
                }

                @Override
                public int getNbParameters() {
                    return fct.getNbParameters();
                }
            });
        }
        catch (TranslationException | NullPointerException ex) {
            throw ex;
        }
        catch (ParseException ex) {
            throw new TranslationException(ex.getMessage(), ex);
        }
        catch (Exception ex) {
            throw new TranslationException(ex);
        }
    }

    public static String apply(String transPattern, ParameterTranslator paramTranslator) throws NullPointerException, ParseException, TranslationException {
        ParsingState state;
        if (transPattern == null || transPattern.trim().length() == 0) {
            throw new NullPointerException("Missing translation pattern!");
        }
        if (paramTranslator == null) {
            throw new NullPointerException("Missing the ParameterTranslator to use!");
        }
        StringBuffer sql = new StringBuffer();
        int NB_PARAMS = paramTranslator.getNbParameters();
        ArrayDeque<ParsingState> stackState = new ArrayDeque<ParsingState>(5);
        ArrayDeque<Boolean> stackIgnore = new ArrayDeque<Boolean>(5);
        char[] pattern = transPattern.toCharArray();
        boolean ignore = false;
        int argIndex = 0;
        block14: for (int textPos = 0; textPos < pattern.length; ++textPos) {
            char c = pattern[textPos];
            state = stackState.isEmpty() ? ParsingState.TEXT : (ParsingState)((Object)stackState.peek());
            ignore = !stackIgnore.isEmpty() && (Boolean)stackIgnore.peek() != false;
            switch (state) {
                case DOLLAR: {
                    if (c == '$') {
                        if (!ignore) {
                            sql.append(c);
                        }
                        stackState.poll();
                        continue block14;
                    }
                    if (Character.isDigit(c)) {
                        argIndex = Character.digit(c, 10);
                        stackState.poll();
                        stackState.push(ParsingState.ARG_REF);
                        continue block14;
                    }
                    throw new ParseException("[c." + textPos + "] Unexpected character after '$': '" + c + "'! Expected: '$' or an argument index (i.e. an integer).", textPos);
                }
                case ARG_REF: {
                    if (Character.isDigit(c)) {
                        argIndex = argIndex * 10 + Character.digit(c, 10);
                        continue block14;
                    }
                    if (c == '.') {
                        stackState.pop();
                        stackState.push(ParsingState.ARG_LIST);
                        continue block14;
                    }
                    if (c == '?') {
                        stackIgnore.push(ignore || argIndex < 1 || argIndex > NB_PARAMS);
                        argIndex = 0;
                        stackState.pop();
                        stackState.push(ParsingState.TERNARY_THEN);
                        continue block14;
                    }
                    if (!ignore) {
                        TranslationPattern.checkArgIndex(argIndex, NB_PARAMS, textPos);
                        sql.append(paramTranslator.translate(argIndex));
                    }
                    --textPos;
                    stackState.poll();
                    argIndex = 0;
                    continue block14;
                }
                case ARG_LIST: {
                    TranslationPattern.checkArgIndex(argIndex, NB_PARAMS, textPos);
                    if (c == '.') {
                        if (!ignore) {
                            for (int pIndex = argIndex; pIndex <= NB_PARAMS; ++pIndex) {
                                sql.append(paramTranslator.translate(pIndex));
                                if (pIndex + 1 > NB_PARAMS) continue;
                                sql.append(", ");
                            }
                        }
                    } else {
                        if (!ignore) {
                            sql.append(paramTranslator.translate(argIndex));
                            sql.append('.');
                        }
                        --textPos;
                    }
                    stackState.poll();
                    argIndex = 0;
                    continue block14;
                }
                case TERNARY_THEN: 
                case TERNARY_ELSE: {
                    if (c == '{') {
                        stackState.pop();
                        if (state == ParsingState.TERNARY_THEN) {
                            stackState.push(ParsingState.TEXT_THEN);
                            continue block14;
                        }
                        stackState.push(ParsingState.TEXT_ELSE);
                        continue block14;
                    }
                    if (Character.isWhitespace(c)) continue block14;
                    throw new ParseException("[c." + textPos + "] Unexpected character: '" + c + "'! Expected: '{'.", textPos);
                }
                default: {
                    if (c == '$') {
                        stackState.push(ParsingState.DOLLAR);
                        continue block14;
                    }
                    if (c == '}') {
                        if (state == ParsingState.TEXT_THEN) {
                            ignore = (Boolean)stackIgnore.pop() == false;
                            stackIgnore.push(!stackIgnore.isEmpty() && (Boolean)stackIgnore.peek() != false || ignore);
                            stackState.pop();
                            stackState.push(ParsingState.TERNARY_ELSE);
                            continue block14;
                        }
                        if (state == ParsingState.TEXT_ELSE) {
                            stackIgnore.pop();
                            stackState.pop();
                            continue block14;
                        }
                        if (ignore) continue block14;
                        sql.append(c);
                        continue block14;
                    }
                    if (ignore) continue block14;
                    sql.append(c);
                }
            }
        }
        block16: while (!stackState.isEmpty()) {
            state = (ParsingState)((Object)stackState.pop());
            switch (state) {
                case DOLLAR: {
                    throw new ParseException("[c." + pattern.length + "] Missing character after '$'! Expected: '$' or an argument index (i.e. an integer).", pattern.length);
                }
                case ARG_REF: 
                case ARG_LIST: {
                    TranslationPattern.checkArgIndex(argIndex, NB_PARAMS, pattern.length);
                    sql.append(paramTranslator.translate(argIndex));
                    if (state == ParsingState.ARG_LIST) {
                        sql.append('.');
                    }
                    argIndex = 0;
                    continue block16;
                }
                case TERNARY_THEN: {
                    throw new ParseException("[c." + pattern.length + "] Missing start of the THEN block of a ternary expression! Expected: '{'.", pattern.length);
                }
                case TERNARY_ELSE: {
                    throw new ParseException("[c." + pattern.length + "] Missing start of the ELSE block of a ternary expression! Expected: '{'.", pattern.length);
                }
                case TEXT_THEN: {
                    throw new ParseException("[c." + pattern.length + "] Missing end of the THEN block of a ternary expression! Expected: '}'.", pattern.length);
                }
                case TEXT_ELSE: {
                    throw new ParseException("[c." + pattern.length + "] Missing end of the ELSE block of a ternary expression! Expected: '}'.", pattern.length);
                }
            }
        }
        return sql.toString();
    }

    public static interface ParameterTranslator {
        public int getNbParameters();

        public String translate(int var1) throws TranslationException;
    }

    private static enum ParsingState {
        TEXT,
        TEXT_THEN,
        TEXT_ELSE,
        DOLLAR,
        ARG_REF,
        ARG_LIST,
        TERNARY_THEN,
        TERNARY_ELSE;

    }
}

