/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.resource;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.tika.detect.CompositeDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.server.HTMLHelper;
import org.apache.tika.server.resource.TikaResource;

@Path(value="/detectors")
public class TikaDetectors {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    private HTMLHelper html = new HTMLHelper();

    @GET
    @Produces(value={"text/html"})
    public String getDectorsHTML() {
        StringBuffer h = new StringBuffer();
        this.html.generateHeader(h, "Detectors available to Apache Tika");
        this.detectorAsHTML(TikaResource.getConfig().getDetector(), h, 2);
        this.html.generateFooter(h);
        return h.toString();
    }

    private void detectorAsHTML(Detector d, StringBuffer html, int level) {
        html.append("<h");
        html.append(level);
        html.append(">");
        String name = d.getClass().getName();
        html.append(name.substring(name.lastIndexOf(46) + 1));
        html.append("</h");
        html.append(level);
        html.append(">");
        html.append("<p>Class: ");
        html.append(name);
        html.append("</p>");
        if (d instanceof CompositeDetector) {
            html.append("<p>Composite Detector</p>");
            for (Detector cd : ((CompositeDetector)d).getDetectors()) {
                this.detectorAsHTML(cd, html, level + 1);
            }
        }
    }

    @GET
    @Produces(value={"application/json"})
    public String getDetectorsJSON() {
        HashMap<String, Object> details = new HashMap<String, Object>();
        this.detectorAsMap(TikaResource.getConfig().getDetector(), details);
        return GSON.toJson(details);
    }

    private void detectorAsMap(Detector d, Map<String, Object> details) {
        details.put("name", d.getClass().getName());
        boolean isComposite = d instanceof CompositeDetector;
        details.put("composite", isComposite);
        if (isComposite) {
            ArrayList<HashMap<String, Object>> c = new ArrayList<HashMap<String, Object>>();
            for (Detector cd : ((CompositeDetector)d).getDetectors()) {
                HashMap<String, Object> cdet = new HashMap<String, Object>();
                this.detectorAsMap(cd, cdet);
                c.add(cdet);
            }
            details.put("children", c);
        }
    }

    @GET
    @Produces(value={"text/plain"})
    public String getDetectorsPlain() {
        StringBuffer text = new StringBuffer();
        this.renderDetector(TikaResource.getConfig().getDetector(), text, 0);
        return text.toString();
    }

    private void renderDetector(Detector d, StringBuffer text, int indent) {
        boolean isComposite = d instanceof CompositeDetector;
        String name = d.getClass().getName();
        for (int i = 0; i < indent; ++i) {
            text.append("  ");
        }
        text.append(name);
        if (isComposite) {
            text.append(" (Composite Detector):\n");
            List<Detector> subDetectors = ((CompositeDetector)d).getDetectors();
            for (Detector sd : subDetectors) {
                this.renderDetector(sd, text, indent + 1);
            }
        } else {
            text.append("\n");
        }
    }
}

