# Generated by default/object.tt
package Paws::CodeBuild::BatchRestrictions;
  use Moose;
  has ComputeTypesAllowed => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'computeTypesAllowed', traits => ['NameInRequest']);
  has MaximumBuildsAllowed => (is => 'ro', isa => 'Int', request_name => 'maximumBuildsAllowed', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeBuild::BatchRestrictions

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeBuild::BatchRestrictions object:

  $service_obj->Method(Att1 => { ComputeTypesAllowed => $value, ..., MaximumBuildsAllowed => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeBuild::BatchRestrictions object:

  $result = $service_obj->Method(...);
  $result->Att1->ComputeTypesAllowed

=head1 DESCRIPTION

Specifies restrictions for the batch build.

=head1 ATTRIBUTES


=head2 ComputeTypesAllowed => ArrayRef[Str|Undef]

An array of strings that specify the compute types that are allowed for
the batch build. See Build environment compute types
(https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html)
in the I<CodeBuild User Guide> for these values.


=head2 MaximumBuildsAllowed => Int

Specifies the maximum number of builds allowed.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeBuild>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

