# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::NZ;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20241212130806;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8[1-79]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            50(?:
              [0367]|
              88
            )|
            8|
            90
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2,3})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            24|
            [346]|
            7[2-57-9]|
            9[2-9]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            2(?:
              10|
              74
            )|
            [589]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1|
            2[028]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            2(?:
              [169]|
              7[0-35-9]
            )|
            7
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,5})'
                }
              ];

my $validators = {
                'fixed_line' => '
          240\\d{5}|
          (?:
            3[2-79]|
            [49][2-9]|
            6[235-9]|
            7[2-57-9]
          )\\d{6}
        ',
                'geographic' => '
          240\\d{5}|
          (?:
            3[2-79]|
            [49][2-9]|
            6[235-9]|
            7[2-57-9]
          )\\d{6}
        ',
                'mobile' => '
          2(?:
            [0-27-9]\\d|
            6
          )\\d{6,7}|
          2(?:
            1\\d|
            75
          )\\d{5}
        ',
                'pager' => '',
                'personal_number' => '70\\d{7}',
                'specialrate' => '(
          (?:
            1[13-57-9]\\d{5}|
            50(?:
              0[08]|
              30|
              66|
              77|
              88
            )
          )\\d{3}|
          90\\d{6,8}
        )|(
          8(?:
            1[16-9]|
            22|
            3\\d|
            4[045]|
            5[459]|
            6[235-9]|
            7[0-3579]|
            90
          )\\d{2,7}
        )',
                'toll_free' => '
          508\\d{6,7}|
          80\\d{6,8}
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"6442128", "Paraparaumu",
"6433983", "Ranfurly",
"646365", "Palmerston\ North",
"64732", "Whakatane",
"646955", "Palmerston\ North\/New\ Plymouth",
"6462122", "Palmerston\ North",
"6462166", "Opunake",
"6468819", "Mokau",
"6474442", "Morrinsville",
"6439023", "Te\ Anau",
"6463915", "Opunake",
"6435538", "Lumsden",
"6435505", "Akaroa",
"6479108", "Whakatane",
"6472620", "Tauranga",
"6496994", "Dargaville",
"6496509", "Pukekohe",
"644260", "Wellington",
"647865", "Whangamata",
"6435661", "Fairlie",
"6462137", "Palmerston\ North",
"6479005", "Tauranga",
"6432716", "Darfield",
"6432619", "Christchurch",
"6496996", "Warkworth",
"6449740", "Paraparaumu",
"6432445", "Greymouth",
"646841", "Napier\ City",
"6432714", "Cheviot",
"6434270", "Oamaru",
"6462121", "Palmerston\ North",
"6436500", "Christchurch",
"6432668", "Blenheim",
"6469319", "Masterton",
"6436688", "Waitangi\ \(Chatham\ Is\.\)",
"6474441", "Waihi",
"6462164", "New\ Plymouth",
"647920", "Rotorua",
"6435662", "Geraldine",
"6493938", "Auckland",
"6439048", "Lawrence",
"644818", "Wellington",
"6439538", "Dunedin\/Timaru",
"646960", "Wanganui\/New\ Plymouth",
"6468307", "Napier\/Wairoa",
"643230", "Invercargill",
"6462600", "Palmerston\ North",
"6439729", "Fox\ Glacier",
"6434995", "Te\ Anau",
"6468889", "Levin",
"6478134", "Taumarunui",
"6434244", "Amberley",
"6469025", "Mokau",
"6433913", "Murchison",
"6479297", "Tauranga",
"6475827", "Hamilton",
"6479710", "Putaruru\/Tokoroa",
"6499423", "Great\ Barrier\ Island",
"6434246", "Waitangi\ \(Chatham\ Is\.\)",
"6462220", "New\ Plymouth",
"6447770", "Paraparaumu",
"6474658", "Waihi",
"6478136", "Te\ Awamutu",
"6436579", "Wanaka",
"6436618", "Blenheim",
"646848", "Napier\ City",
"64636", "Levin",
"647325", "Opotiki",
"6472805", "Morrinsville",
"6436650", "Otautau",
"646656", "Levin",
"6475628", "Tauranga",
"6439313", "Te\ Anau",
"6472809", "Otorohanga",
"6469277", "Gisborne",
"643279", "South\ Island",
"6434238", "Waitangi\ \(Chatham\ Is\.\)",
"64757", "Tauranga",
"6474440", "Paeroa",
"6466997", "New\ Plymouth",
"647315", "Opotiki",
"6472622", "Tauranga",
"6436501", "Akaroa",
"6434271", "Balclutha",
"6462120", "Palmerston\ North",
"643338", "Christchurch",
"6439874", "Cromwell",
"6462613", "Waipukurau",
"6493944", "Hibiscus\ Coast",
"6449741", "Paraparaumu",
"6439876", "Roxburgh",
"643413", "Balclutha",
"6435660", "Haast",
"643447", "Alexandra",
"6442420", "Wellington",
"647824", "Hamilton",
"6469029", "Opunake",
"6472621", "Tauranga",
"6436502", "Amberley",
"6436583", "Te\ Anau",
"6473993", "Te\ Awamutu",
"6468885", "New\ Plymouth",
"6434999", "Dunedin",
"6439725", "Christchurch",
"6439067", "Franz\ Josef",
"6434272", "Alexandra",
"6468258", "Waiouru",
"6468993", "Taihape",
"6492006", "Helensville",
"647872", "Te\ Awamutu",
"64329", "South\ Island",
"6436651", "Riverton",
"6465608", "Dannevirke",
"6442608", "Paraparaumu",
"6499467", "Kaitaia",
"6432647", "Fairlie",
"6435544", "Winton",
"647987", "Tauranga",
"6469315", "Taihape",
"643331", "Christchurch",
"6439756", "Akaroa",
"647903", "Hamilton",
"6462602", "Palmerston\ North",
"644212", "Wellington",
"6432449", "Queenstown",
"643740", "Christchurch",
"6437453", "Amberley",
"6462221", "Gisborne",
"649407", "Kaikohe",
"6447771", "Paraparaumu",
"646864", "Ruatoria",
"6432615", "Amberley",
"6479711", "Whangamata",
"6435996", "Akaroa",
"644551", "Paraparaumu",
"6439457", "Winton",
"6479009", "Hamilton",
"6436652", "Winton",
"6462601", "Palmerston\ North",
"6435509", "Culverden",
"6435994", "Ashburton",
"6435546", "Greymouth",
"6439287", "Oamaru",
"64731", "Whakatane\/Opotiki",
"6462222", "Ohakune",
"6468815", "Pahiatua",
"6439754", "Darfield",
"6467778", "Wairoa",
"6469243", "New\ Plymouth",
"6479712", "Te\ Awamutu",
"6466556", "Stratford",
"6432625", "Twizel",
"6499044", "Hibiscus\ Coast",
"64376", "Greymouth",
"6469294", "Palmerston\ North",
"6472603", "Hamilton",
"64349", "South\ Island",
"64452", "Wellington",
"6479849", "Thames",
"6439000", "Christchurch",
"644211", "Wellington",
"6439348", "South\ Island",
"6437476", "Ranfurly",
"643247", "Tokanui\/Lumsden\/Te\ Anau",
"643213", "Invercargill",
"643332", "Christchurch",
"643576", "Nelson",
"6479241", "Whakatane",
"6462819", "Levin",
"6432999", "Invercargill",
"6499479", "Pukekohe",
"6437777", "Christchurch",
"6474637", "Opotiki",
"6468825", "Gisborne",
"6436523", "Hokitika",
"6469288", "Waiouru",
"6499046", "Pukekohe",
"6466003", "Ruatoria",
"6466554", "Hawera",
"643750", "Haast",
"6472223", "Hamilton",
"647878", "Te\ Kuiti",
"6437474", "Oamaru",
"6469296", "Levin",
"6469713", "Stratford",
"64931", "Auckland\/Waiheke\ Island",
"6479242", "Rotorua",
"643457", "Dunedin",
"6466011", "Marton",
"6463991", "Masterton",
"64338", "Christchurch",
"6437440", "Nelson",
"6462623", "Stratford",
"6434404", "Alexandra",
"6492809", "Maungaturoto",
"649554", "Hibiscus\ Coast",
"6472612", "Te\ Awamutu",
"6435557", "Geraldine",
"6436998", "Blenheim",
"6432654", "Blenheim",
"6498017", "Hibiscus\ Coast",
"6439079", "Murchison",
"644889", "Wellington",
"643466", "Dunedin",
"6479500", "Whakatane",
"6432759", "South\ Island",
"6478991", "Whangamata",
"6473944", "Tauranga",
"6439323", "Cheviot",
"6462158", "Opunake",
"6475618", "Opotiki",
"6439278", "Invercargill",
"647871", "Te\ Awamutu",
"6466525", "Marton",
"6432656", "Nelson",
"6496013", "Whangarei",
"6432800", "Te\ Anau",
"6478078", "Whangamata",
"6473946", "Taupo",
"6439747", "Wanaka",
"6463992", "Levin",
"646371", "Masterton\/Dannevirke\/Pahiatua",
"6439715", "Timaru",
"6432733", "Geraldine",
"6495567", "Kaitaia",
"643943", "Christchurch",
"6472611", "Matamata",
"6434406", "Queenstown\/Cromwell\/Alexandra\/Wanaka\/Ranfurly\/Roxburgh",
"6469019", "Pahiatua",
"644897", "Wellington",
"6439853", "Amberley",
"643980", "Christchurch",
"6478992", "Paeroa",
"6436548", "Waimate",
"6477883", "Hamilton",
"6439719", "Waimate",
"6462103", "Levin",
"6435684", "Winton",
"6449", "Wellington",
"6436567", "Ranfurly",
"6499297", "Hibiscus\ Coast",
"6439002", "Rangiora",
"64694", "Masterton\/Levin",
"6439083", "Cheviot",
"6466529", "Pahiatua",
"6472148", "Waihi",
"6439768", "Ranfurly",
"6432755", "Edendale",
"6479240", "Taupo",
"6439075", "Takaka",
"6432813", "Geraldine",
"6435698", "Hokitika",
"643654", "Timaru",
"6434293", "Haast",
"649348", "Auckland",
"6436628", "Ashburton",
"6439001", "Christchurch",
"6492838", "Pukekohe",
"64367", "South\ Island",
"6435686", "Gore",
"647883", "Putaruru\/Tokoroa",
"644245", "Wellington",
"6432726", "Franz\ Josef",
"64932", "Auckland\/Waiheke\ Island",
"649424", "Hibiscus\ Coast",
"6472610", "Morrinsville",
"6472123", "Morrinsville",
"6463925", "Waiouru",
"6439013", "Ashburton",
"6468264", "Palmerston\ North",
"6437442", "Murchison",
"6499878", "Warkworth",
"6433948", "Kaikoura",
"6432801", "Lumsden",
"647533", "Tauranga",
"643527", "Motueka",
"6445", "Wellington\/Hutt\ Valley",
"6439334", "Fox\ Glacier",
"6499475", "Hibiscus\ Coast",
"644586", "Wellington",
"6436643", "Balclutha",
"643430", "Mt\ Cook",
"6434353", "Twizel",
"6478990", "Thames",
"6498857", "Dargaville",
"6462815", "Wairoa",
"646763", "Opunake",
"6432995", "Winton",
"644570", "Wellington",
"6432427", "Greymouth",
"6462418", "Palmerston\ North",
"6479501", "Opotiki",
"6439336", "Cromwell",
"6432802", "Gore",
"6466010", "Taihape",
"6432724", "Greymouth",
"6463990", "Featherston",
"6479845", "Paeroa",
"646842", "Napier\/Hastings",
"6437441", "Motueka",
"6432629", "Roxburgh",
"6499716", "Helensville",
"6442125", "Paraparaumu",
"6467779", "Masterton",
"6499042", "Hibiscus\ Coast",
"64369", "Geraldine",
"6479246", "Thames",
"6469292", "Ruatoria",
"6466551", "New\ Plymouth",
"6435508", "Cheviot",
"6463918", "Wanganui",
"6477887", "Te\ Awamutu",
"6435535", "Invercargill",
"6435680", "Dunedin",
"6442821", "Wellington",
"6462107", "Dannevirke",
"6479008", "Rotorua",
"6437471", "Kurow",
"646949", "Levin\ W100",
"6436563", "Lawrence",
"6499041", "Helensville",
"643336", "Christchurch",
"649427", "Hibiscus\ Coast",
"6493207", "Hibiscus\ Coast",
"6432448", "Dunedin",
"6469291", "Gisborne",
"643524", "Takaka",
"643937", "South\ Island",
"6436685", "Nelson",
"6462425", "Masterton",
"6466552", "New\ Plymouth",
"6432665", "South\ Island",
"6465609", "Pahiatua",
"6432817", "Christchurch",
"6437472", "Lawrence",
"647923", "Whakatane",
"6442609", "Paraparaumu",
"6479244", "Tauranga",
"6434297", "Westport",
"6448880", "Paraparaumu",
"6439045", "Twizel",
"6493935", "Kawakawa",
"6439330", "Westport",
"643657", "Queenstown",
"6439535", "Fairlie",
"646963", "Wanganui\/New\ Plymouth",
"6439267", "Dunedin",
"6478996", "Huntly",
"6468260", "Featherston",
"6472132", "Taupo",
"6434402", "Alexandra",
"6468259", "Levin",
"6432652", "Cromwell",
"643233", "Riverton\/Winton",
"643666", "Christchurch",
"643268", "South\ Island",
"6472614", "Otorohanga",
"6495532", "Warkworth",
"6434998", "Dunedin",
"6466016", "Napier",
"6463996", "Palmerston\ North",
"644590", "Wellington",
"643420", "Christchurch",
"6473337", "Rotorua",
"6472127", "Paeroa",
"6439017", "Cromwell",
"6432887", "Nelson",
"643924", "Christchurch",
"6472616", "Taumarunui",
"643462", "Dunedin\/Palmerston",
"6474655", "Te\ Kuiti",
"6434401", "Cromwell",
"646651", "Napier",
"6436615", "Ashburton",
"6432720", "Nelson",
"6466014", "Napier",
"6463994", "Dannevirke",
"6472131", "Rotorua",
"6434239", "Christchurch",
"6495531", "Helensville",
"6436647", "Te\ Anau",
"6498853", "Whangarei",
"6432651", "Queenstown",
"6432423", "Dunedin",
"6472808", "Putaruru\/Tokoroa",
"6478994", "Tauranga",
"64933", "Auckland",
"6475625", "Rotorua",
"6434235", "Akaroa",
"6435682", "Riverton",
"6469290", "Napier\/Hastings",
"644894", "Wellington",
"649390", "Auckland",
"6474659", "Whangamata",
"6436578", "Wanaka",
"643950", "Dunedin",
"6436619", "Cheviot",
"6439004", "Gore",
"6472607", "Paeroa",
"6499040", "Helensville",
"643410", "Balclutha\/Milton",
"6437470", "Balclutha",
"6439006", "Nelson",
"647217", "Taupo",
"6466007", "Stratford",
"64396", "Christchurch",
"64335", "Christchurch",
"6435681", "Invercargill",
"643454", "Dunedin",
"6442820", "Wellington",
"6466550", "New\ Plymouth",
"6439728", "Franz\ Josef",
"6468888", "Masterton",
"6468255", "Pahiatua",
"6437773", "Dunedin",
"6493939", "Auckland",
"6439049", "Palmerston",
"6436527", "Haast",
"64347", "Dunedin",
"6439539", "Dunedin\/Timaru",
"6465605", "Marton",
"6435553", "Wanaka",
"6432806", "Edendale",
"646846", "Napier\ City",
"6432650", "Christchurch",
"6432669", "Rangiora",
"6439327", "Ashburton",
"6436689", "Christchurch",
"6495530", "Great\ Barrier\ Island",
"6469318", "Levin",
"6432721", "Motueka",
"6472130", "Tauranga",
"6468262", "Napier",
"6437444", "Takaka",
"643743", "Christchurch",
"6462114", "Waipukurau",
"6434400", "Alexandra",
"6432618", "Culverden",
"6439332", "Hokitika",
"6462627", "Wanganui",
"644202", "Wellington",
"6432737", "Palmerston",
"6495563", "Whangarei",
"6437446", "Franz\ Josef",
"643397", "South\ Island",
"6435539", "Otautau",
"6439857", "Akaroa",
"6479109", "Opotiki",
"649957", "Pukekohe",
"6496508", "Hibiscus\ Coast",
"6432804", "Riverton",
"644816", "Wellington",
"6468261", "Masterton",
"6432722", "Murchison",
"6468818", "Opunake",
"6496017", "Great\ Barrier\ Island",
"6467775", "Palmerston\ North",
"6442129", "Paraparaumu",
"64730", "Whakatane",
"6439331", "Greymouth",
"6439743", "Christchurch",
"6462617", "Masterton",
"6432628", "Ranfurly",
"6462124", "Marton",
"6439345", "Christchurch",
"6435666", "Oamaru",
"6439870", "Queenstown",
"6432711", "Akaroa",
"6462419", "Masterton",
"6474444", "Hamilton",
"6439317", "Gore",
"6469273", "New\ Plymouth",
"6496992", "Kawakawa",
"6462161", "Masterton",
"6466993", "Waiouru",
"6439063", "Westport",
"6474446", "Otorohanga",
"6432712", "Amberley",
"6468997", "Napier",
"6499879", "Warkworth",
"6433949", "Rangiora",
"6469285", "Hawera",
"6494313", "Warkworth",
"64930", "Auckland",
"6496991", "Kaikohe",
"6472457", "Rotorua",
"643753", "Hokitika",
"6435664", "Timaru",
"6436587", "Gore",
"6462162", "Masterton",
"6473997", "Te\ Kuiti",
"649404", "Kawakawa",
"6462126", "Pahiatua",
"6437457", "Darfield",
"64334", "Christchurch",
"6436629", "Christchurch",
"643444", "Ranfurly",
"647827", "Hamilton",
"6492839", "Whangarei",
"6479040", "Otorohanga",
"6436995", "Westport",
"6435699", "Amberley",
"6499463", "Whangarei",
"6432643", "Haast",
"6478083", "Hamilton",
"6478132", "Paeroa",
"6439275", "Nelson",
"646327", "Marton",
"6435540", "Edendale",
"6462155", "Hawera",
"6475615", "Waihi",
"6434242", "Darfield",
"647390", "Hamilton",
"6439750", "Kaikoura",
"6466528", "Dannevirke",
"6436517", "Motueka",
"6439283", "Rangiora",
"6439769", "Roxburgh",
"6472149", "Whangamata",
"6478075", "Te\ Kuiti",
"6469247", "Wanganui",
"6492227", "Whangarei",
"6499733", "Warkworth",
"6435990", "Hokitika",
"6439718", "Mt\ Cook",
"6439453", "Te\ Anau",
"647557", "Tauranga",
"643940", "Christchurch",
"6434241", "Rangiora",
"643983", "Christchurch",
"6478131", "Otorohanga",
"6434276", "Palmerston",
"6439027", "Winton",
"6424", "Scott\ Base",
"6436549", "Mt\ Cook",
"6472624", "Whakatane",
"6496990", "Kaitaia",
"647876", "Te\ Kuiti",
"6473935", "Rotorua",
"6478079", "Hamilton",
"6439872", "Alexandra",
"6475958", "Taupo",
"6493942", "Great\ Barrier\ Island",
"6433987", "Cromwell",
"64698", "Gisborne",
"6472145", "Huntly",
"646376", "Pahiatua",
"6439765", "Milton",
"6436506", "Darfield",
"6463943", "Masterton",
"64683", "Napier\/Hastings",
"6462160", "Masterton",
"6432758", "Otautau",
"6462159", "Mokau",
"6475619", "Hamilton",
"6439279", "Christchurch",
"6435695", "Fox\ Glacier",
"6496100", "Pukekohe",
"6436504", "Cheviot",
"6436999", "Nelson",
"6439078", "Ashburton",
"64733", "Rotorua\/Taupo",
"6439871", "Queenstown",
"6432710", "Christchurch",
"6436625", "Rangiora",
"6434274", "Kurow",
"6492835", "Kaikohe",
"6492808", "Great\ Barrier\ Island",
"643461", "Dunedin\/Palmerston",
"6472626", "Rotorua",
"647880", "Matamata",
"6478130", "Morrinsville",
"6434240", "Ashburton",
"6462226", "Napier",
"6435542", "Riverton",
"6435991", "Franz\ Josef",
"6463928", "Pahiatua",
"6479716", "Waihi",
"6462604", "Ohakune",
"6433917", "Franz\ Josef",
"6479293", "Hamilton",
"6433945", "Cheviot",
"6499875", "Dargaville",
"6436656", "Hokitika",
"6499008", "Pukekohe",
"644905", "Paraparaumu",
"64675", "New\ Plymouth",
"6469289", "Taihape",
"6439751", "Culverden",
"6499478", "Pukekohe",
"6499726", "Kawakawa",
"6435541", "Te\ Anau",
"643468", "Dunedin",
"6462818", "New\ Plymouth",
"6432998", "Tokanui",
"6436654", "Tokanui",
"646760", "New\ Plymouth\/Opunake\/Stratford",
"6435992", "Fox\ Glacier",
"647869", "Thames",
"6475823", "Hamilton",
"6462224", "Masterton",
"643571", "Nelson",
"6479848", "Te\ Kuiti",
"6439349", "South\ Island",
"6462606", "Waiouru",
"6479714", "Huntly",
"643978", "Christchurch",
"6439752", "Cheviot",
"646959", "Palmerston\ North\/New\ Plymouth",
"6432743", "Kurow",
"6498883", "Whangarei",
"6499457", "Kaitaia",
"6442198", "Paraparaumu",
"643944", "Christchurch",
"6439722", "Blenheim",
"6468803", "Gisborne",
"6477777", "Hamilton",
"6468882", "Napier\/Hastings",
"6472146", "Otorohanga",
"6435694", "Franz\ Josef",
"6439766", "Balclutha",
"6436505", "Culverden",
"6492834", "Kawakawa",
"6434275", "Milton",
"6496513", "Whangarei",
"6432440", "Christchurch",
"6437463", "Mt\ Cook",
"6436624", "Darfield",
"6439093", "Ashburton",
"6432223", "Akaroa",
"64423", "Wellington",
"6439737", "Tokanui",
"644902", "Paraparaumu",
"6436626", "Akaroa",
"6479000", "Hamilton",
"6492836", "Kaitaia",
"6472625", "Opotiki",
"6435688", "Queenstown",
"6473934", "Rotorua",
"6468881", "Napier\/Hastings",
"6435500", "Christchurch",
"649349", "Auckland",
"6434283", "Cromwell",
"6439721", "Blenheim",
"646832", "Napier\/Wairoa",
"6475607", "Morrinsville",
"6469303", "Waipukurau",
"643483", "Dunedin\/Lawrence\/Mosgiel",
"6472144", "Matamata",
"6435696", "Haast",
"6439764", "Lawrence",
"647332", "Rotorua",
"647213", "Hamilton",
"6499876", "Kaikohe",
"6436655", "Westport",
"6433946", "Culverden",
"6479747", "Te\ Kuiti",
"64480", "Wellington",
"6472800", "Thames",
"6474449", "Opotiki",
"6462414", "Napier",
"6469311", "Palmerston\ North",
"6499725", "Hibiscus\ Coast",
"649400", "Kaikohe",
"6499067", "Pukekohe",
"6468812", "Waiouru",
"6432728", "Haast",
"6462225", "Levin",
"6462129", "Waiouru",
"6479853", "Putaruru",
"647980", "Hamilton",
"6432611", "Kaikoura",
"6479715", "Paeroa",
"643214", "Invercargill",
"6435650", "Greymouth",
"6442429", "Paraparaumu",
"6469020", "Stratford",
"64738", "Taupo",
"6435669", "Wanaka",
"6462605", "Marton",
"643250", "Christchurch",
"6434990", "Queenstown",
"6469312", "Ohakune",
"6498691", "Maungaturoto",
"6465627", "Levin",
"643393", "Christchurch",
"6439057", "Waimate",
"6499874", "Kawakawa",
"6468811", "Marton",
"6433944", "Ashburton",
"6468268", "New\ Plymouth",
"647466", "Tauranga",
"6462416", "Waipukurau",
"6432612", "Rangiora",
"6439338", "Queenstown",
"64789", "Taumarunui",
"6472813", "Waihi",
"6468247", "Mokau",
"6469284", "Stratford",
"6432442", "Christchurch",
"6436633", "Geraldine",
"6468880", "Napier\/Hastings",
"6463911", "New\ Plymouth",
"6435501", "Christchurch",
"6462609", "Pahiatua",
"6469573", "Palmerston\ North",
"6466558", "Opunake",
"6439720", "Blenheim",
"646764", "Stratford",
"643224", "Invercargill",
"6439346", "Christchurch",
"6435665", "Waimate",
"6437478", "Twizel",
"6479001", "Hamilton",
"6439887", "Christchurch\/Blenheim\/Nelson",
"647927", "Tauranga",
"6444888", "Paraparaumu",
"6499048", "Pukekohe",
"6479719", "Te\ Kuiti",
"6432441", "Christchurch",
"6439344", "Timaru",
"6473923", "Otorohanga",
"6462125", "Taihape",
"6469298", "Masterton",
"6435502", "Christchurch",
"6463912", "New\ Plymouth",
"6474445", "Hamilton",
"647879", "Te\ Awamutu\/Otorohanga\/Te\ Kuiti",
"6479002", "Matamata",
"6436659", "Haast",
"649423", "Warkworth",
"6469286", "Dannevirke",
"6436996", "Takaka",
"6472427", "Rotorua",
"647884", "Morrinsville",
"6468810", "Ohakune",
"646956", "Palmerston\ North\/New\ Plymouth",
"643237", "Riverton\/Winton",
"6435887", "Invercargill",
"6478074", "Taumarunui",
"6462156", "Hawera",
"6475616", "Whangamata",
"6439276", "Nelson",
"6498690", "Kawakawa",
"644888", "Wellington",
"6472629", "Taupo",
"6434991", "Cromwell",
"6479230", "Opotiki",
"644219", "Wellington",
"647866", "Thames",
"646967", "New\ Plymouth",
"6472802", "Paeroa",
"643653", "Blenheim",
"6432610", "Darfield",
"6434279", "Twizel",
"6434408", "Queenstown\/Cromwell\/Alexandra\/Wanaka\/Ranfurly\/Roxburgh",
"6436546", "Fairlie",
"6463903", "Ruatoria",
"6435513", "Waitangi\ \(Chatham\ Is\.\)",
"6469310", "Wanganui",
"6434992", "Ranfurly",
"6436994", "Murchison",
"6432658", "Murchison",
"6436509", "Waitangi\ \(Chatham\ Is\.\)",
"646590", "Palmerston\ North",
"6478076", "Te\ Awamutu",
"6462154", "New\ Plymouth",
"6475614", "Thames",
"6472801", "Huntly",
"6469022", "Hawera",
"6439274", "Queenstown",
"6473948", "Opotiki",
"6432752", "Te\ Anau",
"643278", "South\ Island",
"6469850", "Napier",
"6492427", "Warkworth",
"6434267", "Ranfurly",
"6469869", "Ruatoria",
"64483", "Wellington",
"6439072", "Ashburton",
"6468254", "Ohakune",
"6475626", "Taupo",
"643339", "Christchurch",
"643920", "Rangiora",
"6468820", "Palmerston\ North",
"6462803", "Palmerston\ North",
"6434236", "Amberley",
"6432751", "Riverton",
"6478999", "Hamilton",
"64332", "Christchurch",
"6468256", "Palmerston\ North",
"6469012", "Waiouru",
"6475624", "Rotorua",
"6439071", "Motueka",
"6478144", "Tauranga",
"6436593", "Nelson",
"646946", "Masterton",
"644205", "Wellington",
"6434234", "Darfield",
"6499013", "Kawakawa",
"6492008", "Hibiscus\ Coast",
"6437487", "Winton",
"643680", "Fairlie",
"6439005", "Invercargill",
"6439878", "Christchurch\/Blenheim\/Nelson",
"6466019", "Napier",
"6463999", "Palmerston\ North",
"6432620", "Palmerston",
"6432992", "Gore",
"6462812", "Napier\/Hastings",
"643520", "Blenheim",
"6478097", "Whakatane",
"6439710", "Timaru",
"6463921", "Palmerston\ North",
"6435998", "Rangiora",
"6479842", "Matamata",
"6465606", "Waiouru",
"6432805", "Winton",
"6472823", "Whakatane",
"6467774", "Dannevirke",
"6499471", "Hibiscus\ Coast",
"6466520", "Palmerston\ North",
"6439758", "Ashburton",
"6496009", "Pukekohe",
"6479249", "Huntly",
"6435548", "Westport",
"643669", "Christchurch",
"6439523", "Balclutha",
"6462811", "New\ Plymouth",
"6432991", "Milton",
"6465604", "Ohakune",
"6467776", "Levin",
"6463922", "Palmerston\ North",
"6499719", "Whangarei",
"6462115", "Wairoa",
"644577", "Wellington",
"6439297", "Takaka",
"6479841", "Huntly",
"6437445", "Fox\ Glacier",
"6499472", "Great\ Barrier\ Island",
"6469003", "Napier\/Hastings",
"6435536", "Invercargill",
"6432621", "Oamaru",
"6498823", "Kaitaia",
"6435677", "Ranfurly",
"6433993", "Te\ Anau",
"643240", "Tokanui\/Lumsden\/Te\ Anau",
"6462119", "Wairoa",
"6439703", "Takaka",
"6468822", "Masterton",
"6432718", "Rangiora",
"6437449", "Hokitika",
"6499747", "Dargaville",
"6436684", "Dunedin",
"6432664", "Christchurch",
"6469852", "Napier",
"6462424", "Wanganui",
"643465", "Palmerston",
"6439070", "Motueka",
"6479245", "Matamata",
"644281", "Wellington",
"6432750", "Invercargill",
"6462168", "Featherston",
"6432622", "Balclutha",
"6436686", "Invercargill",
"64357", "Blenheim",
"6432666", "South\ Island",
"644908", "Paraparaumu",
"6462426", "Levin",
"6434223", "Otautau",
"64938", "Auckland\/Waiheke\ Island",
"6475950", "Hamilton",
"646838", "Wairoa",
"6468821", "Featherston",
"643757", "Hokitika\/Franz\ Josef\ Glacier\/Fox\ Glacier\/Haast",
"6465617", "Mokau",
"6432809", "Hokitika",
"6496998", "Helensville",
"6469851", "Napier",
"6432637", "Winton",
"6435534", "Takaka",
"6439863", "Motueka",
"6469010", "Taihape",
"644819", "Wellington",
"6466522", "Palmerston\ North",
"6497777", "Auckland",
"6466015", "Napier",
"6463995", "Marton",
"6436614", "Timaru",
"6439009", "Greymouth",
"6472193", "Whakatane",
"6474654", "Taumarunui",
"6439046", "Kurow",
"6493936", "Maungaturoto",
"643414", "Balclutha\/Milton",
"6479754", "Tauranga",
"647823", "Hamilton",
"6439712", "Fairlie",
"6439536", "Waimate",
"6478995", "Matamata",
"6462810", "Gisborne",
"6432990", "Lumsden",
"643450", "Queenstown",
"64331", "Rangiora\/Amberley\/Culverden\/Darfield\/Cheviot\/Kaikoura",
"644890", "Wellington",
"649394", "Auckland",
"64379", "South\ Island",
"6499470", "Hibiscus\ Coast",
"6433957", "Palmerston",
"643903", "Christchurch",
"6466521", "Palmerston\ North",
"6439534", "Mt\ Cook",
"643954", "Dunedin\/Timaru",
"6439044", "Milton",
"6499557", "Warkworth",
"6493934", "Kaitaia",
"6439711", "Geraldine",
"6463920", "Palmerston\ North",
"646849", "Napier\ City",
"6472615", "Te\ Kuiti",
"6469468", "Featherston",
"6474656", "Te\ Awamutu",
"6469617", "Wanganui\/New\ Plymouth",
"6434248", "Cheviot",
"6436616", "Geraldine",
"6478138", "Waihi",
"6435563", "Queenstown",
"6475621", "Tauranga",
"646845", "Napier\/Hastings",
"6473949", "Taupo",
"6432754", "Tokanui",
"649397", "Auckland\/Waiheke\ Island",
"6436680", "Akaroa",
"643984", "Blenheim",
"6462420", "Palmerston\ North",
"6434231", "Christchurch",
"6432660", "Christchurch",
"6432659", "Takaka",
"6436508", "Rangiora",
"643957", "Timaru",
"6439074", "Ashburton",
"6478141", "Taupo",
"6469016", "Ohakune",
"6434278", "Roxburgh",
"6434409", "Queenstown\/Cromwell\/Alexandra\/Wanaka\/Ranfurly\/Roxburgh",
"6468252", "Dannevirke",
"6433997", "Gore",
"6435673", "Lawrence",
"6439707", "Takaka",
"6469014", "Dannevirke",
"646951", "Palmerston\ North",
"6475622", "Tauranga",
"6432633", "Otautau",
"6478142", "Whakatane",
"6435685", "Tokanui",
"6439867", "Christchurch\/Blenheim\/Nelson",
"6472628", "Taupo",
"6479100", "Rotorua",
"6434232", "Ashburton",
"6435530", "Nelson",
"644815", "Wellington",
"6432756", "Gore",
"6468251", "Wanganui",
"647861", "Paeroa\/Waihi\/Thames\/Whangamata",
"643480", "Dunedin\/Lawrence\/Mosgiel",
"6434227", "Riverton",
"6439076", "Ashburton",
"643443", "Wanaka",
"643417", "Milton",
"647210", "Hamilton",
"6465613", "Wairoa",
"64399", "South\ Island",
"6465601", "Palmerston\ North",
"6499006", "Whangarei",
"6462814", "Hawera",
"6432994", "Otautau",
"6436658", "Fox\ Glacier",
"643754", "Hokitika\/Franz\ Josef\ Glacier\/Fox\ Glacier\/Haast",
"64935", "Auckland",
"6499728", "Dargaville",
"6479750", "Tauranga",
"649403", "Kawakawa",
"6436610", "Kaikoura",
"6479844", "Otorohanga",
"64377", "South\ Island",
"6432725", "Hokitika",
"6474650", "Morrinsville",
"6497773", "Dargaville",
"6462228", "Wanganui",
"647983", "Hamilton",
"6469299", "Napier\/Hastings",
"6444889", "Paraparaumu",
"6472197", "Tauranga",
"6499049", "Great\ Barrier\ Island",
"64947", "Auckland",
"6467772", "Hawera",
"6479718", "Taumarunui",
"6463926", "Taihape",
"644619", "Wellington",
"643469", "Dunedin",
"6479846", "Taumarunui",
"6437479", "Edendale",
"6465602", "Palmerston\ North",
"644886", "Wellington",
"643595", "Christchurch",
"6469613", "Levin",
"6466559", "Mokau",
"64734", "Rotorua",
"6463924", "Marton",
"6462608", "Dannevirke",
"647868", "Thames",
"6467529", "Mokau",
"6433953", "Geraldine",
"643390", "Christchurch",
"6499553", "Kaikohe",
"6432996", "Riverton",
"6499004", "Hibiscus\ Coast",
"6462816", "Gisborne",
"643979", "Christchurch",
"6467771", "New\ Plymouth",
"6439530", "Timaru",
"6499474", "Helensville",
"6439040", "Balclutha",
"646958", "Palmerston\ North\/New\ Plymouth",
"6439335", "Haast",
"6493930", "Whangarei",
"6439339", "South\ Island",
"644777", "Wellington",
"6468250", "Stratford",
"6467525", "Mokau",
"6462807", "Napier\/Hastings",
"6468269", "New\ Plymouth",
"6468824", "Wanganui",
"6479101", "Rotorua",
"6466555", "Hawera",
"6432662", "Christchurch",
"6462422", "Napier\/Hastings",
"6469854", "Waipukurau",
"6436682", "Dunedin",
"6435531", "Nelson",
"6432626", "Kurow",
"6434263", "Lawrence",
"6435668", "Kurow",
"6437475", "Palmerston",
"6499045", "Hibiscus\ Coast",
"6432624", "Milton",
"6435527", "Alexandra",
"6437483", "Otautau",
"6432729", "Westport",
"6469295", "Wanganui",
"6462128", "Ohakune",
"6479027", "Paeroa",
"643930", "Christchurch",
"6478140", "Rotorua",
"6474448", "Taumarunui",
"6436681", "Dunedin",
"6435532", "Motueka",
"6462421", "New\ Plymouth",
"6479102", "Rotorua",
"6434230", "Christchurch",
"6432661", "Christchurch",
"6436597", "Cromwell",
"6468826", "Levin",
"649420", "Helensville",
"6475620", "Tauranga",
"6499017", "Kaikohe",
"6439041", "Ashburton",
"6493931", "Whangarei",
"6444", "Wellington",
"647220", "Tauranga",
"6467770", "Gisborne",
"6466524", "Ohakune",
"6439531", "Timaru",
"6472827", "Tauranga",
"6436612", "Akaroa",
"6474652", "Paeroa",
"6435689", "Otautau",
"6439714", "Waimate",
"6478093", "Rotorua",
"6479752", "Rotorua",
"644209", "Wellington",
"6439716", "Geraldine",
"6439532", "Timaru",
"643335", "Christchurch",
"6439293", "Blenheim",
"6493932", "Dargaville",
"6439042", "Oamaru",
"6467556", "New\ Plymouth\/Mokau",
"6474651", "Otorohanga",
"6434405", "Alexandra",
"644589", "Wellington",
"6436611", "Rangiora",
"6469007", "Masterton",
"6479751", "Tauranga",
"644555", "Wellington",
"6466526", "Waiouru",
"6439527", "Kurow",
"6432655", "Nelson",
"6442199", "Paraparaumu",
"6473945", "Tauranga",
"6465600", "Palmerston\ North",
"6436637", "Twizel",
"6434249", "Kaikoura",
"6469577", "Ohakune",
"6436576", "Cromwell",
"6478139", "Whangamata",
"6468884", "Palmerston\ North",
"6439724", "Blenheim",
"6473931", "Whangamata",
"6439883", "Hokitika",
"6435692", "Takaka",
"6469280", "Waipukurau",
"644906", "Paraparaumu",
"6492832", "Dargaville",
"6436622", "Cheviot",
"6472817", "Taupo",
"6468243", "Napier",
"643923", "Nelson",
"6472141", "Te\ Kuiti",
"6439761", "Kurow",
"64637", "Masterton",
"647887", "Morrinsville",
"643234", "Riverton",
"6435691", "Murchison",
"6473932", "Rotorua",
"6439340", "Mt\ Cook",
"6439008", "Timaru",
"646387", "Waiouru",
"6439875", "Ranfurly",
"6436621", "Culverden",
"646964", "Wanganui",
"6492831", "Maungaturoto",
"6472142", "Te\ Awamutu",
"6439762", "Oamaru",
"6468886", "Wanganui",
"6473927", "Te\ Kuiti",
"6439726", "Timaru",
"643523", "Murchison",
"6432616", "Ashburton",
"647462", "Taupo",
"6435995", "Darfield",
"647875", "Te\ Awamutu\/Otorohanga\/Te\ Kuiti",
"6462412", "Gisborne",
"6468814", "Dannevirke",
"6433941", "Blenheim",
"6478070", "Morrinsville",
"6432808", "Westport",
"6435883", "Dunedin",
"6443990", "Paraparaumu",
"646375", "Pahiatua",
"6499101", "Pukekohe",
"6469316", "Dannevirke",
"6439755", "Rangiora",
"6435545", "Gore",
"6439270", "Greymouth",
"6475610", "Putaruru\/Tokoroa",
"6462150", "New\ Plymouth",
"6468816", "Hawera",
"6462169", "Featherston",
"6469314", "Waiouru",
"6462411", "New\ Plymouth",
"6479045", "Taumarunui",
"6436990", "Cheviot",
"6462118", "Waipukurau",
"6437448", "Haast",
"6432719", "Waitangi\ \(Chatham\ Is\.\)",
"6433942", "Akaroa",
"647312", "Whakatane",
"646767", "New\ Plymouth\/Opunake\/Stratford",
"6463907", "Waipukurau",
"6432614", "South\ Island",
"6435517", "Lawrence",
"6463916", "Mokau",
"6435506", "Amberley",
"6496517", "Kaitaia",
"6437467", "Queenstown",
"6439097", "Darfield",
"643217", "Invercargill",
"6469203", "New\ Plymouth",
"64796", "Hamilton",
"64735", "Rotorua",
"643243", "Tokanui\/Lumsden\/Te\ Anau",
"6469282", "Mokau",
"6432227", "Queenstown",
"6439341", "Fairlie",
"6439733", "Te\ Anau",
"6432444", "Nelson",
"6432715", "Culverden",
"6436620", "Kaikoura",
"6432747", "Queenstown",
"6499718", "Whangarei",
"6435690", "Motueka",
"6499453", "Warkworth",
"6479049", "Te\ Kuiti",
"6496008", "Hibiscus\ Coast",
"649907", "Warkworth",
"64685", "Waipukurau",
"6468807", "Gisborne",
"6477773", "Taupo",
"6435549", "Hokitika",
"6479248", "Rotorua\/Whakatane\/Tauranga",
"6462165", "Stratford",
"6472140", "Putaruru\/Tokoroa",
"6439760", "Twizel",
"6475603", "Hamilton",
"6469307", "Stratford",
"646211", "Napier",
"6439759", "Cromwell",
"64934", "Auckland\/Waiheke\ Island",
"6439342", "Geraldine",
"646860", "Gisborne\/Ruatoria",
"6469281", "Wairoa",
"6496995", "Maungaturoto",
"6473930", "Waihi",
"643276", "South\ Island",
"6463914", "Stratford",
"6435504", "Christchurch",
"6432607", "Dunedin",
"6435999", "Christchurch",
"6432446", "Blenheim",
"6479004", "Te\ Awamutu",
"6434287", "Queenstown",
"6499063", "Hibiscus\ Coast",
"6434996", "Roxburgh",
"646320", "Palmerston\ North\/Marton",
"6479857", "Opotiki",
"6498817", "Hibiscus\ Coast",
"6439879", "Christchurch\/Blenheim\/Nelson",
"6463998", "Palmerston\ North",
"6466018", "Napier",
"6478072", "Paeroa",
"64330", "Ashburton\/Akaroa\/Chatham\ Islands",
"6436991", "Culverden",
"643269", "South\ Island",
"6462410", "New\ Plymouth",
"6492009", "Pukekohe",
"647820", "Hamilton\/Huntly",
"6478998", "Hamilton",
"643453", "Dunedin",
"6439271", "Westport",
"6472804", "Whangamata",
"6462151", "New\ Plymouth",
"6475611", "Taumarunui",
"644893", "Wellington",
"6499100", "Pukekohe",
"6465623", "Opunake",
"6472806", "Matamata",
"6478071", "Otorohanga",
"647862", "Paeroa",
"6433940", "Westport",
"643947", "Invercargill",
"6434994", "Palmerston",
"6436992", "Greymouth",
"6434245", "Culverden",
"6475612", "Te\ Kuiti",
"646952", "Palmerston\ North\ W100",
"6462152", "New\ Plymouth",
"6439272", "Timaru",
"6478135", "Te\ Kuiti",
"644210", "Wellington",
"6439010", "Queenstown",
"6432731", "Timaru",
"6472120", "Putaruru\/Tokoroa",
"643742", "Dunedin",
"6472613", "Putaruru\/Tokoroa",
"646766", "New\ Plymouth",
"6439851", "Culverden",
"6439322", "Culverden",
"643226", "Otautau",
"644203", "Wellington",
"6462809", "Napier\/Hastings",
"6493991", "Pukekohe",
"6498856", "Maungaturoto",
"6432426", "Blenheim",
"6449030", "Paraparaumu",
"6439337", "Wanaka",
"6498854", "Hibiscus\ Coast",
"6479748", "Taumarunui",
"6436599", "Blenheim",
"6432732", "Fairlie",
"6499019", "Maungaturoto",
"6478993", "Waihi",
"6434350", "Twizel",
"6436640", "Palmerston",
"6439321", "Amberley",
"6439852", "Cheviot",
"6432424", "Nelson",
"6432727", "Fox\ Glacier",
"6499068", "Pukekohe",
"6496012", "Kawakawa",
"649451", "Auckland",
"6479029", "Waihi",
"6462621", "New\ Plymouth",
"6472195", "Rotorua",
"643751", "Fox\ Glacier",
"6435529", "Roxburgh",
"6474648", "Huntly",
"6466013", "Featherston",
"6463993", "Pahiatua",
"6462100", "Levin",
"6472221", "Tauranga",
"6466001", "Napier",
"6439865", "Murchison",
"647864", "Thames",
"6436564", "Milton",
"6435687", "Lumsden",
"64697", "Napier",
"6469711", "New\ Plymouth",
"6477880", "Hamilton",
"6475608", "Otorohanga",
"6472829", "Tauranga",
"646954", "Palmerston\ North\ W100",
"647886", "Putaruru\/Tokoroa",
"6434225", "Edendale",
"646903", "Palmerston\ North",
"6472602", "Hamilton",
"6436521", "Greymouth",
"6466002", "Napier",
"643758", "Hokitika\/Franz\ Josef\ Glacier\/Fox\ Glacier\/Haast",
"6499296", "Kaitaia",
"6434290", "Greymouth",
"64364", "South\ Island",
"6472222", "Hamilton",
"6499458", "Kawakawa",
"6479420", "Tauranga",
"6442197", "Paraparaumu",
"646837", "Wairoa",
"6432810", "Franz\ Josef",
"6477778", "Te\ Awamutu",
"6479243", "Rotorua\/Whakatane\/Tauranga",
"6469712", "New\ Plymouth",
"649458", "Dargaville",
"6439529", "Palmerston",
"647870", "Te\ Awamutu",
"6433995", "Tokanui",
"643981", "Christchurch",
"6469009", "Palmerston\ North",
"6498825", "Maungaturoto",
"6472601", "Hamilton",
"6436522", "Greymouth",
"6439738", "Winton",
"6436566", "Kurow",
"6439705", "Motueka",
"6495566", "Kaikohe",
"643232", "Riverton\/Winton",
"647989", "Taupo",
"6492", "Auckland",
"6439709", "Motueka",
"6462620", "New\ Plymouth",
"6437443", "Nelson",
"6434407", "Queenstown\/Cromwell\/Alexandra\/Wanaka\/Ranfurly\/Roxburgh",
"6469005", "Wanganui",
"6433999", "Otautau",
"6434351", "Mt\ Cook",
"6436641", "Lawrence",
"6439320", "Akaroa",
"6432657", "Motueka",
"6435554", "Cromwell",
"6439525", "Milton",
"646962", "Wanganui\/New\ Plymouth",
"643946", "Invercargill",
"6473332", "Rotorua",
"649409", "Kaitaia",
"64632", "Palmerston\ North",
"6472122", "Te\ Awamutu",
"6439012", "Queenstown",
"6439746", "Dunedin",
"6473947", "Whakatane",
"6435556", "Fairlie",
"6434229", "Winton",
"6498016", "Hibiscus\ Coast",
"6449031", "Paraparaumu",
"6472428", "Taupo",
"6432803", "Otautau",
"6439744", "Queenstown",
"6496010", "Kaitaia",
"6493990", "Great\ Barrier\ Island",
"6435888", "Timaru",
"6439869", "Blenheim",
"6439850", "Ashburton",
"6495564", "Whangarei",
"643438", "Kurow",
"6436642", "Milton",
"643463", "Palmerston",
"6432730", "Blenheim",
"6439011", "Queenstown",
"6473331", "Rotorua",
"6472121", "Te\ Kuiti",
"6444887", "Paraparaumu",
"643905", "Ashburton",
"6439003", "Ashburton",
"6499047", "Pukekohe",
"6472199", "Opotiki",
"6439082", "Culverden",
"6472600", "Hamilton",
"643277", "South\ Island",
"6479025", "Huntly",
"6469297", "Masterton",
"6437776", "Cromwell",
"647589", "Hamilton",
"6477882", "Hamilton",
"6479421", "Tauranga",
"6462102", "Levin",
"6436595", "Mt\ Cook",
"6432811", "Fox\ Glacier",
"64328", "South\ Island",
"6499015", "Dargaville",
"6434291", "Westport",
"6437774", "Queenstown",
"6436520", "Greymouth",
"64795", "Hamilton",
"64736", "Rotorua",
"6468248", "New\ Plymouth",
"644571", "Wellington",
"6462805", "Napier\/Hastings",
"647464", "Hamilton",
"647922", "Whakatane",
"643449", "Alexandra",
"6469710", "New\ Plymouth",
"647974", "Hamilton",
"643216", "Invercargill",
"6477881", "Hamilton",
"6466557", "Stratford",
"64686", "Gisborne",
"647825", "Hamilton",
"6472220", "Tauranga",
"6434292", "Hokitika",
"6466000", "Napier",
"6432812", "Haast",
"6437477", "Roxburgh",
"6462101", "Levin",
"6439888", "Christchurch\/Blenheim\/Nelson",
"6479422", "Tauranga",
"6478084", "Hamilton",
"6468809", "Masterton",
"6439286", "Cromwell",
"649470", "Whangarei",
"6499464", "Whangarei",
"6435547", "Blenheim",
"6432644", "Westport",
"643238", "Riverton\/Winton",
"6432749", "Wanaka",
"6433912", "Motueka",
"643459", "Dunedin\/Queenstown",
"646968", "New\ Plymouth\ W100",
"644810", "Wellington",
"6439298", "Motueka",
"6432229", "Dunedin",
"64371", "South\ Island",
"6499421", "Hibiscus\ Coast",
"643485", "Lawrence",
"6439456", "Riverton",
"6496519", "Maungaturoto",
"6437450", "Westport",
"6437469", "Alexandra",
"647215", "Rotorua",
"6435515", "Oamaru",
"64941", "Auckland",
"6463905", "Napier",
"644887", "Wellington",
"6439099", "Kaikoura",
"6439454", "Lumsden",
"646840", "Napier\ City",
"6434289", "Wanaka",
"64936", "Auckland",
"6433911", "Nelson",
"6432609", "Mt\ Cook",
"6435997", "Amberley",
"6499422", "Helensville",
"6469240", "Gisborne",
"6478086", "Hamilton",
"647921", "Rotorua",
"6439284", "Blenheim",
"6499466", "Kaikohe",
"6432646", "Timaru",
"644572", "Wellington",
"6469309", "Mokau",
"6439757", "Waitangi\ \(Chatham\ Is\.\)",
"6439066", "Hokitika",
"643416", "Balclutha\/Milton",
"644666", "Wellington",
"6474443", "Matamata",
"6469274", "New\ Plymouth",
"6439022", "Ashburton",
"6466509", "Napier\/Waipukurau",
"6466994", "Ohakune",
"643590", "Christchurch",
"6439310", "Invercargill",
"6492007", "Warkworth",
"6437488", "South\ Island",
"6439877", "Christchurch\/Blenheim\/Nelson",
"64754", "Tauranga",
"6433982", "Kurow",
"6462610", "Napier",
"643249", "Te\ Anau",
"6462123", "Palmerston\ North",
"6473925", "Putaruru\/Tokoroa",
"643231", "Invercargill",
"6479859", "Tauranga",
"6469575", "Waiouru",
"6439021", "Ashburton",
"646653", "Wanganui",
"6436635", "Fairlie",
"6473990", "Te\ Awamutu",
"6436580", "Invercargill",
"6492428", "Hibiscus\ Coast",
"64348", "Dunedin",
"6434268", "Roxburgh",
"647928", "Tauranga",
"6435663", "Twizel",
"649396", "Auckland\/Waiheke\ Island",
"6469276", "Wanganui",
"6439064", "Ashburton",
"6433981", "Twizel",
"6468990", "Ruatoria",
"643956", "Timaru",
"6472815", "Whakatane",
"6494314", "Warkworth",
"6466996", "Stratford",
"6437452", "Akaroa",
"6433958", "Oamaru",
"6499558", "Great\ Barrier\ Island",
"6469241", "Napier",
"6468304", "Napier\/Wairoa",
"643935", "South\ Island",
"6472819", "Rotorua",
"6498", "Auckland",
"6433910", "Nelson",
"6475826", "Hamilton",
"643529", "Nelson",
"649425", "Warkworth",
"6436639", "Oamaru",
"6479294", "Hamilton",
"6434247", "Kaikoura",
"6469618", "Wanganui\/New\ Plymouth",
"6462603", "Palmerston\ North",
"6469579", "Pahiatua",
"6478137", "Thames",
"6479855", "Taupo",
"6473929", "Thames",
"6497778", "Pukekohe",
"6475824", "Hamilton",
"6462223", "Palmerston\ North",
"6437451", "Blenheim",
"6499420", "Pukekohe",
"6498815", "Helensville",
"643982", "Christchurch",
"6479296", "Tauranga",
"6479713", "Morrinsville",
"6469242", "Levin",
"643660", "Christchurch",
"6436653", "Edendale",
"6468306", "Napier\/Wairoa",
"6469305", "New\ Plymouth",
"6433980", "Milton",
"6468991", "Gisborne",
"6463944", "Featherston",
"6465618", "Masterton",
"644550", "Wellington",
"6496997", "Hibiscus\ Coast",
"649439", "Dargaville",
"6439312", "Riverton",
"6432638", "Tokanui",
"6473991", "Whakatane",
"6436581", "Invercargill",
"6472623", "Tauranga",
"643741", "Christchurch",
"646214", "Gisborne",
"6434285", "Cheviot",
"6439020", "Gore",
"6496515", "Dargaville",
"64456", "Wellington",
"6434273", "Lawrence",
"643689", "Waimate",
"6439095", "Ashburton",
"6435519", "Twizel",
"643752", "Franz\ Josef",
"6437465", "Waimate",
"6462611", "Napier",
"6435678", "Roxburgh",
"6432225", "Greymouth",
"64372", "South\ Island",
"6479019", "Whangamata",
"649452", "Auckland",
"6432717", "Kaikoura",
"6468992", "Wairoa",
"6499748", "Whangarei",
"6439311", "Invercargill",
"6432745", "Roxburgh",
"6468805", "Wanganui",
"643655", "Dunedin",
"6436503", "Ashburton",
"6462167", "Mokau",
"6436582", "Riverton",
"6473992", "Opotiki",
"6479290", "Hamilton",
"6499462", "Whangarei",
"643436", "Kurow",
"644213", "Wellington",
"6432642", "Fox\ Glacier",
"6478082", "Tauranga",
"6439889", "Christchurch\/Blenheim\/Nelson",
"6439451", "Invercargill",
"6433914", "Takaka",
"6434243", "Akaroa",
"6462607", "Taihape",
"644576", "Wellington",
"6478133", "Putaruru\/Tokoroa",
"6439281", "Christchurch",
"643685", "Fairlie",
"6439055", "Fairlie",
"643552", "Dunedin",
"6465625", "Gisborne",
"643211", "Invercargill",
"6468249", "Opunake",
"6439452", "Gore",
"643948", "Invercargill",
"6436657", "Franz\ Josef",
"6478081", "Rotorua",
"6432641", "Franz\ Josef",
"6499461", "Whangarei",
"643539", "Nelson",
"6499727", "Whangarei",
"6499065", "Helensville",
"6496", "Auckland",
"643925", "Christchurch",
"6439282", "Christchurch",
"6462227", "Napier",
"6472198", "Opotiki",
"6433916", "Hokitika",
"6475820", "Hamilton",
"6479717", "Otorohanga",
"6496993", "Whangarei",
"649392", "Auckland",
"643218", "Invercargill",
"6439024", "Lumsden",
"6469272", "Featherston",
"6466992", "Hawera",
"6439868", "Blenheim",
"6472627", "Rotorua",
"6463940", "Levin",
"647391", "Hamilton",
"6433984", "Roxburgh",
"6439061", "Greymouth",
"64373", "Greymouth",
"6475605", "Huntly",
"6435889", "Timaru",
"6434228", "Tokanui",
"64943", "Whangarei",
"6472429", "Whakatane",
"6469271", "Pahiatua",
"643525", "Takaka",
"6433986", "Queenstown",
"6499455", "Dargaville",
"6477775", "Huntly",
"6436507", "Kaikoura",
"6466991", "Wanganui",
"649429", "Great\ Barrier\ Island",
"64368", "Timaru",
"64630", "Featherston",
"647873", "Otorohanga",
"6462163", "New\ Plymouth",
"6472116", "Thames",
"643412", "Balclutha",
"6434277", "Ranfurly",
"6439026", "Riverton",
"6439062", "Ashburton",
"6433998", "Lumsden",
"643939", "South\ Island",
"6499810", "Hibiscus\ Coast",
"643941", "Christchurch",
"6494312", "Warkworth",
"6439708", "Murchison",
"6432713", "Ashburton",
"6439735", "Lumsden",
"6437454", "Ashburton",
"6475821", "Hamilton",
"6439739", "Invercargill",
"6469008", "Palmerston\ North",
"647949", "Hamilton",
"6477779", "Putaruru\/Tokoroa",
"6435543", "Tokanui",
"6439528", "Lawrence",
"6492226", "Helensville",
"6478080", "Hamilton",
"6469246", "Palmerston\ North",
"6432640", "Hokitika",
"6479292", "Hamilton",
"6499460", "Whangarei",
"64337", "Christchurch",
"6499459", "Maungaturoto",
"649959", "Hibiscus\ Coast",
"6475609", "Paeroa",
"6435885", "Invercargill",
"643245", "Tokanui\/Lumsden\/Te\ Anau",
"6472828", "Tauranga",
"6439280", "Nelson",
"6439753", "Amberley",
"646768", "New\ Plymouth",
"64391", "South\ Island",
"647881", "Matamata",
"6437456", "Culverden",
"643460", "Dunedin\/Palmerston",
"6439450", "Invercargill",
"6479291", "Hamilton",
"6435993", "Mt\ Cook",
"6435528", "Ranfurly",
"6479229", "Opotiki",
"6474649", "Matamata",
"6462614", "Wairoa",
"6439873", "Wanaka",
"6493943", "Helensville",
"644895", "Paraparaumu",
"6499811", "Hibiscus\ Coast",
"64998", "Whangarei",
"6436586", "Edendale",
"6435", "South\ Island",
"6473996", "Otorohanga",
"6499069", "Pukekohe",
"6463942", "Masterton",
"6462127", "Dannevirke",
"6466990", "Mokau",
"6474447", "Te\ Kuiti",
"6439314", "Winton",
"643756", "Hokitika",
"6468996", "Napier",
"6436598", "Wanaka",
"6469270", "Marton",
"6499018", "Maungaturoto",
"6439316", "Edendale",
"6468245", "Wairoa",
"643221", "Invercargill",
"646761", "Opunake",
"6462808", "Napier\/Hastings",
"647888", "Matamata",
"6468994", "Waipukurau",
"6463941", "Masterton",
"6439060", "Greymouth",
"649652", "Warkworth",
"6462616", "Ruatoria",
"643455", "Dunedin",
"6436584", "Winton",
"6473994", "Rotorua",
"6439885", "Fox\ Glacier",
"646388", "Taihape",
"6435667", "Waitangi\ \(Chatham\ Is\.\)",
"643206", "Edendale",
"647829", "Hamilton",
"6495533", "Whangarei",
"6432653", "Wanaka",
"643260", "Christchurch",
"6496016", "Warkworth",
"6498851", "Pukekohe",
"6432421", "Tokanui\/Lumsden\/Te\ Anau",
"6439324", "Darfield",
"6435550", "Fox\ Glacier",
"6432736", "Dunedin",
"6439295", "Nelson",
"6479018", "Putaruru\/Tokoroa",
"6437447", "Greymouth",
"6439856", "Darfield",
"6434403", "Queenstown\/Cromwell\/Alexandra\/Wanaka\/Ranfurly\/Roxburgh",
"643445", "Cromwell",
"6472133", "Taupo",
"6463908", "Wairoa",
"6462624", "Opunake",
"64370", "South\ Island",
"6435518", "Milton",
"6435679", "Alexandra",
"6498852", "Warkworth",
"6432734", "Waimate",
"646843", "Napier\/Hastings",
"6478095", "Taupo",
"6462626", "Mokau",
"6432422", "Tokanui\/Lumsden\/Te\ Anau",
"6495560", "Whangarei",
"6439854", "Waitangi\ \(Chatham\ Is\.\)",
"6432639", "Edendale",
"64783", "Hamilton",
"6439740", "Christchurch",
"6496014", "Dargaville",
"6465619", "Masterton",
"646762", "Stratford",
"6432807", "Tokanui",
"64325", "South\ Island",
"6439326", "Rangiora",
"6436562", "Balclutha",
"6436526", "Fox\ Glacier",
"6439007", "Dunedin",
"6437485", "Te\ Anau",
"6499043", "Hibiscus\ Coast",
"643421", "Christchurch",
"6472226", "Te\ Kuiti",
"6466006", "Opunake",
"6473928", "Te\ Awamutu",
"6472604", "Hamilton",
"6469716", "Opunake",
"6497779", "Great\ Barrier\ Island",
"6469293", "New\ Plymouth",
"6436638", "Kurow",
"6472224", "Taupo",
"6469619", "Wanganui\/New\ Plymouth",
"6466004", "Waipukurau",
"6466553", "New\ Plymouth",
"6469578", "Marton",
"646650", "Napier",
"6434265", "Milton",
"6472606", "Huntly",
"6469714", "Hawera",
"647882", "Putaruru\/Tokoroa",
"6436561", "Oamaru",
"649405", "Kaikohe",
"6437473", "Milton",
"6472818", "Rotorua",
"6437770", "Nelson",
"6436524", "Hokitika",
"6433959", "Balclutha",
"646382", "Taihape",
"646869", "Gisborne\/Ruatoria",
"6499559", "Whangarei",
"6436646", "Roxburgh",
"6433955", "Mt\ Cook",
"644904", "Paraparaumu",
"6499555", "Kawakawa",
"6468263", "Napier",
"6439741", "Christchurch",
"6439333", "Franz\ Josef",
"6495561", "Whangarei",
"6492429", "Pukekohe",
"6434269", "Twizel",
"6435552", "Queenstown",
"6439014", "Ashburton",
"6469615", "Masterton",
"643951", "Dunedin",
"6472124", "Matamata",
"647334", "Rotorua",
"649391", "Auckland",
"647867", "Thames",
"6432723", "Takaka",
"643942", "Christchurch",
"646966", "Wanganui\/New\ Plymouth",
"6497775", "Helensville",
"6479858", "Whakatane",
"6437489", "South\ Island",
"6439742", "Christchurch",
"6463997", "Palmerston\ North",
"6466017", "Napier",
"64429", "Paraparaumu",
"6439016", "Alexandra",
"643411", "Balclutha\/Milton",
"6472126", "Otorohanga",
"6466508", "Napier\/Wairoa",
"6435551", "Franz\ Josef",
"643236", "Winton",
"6436644", "Alexandra",
"6439266", "Dunedin",
"6495562", "Whangarei",
"6432420", "Christchurch",
"6498850", "Great\ Barrier\ Island",
"6478997", "Morrinsville",
"643958", "Dunedin\/Timaru",
"6469040", "Wairoa",
"6439084", "Amberley",
"6469308", "Opunake",
"643212", "Invercargill",
"649398", "Auckland\/Waiheke\ Island",
"6437771", "Blenheim",
"6432816", "Waimate",
"6434296", "Greymouth",
"6465615", "Wanganui",
"6436560", "Palmerston",
"649902", "Warkworth",
"6477884", "Tauranga",
"6432635", "Riverton",
"6432608", "Dunedin",
"647926", "Tauranga",
"6493206", "Pukekohe",
"6435683", "Te\ Anau",
"6462104", "Marton",
"6434288", "Cromwell",
"6477886", "Rotorua",
"6437772", "Timaru",
"6496518", "Kawakawa",
"6437468", "Wanaka",
"6435675", "Twizel",
"6439098", "Akaroa",
"6439299", "Murchison",
"6432228", "Wanaka",
"6462106", "Pahiatua",
"64923", "Pukekohe",
"6432748", "Cromwell",
"6499717", "Whangarei",
"6462149", "Ruatoria",
"643418", "Balclutha",
"6496007", "Helensville",
"6434294", "Franz\ Josef",
"6468808", "Palmerston\ North",
"6479247", "Hamilton",
"6432814", "Mt\ Cook",
"6475828", "Hamilton",
"6497774", "Warkworth",
"643749", "Christchurch",
"6472609", "Whangamata",
"6472190", "Whakatane",
"6479843", "Morrinsville",
"6469616", "Featherston",
"6474657", "Thames",
"649431", "Maungaturoto",
"6469001", "New\ Plymouth",
"6472822", "Rotorua",
"6436617", "Cromwell",
"6433956", "Dunedin",
"6436645", "Ranfurly",
"646654", "Gisborne",
"643528", "Motueka",
"6499556", "Maungaturoto",
"6462813", "Wanganui",
"6432993", "Balclutha",
"6439521", "Dunedin",
"643921", "Blenheim",
"6499554", "Kaitaia",
"6493937", "Warkworth",
"6499003", "Warkworth",
"6449008", "Paraparaumu",
"6439047", "Alexandra",
"6436529", "Westport",
"6433954", "Lawrence",
"6439537", "Dunedin\/Timaru",
"6469002", "Hawera",
"6472821", "Hamilton",
"6499473", "Helensville",
"6439522", "Dunedin",
"643215", "Invercargill",
"647826", "Huntly",
"6497776", "Hibiscus\ Coast",
"6466009", "Waiouru",
"6469614", "Levin",
"6463923", "Ohakune",
"6439015", "Wanaka",
"6472125", "Huntly",
"6479298", "Taupo",
"6435674", "Milton",
"6462629", "Levin",
"6498901", "Pukekohe",
"6439700", "Nelson",
"6432636", "Te\ Anau",
"6499818", "Great\ Barrier\ Island",
"646866", "Gisborne\/Ruatoria",
"6433990", "South\ Island",
"6498820", "Whangarei",
"643521", "Nelson",
"6462802", "Palmerston\ North",
"6479021", "Te\ Awamutu",
"643270", "Christchurch",
"6432753", "Winton",
"6432667", "South\ Island",
"6439329", "South\ Island",
"6436687", "Nelson",
"6436591", "Nelson",
"6432815", "Fairlie",
"6439073", "Motueka",
"6465616", "Hawera",
"6434295", "Fox\ Glacier",
"6499011", "Kaitaia",
"6442127", "Paraparaumu",
"649347", "Auckland",
"6439085", "Waitangi\ \(Chatham\ Is\.\)",
"647590", "Hamilton",
"6434220", "Invercargill",
"6465614", "Wanganui",
"6462801", "Palmerston\ North",
"6479022", "Morrinsville",
"6477885", "Tauranga",
"6432634", "Invercargill",
"6435537", "Winton",
"6439859", "Christchurch\/Blenheim\/Nelson",
"6479107", "Whakatane",
"6439860", "Nelson",
"6435676", "Kurow",
"643409", "Queenstown",
"6432739", "Balclutha",
"6499012", "Kawakawa",
"6499746", "Kawakawa",
"6462138", "Palmerston\ North",
"6436592", "Nelson",
"6462105", "Taihape",
"64354", "Nelson",
"6478094", "Tauranga",
"6439296", "Invercargill",
"6432735", "Mt\ Cook",
"6439713", "Mt\ Cook",
"6439458", "Edendale",
"6462109", "Waiouru",
"643241", "Tokanui\/Lumsden\/Te\ Anau",
"643239", "Invercargill",
"647982", "Hamilton",
"646385", "Ohakune",
"6439855", "Rangiora",
"6477889", "Whakatane",
"646750", "Mokau",
"643458", "Dunedin\/Queenstown",
"646969", "New\ Plymouth",
"6466523", "Palmerston\ North",
"6439288", "Ashburton",
"6496015", "Maungaturoto",
"6472820", "Hamilton",
"644280", "Wellington",
"647885", "Putaruru\/Tokoroa",
"6467777", "Napier",
"6472192", "Whakatane",
"649402", "Kawakawa",
"6465607", "Taihape",
"6432819", "Christchurch",
"6499468", "Kawakawa",
"6432648", "Geraldine",
"6434299", "Haast",
"6462144", "Ruatoria",
"6439520", "Dunedin",
"6439325", "Kaikoura",
"646213", "Wanganui",
"6493209", "Great\ Barrier\ Island",
"6469000", "New\ Plymouth",
"6439294", "Dunedin",
"6462625", "Hawera",
"6472191", "Whakatane",
"6466548", "Ruatoria",
"6437486", "Tokanui",
"6472225", "Rotorua",
"646765", "Stratford",
"6473339", "Taupo",
"6472129", "Whangamata",
"6439019", "Roxburgh",
"6466005", "Mokau",
"6469853", "Waiouru",
"6439861", "Nelson",
"643225", "Otautau",
"6469715", "Mokau",
"6434264", "Kurow",
"6498822", "Kaikohe",
"6439068", "Fox\ Glacier",
"6433992", "Riverton",
"643451", "Queenstown",
"6462800", "Palmerston\ North",
"6468257", "Taihape",
"6439702", "Nelson",
"6468823", "Napier\/Hastings",
"6434221", "Invercargill",
"643248", "Lumsden",
"64793", "Tauranga",
"6439269", "Dunedin",
"6436525", "Franz\ Josef",
"6475627", "Taupo",
"6499010", "Kaitaia",
"6469278", "Gisborne",
"6436590", "Nelson",
"6434237", "Culverden",
"643442", "Queenstown",
"6436649", "Gore",
"6434359", "Twizel",
"6466998", "New\ Plymouth",
"6439862", "Nelson",
"644891", "Wellington",
"6479020", "Te\ Awamutu",
"64638", "Taihape\/Ohakune\/Waiouru",
"647877", "Te\ Kuiti",
"64360", "South\ Island",
"6433991", "Invercargill",
"6498821", "Dargaville",
"6432623", "Lawrence",
"6437484", "Riverton",
"6472605", "Thames",
"6432889", "Blenheim",
"6434266", "Palmerston",
"6492426", "Whangarei",
"6443709", "Paraparaumu",
"6434222", "Gore",
"6498900", "Pukekohe",
"6439701", "Nelson",
"646830", "Napier",
"647988", "Rotorua",
"6479852", "Whangamata",
"6472424", "Tauranga",
"6468813", "Taihape",
"6492225", "Pukekohe",
"6478077", "Waihi",
"643452", "Wanaka",
"6435884", "Dunedin",
"6439748", "Dunedin",
"6433989", "Waimate",
"6495568", "Kawakawa",
"6439029", "Tokanui",
"649408", "Kaitaia",
"6472119", "Thames",
"6436547", "Geraldine",
"6435510", "Darfield",
"6463900", "Gisborne",
"644834", "Paraparaumu",
"6479851", "Waihi",
"6437455", "Cheviot",
"6432613", "Waitangi\ \(Chatham\ Is\.\)",
"643667", "Christchurch",
"646953", "Palmerston\ North\ W100",
"6479010", "Thames",
"644892", "Paraparaumu",
"6436997", "Motueka",
"6435558", "Waimate",
"6498018", "Whangarei",
"643441", "Queenstown",
"6435886", "Invercargill",
"6465950", "Palmerston\ North",
"647863", "Waihi",
"6475617", "Whakatane",
"6469313", "Marton",
"6462157", "Stratford",
"6439277", "Invercargill",
"6437462", "Geraldine",
"649401", "Kaikohe",
"6468244", "Waipukurau",
"6469301", "Ruatoria",
"6439092", "Rangiora",
"6437778", "Greymouth",
"6496512", "Whangarei",
"6474638", "Opotiki",
"6468995", "Napier",
"6472810", "Tauranga",
"6499631", "Pukekohe",
"643936", "South\ Island",
"6432222", "Christchurch",
"6469287", "Ohakune",
"6432742", "Twizel",
"6433919", "Haast",
"6498882", "Whangarei",
"643690", "Waimate",
"649426", "Hibiscus\ Coast",
"6439884", "Franz\ Josef",
"647981", "Hamilton",
"6473995", "Putaruru\/Tokoroa",
"643337", "Christchurch",
"6436585", "Tokanui",
"6469570", "Palmerston\ North",
"6439723", "Blenheim",
"6434281", "Queenstown",
"6468802", "New\ Plymouth",
"6468883", "Palmerston\ North",
"6495589", "Pukekohe",
"6436630", "Takaka",
"6496511", "Whangarei",
"6473920", "Huntly",
"6439091", "Rangiora",
"6469302", "Napier",
"6462615", "Gisborne",
"6437461", "Fairlie",
"6432221", "Nelson",
"6439886", "Christchurch\/Blenheim\/Nelson",
"6439347", "Christchurch",
"643448", "Alexandra",
"6498881", "Hibiscus\ Coast",
"6439315", "Tokanui",
"6432741", "Milton",
"6468246", "Hawera",
"643425", "Dunedin",
"6434282", "Queenstown",
"6468801", "Wanganui",
"644595", "Wellington",
"644204", "Wellington",
"643415", "Balclutha",
"6465626", "Ruatoria",
"64378", "Westport",
"6498858", "Kaikohe",
"644817", "Wellington",
"6432428", "Queenstown",
"64948", "Auckland",
"6472803", "Waihi",
"6462417", "Wanganui",
"6439319", "Otautau",
"643396", "South\ Island",
"64790", "Taupo",
"643522", "Nelson",
"6499064", "Helensville",
"6479850", "Tokoroa",
"647463", "Whakatane",
"6462619", "Featherston",
"6435511", "Kaikoura",
"6463901", "Gisborne",
"6499066", "Helensville",
"6436589", "Otautau",
"6473999", "Taupo",
"6434993", "Alexandra",
"6479709", "Matamata",
"643989", "Nelson",
"6433915", "Greymouth",
"6472459", "Rotorua",
"6479746", "Opotiki",
"649395", "Auckland\/Waiheke\ Island",
"6499877", "Maungaturoto",
"6468999", "Napier",
"6433947", "Darfield",
"643955", "Dunedin",
"6465624", "Featherston",
"64363", "South\ Island",
"6463902", "Gisborne",
"6435512", "Rangiora",
"646847", "Napier\/Hastings",
"6499454", "Whangarei",
"6475606", "Matamata",
"6436632", "Murchison",
"643464", "Dunedin",
"643922", "Nelson",
"6468800", "Napier\/Hastings",
"6469572", "Palmerston\ North",
"64336", "South\ Island",
"6435697", "Westport",
"6477774", "Thames",
"6498880", "Helensville",
"644650", "Wellington",
"6432740", "Lawrence",
"6436627", "Waitangi\ \(Chatham\ Is\.\)",
"6472812", "Tauranga",
"6466579", "Featherston",
"6432220", "Dunedin",
"6478129", "Matamata",
"6492837", "Hibiscus\ Coast",
"6439090", "Rangiora",
"6439734", "Edendale",
"6437460", "Waitangi\ \(Chatham\ Is\.\)",
"6432443", "Christchurch",
"6496510", "Whangarei",
"6437459", "Rangiora",
"647216", "Rotorua",
"6473921", "Matamata",
"6469571", "Palmerston\ North",
"643759", "Hokitika\/Franz\ Josef\ Glacier\/Fox\ Glacier\/Haast",
"6435503", "Christchurch",
"6472115", "Taumarunui",
"6434280", "Queenstown",
"6463913", "Hawera",
"6439025", "Otautau",
"643682", "Timaru\/Waimate\/Fairlie",
"6436631", "Motueka",
"649459", "Whangarei",
"6479003", "Thames",
"6439736", "Riverton",
"6436568", "Roxburgh",
"6469249", "Masterton",
"6499298", "Pukekohe",
"6492229", "Hibiscus\ Coast",
"6433985", "Alexandra",
"6499456", "Kaikohe",
"6499630", "Pukekohe",
"6472811", "Tauranga",
"6475604", "Hamilton",
"6477776", "Whangamata",
"6473922", "Morrinsville",
"6436519", "Takaka",
"6469300", "Gisborne",
"6472147", "Paeroa",
"6439767", "Alexandra",
"64362", "South\ Island",
"6432888", "Nelson",
"6479854", "Rotorua",
"6475825", "Hamilton",
"644896", "Wellington",
"6443708", "Paraparaumu",
"6498814", "Pukekohe",
"6499060", "Warkworth",
"6435882", "Dunedin",
"6436648", "Lumsden",
"643755", "Hokitika",
"6466999", "New\ Plymouth",
"6472807", "Te\ Awamutu",
"6462413", "Gisborne",
"6469279", "Levin",
"6499873", "Kaitaia",
"6433943", "Amberley",
"6439268", "Dunedin",
"6495", "Auckland",
"6435881", "Dunedin",
"6439069", "Haast",
"6439050", "Geraldine",
"643467", "Dunedin",
"6465620", "New\ Plymouth",
"6468305", "Napier\/Wairoa",
"6479856", "Tauranga",
"643977", "Christchurch",
"6434997", "Lawrence",
"6498816", "Great\ Barrier\ Island",
"643456", "Dunedin",
"6466549", "Ruatoria",
"6479295", "Whakatane",
"6473338", "Rotorua",
"6472128", "Waihi",
"6439018", "Ranfurly",
"643959", "Dunedin\/Timaru",
"6436623", "Amberley",
"6439094", "Ashburton",
"6437464", "Timaru",
"6468242", "Ruatoria",
"6439730", "Invercargill",
"64320", "Gore",
"649399", "Auckland",
"6432606", "Dunedin",
"6496514", "Whangarei",
"6469200", "Gisborne",
"6492833", "Warkworth",
"6493208", "Helensville",
"6432447", "Timaru",
"6434286", "Christchurch",
"6432224", "Invercargill",
"6469306", "Hawera",
"6477770", "Tauranga",
"6432744", "Ranfurly",
"646844", "Napier\/Hastings",
"6432818", "Christchurch",
"6439882", "Westport",
"6435693", "Nelson",
"6499450", "Warkworth",
"6499469", "Maungaturoto",
"6432649", "Waimate",
"6434298", "Hokitika",
"6468804", "Napier",
"6432746", "Alexandra",
"6468241", "Gisborne",
"6469304", "Wairoa",
"643246", "Tokanui",
"649422", "Warkworth",
"6439289", "Akaroa",
"6468806", "New\ Plymouth",
"6475600", "Hamilton",
"6472143", "Morrinsville",
"6439763", "Palmerston",
"6496516", "Kaikohe",
"6435507", "Ashburton",
"6477888", "Taupo",
"6463917", "Wanganui",
"6439096", "Ashburton",
"6437466", "Cromwell",
"643419", "Balclutha",
"6434284", "Wanaka",
"6432226", "Timaru",
"64937", "Auckland",
"6439459", "Tokanui",
"6479007", "Whakatane",
"6499", "Auckland",
"6473933", "Rotorua",
"6462108", "Ohakune",
"6439881", "Greymouth",
"647828", "Huntly",
"6432738", "Oamaru",
"6462139", "Palmerston\ North",
"6439455", "Otautau",
"6439858", "Kaikoura",
"6435516", "Balclutha",
"6496507", "Helensville",
"6463906", "Napier",
"6439285", "Invercargill",
"6465621", "New\ Plymouth",
"6435880", "Dunedin",
"6468817", "Stratford",
"6499062", "Hibiscus\ Coast",
"644240", "Wellington",
"649320", "Auckland",
"6478073", "Putaruru\/Tokoroa",
"6472420", "Hamilton",
"644975", "Paraparaumu",
"643526", "Motueka",
"643392", "South\ Island",
"6436993", "Kaikoura",
"6478085", "Tauranga",
"644587", "Wellington",
"6432645", "Greymouth",
"6499465", "Dargaville",
"6439328", "South\ Island",
"6469317", "Pahiatua",
"6475613", "Te\ Awamutu",
"6462153", "New\ Plymouth",
"6439273", "Blenheim",
"643334", "Christchurch",
"6499061", "Hibiscus\ Coast",
"64627", "Hawera",
"6479014", "Matamata",
"643908", "Ashburton",
"6465622", "Stratford",
"6439052", "Mt\ Cook",
"6432617", "Cheviot",
"6435514", "Palmerston",
"6462628", "Wanganui",
"6463904", "Napier",
"64343", "Oamaru",
"6499819", "Helensville",
"643435", "Oamaru\/Mount\ Cook\/Twizel\/Kurow",
"6499452", "Warkworth",
"6439880", "Greymouth",
"6466008", "Ohakune",
"6469574", "Taihape",
"6436634", "Mt\ Cook",
"6479299", "Rotorua",
"646321", "Marton",
"6439727", "Dunedin",
"6477772", "Rotorua",
"6468887", "Gisborne",
"6473926", "Taumarunui",
"6439065", "Ashburton",
"6475601", "Hamilton",
"6472814", "Putaruru\/Tokoroa",
"643288", "Christchurch",
"6439732", "Otautau",
"647821", "Hamilton\/Huntly",
"6494315", "Warkworth",
"6436528", "Westport",
"6469202", "Levin",
"6469283", "Opunake",
"6469275", "Wanganui",
"647551", "Tauranga",
"6443", "Wellington",
"6472816", "Morrinsville",
"6499451", "Warkworth",
"6477771", "Whakatane",
"64784", "Hamilton",
"6466995", "Opunake",
"6469576", "Dannevirke",
"6436636", "Waimate",
"649552", "Pukekohe",
"6475602", "Hamilton",
"643926", "Christchurch",
"6436577", "Cromwell",
"6475829", "Hamilton",
"6469201", "Ruatoria",
"64361", "Timaru",
"6473924", "Paeroa",
"64634", "Wanganui",
"6472608", "Waihi",
"6439731", "Gore",
"6439343", "Waimate",
"6466527", "Taihape",
"6433951", "Timaru",
"6497772", "Kaitaia",
"6436518", "Murchison",
"6499551", "Whangarei",
"6439526", "Twizel",
"647822", "Hamilton\/Huntly",
"64785", "Hamilton",
"6467773", "Wanganui",
"6492228", "Warkworth",
"6499299", "Whangarei",
"6439745", "Greymouth",
"646374", "Dannevirke",
"6495565", "Dargaville",
"6439717", "Fairlie",
"646322", "Marton",
"6436569", "Alexandra",
"647925", "Tauranga",
"6478090", "Thames",
"64635", "Palmerston\ North",
"6469611", "Wanganui",
"647874", "Te\ Awamutu\/Otorohanga\/Te\ Kuiti",
"6469006", "Gisborne",
"649958", "Helensville",
"6499552", "Dargaville",
"6437458", "Kaikoura",
"6497771", "Kaikohe",
"6433952", "Fairlie",
"646950", "Palmerston\ North\/New\ Plymouth",
"6469004", "Napier\/Hastings",
"6439290", "Christchurch",
"6478128", "Huntly",
"646769", "New\ Plymouth",
"647211", "Hamilton",
"6435555", "Timaru",
"6465603", "Palmerston\ North",
"6469893", "Ruatoria",
"6439524", "Oamaru",
"6472826", "Matamata",
"647860", "Paeroa\/Waihi\/Thames\/Whangamata",
"647552", "Tauranga",
"6469612", "Wanganui\/New\ Plymouth",
"6435672", "Balclutha",
"6437775", "Wanaka",
"6468253", "Marton",
"6436596", "Queenstown",
"6468827", "New\ Plymouth",
"6468998", "Napier",
"6462804", "Palmerston\ North",
"6499016", "Kaikohe",
"6465611", "Napier",
"6479708", "Thames",
"6435526", "Kurow",
"6434260", "Oamaru",
"6432631", "Gore",
"6472458", "Rotorua",
"6435562", "Invercargill",
"6436588", "Lumsden",
"6473998", "Taumarunui",
"6479026", "Paeroa",
"644393", "Paraparaumu",
"6435671", "Oamaru",
"6462618", "Masterton",
"646965", "Wanganui\ W100",
"6432627", "Alexandra",
"647218", "Tauranga",
"6465612", "Waipukurau",
"647889", "Morrinsville",
"6437480", "Gore",
"6475623", "Tauranga",
"6435561", "Dunedin",
"6432429", "Timaru",
"6439318", "Lumsden",
"6432632", "Lumsden",
"643235", "Invercargill",
"6434233", "Rangiora",
"6499014", "Dargaville",
"6462806", "Napier\/Hastings",
"644250", "Wellington",
"6478143", "Opotiki",
"6436594", "Waimate",
"6498859", "Kaitaia",
"6478092", "Huntly",
"6479753", "Taupo",
"647970", "Hamilton",
"6462817", "Napier",
"6498855", "Kawakawa",
"647245", "Hamilton",
"6432997", "Edendale",
"64944", "Auckland",
"6432425", "Invercargill",
"6439291", "Dunedin",
"6479847", "Te\ Awamutu",
"6499428", "Warkworth",
"6497770", "Whangarei",
"647460", "Rotorua",
"6474653", "Putaruru\/Tokoroa",
"6472194", "Whakatane",
"643267", "South\ Island",
"6436613", "Wanaka",
"64687", "Napier\/Hastings",
"643949", "Dunedin",
"6478091", "Matamata",
"6469610", "Wanganui",
"6495588", "Hibiscus\ Coast",
"6472196", "Taupo",
"643538", "Nelson",
"649406", "Kaitaia",
"6463927", "Dannevirke",
"6433918", "Fox\ Glacier",
"6474639", "Opotiki",
"64737", "Taupo",
"6493933", "Kaikohe",
"6499007", "Kaikohe",
"6439043", "Ashburton",
"647986", "Hamilton",
"649421", "Hibiscus\ Coast",
"6439533", "Geraldine",
"6439292", "Timaru",
"6499477", "Pukekohe",
"6433950", "Waitangi\ \(Chatham\ Is\.\)",
"6437779", "Invercargill",
"6432757", "Lumsden",
"643219", "Invercargill",
"6432663", "Christchurch",
"6462423", "Gisborne",
"6436683", "Rangiora",
"6435559", "Haast",
"6434226", "Lumsden",
"6439077", "Ashburton",
"6498019", "Pukekohe",
"6435560", "Mt\ Cook",
"6434262", "Alexandra",
"643651", "Nelson",
"6433994", "Winton",
"6437481", "Invercargill",
"6498824", "Kawakawa",
"6492807", "Helensville",
"6435670", "Palmerston",
"6439866", "Christchurch\/Blenheim\/Nelson",
"643446", "Roxburgh",
"6439704", "Murchison",
"6439028", "Edendale",
"6435533", "Murchison",
"6469017", "Marton",
"6472118", "Taumarunui",
"6433996", "Edendale",
"6498826", "Warkworth",
"6446509", "Paraparaumu",
"6432630", "Christchurch",
"6434261", "Balclutha",
"6495569", "Maungaturoto",
"6436565", "Twizel",
"649428", "Hibiscus\ Coast",
"6439864", "Takaka",
"6439706", "Nelson",
"6499295", "Kaikohe",
"64340", "South\ Island",
"6465610", "Napier",
"6443333", "Paraparaumu",
"6437482", "Lumsden",
"6439749", "Christchurch",
"6433988", "Wanaka",
"643938", "South\ Island",
"646657", "Masterton",
"6469045", "Waipukurau",
"647812", "Hamilton",
"6434224", "Te\ Anau",};
my $timezones = {
               '' => [
                       'Pacific/Auckland',
                       'Pacific/Chatham'
                     ],
               '1' => [
                        'Pacific/Auckland'
                      ],
               '2' => [
                        'Pacific/Auckland'
                      ],
               '3' => [
                        'Pacific/Auckland'
                      ],
               '330' => [
                          'Pacific/Chatham'
                        ],
               '4' => [
                        'Pacific/Auckland'
                      ],
               '5' => [
                        'Pacific/Auckland'
                      ],
               '6' => [
                        'Pacific/Auckland'
                      ],
               '7' => [
                        'Pacific/Auckland'
                      ],
               '8' => [
                        'Pacific/Auckland'
                      ],
               '9' => [
                        'Pacific/Auckland'
                      ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+64|\D)//g;
      my $self = bless({ country_code => '64', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '64', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;