# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::DE;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20250323211826;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            3[02]|
            40|
            [68]9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,13})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            2(?:
              0[1-389]|
              12[0-8]
            )|
            3(?:
              [35-9][15]|
              4[015]
            )|
            906|
            2(?:
              [13][14]|
              2[18]
            )|
            (?:
              2[4-9]|
              4[2-9]|
              [579][1-9]|
              [68][1-8]
            )1
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [24-6]|
            3(?:
              3(?:
                0[1-467]|
                2[127-9]|
                3[124578]|
                7[1257-9]|
                8[1256]|
                9[145]
              )|
              4(?:
                2[135]|
                4[13578]|
                9[1346]
              )|
              5(?:
                0[14]|
                2[1-3589]|
                6[1-4]|
                7[13468]|
                8[13568]
              )|
              6(?:
                2[1-489]|
                3[124-6]|
                6[13]|
                7[12579]|
                8[1-356]|
                9[135]
              )|
              7(?:
                2[1-7]|
                4[145]|
                6[1-5]|
                7[1-4]
              )|
              8(?:
                21|
                3[1468]|
                6|
                7[1467]|
                8[136]
              )|
              9(?:
                0[12479]|
                2[1358]|
                4[134679]|
                6[1-9]|
                7[136]|
                8[147]|
                9[1468]
              )
            )|
            70[2-8]|
            8(?:
              0[2-9]|
              [1-8]
            )|
            90[7-9]|
            [79][1-9]|
            3[68]4[1347]|
            3(?:
              47|
              60
            )[1356]|
            3(?:
              3[46]|
              46|
              5[49]
            )[1246]|
            3[4579]3[1357]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2,11})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '138',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '3',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{2,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '181',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{5,11})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              3|
              80
            )|
            9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d)(\\d{4,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '1[67]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18500',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18[68]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[1279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            15(?:
              [0568]|
              31
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              6[023]|
              7
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15[279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{7})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{8})'
                }
              ];

my $validators = {
                'fixed_line' => '
          32\\d{9,11}|
          49[1-6]\\d{10}|
          322\\d{6}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'geographic' => '
          32\\d{9,11}|
          49[1-6]\\d{10}|
          322\\d{6}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'mobile' => '
          1(?:
            (?:
              5(?:
                [0-25-9]\\d\\d|
                310
              )|
              76\\d\\d
            )\\d{6}|
            6[023]\\d{7,8}
          )|
          17\\d{8}
        ',
                'pager' => '
          16(?:
            4\\d{1,10}|
            [89]\\d{1,11}
          )
        ',
                'personal_number' => '700\\d{8}',
                'specialrate' => '(
          180\\d{5,11}|
          13(?:
            7[1-6]\\d\\d|
            8
          )\\d{4}
        )|(
          (?:
            137[7-9]|
            900(?:
              [135]|
              9\\d
            )
          )\\d{6}
        )|(
          18(?:
            1\\d{5,11}|
            [2-9]\\d{8}
          )
        )',
                'toll_free' => '800\\d{7,12}',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"4939607", "Kotelow",
"492547", "Rosendahl\-Osterwick",
"495242", "Rheda\-Wiedenbrück",
"499383", "Wiesentheid",
"4935247", "Zehren\ Sachsen",
"494630", "Barderup",
"497972", "Gschwend\ bei\ Gaildorf",
"494765", "Ebersdorf\ bei\ Bremervörde",
"494176", "Marschacht",
"497573", "Stetten\ am\ kalten\ Markt",
"49711", "Stuttgart",
"499567", "Sesslach\-Gemünda",
"498168", "Attenkirchen",
"496757", "Becherbach\ bei\ Kirn",
"492696", "Nohn\ Eifel",
"495128", "Hohenhameln",
"497181", "Schorndorf\ Württemberg",
"492656", "Virneburg",
"494447", "Vechta\-Langförden",
"4935930", "Seitschen",
"4935605", "Komptendorf",
"4938428", "Hohenkirchen\ bei\ Wismar",
"4939245", "Loburg",
"495731", "Bad\ Oeynhausen",
"496102", "Neu\-Isenburg",
"492403", "Eschweiler\ Rheinland",
"494182", "Tostedt",
"494355", "Rieseby",
"496171", "Oberursel\ Taunus",
"498123", "Moosinning",
"498585", "Grainet",
"495744", "Hüllhorst",
"492295", "Ruppichteroth",
"495163", "Fallingbostel\-Dorfmark",
"494902", "Jemgum\-Ditzum",
"4938325", "Rolofshagen",
"497429", "Egesheim",
"4937207", "Hainichen\ Sachsen",
"498136", "Markt\ Indersdorf",
"494925", "Hinte",
"494971", "Esens",
"4936204", "Stotternheim",
"4934386", "Dürrweitzschen\ bei\ Grimma",
"4933209", "Caputh",
"494503", "Timmendorfer\ Strand",
"498670", "Reischach\ Kreis\ Altötting",
"496583", "Palzem",
"492255", "Euskirchen\-Flamersheim",
"4936331", "Ilfeld",
"497277", "Wörth\-Büchelberg",
"499263", "Ludwigsstadt",
"495947", "Laar\ Vechte",
"499524", "Zeil\ am\ Main",
"497853", "Kehl\-Bodersweier",
"4933837", "Brielow",
"492243", "Eitorf",
"494343", "Laboe",
"498086", "Buchbach\ Oberbayern",
"4939889", "Boitzenburg",
"496428", "Stadtallendorf",
"499091", "Monheim\ Schwaben",
"495849", "Waddeweitz",
"4935726", "Gross\ Särchen",
"492674", "Bad\ Bertrich",
"497044", "Mönsheim",
"499228", "Thurnau",
"495471", "Bohmte",
"495425", "Borgholzhausen",
"492307", "Kamen",
"495402", "Bissendorf\ Kreis\ Osnabrück",
"495300", "Salzgitter\-Üfingen",
"4936878", "Oberland",
"499833", "Heidenheim\ Mittelfranken",
"493634", "Sömmerda",
"498465", "Kipfenberg",
"499826", "Weidenbach\ Mittelfranken",
"496287", "Limbach\ Baden",
"499142", "Treuchtlingen",
"4933765", "Märkisch\ Buchholz",
"4936202", "Neudietendorf",
"496324", "Hassloch",
"494207", "Oyten",
"497031", "Böblingen",
"494154", "Trittau",
"499720", "Üchtelhausen",
"498072", "Haag\ in\ Oberbayern",
"494194", "Sievershütten",
"4935893", "Mücka",
"492162", "Viersen",
"493641", "Jena",
"494823", "Wilster",
"498055", "Halfing",
"492977", "Schmallenberg\-Bödefeld",
"496093", "Laufach",
"495857", "Bleckede\-Brackede",
"492850", "Rees\-Haldern",
"496657", "Hofbieber",
"497542", "Tettnang",
"497240", "Pfinztal",
"494238", "Neddenaverbergen",
"495273", "Beverungen",
"493937", "Osterburg\ Altmark",
"496053", "Wächtersbach",
"498095", "Aying",
"497943", "Schöntal\ Jagst",
"496697", "Willingshausen",
"492338", "Breckerfeld",
"4938738", "Karow\ bei\ Lübz",
"4935244", "Krögis",
"4939604", "Wildberg\ bei\ Altentreptow",
"494665", "Emmelsbüll\-Horsbüll",
"498574", "Wittibreut",
"493378", "Ludwigsfelde",
"497748", "Grafenhausen\ Hochschwarzwald",
"4933832", "Rogäsen",
"496261", "Mosbach\ Baden",
"494836", "Hennstedt\ Dithmarschen",
"4936207", "Plaue\ Thüringen",
"499461", "Roding",
"496844", "Blieskastel\-Altheim",
"495644", "Willebadessen\-Peckelsheim",
"4937204", "Lichtenstein\ Sachsen",
"499346", "Grünsfeld",
"4939483", "Ballenstedt",
"494534", "Steinburg\ Kreis\ Storman",
"492366", "Herten\ Westfalen",
"492441", "Kall",
"498369", "Rückholz",
"4936870", "Masserberg",
"4937433", "Gutenfürst",
"496831", "Saarlouis",
"4938334", "Grammendorf",
"494266", "Brockel",
"495631", "Korbach",
"495329", "Schulenberg\ im\ Oberharz",
"494541", "Ratzeburg",
"492434", "Wegberg",
"497124", "Trochtelfingen\ Hohenz",
"4936645", "Mühltroff",
"49631", "Kaiserslautern",
"493496", "Köthen\ Anhalt",
"4938201", "Gelbensande",
"492272", "Bedburg\ Erft",
"4934208", "Löbnitz\ bei\ Delitzsch",
"492685", "Flammersfeld",
"4935242", "Nossen",
"4939602", "Kleeth",
"4939928", "Möllenhagen",
"499935", "Stephansposching",
"4936041", "Bad\ Tennstedt",
"494372", "Westfehmarn",
"4938756", "Grabow",
"4935938", "Grosspostwitz\ OL",
"4933834", "Pritzerbe",
"496381", "Kusel",
"4933653", "Ziltendorf",
"4937202", "Claussnitz\ bei\ Chemnitz",
"498332", "Ottobeuren",
"4939426", "Hessen",
"498556", "Haidmühle",
"497302", "Pfaffenhofen\ an\ der\ Roth",
"4935436", "Laasow\ bei\ Calau",
"493741", "Plauen",
"497371", "Riedlingen\ Württemberg",
"492599", "Ascheberg\-Herbern",
"497325", "Sontheim\ an\ der\ Brenz",
"499804", "Aurach",
"493603", "Bad\ Langensalza",
"498043", "Jachenau",
"494499", "Barssel",
"496306", "Trippstadt",
"492774", "Dietzhölztal",
"4938332", "Gross\ Bisdorf",
"49951", "Bamberg",
"499173", "Thalmässing",
"496045", "Gedern",
"497955", "Wallhausen\ Württemberg",
"493366", "Beeskow",
"492839", "Straelen\-Herongen",
"493441", "Zeitz",
"496663", "Steinau\ an\ der\ Strasse",
"495863", "Zernien",
"497806", "Bad\ Peterstal\-Griesbach",
"4934202", "Delitzsch",
"498665", "Inzell",
"497145", "Markgröningen",
"4938427", "Blowatz",
"4933052", "Leegebruch",
"4935248", "Schönfeld\ bei\ Grossenhain",
"496871", "Wadern",
"496825", "Illingen\ Saar",
"495625", "Naumburg\ Hessen",
"495671", "Hofgeismar",
"4939608", "Staven",
"494882", "Lunden",
"498238", "Gessertshausen",
"4939922", "Dambeck\ bei\ Röbel",
"496802", "Völklingen\-Lauterbach",
"4933473", "Zechin",
"495602", "Hessisch\ Lichtenau",
"496449", "Ehringshausen\-Katzenfurt",
"4938871", "Mühlen\ Eichsen",
"498823", "Mittenwald",
"4935932", "Guttau",
"492474", "Nideggen\-Schmidt",
"4937208", "Auerswalde",
"492937", "Arnsberg\-Oeventrop",
"496628", "Oberaula",
"495828", "Himbergen",
"4934261", "Kühren\ bei\ Wurzen",
"4935454", "Uckro",
"4934953", "Gräfenhainichen",
"492269", "Kierspe\-Rönsahl",
"498541", "Vilshofen\ Niederbayern",
"495233", "Steinheim\ Westfalen",
"4935755", "Ortrand",
"498266", "Kirchheim\ in\ Schwaben",
"497504", "Horgenzell",
"492378", "Fröndenberg\-Langschede",
"495226", "Bruchmühlen\ Westfalen",
"494770", "Wischhafen",
"498868", "Schwabsoien",
"499083", "Möttingen",
"493338", "Bernau\ Brandenburg",
"498534", "Tettenweis",
"49781", "Offenburg",
"4939003", "Jübar",
"494876", "Reher\ Holstein",
"494854", "Friedrichskoog",
"498372", "Obergünzburg",
"492741", "Betzdorf",
"4936693", "Crossen\ an\ der\ Elster",
"499842", "Uffenheim",
"499126", "Eckental",
"499761", "Bad\ Königshofen\ im\ Grabfeld",
"492862", "Südlohn",
"499409", "Pielenhofen",
"4933054", "Liebenwalde",
"497629", "Tegernau\ Baden",
"4934204", "Schkeuditz",
"496024", "Schöllkrippen",
"497331", "Geislingen\ an\ der\ Steige",
"4939924", "Stuer",
"492734", "Freudenberg\ Westfalen",
"496551", "Prüm",
"4938732", "Gallin\ bei\ Lübz",
"495149", "Wienhausen",
"496591", "Gerolstein",
"499133", "Baiersdorf\ Mittelfranken",
"4935934", "Grossdubrau",
"492603", "Bad\ Ems",
"4933838", "Päwesin",
"497344", "Blaubeuren",
"493774", "Schwarzenberg",
"4935452", "Golssen",
"492456", "Selfkant",
"498459", "Manching",
"493685", "Hildburghausen",
"492232", "Brühl\ Rheinland",
"499391", "Marktheidenfeld",
"4936421", "Camburg",
"492389", "Werne",
"499351", "Gemünden\ am\ Main",
"498386", "Oberstaufen",
"4936200", "Elxleben\ bei\ Arnstadt",
"497448", "Seewald",
"494289", "Kirchtimke",
"497193", "Sulzbach\ an\ der\ Murr",
"496209", "Mörlenbach",
"494556", "Ahrensbök\-Gnissau",
"499975", "Waldmünchen\-Geigant",
"499921", "Regen",
"494332", "Hamdorf\ bei\ Rendsburg",
"497153", "Plochingen",
"4938356", "Behrenhoff",
"499952", "Eichendorf",
"495771", "Rahden\ Westfalen",
"495725", "Lindhorst\ bei\ Stadthagen",
"494944", "Wiesmoor",
"495702", "Petershagen\-Lahde",
"496131", "Mainz",
"4935383", "Elster\ Elbe",
"4938737", "Ganzlin",
"499553", "Ebrach\ Oberfranken",
"4938379", "Benz\ Usedom",
"497824", "Schwanau",
"4935696", "Briesnig",
"499420", "Feldkirchen\ Niederbayern",
"494168", "Neu\ Wulmstorf\-Elstorf",
"492066", "Duisburg\-Homberg",
"4938725", "Gross\ Godems",
"494931", "Norden",
"496763", "Kirchberg\ Hunsrück",
"496144", "Bischofsheim\ bei\ Rüsselsheim",
"499305", "Estenfeld",
"498176", "Egling\ bei\ Wolfratshausen",
"4938424", "Bobitz",
"498630", "Oberneukirchen",
"498765", "Bruckberg\ Niederbayern",
"495508", "Gleichen\-Rittmarshausen",
"4937323", "Lichtenberg\ Erzgebirge",
"4933830", "Ziesar",
"498503", "Neuhaus\ am\ Inn",
"4939754", "Löcknitz\ Vorpom",
"497932", "Niederstetten\ Württemberg",
"496505", "Kordel",
"494136", "Scharnebeck",
"4939455", "Schierke",
"4939399", "Kleinau",
"497533", "Allensbach",
"496220", "Wilhelmsfeld",
"496522", "Mettendorf",
"495965", "Klein\ Berssen",
"496728", "Ober\-Hilbersheim",
"4936076", "Niederorschel",
"4936208", "Ermstedt",
"492150", "Meerbusch\-Lank",
"495204", "Steinhagen\ Westfalen",
"495157", "Emmerthal\-Börry",
"496353", "Freinsheim",
"492485", "Schleiden\-Dreiborn",
"494123", "Barmstedt",
"498395", "Tannheim\ Württemberg",
"495197", "Soltau\-Frielingen",
"496393", "Fischbach\ bei\ Dahn",
"4933746", "Werbig\ bei\ Jüterbog",
"4935326", "Schönborn\ Kreis\ Elbe\-Elster",
"496345", "Albersweiler",
"493307", "Zehdenick",
"499257", "Zell\ Oberfranken",
"499104", "Emskirchen",
"492634", "Rengsdorf",
"4939927", "Nossentiner\ Hütte",
"498343", "Aitrang",
"495431", "Quakenbrück",
"4933966", "Dranse",
"499873", "Abenberg\-Wassermungenau",
"4935937", "Prischwitz",
"4933235", "Friesack",
"4933703", "Sperenberg",
"4933365", "Lüdersdorf\ Kreis\ Barnim",
"4935240", "Tauscha\ bei\ Grossenhain",
"4939600", "Zwiedorf",
"497071", "Tübingen",
"497025", "Neuffen",
"4939266", "Förderstedt",
"492641", "Bad\ Neuenahr\-Ahrweiler",
"497729", "Tennenbronn",
"498032", "Rohrdorf\ Kreis\ Rosenheim",
"495444", "Wagenfeld",
"4934207", "Zwochau",
"499661", "Sulzbach\-Rosenberg",
"4938422", "Neukloster",
"497237", "Neulingen\ Enzkreis",
"4936731", "Unterloquitz",
"4937200", "Wittgensdorf\ bei\ Chemnitz",
"4939752", "Blumenhagen\ bei\ Strasburg",
"4939293", "Dreileben",
"496081", "Usingen",
"498194", "Vilgertshofen",
"4936874", "Schönbrunn\ bei\ Hildburghaus",
"498207", "Affing",
"494465", "Friedeburg\ Ostfriesland",
"494747", "Beverstedt",
"492565", "Gronau\-Epe",
"496457", "Burgwald\ Eder",
"499545", "Buttenheim",
"4937421", "Oelsnitz\ Vogtland",
"492751", "Bad\ Berleburg",
"496534", "Mülheim\ Mosel",
"499852", "Feuchtwangen",
"496868", "Mettlach\-Tünsdorf",
"494844", "Pellworm",
"4935203", "Tharandt",
"497262", "Eppingen",
"499085", "Alerheim",
"4935727", "Burghammer",
"496541", "Traben\-Trarbach",
"499438", "Fensterbach",
"4935434", "Altdöbern",
"495159", "Coppenbrügge\-Bisperode",
"497394", "Schelklingen",
"496266", "Hassmersheim",
"4936784", "Stützerbach",
"4939424", "Schwanebeck\ Sachsen\-Anhalt",
"498628", "Kienberg\ Oberbayern",
"4938847", "Boizenburg\ Elbe",
"497354", "Erolzheim",
"495235", "Blomberg\ Lippe",
"495199", "Schneverdingen\-Heber",
"4936921", "Wutha\-Farnroda",
"492361", "Recklinghausen",
"4933836", "Butzow\ bei\ Brandenburg",
"4938754", "Leussow\ bei\ Ludwigslust",
"497832", "Haslach\ im\ Kinzigtal",
"495623", "Edertal",
"492446", "Heimbach\ Eifel",
"4934295", "Krensitz",
"495027", "Linsburg",
"498825", "Krün",
"499466", "Stamsried",
"4935952", "Grossröhrsdorf\ OL",
"498802", "Huglfing",
"4938455", "Plaaz",
"496238", "Dirmstein",
"499341", "Tauberbischofsheim",
"496665", "Sinntal\-Altengronau",
"495865", "Gusborn",
"498067", "Tuntenhausen",
"497458", "Ebhausen",
"496836", "Überherrn",
"494261", "Rotenburg\ Wümme",
"495636", "Lichtenfels\-Goddelsheim",
"497143", "Besigheim",
"497764", "Herrischried",
"498663", "Ruhpolding",
"494546", "Mustin\ Lauenburg",
"499334", "Giebelstadt",
"499572", "Burgkunstadt",
"497195", "Winnenden",
"499270", "Creussen",
"497382", "Römerstein",
"492206", "Overath",
"493491", "Lutherstadt\ Wittenberg",
"497967", "Jagstzell",
"499973", "Furth\ im\ Wald",
"4936782", "Schmiedefeld\ am\ Rennsteig",
"493683", "Schmalkalden",
"496386", "Altenkirchen\ Pfalz",
"494749", "Schiffdorf\-Geestenseth",
"499778", "Fladungen",
"4939422", "Badersleben",
"4937206", "Frankenberg\ Sachsen",
"4933973", "Zernitz\ bei\ Neustadt\ Dosse",
"49431", "Kiel",
"498591", "Obernzell",
"4938752", "Zierzow\ bei\ Ludwigslust",
"4938293", "Kühlungsborn\ Ostseebad",
"497376", "Langenenslingen",
"492622", "Bendorf\ am\ Rhein",
"495064", "Gross\ Düngen",
"4939606", "Glienke",
"499135", "Hessdorf\ Mittelfranken",
"4935954", "Grossharthau",
"4935246", "Ziegenhain\ Sachsen",
"492605", "Löf",
"498551", "Freyung",
"498024", "Holzkirchen",
"49221", "Cologne",
"494381", "Lütjenburg",
"496372", "Bruchmühlbach\-Miesau",
"496301", "Otterbach\ Pfalz",
"497727", "Vöhrenbach",
"4937349", "Scheibenberg",
"4936841", "Schleusingen",
"496355", "Albisheim\ Pfrimm",
"498393", "Holzgünz",
"494125", "Seestermühe",
"494171", "Winsen\ Luhe",
"496182", "Seligenstadt",
"494102", "Ahrensburg",
"495963", "Bawinkel",
"4934382", "Nerchau",
"497906", "Braunsbach",
"498728", "Geratskirchen",
"496395", "Münchweiler\ an\ der\ Rodalb",
"4939427", "Ströbeck",
"495562", "Dassel\-Markoldendorf",
"492267", "Wipperfürth",
"4938844", "Gülze",
"495768", "Petershagen\-Heimsen",
"495494", "Holdorf\ Niedersachsen",
"492651", "Mayen",
"498505", "Hutthurm",
"494367", "Grossenbrode",
"4935724", "Lohsa",
"4934601", "Teutschenthal",
"495454", "Hörstel\-Riesenbeck",
"492691", "Adenau",
"496503", "Hermeskeil",
"499303", "Eibelstadt",
"496630", "Schwalmtal\-Storndorf",
"492837", "Weeze",
"496765", "Gemünden\ Hunsrück",
"499074", "Höchstädt\ an\ der\ Donau",
"493877", "Wittenberge",
"497664", "Freiburg\-Tiengen",
"4939268", "Egeln",
"498144", "Grafrath",
"4938757", "Neustadt\-Glewe",
"497172", "Lorch\ Württemberg",
"495358", "Bahrdorf\-Mackendorf",
"4933968", "Meyenburg\ Kreis\ Prignitz",
"495723", "Bad\ Nenndorf",
"494757", "Wanna",
"49791", "Schwäbisch\ Hall",
"494976", "Spiekeroog",
"496447", "Langgöns\-Niederkleen",
"499555", "Schlüsselfeld\-Aschbach",
"498131", "Dachau",
"492563", "Stadtlohn",
"494954", "Moormerland",
"498457", "Vohburg\ an\ der\ Donau",
"4933748", "Treuenbrietzen",
"499942", "Viechtach",
"492962", "Olsberg",
"4938842", "Lüttenmark",
"492224", "Bad\ Honnef",
"4934384", "Grossbothen",
"499543", "Hirschaid",
"4936206", "Grossfahner",
"495482", "Tecklenburg",
"492387", "Drensteinfurt\-Walstedde",
"494324", "Brokstedt",
"496154", "Ober\-Ramstadt",
"496207", "Wald\-Michelbach",
"494287", "Heeslingen\-Boitzen",
"494463", "Wangerland",
"4935722", "Lauta\ bei\ Hoyerswerda",
"498081", "Dorfen\ Stadt",
"495476", "Ostercappeln\-Venne",
"496032", "Bad\ Nauheim",
"497023", "Weilheim\ an\ der\ Teck",
"4939955", "Jürgenstorf",
"492528", "Ennigerloh\-Enniger",
"4938781", "Mellen",
"497627", "Steinen\ Kreis\ Lörrach",
"499407", "Wenzenbach",
"495147", "Uetze\-Hänigsen",
"496343", "Bad\ Bergzabern",
"4935698", "Hornow",
"4939089", "Bismark\ Altmark",
"492722", "Attendorn",
"499875", "Wolframs\-Eschenbach",
"498345", "Stöttwang",
"496670", "Ludwigsau\ Hessen",
"494923", "Krummhörn\-Pewsum",
"495957", "Lindern\ Oldenburg",
"4933742", "Oehna\ Brandenburg",
"498583", "Neureichenau",
"492293", "Nümbrecht",
"495165", "Rethem\ Aller",
"495776", "Preussisch\ Ströhen",
"498367", "Rosshaupten\ Forggensee",
"494522", "Plön",
"4938848", "Vellahn",
"496585", "Ralingen",
"492253", "Bad\ Münstereifel",
"4936072", "Weissenborn\-Lüderode",
"497843", "Renchen",
"494505", "Stockelsdorf\-Curau",
"496136", "Nieder\-Olm",
"494353", "Ascheffel",
"497132", "Neckarsulm",
"496123", "Eltville\ am\ Rhein",
"495327", "Bad\ Grund\ Harz",
"492422", "Kreuzau",
"4936453", "Mellingen",
"492405", "Würselen",
"495284", "Schwalenberg",
"498102", "Höhenkirchen\-Siegertsbrunn",
"4935728", "Uhyst\ Spree",
"494393", "Boostedt",
"498171", "Wolfratshausen",
"494936", "Grossheide",
"497054", "Wildberg\ Württemberg",
"494131", "Lüneburg",
"494968", "Neulehe",
"496659", "Eichenzell",
"495859", "Thomasburg",
"4937384", "Wechselburg",
"4938483", "Brüel",
"4934782", "Mansfeld\ Südharz",
"4939264", "Kroppenstedt",
"4933964", "Fretzdorf",
"4935692", "Kerkwitz",
"494144", "Himmelpforten",
"494763", "Gnarrenburg",
"499385", "Kolitzheim",
"493691", "Eisenach\ Thüringen",
"499152", "Hartenstein\ Mittelfranken",
"497575", "Messkirch",
"4935324", "Crinitz",
"499192", "Gräfenberg",
"4936969", "Merkers",
"4933744", "Hohenseefeld",
"495436", "Nortrup",
"495252", "Bad\ Lippspringe",
"492557", "Wettringen\ Kreis\ Steinfurt",
"498463", "Greding",
"4939201", "Wolmirstedt",
"495292", "Lichtenau\-Atteln",
"492597", "Senden\ Westfalen",
"4936074", "Worbis",
"496465", "Breidenbach\ bei\ Biedenkopf",
"493528", "Radeberg",
"498324", "Hindelang",
"499666", "Illschwang",
"493722", "Limbach\-Oberfrohna",
"494497", "Barssel\-Harkebrügge",
"496747", "Emmelshausen",
"495364", "Velpke",
"499835", "Ehingen\ Mittelfranken",
"498649", "Schleching",
"4934921", "Kemberg",
"492646", "Königsfeld\ Eifel",
"495423", "Versmold",
"4937382", "Geringswalde",
"493962", "Penzlin\ bei\ Waren",
"4938750", "Malliss",
"4938426", "Neuburg\-Steinhausen",
"499184", "Deining\ Oberpfalz",
"493563", "Spremberg",
"4939262", "Güsten\ Anh",
"499638", "Neualbenreuth",
"4939409", "Eilsleben",
"496086", "Grävenwiesbach",
"497082", "Neuenbürg\ Württemberg",
"499904", "Lalling",
"4933962", "Heiligengrabe",
"495754", "Extertal\-Bremke",
"4937601", "Mülsen\ Skt\ Jacob",
"499265", "Pressig",
"4935694", "Gosda\ bei\ Klinge",
"495468", "Bramsche\-Engter",
"492245", "Much",
"4935322", "Doberlug\-Kirchhain",
"4938354", "Wusterhusen",
"493361", "Fürstenwalde\ Spree",
"497584", "Altshausen",
"495130", "Wedemark",
"499607", "Luhe\-Wildenau",
"492137", "Neuss\-Norf",
"497427", "Schömberg\ bei\ Balingen",
"4934673", "Heldrungen",
"496876", "Weiskirchen\ Saar",
"495676", "Liebenau\ Hessen",
"499374", "Eschau",
"4939428", "Pabstorf",
"494663", "Süderlügum",
"498546", "Windorf\-Otterskirchen",
"4938758", "Dömitz",
"496574", "Hasborn",
"4935936", "Sohland\ Spree",
"498261", "Mindelheim",
"4935265", "Glaubitz",
"4933967", "Freyenstein",
"499569", "Sesslach",
"4939926", "Grabowhöfe",
"4939779", "Eggesin",
"4935327", "Priessen",
"494802", "Wrohm",
"4939325", "Vinzelberg",
"4933056", "Mühlenbeck\ Kreis\ Oberhavel",
"495682", "Borken\ Hessen",
"494871", "Hohenwestedt",
"498053", "Bad\ Endorf",
"494825", "Burg\ Dithmarschen",
"4934206", "Rötha",
"496095", "Bessenbach",
"498657", "Ramsau\ bei\ Berchtesgaden",
"496055", "Freigericht",
"4939267", "Schneidlingen",
"497945", "Wüstenrot",
"498093", "Glonn\ Kreis\ Ebersberg",
"495275", "Höxter\-Ottbergen",
"495221", "Herford",
"497552", "Pfullendorf",
"493622", "Waltershausen\ Thüringen",
"497250", "Kraichtal",
"4938352", "Kemnitz\ bei\ Greifswald",
"499766", "Grosswenkheim",
"498045", "Lenggries\-Fall",
"496647", "Herbstein\-Stockhausen",
"497336", "Lonsee",
"493605", "Leinefelde",
"496043", "Nidda",
"497953", "Blaufelden",
"492309", "Waltrop",
"498306", "Ronsberg",
"499175", "Spalt",
"4937295", "Lugau\ Erzgebirge",
"494209", "Schwanewede",
"496596", "Üdersdorf",
"497464", "Talheim\ Kreis\ Tuttlingen",
"4933747", "Marzahna",
"4933633", "Spreenhagen",
"496430", "Hahnstätten",
"496332", "Zweibrücken",
"497323", "Gerstetten",
"4935873", "Herrnhut",
"4935456", "Terpt",
"4934243", "Bad\ Düben",
"4936077", "Grossbodungen",
"496556", "Pronsfeld",
"499356", "Burgsinn",
"4935697", "Bagenz",
"498381", "Lindenberg\ im\ Allgäu",
"496854", "Oberthal\ Saar",
"499532", "Maroldsweisach",
"4936601", "Hermsdorf\ Thüringen",
"495654", "Herleshausen",
"492451", "Geilenkirchen",
"495694", "Diemelstadt",
"4938736", "Goldberg",
"496894", "St\ Ingbert",
"499396", "Urspringen\ bei\ Lohr",
"499933", "Wallersdorf",
"499926", "Frauenau",
"494551", "Bad\ Segeberg",
"499738", "Rottershausen",
"492683", "Asbach\ Westerwald",
"49831", "Kempten\ Allgäu",
"498547", "Osterhofen\-Gergweis",
"493971", "Anklam",
"493925", "Stassfurt",
"4934383", "Trebsen\ Mulde",
"499493", "Beratzhausen",
"499148", "Ettenstatt",
"493902", "Diesdorf\ Altm",
"49961", "Weiden\ in\ der\ Oberpfalz",
"4933977", "Gumtow",
"492931", "Arnsberg",
"494179", "Winsen\-Tönnhausen",
"499453", "Thalmassing",
"499205", "Vorbach",
"499964", "Stallwang",
"499222", "Presseck",
"492944", "Rietberg\-Mastholte",
"498656", "Anger",
"499681", "Windischeschenbach",
"493395", "Pritzwalk",
"4933679", "Wendisch\ Rietz",
"496061", "Michelstadt",
"498403", "Pförring",
"4939829", "Blankenförde",
"499724", "Stadtlauringen",
"497433", "Balingen",
"496422", "Kirchhain",
"494485", "Elsfleth\-Huntorf",
"496405", "Laubach\ Hessen",
"493447", "Altenburg\ Thüringen",
"492585", "Warendorf\-Hoetmar",
"498295", "Altenmünster\ Schwaben",
"496253", "Fürth\ Odenwald",
"493765", "Reichenbach\ Vogtland",
"498139", "Röhrmoos",
"495304", "Meine",
"499606", "Pfreimd",
"495073", "Neustadt\-Esperke",
"497426", "Gosheim",
"495677", "Calden\-Westuffeln",
"496293", "Schefflenz",
"4938297", "Moitin",
"4938843", "Bennin",
"4939205", "Langenweddingen",
"499357", "Gräfendorf\ Bayern",
"496245", "Biblis",
"494641", "Süderbrarup",
"499397", "Wertheim\-Dertingen",
"498243", "Fuchstal",
"495531", "Holzminden",
"496108", "Mühlheim\ am\ Main",
"499927", "Kirchberg\ Wald",
"496783", "Baumholder",
"494188", "Welle\ Nordheide",
"494703", "Loxstedt\-Donnern",
"4935723", "Bernsdorf\ OL",
"494634", "Husby",
"4935207", "Moritzburg",
"4934925", "Bad\ Schmiedeberg",
"4936458", "Bad\ Berka",
"498785", "Rottenburg\-Oberroning",
"495544", "Reinhardshagen",
"497773", "Bodman\-Ludwigshafen",
"495105", "Barsinghausen",
"495846", "Gartow\ Niedersachsen",
"497337", "Nellingen\ Alb",
"496646", "Grebenau",
"4938488", "Demen",
"4934639", "Wallendorf\ Luppe",
"492747", "Molzhain",
"492465", "Inden",
"495248", "Langenberg\ Kreis\ Gütersloh",
"496597", "Jünkerath",
"4937605", "Hartenstein\ Sachsen",
"499829", "Flachslanden",
"497642", "Endingen\ Kaiserstuhl",
"499445", "Neustadt\ an\ der\ Donau",
"496557", "Hallschlag",
"494474", "Garrel",
"493541", "Calau",
"4937436", "Weischlitz",
"498756", "Nandlstadt",
"492759", "Bad\ Berleburg\-Aue",
"4935202", "Klingenberg\ Sachsen",
"493868", "Rastow",
"4933974", "Dessow",
"495191", "Soltau",
"498338", "Böhen",
"49971", "Bad\ Kissingen",
"497308", "Nersingen",
"494839", "Wöhrden\ Dithmarschen",
"492574", "Saerbeck",
"4933638", "Rüdersdorf\ bei\ Berlin",
"495151", "Hameln",
"4936450", "Kranichfeld",
"4935953", "Burkau",
"495956", "Rastdorf",
"499349", "Werbach\-Wenkheim",
"495777", "Diepenau\-Essern",
"492770", "Eschenburg",
"498366", "Oy\-Mittelberg",
"493836", "Wolgast",
"4938294", "Neubukow",
"495333", "Dettum",
"498441", "Pfaffenhofen\ an\ der\ Ilm",
"492369", "Dorsten\-Wulfen",
"495326", "Langelsheim",
"499624", "Ensdorf\ Oberpfalz",
"494269", "Ahausen\-Kirchwalsede",
"497404", "Epfendorf",
"4939321", "Arneburg",
"495042", "Bad\ Münder\ am\ Deister",
"498434", "Rennertshofen",
"496683", "Ehrenberg\ Rhön",
"495883", "Lemgow",
"494603", "Havetoft",
"493386", "Premnitz",
"498272", "Wertingen",
"494734", "Stadland\-Seefeld",
"4937291", "Augustusburg",
"4935204", "Wilsdruff",
"497231", "Pforzheim",
"498685", "Kirchanschöring",
"496087", "Waldems",
"496451", "Frankenberg\ Eder",
"4933972", "Breddin",
"4933656", "Bahro",
"494862", "Garding",
"4939423", "Wegeleben",
"494741", "Nordholz\ bei\ Bremerhaven",
"497244", "Weingarten\ Baden",
"4936783", "Gehren\ Thüringen",
"4935433", "Vetschau",
"4936605", "Bad\ Köstritz",
"492332", "Gevelsberg",
"495437", "Menslage",
"492556", "Metelen",
"492596", "Nordkirchen",
"493372", "Jüterbog",
"4938753", "Wöbbelin",
"497742", "Klettgau",
"499251", "Münchberg",
"493301", "Oranienburg",
"4938292", "Kröpelin",
"497673", "Schönau\ im\ Schwarzwald",
"494496", "Friesoythe\-Markhausen",
"492043", "Gladbeck",
"496746", "Pfalzfeld",
"498774", "Bayerbach\ bei\ Ergoldsbach",
"494232", "Langwedel\ Kreis\ Verden",
"492647", "Kesseling",
"494456", "Varel\-Altjührden",
"497442", "Baiersbronn",
"497340", "Neenstetten",
"492836", "Wachtendonk",
"4989", "Munich",
"499645", "Eschenbach\ in\ der\ Oberpfalz",
"4939006", "Miesterhorst",
"493876", "Perleberg",
"495373", "Hillerse\ Kreis\ Gifhorn",
"494338", "Alt\ Duvenstedt",
"4934672", "Rossleben",
"496020", "Heigenbrücken",
"4934956", "Zörbig",
"4934244", "Mockrehna",
"4933978", "Segeletz",
"492238", "Pulheim",
"4939721", "Liepen\ bei\ Anklam",
"494756", "Odisheim",
"4935874", "Bernstadt\ an\ der\ Eigen",
"4936481", "Neustadt\ an\ der\ Orla",
"496361", "Rockenhausen",
"4933634", "Berkenbrück\ Kreis\ Oder\-Spree",
"494796", "Teufelsmoor",
"494977", "Blomberg\ Ostfriesland",
"492823", "Goch",
"496446", "Hohenahr",
"4934291", "Borsdorf",
"494434", "Colnrade",
"499246", "Pegnitz\-Trockau",
"4933476", "Neuhardenberg",
"4936925", "Marksuhl",
"499561", "Coburg",
"497907", "Schwäbisch\ Hall\-Sulzdorf",
"498269", "Unteregg\ bei\ Mindelheim",
"4938451", "Hoppenrade\ bei\ Güstrow",
"492541", "Coesfeld",
"492266", "Lindlar",
"498378", "Buchenberg\ bei\ Kempten",
"494441", "Vechta",
"493574", "Lauchhammer",
"499848", "Simmershofen",
"494366", "Grömitz\-Cismar",
"4939861", "Gramzow\ bei\ Prenzlau",
"496751", "Bad\ Sobernheim",
"492534", "Münster\-Roxel",
"492372", "Hemer",
"493596", "Neustadt\ in\ Sachsen",
"499129", "Wendelstein",
"4937755", "Schönheide\ Erzgebirge",
"49621", "Mannheim",
"498741", "Vilsbiburg",
"492301", "Holzwickede",
"498862", "Steingaden\ Oberbayern",
"493332", "Schwedt\/Oder",
"49202", "Wuppertal",
"4938353", "Gützkow\ bei\ Greifswald",
"497626", "Kandern",
"499406", "Mintraching",
"4935208", "Radeburg",
"495146", "Wietze",
"497633", "Staufen\ im\ Breisgau",
"495822", "Ebstorf",
"4935872", "Neusalza\-Spremberg",
"496622", "Bebra",
"495805", "Oetzen",
"498734", "Reisbach\ Niederbayern",
"493647", "Pössneck",
"4934242", "Hohenpriessnitz",
"496281", "Buchen\ Odenwald",
"494272", "Siedenburg",
"4933632", "Hangelsberg",
"497704", "Geisingen\ Baden",
"498456", "Lenting",
"498232", "Schwabmünchen",
"495608", "Söhrewald",
"499481", "Pfatter",
"498389", "Weissensberg",
"497271", "Wörth\ am\ Rhein",
"497225", "Gaggenau",
"494774", "Hechthausen",
"495941", "Neuenhaus\ Dinkel",
"497202", "Karlsbad",
"496206", "Lampertheim",
"494286", "Gyhum",
"499653", "Eslarn",
"499097", "Marxheim",
"4936845", "Gehlberg",
"495934", "Haren\-Rütenbrock",
"49941", "Regensburg",
"494559", "Wensin",
"4935877", "Cunewalde",
"499283", "Rehau",
"492447", "Dahlem\ bei\ Kall",
"495026", "Steimbke",
"497473", "Mössingen",
"499467", "Michelsneukirchen",
"4935200", "Arnsdorf\ bei\ Dresden",
"4933637", "Beerfelde",
"4933743", "Blönsdorf",
"498179", "Eurasburg\ an\ der\ Loisach",
"498066", "Bad\ Feilnbach",
"49214", "Leverkusen",
"499745", "Wildflecken",
"495033", "Wunstorf\-Grossenheidorn",
"493585", "Löbau",
"496837", "Wallerfangen",
"492630", "Mülheim\-Kärlich",
"4934605", "Gröbers",
"494547", "Gudow\ Lauenburg",
"4936452", "Berlstedt",
"493931", "Stendal",
"4934783", "Gerbstedt",
"494255", "Martfeld",
"496691", "Schwalmstadt",
"495851", "Dahlenburg",
"498038", "Vogtareuth",
"496651", "Rasdorf",
"492925", "Warstein\-Allagen",
"492971", "Schmallenberg\-Dorlar",
"494295", "Emtinghausen",
"4938482", "Warin",
"492902", "Warstein",
"494139", "Hohnstorf\ Elbe",
"4937326", "Frauenstein\ Sachsen",
"493944", "Blankenburg\ Harz",
"4935386", "Prettin",
"496267", "Fahrenbach\ Baden",
"492395", "Finnentrop\-Rönkhausen",
"497529", "Waldburg\ Württemberg",
"492182", "Grevenbroich\-Kapellen",
"4935693", "Lauschütz",
"496483", "Selters\ Taunus",
"492355", "Schalksmühle",
"494403", "Bad\ Zwischenahn",
"496722", "Rüdesheim\ am\ Rhein",
"497733", "Engen\ Hegau",
"499363", "Arnstein\ Unterfranken",
"498634", "Garching\ an\ der\ Alz",
"49395", "Neubrandenburg",
"498703", "Essenbach",
"499424", "Strasskirchen",
"4939296", "Welsleben",
"497161", "Göppingen",
"494243", "Twistringen",
"4933970", "Neustadt\ Dosse",
"497938", "Mulfingen\ Jagst",
"4933395", "Zerpenschleuse",
"498641", "Grassau\ Kreis\ Traunstein",
"4936454", "Magdala",
"497726", "Bad\ Dürrheim",
"495903", "Emsbüren",
"494162", "Jork",
"4939951", "Faulenrost",
"4938785", "Berge\ bei\ Perleberg",
"4939263", "Unseburg",
"4934979", "Wulfen\ Sachsen\-Anhalt",
"4938484", "Ventschow",
"4937383", "Lunzenau",
"495502", "Dransfeld",
"492207", "Kürten\-Dürscheid",
"492154", "Willich",
"497966", "Unterschneidheim",
"495525", "Walkenried",
"495571", "Uslar",
"494307", "Raisdorf",
"496224", "Sandhausen\ Baden",
"4935323", "Sonnewalde",
"496387", "Sankt\ Julian",
"495183", "Lamspringe",
"498565", "Dietersburg\-Baumgarten",
"494674", "Ockholm",
"496563", "Kyllburg",
"4933963", "Wulfersdorf\ bei\ Wittstock",
"498751", "Mainburg",
"494137", "Barendorf",
"493546", "Lübben\ Spreewald",
"4937320", "Mulda\ Sachsen",
"497527", "Wolfegg",
"4933833", "Wollin\ bei\ Brandenburg",
"496269", "Gundelsheim\ Württemberg",
"497484", "Simmersfeld",
"495156", "Coppenbrügge",
"495196", "Wietzendorf",
"492628", "Rhens",
"499274", "Hollfeld",
"4938875", "Schlagsdorf\ bei\ Gadebusch",
"493831", "Stralsund",
"492449", "Blankenheim\ Ahr",
"498361", "Nesselwang",
"496474", "Villmar\-Aumenau",
"498446", "Pörnbach",
"495951", "Werlte",
"498020", "Weyarn",
"492871", "Bocholt",
"4935751", "Welzow",
"492825", "Uedem",
"499772", "Bischofsheim\ an\ der\ Rhön",
"4934327", "Waldheim\ Sachsen",
"499469", "Roding\-Neubäu",
"492802", "Alpen",
"4939482", "Gatersleben",
"499701", "Sandberg\ Unterfranken",
"4933654", "Fünfeichen",
"499643", "Auerbach\ in\ der\ Oberpfalz",
"493844", "Schwaan",
"4935206", "Kreischa\ bei\ Dresden",
"495060", "Bodenburg",
"498177", "Münsing\ Starnberger\ See",
"495321", "Goslar",
"495375", "Müden\ Aller",
"4937432", "Pausa\ Vogtland",
"497388", "Pfronstetten",
"492663", "Westerburg\ Westerwald",
"4969", "Frankfurt\ am\ Main",
"497236", "Keltern",
"499655", "Tännesberg",
"497452", "Nagold",
"49385", "Schwerin",
"498206", "Egling\ an\ der\ Paar",
"493381", "Brandenburg\ an\ der\ Havel",
"4938296", "Rerik\ Ostseebad",
"494746", "Hagen\ bei\ Bremerhaven",
"497564", "Bad\ Wurzach",
"49331", "Potsdam",
"497838", "Nordrach",
"4939603", "Burg\ Stargard",
"496456", "Haina\ Kloster",
"4935243", "Weinböhla",
"4933478", "Gross\ Neuendorf",
"498808", "Pähl",
"497223", "Bühl\ Baden",
"496232", "Speyer",
"492591", "Lüdinghausen",
"498281", "Thannhausen\ Schwaben",
"495803", "Rosche",
"493306", "Gransee",
"497635", "Schliengen",
"499256", "Stammbach",
"494683", "Oldsum",
"495174", "Lahstedt",
"498622", "Tacherting\-Peterskirchen",
"4939484", "Harzgerode",
"4937203", "Gersdorf\ bei\ Chemnitz",
"4933652", "Neuzelle",
"4933976", "Wutike",
"496007", "Rosbach\-Rodheim",
"4936425", "Isserstedt",
"496734", "Flonheim",
"492551", "Steinfurt\-Burgsteinfurt",
"495662", "Felsberg\ Hessen",
"494451", "Varel\ Jadebusen",
"4939008", "Kunrau",
"494491", "Friesoythe",
"49821", "Augsburg",
"497268", "Bad\ Rappenau\-Obergimpern",
"4938333", "Horst\ bei\ Grimmen",
"496741", "St\ Goar",
"4937434", "Bobenneukirchen",
"492393", "Sundern\-Allendorf",
"496190", "Hattersheim\ am\ Main",
"4935841", "Grossschönau\ Sachsen",
"493976", "Torgelow\ bei\ Ueckermünde",
"494405", "Edewecht",
"496485", "Nentershausen\ Westerwald",
"492353", "Halver",
"498267", "Dirlewang",
"496150", "Weiterstadt",
"4933085", "Seilershof",
"494320", "Heidmühlen",
"494422", "Sande\ Kreis\ Friesl",
"495384", "Seesen\-Gross\ Rhüden",
"498651", "Bad\ Reichenhall",
"492505", "Altenberge\ Westfalen",
"492522", "Oelde",
"4938721", "Ziegendorf",
"494253", "Asendorf\ Kreis\ Diepholz",
"494293", "Ottersberg\-Fischerhude",
"4933708", "Rangsdorf",
"494877", "Hennstedt\ bei\ Itzehoe",
"4933470", "Lietzen",
"492923", "Lippetal\-Herzfeld",
"494950", "Holtland",
"495035", "Gross\ Munzel",
"499164", "Langenfeld\ Mittelfranken",
"496066", "Michelstadt\-Vielbrunn",
"497807", "Neuried\ Ortenaukreis",
"4939451", "Wasserleben",
"493583", "Zittau",
"4939298", "Barby\ Elbe",
"492763", "Drolshagen\-Bleche",
"4935894", "Hähnichen",
"499285", "Kirchenlamitz",
"4934692", "Alsleben\ Saale",
"499948", "Eschlkam",
"497062", "Beilstein\ Württemberg",
"4939000", "Beetzendorf",
"499672", "Neunburg\ vorm\ Wald",
"4933657", "Steinsdorf\ Brandenburg",
"497475", "Burladingen",
"4934324", "Ostrau\ Sachsen",
"492131", "Neuss",
"495185", "Duingen",
"498563", "Bad\ Birnbach\ Rottal",
"494646", "Mohrkirch",
"495352", "Schöningen",
"49201", "Essen",
"495536", "Holzminden\-Neuhaus",
"4933231", "Pausin",
"498224", "Offingen\ Donau",
"496565", "Dudeldorf",
"498387", "Weiler\-Simmerberg",
"4935388", "Klöden",
"495264", "Kalletal",
"4937328", "Grossschirma",
"499099", "Kaisheim",
"495922", "Bad\ Bentheim",
"4939931", "Röbel\ Müritz",
"495905", "Beesten",
"4933361", "Joachimsthal",
"494557", "Blunk",
"495523", "Bad\ Sachsa",
"4933439", "Fredersdorf\-Vogelsdorf",
"494245", "Neuenkirchen\ bei\ Bassum",
"499127", "Rosstal\ Mittelfranken",
"4936735", "Probstzella",
"4937437", "Bad\ Elster",
"495841", "Lüchow\ Wendland",
"496641", "Lauterbach\ Hessen",
"49760", "Oberried\ Breisgau",
"496703", "Wöllstein\ Rheinhessen",
"499365", "Rimpar",
"496188", "Kahl\ am\ Main",
"4935892", "Horka\ OL",
"494108", "Rosengarten\ Kreis\ Harburg",
"497660", "St\ Peter\ Schwarzwald",
"497735", "Öhningen",
"499070", "Tapfheim",
"4934322", "Rosswein",
"4936203", "Vieselbach",
"493994", "Malchin",
"498722", "Gangkofen",
"498705", "Altfraunhofen",
"495834", "Wittingen\-Knesebeck",
"496634", "Gemünden\ Felda",
"4939487", "Friedrichsbrunn",
"495021", "Nienburg\ Weser",
"499347", "Wittighausen",
"498293", "Welden\ bei\ Augsburg",
"492583", "Sassenberg",
"493763", "Glauchau",
"496255", "Lindenfels",
"495462", "Ankum",
"496139", "Budenheim",
"492367", "Henrichenburg",
"496295", "Rosenberg\ Baden",
"498253", "Pöttmes",
"492982", "Medebach",
"493968", "Schönbeck",
"4937322", "Brand\-Erbisdorf",
"4938486", "Gustävel",
"494267", "Lauenbrück",
"498422", "Dollnstein",
"498320", "Missen\-Wilhams",
"4934425", "Droyssig",
"498405", "Stammham\ bei\ Ingolstadt",
"495594", "Bovenden\-Reyershausen",
"498061", "Bad\ Aibling",
"496403", "Linden\ Hessen",
"4939241", "Leitzkau",
"494939", "Baltrum",
"4935601", "Peitz",
"499632", "Waldsassen",
"495554", "Moringen",
"492102", "Ratingen",
"494483", "Ovelgönne\-Grossenmeer",
"492171", "Leverkusen\-Opladen",
"497435", "Albstadt\-Laufen",
"4933704", "Baruth\ Mark",
"496656", "Ebersburg",
"4936873", "Themar",
"499203", "Neudrossenfeld",
"4939294", "Gross\ Rosenburg",
"496696", "Gilserberg",
"496078", "Gross\-Umstadt",
"495258", "Salzkotten",
"493923", "Zerbst",
"499495", "Breitenbrunn\ Oberpfalz",
"4938321", "Martensdorf\ bei\ Stralsund",
"4934328", "Hartha\ bei\ Döbeln",
"499180", "Pyrbaum",
"4937430", "Eichigt",
"497652", "Hinterzarten",
"493522", "Grossenhain\ Sachsen",
"494837", "Neuenkirchen\ Dithmarschen",
"495439", "Bersenbrück",
"496162", "Reinheim\ Odenwald",
"4936335", "Grosswechsungen",
"498557", "Mauth",
"492463", "Titz",
"499158", "Offenhausen\ Mittelfranken",
"495582", "Sankt\ Andreasberg",
"499443", "Abensberg",
"4935384", "Steinsdorf\ bei\ Jessen",
"499198", "Heiligenstadt\ in\ Oberfranken",
"492324", "Hattingen\ Ruhr",
"4933477", "Trebnitz\ bei\ Müncheberg",
"492994", "Marsberg\-Westheim",
"4937324", "Reinsberg\ Sachsen",
"497775", "Mühlingen",
"494962", "Papenburg\-Aschendorf",
"497721", "Villingen\ im\ Schwarzwald",
"495103", "Wennigsen\ Deister",
"496307", "Schopp",
"4938423", "Bad\ Kleinen",
"494224", "Gross\ Ippener",
"4934722", "Preusslitz",
"4933702", "Wünsdorf",
"497166", "Adelberg",
"4934659", "Blankenheim\ bei\ Sangerhausen",
"492954", "Rüthen\-Oestereiden",
"494563", "Scharbeutz\-Haffkrug",
"495874", "Soltendieck",
"496674", "Friedewald\ Hessen",
"494705", "Wremen",
"497138", "Schwaigern",
"492428", "Niederzier",
"4939007", "Tangeln",
"496785", "Herrstein",
"497961", "Ellwangen\ Jagst",
"494722", "Cuxhaven\-Altenbruch",
"498783", "Rohr\ in\ Niederbayern",
"4939753", "Strasburg",
"494140", "Estorf\ Kreis\ Stade",
"4939292", "Biederitz",
"497684", "Glottertal",
"496243", "Monsheim",
"494528", "Schönwalde\ am\ Bungsberg",
"498245", "Türkheim\ Wertach",
"493871", "Parchim",
"4934203", "Zwenkau",
"4933053", "Zehlendorf\ Kreis\ Oberhavel",
"496434", "Bad\ Camberg",
"492831", "Geldern",
"499732", "Hammelburg",
"4936694", "Schkölen\ Thüringen",
"497362", "Bopfingen",
"494791", "Osterholz\-Scharmbeck",
"493663", "Schleiz",
"498137", "Petershausen",
"4935933", "Neschwitz",
"496441", "Wetzlar",
"492844", "Rheinberg\-Orsoy",
"4939061", "Weferlingen",
"495335", "Schladen",
"494751", "Otterndorf",
"4933472", "Golzow\ bei\ Seelow",
"4939923", "Priborn",
"497254", "Waghäusel",
"492546", "Coesfeld\-Lette",
"492261", "Gummersbach",
"498549", "Vilshofen\-Pleinting",
"499241", "Pegnitz",
"496338", "Hornbach\ Pfalz",
"494177", "Drage\ Elbe",
"495084", "Hambühren",
"499566", "Meeder",
"496756", "Winterbach\ Soonwald",
"493628", "Arnstadt",
"497558", "Illmensee",
"492697", "Blankenheim\-Ahrhütte",
"4939002", "Oebisfelde",
"492053", "Velbert\-Neviges",
"499234", "Neusorg",
"495650", "Cornberg",
"492657", "Uersfeld",
"494446", "Bakum\ Kreis\ Vechta",
"4939297", "Eickendorf\ Kreis\ Schönebeck",
"494361", "Oldenburg\ in\ Holstein",
"4938205", "Tessin\ bei\ Rostock",
"4937327", "Rechenberg\-Bienenmühle",
"499472", "Hohenfels\ Oberpfalz",
"499401", "Neutraubling",
"492045", "Bottrop\-Kirchhellen",
"496888", "Lebach\-Steinbach",
"497675", "Bernau\ Baden",
"497621", "Lörrach",
"493591", "Bautzen",
"496774", "Kaub",
"492306", "Lünen",
"4936692", "Bürgel",
"499827", "Lichtenau\ Mittelfranken",
"496286", "Walldürn\-Rippberg",
"496599", "Weidenbach\ bei\ Gerolstein",
"494206", "Stuhr\-Heiligenrode",
"496559", "Leidenborn",
"4933474", "Neutrebbin",
"495141", "Celle",
"4935387", "Seyda",
"4938733", "Karbow\-Vietlübbe",
"497276", "Herxheim\ bei\ Landau\ Pfalz",
"4933636", "Steinhöfel\ Kreis\ Oder\-Spree",
"49421", "Bremen",
"492381", "Hamm\ Westfalen",
"495946", "Georgsdorf",
"499359", "Karlstadt\-Wiesenfeld",
"4935453", "Drahnsdorf",
"4934954", "Roitzsch\ bei\ Bitterfeld",
"4939488", "Güntersberge",
"4935876", "Weissenberg\ Sachsen",
"494605", "Medelby",
"4939004", "Köckte\ bei\ Gardelegen",
"494622", "Taarstedt",
"499929", "Ruhmannsfelden",
"495052", "Hermannsburg",
"498683", "Tittmoning",
"4937438", "Bad\ Brambach",
"496201", "Weinheim\ Bergstr",
"496272", "Hirschhorn\ Neckar",
"49231", "Dortmund",
"494281", "Zeven",
"492241", "Siegburg",
"497851", "Kehl",
"492566", "Legden",
"494334", "Bredenbek\ bei\ Rendsburg",
"499546", "Burgebrach",
"4933458", "Falkenberg\ Mark",
"499261", "Kronach",
"499093", "Polsingen",
"499657", "Waldthurn",
"492234", "Frechen",
"4939991", "Daberkow",
"495529", "Rhumspringe",
"494466", "Wittmund\-Ardorf",
"492732", "Kreuztal",
"499831", "Gunzenhausen",
"497026", "Lenningen",
"495473", "Ostercappeln",
"493772", "Schneeberg\ Erzgebirge",
"497440", "Bad\ Rippoldsau",
"496461", "Biedenkopf",
"496709", "Fürfeld\ Kreis\ Bad\ Kreuznach",
"499844", "Obernzenn",
"493643", "Weimar\ Thüringen",
"496346", "Annweiler\ am\ Trifels",
"498374", "Dietmannsried",
"494852", "Brunsbüttel",
"493578", "Kamenz",
"496022", "Obernburg\ am\ Main",
"4933672", "Pfaffendorfb\ Beeskow",
"497033", "Weil\ Der\ Stadt",
"494892", "Schenefeld\ Mittelholstein",
"4939822", "Kratzeburg",
"492538", "Drensteinfurt\-Rinkerode",
"4934978", "Radegast\ Kreis\ Köthen",
"492864", "Reken",
"497525", "Aulendorf",
"497571", "Sigmaringen",
"495966", "Meppen\-Apeldorn",
"4933436", "Prötzel",
"492486", "Nettersheim",
"497502", "Wolpertswende",
"4938855", "Lübtheen",
"498230", "Gablingen",
"493695", "Bad\ Salzungen",
"492359", "Kierspe",
"498532", "Griesbach\ im\ Rottal",
"499381", "Volkach",
"497903", "Mainhardt",
"49931", "Würzburg",
"497708", "Geisingen\-Leipferdingen",
"494135", "Kirchgellersen",
"496506", "Welschbillig",
"497183", "Rudersberg\ Württemberg",
"498860", "Bernbeuren",
"4935058", "Pretzschendorf",
"496804", "Mandelbachtal",
"495604", "Grossalmerode",
"499749", "Oberbach\ Unterfranken",
"492065", "Duisburg\-Rheinhausen",
"4939083", "Messdorf",
"494884", "Schwabstedt",
"499306", "Kist",
"498121", "Markt\ Schwaben",
"495377", "Ehra\-Lessien",
"498766", "Gammelsdorf",
"492472", "Monschau",
"496173", "Kronberg\ im\ Taunus",
"49651", "Trier",
"495733", "Vlotho",
"494778", "Wingst",
"492401", "Baesweiler",
"496581", "Saarburg",
"495726", "Wiedensahl",
"494501", "Kastorf\ Holstein",
"4934632", "Mücheln\ Geiseltal",
"4939824", "Hohenzieritz",
"496620", "Philippsthal\ Werra",
"492827", "Goch\-Hassum",
"494973", "Wittmund\-Burhafe",
"4935771", "Bad\ Muskau",
"495820", "Suhlendorf",
"495161", "Walsrode",
"4933674", "Trebatsch",
"495907", "Geeste",
"494555", "Seedorf\ bei\ Bad\ Segeberg",
"499976", "Rötz",
"492203", "Cologne\-Porz",
"498192", "Schondorf\ am\ Ammersee",
"495187", "Delligsen",
"492455", "Waldfeucht",
"496383", "Glan\-Münchweiler",
"493686", "Eisfeld",
"494303", "Schlesen",
"4935209", "Mohorn",
"496567", "Oberkail",
"498152", "Herrsching\ am\ Ammersee",
"498385", "Hergatz",
"497229", "Iffezheim",
"499367", "Unterpleichfeld",
"497373", "Zwiefalten",
"4934743", "Ermsleben",
"4934637", "Frankleben",
"498707", "Adlkofen",
"498034", "Brannenburg",
"495442", "Barnstorf\ Kreis\ Diepholz",
"499102", "Wilhermsdorf",
"492632", "Andernach",
"4933605", "Boossen",
"494247", "Affinghausen",
"499171", "Roth\ Mittelfranken",
"493672", "Rudolstadt",
"4938393", "Binz\ Ostseebad",
"493601", "Mühlhausen\ Thüringen",
"498041", "Bad\ Tölz",
"496051", "Gelnhausen",
"498638", "Waldkraiburg",
"497941", "Öhringen",
"492507", "Havixbeck",
"495202", "Oerlinghausen",
"495271", "Höxter",
"495225", "Spenge",
"499428", "Kirchroth",
"494875", "Stafstedt",
"494821", "Itzehoe",
"4933979", "Wusterhausen\ Dosse",
"497934", "Weikersheim",
"496263", "Neckargerach",
"4934498", "Rositz",
"496524", "Rodershausen",
"494407", "Wardenburg",
"498265", "Pfaffenhausen\ Schwaben",
"496826", "Bexbach",
"492443", "Mechernich",
"495626", "Bad\ Zwesten",
"496142", "Rüsselsheim",
"499287", "Selb",
"499324", "Dettelbach",
"4933677", "Glienicke\ bei\ Beeskow",
"497477", "Jungingen\ bei\ Hechingen",
"492158", "Grefrath\ bei\ Krefeld",
"4937343", "Jöhstadt",
"499463", "Wald\ Oberpfalz",
"4939827", "Schwarz\ bei\ Neustrelitz",
"495037", "Bad\ Rehburg",
"495704", "Petershagen\-Friedewalde",
"494942", "Südbrookmerland",
"4935825", "Kodersdorf",
"496228", "Schönau\ Odenwald",
"499954", "Simbach\ Niederbayern",
"497805", "Appenweier",
"498666", "Teisendorf",
"494543", "Nusse",
"497146", "Remseck\ am\ Neckar",
"496833", "Rehlingen\-Siersburg",
"497822", "Ettenheim",
"495633", "Diemelsee",
"496322", "Bad\ Dürkheim",
"496420", "Lahntal",
"497333", "Laichingen",
"494152", "Geesthacht",
"4938826", "Dassow",
"494385", "Hohenfelde\ bei\ Kiel",
"4934343", "Regis\-Breitingen",
"499763", "Sulzdorf\ an\ der\ Lederhecke",
"499144", "Pleinfeld",
"497777", "Sauldorf",
"496305", "Hochspeyer",
"492743", "Daaden",
"492164", "Jüchen\-Otzenrath",
"498303", "Waltenhofen",
"494192", "Bad\ Bramstedt",
"498074", "Schnaitsee",
"496046", "Ortenberg\ Hessen",
"497042", "Vaihingen\ an\ der\ Enz",
"4934492", "Lucka",
"492672", "Treis\-Karden",
"496593", "Hillesheim\ Eifel",
"499131", "Erlangen",
"492601", "Nauort",
"498555", "Perlesreut",
"493632", "Sondershausen",
"496553", "Schönecken",
"495404", "Westerkappeln",
"4933457", "Altreetz",
"4938793", "Dergenthin",
"492948", "Lippstadt\-Rebbeke",
"497326", "Neresheim",
"499728", "Wülfershausen\ Unterfranken",
"499353", "Karlstadt",
"499936", "Wallerfing",
"498247", "Bad\ Wörishofen",
"4933845", "Borkheide",
"499393", "Rothenfels\ Unterfranken",
"4934977", "Quellendorf",
"494707", "Langen\-Neuenwalde",
"497151", "Waiblingen",
"496787", "Niederbrombach",
"495308", "Lehre",
"499923", "Teisnach",
"499505", "Litzendorf",
"4939773", "Altwarp",
"492686", "Weyerbusch",
"4939820", "Triepkendorf",
"499522", "Eltmann",
"497191", "Backnang",
"499220", "Kasendorf\-Azendorf",
"494265", "Fintel",
"498407", "Grossmehring",
"495742", "Preussisch\ Oldendorf",
"493443", "Weissenfels\ Sachsen\-Anhalt",
"496661", "Schlüchtern",
"495861", "Dannenberg\ Elbe",
"498821", "Garmisch\-Partenkirchen",
"494184", "Hanstedt\ Nordheide",
"499345", "Külsheim\ Baden",
"4934494", "Ehrenhain",
"496104", "Heusenstamm",
"496257", "Seeheim\-Jugenheim",
"492365", "Marl",
"496297", "Ravenstein\ Baden",
"494638", "Tarp",
"496873", "Nonnweiler",
"495673", "Immenhausen\ Hessen",
"498678", "Marktl",
"4934441", "Hohenmölsen",
"499497", "Seubersdorf\ in\ der\ Oberpfalz",
"494666", "Ladelund",
"498543", "Aidenbach",
"495231", "Detmold",
"4939225", "Altengrabow",
"496545", "Blankenrath",
"494835", "Albersdorf\ Holstein",
"4939055", "Hörsingen",
"498056", "Eggstätt",
"497974", "Bühlerzell",
"4935057", "Hermsdorf\ Erzgebirge",
"4933925", "Wustrau\-Altfriesack",
"499081", "Nördlingen",
"4934905", "Wörlitz",
"495244", "Rietberg",
"492755", "Bad\ Berleburg\-Schwarzenau",
"4935365", "Falkenberg\ Elster",
"498466", "Denkendorf\ Oberbayern",
"492772", "Herborn\ Hessen",
"499825", "Herrieden",
"499871", "Windsbach",
"498341", "Kaufbeuren",
"494478", "Cappeln\ Oldenburg",
"495433", "Badbergen",
"4936459", "Blankenhain\ Thüringen",
"499802", "Ansbach\-Katterbach",
"4933454", "Wölsickendorf\/Wollenberg",
"495109", "Ronnenberg",
"498334", "Bad\ Grönenbach",
"499663", "Neukirchen\ bei\ Sulzbach\-Rosenberg",
"497073", "Ammerbuch",
"495426", "Glandorf",
"492643", "Altenahr",
"497304", "Blaustein\ Württemberg",
"4935052", "Kipsdorf\ Kurort",
"494607", "Janneby",
"498085", "Sankt\ Wolfgang",
"496083", "Weilrod",
"4936021", "Schlotheim",
"4936963", "Dorndorf\ Rhön",
"492274", "Elsdorf\ Rheinland",
"4939362", "Grieben\ bei\ Tangerhütte",
"4933932", "Fehrbellin",
"499628", "Ursensollen",
"496249", "Guntersblum",
"4934638", "Zöschen",
"4935473", "Neu\ Lübbenau",
"498586", "Hauzenberg",
"4934497", "Langenleuba\-Niederhain",
"492296", "Reichshof\-Brüchermühle",
"499551", "Burgwindheim",
"498135", "Sulzemoos",
"494926", "Krummhörn\-Greetsiel",
"497122", "St\ Johann\ Württemberg",
"4936625", "Langenwetzendorf",
"496133", "Oppenheim",
"498259", "Schiltberg",
"495337", "Kissenbrück",
"492330", "Herdecke",
"492432", "Wassenberg",
"4933452", "Neulewin",
"492256", "Mechernich\-Satzvey",
"495773", "Stemwede\-Wehdem",
"494230", "Verden\-Walle",
"494532", "Bargteheide",
"496842", "Blieskastel",
"495642", "Warburg\-Scherfede",
"494356", "Gross\ Wittensee",
"496126", "Idstein",
"496409", "Biebertal",
"494933", "Dornum\ Ostfriesland",
"496761", "Simmern\ Hunsrück",
"495978", "Hörstel\-Dreierwalde",
"492858", "Hünxe",
"4936743", "Teichel",
"494489", "Apen",
"497248", "Marxzell",
"497531", "Konstanz",
"492695", "Insul",
"4935054", "Lauenstein\ Sachsen",
"499209", "Emtmannsberg",
"492655", "Weibern",
"498501", "Thyrnau",
"498572", "Tann\ Niederbayern",
"497544", "Markdorf",
"4939364", "Dolle",
"494766", "Basdahl",
"496391", "Dahn",
"4933678", "Storkow\ Mark",
"496351", "Eisenberg\ Pfalz",
"494175", "Egestorf\ Nordheide",
"494121", "Elmshorn",
"4939828", "Wustrow\ Kreis\ Mecklenburg\-Strelitz",
"4934656", "Wallhausen\ Sachsen\-Anhalt",
"4939403", "Gröningen\ Sachsen\-Anhalt",
"493493", "Bitterfeld",
"499971", "Cham",
"499925", "Bayerisch\ Eisenstein",
"495752", "Auetal\-Hattendorf",
"4933981", "Putlitz",
"494609", "Eggebek",
"49361", "Erfurt",
"497084", "Schömberg\ bei\ Neuenbürg",
"4935342", "Mühlberg\ Elbe",
"499503", "Oberhaid\ Oberfranken",
"499355", "Frammersbach",
"496247", "Worms\-Pfeddersheim",
"499182", "Velburg",
"4937361", "Neuhausen\ Erzgebirge",
"493964", "Bredenfelde\ bei\ Strasburg",
"499395", "Triefenstein",
"493681", "Suhl",
"4938301", "Putbus",
"495362", "Wolfsburg\-Fallersleben",
"4936375", "Kindelbrück",
"496595", "Dockweiler",
"4937439", "Jocketa",
"498553", "Spiegelau",
"493724", "Burgstädt",
"4933437", "Reichenberg\ bei\ Strausberg",
"499447", "Essing",
"498593", "Untergriesbach",
"496555", "Bleialf",
"4938232", "Zingst\ Ostseebad",
"496303", "Enkenbach\-Alsenborn",
"499765", "Trappstadt",
"495254", "Paderborn\-Schloss\ Neuhaus",
"4939489", "Strassberg\ Harz",
"498046", "Bad\ Heilbrunn",
"494383", "Grebin",
"496074", "Rödermark",
"497335", "Wiesensteig",
"493606", "Heiligenstadt\ Heilbad",
"4936652", "Wurzbach",
"498322", "Oberstdorf",
"499176", "Allersberg",
"495294", "Hövelhof\-Espeln",
"492745", "Brachbach\ Sieg",
"499154", "Pommelsbrunn",
"499207", "Königsfeld\ Oberfranken",
"494142", "Steinkirchen\ Kreis\ Stade",
"494826", "Hohenlockstedt",
"496096", "Wiesen\ Unterfranken",
"496056", "Bad\ Soden\-Salmünster",
"497946", "Bretzfeld",
"492753", "Erndtebrück",
"499194", "Ebermannstadt",
"495276", "Marienmünster",
"4935025", "Liebstadt",
"498545", "Hofkirchen\ Bayern",
"497052", "Bad\ Liebenzell",
"494833", "Wesselburen",
"496678", "Wildeck\-Hönebach",
"4939035", "Kuhfelde",
"492958", "Büren\-Harth",
"496543", "Büchenbeuren",
"492587", "Ennigerloh\-Westkirchen",
"495282", "Schieder\-Schwalenberg",
"499343", "Lauda\-Königshofen",
"492424", "Vettweiss",
"497134", "Weinsberg",
"496821", "Neunkirchen\ Saar",
"496875", "Nonnweiler\-Primstal",
"4938234", "Born\ Darss",
"495621", "Bad\ Wildungen",
"495675", "Trendelburg",
"495339", "Gielde",
"498257", "Inchenhofen",
"498104", "Sauerlach",
"492363", "Datteln",
"498661", "Grabenstätt\ Chiemsee",
"4933093", "Fürstenberg\ Havel",
"494263", "Scheessel",
"497141", "Ludwigsburg\ Württemberg",
"4937463", "Bergen\ Vogtland",
"494487", "Grossenkneten\-Huntlosen",
"4938828", "Schönberg",
"496407", "Rabenau\ Hessen",
"494524", "Scharbeutz\-Pönitz",
"493445", "Naumburg\ Saale",
"496438", "Hünfelden",
"4939826", "Blankensee\ bei\ Neustrelitz",
"4934658", "Hayn\ Harz",
"4933676", "Friedland\ bei\ Beeskow",
"499266", "Mitwitz",
"492246", "Lohmar\ Rheinland",
"492561", "Ahaus",
"498249", "Ettringen\ Wertach",
"499534", "Burgpreppach",
"496852", "Nohfelden",
"495652", "Bad\ Sooden\-Allendorf",
"496789", "Heimbach\ Nahe",
"494346", "Gettorf",
"498083", "Isen",
"499868", "Schillingsfürst",
"4935032", "Langenhennersdorf",
"494461", "Jever",
"49371", "Chemnitz\ Sachsen",
"497258", "Oberderdingen\-Flehingen",
"495692", "Wolfhagen",
"498687", "Taching\-Tengling",
"496085", "Waldsolms",
"499665", "Königstein\ Oberpfalz",
"497462", "Immendingen",
"499836", "Gunzenhausen\-Cronheim",
"4933203", "Kleinmachnow",
"4934223", "Dommitzsch",
"492645", "Vettelschoss",
"496334", "Thaleischweiler\-Fröschen",
"497021", "Kirchheim\ unter\ Teck",
"495435", "Berge\ bei\ Quakenbrück",
"497554", "Heiligenberg\ Baden",
"499823", "Leutershausen",
"493624", "Ohrdruf",
"496466", "Dautphetal\-Friedensdorf",
"4933434", "Herzfelde\ bei\ Strausberg",
"496341", "Landau\ in\ der\ Pfalz",
"499238", "Röslau",
"499499", "Painten",
"495684", "Frielendorf",
"499386", "Prosselsheim",
"494804", "Nordhastedt",
"4939883", "Gross\ Dölln",
"4939345", "Parchen",
"497576", "Krauchenwies",
"4934636", "Schafstädt",
"495961", "Haselünne",
"495138", "Sehnde",
"494173", "Wulfsen",
"49451", "Lübeck",
"492693", "Antweiler",
"496501", "Konz",
"496572", "Manderscheid\ Eifel",
"49241", "Aachen",
"4936085", "Reinholterode",
"492653", "Kaisersesch",
"498761", "Moosburg\ an\ der\ Isar",
"4936463", "Gebstedt",
"492406", "Herzogenrath",
"497582", "Bad\ Buchau",
"4938225", "Trinwillershagen",
"492129", "Haan\ Rheinland",
"499372", "Klingenberg\ am\ Main",
"494935", "Juist",
"4935973", "Stolpen",
"498133", "Haimhausen\ Oberbayern",
"495166", "Walsrode\-Kirchboitzen",
"495775", "Diepenau",
"495721", "Stadthagen",
"496586", "Beuren\ Hochwald",
"4934775", "Wippra",
"4933432", "Müncheberg",
"494506", "Stockelsdorf\-Krumbeck",
"496135", "Bodenheim\ Rhein",
"498022", "Tegernsee",
"497739", "Hilzingen",
"495807", "Altenmedingen",
"499369", "Uettingen",
"4934654", "Stolberg\ Harz",
"4936702", "Lauscha",
"4937329", "Grosshartmannsdorf",
"498461", "Beilngries",
"496003", "Rosbach\ von\ der\ Höhe",
"498709", "Eching\ Niederbayern",
"499876", "Rohr\ Mittelfranken",
"496374", "Weilerbach",
"498346", "Pforzen",
"4939366", "Kehnert",
"495421", "Dissen\ am\ Teutoburger\ Wald",
"495475", "Bohmte\-Hunteburg",
"494249", "Bassum\-Nordwohlde",
"4933335", "Pinnow\ Kreis\ Uckermark",
"4935389", "Holzdorf\ Elster",
"4938373", "Katzow",
"495062", "Holle\ bei\ Hildesheim",
"499278", "Weidenberg",
"4935056", "Altenberg\ Sachsen",
"492624", "Höhr\-Grenzhausen",
"496478", "Greifenstein\-Ulm",
"495909", "Wettrup",
"493561", "Guben",
"4936761", "Heubisch",
"499574", "Marktzeuln",
"497227", "Lichtenau\ Baden",
"496569", "Bickendorf",
"4933438", "Altlandsberg",
"4939393", "Werben\ Elbe",
"497384", "Schelklingen\-Hütten",
"49271", "Siegen",
"497841", "Achern",
"4934652", "Allstedt",
"4934976", "Gröbzig",
"499289", "Schwarzenbach\ am\ Wald",
"492251", "Euskirchen",
"499332", "Marktbreit",
"498581", "Waldkirchen\ Niederbayern",
"492291", "Waldbröl",
"494921", "Emden\ Stadt",
"497762", "Wehr\ Baden",
"494975", "Westerholt\ Ostfriesland",
"4936704", "Steinheid",
"499556", "Geiselwind",
"49851", "Passau",
"497834", "Wolfach",
"497568", "Bad\ Wurzach\-Hauerz",
"496766", "Kisselbach",
"499647", "Kirchenthumbach",
"4936941", "Wasungen",
"492667", "Stein\-Neukirch",
"494351", "Eckernförde",
"496175", "Friedrichsdorf\ Taunus",
"497392", "Laupheim",
"498506", "Bad\ Höhenstadt",
"492509", "Nottuln\-Appelhülsen",
"4939745", "Hetzdorf\ bei\ Strasburg",
"497352", "Ochsenhausen",
"494133", "Wittorf\ Kreis\ Lüneburg",
"4938827", "Kalkhorst",
"496356", "Carlsberg\ Pfalz",
"494126", "Horst\ Holstein",
"494842", "Nordstrand",
"4933456", "Wriezen",
"4933873", "Grosswudicke",
"499854", "Wittelshofen",
"496532", "Zeltingen\-Rachtig",
"497905", "Langenburg",
"493693", "Meiningen",
"497264", "Bad\ Rappenau",
"496396", "Hinterweidenthal",
"494409", "Westerstede\-Ocholt",
"49341", "Leipzig",
"494761", "Bremervörde",
"499123", "Lauf\ an\ der\ Pegnitz",
"496041", "Glauburg",
"4933479", "Küstrin\-Kietz",
"497951", "Crailsheim",
"492724", "Finnentrop\-Serkenrode",
"496034", "Wöllstadt",
"497321", "Heidenheim\ an\ der\ Brenz",
"497375", "Obermarchtal",
"496707", "Windesheim",
"493745", "Falkenstein\ Vogtland",
"4934463", "Bad\ Kösen",
"492606", "Winningen\ Mosel",
"494305", "Westensee",
"499931", "Plattling",
"496385", "Reichenbach\-Steegen",
"492453", "Heinsberg\-Randerath",
"494322", "Bordesholm",
"496152", "Gross\-Gerau",
"498383", "Grünenbach\ Allgäu",
"496192", "Hofheim\ am\ Taunus",
"49261", "Koblenz\ am\ Rhein",
"4934496", "Nöbdenitz",
"4939009", "Badel",
"4939971", "Gnoien",
"499944", "Miltach",
"499659", "Leuchtenberg",
"494952", "Rhauderfehn",
"492681", "Altenkirchen\ Westerwald",
"495484", "Lienen\-Kattenvenne",
"497156", "Ditzingen",
"492205", "Rösrath",
"4938822", "Diedrichshagen\ bei\ Grevesmühlen",
"492520", "Wadersloh\-Diestedde",
"492222", "Bornheim\ Rheinland",
"495527", "Duderstadt",
"492964", "Brilon\-Alme",
"494553", "Geschendorf",
"496666", "Freiensteinau",
"497174", "Mögglingen",
"499747", "Geroda\ Bayern",
"496835", "Beckingen",
"495635", "Vöhl",
"4939855", "Parmen\-Weggun",
"494545", "Seedorf\ Lauenburg",
"497803", "Gengenbach",
"495379", "Sassenburg\-Grussendorf",
"499072", "Lauingen\ Donau",
"492445", "Schleiden\ Eifel",
"498142", "Olching",
"499465", "Neukirchen\-Balbini",
"497662", "Vogtsburg\ im\ Kaiserstuhl",
"493328", "Teltow",
"496265", "Billigheim\ Baden",
"495492", "Steinfeld\ Oldenburg",
"498263", "Breitenbrunn\ Schwaben",
"492357", "Herscheid\ Westfalen",
"495452", "Mettingen\ Westfalen",
"494661", "Niebüll",
"495236", "Blomberg\-Grossenmarpe",
"494257", "Schweringen",
"494104", "Aumühle\ bei\ Hamburg",
"495223", "Bünde",
"496184", "Langenselbold",
"498091", "Kirchseeon",
"495564", "Dassel",
"4938824", "Mallentin",
"498051", "Prien\ am\ Chiemsee",
"496638", "Schwalmtal\-Renzendorf",
"494873", "Aukrug",
"492927", "Neuengeseke",
"495838", "Gross\ Oesingen",
"494297", "Ottersberg\-Posthausen",
"499086", "Fremdingen",
"4934361", "Dahlen\ Sachsen",
"493998", "Demmin",
"495533", "Bodenwerder",
"498241", "Buchloe",
"49671", "Bad\ Kreuznach",
"494643", "Gelting\ Angeln",
"4939884", "Hassleben\ bei\ Prenzlau",
"495932", "Haren\ Ems",
"499549", "Lisberg",
"4933331", "Casekow",
"498234", "Bobingen",
"497157", "Waldenbuch",
"497204", "Malsch\-Völkersbach",
"494469", "Wangerooge",
"497965", "Ellwangen\-Röhlingen",
"494772", "Oberndorf\ Oste",
"4935033", "Rosenthal\ Sächsische\ Schweiz",
"496781", "Idar\-Oberstein",
"4933202", "Töplitz",
"4934222", "Arzberg\ bei\ Torgau",
"498732", "Frontenhausen",
"495824", "Bad\ Bodenteich",
"496624", "Heringen\ Werra",
"493466", "Artern\ Unstrut",
"497702", "Blumberg\ Baden",
"4936464", "Wormstedt",
"493341", "Strausberg",
"494274", "Varrel\ bei\ Sulingen",
"4937467", "Klingenthal\ Sachsen",
"497725", "Königsfeld\ im\ Schwarzwald",
"497771", "Stockach",
"496349", "Billigheim\-Ingenheim",
"492374", "Iserlohn\-Letmathe",
"496706", "Wallhausen\ Nahe",
"498538", "Pocking\-Hartkirchen",
"4933878", "Nennhausen",
"493334", "Eberswalde",
"4935974", "Hinterhermsdorf",
"492607", "Kobern\-Gondorf",
"493501", "Pirna",
"499451", "Schierling",
"492933", "Sundern\ Sauerland",
"494858", "Sankt\ Margarethen\ Holstein",
"496028", "Sulzbach\ am\ Main",
"492532", "Ostbevern",
"495237", "Augustdorf",
"4939882", "Gollin",
"493973", "Pasewalk",
"499491", "Hemau",
"4939086", "Jävenitz",
"494256", "Hilgermissen",
"499683", "Friedenfels",
"4938378", "Heringsdorf\ Seebad",
"4936945", "Henneberg",
"492738", "Netphen",
"494330", "Emkendorf",
"494432", "Dötlingen\-Brettorf",
"497348", "Beimerstetten",
"494296", "Schwanewede\-Aschwarden",
"499087", "Marktoffingen",
"496509", "Büdlich",
"496667", "Steinau\-Ulmbach",
"498065", "Tuntenhausen\-Schönau",
"4939741", "Jatznick",
"497431", "Albstadt\-Ebingen",
"4934224", "Belgern\ Sachsen",
"499746", "Zeitlofs",
"4933204", "Beelitz\ Mark",
"492175", "Leichlingen\ Rheinland",
"493586", "Neugersdorf\ Sachsen",
"498370", "Wiggensbach",
"4936209", "Klettbach",
"4936462", "Ossmannstedt",
"496063", "Bad\ König",
"496291", "Adelsheim",
"4933433", "Buckow\ Märkische\ Schweiz",
"497444", "Alpirsbach",
"4939398", "Gross\ Garz",
"495071", "Schwarmstedt",
"495025", "Estorf\ Weser",
"496251", "Bensheim",
"496205", "Hockenheim",
"4935343", "Hirschfeld\ bei\ Elsterwerda",
"4933839", "Wusterwitz",
"494948", "Wiesmoor\-Marcardsmoor",
"494285", "Rhade\ bei\ Zeven",
"497233", "Niefern\-Öschelbronn",
"496222", "Wiesloch",
"496681", "Hilders",
"498203", "Grossaitingen",
"497930", "Boxberg\ Baden",
"494672", "Langenhorn",
"492192", "Hückeswagen",
"4938370", "Kröslin",
"4934746", "Giersleben",
"494164", "Harsefeld",
"494743", "Langen\ bei\ Bremerhaven",
"49581", "Uelzen",
"49661", "Fulda",
"497226", "Bühl\-Sand",
"492152", "Kempen",
"495504", "Friedland\ Kreis\ Göttingen",
"4939887", "Gerswalde",
"496453", "Gemünden\ Wohra",
"492385", "Hamm\-Rhynern",
"499253", "Weissenstadt",
"495145", "Beedenbostel",
"493303", "Birkenwerder",
"495806", "Barum\ bei\ Bad\ Bevensen",
"4938233", "Prerow\ Ostseebad",
"499293", "Berg\ Oberfranken",
"498347", "Friesenried",
"495208", "Leopoldshöhe",
"4936653", "Lehesten\ Thüringer\ Wald",
"4939975", "Thürkow",
"496724", "Stromberg\ Hunsrück",
"4939390", "Iden",
"4937464", "Schöneck\ Vogtland",
"499422", "Bogen\ Niederbayern",
"497671", "Todtnau",
"497625", "Zell\ im\ Wiesental",
"4933094", "Löwenberg",
"492041", "Bottrop",
"499405", "Bad\ Abbach",
"492638", "Waldbreitbach",
"498507", "Neuburg\ am\ Inn",
"494365", "Heringsdorf\ Holstein",
"4935249", "Basslitz",
"4939851", "Göritz\ bei\ Prenzlau",
"496357", "Standenbühl",
"494127", "Westerhorn",
"499245", "Obertrubach",
"495153", "Salzhemmendorf",
"4937346", "Geyer",
"492904", "Bestwig",
"4935795", "Königsbrück",
"4938461", "Bützow",
"496397", "Leimen\ Pfalz",
"495193", "Schneverdingen",
"495448", "Barver",
"492265", "Reichshof\-Eckenhagen",
"495331", "Wolfenbüttel",
"498443", "Hohenwart\ Paar",
"494755", "Ihlienworth",
"494795", "Garlstedt",
"498158", "Tutzing",
"496445", "Schöffengrund",
"495344", "Lengede",
"492835", "Issum",
"4933207", "Gross\ Kreutz",
"499646", "Freihung",
"4937209", "Einsiedel\ bei\ Chemnitz",
"493821", "Ribnitz\-Damgarten",
"492666", "Freilingen\ Westerwald",
"498669", "Traunreut",
"4937462", "Rothenkirchen\ Vogtland",
"4933870", "Zollchow\ bei\ Rathenow",
"494495", "Friesoythe\-Thüle",
"496745", "Gondershausen",
"4935939", "Hochkirch",
"497959", "Frankenhardt",
"498743", "Geisenhausen",
"499837", "Haundorf",
"496049", "Kefenrod",
"492303", "Unna",
"4939929", "Jabel\ bei\ Waren",
"4939776", "Hintersee",
"494180", "Königsmoor",
"497644", "Kenzingen",
"494455", "Jade\-Schweiburg",
"4937365", "Sayda",
"494203", "Weyhe\ bei\ Bremen",
"496283", "Hardheim\ Odenwald",
"4934462", "Laucha\ Unstrut",
"492555", "Schöppingen",
"498285", "Burtenbach",
"492595", "Olfen",
"497329", "Steinheim\ am\ Albuch",
"4938305", "Gingst",
"496467", "Hatzfeld\ Eder",
"497631", "Müllheim\ Baden",
"495943", "Emlichheim",
"4933200", "Bergholz\-Rehbrücke",
"497273", "Hagenbach\ Pfalz",
"4936371", "Schlossvippach",
"499267", "Nordhalben",
"495542", "Witzenhausen",
"492247", "Neunkirchen\-Seelscheid",
"4938796", "Viesecke",
"494632", "Steinbergkirche",
"4933877", "Nitzahn",
"4934346", "Narsdorf",
"494347", "Flintbek",
"4938823", "Selmsdorf",
"493385", "Rathenow",
"499651", "Vohenstrauss",
"492689", "Dierdorf",
"498686", "Petting",
"4937468", "Treuen\ Vogtland",
"495371", "Gifhorn",
"4938377", "Zinnowitz",
"495325", "Goslar\-Hahnenklee",
"495302", "Vechelde",
"492407", "Herzogenrath\-Kohlscheid",
"499528", "Donnersdorf",
"492821", "Kleve\ Niederrhein",
"4934464", "Freyburg\ Unstrut",
"499722", "Werneck",
"495955", "Esterwegen",
"496363", "Niederkirchen",
"495167", "Walsrode\-Westenholz",
"4935021", "Königstein\ Sächsische\ Schweiz",
"498365", "Wertach",
"496587", "Zerf",
"4939031", "Dähre",
"496424", "Ebsdorfergrund",
"492678", "Büchel\ bei\ Cochem",
"499962", "Schwarzach\ Niederbayern",
"4939397", "Geestgottberg",
"492543", "Billerbeck\ Westfalen",
"497577", "Veringenstadt",
"499563", "Rödental",
"492942", "Geseke",
"494158", "Roseburg",
"492056", "Heiligenhaus",
"496328", "Elmstein",
"493904", "Haldensleben",
"496753", "Meisenheim",
"494443", "Dinklage",
"498772", "Mallersdorf\-Pfaffenberg",
"4936703", "Gräfenthal",
"498469", "Freystadt\-Burggriesbach",
"4935476", "Wittmannsdorf\-Bückchen",
"499446", "Altmannstein",
"497731", "Singen\ Hohentwiel",
"4939888", "Lychen",
"494234", "Dörverden",
"4938372", "Usedom",
"492334", "Hagen\-Hohenlimburg",
"495845", "Bergen\ Dumme",
"496645", "Ulrichstein",
"4936966", "Kaltennordheim",
"495429", "Melle\-Wellingholzhausen",
"499177", "Heideck",
"497163", "Ebersbach\ an\ der\ Fils",
"497744", "Stühlingen",
"494241", "Bassum",
"49511", "Hannover",
"495573", "Uslar\-Volpriehausen",
"494864", "Oldenswort",
"495648", "Brakel\-Gehrden",
"496848", "Homburg\-Einöd",
"492852", "Hamminkeln",
"497242", "Rheinstetten",
"495901", "Fürstenau\ bei\ Bramsche",
"498274", "Buttenwiesen",
"496246", "Eich\ Rheinhessen",
"4933731", "Trebbin",
"4939392", "Rönnebeck\ Sachsen\-Anhalt",
"496561", "Bitburg",
"4933874", "Stechow\ Brandenburg",
"497128", "Sonnenbühl",
"495181", "Alfeld\ Leine",
"494732", "Stadland\-Rodenkirchen",
"497300", "Roggenburg",
"498296", "Villenbach",
"497402", "Fluorn\-Winzeln",
"492586", "Beelen",
"4939341", "Redekin",
"494929", "Ihlow\ Kreis\ Aurich",
"499622", "Hirschau\ Oberpfalz",
"499605", "Weiherhammer",
"4938429", "Glasin",
"497425", "Trossingen",
"497471", "Hechingen",
"4934467", "Eckartsberga",
"493860", "Raben\ Steinfeld",
"4934653", "Rottleberode",
"499281", "Hof\ Saale",
"495044", "Springe\-Eldagsen",
"4939406", "Harbke",
"498330", "Legau",
"498432", "Burgheim",
"496129", "Schlangenbad",
"49921", "Bayreuth",
"4938374", "Lassan\ bei\ Wolgast",
"494486", "Edewecht\-Friedrichsfehn",
"495031", "Wunstorf",
"498858", "Kochel\-Walchensee",
"4936081", "Arenshausen",
"496406", "Lollar",
"4933208", "Fahrland",
"499206", "Mistelgau\-Obernsees",
"495853", "Neu\ Darchau",
"496653", "Burghaun",
"494827", "Wacken",
"492973", "Eslohe\ Sauerland",
"496693", "Neuental",
"492501", "Münster\-Hiltrup",
"496057", "Flörsbachtal",
"497947", "Forchtenberg",
"493933", "Genthin",
"49641", "Giessen",
"492572", "Emsdetten",
"495277", "Höxter\-Fürstenau",
"4938221", "Marlow",
"492778", "Siegbach",
"494769", "Bremervörde\-Iselersheim",
"4939394", "Hohenberg\-Krusemark",
"494401", "Brake\ Unterweser",
"494472", "Lastrup",
"4933872", "Hohennauen",
"4934771", "Querfurt",
"494606", "Wanderup",
"494724", "Cuxhaven\-Lüdingworth",
"499190", "Heroldsbach",
"497275", "Kandel",
"497221", "Baden\-Baden",
"495945", "Wilsum",
"497682", "Elzach",
"498467", "Kinding",
"494222", "Ganderkesee",
"4937344", "Crottendorf\ Sachsen",
"496285", "Walldürn\-Altheim",
"494964", "Rhede\ Ems",
"492553", "Ochtrup",
"494205", "Ottersberg",
"492992", "Marsberg",
"495872", "Stoetze",
"496672", "Eiterfeld",
"492952", "Rüthen",
"494681", "Wyk\ auf\ Föhr",
"4934742", "Sylda",
"4933841", "Belzig",
"492593", "Ascheberg\ Westfalen",
"498283", "Neuburg\ an\ der\ Kammel",
"49461", "Flensburg",
"496743", "Bacharach",
"496164", "Reichelsheim\ Odenwald",
"494493", "Friesoythe\-Gehlenberg",
"494148", "Drochtersen\-Assel",
"497676", "Feldberg\ Schwarzwald",
"4938392", "Sassnitz",
"497130", "Löwenstein\ Württemberg",
"494453", "Zetel",
"495427", "Melle\-Buer",
"499179", "Freystadt",
"492305", "Castrop\-Rauxel",
"4939087", "Jerchel\ Altmark",
"498745", "Bodenkirchen",
"495584", "Hattorf\ am\ Harz",
"496755", "Odernheim\ am\ Glan",
"494829", "Wewelsfleth",
"497654", "Löffingen",
"494445", "Visbek\ Kreis\ Vechta",
"498328", "Balderschwang",
"498753", "Elsendorf\ Niederbayern",
"497949", "Pfedelbach\-Untersteinbach",
"4935439", "Zinnitz",
"496059", "Jossgrund",
"4934348", "Frohburg",
"495368", "Parsau",
"492545", "Rosendahl\-Darfeld",
"494767", "Bremervörde\-Bevern",
"499565", "Untersiemau",
"492297", "Wildbergerhütte",
"495592", "Gleichen\-Bremke",
"499188", "Postbauer\-Heng",
"4934445", "Stössen",
"495953", "Börger",
"498424", "Nassenfels",
"494927", "Krummhörn\-Loquard",
"492873", "Isselburg\-Werth",
"4937342", "Cranzahl",
"4939051", "Calvörde",
"495336", "Semmenstedt",
"499634", "Wiesau",
"495250", "Delbrück\ Westfalen",
"495552", "Katlenburg",
"492104", "Mettmann",
"492257", "Reckerscheid",
"4939221", "Möckern\ bei\ Magdeburg",
"498363", "Pfronten",
"492661", "Bad\ Marienberg\ Westerwald",
"4934901", "Rosslau\ Elbe",
"4933921", "Zechlinerhütte",
"4939778", "Ferdinandshof\ bei\ Torgelow",
"495323", "Clausthal\-Zellerfeld",
"4939400", "Wefensleben",
"494357", "Sehestedt\ Eider",
"499908", "Schöfweg",
"496127", "Niedernhausen\ Taunus",
"4935361", "Schlieben",
"492984", "Hallenberg",
"4938759", "Tewswoos",
"499641", "Grafenwöhr",
"495464", "Alfhausen",
"499269", "Tettau\ Kreis\ Kronach",
"494624", "Kropp",
"499937", "Oberpöring",
"498246", "Waal",
"496274", "Waldbrunn\ Odenwald",
"498561", "Pfarrkirchen\ Niederbayern",
"495054", "Bergen\-Sülze",
"494706", "Schiffdorf",
"496786", "Kempfeld",
"494349", "Dänischenhagen",
"495521", "Herzberg\ am\ Harz",
"499378", "Eichenbühl\-Riedern",
"492687", "Horhausen\ Westerwald",
"4933206", "Fichtenwalde",
"495843", "Wustrow\ Wendland",
"496643", "Herbstein",
"493461", "Merseburg\ Saale",
"49471", "Bremerhaven",
"496578", "Salmtal",
"493346", "Seelow",
"4936255", "Goldbach\ bei\ Gotha",
"4939084", "Lindstedt",
"497165", "Göppingen\-Hohenstaufen",
"4936025", "Körner",
"496047", "Altenstadt\ Hessen",
"497957", "Kressberg",
"4933673", "Weichensdorf",
"4937347", "Bärenstein\ Kreis\ Annaberg",
"499474", "Schmidmühlen",
"4939408", "Hadmersleben",
"4939823", "Rechlin",
"496772", "Nastätten",
"496701", "Sprendlingen\ Rheinhessen",
"495132", "Lehrte",
"497327", "Dischingen",
"492351", "Lüdenscheid",
"494667", "Dagebüll",
"497579", "Schwenningen\ Baden",
"492391", "Plettenberg",
"499232", "Wunsiedel",
"4936621", "Elsterberg\ bei\ Plauen",
"492921", "Soest",
"498057", "Aschau\-Sachrang",
"492975", "Schmallenberg\-Oberkirchen",
"495855", "Nahrendorf",
"496655", "Neuhof\ Kreis\ Fulda",
"49841", "Ingolstadt\ Donau",
"497754", "Görwihl",
"493935", "Tangerhütte",
"494251", "Hoya",
"495082", "Langlingen",
"496695", "Jesberg",
"495658", "Wehretal",
"496858", "Ottweiler\-Fürth",
"493581", "Görlitz",
"492409", "Stolberg\-Gressenich",
"492761", "Olpe\ Biggesee",
"498406", "Böhmfeld",
"4936968", "Rossdorf\ Rhön",
"497252", "Bretten",
"496898", "Völklingen",
"492842", "Kamp\-Lintfort",
"497436", "Messstetten\-Oberdigisheim",
"4939082", "Mieste",
"499741", "Bad\ Brückenau",
"497423", "Oberndorf\ am\ Neckar",
"496432", "Diez",
"499603", "Floss",
"4935478", "Goyatz",
"4939886", "Milmersdorf",
"492133", "Dormagen",
"496256", "Lampertheim\-Hüttenfeld",
"494509", "Gross\ Grönau",
"49351", "Dresden",
"497364", "Oberkochen",
"496296", "Ahorn\ Baden",
"496589", "Kell\ am\ See",
"499734", "Burkardroth",
"4934633", "Braunsbedra",
"499366", "Geroldshausen\ Unterfranken",
"494848", "Rantrum",
"495664", "Morschen",
"496864", "Mettlach",
"499441", "Kelheim",
"497736", "Tengen",
"4939396", "Neukirchen\ Altmark",
"498349", "Stötten\ am\ Auerberg",
"492461", "Jülich",
"498706", "Vilsheim",
"494561", "Neustadt\ in\ Holstein",
"4939995", "Nossendorf",
"4936744", "Remda",
"494246", "Twistringen\-Heiligenloh",
"499434", "Bodenwöhr",
"49591", "Lingen\ \(Ems\)",
"496732", "Wörrstadt",
"497723", "Furtwangen\ im\ Schwarzwald",
"495101", "Pattensen",
"497358", "Eberhardzell\-Füramoos",
"498624", "Obing",
"495172", "Ilsede",
"497260", "Sinsheim\-Hilsbach",
"497562", "Isny\ im\ Allgäu",
"495906", "Lünne",
"498781", "Rottenburg\ an\ der\ Laaber",
"4936962", "Vacha",
"496234", "Mutterstadt",
"497963", "Adelmannsfelden",
"4935053", "Glashütte\ Sachsen",
"499977", "Arnschwang",
"4939088", "Letzlingen",
"4938376", "Zirchow",
"495186", "Salzhemmendorf\-Wallensen",
"497454", "Sulz\ am\ Neckar",
"4939404", "Ausleben",
"4935472", "Schlepzig",
"495535", "Polle",
"4933933", "Lindow\ Mark",
"499338", "Röttingen\ Unterfranken",
"496241", "Worms",
"4939363", "Angern",
"496566", "Körperich",
"49871", "Landshut",
"496827", "Eppelborn",
"492620", "Neuhäusel\ Westerwald",
"4933876", "Buschow",
"499286", "Oberkotzau",
"4938797", "Karstädt\ Kreis\ Prignitz",
"498251", "Aichach",
"492581", "Warendorf",
"498291", "Zusmarshausen",
"4938851", "Zarrentin",
"49441", "Oldenburg",
"493761", "Werdau\ Sachsen",
"497476", "Bisingen",
"495023", "Liebenau\ Kreis\ Nieburg\ Weser",
"495036", "Neustadt\-Schneeren",
"494481", "Hatten\-Sandkrug",
"492173", "Langenfeld\ Rheinland",
"49251", "Münster",
"496472", "Weilmünster",
"498063", "Feldkirchen\-Westerham",
"496401", "Grünberg\ Hessen",
"4936742", "Uhlstädt",
"492804", "Xanten\-Marienbaum",
"498667", "Seeon\-Seebruck",
"497147", "Sachsenheim\ Württemberg",
"4934347", "Oelzschau\ bei\ Borna",
"499774", "Oberelsbach",
"4939777", "Borkenfriede",
"4936964", "Dermbach\ Rhön",
"492506", "Münster\-Wolbeck",
"497482", "Horb\-Dettingen",
"498509", "Ruderting",
"493391", "Neuruppin",
"4935329", "Dollenchen",
"499201", "Gesees",
"495068", "Elze\ Leine",
"499272", "Fichtelberg",
"4933969", "Stepenitz",
"498028", "Fischbachau",
"492935", "Sundern\-Hachen",
"4939402", "Völpke",
"494129", "Haseldorf",
"496359", "Grünstadt",
"4934973", "Osternienburg",
"4935474", "Schönwalde\ bei\ Lübben",
"493921", "Burg\ bei\ Magdeburg",
"494406", "Berne",
"496486", "Katzenelnbogen",
"4935775", "Pechern",
"499403", "Donaustauf",
"497623", "Rheinfelden\ Baden",
"495832", "Hankensbüttel",
"498724", "Massing",
"4934342", "Neukieritzsch",
"493322", "Falkensee",
"49203", "Duisburg",
"496347", "Hochstadt\ Pfalz",
"497636", "Münstertal\ Schwarzwald",
"4938792", "Lenzen\ \(Elbe\)",
"4962195", "Ludwigshafen",
"499255", "Marktleugast",
"495764", "Steyerberg",
"495143", "Winsen\ Aller",
"4934493", "Gössnitz\ Thüringen",
"495458", "Hopsten",
"499295", "Töpen",
"499078", "Mertingen",
"494745", "Bad\ Bederkesa",
"495924", "Bad\ Bentheim\-Gildehaus",
"498453", "Reichertshofen\ Oberbayern",
"495262", "Extertal",
"492567", "Ahaus\-Alstätte",
"4939407", "Seehausen\ Börde",
"4937348", "Oberwiesenthal\ Kurort",
"492383", "Bönen",
"496455", "Frankenau\ Hessen",
"499547", "Zapfendorf",
"4934466", "Janisroda",
"49861", "Traunstein",
"497668", "Ihringen",
"497235", "Unterreichenbach\ Kreis\ Calw",
"499656", "Moosbach\ bei\ Vohenstrauss",
"494283", "Tarmstedt",
"4939772", "Rothemühl",
"495354", "Jerxheim",
"4933601", "Podelzig",
"498681", "Waging\ am\ See",
"496203", "Ladenburg",
"498205", "Dasing",
"494467", "Wittmund\-Funnix",
"498222", "Burgau\ Schwaben",
"497159", "Renningen",
"492833", "Kerken",
"496669", "Neuhof\-Hauswurz",
"499307", "Altertheim",
"494958", "Jemgum",
"495376", "Wesendorf\ Kreis\ Gifhorn",
"4934344", "Kohren\-Sahlis",
"492228", "Remagen\-Rolandseck",
"499674", "Schönsee",
"494753", "Balje",
"4938794", "Cumlosen",
"493984", "Prenzlau",
"499162", "Scheinfeld",
"496158", "Riedstadt",
"498445", "Gerolsbach",
"494328", "Rickling",
"493661", "Greiz",
"492826", "Kranenburg\ Niederrhein",
"496198", "Eppstein",
"496443", "Ehringshausen\ Dill",
"494793", "Hambergen",
"4935477", "Rietzneuendorf\-Friedrichshof",
"492524", "Ennigerloh",
"499243", "Pottenstein",
"495155", "Emmerthal",
"495382", "Bad\ Gandersheim",
"495195", "Neuenkirchen\ bei\ Soltau",
"492263", "Engelskirchen",
"4939080", "Kalbe\ Milde",
"494363", "Lensahn",
"4936967", "Geisa",
"4939774", "Mönkebude",
"496507", "Neumagen\-Dhron",
"499089", "Bissingen\-Unterringingen",
"492051", "Velbert",
"4939831", "Feldberg",
"499482", "Wörth\ an\ der\ Donau",
"498231", "Königsbrunn\ bei\ Augsburg",
"4939743", "Zerrenthin",
"495543", "Staufenberg\ Niedersachsen",
"497685", "Gutach\-Bleibach",
"494633", "Satrup",
"494704", "Drangstedt",
"495942", "Uelsen",
"496784", "Weierbach",
"497570", "Sigmaringen\-Gutenstein",
"497272", "Rülzheim",
"496276", "Hesseneck",
"4933875", "Rhinow",
"493448", "Meuselwitz\ Thüringen",
"495056", "Winsen\-Meissendorf",
"494626", "Treia",
"495407", "Wallenhorst",
"492302", "Witten",
"498742", "Velden\ Vils",
"4933369", "Oderberg",
"4938307", "Poseritz",
"492325", "Wanne\-Eickel",
"492371", "Iserlohn",
"493629", "Stadtilm",
"493331", "Angermünde",
"498861", "Schongau",
"4937367", "Lengefeld\ Erzgebirge",
"4940", "Hamburg",
"496339", "Grosssteinhausen",
"496621", "Bad\ Hersfeld",
"496675", "Breitenbach\ am\ Herzberg",
"495875", "Emmendorf",
"495821", "Bad\ Bevensen",
"492955", "Büren\-Wewelsburg",
"4933239", "Gross\ Behnitz",
"494202", "Achim\ bei\ Bremen",
"494271", "Sulingen",
"498548", "Vilshofen\-Sandbach",
"493344", "Bad\ Freienwalde",
"496580", "Zemmer",
"497774", "Eigeltingen",
"499147", "Nennslingen",
"496282", "Walldürn",
"4939996", "Törpin",
"499562", "Sonnefeld",
"493881", "Grevesmühlen",
"499260", "Wilhelmsthal\ Oberfranken",
"496558", "Büdesheim\ Eifel",
"492943", "Erwitte",
"49335", "Frankfurt\ \(Oder\)",
"497977", "Oberrot\ bei\ Gaildorf",
"499963", "Konzell",
"495247", "Harsewinkel",
"492542", "Gescher",
"493504", "Dippoldiswalde",
"499454", "Aufhausen\ Oberpfalz",
"494442", "Lohne\ Oldenburg",
"494340", "Achterwehr",
"4939459", "Hasselfelde",
"4939395", "Wanzer",
"49381", "Rostock",
"496752", "Kirn\ Nahe",
"496294", "Krautheim\ Jagst",
"497366", "Abtsgmünd",
"499736", "Oberthulba",
"497441", "Freudenstadt",
"4938729", "Marnitz",
"495074", "Rodewald",
"494187", "Holm\-Seppensen",
"496107", "Kelsterbach",
"496254", "Lautertal\ Odenwald",
"499928", "Kirchdorf\ im\ Wald",
"495303", "Wendeburg",
"499398", "Birkenfeld\ bei\ Würzburg",
"4933333", "Tantow",
"495555", "Moringen\-Fredelsloh",
"497434", "Winterlingen",
"499723", "Röthlein",
"4938375", "Koserow",
"4936948", "Römhild",
"499358", "Gössenheim",
"498404", "Oberdolling",
"496362", "Alsenz",
"492853", "Schermbeck",
"494938", "Hagermarsch",
"495973", "Neuenkirchen\ Kreis\ Steinfurt",
"494161", "Buxtehude",
"497243", "Ettlingen",
"495572", "Bodenfelde",
"493969", "Siedenbollentin",
"496050", "Biebergemünd",
"497940", "Künzelsau",
"496138", "Mommenheim",
"494733", "Butjadingen\-Burhave",
"494604", "Grossenwiehe",
"4939978", "Gross\ Roge",
"496684", "Hofbieber\-Schwarzbach",
"495135", "Burgwedel\-Fuhrberg",
"497307", "Senden\ Iller",
"495586", "Wieda",
"496775", "Strüth\ Taunus",
"496721", "Bingen\ am\ Rhein",
"496166", "Fischbachtal",
"4939853", "Holzendorf\ bei\ Prenzlau",
"498773", "Neufahrn\ in\ Niederbayern",
"493867", "Lübstorf",
"497674", "Todtmoos",
"4933984", "Blumenthal\ bei\ Pritzwalk",
"495259", "Bad\ Driburg\-Neuenheerse",
"498337", "Altenstadt\ Iller",
"4938304", "Garz\ Rügen",
"498642", "Übersee",
"497162", "Süssen",
"494966", "Neubörger",
"4937364", "Reitzenhain\ Erzgebirge",
"4936940", "Oepfershausen",
"495085", "Burgdorf\-Ehlershausen",
"496692", "Neustadt\ Hessen",
"49211", "Düsseldorf",
"492573", "Nordwalde",
"4938231", "Barth",
"4962196", "Ludwigshafen",
"492972", "Schmallenberg",
"496652", "Hünfeld",
"493533", "Elsterwerda",
"495852", "Bleckede",
"497656", "Schluchsee",
"499199", "Kunreuth",
"4936651", "Lobenstein",
"499235", "Thierstein",
"49209", "Gelsenkirchen",
"494473", "Emstek",
"492181", "Grevenbroich",
"495438", "Bakum\-Lüsche",
"498433", "Königsmoos",
"495341", "Salzgitter",
"4935341", "Bad\ Liebenwerda",
"494529", "Süsel\-Bujendorf",
"495466", "Merzen",
"4933982", "Hoppenrade\ Kreis\ Prignitz",
"497403", "Dunningen",
"496435", "Wallmerod",
"495334", "Hornburg\ Kreis\ Wolfenbüttel",
"492845", "Neukirchen\-Vluyn",
"497255", "Graben\-Neudorf",
"4938302", "Sagard",
"499636", "Plössberg",
"499170", "Schwanstetten",
"4934465", "Bad\ Bibra",
"492429", "Hürtgenwald",
"497139", "Neuenstadt\ am\ Kocher",
"4937362", "Seiffen\ Erzgebirge",
"498426", "Walting\ Kreis\ Eichstätt",
"499865", "Adelshofen\ Mittelfranken",
"497703", "Bonndorf\ im\ Schwarzwald",
"495121", "Hildesheim",
"495175", "Lehrte\-Arpke",
"492867", "Heiden\ Kreis\ Borken",
"496660", "Steinau\-Marjoss",
"496735", "Eppelsheim",
"499847", "Ergersheim",
"496039", "Karben",
"498733", "Mengkofen",
"495766", "Rehburg\-Loccum",
"498377", "Unterthingau",
"497634", "Sulzburg",
"4937465", "Tannenbergsthal\ Vogtland",
"496215", "Ludwigshafen",
"4934362", "Mügeln\ bei\ Oschatz",
"498726", "Schönau\ Niederbayern",
"498161", "Freising",
"497641", "Emmendingen",
"495933", "Lathen",
"492237", "Kerpen\ Rheinland\-Türnich",
"495532", "Stadtoldendorf",
"499654", "Pleystein",
"494642", "Kappeln\ Schlei",
"495356", "Helmstedt\-Barmke",
"4934446", "Grosskorbetha",
"494337", "Jevenstedt",
"4938308", "Göhren\ Rügen",
"4935792", "Ossling",
"494773", "Lamstedt",
"4935023", "Bad\ Gottleuba",
"499080", "Harburg\ Schwaben",
"4937368", "Deutschneudorf",
"4939033", "Wallstawe",
"497565", "Aichstetten\ Kreis\ Ravensburg",
"495926", "Engden",
"492824", "Kalkar",
"496062", "Erbach\ Odenwald",
"4936373", "Buttstädt",
"4936649", "Gefell\ bei\ Schleiz",
"496475", "Weilmünster\-Wolfenhausen",
"496421", "Marburg",
"4934364", "Wermsdorf",
"495374", "Isenbüttel",
"499676", "Winklarn",
"4938821", "Lüdersdorf",
"4939972", "Walkendorf",
"495607", "Fuldatal",
"497066", "Bad\ Rappenau\-Bonfeld",
"494426", "Wangerland\-Horumersiel",
"493901", "Salzwedel",
"492533", "Münster\-Nienberge",
"493573", "Senftenberg",
"494109", "Tangstedt\ Bz\ Hamburg",
"492932", "Neheim\-Hüsten",
"4936947", "Jüchsen",
"499275", "Speichersdorf",
"499221", "Kulmbach",
"492526", "Sendenhorst",
"499682", "Erbendorf",
"494433", "Dötlingen",
"497150", "Korntal\-Münchingen",
"497485", "Empfingen",
"4936465", "Oberndorf\ bei\ Apolda",
"492331", "Hagen\ Westfalen",
"499292", "Konradsreuth",
"4933769", "Töpchin",
"496268", "Hüffenhardt",
"4936764", "Neuhaus\-Schierschnitz",
"493302", "Hennigsdorf",
"4939977", "Jördenstorf",
"499252", "Helmbrechts",
"497741", "Tiengen\ Hochrhein",
"499436", "Nittenau",
"494244", "Harpstedt",
"4938223", "Saal\ Vorpom",
"493371", "Luckenwalde",
"499423", "Geiselhöring",
"496635", "Kirtorf",
"4935975", "Hohnstein",
"498704", "Altdorf\-Pfettrach",
"495835", "Wahrenholz",
"499364", "Zellingen",
"498633", "Tüssling",
"497734", "Gailingen",
"4934773", "Schwittersdorf",
"496866", "Perl\-Nennig",
"494231", "Verden\ Aller",
"498271", "Meitingen",
"498225", "Jettingen\-Scheppach",
"4939885", "Jakobshagen",
"497389", "Heroldstatt",
"4939343", "Jerichow",
"494673", "Joldelund",
"496838", "Saarwellingen",
"498202", "Althegnenberg",
"496564", "Neuerburg\ Eifel",
"4934651", "Rossla",
"495184", "Freden\ Leine",
"497456", "Haiterbach",
"496223", "Neckargemünd",
"497232", "Königsbach\-Stein",
"496236", "Neuhofen\ Pfalz",
"494861", "Tönning",
"496452", "Battenberg\ Eder",
"494120", "Ellerhoop",
"492153", "Nettetal\-Lobberich",
"499468", "Zell\ Oberpfalz",
"4936083", "Uder",
"492193", "Dabringhausen",
"495265", "Dörentrup",
"492448", "Hellenthal\-Rescheid",
"494742", "Dorum",
"495904", "Lengerich\ Emsl",
"499776", "Mellrichstadt",
"498809", "Wessobrunn",
"499165", "Sugenheim",
"495707", "Petershagen\ Weser",
"498442", "Wolnzach",
"498340", "Baisweil",
"495034", "Neustadt\-Hagen",
"494308", "Schwedeneck",
"4936762", "Steinach\ Thüringen",
"497839", "Schapbach",
"4933205", "Michendorf",
"4933733", "Stülpe",
"492208", "Niederkassel",
"497474", "Haigerloch",
"499284", "Schwarzenbach\ an\ der\ Saale",
"495041", "Springe\ Deister",
"497269", "Sulzfeld\ Baden",
"4936701", "Lichte",
"496527", "Oberweis",
"494404", "Elsfleth",
"493542", "Lübbenau\ Spreewald",
"4935797", "Schwepnitz",
"496484", "Beselich",
"4935609", "Drachhausen",
"497937", "Dörzbach",
"493943", "Wernigerode",
"49281", "Wesel",
"4938300", "Insel\ Hiddensee",
"495192", "Munster",
"492504", "Telgte",
"495152", "Hessisch\ Oldendorf",
"4936944", "Rentwertshausen",
"4936256", "Wechmar",
"4937360", "Olbernhau",
"4936026", "Struth\ bei\ Mühlhausen",
"497962", "Fichtenau",
"494721", "Cuxhaven",
"494775", "Grossenwörden",
"497224", "Gernsbach",
"495506", "Adelebsen",
"497387", "Hohenstein\ Württemberg",
"4939053", "Süplingen",
"497563", "Kisslegg",
"498178", "Icking",
"4939223", "Theessen",
"494166", "Ahlerstedt",
"4933923", "Flecken\ Zechlin",
"4934903", "Coswig\ Anhalt",
"495935", "Twist\-Schöninghsdorf",
"4935363", "Fermerswalde",
"496161", "Brensbach",
"492627", "Braubach",
"497528", "Neukirch\ bei\ Tettnang",
"4939997", "Jarmen",
"496726", "Lorch\ Rheingau",
"497722", "Triberg\ im\ Schwarzwald",
"498039", "Rott\ am\ Inn",
"494961", "Papenburg",
"496733", "Gau\-Odernheim",
"497705", "Wolterdingen\ Schwarzw",
"495173", "Uetze",
"49551", "Göttingen",
"494138", "Betzendorf\ Kreis\ Lüneburg",
"494684", "Langeness\ Hallig",
"495804", "Rätzlingen\ Kreis\ Uelzen",
"498735", "Gangkofen\-Kollbach",
"4936020", "Ebeleben",
"4937366", "Rübenau",
"4939329", "Möringen",
"497267", "Gemmingen",
"499273", "Bad\ Berneck\ im\ Fichtelgebirge",
"497483", "Horb\-Mühringen",
"494435", "Grossenkneten",
"4938306", "Samtens",
"499857", "Schopfloch\ Mittelfranken",
"497939", "Schrozberg\-Spielbach",
"4933843", "Niemegk",
"492535", "Sendenhorst\-Albersloh",
"496008", "Echzell",
"4933986", "Falkenhagen\ Kreis\ Prignitz",
"493521", "Meissen",
"497651", "Titisee\-Neustadt",
"4939775", "Ahlbeck\ bei\ Torgelow",
"498807", "Diessen\ am\ Ammersee",
"492664", "Rennerod",
"4934345", "Bad\ Lausick",
"495022", "Wietzen",
"492981", "Winterberg\ Westfalen",
"497837", "Oberharmersbach",
"495346", "Liebenburg",
"493843", "Güstrow",
"499644", "Pressath",
"495461", "Bramsche\ Hase",
"49291", "Meschede",
"498421", "Eichstätt\ Bayern",
"496473", "Leun",
"499631", "Tirschenreuth",
"498062", "Bruckmühl\ Mangfall",
"4936028", "Kammerforst\ Thüringen",
"492382", "Ahlen\ Westfalen",
"495524", "Bad\ Lauterberg\ im\ Harz",
"4936258", "Friemar",
"498236", "Fischach",
"499947", "Neukirchen\ bei\ Hl\ Blut",
"495263", "Barntrup",
"492195", "Radevormwald",
"498452", "Geisenfeld",
"4935772", "Rietschen",
"494621", "Schleswig",
"494339", "Christiansholm",
"497808", "Hohberg\ bei\ Offenburg",
"498223", "Ichenhausen",
"494282", "Sittensen",
"4939405", "Hötensleben",
"496271", "Eberbach\ Baden",
"496202", "Schwetzingen",
"498564", "Johanniskirchen",
"496500", "Waldrach",
"495051", "Bergen\ Kreis\ Celle",
"496633", "Homberg\ Ohm",
"497622", "Schopfheim",
"495833", "Brome",
"499402", "Regenstauf",
"499471", "Burglengenfeld",
"495228", "Vlotho\-Exter",
"49234", "Bochum",
"498379", "Waltenhofen\-Oberdorf",
"498635", "Pleiskirchen",
"493592", "Kirschau",
"496704", "Langenlonsheim",
"4936623", "Berga\ Elster",
"49721", "Karlsruhe",
"498268", "Tussenhausen",
"493464", "Sangerhausen",
"494276", "Borstel\ bei\ Sulingen",
"4939994", "Metschow",
"495142", "Eschede",
"496626", "Wildeck\-Obersuhl",
"495826", "Suderburg",
"492924", "Möhnesee",
"492262", "Wiehl",
"494294", "Riede\ Kreis\ Verden",
"497751", "Waldshut",
"493886", "Gadebusch",
"4936965", "Stadtlengsfeld",
"494107", "Siek\ Kreis\ Stormarn",
"494254", "Eystrup",
"495383", "Lutter\ am\ Barenberge",
"499242", "Gössweinstein",
"496187", "Schöneck",
"4933671", "Lieberose",
"492354", "Meinerzhagen",
"4935774", "Boxberg\ Sachsen",
"4939821", "Carpin",
"494362", "Heiligenhafen",
"499128", "Feucht",
"492394", "Neuenrade\-Affeln",
"4935475", "Straupitz",
"494558", "Todesfelde",
"497361", "Aalen",
"492832", "Kevelaer",
"497446", "Lossburg",
"496340", "Wörth\-Schaidt",
"496442", "Braunfels",
"492764", "Welschen\ Ennest",
"498388", "Hergensweiler",
"494792", "Worpswede",
"494752", "Neuhaus\ Oste",
"496809", "Grossrosseln",
"495609", "Ahnatal",
"499163", "Dachsbach",
"499744", "Zeitlofs\-Detter",
"4939992", "Görmin",
"494564", "Schashagen",
"492953", "Wünnenberg",
"494920", "Wirdum",
"496673", "Haunetal",
"4936254", "Friedrichswerth",
"494838", "Tellingstedt",
"4936946", "Erbenhausen\ Thüringen",
"495873", "Eimke",
"497309", "Weissenhorn",
"4939085", "Zichtau",
"4936024", "Diedorf\ bei\ Mühlhausen",
"492592", "Selm",
"498282", "Krumbach\ Schwaben",
"497746", "Wutöschingen",
"499431", "Schwandorf",
"492552", "Steinfurt\-Borghorst",
"495257", "Hövelhof",
"494223", "Ganderkesee\-Bookholzberg",
"493869", "Dümmer",
"492993", "Marsberg\-Canstein",
"498621", "Trostberg",
"492336", "Schwelm",
"4939959", "Dargun",
"492323", "Herne",
"494452", "Zetel\-Neuenburg",
"496120", "Aarbergen",
"496861", "Merzig",
"494236", "Kirchlinteln",
"495661", "Melsungen",
"492758", "Bad\ Berleburg\-Girkhausen",
"499444", "Siegenburg",
"496742", "Boppard",
"492464", "Aldenhoven\ bei\ Jülich",
"494492", "Saterland",
"493727", "Mittweida",
"497451", "Horb\ am\ Neckar",
"4933451", "Heckelberg",
"496244", "Westhofen\ Rheinhessenen",
"498276", "Baar\ Schwaben",
"493382", "Lehnin",
"4938853", "Drönnewitz\ bei\ Hagenow",
"493967", "Oertzenhof\ bei\ Strasburg",
"494268", "Bötersen",
"494635", "Sörup",
"497683", "Simonswald",
"498784", "Hohenthann",
"495545", "Hedemünden",
"492368", "Oer\-Erkenschwick",
"496231", "Hochdorf\-Assenheim",
"499348", "Werbach\-Gamburg",
"4939998", "Loitz\ bei\ Demmin",
"494484", "Hude\-Wüsting",
"4936022", "Grossengottern",
"498460", "Berching\-Holnstein",
"496404", "Lich\ Hessen",
"498362", "Füssen",
"494527", "Bosau",
"495553", "Kalefeld",
"4936252", "Tambach\-Dietharz",
"49212", "Solingen",
"492801", "Xanten",
"495593", "Bovenden\-Lenglern",
"499725", "Poppenhausen\ Unterfranken",
"499771", "Bad\ Neustadt\ an\ der\ Saale",
"492872", "Rhede\ Westfalen",
"495952", "Sögel",
"498254", "Altomünster",
"495305", "Sickte",
"4933931", "Rheinsberg\ Mark",
"493764", "Meerane",
"4939361", "Lüderitz",
"498294", "Horgau",
"492584", "Warendorf\-Milte",
"492427", "Nideggen",
"495322", "Bad\ Harzburg",
"498752", "Au\ in\ der\ Hallertau",
"496308", "Olsbrücken",
"4936766", "Schalkau",
"492945", "Lippstadt\-Benninghausen",
"493394", "Wittstock\ Dosse",
"499197", "Egloffstein",
"498558", "Hohenau\ Niederbayern",
"499204", "Plankenfels",
"499157", "Alfeld\ Mittelfranken",
"499965", "Sankt\ Englmar",
"495761", "Stolzenau",
"495409", "Hilter\ am\ Teutoburger\ Wald",
"495126", "Algermissen",
"4935796", "Panschwitz\-Kuckau",
"496642", "Schlitz",
"495842", "Schnega",
"497557", "Herdwangen\-Schönach",
"496773", "Kamp\-Bornhofen",
"4936027", "Lengenfeld\ Unterm\ Stein",
"498166", "Allershausen\ Oberbayern",
"4936257", "Luisenthal\ Thüringen",
"4935823", "Ostritz",
"497646", "Weisweil\ Breisgau",
"496337", "Grossbundenbach",
"494178", "Radbruch",
"499149", "Weissenburg\-Suffersheim",
"498721", "Eggenfelden",
"4939833", "Mirow\ Kreis\ Neustrelitz",
"49906", "Donauwörth",
"494735", "Butjadingen\-Stollhamm",
"495351", "Helmstedt",
"498684", "Fridolfing",
"498138", "Schwabhausen\ bei\ Dachau",
"497245", "Durmersheim",
"495975", "Rheine\-Mesum",
"495921", "Nordhorn",
"492855", "Voerde\ Niederrhein",
"493981", "Neustrelitz",
"4934745", "Winningen\ Sachsen\-Anhalt",
"497253", "Bad\ Schönborn",
"496426", "Fronhausen",
"492843", "Rheinberg",
"4934444", "Lützen",
"497950", "Schnelldorf",
"496109", "Frankfurt\-Bergen\-Enkheim",
"494189", "Undeloh",
"4934299", "Gaschwitz",
"4933603", "Falkenhagen\ bei\ Seelow",
"498435", "Ehekirchen",
"492132", "Meerbusch\-Büderich",
"4938459", "Laage",
"499602", "Neustadt\ an\ der\ Waldnaab",
"496433", "Hadamar",
"497422", "Schramberg",
"49391", "Magdeburg",
"499625", "Kastl\ bei\ Amberg",
"499671", "Oberviechtach",
"499233", "Arzberg\ Oberfranken",
"4939976", "Gross\ Bützin",
"494421", "Wilhelmshaven",
"494475", "Molbergen",
"492054", "Essen\-Kettwig",
"499828", "Rügland",
"492575", "Greven\-Reckenfeld",
"492521", "Beckum",
"498652", "Berchtesgaden",
"495083", "Hohne\ bei\ Celle",
"492680", "Mündersbach",
"496887", "Schmelz\ Saar",
"493535", "Herzberg\ Elster",
"4934491", "Schmölln\ Thüringen",
"499392", "Faulbach\ Unterfranken",
"4939081", "Kakerbeck\ Sachsen\-Anhalt",
"494344", "Schönberg\ Holstein",
"499536", "Kirchlauter",
"499352", "Lohr\ am\ Main",
"499185", "Mühlhausen\ Oberpfalz",
"4934975", "Görzig\ Kreis\ Köthen",
"492244", "Königswinter\-Oberpleis",
"4933847", "Görzke",
"497854", "Kehl\-Goldscheuer",
"499523", "Hofheim\ in\ Unterfranken",
"4938789", "Wolfshagen\ bei\ Perleberg",
"494331", "Rendsburg",
"499905", "Bernried\ Niederbayern",
"4935773", "Schleife",
"4930", "Berlin",
"499922", "Zwiesel",
"499264", "Küps",
"4935820", "Zodel",
"495755", "Kalletal\-Varenholz",
"498302", "Görisried",
"496464", "Angelburg",
"499841", "Bad\ Windsheim",
"492742", "Wissen",
"4936622", "Triebes",
"494193", "Henstedt\-Ulzburg",
"498325", "Oberstaufen\-Thalkirchdorf",
"495127", "Harsum",
"494153", "Lauenburg\ Elbe",
"497332", "Lauterstein",
"496323", "Edenkoben",
"496758", "Waldböckelheim",
"497556", "Uhldingen\-Mühlhofen",
"492861", "Borken\ Westfalen",
"499762", "Saal\ an\ der\ Saale",
"499568", "Neustadt\ bei\ Coburg",
"499834", "Theilenhofen",
"496552", "Olzheim",
"498167", "Zolling",
"496336", "Dellfeld",
"4939746", "Krackow",
"492673", "Ellenz\-Poltersdorf",
"497043", "Maulbronn",
"495365", "Wolfsburg\-Neindorf",
"492548", "Dülmen\-Rorup",
"496592", "Daun",
"4933336", "Passow\ Kreis\ Uckermark",
"497055", "Neuweiler\ Kreis\ Calw",
"493907", "Gardelegen",
"4933927", "Linum",
"4934907", "Jeber\-Bergfrieden",
"494208", "Grasberg",
"498542", "Ortenburg",
"4935055", "Höckendorf\ bei\ Dippoldiswalde",
"492308", "Unna\-Hemmerde",
"497574", "Gammertingen",
"4939057", "Rätzlingen\ Sachsen\-Anhalt",
"495686", "Schwarzenborn\ Knüll",
"499227", "Neuenmarkt",
"4939365", "Bellingen\ bei\ Stendal",
"494806", "Sarzbüttel",
"499384", "Schwanfeld",
"4938858", "Lassahn",
"496584", "Wellen\ Mosel",
"4936624", "Teichwolframsdorf",
"496427", "Cölbe\-Schönstadt",
"494504", "Ratekau",
"495164", "Hodenhagen",
"495743", "Espelkamp\-Gestringen",
"4934609", "Salzmünde",
"49481", "Heide\ Holstein",
"495601", "Schauenburg",
"4939993", "Hohenmocker",
"494881", "Friedrichstadt",
"498124", "Forstern\ Oberbayern",
"495672", "Bad\ Karlshafen",
"496872", "Losheim\ am\ See",
"495948", "Itterbeck",
"495285", "Bad\ Pyrmont\-Kleinenberg",
"492404", "Alsdorf\ Rheinland",
"495695", "Twistetal",
"4939052", "Erxleben\ bei\ Haldensleben",
"496082", "Niederreifenberg",
"4933844", "Brück\ Brandenburg",
"4939222", "Möser",
"4937341", "Ehrenfriedersdorf",
"495655", "Wanfried",
"4936849", "Kleinschmalkalden",
"493966", "Cölpin",
"496855", "Freisen",
"4938466", "Jürgenshagen",
"4935362", "Schönewalde\ bei\ Herzberg",
"4933922", "Karwesee",
"4933608", "Jacobsdorf\ Mark",
"4939856", "Beenz\ bei\ Prenzlau",
"4938850", "Gammelin",
"493733", "Annaberg\-Buchholz",
"493377", "Zossen\ Brandenburg",
"497747", "Berau",
"499174", "Hilpoltstein",
"492773", "Haiger",
"499803", "Colmberg",
"495432", "Löningen",
"492337", "Hagen\-Dahl",
"492642", "Remagen",
"497072", "Gomaringen",
"496698", "Schrecksbach",
"494237", "Bendingbostel",
"497465", "Emmingen\-Liptingen",
"499662", "Vilseck",
"495858", "Hitzacker\-Wietzetze",
"493726", "Flöha",
"498031", "Rosenheim\ Oberbayern",
"496658", "Poppenhausen\ Wasserkuppe",
"497931", "Bad\ Mergentheim",
"4939224", "Büden",
"49811", "Hallbergmoos",
"498573", "Ering",
"4939054", "Flechtingen",
"4934741", "Frose",
"496575", "Landscheid",
"497944", "Kupferzell",
"496054", "Birstein",
"4936929", "Ruhla",
"495274", "Nieheim",
"499196", "Wiesenttal",
"4935364", "Lebusa",
"493529", "Heidenau\ Sachsen",
"499156", "Neuhaus\ an\ der\ Pegnitz",
"4933924", "Rägelin",
"496094", "Weibersbrunn",
"4934904", "Oranienbaum",
"4938391", "Altenkirchen\ Rügen",
"494824", "Krempe",
"4935828", "Reichenbach\ OL",
"492433", "Hückelhoven",
"496132", "Ingelheim\ am\ Rhein",
"497123", "Metzingen\ Württemberg",
"494526", "Ascheberg\ Holstein",
"495772", "Espelkamp",
"499951", "Landau\ an\ der\ Isar",
"493473", "Aschersleben\ Sachsen\-Anhalt",
"499639", "Mähring",
"498845", "Bad\ Kohlgrub",
"494932", "Norderney",
"498106", "Vaterstetten",
"499375", "Freudenberg\ Baden",
"499321", "Kitzingen",
"497585", "Ostrach",
"494533", "Reinfeld\ Holstein",
"497136", "Bad\ Friedrichshall",
"495643", "Borgentreich",
"492426", "Nörvenich",
"4934495", "Dobitschen",
"496843", "Gersheim",
"497343", "Buch\ bei\ Illertissen",
"4935026", "Dürrröhrsdorf\-Dittersbach",
"493773", "Johanngeorgenstadt",
"498867", "Rottenbuch\ Oberbayern",
"492604", "Nassau\ Lahn",
"4934443", "Teuchern",
"499134", "Neunkirchen\ am\ Brand",
"495065", "Sibbesse",
"493337", "Biesenthal\ Brandenburg",
"4933848", "Raben",
"492733", "Hilchenbach",
"4939036", "Binde",
"495401", "Georgsmarienhütte",
"495769", "Steyerberg\-Voigtei",
"495472", "Bad\ Essen",
"492377", "Wickede\ Ruhr",
"496036", "Wölfersheim",
"494893", "Hohenaspe",
"497032", "Herrenberg",
"496023", "Alzenau\ in\ Unterfranken",
"499141", "Weissenburg\ in\ Bayern",
"494277", "Schwaförden",
"4939832", "Wesenberg",
"492161", "Mönchengladbach",
"4933604", "Lebus",
"494853", "Sankt\ Michaelisdonn",
"498071", "Wasserburg\ am\ Inn",
"498025", "Miesbach",
"496627", "Nentershausen\ Hessen",
"4935822", "Hagenwerder",
"492938", "Ense",
"495827", "Unterlüss",
"497154", "Kornwestheim",
"498237", "Aindling",
"499946", "Hohenwarth\ bei\ Kötzing",
"497194", "Spiegelberg",
"496068", "Beerfelden",
"499092", "Wemding",
"496172", "Bad\ Homburg\ von\ der\ Höhe",
"498824", "Oberau\ Loisach",
"492473", "Simmerath",
"4939058", "Uthmöden",
"494181", "Buchholz\ in\ der\ Nordheide",
"496101", "Bad\ Vilbel",
"495732", "Löhne",
"493433", "Borna\ Stadt",
"497447", "Baiersbronn\-Schwarzenberg",
"494972", "Langeoog",
"497765", "Rickenbach\ Hotzenwald",
"499335", "Aub\ Kreis\ Würzburg",
"4939771", "Ueckermünde",
"4933928", "Wildberg\ Brandenburg",
"495864", "Jameln",
"496664", "Sinntal\-Sterbfritz",
"4933602", "Alt\ Zeschdorf",
"497176", "Spraitbach",
"497971", "Gaildorf",
"499084", "Bissingen\ Schwaben",
"4934341", "Geithain",
"498533", "Rotthalmünster",
"495241", "Gütersloh",
"496535", "Osann\-Monzel",
"494106", "Quickborn\ Kreis\ Pinneberg",
"497503", "Wilhelmsdorf\ Württemberg",
"496186", "Grosskrotzenburg",
"494845", "Ostenfeld\ Husum",
"497182", "Welzheim",
"4936376", "Straussfurt",
"497355", "Hochdorf\ Riss",
"495234", "Horn\-Bad\ Meinberg",
"4938791", "Bad\ Wilsnack",
"497395", "Ehingen\-Dächingen",
"492529", "Oelde\-Stromberg",
"498629", "Palling",
"4939050", "Bartensleben",
"492626", "Selters\ Westerwald",
"495443", "Lemförde",
"495198", "Schneverdingen\-Wintermoor",
"498331", "Memmingen",
"493861", "Plate",
"4937609", "Wolkenburg\ Mulde",
"499280", "Selbitz\ Oberfranken",
"495158", "Hemeringen",
"499439", "Neunburg\-Kemnath",
"4933607", "Briesen\ Mark",
"496727", "Gensingen",
"499874", "Neuendettelsau",
"4939346", "Tucheim",
"498344", "Westendorf\ bei\ Kaufbeuren",
"4933920", "Walsleben\ bei\ Neuruppin",
"4934635", "Bad\ Lauchstädt",
"496869", "Merzig\-Silwingen",
"492633", "Brohl\-Lützing",
"499103", "Cadolzburg",
"4939401", "Neuwegersleben",
"492225", "Meckenheim\ Rheinland",
"492271", "Bergheim\ Erft",
"4938852", "Wittenburg",
"492202", "Bergisch\ Gladbach",
"495507", "Ebergötzen",
"497386", "Hayingen",
"4934929", "Straach",
"499576", "Lichtenfels\-Isling",
"4934776", "Rothenschirmbach",
"494955", "Westoverledingen",
"497459", "Nagold\-Hochdorf",
"494167", "Apensen",
"4939209", "Wanzleben",
"496239", "Bobenheim\-Roxheim",
"498153", "Wessling",
"496195", "Kelkheim\ Taunus",
"496382", "Lauterecken",
"496155", "Griesheim\ Hessen",
"4938226", "Dierhagen\ Ostseebad",
"498193", "Geltendorf",
"494371", "Burg\ auf\ Fehmarn",
"4936741", "Bad\ Blankenburg",
"494302", "Kirchbarkau",
"498806", "Utting\ am\ Ammersee",
"499779", "Nordheim\ von\ der\ Rhön",
"497665", "March\ Breisgau",
"498145", "Mammendorf",
"496458", "Rosenthal\ Hessen",
"499360", "Thüngen",
"499462", "Falkenstein\ Oberpfalz",
"496764", "Rheinböllen",
"497836", "Schiltach",
"495347", "Burgdorf\ bei\ Salzgitter",
"4936023", "Horsmar",
"499075", "Glött",
"4936961", "Bad\ Liebenstein",
"4935827", "Nieder\-Seifersdorf",
"4936253", "Georgenthal\ Thüringer\ Wald",
"494748", "Stubben\ bei\ Bremerhaven",
"494542", "Mölln\ Lauenburg",
"494240", "Syke\-Heiligenfelde",
"4939825", "Wokuhl",
"497823", "Seelbach\ Schutter",
"495632", "Willingen\ Upland",
"496832", "Beckingen\-Reimsbach",
"499554", "Untersteinbach\ Unterfranken",
"4933675", "Tauche",
"498208", "Eurasburg\ bei\ Augsburg",
"494943", "Grossefehn",
"4935471", "Birkenhainchen",
"497541", "Friedrichshafen",
"4936628", "Zeulenroda",
"4938854", "Redefin",
"496394", "Bundenthal",
"497266", "Kirchardt",
"495203", "Werther\ Westfalen",
"494124", "Glückstadt",
"499856", "Dürrwangen",
"497534", "Reichenau\ Baden",
"49881", "Weilheim\ in\ Oberbayern",
"495455", "Tecklenburg\-Brochterbeck",
"498504", "Tittling",
"496262", "Aglasterhausen",
"495495", "Vörden\ Kreis\ Vechta",
"495509", "Rosdorf\ Kreis\ Göttingen",
"4938220", "Wustrow\ Ostseebad",
"493961", "Altentreptow",
"494169", "Sauensiek",
"497457", "Rottenburg\-Ergenzingen",
"4936378", "Ostramondra",
"499974", "Traitsching",
"496237", "Maxdorf",
"495028", "Pennigsehl",
"497081", "Bad\ Wildbad",
"496002", "Ober\-Mörlen",
"4939852", "Schönermark\ bei\ Prenzlau",
"495251", "Paderborn",
"4934906", "Raguhn",
"496071", "Dieburg",
"4933926", "Herzberg\ Mark",
"4933337", "Altkünkendorf",
"498023", "Bayrischzell",
"494855", "Eddelak",
"495063", "Bad\ Salzdetfurth",
"4938462", "Baumgarten",
"498036", "Stephanskirchen\ Simssee",
"493721", "Meinersdorf",
"4939389", "Schollene",
"4938209", "Sanitz\ bei\ Rostock",
"497345", "Langenau\ Württemberg",
"4939226", "Hohenziatz",
"4939056", "Klüden",
"496867", "Perl",
"492735", "Neunkirchen\ Siegerl",
"496526", "Bollendorf",
"497728", "Niedereschach",
"497353", "Schwendi",
"494132", "Amelinghausen",
"497393", "Munderkingen",
"497936", "Schrozberg\-Bartenstein",
"498535", "Haarbach",
"4938825", "Klütz",
"499151", "Hersbruck",
"494843", "Viöl",
"49571", "Minden\ Westfalen",
"497505", "Fronreute",
"4939747", "Züsedom",
"499191", "Forchheim\ Oberfranken",
"497220", "Forbach\-Hundsbach",
"496533", "Morbach\ Hunsrück",
"497522", "Wangen\ im\ Allgäu",
"498664", "Chieming",
"4933983", "Gross\ Pankow\ Kreis\ Prignitz",
"499333", "Sommerhausen",
"4939854", "Kleptow",
"499777", "Ostheim\ von\ der\ Rhön",
"497144", "Marbach\ am\ Neckar",
"497763", "Murg",
"495706", "Porta\ Westfalica",
"499956", "Eichendorf\-Aufhausen",
"494521", "Eutin",
"4939038", "Henningen",
"492421", "Düren",
"4938464", "Bernitt",
"4937363", "Zöblitz",
"497131", "Heilbronn\ Neckar",
"4933846", "Dippmannsdorf",
"495624", "Bad\ Emstal",
"496824", "Ottweiler",
"499326", "Markt\ Einersheim",
"4935028", "Krippen",
"493435", "Oschatz",
"4938303", "Sellin\ Ostseebad",
"499531", "Ebern",
"498382", "Lindau\ Bodensee",
"4936461", "Bad\ Sulza",
"494464", "Wittmund\-Carolinensiel",
"4939742", "Brüssow\ bei\ Pasewalk",
"492236", "Wesseling\ Rheinland",
"494758", "Nordleda",
"494323", "Bornhöved",
"498195", "Weil\ Kreis\ Landsberg\ am\ Lech",
"492452", "Heinsberg\ Rheinland",
"495357", "Grasleben",
"498239", "Langenneufnach",
"4935971", "Sebnitz",
"499544", "Baunach",
"494336", "Owschlag",
"494552", "Leezen",
"492223", "Königswinter",
"4936626", "Auma",
"494953", "Bunde",
"492564", "Vreden",
"492838", "Sonsbeck",
"498869", "Kinsau",
"492866", "Dorsten\-Rhade",
"493675", "Sonneberg\ Thüringen",
"493621", "Gotha\ Thüringen",
"4939881", "Ringenwalde\ bei\ Templin",
"497551", "Überlingen\ Bodensee",
"499846", "Ipsheim",
"492379", "Menden\-Asbeck",
"499122", "Schwabach",
"495767", "Warmsen",
"492635", "Rheinbrohl",
"499105", "Grosshabersdorf",
"498376", "Sulzberg\ Allgäu",
"496344", "Schwegenheim",
"492268", "Kürten",
"495445", "Drebber",
"4939030", "Brunau",
"498727", "Falkenberg\ Niederbayern",
"495829", "Wriedel",
"496629", "Schenklengsfeld",
"4935020", "Struppen",
"497024", "Wendlingen\ am\ Neckar",
"496331", "Pirmasens",
"4933334", "Greiffenberg",
"495453", "Recke",
"496504", "Thalfang",
"498262", "Mittelneufnach",
"4938228", "Dettmannsdorf\-Kölzow",
"49561", "Kassel",
"49681", "Saarbrücken",
"4934221", "Schildau\ Gneisenaustadt",
"4933201", "Gross\ Glienicke",
"4939744", "Rothenklempenow",
"495493", "Neuenkirchen\ Kreis\ Vechta",
"495148", "Steinhorst\ Niedersachsen",
"4936370", "Grossenehrich",
"497628", "Efringen\-Kirchen",
"494872", "Hanerau\-Hademarschen",
"496881", "Lebach",
"499408", "Altenthann",
"495681", "Homberg\ Efze",
"495222", "Bad\ Salzuflen",
"492527", "Lippetal\-Lippborg",
"495520", "Braunlage",
"495964", "Lähden",
"498394", "Lautrach",
"492484", "Mechernich\-Eiserfey",
"495205", "Bielefeld\-Sennestadt",
"497825", "Kippenheim",
"497802", "Oberkirch\ Baden",
"4936705", "Oberweissbach\ Thüringer\ Wald",
"497449", "Baiersbronn\-Obertal",
"494288", "Horstedt\ Kreis\ Rotenburg",
"495724", "Obernkirchen",
"49340", "Dessau\ Anh",
"4939348", "Klitsche",
"493987", "Templin",
"493362", "Erkner",
"494945", "Grossefehn\-Timmel",
"498764", "Mauern\ Kreis\ Freising",
"4939857", "Drense",
"498143", "Inning\ am\ Ammersee",
"492388", "Hamm\-Uentrop",
"497663", "Eichstetten",
"499677", "Oberviechtach\-Pullenried",
"4933332", "Gartz\ Oder",
"499073", "Gundelfingen\ an\ der\ Donau",
"495606", "Zierenberg",
"496806", "Heusweiler",
"496145", "Flörsheim\ am\ Main",
"498458", "Gaimersheim",
"495424", "Bad\ Rothenfelde",
"493379", "Mahlow",
"497306", "Vöhringen\ Iller",
"4938222", "Semlow",
"493635", "Kölleda",
"498592", "Wegscheid\ Niederbayern",
"498552", "Grafenau\ Niederbayern",
"492339", "Sprockhövel\-Hasslinghausen",
"498250", "Hilgertshausen\-Tandern",
"496167", "Modautal",
"495363", "Wolfsburg\-Vorsfelde",
"493866", "Cambs",
"497045", "Oberderdingen",
"492675", "Ediger\-Eller",
"492621", "Lahnstein",
"498336", "Erkheim",
"498323", "Immenstadt\ im\ Allgäu",
"494195", "Hartenholm",
"494239", "Dörverden\-Westen",
"4936739", "Rottenbach",
"4933435", "Rehfelde",
"4934772", "Helbra",
"494967", "Rhauderfehn\-Burlage",
"496302", "Winnweiler",
"498464", "Dietfurt\ an\ der\ Altmühl",
"496400", "Mücke",
"4936377", "Rastenberg",
"494155", "Büchen",
"496371", "Landstuhl",
"496325", "Lambrecht\ Pfalz",
"4933734", "Felgentreu",
"494480", "Ovelgönne\-Strückhausen",
"494382", "Wangels",
"4938856", "Pritzier\ bei\ Hagenow",
"499571", "Lichtenfels\ Bayern",
"499525", "Königsberg\ in\ Bayern",
"499502", "Frensdorf",
"495753", "Auetal\-Bernsen",
"4939342", "Gladau",
"499903", "Schöllnach",
"497381", "Münsingen",
"495328", "Altenau\ Harz",
"4936082", "Ershausen",
"498368", "Halblech",
"493564", "Schwarze\ Pumpe",
"493838", "Bergen\ auf\ Rügen",
"49731", "Ulm\ Donau",
"4936943", "Bettenhausen\ Thüringen",
"499183", "Burgthann",
"4933338", "Stolpe\/Oder",
"499708", "Bad\ Bocklet",
"494394", "Bokhorst",
"497831", "Hausach",
"4938224", "Gresenhorst",
"492362", "Dorsten",
"495467", "Voltlage",
"499342", "Wertheim",
"4939748", "Viereck",
"495283", "Lügde\-Rischenau",
"498801", "Seeshaupt",
"496124", "Bad\ Schwalbach",
"494354", "Fleckeby",
"497844", "Rheinau",
"4934774", "Röblingen\ am\ See",
"492254", "Weilerswist",
"499637", "Falkenberg\ Oberpfalz",
"4933732", "Hennickendorf\ bei\ Luckenwalde",
"492294", "Morsbach\ Sieg",
"498584", "Breitenberg\ Niederbayern",
"495745", "Stemwede\-Levern",
"4939391", "Lückstedt",
"494924", "Moormerland\-Oldersum",
"498427", "Wellheim",
"494262", "Visselhövede",
"494458", "Wiefelstede\-Spohle",
"499851", "Dinkelsbühl",
"492752", "Bad\ Laasphe",
"4939037", "Pretzier",
"497546", "Oberteuringen",
"497261", "Sinsheim",
"494764", "Gnarrenburg\-Klenkendorf",
"4935027", "Weesenstein",
"494498", "Saterland\-Ramsloh",
"494143", "Drochtersen",
"4939344", "Güsen",
"497657", "Eisenbach\ Hochschwarzwald",
"494832", "Meldorf",
"492598", "Senden\-Ottmarsbocholt",
"4936084", "Heuthen",
"496542", "Bullay",
"492558", "Horstmar",
"4938371", "Karlshagen",
"4933089", "Himmelpfort",
"497053", "Bad\ Teinach\-Zavelstein",
"495406", "Belm",
"497324", "Herbrechtingen",
"496031", "Friedberg\ Hessen",
"4939740", "Nechlin",
"4936374", "Weissensee",
"497463", "Mühlheim\ an\ der\ Donau",
"495129", "Söhlde",
"492166", "Mönchengladbach\-Rheydt",
"497954", "Kirchberg\ an\ der\ Jagst",
"496044", "Schotten\ Hessen",
"493735", "Marienberg\ Sachsen",
"498076", "Pfaffing",
"499805", "Burgoberbach",
"499822", "Bechhofen\ an\ der\ Heide",
"492775", "Driedorf",
"492721", "Lennestadt",
"4934363", "Cavertitz",
"499146", "Markt\ Berolzheim",
"4935826", "Königshain\ bei\ Görlitz",
"499941", "Kötzting",
"492684", "Puderbach\ Westerwald",
"499608", "Kohlberg\ Oberpfalz",
"495481", "Lengerich\ Westfalen",
"497428", "Rosenfeld",
"492961", "Brilon",
"49541", "Osnabrück",
"4939032", "Mahlsdorf\ bei\ Salzwedel",
"496893", "Saarbrücken\-Ensheim",
"495693", "Volkmarsen",
"498082", "Schwindegg",
"494627", "Dörpstedt",
"495653", "Sontra",
"496853", "Marpingen",
"4935793", "Elstra",
"4935022", "Bad\ Schandau",
"499373", "Amorbach",
"497367", "Aalen\-Ebnat",
"496429", "Schweinsberg\ Hessen",
"499737", "Wartmannsroth",
"495645", "Borgentreich\-Borgholz",
"494186", "Buchholz\-Trelde",
"496106", "Rodgau",
"494535", "Nahe",
"497583", "Bad\ Schussenried",
"4936372", "Kleinneuhausen",
"4939973", "Altkalen",
"497171", "Schwäbisch\ Gmünd",
"497125", "Bad\ Urach",
"492435", "Erkelenz\-Lövenich",
"4938227", "Lüdershagen\ bei\ Barth",
"493421", "Torgau",
"493475", "Lutherstadt\ Eisleben",
"494101", "Pinneberg",
"4933606", "Müllrose",
"4939858", "Bietikow",
"4936087", "Wüstheuterode",
"496181", "Hanau",
"498094", "Steinhöring",
"494172", "Salzhausen",
"497976", "Sulzbach\-Laufen",
"495561", "Einbeck",
"498054", "Breitbrunn\ am\ Chiemsee",
"495246", "Verl",
"493909", "Klötze\ Altmark",
"49491", "Leer\ Ostfriesland",
"4939034", "Fleetmark",
"492652", "Mendig",
"4935024", "Stadt\ Wehlen",
"492692", "Kelberg",
"4939347", "Kade",
"495848", "Trebel",
"496648", "Bad\ Salzschlirf",
"499229", "Mainleus",
"494664", "Neukirchen\ bei\ Niebüll",
"496573", "Gillenfeld",
"49611", "Wiesbaden",
"4934461", "Nebra\ Unstrut",
"498537", "Bad\ Füssing\-Aigen",
"495459", "Hörstel",
"492608", "Welschneudorf",
"499961", "Mitterfels",
"492941", "Lippstadt",
"493883", "Hagenow",
"4938782", "Reetz\ bei\ Perleberg",
"499090", "Rain\ Lech",
"4936336", "Klettenberg",
"492934", "Sundern\-Altenhellefeld",
"4936927", "Unterellen",
"4938841", "Neuhaus\ Elbe",
"49465", "Sylt",
"495301", "Lehre\-Essenrode",
"497158", "Neuhausen\ auf\ den\ Fildern",
"495372", "Meinersen",
"497443", "Dornstetten",
"493437", "Grimma",
"4934604", "Niemberg",
"497669", "St\ Märgen",
"499721", "Schweinfurt",
"499775", "Schönau\ an\ der\ Brend",
"492822", "Emmerich",
"499166", "Münchsteinach",
"4938485", "Dabel",
"496235", "Schifferstadt",
"497203", "Walzbachtal",
"4936847", "Steinbach\-Hallenberg",
"4934426", "Kayna",
"494631", "Glücksburg\ Ostsee",
"4938784", "Kleinow\ Kreis\ Prignitz",
"495266", "Lemgo\-Kirchheide",
"494329", "Langwedel\ Holstein",
"496159", "Messel",
"498233", "Kissing",
"495541", "Hann\.\ Münden",
"498226", "Bibertal",
"494644", "Karby",
"497455", "Dornhan",
"496668", "Birstein\-Lichenroth",
"494959", "Dollart",
"4937608", "Waldenburg\ Sachsen",
"495534", "Eschershausen\ an\ der\ Lenne",
"499652", "Waidhaus",
"493996", "Teterow",
"499088", "Mönchsdeggingen",
"4934381", "Colditz",
"497347", "Dietenheim",
"496636", "Romrod",
"495836", "Wittingen\-Radenbeck",
"492373", "Menden\ Sauerland",
"4939208", "Loitsche",
"496865", "Mettlach\-Orscholz",
"492737", "Netphen\-Deuz",
"495665", "Guxhagen",
"4934928", "Seegrehna",
"494273", "Kirchdorf\ bei\ Sulingen",
"495238", "Nieheim\-Himmighausen",
"498671", "Altötting",
"4934602", "Landsberg\ Sachsen\-Anhalt",
"496027", "Stockstadt\ am\ Main",
"496623", "Rotenburg\ an\ der\ Fulda",
"497632", "Badenweiler",
"495823", "Bienenbüttel",
"494857", "Barlt",
"4937757", "Rittersgrün",
"499435", "Schwarzenfeld",
"4933394", "Blumberg\ Kreis\ Barnim",
"4933929", "Gühlen\-Glienicke",
"499276", "Bischofsgrün",
"4934909", "Aken\ Elbe",
"493531", "Finsterwalde",
"495194", "Bispingen",
"492903", "Meschede\-Freienohl",
"492571", "Greven\ Westfalen",
"492525", "Beckum\-Neubeckum",
"4938751", "Picher",
"492502", "Nottuln",
"497486", "Horb\-Altheim",
"495154", "Aerzen",
"495207", "Schloss\ Holte\-Stukenbrock",
"4936924", "Mihla",
"496482", "Runkel",
"494425", "Wangerland\-Hooksiel",
"498348", "Bidingen",
"493544", "Luckau\ Brandenburg",
"494471", "Cloppenburg",
"4938206", "Graal\-Müritz\ Seeheilbad",
"492183", "Rommerskirchen",
"4939386", "Seehausen\ Altmark",
"4936842", "Oberhof\ Thüringen",
"494402", "Rastede",
"494849", "Hooge",
"4939059", "Wegenstedt",
"4937600", "Neumark\ Sachsen",
"497472", "Rottenburg\ am\ Neckar",
"499339", "Ippesheim",
"4934607", "Wettin",
"499675", "Altendorf\ am\ Nabburg",
"499621", "Amberg\ Oberpfalz",
"4937293", "Eppendorf\ Sachsen",
"4939200", "Gommern",
"498431", "Neuburg\ an\ der\ Donau",
"496147", "Trebur",
"499282", "Naila",
"4937752", "Eibenstock",
"4934920", "Kropstädt",
"4933635", "Arensdorf\ Kreis\ Oder\-Spree",
"4939421", "Osterwieck",
"4936781", "Grossbreitenbach",
"498444", "Schweitenkirchen",
"495032", "Neustadt\ am\ Rübenberge",
"496476", "Mengerskirchen",
"4935875", "Obercunnersdorf\ bei\ Löbau",
"494947", "Aurich\-Ogenbargen",
"495503", "Nörten\-Hardenberg",
"4935951", "Neukirch\ Lausitz",
"4935263", "Gröditz\ bei\ Riesa",
"496454", "Lichtenfels\-Sachsenberg",
"495902", "Freren",
"494744", "Loxstedt",
"494163", "Horneburg\ Niederelbe",
"4936922", "Gerstungen",
"4936608", "Seelingstädt\ bei\ Gera",
"492851", "Rees",
"497566", "Argenbühl",
"495925", "Wietmarschen",
"495971", "Rheine",
"498157", "Feldafing",
"498204", "Mickhausen",
"496562", "Speicher",
"4936844", "Rohr\ Thüringen",
"4939323", "Schönhausen\ Elbe",
"494731", "Nordenham",
"497234", "Tiefenbronn",
"4938787", "Glöwen",
"495182", "Gronau\ Leine",
"495355", "Frellstedt",
"4933849", "Wiesenburg\ Mark",
"496398", "Vorderweidenthal",
"498702", "Wörth\ an\ der\ Isar",
"495447", "Lembruch",
"492440", "Nettersheim\-Tondorf",
"496216", "Ludwigshafen",
"498725", "Wurmannsquick",
"498771", "Ergoldsbach",
"4933397", "Wandlitz",
"497732", "Radolfzell\ am\ Bodensee",
"498029", "Kreuth\ bei\ Tegernsee",
"49355", "Cottbus",
"496723", "Oestrich\-Winkel",
"4937754", "Zwönitz",
"496358", "Kriegsfeld",
"494128", "Kollmar",
"499294", "Regnitzlosau",
"495069", "Nordstemmen",
"495176", "Edemissen",
"496736", "Bechenheim",
"493677", "Ilmenau\ Thüringen",
"494242", "Syke",
"495765", "Raddestorf",
"492637", "Weissenthurm",
"499254", "Gefrees",
"499107", "Trautskirchen",
"493304", "Velten",
"496423", "Wetter\ Hessen",
"497432", "Albstadt\-Tailfingen",
"4938295", "Satow\ bei\ Bad\ Doberan",
"497256", "Philippsburg",
"4935829", "Gersdorf\ bei\ Görlitz",
"499635", "Bärnau",
"496364", "Nussbach\ Pfalz",
"498402", "Münchsmünster",
"4936928", "Neuenhof\ Thüringen",
"4936602", "Ronneburg\ Thüringen",
"494348", "Schönkirchen",
"4938780", "Lanz\ Brandenburg",
"492985", "Winterberg\-Niedersfeld",
"495465", "Neuenkirchen\ bei\ Bramsche",
"492248", "Hennef\-Uckerath",
"496292", "Seckach",
"499268", "Teuschnitz",
"496252", "Heppenheim\ Bergstrasse",
"496550", "Irrhausen",
"496436", "Dornburg\ Hessen",
"495072", "Neustadt\-Mandelsloh",
"493525", "Riesa",
"493571", "Hoyerswerda",
"494444", "Goldenstedt",
"497655", "Feldberg\-Altglashütten",
"499236", "Nagel",
"499452", "Langquaid",
"499350", "Eussenheim\-Hundsbach",
"496468", "Dautphetal\-Mornshausen",
"499492", "Parsberg",
"4938351", "Mesekenhagen",
"496754", "Martinstein",
"495086", "Celle\-Scheuen",
"494431", "Wildeshausen",
"499920", "Bischofsmais",
"499564", "Bad\ Rodach",
"4933975", "Dannenwalde\ Kreis\ Prignitz",
"4936426", "Ottendorf\ bei\ Stadtroda",
"499223", "Rugendorf",
"4934293", "Naunhof\ bei\ Grimma",
"498731", "Dingolfing",
"4933609", "Brieskow\-Finkenheerd",
"4936604", "Münchenbernsdorf",
"494965", "Surwold",
"496284", "Mudau",
"4938453", "Mistorf",
"493342", "Neuenhagen\ bei\ Berlin",
"494204", "Thedinghausen",
"4937607", "Ebersbrunn\ Sachsen",
"496327", "Neustadt\-Lachen",
"495123", "Schellerten",
"4938876", "Roggendorf",
"495136", "Burgdorf\ Kreis\ Hannover",
"497643", "Herbolzheim\ Breisgau",
"4936848", "Wernshausen",
"495585", "Herzberg\-Sieber",
"498744", "Gerzen",
"497578", "Wald\ Hohenz",
"492304", "Schwerte",
"496776", "Dachsenhausen",
"496165", "Breuberg",
"4939863", "Seehausen\ bei\ Prenzlau",
"492677", "Lutzerath",
"4935205", "Ottendorf\-Okrilla",
"4934927", "Globig\-Bleddin",
"494508", "Krummesse",
"496588", "Pluwig",
"495168", "Walsrode\-Stellichte",
"495931", "Meppen",
"499527", "Knetzgau",
"4939723", "Krien",
"4934600", "Ostrau\ Saalkreis",
"499484", "Brennberg",
"4936483", "Ziegenrück",
"496782", "Birkenfeld\ Nahe",
"497274", "Germersheim",
"492408", "Aachen\-Kornelimünster",
"495659", "Ringgau",
"494725", "Helgoland",
"494771", "Hemmoor",
"495944", "Hoogstede",
"494702", "Sandstedt",
"4939207", "Colbitz",
"495556", "Lindau\ Harz",
"4939953", "Schwinkendorf",
"497127", "Neckartenzlingen",
"495332", "Schöppenstedt",
"4937381", "Penig",
"497365", "Essingen\ Württemberg",
"499735", "Massbach",
"4936840", "Trusetal",
"495043", "Lauenau",
"495647", "Lichtenau\-Kleinenberg",
"494537", "Sülfeld\ Holstein",
"4937602", "Kirchberg\ Sachsen",
"499178", "Abenberg\ Mittelfranken",
"493941", "Halberstadt",
"4939202", "Gross\ Ammensleben",
"494149", "Fredenbeck",
"4934922", "Mühlanger",
"497755", "Weilheim\ Kreis\ Waldshut",
"4936736", "Arnsgereuth",
"496694", "Neukirchen\ Knüll",
"496654", "Gersfeld\ Rhön",
"4938859", "Alt\ Zachun",
"495854", "Bleckede\-Barskamp",
"492974", "Schmallenberg\-Fredeburg",
"497164", "Boll\ Kreis\ Göppingen",
"497743", "Ühlingen\-Birkendorf",
"4934781", "Greifenhagen",
"496676", "Hohenroda\ Hessen",
"493737", "Rochlitz",
"492333", "Ennepetal",
"496130", "Schwabenheim\ an\ der\ Selz",
"4936920", "Grossenlupnitz",
"492777", "Breitscheid\ Hessen",
"4938788", "Gross\ Warnow",
"494233", "Blender",
"495278", "Höxter\-Ovenhausen",
"496058", "Gründau",
"498631", "Mühldorf\ am\ Inn",
"497948", "Öhringen\-Ohrnberg",
"4935691", "Bärenklau\ NL",
"494828", "Lägerdorf",
"4937604", "Mosel",
"497672", "St\ Blasien",
"4933086", "Grieben\ Kreis\ Oberhavel",
"4936607", "Niederpöllnitz",
"499421", "Straubing",
"496221", "Heidelberg",
"496275", "Rothenberg\ Odenwald",
"495055", "Fassberg",
"498857", "Benediktbeuern",
"4936071", "Teistungen",
"4939204", "Niederndodeleben",
"494625", "Jübek",
"494671", "Bredstedt",
"495882", "Gorleben",
"496682", "Tann\ Rhön",
"498273", "Nordendorf",
"4933741", "Niedergörsdorf",
"494602", "Freienwill",
"49208", "Oberhausen\ Rheinland",
"4934924", "Zahna",
"492191", "Remscheid",
"499189", "Berg\ bei\ Neumarkt\ in\ der\ Oberpfalz",
"492151", "Krefeld",
"4933398", "Werneuchen",
"495574", "Oberweser",
"494863", "Sankt\ Peter\-Ording",
"495428", "Melle\-Neuenkirchen",
"4936730", "Sitzendorf",
"499271", "Thurnau\-Alladorf",
"499225", "Stadtsteinach",
"499202", "Waischenfeld",
"4937756", "Breitenbrunn\ Erzgebirge",
"498754", "Volkenschwand",
"493523", "Coswig\ bei\ Dresden",
"497653", "Lenzkirch",
"4938331", "Rakow\ Vorpom",
"498468", "Altmannstein\-Pondorf",
"49741", "Rottweil",
"498252", "Schrobenhausen",
"498550", "Philippsreut",
"493841", "Wismar",
"497129", "Lichtenstein\ Württemberg",
"4936695", "Söllmnitz",
"492983", "Winterberg\-Siedlinghausen",
"495324", "Vienenburg",
"4936846", "Suhl\-Dietzhausen",
"493762", "Crimmitschau",
"492582", "Everswinkel",
"498292", "Dinkelscherben",
"4939382", "Kamern",
"4938202", "Volkenshagen",
"499626", "Hohenburg",
"492103", "Hilden",
"493834", "Greifswald",
"499633", "Mitterteich",
"498364", "Seeg",
"496402", "Hungen",
"496425", "Rauschenberg\ Hessen",
"496471", "Weilburg",
"494482", "Hatten",
"4936042", "Tonna",
"498423", "Titting",
"4939601", "Friedland",
"4939859", "Fürstenwerder",
"495954", "Lorup",
"4935241", "Lommatzsch",
"494539", "Westerau",
"492874", "Isselburg",
"499704", "Euerdorf",
"496849", "Kirkel",
"4934955", "Gossa",
"497246", "Malsch\ Kreis\ Karlsruhe",
"498782", "Pfeffenhausen",
"4936428", "Stadtroda",
"497561", "Leutkirch\ im\ Allgäu",
"495976", "Salzbergen",
"492856", "Hamminkeln\-Brünen",
"494358", "Loose\ bei\ Eckernförde",
"499907", "Zenting",
"496128", "Taunusstein",
"4935753", "Grossräschen",
"494723", "Cuxhaven\-Altenwalde",
"492750", "Diedenshausen",
"494736", "Butjadingen\-Tossens",
"494928", "Ihlow\-Riepe",
"494830", "Süderhastedt",
"4939005", "Kusey",
"499187", "Altdorf\ bei\ Nürnberg",
"496242", "Osthofen",
"499442", "Riedenburg",
"499340", "Königheim\-Brehmen",
"4933080", "Marienthal\ Kreis\ Oberhavel",
"498165", "Neufahrn\ bei\ Freising",
"495583", "Braunlage\-Hohegeiss",
"494454", "Jade",
"497645", "Freiamt",
"4938204", "Broderstorf",
"4939384", "Arendsee\ Altmark",
"494768", "Hipstedt",
"494494", "Bösel\ Oldenburg",
"492779", "Greifenstein\-Beilstein",
"495367", "Rühen",
"492360", "Haltern\-Lippramsdorf",
"492462", "Linnich",
"496163", "Höchst\ im\ Odenwald",
"496744", "Oberwesel",
"4933475", "Letschin",
"4933831", "Weseram",
"498284", "Ziemetshausen",
"492594", "Dülmen",
"4936926", "Creuzburg",
"494260", "Visselhövede\-Wittorf",
"494562", "Grömitz",
"498327", "Rettenberg",
"495171", "Peine",
"4936337", "Schiedungen",
"494963", "Dörpen",
"495102", "Laatzen",
"492554", "Laer\ Kreis\ Steinfurt",
"496731", "Alzey",
"495381", "Seesen",
"498654", "Freilassing",
"497328", "Königsbronn",
"4939295", "Zuchau",
"497753", "Albbruck",
"4933396", "Klosterfelde",
"499966", "Wiesenfelden",
"4939749", "Grambow\ bei\ Pasewalk",
"496048", "Büdingen\-Eckartshausen",
"497958", "Rot\ Am\ See\-Brettheim",
"4936201", "Walschleben",
"49531", "Braunschweig",
"492052", "Velbert\-Langenberg",
"492688", "Kroppach",
"495045", "Springe\-Bennigsen",
"499733", "Münnerstadt",
"4933088", "Falkenthal",
"498847", "Obersöchering",
"499377", "Freudenberg\-Boxtal",
"497363", "Lauchheim",
"4933233", "Ketzin",
"497587", "Hosskirch",
"4936332", "Ellrich",
"495306", "Cremlingen",
"497424", "Spaichingen",
"499604", "Wernberg\-Köblitz",
"499161", "Neustadt\ an\ der\ Aisch",
"499938", "Moos\ Niederbayern",
"4939933", "Vollrathsruhe",
"499820", "Lehrberg",
"4933363", "Altenhof\ Kreis\ Barnim",
"4934424", "Reuden\ bei\ Zeitz",
"499726", "Euerbach",
"494636", "Langballig",
"495261", "Lemgo",
"495546", "Scheden",
"494865", "Osterhever",
"4934606", "Teicha\ Sachsen\-Anhalt",
"4939453", "Derenburg",
"4936738", "Königsee",
"496897", "Sulzbach\ Saar",
"498682", "Laufen\ Salzach",
"495053", "Fassberg\-Müden",
"499529", "Oberaurach",
"498221", "Günzburg",
"495657", "Meissner",
"496857", "Namborn",
"494623", "Böklund",
"4935385", "Annaburg",
"4935843", "Hirschfelde\ bei\ Zittau",
"494235", "Langwedel\-Etelsen",
"497467", "Neuhausen\ ob\ Eck",
"493991", "Waren\ Müritz",
"499473", "Kallmünz",
"496329", "Weidenthal\ Pfalz",
"494159", "Basthorst",
"496631", "Alsfeld",
"4936334", "Wolkramshausen",
"495831", "Wittingen",
"4938723", "Kladrum",
"493375", "Königs\ Wusterhausen",
"493321", "Nauen\ Brandenburg",
"497745", "Jestetten",
"4934422", "Osterfeld",
"494668", "Klanxbüll",
"496644", "Grebenhain",
"4937325", "Niederbobritzsch",
"495844", "Clenze",
"4938207", "Stäbelow",
"4939387", "Havelberg",
"492335", "Wetter\ Ruhr",
"499773", "Unsleben",
"499337", "Gaukönigshofen",
"492803", "Wesel\-Büderich",
"498064", "Au\ bei\ Bad\ Aibling",
"4939751", "Penkun",
"495551", "Northeim",
"4936732", "Könitz",
"492174", "Burscheid\ Rheinland",
"4934926", "Pretzsch\ Elbe",
"4934779", "Abberode",
"4937422", "Markneukirchen",
"495024", "Rohrsen\ Kreis\ Nienburg\ Weser",
"4939206", "Eichenbarleben",
"4933763", "Bestensee",
"4934325", "Mochau\-Lüttewitz",
"499978", "Schönthal\ Oberpfalz",
"492662", "Hachenburg",
"4935895", "Klitten",
"499642", "Kemnath\ Stadt",
"4938229", "Bad\ Sülze",
"497445", "Pfalzgrafenweiler",
"4937606", "Lengenfeld\ Vogtland",
"497357", "Attenweiler",
"4933084", "Gutengermendorf",
"495209", "Gütersloh\-Friedrichsdorf",
"493946", "Quedlinburg",
"4939349", "Parey\ Elbe",
"494847", "Oster\-Ohrstedt",
"492991", "Marsberg\-Bredelar",
"498623", "Kirchweidach",
"497724", "St\ Georgen\ im\ Schwarzwald",
"4936871", "Bad\ Colberg\-Heldburg",
"494275", "Ehrenburg",
"494221", "Delmenhorst",
"495802", "Wrestedt",
"499433", "Nabburg",
"498027", "Dietramszell",
"494682", "Amrum",
"492951", "Büren",
"4936734", "Leutenberg",
"496625", "Niederaula",
"495825", "Wieren",
"4936427", "Dornburg\ Saale",
"493679", "Neuhaus\ am\ Rennweg",
"498170", "Strasslach\-Dingharting",
"499426", "Oberschneiding",
"495067", "Bockenem",
"4938323", "Prohn",
"493335", "Finowfurt",
"495663", "Spangenberg",
"492639", "Anhausen\ Kreis\ Neuwied",
"498636", "Ampfing",
"492375", "Balve",
"497148", "Grossbottwar",
"4933082", "Menz\ Kreis\ Oberhavel",
"49761", "Freiburg\ im\ Breisgau",
"4936338", "Bleicherode",
"496226", "Meckesheim",
"497453", "Altensteig\ Württemberg",
"492156", "Willich\-Anrath",
"497520", "Bodnegg",
"496233", "Frankenthal\ Pfalz",
"497222", "Rastatt",
"497964", "Stödtlen",
"4939243", "Nedlitz\ bei\ Zerbst",
"4935603", "Burg\ Spreewald",
"492196", "Wermelskirchen",
"497681", "Waldkirch\ Breisgau",
"494468", "Friedeburg\-Reepsholt",
"494794", "Worpswede\-Ostersode",
"499120", "Leinburg",
"4936422", "Reinstädt\ Thüringen",
"492762", "Wenden\ Südsauerland",
"499861", "Rothenburg\ ob\ der\ Tauber",
"496444", "Bischoffen",
"4933655", "Grunow\ Kreis\ Oder\-Spree",
"499742", "Kalbach\ Rhön",
"4935451", "Dahme\ Brandenburg",
"492841", "Moers",
"494754", "Bülkau",
"497251", "Bruchsal",
"497667", "Breisach\ am\ Rhein",
"493874", "Ludwigslust",
"499673", "Tiefenbach\ Oberpfalz",
"496431", "Limburg\ an\ der\ Lahn",
"499548", "Mühlhausen\ Mittelfranken",
"492834", "Straelen",
"492568", "Heek",
"495345", "Baddeckenstedt",
"499077", "Bachhagel",
"497063", "Bad\ Wimpfen",
"492536", "Münster\-Albachten",
"494423", "Fedderwarden",
"495457", "Hopsten\-Schale",
"492352", "Altena\ Westfalen",
"4936330", "Grossberndten",
"496348", "Offenbach\ an\ der\ Queich",
"499231", "Marktredwitz",
"492392", "Werdohl",
"493576", "Weisswasser",
"498380", "Achberg",
"4939039", "Bonese",
"494364", "Dahme\ Kreis\ Ostholstein",
"4933087", "Bredereiche",
"492905", "Bestwig\-Ramsbeck",
"494292", "Ritterhude",
"4936606", "Kraftsdorf",
"4938874", "Lützow",
"492264", "Marienheide",
"492922", "Werl",
"499244", "Betzenstein",
"494252", "Bruchhausen\-Vilsen",
"494550", "Bühnsdorf",
"4938731", "Lübz",
"492523", "Wadersloh",
"4939485", "Gernrode\ Harz",
"497706", "Oberbaldingen",
"493462", "Bad\ Dürrenberg",
"496508", "Hetzerath\ Mosel",
"4936424", "Kahla\ Thüringen",
"492739", "Wilnsdorf",
"495763", "Uchte",
"495144", "Wathlingen",
"4934262", "Falkenhain\ bei\ Wurzen",
"496029", "Mömbris",
"498723", "Arnstorf",
"499404", "Nittendorf",
"4937435", "Reuth\ bei\ Plauen",
"4936379", "Holzengel",
"497624", "Grenzach\-Wyhlen",
"4936643", "Thimmendorf",
"4936737", "Drognitz",
"495131", "Garbsen",
"493594", "Bischofswerda",
"494859", "Windbergen",
"496771", "St\ Goarshausen",
"496725", "Gau\-Algesheim",
"4933051", "Nassenheide",
"495936", "Twist",
"495353", "Königslutter\ am\ Elm",
"496204", "Viernheim",
"496157", "Pfungstadt",
"494327", "Grossenaspe",
"498562", "Triftern",
"4938208", "Kavelstorf",
"4939388", "Goldbeck\ Altm",
"494284", "Selsingen",
"495522", "Osterode\ am\ Harz",
"492227", "Bornheim\-Merten",
"494776", "Osten\-Altendorf",
"4938872", "Rehna",
"492384", "Welver",
"4935931", "Königswartha",
"49771", "Donaueschingen",
"495505", "Hardegsen",
"498454", "Karlshuld",
"495923", "Schüttorf",
"494957", "Detern",
"494165", "Hollenstedt\ Nordheide",
"4939921", "Ankershagen",
"495232", "Lage\ Lippe",
"4939454", "Elbingerode\ Harz",
"495456", "Westerkappeln\-Velpe",
"497184", "Kaisersbach",
"497904", "Ilshofen",
"4934321", "Leisnig",
"499082", "Oettingen\ in\ Bayern",
"49365", "Gera",
"497265", "Angelbachtal",
"4938328", "Miltzow",
"499855", "Dentlein\ am\ Forst",
"4935891", "Rothenburg\ OL",
"495741", "Lübbecke",
"4933232", "Brieselang",
"4936333", "Heringen\ Helme",
"494974", "Neuharlingersiel",
"495862", "Hitzacker\ Elbe",
"4935844", "Oybin\ Kurort",
"499658", "Georgenberg",
"4938425", "Kirchdorf\ Poel",
"498805", "Hohenpeissenberg",
"495734", "Bergkirchen\ Westfalen",
"4935608", "Gross\ Ossnig",
"497666", "Denzlingen",
"4939248", "Dobritz",
"498146", "Moorenweis",
"496174", "Königstein\ im\ Taunus",
"498822", "Oberammergau",
"494883", "Süderstapel",
"497835", "Zell\ am\ Harmersbach",
"4938724", "Siggelkow",
"4933362", "Liepe\ Kreis\ Barnim",
"499076", "Wittislingen",
"495603", "Gudensberg",
"496803", "Mandelbachtal\-Ommersheim",
"4939932", "Malchow\ bei\ Waren",
"4939452", "Ilsenburg",
"4936875", "Straufhain\-Streufdorf",
"492828", "Emmerich\-Elten",
"495937", "Geeste\-Gross\ Hesepe",
"496196", "Bad\ Soden\ am\ Taunus",
"494326", "Wankendorf",
"499094", "Tagmersheim",
"492233", "Hürth\ Rheinland",
"492226", "Rheinbach",
"494777", "Cadenberge",
"4936640", "Remptendorf",
"495378", "Sassenburg\-Platendorf",
"494333", "Erfde",
"497152", "Leonberg\ Württemberg",
"497385", "Gomadingen",
"497192", "Murrhardt",
"499521", "Hassfurt",
"499575", "Weismain",
"494956", "Uplengen",
"4933768", "Prieros",
"4934691", "Könnern",
"495839", "Wittingen\-Ohrdorf",
"496639", "Ottrau",
"492863", "Velen",
"497707", "Bräunlingen",
"497034", "Ehningen",
"494151", "Schwarzenbek",
"496321", "Neustadt\ an\ der\ Weinstrasse",
"496375", "Wallhalben",
"4933234", "Wustermark",
"4935842", "Oderwitz",
"498373", "Altusried",
"494191", "Kaltenkirchen\ Holstein",
"499843", "Burgbernheim",
"493644", "Apolda",
"492602", "Montabaur",
"499132", "Herzogenaurach",
"4934423", "Heuckewalde",
"492625", "Ochtendung",
"492671", "Cochem",
"497041", "Mühlacker",
"493329", "Stahnsdorf",
"4933364", "Gross\ Ziethen\ Kreis\ Barnim",
"495474", "Stemwede\-Dielingen",
"4939934", "Gross\ Plasten",
"4938722", "Raduhn",
"493631", "Nordhausen\ Thüringen",
"497356", "Schemmerhofen",
"4935754", "Klettwitz",
"496523", "Holsthum",
"497532", "Meersburg",
"49375", "Zwickau",
"499279", "Mistelgau",
"498571", "Simbach\ am\ Inn",
"494248", "Bassum\-Neubruchhausen",
"493947", "Thale",
"497933", "Creglingen",
"498502", "Fürstenzell",
"496264", "Neudenau",
"4935455", "Walddrehna",
"496392", "Hauenstein\ Pfalz",
"498708", "Weihmichl\-Unterneuhausen",
"4936648", "Dittersdorf\ bei\ Schleiz",
"495565", "Einbeck\-Wenzen",
"4939457", "Benneckenstein\ Harz",
"494740", "Loxstedt\-Dedesdorf",
"494105", "Seevetal",
"496536", "Kleinich",
"497738", "Steisslingen",
"494122", "Uetersen",
"496352", "Kirchheimbolanden",
"4937296", "Stollberg\ Erzgebirge",
"496185", "Hammersbach\ Hessen",
"494846", "Hattstedt",
"4933760", "Münchehofe\ Kreis\ Dahme\-Spreewald",
"496568", "Wolsfeld",
"495634", "Waldeck\-Sachsenhausen",
"499552", "Burghaslach",
"496834", "Bous",
"499336", "Bütthard",
"494544", "Berkenthin",
"493471", "Bernburg\ Saale",
"493425", "Wurzen",
"4938203", "Bad\ Doberan",
"4939383", "Sandau\ Elbe",
"499953", "Pilsting",
"492431", "Erkelenz",
"4938727", "Mestlin",
"497175", "Leinzell",
"495703", "Hille",
"497121", "Reutlingen",
"499464", "Walderbach",
"495641", "Warburg",
"496841", "Homburg\ Saar",
"494531", "Bad\ Oldesloe",
"4938735", "Plau\ am\ See",
"495908", "Wietmarschen\-Lohne",
"496479", "Waldbrunn\ Westerwald",
"499323", "Iphofen",
"492444", "Schleiden\-Gemünd",
"4936043", "Kirchheilingen",
"496762", "Kastellaun",
"4935752", "Ruhland",
"4939481", "Hedersleben\ bei\ Aschersleben",
"497569", "Isny\-Eisenbach",
"496227", "Walldorf\ Baden",
"498851", "Kochel\ am\ See",
"496384", "Konken",
"492204", "Bensberg",
"497478", "Hirrlingen",
"4937431", "Mehltheuer\ Vogtland",
"492157", "Nettetal\-Kaldenkirchen",
"495485", "Ladbergen",
"499945", "Arnbruck",
"495190", "Soltau\-Emmingen",
"4938320", "Tribsees",
"499288", "Bad\ Steben",
"4933055", "Kremmen",
"498342", "Marktoberdorf",
"4937369", "Wolkenstein",
"4934205", "Markranstädt",
"494408", "Hude\ Oldenburg",
"499872", "Heilsbronn",
"492725", "Lennestadt\-Oedingen",
"492771", "Dillenburg",
"493731", "Freiberg\ Sachsen",
"498026", "Hausham",
"4938309", "Trent",
"4933367", "Friedrichswalde\ Brandenburg",
"4935935", "Kleinwelka",
"4933989", "Sadenbeck",
"4935600", "Döbern\ NL",
"4933237", "Paulinenaue",
"498033", "Oberaudorf",
"499427", "Leiblfing",
"4935266", "Heyda\ bei\ Riesa",
"495066", "Sarstedt",
"4939925", "Wredenhagen",
"498637", "Lohkirchen",
"493744", "Auerbach\ Vogtland",
"497374", "Uttenweiler",
"496035", "Reichelsheim\ Wetterau",
"492508", "Drensteinfurt",
"495674", "Grebenstein",
"498122", "Erding",
"496874", "Wadern\-Nunkirchen",
"497259", "Östringen\-Odenheim",
"498846", "Uffing\ am\ Staffelsee",
"493431", "Döbeln",
"498105", "Gilching",
"499376", "Collenberg",
"499869", "Wettringen\ Mittelfranken",
"492402", "Stolberg\ Rheinland",
"497586", "Herbertingen",
"495307", "Braunschweig\-Wenden",
"496788", "Sien",
"4936423", "Orlamünde",
"496103", "Langen\ Hessen",
"494708", "Ringstedt",
"497135", "Brackenheim",
"492471", "Roetgen\ Eifel",
"492425", "Nideggen\-Embken",
"4938327", "Elmenhorst\ Vorpom",
"494183", "Jesteburg",
"494502", "Lübeck\-Travemünde",
"494525", "Ahrensbök",
"498248", "Lamerdingen",
"496582", "Freudenburg",
"4936644", "Hirschberg\ Saale",
"496439", "Holzappel",
"494903", "Wymeer",
"495162", "Fallingbostel",
"499727", "Schonungen\-Marktsteinach",
"4939247", "Güterglück",
"4935607", "Jänschwalde",
"492947", "Anröchte",
"4933230", "Börnicke\ Kreis\ Havelland",
"4936691", "Eisenberg\ Thüringen",
"499195", "Adelsdorf\ Mittelfranken",
"497572", "Mengen\ Württemberg",
"499382", "Gerolzhofen",
"499480", "Sünching",
"498531", "Pocking",
"499155", "Simmelsdorf",
"497973", "Obersontheim",
"498544", "Eging\ am\ See",
"4935245", "Burkhardswalde\-Munzig",
"4939605", "Gross\ Nemerow",
"4939726", "Ducherow",
"496554", "Waxweiler",
"499832", "Wassertrüdingen",
"495403", "Bad\ Iburg",
"4934263", "Hohburg",
"497466", "Beuron",
"496594", "Birresborn",
"4933767", "Friedersdorf\ bei\ Berlin",
"49228", "Bonn",
"493725", "Zschopau",
"493771", "Aue\ Sachsen",
"498073", "Gars\ am\ Inn",
"494851", "Marne",
"4936642", "Harra",
"492744", "Herdorf",
"492163", "Schwalmtal\ Niederrhein",
"495295", "Lichtenau\ Westfalen",
"496462", "Gladenbach",
"498304", "Wildpoldsried",
"495139", "Burgwedel",
"495255", "Altenbeken",
"499764", "Höchheim",
"499498", "Laaber",
"499143", "Pappenheim\ Mittelfranken",
"497334", "Deggingen",
"496021", "Aschaffenburg",
"4939001", "Apenburg",
"498677", "Burghausen\ Salzach",
"494637", "Sterup",
"497852", "Willstätt",
"492242", "Hennef\ Sieg",
"496298", "Möckmühl",
"499262", "Wallenfels",
"499560", "Grub\ am\ Forst",
"499924", "Bodenmais",
"496258", "Gernsheim",
"49345", "Halle\ Saale",
"497085", "Enzklösterle",
"495696", "Bad\ Arolsen\-Landau",
"4939062", "Bebertal",
"4934296", "Groitzsch\ bei\ Pegau",
"499394", "Esselbach",
"4933835", "Golzow\ bei\ Brandenburg",
"499354", "Rieneck",
"4938873", "Carlow",
"493965", "Burow\ bei\ Altentreptow",
"495656", "Waldkappel",
"496856", "St\ Wendel\-Niederkirchen",
"4938456", "Langhagen\ bei\ Güstrow",
"4938720", "Grebbin",
"494342", "Preetz\ Kreis\ Plön",
"4939458", "Heudeber",
"4936647", "Saalburg\ Thüringen",
"4936733", "Kaulsdorf",
"4939291", "Calbe\ Saale",
"494934", "Marienhafe",
"495286", "Ottenstein\ Niedersachsen",
"499627", "Freudenberg\ Oberpfalz",
"495774", "Wagenfeld\-Ströhen",
"496134", "Mainz\-Kastel",
"494941", "Aurich",
"497821", "Lahr\ Schwarzwald",
"498640", "Reit\ Im\ Winkl",
"4938324", "Velgast",
"4937423", "Adorf\ Vogtland",
"4933762", "Zeuthen",
"4936205", "Gräfenroda",
"494608", "Handewitt",
"495272", "Brakel\ Westfalen",
"495201", "Halle\ Westfalen",
"4936949", "Obermassfeld\-Grimmenthal",
"497942", "Neuenstein\ Württemberg",
"496052", "Bad\ Orb",
"493537", "Jessen\ Elster",
"494146", "Stade\-Bützfleth",
"495685", "Knüllwald",
"496092", "Heimbuchenthal",
"494822", "Kellinghusen",
"494805", "Schafstedt",
"497543", "Kressbronn\ am\ Bodensee",
"4933701", "Grossbeeren",
"4934721", "Nienburg\ Saale",
"4935604", "Krieschow",
"4939956", "Neukalen",
"4939244", "Steutz",
"497056", "Gechingen",
"494477", "Lastrup\-Hemmelte",
"4938728", "Domsühl",
"497303", "Illertissen",
"496335", "Trulben",
"492644", "Linz\ am\ Rhein",
"495441", "Diepholz",
"498333", "Babenhausen\ Schwaben",
"499664", "Hahnbach",
"493863", "Crivitz",
"495366", "Jembke",
"499172", "Georgensgmünd",
"492631", "Neuwied",
"499101", "Langenzenn",
"498326", "Fischen\ im\ Allgäu",
"495434", "Essen\ Oldenburg",
"49991", "Deggendorf",
"498042", "Lenggries",
"4933764", "Mittenwalde\ Mark",
"493671", "Saalfeld\ Saale",
"4938322", "Richtenberg",
"497555", "Deggenhausertal",
"497247", "Linkenheim\-Hochstetten",
"4933238", "Senzke",
"495977", "Spelle",
"495850", "Neetze",
"492857", "Rees\-Mehr",
"496650", "Hosenfeld",
"4933083", "Schulzendorf\ Kreis\ Oberhavel",
"499906", "Mariaposching",
"492273", "Kerpen\-Horrem",
"4935602", "Drebkau",
"4939242", "Prödel",
"494737", "Stadland\-Schwei",
"496084", "Schmitten\ Taunus",
"498191", "Landsberg\ am\ Lech",
"498151", "Starnberg",
"4937321", "Frankenstein\ Sachsen",
"499535", "Pfarrweisach",
"4933368", "Hohensaaten",
"499186", "Lauterhofen\ Oberpfalz",
"4938458", "Zehna",
"496544", "Rhaunen",
"497391", "Ehingen\ Donau",
"494834", "Büsum",
"497351", "Biberach\ an\ der\ Riss",
"4934298", "Taucha\ bei\ Leipzig",
"4935264", "Strehla",
"495108", "Gehrden\ Han",
"496531", "Bernkastel\-Kues",
"499448", "Hausen\ Niederbayern",
"499193", "Höchstadt\ an\ der\ Aisch",
"492754", "Bad\ Laasphe\-Feudingen",
"494841", "Husum\ Nordsee",
"497975", "Untergröningen",
"494762", "Kutenholz",
"4939324", "Kläden\ bei\ Stendal",
"495245", "Herzebrock\-Clarholz",
"499153", "Schnaittach",
"4936843", "Benshausen",
"494479", "Molbergen\-Peheim",
"492252", "Zülpich",
"494523", "Malente",
"4937292", "Oederan",
"497126", "Burladingen\-Melchingen",
"492436", "Wegberg\-Rödgen",
"497842", "Kappelrodeck",
"494264", "Sottrum\ Kreis\ Rotenburg",
"497761", "Bad\ Säckingen",
"494922", "Borkum",
"493476", "Hettstedt\ Sachsen\-Anhalt",
"4938355", "Züssow",
"492590", "Dülmen\-Buldern",
"498582", "Röhrnbach",
"492292", "Windeck\ Sieg",
"499331", "Ochsenfurt",
"492364", "Haltern\ Westfalen",
"494392", "Nortorf\ bei\ Neumünster",
"495646", "Willebadessen",
"492423", "Langerwehe",
"494185", "Marxen\ Auetal",
"496122", "Hofheim\-Wallau",
"497133", "Lauffen\ am\ Neckar",
"494352", "Damp",
"494536", "Steinhorst\ Lauenburg",
"496105", "Mörfelden\-Walldorf",
"499344", "Gerchsheim",
"4939728", "Medow\ bei\ Anklam",
"4933971", "Kyritz\ Brandenburg",
"492859", "Wesel\-Bislich",
"4936923", "Treffurt",
"493562", "Forst\ Lausitz",
"496408", "Buseck",
"494488", "Westerstede",
"497249", "Stutensee",
"498856", "Penzberg",
"493963", "Woldegk",
"498258", "Sielenbach",
"499504", "Stadelhofen",
"49981", "Ansbach",
"497083", "Bad\ Herrenalb",
"4939322", "Tangermünde",
"492588", "Harsewinkel\-Greffen",
"493494", "Wolfen",
"4962199", "Ludwigshafen",
"495293", "Paderborn\-Dahl",
"492165", "Jüchen",
"496677", "Neuenstein\ Hessen",
"4935201", "Langebrück",
"4937294", "Grünhainichen",
"498021", "Waakirchen",
"498075", "Amerang",
"492957", "Wünnenberg\-Haaren",
"494384", "Selent",
"496073", "Babenhausen\ Hessen",
"496304", "Wolfstein\ Pfalz",
"498462", "Berching",
"492776", "Bad\ Endbach\-Hartenrod",
"495253", "Bad\ Driburg",
"493928", "Schönebeck\ Elbe",
"499145", "Solnhofen",
"495405", "Hasbergen\ Kreis\ Osnabrück",
"495320", "Torfhaus",
"495422", "Melle",
"492327", "Bochum\-Wattenscheid",
"493723", "Hohenstein\-Ernstthal",
"499208", "Bindlach",
"498554", "Schönberg\ Niederbayern",
"4935756", "Hosena",
"495491", "Damme\ Dümmer",
"4933366", "Chorin",
"492654", "Polch",
"4939265", "Löderburg",
"4938783", "Dallmin",
"494662", "Leck",
"495451", "Ibbenbüren",
"4939327", "Klietz",
"492694", "Wershofen",
"494174", "Stelle\ Kreis\ Harburg",
"498092", "Grafing\ bei\ München",
"4935325", "Rückersdorf\ bei\ Finsterwalde",
"4935267", "Diesbar\-Seusslitz",
"497545", "Immenstaad\ am\ Bodensee",
"4933965", "Herzsprung\ bei\ Wittstock",
"494803", "Pahlen",
"498052", "Aschau\ im\ Chiemgau",
"495683", "Wabern\ Hessen",
"495840", "Schnackenburg",
"497257", "Bruchsal\-Untergrombach",
"495746", "Rödinghausen",
"495309", "Lehre\-Wendhausen",
"498134", "Odelzhausen",
"499867", "Geslau",
"4933393", "Gross\ Schönebeck\ Kreis\ Barnim",
"499071", "Dillingen\ an\ der\ Donau",
"497661", "Kirchzarten",
"499729", "Grettstadt",
"498141", "Fürstenfeldbruck",
"496151", "Darmstadt",
"4938726", "Spornitz",
"4938450", "Tarnow\ bei\ Bützow",
"494321", "Neumünster",
"499932", "Osterhofen",
"4934785", "Sandersleben",
"494639", "Schafflund",
"499533", "Untermerzbach",
"498084", "Taufkirchen\ Vils",
"492682", "Hamm\ Sieg",
"494951", "Weener",
"499526", "Riedbach",
"492275", "Kerpen\-Buir",
"498650", "Marktschellenberg",
"4935695", "Simmersdorf",
"4936075", "Dingelstädt\ Eichsfeld",
"497952", "Gerabronn",
"496042", "Büdingen\ Hessen",
"4939999", "Tutow",
"4933745", "Petkus",
"493623", "Friedrichroda",
"499824", "Dietenhofen",
"497553", "Salem\ Baden",
"494156", "Talkau",
"492058", "Wülfrath",
"496326", "Deidesheim",
"4937297", "Thum\ Sachsen",
"495137", "Seelze",
"497420", "Deisslingen",
"497322", "Giengen\ an\ der\ Brenz",
"496333", "Waldfischbach\-Burgalben",
"497305", "Erbach\ Donau",
"493636", "Greussen",
"498679", "Burgkirchen\ an\ der\ Alz",
"497046", "Zaberfeld",
"493865", "Holthusen",
"4934603", "Nauendorf\ Sachsen\-Anhalt",
"4939456", "Altenbrak",
"492676", "Ulmen",
"498335", "Fellheim",
"497228", "Forbach",
"495281", "Bad\ Pyrmont",
"498803", "Peissenberg",
"492064", "Dinslaken",
"4939952", "Grammentin",
"495605", "Kaufungen\ Hessen",
"493847", "Sternberg",
"496805", "Kleinblittersdorf",
"495622", "Fritzlar",
"497833", "Hornberg\ Schwarzwaldbahn",
"496146", "Hochheim\ am\ Main",
"494885", "Bergenhusen",
"497142", "Bietigheim\-Bissingen",
"497826", "Schuttertal",
"4938457", "Krakow\ am\ See",
"4937603", "Wildenfels",
"498662", "Siegsdorf\ Kreis\ Traunstein",
"4934297", "Liebertwolkwitz",
"497720", "Schwenningen\ am\ Neckar",
"49521", "Bielefeld",
"496477", "Greifenstein\-Nenderoth",
"494946", "Grossefehn\-Bagband",
"497263", "Waibstadt",
"4933766", "Teupitz",
"499277", "Warmensteinach",
"494141", "Stade",
"4938845", "Kaarssen",
"4939203", "Barleben",
"499853", "Wilburgstetten",
"497524", "Bad\ Waldsee",
"493949", "Oschersleben\ Bode",
"4939727", "Spantekow",
"495206", "Bielefeld\-Jöllenbeck",
"4935725", "Wittichenau",
"497051", "Calw",
"494134", "Embsen\ Kreis\ Lüneburg",
"495808", "Gerdau",
"4934923", "Cobbelsdorf",
"495446", "Rehden",
"492623", "Ransbach\-Baumbach",
"495361", "Wolfsburg",
"4938481", "Witzin",
"4939954", "Stavenhagen\ Reuterstadt",
"4939246", "Lindau\ Anh",
"4935606", "Briesen\ bei\ Cottbus",
"496373", "Schönenberg\-Kübelberg",
"495177", "Edemissen\-Abbensen",
"499429", "Rain\ Niederbayern",
"492865", "Raesfeld",
"496737", "Köngernheim",
"496004", "Lich\-Eberstadt",
"499845", "Oberdachstetten",
"4936029", "Menteroda",
"498639", "Neumarkt\-Sankt\ Veit",
"492636", "Burgbrohl",
"498375", "Weitnau",
"499106", "Markt\ Erlbach",
"4939320", "Schinne",
"498321", "Sonthofen",
"4936259", "Tabarz\ Thüringer\ Wald",
"499901", "Hengersberg\ Bayern",
"497383", "Münsingen\-Buttenhausen",
"4938326", "Grimmen",
"494335", "Hohn\ bei\ Rendsburg",
"4934385", "Mutzschen",
"495751", "Rinteln",
"499972", "Waldmünchen",
"499648", "Neustadt\ am\ Kulm",
"496229", "Neckarsteinach",
"497567", "Leutkirch\-Friesenhofen",
"499573", "Staffelstein\ Oberfranken",
"49911", "Nuremberg",
"499181", "Neumarkt\ in\ der\ Oberpfalz",
"4936451", "Buttelstedt",
"492159", "Meerbusch\-Osterath",
"492235", "Erftstadt",
"493682", "Zella\-Mehlis",
"498196", "Pürgen",
"495528", "Gieboldehausen",
"497581", "Saulgau",
"498762", "Wartenberg\ Oberbayern",
"4938454", "Kritzkow",
"4936603", "Weida",
"497620", "Schopfheim\-Gersbach",
"498841", "Murnau\ am\ Staffelsee",
"499302", "Rottendorf\ Unterfranken",
"4935268", "Stauchitz",
"499325", "Kleinlangheim",
"499371", "Miltenberg",
"4938755", "Eldena",
"4934294", "Rackwitz",
"493423", "Eilenburg",
"497804", "Oppenau",
"499167", "Oberscheinfeld",
"495705", "Petershagen\-Windheim",
"49751", "Ravensburg",
"497173", "Heubach",
"493364", "Eisenhüttenstadt",
"4939328", "Rochau",
"499955", "Mamming",
"495722", "Bückeburg",
"498536", "Kösslarn",
"495563", "Kreiensen",
"498450", "Ingolstadt\-Zuchering",
"494874", "Todenbüttel",
"496183", "Erlensee",
"496708", "Bad\ Münster\ am\ Stein\-Ebernburg",
"498392", "Markt\ Rettenbach",
"497506", "Wangen\-Leupolz",
"492482", "Hellenthal",
"494103", "Wedel",
"495962", "Herzlake",
"495224", "Enger\ Westfalen",
"4939425", "Dingelstedt\ am\ Huy",
"496525", "Irrel",
"496571", "Wittlich",
"496502", "Schweich",
"4936484", "Knau\ bei\ Pössneck",
"4933631", "Bad\ Saarow\-Pieskow",
"4935435", "Gollmitz\ bei\ Calau",
"497935", "Schrozberg",
"4939724", "Klein\ Bünzow",
"4936785", "Gräfinau\-Angstedt",
"4934241", "Jesewitz",
"494298", "Lilienthal",
"4938452", "Lalendorf",
"497461", "Tuttlingen",
"497709", "Wutach",
"498035", "Raubling",
"492928", "Soest\-Ostönnen",
"497346", "Illerkirchberg",
"496637", "Feldatal",
"4935955", "Pulsnitz",
"495837", "Sprakensehl",
"497022", "Nürtingen",
"496033", "Butzbach",
"4934292", "Brandis\ bei\ Wurzen",
"494258", "Schwarme",
"492736", "Burbach\ Siegerl",
"4939862", "Schmölln\ bei\ Prenzlau",
"492723", "Kirchhundem",
"492358", "Meinerzhagen\-Valbert",
"496026", "Grossostheim",
"496342", "Schweigen\-Rechtenbach",
"496440", "Kölschhausen",
"4939957", "Gielow",
"494856", "Kronprinzenkoog",
"493327", "Werder\ Havel",
"495939", "Sustrum",
"492963", "Brilon\-Messinghausen",
"494554", "Wahlstedt",
"4937298", "Oelsnitz\ Erzgebirge",
"495483", "Lienen",
"499542", "Schesslitz",
"492562", "Gronau\ Westfalen",
"4936646", "Tanna\ bei\ Schleiz",
"499943", "Lam\ Oberpfalz",
"494462", "Wittmund",
"4936482", "Triptis",
"493588", "Niesky",
"498384", "Röthenbach\ Allgäu",
"494779", "Freiburg\ Elbe",
"495651", "Eschwege",
"496851", "St\ Wendel",
"4934671", "Bad\ Frankenhausen\ Kyffhäuser",
"492454", "Gangelt",
"499748", "Motten",
"495691", "Bad\ Arolsen",
"4939722", "Sarnow\ bei\ Anklam",};
$areanames{de} = {"4935753", "Großräschen",
"495053", "Faßberg\-Müden",
"498170", "Straßlach\-Dingharting",
"496364", "Nußbach\ Pfalz",
"496252", "Heppenheim\ Bergstraße",
"497351", "Biberach\ an\ der\ Riß",
"49911", "Nürnberg",
"498536", "Kößlarn",
"4936484", "Knau\ bei\ Pößneck",
"496321", "Neustadt\ an\ der\ Weinstraße",
"4939934", "Groß\ Plasten",
"4936949", "Obermaßfeld\-Grimmenthal",
"494684", "Langeneß\ Hallig",
"498807", "Dießen\ am\ Ammersee",
"499242", "Gößweinstein",
"4939976", "Groß\ Bützin",
"497162", "Süßen",
"499636", "Plößberg",
"498633", "Tüßling",
"4936705", "Oberweißbach\ Thüringer\ Wald",
"492339", "Sprockhövel\-Haßlinghausen",
"495827", "Unterlüß",
"499141", "Weißenburg\ in\ Bayern",
"497355", "Hochdorf\ Riß",
"4938234", "Born\ Darß",
"4939883", "Groß\ Dölln",
"492203", "Köln\-Porz",
"4934445", "Stößen",
"4934901", "Roßlau\ Elbe",
"494509", "Groß\ Grönau",
"4934493", "Gößnitz\ Thüringen",
"499656", "Moosbach\ bei\ Vohenstrauß",
"4935952", "Großröhrsdorf\ OL",
"495064", "Groß\ Düngen",
"49221", "Köln",
"498367", "Roßhaupten\ Forggensee",
"4936072", "Weißenborn\-Lüderode",
"494497", "Barßel\-Harkebrügge",
"499567", "Seßlach\-Gemünda",
"4935726", "Groß\ Särchen",
"4935938", "Großpostwitz\ OL",
"496663", "Steinau\ an\ der\ Straße",
"4935248", "Schönfeld\ bei\ Großenhain",
"4935240", "Tauscha\ bei\ Großenhain",
"4935841", "Großschönau\ Sachsen",
"495384", "Seesen\-Groß\ Rhüden",
"494483", "Ovelgönne\-Großenmeer",
"4989", "München",
"493647", "Pößneck",};
my $timezones = {
               '' => [
                       'Europe/Berlin'
                     ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+49|\D)//g;
      my $self = bless({ country_code => '49', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '49', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;