# Generated by default/object.tt
package Paws::Glue::MongoDBTarget;
  use Moose;
  has ConnectionName => (is => 'ro', isa => 'Str');
  has Path => (is => 'ro', isa => 'Str');
  has ScanAll => (is => 'ro', isa => 'Bool');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Glue::MongoDBTarget

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Glue::MongoDBTarget object:

  $service_obj->Method(Att1 => { ConnectionName => $value, ..., ScanAll => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Glue::MongoDBTarget object:

  $result = $service_obj->Method(...);
  $result->Att1->ConnectionName

=head1 DESCRIPTION

Specifies an Amazon DocumentDB or MongoDB data store to crawl.

=head1 ATTRIBUTES


=head2 ConnectionName => Str

The name of the connection to use to connect to the Amazon DocumentDB
or MongoDB target.


=head2 Path => Str

The path of the Amazon DocumentDB or MongoDB target
(database/collection).


=head2 ScanAll => Bool

Indicates whether to scan all the records, or to sample rows from the
table. Scanning all the records can take a long time when the table is
not a high throughput table.

A value of C<true> means to scan all records, while a value of C<false>
means to sample the records. If no value is specified, the value
defaults to C<true>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Glue>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

