# Generated by default/object.tt
package Paws::EMR::NotebookExecutionSummary;
  use Moose;
  has EditorId => (is => 'ro', isa => 'Str');
  has EndTime => (is => 'ro', isa => 'Str');
  has NotebookExecutionId => (is => 'ro', isa => 'Str');
  has NotebookExecutionName => (is => 'ro', isa => 'Str');
  has StartTime => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::EMR::NotebookExecutionSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::EMR::NotebookExecutionSummary object:

  $service_obj->Method(Att1 => { EditorId => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::EMR::NotebookExecutionSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->EditorId

=head1 DESCRIPTION

This class has no description

=head1 ATTRIBUTES


=head2 EditorId => Str

The unique identifier of the editor associated with the notebook
execution.


=head2 EndTime => Str

The timestamp when notebook execution started.


=head2 NotebookExecutionId => Str

The unique identifier of the notebook execution.


=head2 NotebookExecutionName => Str

The name of the notebook execution.


=head2 StartTime => Str

The timestamp when notebook execution started.


=head2 Status => Str

The status of the notebook execution.

=over

=item *

C<START_PENDING> indicates that the cluster has received the execution
request but execution has not begun.

=item *

C<STARTING> indicates that the execution is starting on the cluster.

=item *

C<RUNNING> indicates that the execution is being processed by the
cluster.

=item *

C<FINISHING> indicates that execution processing is in the final
stages.

=item *

C<FINISHED> indicates that the execution has completed without error.

=item *

C<FAILING> indicates that the execution is failing and will not finish
successfully.

=item *

C<FAILED> indicates that the execution failed.

=item *

C<STOP_PENDING> indicates that the cluster has received a
C<StopNotebookExecution> request and the stop is pending.

=item *

C<STOPPING> indicates that the cluster is in the process of stopping
the execution as a result of a C<StopNotebookExecution> request.

=item *

C<STOPPED> indicates that the execution stopped because of a
C<StopNotebookExecution> request.

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::EMR>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

