# This Makefile.PL for Crypt-OpenSSL-SignCSR was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.49.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use 5.014;
use ExtUtils::MakeMaker;

use Config;
use File::Spec;
use Crypt::OpenSSL::Guess;
use Crypt::OpenSSL::ConfiguredAPI;

my %args;

my ($major, $minor, $patch) = openssl_version();
print "Installed OpenSSL: $major.$minor.$patch\n";

my $version = ($major * 10000) + ($minor * 100);
my $api = Crypt::OpenSSL::ConfiguredAPI::get_configured_api();
print "API version read $api\n";

if (!$api) {
    my $prefix = find_openssl_prefix();
    my $exec = find_openssl_exec($prefix);
    if (`$exec version` =~ m/LibreSSL/){
        $api = 10100;
        print "LibreSSL detected setting api to 10100\n";
    }
}

my $compat = $api ne 0 ? $api : $version;
print "OPENSSL_COMPAT_API set to: $compat\n";

$args{INC} =  openssl_inc_paths();
$args{LIBS} = [openssl_lib_paths() . ' -lssl -lcrypto'];

my $cc_option_flags = " -DOPENSSL_API_COMPAT=$compat";

if ($Config::Config{cc} =~ /gcc/i) {
  $cc_option_flags .= $ENV{AUTHOR_TESTING} ? ' -Wall -Werror' : ' -Wall';
} else {
  $cc_option_flags .= '';
}

if ($Config{gccversion} =~ /llvm/i) {
  if ( $^O eq 'darwin' && (
    $Config{gccversion} =~ /LLVM 1[2-9].\d.[5-9]/ ||
    $Config{gccversion} =~ /LLVM 1[3-9]/ ))
  {
    $cc_option_flags .= ' -Wno-deprecated-declarations -Wno-compound-token-split-by-macro';
  } else {
    $cc_option_flags .= ' -Wno-deprecated-declarations';
  }

  if ($Config{gccversion} =~ /llvm 13/i) {
      $cc_option_flags .= ' -Wno-compound-token-split-by-macro';
  }

  if ($Config{PERL_VERSION} <= 20) {
    $cc_option_flags .= ' -Wno-error=pointer-bool-conversion';
  }
}

if ($Config{myuname} =~ /sunos|solaris/i) {
  $args{OPTIMIZE} = $cc_option_flags;
} else {
  $args{OPTIMIZE} = $cc_option_flags;
}

my %WriteMakefileArgs = (
  "ABSTRACT" => "Sign a Certificate Signing Request in XS.",
  "AUTHOR" => "Timothy Legge <timlegge\@cpan.org>",
  "BUILD_REQUIRES" => {
    "Crypt::OpenSSL::ConfiguredAPI" => 0,
    "Crypt::OpenSSL::Guess" => 0
  },
  "CONFIGURE_REQUIRES" => {
    "Crypt::OpenSSL::ConfiguredAPI" => 0,
    "Crypt::OpenSSL::Guess" => 0,
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME" => "Crypt-OpenSSL-SignCSR",
  "LICENSE" => "apache",
  "MIN_PERL_VERSION" => "5.014",
  "NAME" => "Crypt::OpenSSL::SignCSR",
  "PREREQ_PM" => {
    "Exporter" => 0,
    "XSLoader" => 0
  },
  "TEST_REQUIRES" => {
    "Crypt::OpenSSL::Guess" => 0,
    "Crypt::OpenSSL::PKCS10" => "0.19",
    "Crypt::OpenSSL::RSA" => 0,
    "File::Slurper" => "0.012",
    "File::Temp" => 0,
    "File::Which" => 0,
    "Test::More" => "0.88"
  },
  "VERSION" => "0.14",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

%WriteMakefileArgs = (
    %WriteMakefileArgs,
    %args,
);

my %FallbackPrereqs = (
  "Crypt::OpenSSL::ConfiguredAPI" => 0,
  "Crypt::OpenSSL::Guess" => 0,
  "Crypt::OpenSSL::PKCS10" => "0.19",
  "Crypt::OpenSSL::RSA" => 0,
  "Exporter" => 0,
  "File::Slurper" => "0.012",
  "File::Temp" => 0,
  "File::Which" => 0,
  "Test::More" => "0.88",
  "XSLoader" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);
