/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.openqa.selenium.grid.web.CombinedRoute;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.grid.web.PredicatedRoute;
import org.openqa.selenium.grid.web.Route;
import org.openqa.selenium.grid.web.SpecificRoute;
import org.openqa.selenium.injector.Injector;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;

public class Routes {
    private final BiFunction<Injector, HttpRequest, CommandHandler> handlerFunc;

    Routes(BiFunction<Injector, HttpRequest, CommandHandler> handlerFunc) {
        this.handlerFunc = Objects.requireNonNull(handlerFunc);
    }

    public static PredicatedRoute matching(Predicate<HttpRequest> predicate) {
        return new PredicatedRoute(predicate);
    }

    public static SpecificRoute delete(String template) {
        return new SpecificRoute(HttpMethod.DELETE, template);
    }

    public static SpecificRoute get(String template) {
        return new SpecificRoute(HttpMethod.GET, template);
    }

    public static SpecificRoute post(String template) {
        return new SpecificRoute(HttpMethod.POST, template);
    }

    public static CombinedRoute combine(Route atLeastOne, Route ... optionalOthers) {
        return Routes.combine(atLeastOne.build(), (Routes[])Arrays.stream(optionalOthers).map(Route::build).toArray(Routes[]::new));
    }

    public static CombinedRoute combine(Routes atLeastOne, Routes ... optionalOthers) {
        ImmutableList queue = Stream.concat(Stream.of(atLeastOne), Arrays.stream(optionalOthers)).collect(ImmutableList.toImmutableList());
        return new CombinedRoute(queue.reverse());
    }

    public Optional<CommandHandler> match(Injector injector, HttpRequest request) {
        return Optional.ofNullable(this.handlerFunc.apply(injector, request));
    }
}

