# -*- mode: perl; -*-

use strict;
use warnings;

use Test::More tests => 929;

use Math::BigFloat;

while (<DATA>) {
    s/#.*$//;                   # remove comments
    s/\s+$//;                   # remove trailing whitespace
    next unless length;         # skip empty lines

    my ($x_str, $expected) = split /:/;
    my ($x, $str);

    for my $accu ("undef", "20") {
        my $test = qq|Math::BigFloat -> accuracy($accu);|
                 . qq| \$x = Math::BigFloat -> new("$x_str");|
                 . qq| \$str = \$x -> bestr();|;

        note "\n$test\n\n";
        eval $test;
        die $@ if $@;           # should never happen

        is($str, $expected, qq|output is "$expected"|);
        if ($x_str eq 'NaN') {
            ok($x -> is_nan(), "input object is unmodified");
        } else {
            cmp_ok($x, "==", $x_str, "input object is unmodified");
        }
    }
}

# Reset accuracy and precision.

Math::BigFloat -> accuracy(undef);
Math::BigFloat -> precision(undef);

# 355/113 rounded to 40 digits.

my $str = '3.141592920353982300884955752212389380531';

# Default rounding.

note(qq|\nMath::BigFloat -> new("$str") -> bestr();\n\n|);
is(Math::BigFloat -> new($str) -> bestr(),
   '3.141592920353982300884955752212389380531e+0');

# Accuracy as argument.

note(qq|\nMath::BigFloat -> new("$str") -> bestr(3);\n\n|);
is(Math::BigFloat -> new($str) -> bestr(3), '3.14e+0');

# Precision as argument.

note(qq|\nMath::BigFloat -> new("$str") -> bestr(undef, -3);\n\n|);
is(Math::BigFloat -> new($str) -> bestr(undef, -3), '3.142e+0');

# Accuracy as class variable.

note(qq|\nMath::BigFloat -> accuracy(5); Math::BigFloat -> new("$str") -> bestr();\n\n|);
Math::BigFloat -> accuracy(5);
is(Math::BigFloat -> new($str) -> bestr(), '3.1416e+0');

# Precision as class variable.

note(qq|\nMath::BigFloat -> precision(-5); Math::BigFloat -> new("$str") -> bestr();\n\n|);
Math::BigFloat -> precision(-5);
is(Math::BigFloat -> new($str) -> bestr(), '3.14159e+0');

__DATA__

NaN:NaN

inf:inf
-inf:-inf

0:0e+0
-0:0e+0

# positive numbers

0.000000000001:1e-12
0.00000000001:10e-12
0.0000000001:100e-12
0.000000001:1e-9
0.00000001:10e-9
0.0000001:100e-9
0.000001:1e-6
0.00001:10e-6
0.0001:100e-6
0.001:1e-3
0.01:10e-3
0.1:100e-3
1:1e+0
10:10e+0
100:100e+0
1000:1e+3
10000:10e+3
100000:100e+3
1000000:1e+6
10000000:10e+6
100000000:100e+6
1000000000:1e+9
10000000000:10e+9
100000000000:100e+9
1000000000000:1e+12

0.0000000000012:1.2e-12
0.000000000012:12e-12
0.00000000012:120e-12
0.0000000012:1.2e-9
0.000000012:12e-9
0.00000012:120e-9
0.0000012:1.2e-6
0.000012:12e-6
0.00012:120e-6
0.0012:1.2e-3
0.012:12e-3
0.12:120e-3
1.2:1.2e+0
12:12e+0
120:120e+0
1200:1.2e+3
12000:12e+3
120000:120e+3
1200000:1.2e+6
12000000:12e+6
120000000:120e+6
1200000000:1.2e+9
12000000000:12e+9
120000000000:120e+9
1200000000000:1.2e+12

0.00000000000123:1.23e-12
0.0000000000123:12.3e-12
0.000000000123:123e-12
0.00000000123:1.23e-9
0.0000000123:12.3e-9
0.000000123:123e-9
0.00000123:1.23e-6
0.0000123:12.3e-6
0.000123:123e-6
0.00123:1.23e-3
0.0123:12.3e-3
0.123:123e-3
1.23:1.23e+0
12.3:12.3e+0
123:123e+0
1230:1.23e+3
12300:12.3e+3
123000:123e+3
1230000:1.23e+6
12300000:12.3e+6
123000000:123e+6
1230000000:1.23e+9
12300000000:12.3e+9
123000000000:123e+9
1230000000000:1.23e+12

0.000000000001234:1.234e-12
0.00000000001234:12.34e-12
0.0000000001234:123.4e-12
0.000000001234:1.234e-9
0.00000001234:12.34e-9
0.0000001234:123.4e-9
0.000001234:1.234e-6
0.00001234:12.34e-6
0.0001234:123.4e-6
0.001234:1.234e-3
0.01234:12.34e-3
0.1234:123.4e-3
1.234:1.234e+0
12.34:12.34e+0
123.4:123.4e+0
1234:1.234e+3
12340:12.34e+3
123400:123.4e+3
1234000:1.234e+6
12340000:12.34e+6
123400000:123.4e+6
1234000000:1.234e+9
12340000000:12.34e+9
123400000000:123.4e+9
1234000000000:1.234e+12

0.000003141592:3.141592e-6
0.00003141592:31.41592e-6
0.0003141592:314.1592e-6
0.003141592:3.141592e-3
0.03141592:31.41592e-3
0.3141592:314.1592e-3
3.141592:3.141592e+0
31.41592:31.41592e+0
314.1592:314.1592e+0
3141.592:3.141592e+3
31415.92:31.41592e+3
314159.2:314.1592e+3
3141592:3.141592e+6

# negative numbers

-0.000000000001:-1e-12
-0.00000000001:-10e-12
-0.0000000001:-100e-12
-0.000000001:-1e-9
-0.00000001:-10e-9
-0.0000001:-100e-9
-0.000001:-1e-6
-0.00001:-10e-6
-0.0001:-100e-6
-0.001:-1e-3
-0.01:-10e-3
-0.1:-100e-3
-1:-1e+0
-10:-10e+0
-100:-100e+0
-1000:-1e+3
-10000:-10e+3
-100000:-100e+3
-1000000:-1e+6
-10000000:-10e+6
-100000000:-100e+6
-1000000000:-1e+9
-10000000000:-10e+9
-100000000000:-100e+9
-1000000000000:-1e+12

-0.0000000000012:-1.2e-12
-0.000000000012:-12e-12
-0.00000000012:-120e-12
-0.0000000012:-1.2e-9
-0.000000012:-12e-9
-0.00000012:-120e-9
-0.0000012:-1.2e-6
-0.000012:-12e-6
-0.00012:-120e-6
-0.0012:-1.2e-3
-0.012:-12e-3
-0.12:-120e-3
-1.2:-1.2e+0
-12:-12e+0
-120:-120e+0
-1200:-1.2e+3
-12000:-12e+3
-120000:-120e+3
-1200000:-1.2e+6
-12000000:-12e+6
-120000000:-120e+6
-1200000000:-1.2e+9
-12000000000:-12e+9
-120000000000:-120e+9
-1200000000000:-1.2e+12

-0.00000000000123:-1.23e-12
-0.0000000000123:-12.3e-12
-0.000000000123:-123e-12
-0.00000000123:-1.23e-9
-0.0000000123:-12.3e-9
-0.000000123:-123e-9
-0.00000123:-1.23e-6
-0.0000123:-12.3e-6
-0.000123:-123e-6
-0.00123:-1.23e-3
-0.0123:-12.3e-3
-0.123:-123e-3
-1.23:-1.23e+0
-12.3:-12.3e+0
-123:-123e+0
-1230:-1.23e+3
-12300:-12.3e+3
-123000:-123e+3
-1230000:-1.23e+6
-12300000:-12.3e+6
-123000000:-123e+6
-1230000000:-1.23e+9
-12300000000:-12.3e+9
-123000000000:-123e+9
-1230000000000:-1.23e+12

-0.000000000001234:-1.234e-12
-0.00000000001234:-12.34e-12
-0.0000000001234:-123.4e-12
-0.000000001234:-1.234e-9
-0.00000001234:-12.34e-9
-0.0000001234:-123.4e-9
-0.000001234:-1.234e-6
-0.00001234:-12.34e-6
-0.0001234:-123.4e-6
-0.001234:-1.234e-3
-0.01234:-12.34e-3
-0.1234:-123.4e-3
-1.234:-1.234e+0
-12.34:-12.34e+0
-123.4:-123.4e+0
-1234:-1.234e+3
-12340:-12.34e+3
-123400:-123.4e+3
-1234000:-1.234e+6
-12340000:-12.34e+6
-123400000:-123.4e+6
-1234000000:-1.234e+9
-12340000000:-12.34e+9
-123400000000:-123.4e+9
-1234000000000:-1.234e+12

-0.000003141592:-3.141592e-6
-0.00003141592:-31.41592e-6
-0.0003141592:-314.1592e-6
-0.003141592:-3.141592e-3
-0.03141592:-31.41592e-3
-0.3141592:-314.1592e-3
-3.141592:-3.141592e+0
-31.41592:-31.41592e+0
-314.1592:-314.1592e+0
-3141.592:-3.141592e+3
-31415.92:-31.41592e+3
-314159.2:-314.1592e+3
-3141592:-3.141592e+6
