package Task::PYX;

use strict;
use warnings;

our $VERSION = 0.10;

1;

__END__

=pod

=encoding utf8

=head1 NAME

Task::PYX - Install the PYX modules.

=head1 SYNOPSIS

 cpanm Task::PYX

=head1 SEE ALSO

=over

=item L<App::PYX2XML>

Perl class for pyx2xml application.

=item L<PYX>

A perl module for PYX handling.

=item L<PYX::GraphViz>

GraphViz output for PYX handling.

=item L<PYX::Hist>

Processing PYX data or file and print histogram.

=item L<PYX::Parser>

PYX parser.

=item L<PYX::SGML::Raw>

Processing PYX data or file and write as SGML.

=item L<PYX::SGML::Tags>

Processing PYX data or file and write as SGML via Tags.

=item L<PYX::Sort>

Processing PYX data or file and sort element attributes.

=item L<PYX::Stack>

Processing PYX data or file and process element stack.

=item L<PYX::Utils>

PYX common utilities for encoding and decoding data.

=item L<PYX::XMLNorm>

Processing PYX data or file and do XML normalization.

=item L<PYX::XMLSchema::List>

Processing PYX data or file and print list of XML schemas.

=item L<SGML::PYX>

Convertor between SGML and PYX.

=item L<Tags::Output::PYX>

Tags output to PYX format.

=item L<XML::MinWriter>

Perl extension for writing XML in PYX format.

=item L<XML::PYX>

PYX parser based on XML::Parser.

=back

=head1 REPOSITORY

L<https://github.com/michal-josef-spacek/Task-PYX>

=head1 AUTHOR

Michal Josef Špaček L<mailto:skim@cpan.org>

L<http://skim.cz>

=head1 LICENSE AND COPYRIGHT

© 2015-2023 Michal Josef Špaček

Artistic License

BSD 2-Clause License

=head1 VERSION

0.10

=cut
