/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Slot
implements Comparable<Slot> {
    private final double start;
    private final double end;

    public Slot(double d, double d2) {
        if (d >= d2) {
            throw new IllegalArgumentException();
        }
        this.start = d;
        this.end = d2;
    }

    public String toString() {
        return "(" + this.start + "," + this.end + ")";
    }

    public double getStart() {
        return this.start;
    }

    public double getEnd() {
        return this.end;
    }

    public double size() {
        return this.end - this.start;
    }

    public boolean contains(double d) {
        return d >= this.start && d <= this.end;
    }

    public boolean intersect(Slot slot) {
        return this.contains(slot.start) || this.contains(slot.end) || slot.contains(this.start) || slot.contains(this.end);
    }

    public Slot merge(Slot slot) {
        return new Slot(Math.min(this.start, slot.start), Math.max(this.end, slot.end));
    }

    @Override
    public int compareTo(Slot slot) {
        if (this.start < slot.start) {
            return -1;
        }
        if (this.start > slot.start) {
            return 1;
        }
        return 0;
    }
}

