/*
 * Decompiled with CFR 0.152.
 */
package com.vizdom.ber;

import com.vizdom.ber.BerIdentifier;
import com.vizdom.ber.BerModule;
import com.vizdom.ber.BerObject;
import com.vizdom.util.CharacterEncoder;
import com.vizdom.util.UnreachableCodeException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class BerOctetString
extends BerObject {
    static final BerIdentifier gIDENTIFIER = new BerIdentifier(0, 4);
    private byte[] mByteArray;
    private String mString;
    private String mCharacterEncoding;

    protected BerOctetString() {
    }

    public BerOctetString(String aString, String aCharacterEncoding) throws UnsupportedEncodingException {
        this.mByteArray = CharacterEncoder.toByteArray(aString, aCharacterEncoding);
        this.mString = aString;
    }

    public BerOctetString(byte[] aByteArray, String aCharacterEncoding) throws UnsupportedEncodingException {
        this.mByteArray = aByteArray;
        this.mCharacterEncoding = aCharacterEncoding;
        this.mString = null;
    }

    public BerOctetString(byte[] aByteArray) {
        this.mByteArray = aByteArray;
        this.mString = null;
        this.mCharacterEncoding = null;
    }

    @Override
    public BerIdentifier getIdentifier() {
        return gIDENTIFIER;
    }

    @Override
    protected final int mGetLength() {
        return this.mByteArray.length;
    }

    @Override
    protected final void mWriteContents(OutputStream anOut) throws IOException {
        anOut.write(this.mByteArray);
    }

    @Override
    protected void mReadContents(InputStream anIn, BerModule aModule, BerIdentifier anIdentifier, int aLength) throws IOException {
        int count;
        this.mByteArray = new byte[aLength];
        for (int offset = 0; offset < aLength; offset += count) {
            count = anIn.read(this.mByteArray, offset, aLength - offset);
            if (count != -1) continue;
            throw new EOFException();
        }
        this.mCharacterEncoding = aModule.getCharacterEncoding();
        this.mString = null;
    }

    public byte[] toByteArray() {
        return this.mByteArray;
    }

    @Override
    public synchronized String toString() {
        if (this.mString == null) {
            if (this.mByteArray.length == 0) {
                this.mString = "";
            } else if (this.mCharacterEncoding == null) {
                this.mString = new String(this.mByteArray);
            } else {
                try {
                    this.mString = CharacterEncoder.toString(this.mByteArray, this.mCharacterEncoding);
                }
                catch (UnsupportedEncodingException e) {
                    throw new UnreachableCodeException(e);
                }
            }
        }
        return this.mString;
    }

    public String toString(String aCharacterEncoding) throws UnsupportedEncodingException {
        return CharacterEncoder.toString(this.mByteArray, aCharacterEncoding);
    }
}

