/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.ScriptPreProcessor;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.util.regex.Pattern;

public class IEWeirdSyntaxScriptPreProcessor
implements ScriptPreProcessor {
    private static final IEWeirdSyntaxScriptPreProcessor instance_ = new IEWeirdSyntaxScriptPreProcessor();
    private static final Pattern patternFinally_ = Pattern.compile("(\\}(?:\\s*(?://.*\\n)?)*);((?:\\s*(?://.*\\n)?)*finally)");
    private static final Pattern patternCatch_ = Pattern.compile("(\\}(?:\\s*(?://.*\\n)?)*);((?:\\s*(?://.*\\n)?)*catch)");

    public static IEWeirdSyntaxScriptPreProcessor getInstance() {
        return instance_;
    }

    @Override
    public String preProcess(HtmlPage htmlPage, String sourceCode, String sourceName, int lineNumber, HtmlElement htmlElement) {
        if (sourceCode.contains("catch")) {
            sourceCode = patternCatch_.matcher(sourceCode).replaceAll("$1 $2");
        }
        if (sourceCode.contains("finally")) {
            sourceCode = patternFinally_.matcher(sourceCode).replaceAll("$1 $2");
        }
        return sourceCode;
    }
}

