// Copyright (c) 2011 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// Created by postproc-shortwords 1.9 on 2011-04-06 14:00:13
// From command line:
//  --delta_octa --wrt=cld_generated_quadchrome.bin --standard --minchars=5
//  --mincount=2 --max_items_per_langscript=200 --boostcloseweakerpercent=10
//  --flatmap --rr_alloc --freq_alloc --indirectbits=12 --thresh=210 --v25
//  --kentries=4 --tablename=DeltaOctaChrome --34_full
//  --remap=xxx-Latn=>ut-Latn sh-Latn=>hr-Latn sh-Cyrl=>sr-Cyrl
//  nn-Latn=>no-Latn bh-Deva=>ut-Deva mr-Deva=>ut-Deva ne-Deva=>ut-Deva
//  lg-Latn=>ut-Latn rw-Latn=>ut-Latn gd-Latn=>ut-Latn  --include=af-Latn
//  ar-Arab be-Cyrl bg-Cyrl ca-Latn cs-Latn cy-Latn da-Latn de-Latn el-Grek
//  en-Latn es-Latn et-Latn fa-Arab fi-Latn fr-Latn ga-Latn gd-Latn hi-Deva
//  hr-Latn hu-Latn id-Latn is-Latn is-Latn it-Latn iw-Hebr ja-Hani ko-Hani
//  lg-Latn lt-Latn lv-Latn mk-Cyrl ms-Latn nl-Latn no-Latn pl-Latn pt-Latn
//  ro-Latn ru-Cyrl rw-Latn sh-Cyrl sh-Latn sk-Latn sl-Latn sr-Cyrl sv-Latn
//  sw-Latn th-Thai tl-Latn tr-Latn uk-Cyrl vi-Latn yi-Hebr zh-Hani zh-TW
//  sq-Latn az-Latn eu-Latn bn-Beng gl-Latn ht-Latn mt-Latn sr-Latn ur-Arab
//  ut-Latn ut-Deva  --force_to_lang_soft --soft_cram2 --nomsidlevel
//  --shapeflatprob --langpriorpercent=10 --skipnuc --shapeforcetop
//  --shapeeventop --shapesteep2 --langcounts --writebin --list_items=120
//  /export/hda3/cld/all_text_octa_0120_sort.utf8
//
//
// See compact_lang_det.cc for usage
//
#include "encodings/compact_lang_det/cldutil.h"

static const int kDeltaOctaChromeBuildDate = 20110406;    // yyyymmdd

COMPILE_ASSERT(MONTENEGRIN == 160, k_montenegrin_changed);
COMPILE_ASSERT(EXT_NUM_LANGUAGES >= 209, k_ext_num_languages_changed);

// Nil-grams: 20 languages
//     GREEK BENGALI MALAYALAM TELUGU TAMIL GUJARATI THAI KANNADA
//     PUNJABI GEORGIAN SINHALESE ARMENIAN LAOTHIAN KHMER DHIVEHI
//     CHEROKEE SYRIAC LIMBU ORIYA INUKTITUT

// Uni-grams: 6 languages
//     Japanese Korean Chinese VIETNAMESE ChineseT ZHUANG

// Words/Quads/Gibberish: 52 languages in range ENGLISH..HAITIAN_CREOLE:
//     ENGLISH DANISH DUTCH FINNISH FRENCH GERMAN HEBREW ITALIAN
//     NORWEGIAN POLISH PORTUGUESE RUSSIAN SPANISH SWEDISH CZECH
//     ICELANDIC LATVIAN LITHUANIAN ROMANIAN HUNGARIAN ESTONIAN
//     Ignore BULGARIAN CROATIAN SERBIAN IRISH GALICIAN TAGALOG
//     TURKISH UKRAINIAN HINDI MACEDONIAN INDONESIAN MALAY WELSH
//     ALBANIAN BELARUSIAN URDU ARABIC CATALAN BASQUE SWAHILI
//     SLOVENIAN MALTESE VIETNAMESE SLOVAK AZERBAIJANI PERSIAN
//     YIDDISH AFRIKAANS HAITIAN_CREOLE

//  ENGLISH 50
//  DANISH 61
//  DUTCH 56
//  FINNISH 55
//  FRENCH 63
//  GERMAN 54
//  HEBREW 56
//  ITALIAN 63
//  NORWEGIAN 60
//  POLISH 56
//  PORTUGUESE 51
//  RUSSIAN 63
//  SPANISH 49
//  SWEDISH 60
//  CZECH 55
//  ICELANDIC 52
//  LATVIAN 55
//  LITHUANIAN 60
//  ROMANIAN 48
//  HUNGARIAN 59
//  ESTONIAN 54
//  Ignore 128
//  BULGARIAN 56
//  CROATIAN 57
//  SERBIAN 115
//  IRISH 62
//  GALICIAN 60
//  TAGALOG 50
//  TURKISH 53
//  UKRAINIAN 58
//  HINDI 53
//  MACEDONIAN 61
//  BENGALI 58
//  INDONESIAN 56
//  MALAY 57
//  WELSH 55
//  ALBANIAN 58
//  BELARUSIAN 60
//  URDU 59
//  ARABIC 57
//  CATALAN 59
//  BASQUE 55
//  SWAHILI 59
//  SLOVENIAN 59
//  MALTESE 52
//  VIETNAMESE 56
//  SLOVAK 60
//  AZERBAIJANI 58
//  PERSIAN 46
//  YIDDISH 59
//  AFRIKAANS 58
//  HAITIAN_CREOLE 58


static const int kDeltaOctaChromeSize = 1024;    // Bucket count
static const int kDeltaOctaChromeKeyMask = 0xfffff000;    // Mask hash key

// Of 906355 offered items (into 4096 table entries):
// 3069 filled (0%), 3 merged (0%), 7728 dropped (0%)
// 895555 items ignored: over --max_items_per_langscript
static const cld::IndirectProbBucket4 kDeltaOctaChrome[kDeltaOctaChromeSize] = {
  // key[4], words[4] in UTF-8
  // value[4]
  { {0xe200c001,0x02fe7002,0xd83dc003,0x00000000}},	// [000] _galite_, _cargar_, _مشابہ_,
  { {0x67c95004,0x23866005,0x62647006,0x00000000}},	//   _zastosow, _soort_, _zaslal_,
  { {0xe25a6007,0x1097e008,0x242bc009,0x00000000}},	//   _poolt_, _времени_, _مساجد_,
  { {0x72bb900a,0x23f8500b,0x2200c00c,0x00000000}},	//   _referee_, _palun_, _kalite_,
  { {0x99da400d,0x9b7dd00e,0x52d8d00f,0x00000000}},	//   _galleria_, _prenumer, _order_,
  { {0xd25b6010,0xa1452011,0x125a600f,0x00000000}},	//   _ingles_, _materjal, _tools_,
  { {0xc27e6012,0x22240013,0x13954014,0x00000000}},	//   _huong_, _usiku_, _pjesma_,
  { {0x6291e015,0x96b11016,0xbc1bf017,0x00000000}},	//   _antal_, _sigurish, _undanfar,
  { {0xf3ea900f,0xfcddf018,0x8a3e5019,0x00000000}},	//   _state_, _колектив, _haritası_,
  { {0x234aa009,0x7c69f01a,0x03c87007,0x00000000}},	//   _خریدار_, _burundi_, _tervis_,
  { {0xf291901b,0x299fd009,0x027e6012,0x00000000}},	//   _insan_, _صحابہ_, _luong_,
  { {0x62ca301c,0x227f401d,0x3291f01e,0x00000000}},	//   _üldse_, _tienen_, _hutan_,
  { {0x9afd601b,0x6c5a501f,0x64225020,0x00000000}},	//   _investis, _menteri_, _indirizz,
  { {0xf3f83007,0x12cb8015,0x6b6d0021,0x00000000}},	//   _samuti_, _borde_, _exporter,
  { {0x742a6022,0x79eb2009,0xd3ebe020,0x00000000}},	//   _правильн, _طاہرالقا, _detto_,
  { {0xc3f82023,0xe3a7e003,0x41ce5024,0x00000000}},	//   _sikur_, _مجموعی_, _положенн,
  { {0xf27ed025,0x23954026,0xc2909027,0x00000000}},	// [010] _ocena_, _viesti_, _izjave_,
  { {0xe394d028,0xac0ae021,0x23730029,0x00000000}},	//   _viesu_, _stoppen_, _איזראעלי_,
  { {0xd3eb9002,0xfc7d902a,0x92fce02b,0x00000000}},	//   _desta_, _consejo_, _mangel_,
  { {0xa200c02c,0x92d8c02d,0x2c62101b,0x00000000}},	//   _undir_, _under_, _forumun_,
  { {0x52c59012,0xae38f02e,0x4469502f,0x00000000}},	//   _beeline_, _veransta, _пристигн,
  { {0x03ea6030,0x627f001a,0x0ad20031,0x00000000}},	//   _multe_, _abandi_, _gratuite,
  { {0x96dcb032,0x72d17009,0x99643033,0x00000000}},	//   _फिलिम_, _لوکلائزی, _favorile,
  { {0xa2a6a010,0x93a92034,0x65af3035,0x00000000}},	//   _gabby_, _private_, _споразум,
  { {0x92d98036,0xefe3a037,0xb2fc0001,0x00000000}},	//   _diren_, _розныя_, _taigi_,
  { {0x62feb038,0x92cae021,0xa25b9039,0x00000000}},	//   _activar_, _landen_, _jesli_,
  { {0xf231103a,0x585c903b,0x0394203c,0x00000000}},	//   _stammen_, _maalisku, _maksa_,
  { {0x62d9f03d,0x32b5203e,0x87aa703f,0x00000000}},	//   _zuten_, _conduce_, _instelli,
  { {0xb25a6040,0x8ae64041,0x2ec5c035,0x00000000}},	//   _julle_, _সংলাপে, _главни_,
  { {0x9486c042,0xf64c9009,0x384c902f,0x00000000}},	//   _भंडारा, _متشابہہ_, _поставув,
  { {0x553c0043,0xa2d81036,0xc004c044,0x00000000}},	//   _तब्बल_, _lehen_, _elektrik_,
  { {0x6201c045,0xa401900c,0x4d978039,0x00000000}},	//   _invia_, _ameriken_, _motoryza,
  { {0xe0082029,0xa3866046,0x2ba4f015,0x00000000}},	// [020] _געגנטן_, _stori_, _diskuter,
  { {0x53eb9025,0xc66f6047,0xb2d8400f,0x00000000}},	//   _cesti_, _pozdrawi, _times_,
  { {0xfb25d048,0x32b1d049,0x92afc04a,0x00000000}},	//   _гледам_, _bendera_, _خصائص_,
  { {0x827e6012,0xeebc104b,0x10485047,0x00000000}},	//   _tuong_, _aktuelle_, _naturaln,
  { {0xa2d82036,0x32cb704c,0xc83b801c,0x00000000}},	//   _azken_, _stadig_, _väljende,
  { {0x02b4004d,0x92cae04e,0x03eaf002,0x00000000}},	//   _which_, _findes_, _manter_,
  { {0x525a504f,0xd2b40012,0x7237e050,0x00000000}},	//   _colli_, _thich_, _primera_,
  { {0xa2d99051,0x3b0c3020,0x83c86052,0x00000000}},	//   _eisen_, _rapprese, _kurven_,
  { {0x757b1053,0xf2006054,0x2ee9d055,0x00000000}},	//   _santiago_, _avoir_, _funksion,
  { {0x22919033,0xc6e80056,0xf27e0057,0x00000000}},	//   _nisan_, _контроль_, _brine_,
  { {0x8202604c,0x1e55e036,0x19ba3050,0x00000000}},	//   _ferien_, _espainia, _privacid,
  { {0x23ebe058,0x12001036,0x725a9044,0x00000000}},	//   _cette_, _behin_, _itali_,
  { {0x97293048,0xe248d059,0x2201c05a,0x00000000}},	//   _добри_, _umeme_, _envia_,
  { {0xfc113015,0xb2909059,0xcb57e05b,0x00000000}},	//   _helsingb, _kijana_, _пасаду_,
  { {0x9d29d009,0x225ae058,0xdb0f3053,0x00000000}},	//   _ڈیموکریٹ, _taille_, _disparat,
  { {0x8394705c,0x5249905d,0x03967021,0x00000000}},	//   _mense_, _mismo_, _lessen_,
  { {0xa2d8404e,0xd2918033,0x9202105e,0x00000000}},	// [030] _timer_, _murat_, _kopiju_,
  { {0x4cec105f,0x5c52a060,0xf201e061,0x00000000}},	//   _компаниј, _auktion_, _akció_,
  { {0x02fc6059,0x4290a062,0x0d2d9063,0x00000000}},	//   _ndogo_, _laban_, _napište_,
  { {0x8d3c3064,0xb2a7c065,0x8224d063,0x00000000}},	//   _velikost_, _района_, _funkce_,
  { {0x32489066,0x32cad040,0xfb14c035,0x00000000}},	//   _chama_, _reeds_, _извор_,
  { {0x2156b029,0xc27f702d,0xf630b04a,0x00000000}},	//   _ליובאַוו, _change_, _الأبيض_,
  { {0x82ca7052,0xa2009054,0x33ebe067,0x00000000}},	//   _hunde_, _avait_, _tette_,
  { {0xd27e703a,0xf2d9905a,0xb296c068,0x00000000}},	//   _kunne_, _museu_, _strateji_,
  { {0x5c55b03f,0x62787060,0xc3227069,0x00000000}},	//   _bestand_, _barnet_, _fesyen_,
  { {0xd236006a,0x4c51d06b,0x03ce006c,0x00000000}},	//   _prije_, _चालेल_, _prive_,
  { {0xbdc5e06c,0x37253029,0x307af06d,0x00000000}},	//   _elektora, _אנטשולדי, _besplatn,
  { {0x7225803b,0xb290202e,0x0d56006e,0x00000000}},	//   _turku_, _jemand_, _ליצירת_,
  { {0x6303f033,0x0ba7a06f,0x10a47029,0x00000000}},	//   _teknoloj, _पूछताछ, _לאַגער_,
  { {0xa386d070,0xf2902035,0xe2907010,0x00000000}},	//   _alert_, _kakav_, _banal_,
  { {0x72257071,0x9200501b,0x2f23105a,0x00000000}},	//   _praksa_, _bilir_, _explicar_,
  { {0xe343b04a,0x9408f072,0x426c9073,0x00000000}},	//   _بتوقيت_, _франківс, _nikoli_,
  { {0xe2c40029,0x2c54f074,0x8337c065,0x00000000}},	// [040] _פאסירן_, _ellenőrz, _николай_,
  { {0x72026069,0x23ebe075,0xfc496072,0x00000000}},	//   _terima_, _sette_, _банківсь,
  { {0xf5d9d072,0xaf212076,0xa3869014,0x00000000}},	//   _аналіз_, _esperien, _igara_,
  { {0x6c5d7012,0x93869077,0xb2fcd078,0x00000000}},	//   _viettel_, _muare_, _svega_,
  { {0xe27e9012,0xb3f40079,0x33ea9076,0x00000000}},	//   _quang_, _costas_, _stati_,
  { {0x13eb907a,0x6200707b,0x4290707c,0x00000000}},	//   _cestu_, _minis_, _minas_,
  { {0x52915033,0xe17bf009,0x42ca002d,0x00000000}},	//   _sigara_, _پھانسی_, _guide_,
  { {0x0712206f,0x6e46d04f,0x2582001a,0x00000000}},	//   _अन्दर_, _stratega, _amategek,
  { {0x5f4e0054,0x72908059,0xf2d80012,0x00000000}},	//   _personne_, _bahati_, _phien_,
  { {0xd6882056,0xc2d9606b,0x23ea0040,0x00000000}},	//   _контролю_, _kugeza_, _buite_,
  { {0xf3a3f047,0x03eae007,0x12d8707d,0x00000000}},	//   _grupy_, _kontot_, _ihned_,
  { {0xf5fbe07e,0x626ce027,0x1290307f,0x00000000}},	//   _акрамя_, _osnovi_, _cumann_,
  { {0x83e25080,0x905e6081,0x69fe6036,0x00000000}},	//   _természe, _ekonomik_, _ekonomia_,
  { {0x42004082,0xb2907049,0x02d86005,0x00000000}},	//   _jamii_, _dinas_, _groep_,
  { {0x73eb804e,0x2588d054,0xedc5d04a,0x00000000}},	//   _marts_, _activité, _طبعاً_,
  { {0x03eb900a,0xc2d99015,0x6847c02f,0x00000000}},	//   _bosta_, _anser_, _напади_,
  { {0x3387e020,0x743c0041,0xfcf8106e,0x00000000}},	// [050] _altre_, _সাকিব_, _התביעה_,
  { {0x13ead083,0xc395406a,0x23eb9083,0x00000000}},	//   _protiv_, _mjesto_, _dosta_,
  { {0x325a504f,0x0867a061,0x9e9e302e,0x00000000}},	//   _felly_, _április_, _erstellt_,
  { {0x89722084,0xe2d9001a,0x92d99060,0x00000000}},	//   _arhitekt, _imbere_, _huset_,
  { {0xe6a22085,0xf386c04f,0x23967086,0x00000000}},	//   _институц, _agored_, _passen_,
  { {0x93f47087,0xf991c088,0x4290f01d,0x00000000}},	//   _sistem_, _здравств, _lugar_,
  { {0x9394700c,0x805e605c,0x5f46300c,0x00000000}},	//   _panse_, _moontlik_, _aristide_,
  { {0x1394602d,0xe1e5b089,0xd290f08a,0x00000000}},	//   _those_, _politikë_, _tugas_,
  { {0x41ec106e,0x72d5608b,0x2c6fc036,0x00000000}},	//   _להכניס_, _vitoria_, _loturak_,
  { {0x37803008,0xf2927055,0xe3a5b027,0x00000000}},	//   _управлен, _mesazh_, _garancij,
  { {0x667c4072,0xc200208c,0x6942c08d,0x00000000}},	//   _комуналь, _ilkin_, _знакаміт,
  { {0x4294008e,0x8a69f08f,0x2b8ac090,0x00000000}},	//   _आंदोलन, _финансов, _новом_,
  { {0xe2925091,0xb2b9a092,0xc3eb9028,0x00000000}},	//   _totali_, _oíche_, _pastu_,
  { {0x0c5cf032,0xdd47b064,0x498b0093,0x00000000}},	//   _मिळेल_, _dispozic, _znači_,
  { {0xe2d84051,0xd2fd5094,0xa301e047,0x00000000}},	//   _nemen_, _kopiert_, _ostatni_,
  { {0x82902019,0x372a7009,0x4049a029,0x00000000}},	//   _fakat_, _سرِورق_, _אַהײם_,
  { {0x5b6cc05a,0x93030010,0xac6f7043,0x00000000}},	// [060] _estadíst, _salamat_, _afurika_,
  { {0x058fa06e,0x352a006e,0x79c89061,0x00000000}},	//   _אמצעי_, _בכתבות_, _automata_,
  { {0xc3f46079,0xc342705c,0xa2b47061,0x00000000}},	//   _curtha_, _beteken_, _sincs_,
  { {0xb290c01f,0xe5731095,0xdf839096,0x00000000}},	//   _badan_, _amatersk, _помощь_,
  { {0x12902097,0xafc2d009,0x1e54e008,0x00000000}},	//   _rekao_, _باجوڑ_, _экономич,
  { {0xb2011098,0x72002044,0x92d8a002,0x00000000}},	//   _bizim_, _jakim_, _babel_,
  { {0x49cc1099,0x612d208d,0xcbf5409a,0x00000000}},	//   _rendelke, _часта_, _espectac,
  { {0xf2e8d05e,0x6ac80029,0x0436309b,0x00000000}},	//   _tehniku_, _בערלין_, _praktick,
  { {0xe3ebe015,0x02908035,0x9fd63010,0x00000000}},	//   _detta_, _nekako_, _limitado,
  { {0x7544807e,0x5c77e091,0xe26c300b,0x00000000}},	//   _статысты, _estremi_, _remont_,
  { {0x2395909c,0x643e1035,0xadc47001,0x00000000}},	//   _sisse_, _јасно_, _konkursa,
  { {0xbb34309d,0x1715b06e,0xd249500b,0x00000000}},	//   _интересн, _רוחני_, _olemas_,
  { {0x93f9001a,0xa7b3600c,0x8d7bf06b,0x00000000}},	//   _kibuye_, _konstiti, _आराखडा,
  { {0x1d03209e,0x525c6045,0xc3ea708b,0x00000000}},	//   _خدمات_, _località_, _kontu_,
  { {0x6387709f,0xc75410a0,0x4387e0a1,0x00000000}},	//   _zdarma_, _независи, _betri_,
  { {0xa2595020,0x1c5620a2,0x044a106e,0x00000000}},	//   _particol, _काहें_, _בדצמבר_,
  { {0xfc124059,0x484ed050,0xd5ab0009,0x00000000}},	// [070] _kampuni_, _publicid, _گھنٹوں_,
  { {0x15c02041,0x4ae6e060,0x9c06e04e,0x00000000}},	//   _নাগরিক, _auktione, _auktions,
  { {0x6000d028,0x6c2d50a3,0x4201f0a4,0x00000000}},	//   _informāc, _espiritu_, _poziom_,
  { {0xf6b95051,0xb248002c,0x6301806d,0x00000000}},	//   _belangri, _heima_, _trebate_,
  { {0xd7c2d0a5,0x69f9b0a6,0x2291e06c,0x00000000}},	//   _বাইরে_, _професио, _mitan_,
  { {0x329040a7,0xe6cca092,0x42b60091,0x00000000}},	//   _teman_, _polainni, _muscat_,
  { {0xc2a6c04d,0x33795033,0x7201f069,0x00000000}},	//   _member_, _antalya_, _putih_,
  { {0xa3ea0026,0x0da110a8,0x89c9f0a9,0x00000000}},	//   _muita_, _پایگاه_, _germania_,
  { {0x72d850aa,0xaa1ec0ab,0x73c22067,0x00000000}},	//   _gelen_, _видим_, _rövid_,
  { {0x53fa7071,0x022810ac,0x93b6c035,0x00000000}},	//   _forumi_, _наступны, _забрани_,
  { {0xc2486097,0x1dabc0ad,0xf2ca0076,0x00000000}},	//   _veoma_, _kehidupa, _guida_,
  { {0x6200c061,0xefa720ae,0x0a1ed0ab,0x00000000}},	//   _pedig_, _komentar_, _видиш_,
  { {0x4290c021,0xcc61803a,0x22cae0af,0x00000000}},	//   _omdat_, _sverige_, _mvideo_,
  { {0x52bb104e,0xd2d8a030,0x65c7e041,0x00000000}},	//   _seneste_, _liber_, _রেকর্ড,
  { {0x4d111038,0x62d8405c,0xb98d1096,0x00000000}},	//   _arquitec, _hemel_, _написать_,
  { {0xb38750a1,0xa2d9808b,0xb926c088,0x00000000}},	//   _áfram_, _arren_, _причини_,
  { {0xdb9b502e,0xa635206b,0x8ec1807f,0x00000000}},	// [080] _technisc, _पदाधिक, _bronntan,
  { {0x920040b0,0x64c8708d,0x53eaf017,0x00000000}},	//   _damit_, _вызвален, _vantar_,
  { {0x13eb80b1,0xd468206e,0x92905036,0x00000000}},	//   _norte_, _בתהליך_, _zelan_,
  { {0x727e603a,0x1a5ca001,0x53f45015,0x00000000}},	//   _trong_, _galerija_, _mitten_,
  { {0x2c21404d,0x6fa720b2,0x0915e0b0,0x00000000}},	//   _company_, _comentar_, _verbindu,
  { {0x8200300a,0x52900030,0xeeb45002,0x00000000}},	//   _simili_, _chiar_, _recentes_,
  { {0xe37950b3,0x2868600b,0xa2a75091,0x00000000}},	//   _dudalen_, _ekspress_, _liebes_,
  { {0x6248d04b,0x897860b4,0x4386603a,0x00000000}},	//   _thema_, _amminist, _gjort_,
  { {0x92132063,0x4f4a4031,0x72d8f0b5,0x00000000}},	//   _archiv_, _personna, _lagen_,
  { {0x0335a06b,0xcefd206f,0x073c708f,0x00000000}},	//   _पंतप्र, _पेशकश_, _комуника,
  { {0xc487706b,0xf387804f,0x91e7306b,0x00000000}},	//   _मिपावर, _parry_, _चेहर्_,
  { {0x825a5007,0x94d1506f,0xbc6f50b6,0x00000000}},	//   _mille_, _मेडिकल, _ostrava_,
  { {0x916c204a,0xa2f4c025,0x6947e02f,0x00000000}},	//   _النكت_, _napisal_, _предлог_,
  { {0x3e56c08d,0x02d10057,0x7ece1029,0x00000000}},	//   _проста_, _povodom_, _צוטריט_,
  { {0x720b10b7,0x726ca080,0x8b75506b,0x00000000}},	//   _اردبیل_, _tibor_, _कॉर्पो,
  { {0xf740406f,0x8bdf2015,0xe29260b8,0x00000000}},	//   _गाजिया, _semester, _darauf_,
  { {0x946ee096,0xea051072,0xc2fc7066,0x00000000}},	// [090] _время_, _служби_, _rangi_,
  { {0x1f2e3050,0x13ebf064,0x2eed20b7,0x00000000}},	//   _comunida, _historii_, _المثل_,
  { {0x6e95906e,0xc57e404f,0x4aea702e,0x00000000}},	//   _עוררו_, _benderfy, _erstelle,
  { {0x72ca70b9,0xf926c024,0x8e0dd022,0x00000000}},	//   _mundo_, _причин_, _поблагод,
  { {0x425ba012,0x02b4e012,0xe291a00a,0x00000000}},	//   _amply_, _vincom_, _hipaa_,
  { {0x233d109e,0xa25ad075,0x522ac0ac,0x00000000}},	//   _دیدار_, _heller_, _побач_,
  { {0xf239f00a,0xe3805044,0x0200c066,0x00000000}},	//   _termini_, _petrol_, _halisi_,
  { {0xc580207c,0x5ec3a0ba,0x9b99f09d,0x00000000}},	//   _informaç, _christus_, _практиче,
  { {0x03f4702e,0xe27ee00c,0x7290301b,0x00000000}},	//   _ersten_, _mennen_, _olmasa_,
  { {0x3290504f,0xd20180bb,0x92d9e00d,0x00000000}},	//   _allan_, _emrin_, _siten_,
  { {0x12d8402e,0xa85230bc,0x02b49012,0x00000000}},	//   _immer_, _recursos_, _khach_,
  { {0xd1192065,0x47b710bd,0x425ad038,0x00000000}},	//   _техника_, _нашите_, _taller_,
  { {0xe9a7c072,0x02904019,0x62027055,0x00000000}},	//   _завжди_, _tamam_, _arriti_,
  { {0xd422208f,0x42cad0be,0x20ec1092,0x00000000}},	//   _единстве, _bildes_, _speisial,
  { {0xe2d9e0b9,0x7289e009,0xa388f0bf,0x00000000}},	//   _antes_, _کرینگے_, _unutrašn,
  { {0xdb48f07e,0x48c530b1,0x8200d04b,0x00000000}},	//   _версія_, _reservad, _preis_,
  { {0xd0d0904a,0x14242048,0x229070c0,0x00000000}},	// [0a0] _للنساء_, _случай_, _manau_,
  { {0x33085010,0xeaf7b0a9,0xb7b9a06e,0x00000000}},	//   _breakup_, _consumat, _עקיבא_,
  { {0xb201e0c1,0xa57e404f,0x75f32041,0x00000000}},	//   _sitio_, _penderfy, _শেয়ার_,
  { {0x7d136016,0xe2fc7066,0xccf18032,0x00000000}},	//   _konsider, _lengo_, _ibiteker,
  { {0x23eae026,0xc9c7d0bd,0x9ecb9059,0x00000000}},	//   _tuntuu_, _прилеп_, _kulingan,
  { {0x2290905c,0x02cae060,0x73401053,0x00000000}},	//   _schatz_, _fundet_, _licenza_,
  { {0xa2486089,0x938710ae,0xa3ebe0c2,0x00000000}},	//   _akoma_, _rubrik_, _jotta_,
  { {0x4d379048,0x1eb9b037,0xba2270a9,0x00000000}},	//   _бизнес_, _спачатку_, _practica_,
  { {0x525b10c3,0xa907b0ba,0x63948044,0x00000000}},	//   _publik_, _redakteu, _maksud_,
  { {0x4200d010,0xc291601a,0xf3e720c4,0x00000000}},	//   _iloilo_, _hagati_, _hätte_,
  { {0x93fa6095,0xd9a3f07e,0x23e7201c,0x00000000}},	//   _poruka_, _мерапрые, _kätte_,
  { {0xf7ac0002,0x9f98e035,0xa77d304a,0x00000000}},	//   _colectiv, _политику_, _الحزب_,
  { {0xe2d8f04b,0xd291f079,0xd290f0a1,0x00000000}},	//   _sagen_, _anuas_, _sagan_,
  { {0x02fc60b5,0x511120c5,0x99f66080,0x00000000}},	//   _blogg_, _białysto, _virág_,
  { {0xd27ef0c6,0x2ddc7005,0x02fcf0c7,0x00000000}},	//   _meiner_, _marktpla, _legge_,
  { {0xec5ce06b,0x12907098,0xa2caf02e,0x00000000}},	//   _योगेश_, _manat_, _leider_,
  { {0x425a0055,0x5c56c06f,0x12fc7094,0x00000000}},	// [0b0] _prill_, _छापें_, _langt_,
  { {0xe2d850c5,0x52dc20c8,0x423690c9,0x00000000}},	//   _dalej_, _партнера_, _kraje_,
  { {0xe88060ca,0xa3f46040,0x4a4bb043,0x00000000}},	//   _artikulu, _vertel_, _perezida_,
  { {0xcc521038,0x34b60001,0xea9bd061,0x00000000}},	//   _lectura_, _kompanij, _közleked,
  { {0x9d2f4025,0xae99204a,0x46dcf06b,0x00000000}},	//   _gospodar, _وبعدين_, _मंसिर_,
  { {0xd36fb0c0,0x0394e0cb,0x726cc015,0x00000000}},	//   _daugiau_, _zaista_, _sidor_,
  { {0xe27e9012,0xd2a690cc,0x4291e01b,0x00000000}},	//   _giang_, _grabe_, _kitab_,
  { {0x97d0c0cd,0xdf26b095,0x83947020,0x00000000}},	//   _многу_, _gađajte_, _senso_,
  { {0xf2ca70ba,0xae96b050,0x80b6106f,0x00000000}},	//   _einde_, _bastante_, _मुटुमा,
  { {0x02ca704e,0xacf0a06f,0x0d5ac0a6,0x00000000}},	//   _finde_, _पाठकों, _модел_,
  { {0x8d8e401d,0xa2fc7066,0x0290e04f,0x00000000}},	//   _encontra, _tangu_, _ionawr_,
  { {0xebe360ae,0x1c53702a,0x63c7f096,0x00000000}},	//   _komentar, _portada_, _группы_,
  { {0x02d8e05a,0x62fc701d,0x9face09e,0x00000000}},	//   _manera_, _tengo_, _تجاوز_,
  { {0xc35520b3,0x42026010,0xe27e905c,0x00000000}},	//   _calendr_, _korina_, _trane_,
  { {0xd7a4605f,0x421340aa,0x62b6705a,0x00000000}},	//   _независн, _şehir_, _tercer_,
  { {0xb0e6406f,0x739040ce,0xca8300cf,0x00000000}},	//   _आईपीएल, _الخليج_, _familjen_,
  { {0xb2026020,0x2408b0d0,0xa350600a,0x00000000}},	// [0c0] _aprile_, _kuhinjsk, _photolum,
  { {0xe2240028,0x62d98066,0xe431f041,0x00000000}},	//   _laiks_, _gazeti_, _জড়িত_,
  { {0x327f70b1,0x6ec4d05b,0x8486906b,0x00000000}},	//   _quando_, _дзеля_, _दिलासा,
  { {0x4263a06f,0x1e18e028,0xb200c025,0x00000000}},	//   _सक्षम_, _galerija, _veliko_,
  { {0x6be360d1,0x02d81080,0xf3949051,0x00000000}},	//   _comentar, _lehet_, _naast_,
  { {0x2291804f,0x4b28b08d,0x80492065,0x00000000}},	//   _adran_, _транспар, _периода_,
  { {0xa2d51080,0xc6d1103f,0xba08e026,0x00000000}},	//   _mellett_, _probleem_, _salasana_,
  { {0x4a14c04a,0x862740a9,0x27b92096,0x00000000}},	//   _أبريل_, _aplicati, _предыдущ,
  { {0x12484054,0x4c00001d,0x12da600a,0x00000000}},	//   _comme_, _música_, _unread_,
  { {0x67a7b041,0xa2d98064,0xc4e1b041,0x00000000}},	//   _জানলে_, _firem_, _জাপান_,
  { {0xe394e07f,0xc991904f,0x6b2b7068,0x00000000}},	//   _chiste_, _technole, _komandas,
  { {0xb482f07e,0x33eb7046,0x92d9900f,0x00000000}},	//   _форумы_, _ymateb_, _based_,
  { {0x32d8904f,0x6da3e0d2,0xb290e0b0,0x00000000}},	//   _flaen_, _досить_, _danach_,
  { {0xe6975060,0x2dffe0d3,0xa29180be,0x00000000}},	//   _offentli, _perempua, _kuras_,
  { {0xb2018084,0x4da2006c,0xe9ec806f,0x00000000}},	//   _juris_, _prensipa, _बल्लेब,
  { {0xd046406f,0x62e3000d,0x02927092,0x00000000}},	//   _डेवलपर, _valitse_, _spraoi_,
  { {0x5f71a072,0x92d800d4,0x99d59009,0x00000000}},	// [0d0] _основі_, _chieu_, _منشیات_,
  { {0x7c480029,0x5df80029,0x2beec096,0x00000000}},	//   _העלפֿן_, _העלפֿט_, _самое_,
  { {0x72a64066,0xf85cb05c,0x5f453098,0x00000000}},	//   _simba_, _verander_, _formalaş,
  { {0x3afcb02e,0x63e390d5,0xbbbd0041,0x00000000}},	//   _gesundhe, _פרנסה_, _নরাধম_,
  { {0x82d51061,0xd2027059,0x329260b4,0x00000000}},	//   _kellett_, _aprili_, _strada_,
  { {0xbceb906e,0x92d460d1,0xee8f606a,0x00000000}},	//   _להניח_, _perdre_, _promijen,
  { {0x170e1029,0x5b5520d6,0x82d8c073,0x00000000}},	//   _אוודאי_, _kontakta_, _leden_,
  { {0xf0ef20ce,0xab66403e,0x1641c090,0x00000000}},	//   _فساتين_, _realizar, _стари_,
  { {0x7101c08d,0xee29d017,0xb7aa704d,0x00000000}},	//   _свету_, _bygginga, _australi,
  { {0xb27e9031,0xe280b073,0x32f33057,0x00000000}},	//   _quand_, _diskuse_, _nedovolj,
  { {0x6386c03a,0x9e923024,0x18c53092,0x00000000}},	//   _gjorde_, _потреби_, _spreagad,
  { {0x2386a004,0x4e38f07f,0xa0d7a0d7,0x00000000}},	//   _dobry_, _carachta, _הגהות_,
  { {0xf8ea6044,0x157ed002,0xd700f092,0x00000000}},	//   _mengandu, _inclusió, _struchtú,
  { {0x82924044,0x768e60b2,0x8290201e,0x00000000}},	//   _datang_, _profissi, _dekat_,
  { {0x95bd90c8,0x12484075,0xe2245081,0x00000000}},	//   _министра_, _somme_, _belki_,
  { {0x53417038,0x284640b1,0x73fe5099,0x00000000}},	//   _reserva_, _qualidad, _amerikai_,
  { {0xa2d8c0aa,0xa18800be,0x3221b055,0x00000000}},	// [0e0] _neden_, _festivāl, _diskutim,
  { {0xc4c4206e,0x43eb5084,0x43875026,0x00000000}},	//   _אנגלית_, _vietas_, _vieras_,
  { {0x664e206e,0xc25a9076,0x827ec0d8,0x00000000}},	//   _אוהדים_, _quale_, _fronte_,
  { {0xc236d080,0x22fcd09c,0xc2e08032,0x00000000}},	//   _tudja_, _seega_, _कालीन_,
  { {0x454e20c8,0xa386d01d,0x7290d0d9,0x00000000}},	//   _лична_, _enero_, _halafu_,
  { {0xe290a04f,0x6032f0da,0x68dc5092,0x00000000}},	//   _alban_, _nastaven, _tarraing,
  { {0x33947094,0x2aa7a033,0xf320c062,0x00000000}},	//   _dansk_, _programı_, _medyo_,
  { {0x23f85054,0x791b70af,0xa3f8f030,0x00000000}},	//   _celui_, _toán_, _sigur_,
  { {0xbd9dc083,0xf956a002,0x37158029,0x00000000}},	//   _jednosta, _escribir_, _שושנת_,
  { {0xb25a5055,0x9843402f,0x13ebf06c,0x00000000}},	//   _tilla_, _централн, _moute_,
  { {0x92d80077,0x3ceed008,0xd061d096,0x00000000}},	//   _thiet_, _среди_, _стать_,
  { {0xd287309e,0x927e703a,0x323fd05c,0x00000000}},	//   _رفتار_, _kunna_, _vermaak_,
  { {0xdb136010,0xf20110c5,0xf2d8200f,0x00000000}},	//   _pampanga_, _razie_, _makes_,
  { {0xc2ba50d3,0xb2e850cb,0x1290c012,0x00000000}},	//   _sendiri_, _poslednj, _vedan_,
  { {0xa5eb00db,0xff6f906e,0x797ac012,0x00000000}},	//   _سرمایه_, _במשרד_, _thanhnie,
  { {0xc358901d,0x0dd950b7,0xc2caf0dc,0x00000000}},	//   _página_, _وبسایت_, _bandar_,
  { {0x63ea00dd,0xf3a38076,0xf27f700c,0x00000000}},	// [0f0] _uniti_, _corpo_, _chanje_,
  { {0x3951200d,0x0200c00b,0x4d392012,0x00000000}},	//   _automaat, _valige_, _mobifone_,
  { {0x432070de,0xb3eb80da,0x79a3707c,0x00000000}},	//   _kenya_, _karty_, _ministér,
  { {0x138b8092,0x18465038,0x7f2430ac,0x00000000}},	//   _márta_, _lectures_, _меркаван,
  { {0x6dee3009,0x7c27b029,0x73eb70df,0x00000000}},	//   _کمزور_, _נאַציאָנ, _esaten_,
  { {0xb2b49039,0x0d439029,0xb147d02f,0x00000000}},	//   _pracy_, _סטעיט_, _капитал_,
  { {0x4200904f,0x80d4204a,0x3ba6b06f,0x00000000}},	//   _plaid_, _يوفقك_, _हड़ताल,
  { {0xafacc0e0,0xa404b088,0xe3a3f0e1,0x00000000}},	//   _مجروح_, _авганист, _koupe_,
  { {0x73a35001,0xe27eb05c,0x32cae027,0x00000000}},	//   _liepos_, _moenie_, _vendar_,
  { {0x22fc7033,0xe2d8c03f,0xd290c0d6,0x00000000}},	//   _hangi_, _reden_, _redan_,
  { {0xd2c2e075,0xa9995022,0x6dd6e026,0x00000000}},	//   _tallinn_, _професси, _perjanta,
  { {0xd3435041,0xd2902057,0x08c73052,0x00000000}},	//   _ইমেইল_, _makar_, _indehold,
  { {0x49aa304a,0x42e8601d,0xd86c6002,0x00000000}},	//   _تأكيد_, _perfil_, _sociedad,
  { {0xc26c40e2,0x98f420c8,0xb2d83031,0x00000000}},	//   _pomoc_, _академиј, _samedi_,
  { {0xd290c05c,0x927a20b8,0x1c76d06f,0x00000000}},	//   _nadat_, _persönli, _मिश्रा,
  { {0xc1b1e0a5,0x0a868047,0xe3f8e005,0x00000000}},	//   _জানেন_, _europejs, _vanuit_,
  { {0xcc77f042,0x926e7058,0x92d8a09c,0x00000000}},	// [100] _शेट्टी, _besoin_, _umbes_,
  { {0xfd2c900c,0xb2908026,0x302b905b,0x00000000}},	//   _aktivite_, _kukaan_, _школах_,
  { {0x08a1e041,0xd643a029,0xf22470d9,0x00000000}},	//   _আনুষঙ্, _יאפאן_, _benki_,
  { {0xa1f8c04a,0x0294506a,0x8a17c00e,0x00000000}},	//   _متصفح_, _linkovi_, _psichiat,
  { {0xb2907047,0xcc610059,0x8b8a205f,0x00000000}},	//   _ponad_, _masuala_, _мојот_,
  { {0x9351903e,0x584d2001,0x13ead0e3,0x00000000}},	//   _conform_, _sistemos_, _trete_,
  { {0xc295500b,0xf517704a,0x83f40094,0x00000000}},	//   _probleem, _والطفل_, _kostet_,
  { {0xc3ea6073,0x42b490e4,0x4f67a029,0x00000000}},	//   _proto_, _place_, _בעלזא_,
  { {0xb200d0ba,0xa9159041,0x8334c0b7,0x00000000}},	//   _klein_, _আহ্বান, _آذربایجا,
  { {0xcae820cf,0xcf8df08e,0xd3f470d1,0x00000000}},	//   _expresse, _बल्कि_, _mostra_,
  { {0x6ad7300b,0x92cbf093,0xde329041,0x00000000}},	//   _postitat, _ljude_, _কাজটা_,
  { {0x71772088,0xe27e702c,0xc354a002,0x00000000}},	//   _место_, _vinna_, _modelos_,
  { {0x63f43031,0x63eb80df,0xf2fc907f,0x00000000}},	//   _posté_, _sortu_, _beaga_,
  { {0xd27ed012,0x306790bd,0xe2b5d064,0x00000000}},	//   _tieng_, _развој_, _najdete_,
  { {0xb7c6106b,0x31079029,0x23869069,0x00000000}},	//   _हळूहळू, _מעיאר_, _juara_,
  { {0x32926010,0x8c75807f,0x93737012,0x00000000}},	//   _parang_, _bearish_, _rongbay_,
  { {0xe2e0901c,0x427ef047,0x10d7709b,0x00000000}},	// [110] _profiili_, _opinii_, _motocykl,
  { {0x02247099,0x499bd060,0x55bd60c2,0x00000000}},	//   _senki_, _velkomme, _myöhemmi,
  { {0x22d90067,0xa2873009,0xc3869066,0x00000000}},	//   _videó_, _تہران_, _ziara_,
  { {0x62902001,0x7dc4503f,0x4682d06f,0x00000000}},	//   _vakar_, _maximale_, _सहवाग_,
  { {0xd3958033,0x82002095,0x653680e3,0x00000000}},	//   _varsa_, _nekih_, _wikipedy,
  { {0x60b3b0ae,0x4f3a5060,0xdd6ff00a,0x00000000}},	//   _kriminal, _brancher_, _tramunta,
  { {0x5f1160c0,0x47a73054,0xa04160e5,0x00000000}},	//   _kontakta, _partenai, _kontaktn,
  { {0xbc1a70d2,0x4df0c0db,0x027ef00a,0x00000000}},	//   _практичн, _کنکور_, _ezines_,
  { {0x753a901b,0xd273b02c,0xe2fca015,0x00000000}},	//   _agentliy, _mínum_, _skrivet_,
  { {0x13ea701a,0x429180b0,0x9636406f,0x00000000}},	//   _muntu_, _daran_, _सुनहरे,
  { {0x6d50706b,0x0fe03092,0x667a50ac,0x00000000}},	//   _मुंगेर, _sadistic_, _дагаворн,
  { {0x33eb909b,0x63872080,0xf3806007,0x00000000}},	//   _postu_, _egyre_, _korral_,
  { {0xbf65e09d,0x05b76077,0x63eb909b,0x00000000}},	//   _автомоби, _finalsty, _testy_,
  { {0x527f70df,0x3c6160e6,0x329270e7,0x00000000}},	//   _emango_, _bestuur_, _pasang_,
  { {0x625a6017,0xf24890d9,0xaf6f500a,0x00000000}},	//   _fullt_, _vyama_, _aquatics_,
  { {0x52fce03f,0x2c2cf099,0x6c34f030,0x00000000}},	//   _dingen_, _bruttó_, _descoper,
  { {0x82ca9020,0x8d96a03a,0x0378101a,0x00000000}},	// [120] _grado_, _milliona, _kubanga_,
  { {0x92b6500c,0xf2c1c00b,0xfc53906b,0x00000000}},	//   _touche_, _sellega_, _ध्येय_,
  { {0xb291601a,0xac5bf033,0x85418041,0x00000000}},	//   _kigali_, _listesi_, _সাংস্ক,
  { {0x125a5075,0x82d8b020,0xc667909d,0x00000000}},	//   _ville_, _vedere_, _наверх_,
  { {0x7f20a051,0xb201907c,0xa2cae0b0,0x00000000}},	//   _adverten, _assim_, _findet_,
  { {0xf25a5055,0x620250b4,0xe9849084,0x00000000}},	//   _tille_, _motivo_, _komisija_,
  { {0x60e4a06f,0x6290f034,0x02fcc0e8,0x00000000}},	//   _उड़ीसा, _legal_, _blogue_,
  { {0x52e59028,0xf27f4012,0xd26c5010,0x00000000}},	//   _tehnika_, _cienco_, _halos_,
  { {0xb3f45026,0x1201f044,0xec76606f,0x00000000}},	//   _sitten_, _artis_, _मुम्बई,
  { {0x9200200c,0x62918015,0xbde6c0d8,0x00000000}},	//   _komite_, _varan_, _nájdete_,
  { {0x43eb80b5,0x82d980b0,0xd00e60cd,0x00000000}},	//   _sorts_, _waren_, _договоро,
  { {0xf61f4038,0x92c5305c,0x73eae00f,0x00000000}},	//   _exposici, _heilige_, _center_,
  { {0xe3051009,0x42d9f0aa,0xbb03b01d,0x00000000}},	//   _دوچار_, _gazete_, _herramie,
  { {0x81ae10e9,0x9e42c0b1,0x82d84033,0x00000000}},	//   _קולנוע_, _localiza, _ahmet_,
  { {0xd201a00d,0x787b20c8,0xd6e7b07e,0x00000000}},	//   _lapin_, _страха_, _вытворча,
  { {0x125a904f,0x9320d055,0x04d9a009,0x00000000}},	//   _arall_, _menyre_, _سرینگر_,
  { {0xec09b006,0xc291e01e,0x429050ea,0x00000000}},	// [130] _podpora_, _hitam_, _balas_,
  { {0x478020d2,0x739470e3,0x72e5900a,0x00000000}},	//   _управлін, _konsa_, _teknika_,
  { {0x329160eb,0x1268b048,0xd6179001,0x00000000}},	//   _regalo_, _контакти_, _eurovizi,
  { {0x13b0e0b1,0x531f000f,0x36d71038,0x00000000}},	//   _clique_, _special_, _descobri,
  { {0x8200504f,0x73946032,0x6200401b,0x00000000}},	//   _talis_, _byose_, _samir_,
  { {0x4058b072,0x9738304a,0xc72cc06f,0x00000000}},	//   _електрон, _سيرفر_, _गाज़िय,
  { {0x8394f03a,0x030990b3,0xd2da5015,0x00000000}},	//   _priser_, _broblem_, _citera_,
  { {0x1c6d8096,0x9150a047,0x926c20ec,0x00000000}},	//   _постоянн, _podstawo, _tokom_,
  { {0x43575019,0x63eaf031,0x026da061,0x00000000}},	//   _gerekir_, _faites_, _napon_,
  { {0x526df00d,0x8638c09d,0xef4af044,0x00000000}},	//   _autot_, _направле, _perpusta,
  { {0xc32090ed,0xf03fa00c,0x097ad02e,0x00000000}},	//   _upaya_, _domestik_, _enthalte,
  { {0x43f98086,0x950120b2,0x53f8f038,0x00000000}},	//   _terug_, _especial_, _algun_,
  { {0xc3860031,0x437b1078,0x0dd4006e,0x00000000}},	//   _faire_, _naravno_, _האשכול_,
  { {0xd3f4603a,0x22cae0b0,0xc26d809b,0x00000000}},	//   _sitter_, _senden_, _karol_,
  { {0xd29260ee,0x43a2400b,0xbce2705f,0x00000000}},	//   _strana_, _limpa_, _информир,
  { {0x4255906b,0x74ef4024,0x72d9b0ef,0x00000000}},	//   _संमेलन, _спортивн, _beveik_,
  { {0x1320c019,0x027ee07c,0x73eae052,0x00000000}},	// [140] _medya_, _quinta_, _renter_,
  { {0xef40c038,0x4f02c07e,0x7b51c056,0x00000000}},	//   _subscrip, _школы_, _територі,
  { {0xf2916020,0xf284609d,0x4e428001,0x00000000}},	//   _magari_, _безопасн, _kataloge_,
  { {0x0d2c3008,0x77a61012,0x5200901b,0x00000000}},	//   _список_, _vietgiai, _sakini_,
  { {0x717730ac,0x5be5b001,0x62fcf04c,0x00000000}},	//   _белта_, _kalendor, _begge_,
  { {0x29851041,0xb38690b5,0x73e7d0a1,0x00000000}},	//   _জেবতিক, _snart_, _mætti_,
  { {0x129270f0,0x62484058,0xedad802c,0x00000000}},	//   _strani_, _homme_, _bandarík,
  { {0x5ddc2009,0xf25d600a,0xa9dff067,0x00000000}},	//   _حلقوں_, _divertim, _augusztu,
  { {0xa3940092,0x1290c059,0xa387f01a,0x00000000}},	//   _ceist_, _madai_, _ukuri_,
  { {0xe27f8068,0xa26c50b1,0xcd7d209e,0x00000000}},	//   _biznes_, _valor_, _مجلات_,
  { {0x820190f1,0xbbe53001,0x8a8860f2,0x00000000}},	//   _hasil_, _aksesuar, _moderáto,
  { {0x926c70d6,0x64a190d5,0xa584a051,0x00000000}},	//   _genom_, _אדרבה_, _gelegenh,
  { {0x0290c055,0x42ee604f,0xd97ad009,0x00000000}},	//   _islame_, _economi_, _خریدنے_,
  { {0x13959075,0x29e230c0,0xef720001,0x00000000}},	//   _desse_, _istorija_, _dienoraš,
  { {0x22ab10f3,0x5e62d01d,0x03eb9031,0x00000000}},	//   _bandung_, _descarga, _juste_,
  { {0x6394e062,0xd75aa0f4,0x8290a092,0x00000000}},	//   _trisha_, _правител, _tobac_,
  { {0x3af3609a,0x9097c06e,0x212d3024,0x00000000}},	// [150] _consulte, _האלקטרונ, _сайті_,
  { {0x027f505e,0xf1c8106e,0x2ef8106e,0x00000000}},	//   _dienas_, _העיצוב_, _העיסוק_,
  { {0x93f400d6,0x062b0028,0x2682301d,0x00000000}},	//   _postat_, _teritori, _accesori,
  { {0xad47b002,0x327ef02e,0x12fdf032,0x00000000}},	//   _disposic, _seiner_, _avuga_,
  { {0xaa76106f,0xe8c6301a,0xf27ec052,0x00000000}},	//   _नवीनतम, _abaturag, _endnu_,
  { {0xa2005098,0x401d100c,0x72d9202d,0x00000000}},	//   _illik_, _kondisyo, _recent_,
  { {0x01241029,0x1c52c06b,0x125a608b,0x00000000}},	//   _הרבנים_, _तिथेच_, _urola_,
  { {0xc25ad0ca,0x06d1c06b,0xc85c106e,0x00000000}},	//   _duela_, _विडिओ_, _ההזמנה_,
  { {0xf27f7066,0xbabba073,0x0b2b8096,0x00000000}},	//   _upande_, _potvrdit, _исследов,
  { {0x2e0cf009,0x62d81016,0x82fcd01a,0x00000000}},	//   _بارشکریہ_, _behet_, _rwego_,
  { {0x69c860f5,0xd3ea006c,0x1b55103f,0x00000000}},	//   _primaria_, _edite_, _kinderen_,
  { {0x22026019,0x0291a0f6,0x61ceb0cf,0x00000000}},	//   _turizm_, _empat_, _välkomme,
  { {0x8d42d072,0xbc76d063,0x023740bb,0x00000000}},	//   _інформац, _energii_, _drejte_,
  { {0xa387804f,0x125a500a,0x727ee03a,0x00000000}},	//   _torri_, _billi_, _hennar_,
  { {0xc3cff06c,0x90bab06f,0x72b58031,0x00000000}},	//   _nouvo_, _गठबंधन, _parce_,
  { {0x229030b1,0xa2fdf027,0x9b55105a,0x00000000}},	//   _semana_, _drugi_, _contacta_,
  { {0x0477a0d2,0x3b0c20db,0xd290b071,0x00000000}},	// [160] _проекти_, _تاپیک_, _izdaje_,
  { {0x326c20f7,0xf2d850c9,0xd25a9010,0x00000000}},	//   _pokok_, _kolem_, _ugali_,
  { {0xc3946092,0x8d198022,0xf2ada06e,0x00000000}},	//   _phost_, _различны, _אבטחה_,
  { {0xf26c1026,0xaaf85031,0x72b57059,0x00000000}},	//   _johon_, _actuelle, _kuacha_,
  { {0x1c26c0c8,0xd2fd104d,0x62cad020,0x00000000}},	//   _природу_, _similar_, _credo_,
  { {0xb3ead00e,0x33782055,0xe321f088,0x00000000}},	//   _vieta_, _albania_, _едностав,
  { {0x446390f8,0xe2018066,0x7301c067,0x00000000}},	//   _আলাদা_, _muziki_, _apróhird,
  { {0xc1773056,0xc14750e8,0x9b65b03e,0x00000000}},	//   _центр_, _desenvol, _utilizar,
  { {0xb0747052,0x139500ec,0x02fce0cc,0x00000000}},	//   _redaktio, _vlasti_, _langit_,
  { {0x9964106f,0x22ca901b,0x0b5ed05f,0x00000000}},	//   _खतरनाक, _orada_, _храна_,
  { {0x5640101a,0xa2ca9093,0x58bf300b,0x00000000}},	//   _abanyarw, _grada_, _nimetatu,
  { {0xb2005078,0x1840d0f9,0xae327041,0x00000000}},	//   _volim_, _بخصوص_, _বিষয়ে_,
  { {0x9225900c,0xb8832037,0x32a690aa,0x00000000}},	//   _paske_, _фестывал, _araba_,
  { {0xe2004033,0x1c013064,0x1eb13071,0x00000000}},	//   _komik_, _prostor_, _prostore_,
  { {0xa3455062,0xd641c0fa,0x53f1400a,0x00000000}},	//   _depende_, _втора_, _esportaz,
  { {0x32ca502c,0x1d7a7060,0xe3a2c0fb,0x00000000}},	//   _vildi_, _kommende_, _campos_,
  { {0x23ea7026,0xe2ca700b,0x9290b066,0x00000000}},	// [170] _hinta_, _hinda_, _badala_,
  { {0xc68e106e,0x2b56106e,0xc39540d8,0x00000000}},	//   _שוקולד_, _בשיתוף_, _miesto_,
  { {0x99b1403f,0xc0114050,0x4f1c1029,0x00000000}},	//   _producte, _producto, _שפיטאל_,
  { {0xf291905e,0x73ead09b,0x43f990c0,0x00000000}},	//   _visas_, _preto_, _visus_,
  { {0x4273701b,0x62d91047,0x323670dd,0x00000000}},	//   _güney_, _razem_, _linja_,
  { {0xc2ca3090,0x2311406b,0xdeab9015,0x00000000}},	//   _hajde_, _जागृत_, _rekommen,
  { {0xe2d9e03f,0x722e00ee,0x02ca7054,0x00000000}},	//   _laten_, _pravidel, _lundi_,
  { {0x329010df,0xb27f402c,0x8e3270a7,0x00000000}},	//   _behar_, _prenta_, _kualitas_,
  { {0xf2919013,0xc9f66067,0xf7cba035,0x00000000}},	//   _tayari_, _során_, _skupštin,
  { {0xc951504d,0x4201f095,0x07b79041,0x00000000}},	//   _associat, _istim_, _ডোমেইন,
  { {0xc386c040,0xcdf150c0,0xd0cbe035,0x00000000}},	//   _storie_, _produkta, _отворен_,
  { {0xd2caf079,0xd14a70b0,0x96956002,0x00000000}},	//   _maidir_, _kostenlo, _especiai,
  { {0x92fc7059,0x305810c5,0x92cae016,0x00000000}},	//   _mengi_, _mieszkan, _vendin_,
  { {0x83ce9097,0x73ea90b5,0x82fc70a1,0x00000000}},	//   _prava_, _prata_, _lengi_,
  { {0x6393c09e,0x9e41e00a,0x13227029,0x00000000}},	//   _رابطه_, _garantit_, _רעזולטאַ,
  { {0x92efc00a,0x143100fc,0xf386d076,0x00000000}},	//   _familja_, _العاده_, _avere_,
  { {0x52cad0a4,0xdad510f5,0xce36c0ec,0x00000000}},	// [180] _wtedy_, _restruct, _obrazova,
  { {0x126df0af,0x139480c2,0x0332f02a,0x00000000}},	//   _thuoc_, _maksaa_, _caixas_,
  { {0xa3f98059,0x3e46c001,0x98bed05c,0x00000000}},	//   _barua_, _kataloga, _ingestuu,
  { {0x73f9806b,0x2cf610fd,0x626de0e3,0x00000000}},	//   _suzuki_, _адрес_, _baton_,
  { {0x83ac1061,0xf26c70d6,0x0386b0fe,0x00000000}},	//   _éppen_, _honom_, _podria_,
  { {0x36967054,0x7849e0d2,0x52014028,0x00000000}},	//   _accessoi, _призначе, _audits_,
  { {0xb291a055,0x018dd068,0x0262c04a,0x00000000}},	//   _sipas_, _probleml, _عاشقة_,
  { {0xc387e0a9,0xa386d076,0x7ad0e009,0x00000000}},	//   _intre_, _storia_, _کرفیو_,
  { {0x1f1f3036,0xcc5c5041,0xceb0a053,0x00000000}},	//   _komunita, _তীব্র_, _diversas_,
  { {0xb21a504a,0x8c56a012,0x2394d051,0x00000000}},	//   _مراقبة_, _vietsub_, _meest_,
  { {0xe17d80d5,0x4485906f,0xc3ea60ca,0x00000000}},	//   _תירוץ_, _हंगामा, _edota_,
  { {0xc20ce009,0xf3f4700e,0x9340e051,0x00000000}},	//   _زیراہتما, _turtas_, _gelegen_,
  { {0x62c3e085,0x83eae076,0x6ae4304d,0x00000000}},	//   _корист_, _contro_, _septembe,
  { {0xee472002,0xa5f39035,0x4290001e,0x00000000}},	//   _localida, _болести_, _ujian_,
  { {0x0d868020,0x42d8d046,0x41422037,0x00000000}},	//   _novembre_, _teledu_, _штраф_,
  { {0x52da7076,0xe831104a,0x928f101a,0x00000000}},	//   _essere_, _الظروف_, _urukiko_,
  { {0xb2dac04b,0x62d82040,0x526c1010,0x00000000}},	// [190] _können_, _seker_, _bohol_,
  { {0x127ed001,0x226d8010,0x169bd046,0x00000000}},	//   _pieno_, _meron_, _gobeithi,
  { {0x129040e3,0x0249004f,0xeab89085,0x00000000}},	//   _moman_, _dramor_, _црногорс,
  { {0x929040c5,0x346520dd,0xff3a20aa,0x00000000}},	//   _temat_, _referenz, _profilin,
  { {0xa25a5076,0x122b30a9,0xa84cb084,0x00000000}},	//   _dalle_, _animale_, _sadarbīb,
  { {0x8d42d096,0x52fd704b,0x12909040,0x00000000}},	//   _информац, _fragen_, _plaas_,
  { {0xc3940092,0xc3bb2002,0x7ffc204a,0x00000000}},	//   _poist_, _través_, _القيم_,
  { {0x3c5c105c,0xe2d98049,0xa5879080,0x00000000}},	//   _bestaan_, _keren_, _horoszkó,
  { {0x120040a1,0x02d84070,0xfc26d038,0x00000000}},	//   _komin_, _komen_, _avançada_,
  { {0x01b64091,0xf3eae06c,0x73c5f009,0x00000000}},	//   _permessi_, _kontan_, _کالونی_,
  { {0xf2fc00c6,0x5e563088,0xc39420be,0x00000000}},	//   _enige_, _настани_, _plkst_,
  { {0xa101208d,0xb2fd6075,0x23eae061,0x00000000}},	//   _свята_, _ligger_, _mentes_,
  { {0xd200c068,0x3249701a,0x42cad0de,0x00000000}},	//   _nadir_, _ijambo_, _bildet_,
  { {0xf291c028,0x30d6206e,0x41c4d0ff,0x00000000}},	//   _divas_, _מבזקים_, _məcəlləs,
  { {0xadca3024,0x30e3c09d,0x9c0880c8,0x00000000}},	//   _начальни, _рекоменд, _традициј,
  { {0x52d98073,0xd9d740e8,0x2cf740a9,0x00000000}},	//   _beren_, _instalad, _instalar,
  { {0xf2d99044,0xdaf7b0f5,0xe290d092,0x00000000}},	// [1a0] _lesen_, _consulat, _plean_,
  { {0xc2d950ea,0x9111b009,0xb27e004d,0x00000000}},	//   _deposit_, _سینیٹر_, _being_,
  { {0xb26c4100,0xb2d87036,0xe27f701b,0x00000000}},	//   _temos_, _honek_, _fransa_,
  { {0x3851a0c5,0xd668f0bd,0xa5f1204a,0x00000000}},	//   _samochod, _присуств, _الشؤون_,
  { {0xa37fc053,0x4efb2065,0x727ea026,0x00000000}},	//   _palabra_, _страни_, _mennä_,
  { {0x92a66101,0x8557d085,0x027f700c,0x00000000}},	//   _osoba_, _приказ_, _franse_,
  { {0x02499102,0x6d3790cd,0x82b66103,0x00000000}},	//   _rasmi_, _бизнис_, _faucet_,
  { {0x30580029,0x22d10057,0x1b6a9065,0x00000000}},	//   _דערביי_, _govorim_, _статия_,
  { {0x9413803e,0xeda810df,0x92cae04e,0x00000000}},	//   _cristian_, _donostia, _hendes_,
  { {0x72e97028,0xb1417032,0xe65c50fa,0x00000000}},	//   _perioda_, _बाबूजी, _елементи_,
  { {0x127e0036,0xe859f09d,0x128c304a,0x00000000}},	//   _baino_, _предложе, _الصمت_,
  { {0xb295c00a,0x029270c0,0xc76fd096,0x00000000}},	//   _dipartim, _visada_, _изображе,
  { {0x92cbf049,0x7c17d056,0xa98960af,0x00000000}},	//   _studi_, _правил_, _chính_,
  { {0x02d8f03a,0xe2ee90d8,0x72d98031,0x00000000}},	//   _meget_, _graft_, _prendre_,
  { {0x67d0c048,0xc3ead0e2,0x0349800a,0x00000000}},	//   _много_, _siete_, _esperti_,
  { {0x3c23b0e9,0xf3f4700d,0x9fc0d0be,0x00000000}},	//   _תרגום_, _lasten_, _literatū,
  { {0xb7d8c027,0x0d6f3054,0x32ca700c,0x00000000}},	// [1b0] _današnji_, _commenta, _mande_,
  { {0x427e00b0,0x22ca7052,0x7200500d,0x00000000}},	//   _meine_, _lande_, _pelit_,
  { {0x45d6f092,0x022bb054,0x4e1bb104,0x00000000}},	//   _forbarth, _chambre_, _chambres_,
  { {0x53f4606b,0x365ec035,0x7af3c105,0x00000000}},	//   _portal_, _филма_, _napravit,
  { {0xc22ac035,0x87e5306f,0x22dc1057,0x00000000}},	//   _добар_, _आसाराम, _promocij,
  { {0x5291a087,0x0a15e04c,0xd16c304a,0x00000000}},	//   _depan_, _forbinde, _الركن_,
  { {0xce2cc035,0x863f9057,0xff47109a,0x00000000}},	//   _млади_, _socijali, _comprova,
  { {0xf634c067,0x5291e0c0,0x2d5ac048,0x00000000}},	//   _tevékeny, _kitas_, _можем_,
  { {0xb407c06f,0x3e45d01a,0xf2e62076,0x00000000}},	//   _योगदान, _bagaraga, _tecnica_,
  { {0xc3ce90ec,0x038180f5,0x5a93c0bd,0x00000000}},	//   _pravu_, _prezent_, _можеби_,
  { {0xb2489106,0xd3958020,0x69db7038,0x00000000}},	//   _utama_, _verso_, _hipoteca_,
  { {0xff0a604f,0xd1e2b022,0x8290c107,0x00000000}},	//   _ddiwedda, _техничес, _ibland_,
  { {0xffd6c035,0x0f49409a,0x43860108,0x00000000}},	//   _сигурно_, _propieta, _imirt_,
  { {0xe2ca7040,0x43eb80c0,0xdc63e058,0x00000000}},	//   _hande_, _turto_, _entrée_,
  { {0xf1b5e085,0xeaae601b,0xcaf24071,0x00000000}},	//   _стандард, _elektron_, _pokrovit,
  { {0x227e00b0,0x1394f035,0xe291e098,0x00000000}},	//   _keine_, _smislu_, _sitat_,
  { {0xd291e0be,0x926c50a9,0x42e8007e,0x00000000}},	// [1c0] _citas_, _celor_, _праводзі,
  { {0xbc07304f,0xf201c038,0x42d87028,0x00000000}},	//   _perthnas, _havia_, _nenes_,
  { {0x6c6f60d1,0xc3eae0d4,0xd2d8503a,0x00000000}},	//   _entrada_, _toitim_, _elles_,
  { {0xc3f8502c,0x4291900c,0xac06f092,0x00000000}},	//   _telur_, _resan_, _córais_,
  { {0xc290f099,0x13f8f00a,0x025af028,0x00000000}},	//   _magas_, _magus_, _bailes_,
  { {0x1e73c032,0xc25a0092,0x0200c109,0x00000000}},	//   _फॉन्ट_, _gaile_, _miliwn_,
  { {0x526c701d,0x541d705c,0x41772085,0x00000000}},	//   _menos_, _verstaan_, _теста_,
  { {0x84be00e9,0x1c242027,0xf291f09a,0x00000000}},	//   _נושאים_, _financir, _estan_,
  { {0x7c7e0060,0xeeb4e09a,0x23f9e055,0x00000000}},	//   _carsten_, _diverses_, _ditur_,
  { {0x227e9012,0x77960027,0xc27ed03d,0x00000000}},	//   _khang_, _predstav, _trena_,
  { {0x62d9f05c,0x0010e07f,0x42d9f061,0x00000000}},	//   _dienste_, _margaíoc, _isten_,
  { {0x526e6073,0x5369607f,0xb200b014,0x00000000}},	//   _evropa_, _praghas_, _jedini_,
  { {0xd9f32071,0xed332025,0xd2d4702b,0x00000000}},	//   _agencija_, _agencije_, _onsdag_,
  { {0xba83b005,0x62c0e057,0xaed400be,0x00000000}},	//   _beginnen_, _poštovan, _salidzin,
  { {0x23f9e0a7,0xec617007,0xc2fd805c,0x00000000}},	//   _situs_, _virumaa_, _berge_,
  { {0xf257209c,0xd2d9e044,0x42d9610a,0x00000000}},	//   _välja_, _citer_, _segera_,
  { {0x147a8093,0x108cc096,0xd291407f,0x00000000}},	// [1d0] _postavlj, _слова_, _cheart_,
  { {0x222580ba,0x235650c0,0x9bed707c,0x00000000}},	//   _werke_, _adresas_, _fevereir,
  { {0x63f8f0e7,0x92259035,0x77185022,0x00000000}},	//   _bagus_, _tesko_, _контакты_,
  { {0xe3f02045,0xfb7e6016,0xe712506f,0x00000000}},	//   _informaz, _profilin_, _आवेदन_,
  { {0x34652091,0xe20270b4,0xa3a3a05c,0x00000000}},	//   _internaz, _musica_, _lippe_,
  { {0x920050a1,0x727ed05e,0x729050a1,0x00000000}},	//   _allir_, _diena_, _allar_,
  { {0x72935067,0xc9c84021,0x5201a00d,0x00000000}},	//   _millió_, _verdiene, _napit_,
  { {0xad9ac048,0xd2786013,0xe2d840be,0x00000000}},	//   _статии_, _mbunge_, _domes_,
  { {0x6fe3d009,0x03ea90a7,0x5459c0b2,0x00000000}},	//   _لاپتہ_, _suatu_, _objetivo_,
  { {0x1331b001,0xc2d85075,0x8478708d,0x00000000}},	//   _diskusij, _eller_, _наступна,
  { {0x6fc11001,0x315da038,0xf2fcd0d9,0x00000000}},	//   _apdovano, _actuacio, _mbegu_,
  { {0xf255406f,0xd3ff2027,0x23067056,0x00000000}},	//   _विधेयक, _planinsk, _експерим,
  { {0x2291e033,0xfbf38038,0x407a3067,0x00000000}},	//   _kitap_, _celebrac, _csütörtö,
  { {0xcf2dc01e,0xfaf15029,0xb2efb07f,0x00000000}},	//   _kepentin, _לעבאוויט, _cúirte_,
  { {0x927b40b1,0xa201f0c0,0xd27f702c,0x00000000}},	//   _comentár, _muzika_, _standa_,
  { {0xd6a3007f,0xf3f46030,0x34001008,0x00000000}},	//   _aistrith, _martie_, _песня_,
  { {0x0290c039,0xc3940066,0xbc67e09e,0x00000000}},	// [1e0] _dodaj_, _ofisi_, _سرطان_,
  { {0x63ea6064,0x28a9210b,0xd2a6610c,0x00000000}},	//   _proti_, _stratégi, _osobe_,
  { {0xfae30007,0x15f9104a,0xd897104a,0x00000000}},	//   _postimee, _التلفزيو, _قريبا_,
  { {0xf25a90bf,0xda749024,0xa358a06b,0x00000000}},	//   _hvala_, _департам, _umugore_,
  { {0xc27ee031,0x421b9009,0xd7def06b,0x00000000}},	//   _donner_, _سکریپشن_, _गायकवा,
  { {0x127ee00c,0x170ba06e,0x6cf7506b,0x00000000}},	//   _konnen_, _ההבדל_, _वादग्र,
  { {0xe212b00c,0x02d98007,0x1201800b,0x00000000}},	//   _mache_, _parem_, _parim_,
  { {0x0248b064,0x6fc3500b,0x92d87050,0x00000000}},	//   _chemie_, _horoskoo, _tener_,
  { {0xc2645094,0x37b4d0df,0xa6679042,0x00000000}},	//   _skulle_, _leheneng, _त्रस्त,
  { {0xedd2d05b,0x06bbb009,0xd762d0a6,0x00000000}},	//   _стала_, _مفاہمت_, _става_,
  { {0xd368a0e6,0x628390a4,0xc2cad046,0x00000000}},	//   _vergeet_, _poznań_, _credu_,
  { {0xf8879029,0xac93d009,0x09e820b0,0x00000000}},	//   _בעסטע_, _جاپان_, _impressu,
  { {0xd3446073,0x597e2018,0xbe2bf02c,0x00000000}},	//   _licence_, _групи_, _laugarda,
  { {0x3c891090,0x2f2450af,0xd4f4b0b1,0x00000000}},	//   _различит, _ngách_, _acompanh,
  { {0x8365b06f,0x427f40d9,0x7739c038,0x00000000}},	//   _मुरैना, _huenda_, _esportiv,
  { {0x27b260b1,0x9f24d080,0xf27ed00a,0x00000000}},	//   _consegui, _legalább_, _tieni_,
  { {0x31ab7020,0x1292705c,0x3c694073,0x00000000}},	// [1f0] _commenti_, _marais_, _kultury_,
  { {0xd3eb7038,0xe2d85077,0xe2d9a0b2,0x00000000}},	//   _quatre_, _telex_, _papel_,
  { {0x22918033,0xcfc23009,0x62ed4050,0x00000000}},	//   _biraz_, _مایوس_, _posible_,
  { {0x53a240b2,0x926c110d,0x927e0059,0x00000000}},	//   _campo_, _mohou_, _haina_,
  { {0xb7552042,0xedc21010,0x9290a059,0x00000000}},	//   _कनिष्ठ, _panitika, _majaji_,
  { {0x5a26d009,0xd79b20d2,0xc26c9006,0x00000000}},	//   _شاہراہ_, _автором_, _škoda_,
  { {0x9394900a,0xf7131088,0x4291101a,0x00000000}},	//   _blast_, _републик, _gacaca_,
  { {0x227ed026,0xe17d906e,0xc5a79041,0x00000000}},	//   _vuonna_, _בישול_, _ভৌগলিক,
  { {0xd3949057,0xf2d9c02d,0xc29050a7,0x00000000}},	//   _vlast_, _level_, _dolar_,
  { {0x3316f036,0x034a20c8,0xc1c31056,0x00000000}},	//   _baizik_, _сиромашн, _доходи_,
  { {0xbb82210e,0x309c1041,0x72014062,0x00000000}},	//   _تخریب_, _মাসুদ_, _undies_,
  { {0x925a50b0,0xf2cb808c,0x2a77a032,0x00000000}},	//   _hallo_, _burda_, _मूलभूत,
  { {0xf236c0bb,0x7387704f,0x83ebf0c2,0x00000000}},	//   _madje_, _siarad_, _uutta_,
  { {0x824980e5,0x929250b3,0xdb458058,0x00000000}},	//   _firmy_, _neuadd_, _propriét,
  { {0xc2905092,0xa248c0e6,0x5387f093,0x00000000}},	//   _solas_, _jammer_, _sutra_,
  { {0xb2005070,0xbc5e304f,0x81d9a0ae,0x00000000}},	//   _polis_, _castell_, _republik_,
  { {0x95fc910f,0x243e207e,0x55872009,0x00000000}},	// [200] _प्रथम_, _даўно_, _قارئین_,
  { {0xc27e901a,0xb27ed05e,0x49a960d2,0x00000000}},	//   _imana_, _dienu_, _професій,
  { {0x226c102e,0xe0e2b0d0,0x58b53009,0x00000000}},	//   _schon_, _poznaval, _گوجرانوا,
  { {0x635490cc,0x2ef51053,0xa5b780b7,0x00000000}},	//   _rodents_, _telefóni, _لینوکس_,
  { {0x7f2dc0e4,0x7032103e,0xf3ac701d,0x00000000}},	//   _differen, _tratamen, _grupos_,
  { {0xa27ff04c,0xd6d2309d,0x03ce9071,0x00000000}},	//   _grund_, _инструкц, _pravi_,
  { {0xd52eb02a,0x8512006e,0xf4a900df,0x00000000}},	//   _respecto_, _תחבורה_, _pasahitz,
  { {0x42918001,0xcdf4305f,0x12d9b109,0x00000000}},	//   _gerai_, _регионал, _ddweud_,
  { {0xc349200a,0x2316001b,0x76c5c009,0x00000000}},	//   _diversi_, _faizi_, _نوٹسز_,
  { {0x3136d04a,0xe3436020,0x4db32092,0x00000000}},	//   _مراقب_, _livello_, _leanúnac,
  { {0xb386602c,0x998e00c8,0x9f116002,0x00000000}},	//   _hvort_, _нашим_, _contrata,
  { {0xf3a72096,0x56186095,0x9236c007,0x00000000}},	//   _другой_, _naslovni, _hiljem_,
  { {0xe2d98035,0x55c8307e,0x02fcc110,0x00000000}},	//   _pored_, _значна_, _blogga_,
  { {0x1fd630ce,0xa2d9e016,0x92ca710b,0x00000000}},	//   _تفعيل_, _veten_, _wanda_,
  { {0x826d10fe,0xad879096,0x93eb901d,0x00000000}},	//   _escola_, _размер_, _gusta_,
  { {0xa27ff012,0x9394d016,0x807440be,0x00000000}},	//   _trung_, _pjese_, _kalendār,
  { {0xa27ed051,0x1a74807f,0x529180cc,0x00000000}},	// [210] _dient_, _ranganna_, _sarap_,
  { {0x00a61029,0xb394d087,0x0d9900aa,0x00000000}},	//   _עסקנים_, _proses_, _reklamla,
  { {0x3106d032,0xd3959015,0x8874108b,0x00000000}},	//   _चौकशी_, _dessa_, _baliabid,
  { {0xa2ca000b,0xbfb2c04a,0xf4e2f041,0x00000000}},	//   _saidi_, _ندعوك_, _আলবাব_,
  { {0x28d6d036,0x52df10a1,0xe2d8c111,0x00000000}},	//   _estrateg, _menning_, _moden_,
  { {0x6f1e10aa,0x82926094,0xb706008d,0x00000000}},	//   _kendisin, _harald_, _украінск,
  { {0xb37b00cc,0x4f6d4028,0x4a4ec112,0x00000000}},	//   _paraiso_, _pasaules_, _директно_,
  { {0x74fa5008,0x60fe5024,0x49d5906e,0x00000000}},	//   _программ, _програми_, _מושלם_,
  { {0xad9880df,0xb22ac037,0x42732113,0x00000000}},	//   _publikoa, _годам_, _tänne_,
  { {0xb201b01d,0x9c07a08d,0xf3eb70d4,0x00000000}},	//   _enviar_, _навошта_, _beatvn_,
  { {0xdd6fc094,0x923e9067,0xa394e001,0x00000000}},	//   _elementa, _termék_, _maisto_,
  { {0x13da60b7,0x1749e0ab,0xc2cae094,0x00000000}},	//   _فعالیت_, _размишља, _landet_,
  { {0x42fd801b,0x1f81f05f,0x427eb052,0x00000000}},	//   _vergi_, _германиј, _odense_,
  { {0x53eab0a2,0x827f00e4,0x3608600d,0x00000000}},	//   _ndetse_, _thanks_, _normaali,
  { {0x76e8b018,0x1d9e3027,0xf3eb9015,0x00000000}},	//   _характер, _baterije_, _sista_,
  { {0x89e86063,0x187a702f,0x1e6220a9,0x00000000}},	//   _samozřej, _затворен, _imobilia,
  { {0xcf7aa09e,0x652900e3,0xbe466002,0x00000000}},	// [220] _افتتاح_, _definisy, _finalida,
  { {0x92d9110b,0xa200c114,0x227e6104,0x00000000}},	//   _reklamy_, _hodin_, _avons_,
  { {0xbdb4a0d2,0x257740b2,0x49ebd02b,0x00000000}},	//   _необхідн, _distrito_, _undersøg,
  { {0x8fe00041,0x329260ff,0x72572007,0x00000000}},	//   _প্রমাণ, _israil_, _jälle_,
  { {0x2f20e00a,0xb3bbc009,0x5fe8b06b,0x00000000}},	//   _attenden, _اسٹاک_, _साहाय्,
  { {0x8394e060,0xd200f03f,0x425b0059,0x00000000}},	//   _hansen_, _manier_, _maalum_,
  { {0x02cf8101,0x92ca50df,0xc3c08009,0x00000000}},	//   _podobne_, _talde_, _رینجرز_,
  { {0xceb33115,0x9378d0aa,0x0202600a,0x00000000}},	//   _autohton, _tamamen_, _ferita_,
  { {0x1aaa70c8,0xb378e10a,0x32eb20c5,0x00000000}},	//   _председн, _halaman_, _dopiero_,
  { {0xe7899048,0xf29e0092,0xb290c010,0x00000000}},	//   _неделя_, _téacs_, _malaki_,
  { {0x31772037,0xc3478036,0x11972116,0x00000000}},	//   _нехта_, _inkesta_, _koncerty_,
  { {0x5fe7e008,0x2c45b0ac,0x72d8001d,0x00000000}},	//   _пароль_, _рублёў_, _quien_,
  { {0xea58a10b,0x525ad00b,0x23ea2055,0x00000000}},	//   _licencia_, _selles_, _fakti_,
  { {0x5ceed090,0xe2b49117,0x5201e0aa,0x00000000}},	//   _града_, _inace_, _tatil_,
  { {0x625a2093,0xd2eee060,0xa28710e0,0x00000000}},	//   _rekla_, _kaffe_, _شہداء_,
  { {0xb5ef300d,0xe93f300d,0xcf8f300d,0x00000000}},	//   _kommenti, _kommentt, _kommento,
  { {0xf57f304a,0x9397404e,0xb200705c,0x00000000}},	// [230] _أصبحت_, _samarbej, _junie_,
  { {0x127e0046,0x146f409e,0xa25a5031,0x00000000}},	//   _maint_, _استعداد_, _salle_,
  { {0x22494026,0xfc537071,0xb290c118,0x00000000}},	//   _hieman_, _dostava_, _modal_,
  { {0x7273c027,0x85ee3002,0x08cc106e,0x00000000}},	//   _nepravil, _fundació, _באוקטובר_,
  { {0xc2c6b10c,0x235f3059,0x827d0006,0x00000000}},	//   _mislite_, _mengine_, _materiál,
  { {0xd236d061,0xd98b6027,0x4ecda055,0x00000000}},	//   _ideje_, _prehrana_, _komision,
  { {0x4224f00e,0x22ca708b,0x0a0f6014,0x00000000}},	//   _vaikus_, _jende_, _stranica_,
  { {0xec56b027,0xe27e70c6,0xe305c0f9,0x00000000}},	//   _kartice_, _denne_, _دورات_,
  { {0x427ef020,0x63eb9027,0x3ed4e0c0,0x00000000}},	//   _quindi_, _listo_, _socialin,
  { {0xb2b4000f,0x127e4059,0xa9dcc0c5,0x00000000}},	//   _price_, _namna_, _zabezpie,
  { {0x2af0b119,0x0c5ec035,0x3ea5b036,0x00000000}},	//   _الحديث_, _smatram_, _bestalde_,
  { {0x8387e030,0x3d6fc0b7,0x7098006e,0x00000000}},	//   _intra_, _احداث_, _התרבות_,
  { {0x62fe7049,0x156dd072,0x02ca7052,0x00000000}},	//   _target_, _норматив, _hende_,
  { {0xe27e6012,0x8afd80bb,0xf236911a,0x00000000}},	//   _phong_, _intervis, _imaju_,
  { {0x143ec08f,0x6b17c09d,0x12d94005,0x00000000}},	//   _разни_, _раздел_, _tweede_,
  { {0x02d8f04f,0xd394d0d6,0xf201e04e,0x00000000}},	//   _neges_, _kanske_, _altid_,
  { {0xb267c009,0xa7b870c5,0x0ebca047,0x00000000}},	// [240] _ایسوسی_, _regulami, _publiczn,
  { {0x925a40d6,0xada8d038,0x76bc204a,0x00000000}},	//   _gamla_, _activita, _لتحميل_,
  { {0x452a006e,0xbf17311b,0xcc22f09b,0x00000000}},	//   _הכתבות_, _perdagan, _skupiny_,
  { {0xc224911c,0x8e1c9043,0xe3ead0d8,0x00000000}},	//   _lekker_, _interaha, _sveta_,
  { {0x0200f04f,0x522470c5,0x654ce037,0x00000000}},	//   _megis_, _rynku_, _дагэтуль_,
  { {0x93aab02d,0xcf9ab00f,0xe375f017,0x00000000}},	//   _service_, _services_, _starfsem,
  { {0xdbf5a06e,0x42b0e06f,0xf2ca7086,0x00000000}},	//   _דוגמא_, _ग्रुप_, _vindt_,
  { {0x22d8d05c,0x6291805c,0xc4999035,0x00000000}},	//   _speel_, _veral_, _приближа,
  { {0x52a700d1,0x7394e0b5,0x55b680d2,0x00000000}},	//   _acabar_, _ganska_, _партії_,
  { {0xdcec006e,0x427e9044,0x76bc006e,0x00000000}},	//   _להשקיע_, _klang_, _להשאיר_,
  { {0x02da6010,0xa2ca706c,0xc34c706b,0x00000000}},	//   _karera_, _tande_, _निघून_,
  { {0x90578067,0xf87cc090,0x124890ed,0x00000000}},	//   _sziaszto, _поставље, _agama_,
  { {0xb25a0007,0xc2cb8108,0x81486116,0x00000000}},	//   _teile_, _airde_, _dostupno,
  { {0x82ca502c,0x8291811d,0xfa2db022,0x00000000}},	//   _halda_, _barat_, _посетите,
  { {0x90499029,0x1124106e,0xe25a503a,0x00000000}},	//   _אַלײן_, _הטלפון_, _kalla_,
  { {0x13f4700f,0x32fe602c,0xe2018015,0x00000000}},	//   _system_, _morgun_, _varit_,
  { {0x5dc5b0d8,0x5469109e,0x13f96062,0x00000000}},	// [250] _politike_, _مبارزه_, _siguro_,
  { {0xd71da0e8,0x48b9a048,0x0d73d05f,0x00000000}},	//   _normativ, _последни_, _територи,
  { {0xe290c098,0x31c8106e,0x6ab3211e,0x00000000}},	//   _allaha_, _לעיצוב_, _مدنظر_,
  { {0xb337c05f,0x829500ff,0x2651b01d,0x00000000}},	//   _никола_, _müavini_, _educació,
  { {0x7394e013,0x7207906e,0x3200510b,0x00000000}},	//   _maisha_, _רעננה_, _helix_,
  { {0xd3ea700c,0xeaea70aa,0xfc54905c,0x00000000}},	//   _sante_, _sistemle, _gauteng_,
  { {0x9a3e20db,0x57829035,0x9dbe00ba,0x00000000}},	//   _مستقیم_, _интелект, _verstand_,
  { {0x73eb9047,0xd27f4055,0xa27e002e,0x00000000}},	//   _posty_, _brenda_, _seine_,
  { {0x3e479029,0xbc9800a1,0x1b675053,0x00000000}},	//   _טעיפס_, _spurning_, _implicar,
  { {0x7a39c09d,0x22497017,0xd719707c,0x00000000}},	//   _недели_, _framan_, _conferên,
  { {0xe1dcc035,0xf395406a,0x198d4035,0x00000000}},	//   _хлеба_, _mjestu_, _комуналн,
  { {0xd12d2008,0xf3a37040,0x3d73a035,0x00000000}},	//   _часто_, _grappe_, _позната_,
  { {0x6202708b,0x22919028,0x2291e010,0x00000000}},	//   _musika_, _masas_, _tatak_,
  { {0xc2461090,0x0d0c5012,0xd94f4057,0x00000000}},	//   _здрав_, _starspor, _razlicit,
  { {0x6945a054,0x72acf018,0x120da08f,0x00000000}},	//   _utilisat, _характер_, _проверка_,
  { {0x7aeb6035,0xd168206e,0x311da0c8,0x00000000}},	//   _neprijat, _התוצאה_, _проблеме_,
  { {0xedcb3003,0xb3fa70cc,0x417da06e,0x00000000}},	// [260] _مثلاً_, _basura_, _ריקוד_,
  { {0x3ccdb008,0xec7520b1,0x1394d066,0x00000000}},	//   _последне, _celular_, _agosti_,
  { {0x12d820c3,0x53f990a7,0xf468206e,0x00000000}},	//   _printed_, _kasus_, _התהליך_,
  { {0x9290c01d,0xf1cc20cc,0x429260c0,0x00000000}},	//   _todas_, _primetim, _metais_,
  { {0x8200b0b0,0x52019055,0x1dd930db,0x00000000}},	//   _medien_, _besim_, _حتماً_,
  { {0xfc7c8002,0x72365017,0x9b7f2020,0x00000000}},	//   _existen_, _selja_, _francesc,
  { {0x0facd012,0x9206104a,0xf5a390bd,0x00000000}},	//   _truongto, _ناروتو_, _помеѓу_,
  { {0x102c602f,0x22025068,0xd290f0ba,0x00000000}},	//   _користењ, _imtina_, _nogal_,
  { {0xb3ddb036,0x23ced012,0xd2eb1010,0x00000000}},	//   _normaliz, _raovat_, _soriano_,
  { {0x03ebf00d,0x92919055,0xc25a504f,0x00000000}},	//   _mutta_, _kesaj_, _wella_,
  { {0xdb5bf052,0x56154029,0x8236502c,0x00000000}},	//   _pedersen_, _סטאטיסטי, _telja_,
  { {0xfd45e038,0x829190b9,0x1eb16002,0x00000000}},	//   _competic, _casas_, _externas_,
  { {0x9369211f,0x52bf10b7,0x52918070,0x00000000}},	//   _bloggar_, _املاک_, _paras_,
  { {0x73ea007f,0x32ea308f,0x34724027,0x00000000}},	//   _maith_, _употреба_, _navedeno_,
  { {0xc2b1d020,0x824a7038,0x2f5d3120,0x00000000}},	//   _vendita_, _normes_, _opravdan,
  { {0x8143b0b0,0xe3cef099,0x62d8c0e8,0x00000000}},	//   _innerhal, _privit_, _podes_,
  { {0x82d8b03f,0x7c51c064,0x1c02b012,0x00000000}},	// [270] _andere_, _kultura_, _jetstar_,
  { {0x7f761121,0x326d90bb,0xd3121054,0x00000000}},	//   _שייכות_, _besoj_, _membres_,
  { {0x520190aa,0x7f3ac027,0x39803041,0x00000000}},	//   _resim_, _pregledn, _পারতাম,
  { {0x927f7122,0x92b5804f,0xd2d46054,0x00000000}},	//   _uganda_, _merch_, _jardin_,
  { {0x12918036,0x83ea30d8,0x9b0bf022,0x00000000}},	//   _berak_, _tejto_, _страны_,
  { {0x61dc10ac,0x72a7c08d,0x7720106e,0x00000000}},	//   _альбо_, _такога_, _במגוון_,
  { {0x1386011f,0xd2fce106,0xc8f45056,0x00000000}},	//   _meira_, _tangan_, _телефонн,
  { {0x82ca70a3,0x3e2cc05f,0x3278601b,0x00000000}},	//   _ganda_, _влада_, _olunan_,
  { {0xa292000c,0x62b5203f,0x9eb6c08f,0x00000000}},	//   _separe_, _succes_, _профила_,
  { {0x3be7400a,0x2b07c0c8,0x1487c035,0x00000000}},	//   _direttor, _видели_, _видела_,
  { {0x73463040,0xe49b20c5,0xbbefb123,0x00000000}},	//   _kinders_, _ogranicz, _pardubic,
  { {0x727f8124,0xf26c50a3,0x1061c0b7,0x00000000}},	//   _mirna_, _bilog_, _کنسرت_,
  { {0xe25a500d,0x8d1e201a,0x8ec330b2,0x00000000}},	//   _kello_, _jenoside_, _anuncian,
  { {0x426c90e5,0xd1776032,0x12e3d00c,0x00000000}},	//   _škola_, _जर्सी_, _avantaj_,
  { {0x0d62c009,0xa27e3055,0x7682806f,0x00000000}},	//   _ردعمل_, _bejne_, _दिमाग_,
  { {0x9387401b,0xab0f4002,0x4528706c,0x00000000}},	//   _enerji_, _resposta_, _aplikasy,
  { {0xa386007c,0x5a8e206e,0x72895039,0x00000000}},	// [280] _feira_, _בוואלה_, _kliknij_,
  { {0x7249810b,0x46c28027,0xb543f01b,0x00000000}},	//   _forme_, _organizi, _komissiy,
  { {0x427f0079,0xe7b59011,0x927c604e,0x00000000}},	//   _leanas_, _moisturi, _forskell,
  { {0x1a5ca00e,0x8200b071,0xbf980029,0x00000000}},	//   _kolegija_, _medije_, _צענזור_,
  { {0xa2b58031,0x4394e031,0x926cc0a4,0x00000000}},	//   _merci_, _maison_, _pomocy_,
  { {0x5386d02c,0xc27e00ba,0xdc4930d2,0x00000000}},	//   _hvers_, _klink_, _харківсь,
  { {0x153c3054,0x83a24076,0xa2b5700c,0x00000000}},	//   _recherch, _tempo_, _chache_,
  { {0xa2d98125,0xac05f00d,0x00000000,0x00000000}},	//   _okres_, _torstai_,   ,
  { {0x82d8e058,0xd34450c9,0x82bc7027,0x00000000}},	//   _effet_, _recenze_, _gledano_,
  { {0x72ca702c,0x63ea9083,0x6f960029,0x00000000}},	//   _senda_, _imati_, _מיטלען_,
  { {0x8224001a,0xc27e50f9,0x040ae0d2,0x00000000}},	//   _ariko_, _مستقلة_, _квітня_,
  { {0xfacde048,0x72f2206f,0x53f9d109,0x00000000}},	//   _посещени, _कबीरा_, _rywun_,
  { {0xff61f098,0xffc56036,0xc2d8b097,0x00000000}},	//   _çünki_, _autonomo, _budemo_,
  { {0x318110ce,0xbb78603a,0x7c19f008,0x00000000}},	//   _العظيم_, _applianc, _предоста,
  { {0x7ecdd048,0xa598101a,0x93f47055,0x00000000}},	//   _продажба_, _starbuck, _rastin_,
  { {0x22e76012,0x0290704f,0x83959126,0x00000000}},	//   _diendan_, _hunan_, _fosse_,
  { {0x7291c0aa,0x1ed05009,0x5981f09b,0x00000000}},	// [290] _devam_, _مشاورت_, _politike,
  { {0x4cfde008,0x8246d09d,0x826e60bf,0x00000000}},	//   _последни, _интернет_, _naroda_,
  { {0xd3dc904f,0x03160084,0x62fc6020,0x00000000}},	//   _prawf_, _reizi_, _luogo_,
  { {0x744a30db,0x4f7d607e,0x627ee0c6,0x00000000}},	//   _نتایج_, _ажыццяўл, _meinte_,
  { {0x090e80c8,0x00000000,0x00000000,0x00000000}},	//   _смислу_,   ,   ,
  { {0x5063d127,0x026ca006,0x12f1e0a4,0x00000000}},	//   _договор_, _školy_, _pomocą_,
  { {0xd3eae128,0xf2ca000b,0x62fe705c,0x00000000}},	//   _kontak_, _veidi_, _kruger_,
  { {0x825ac040,0x69fd30b1,0xc2916001,0x00000000}},	//   _willem_, _pagament, _negali_,
  { {0xf394e051,0xb8dc40a1,0x73998092,0x00000000}},	//   _mensen_, _spurning, _sásta_,
  { {0xaef870d5,0xbd31b06f,0xb3b5e0d0,0x00000000}},	//   _קערפער_, _स्टॉक_, _plovila_,
  { {0x8484106f,0x6a95c06b,0x8c6a201b,0x00000000}},	//   _आँखामा, _स्वीका, _sonuncu_,
  { {0x72480020,0xdb48f096,0x1ae45041,0x00000000}},	//   _primo_, _версия_, _চেহারা,
  { {0xf4a4a0c5,0xf5a83036,0xd343006b,0x00000000}},	//   _najbardz, _klaserak, _तरतूद_,
  { {0xb2fcf04f,0xe2d91117,0x72caa059,0x00000000}},	//   _bangor_, _mozes_, _labda_,
  { {0xf2cae0de,0x23ea0043,0xe4da102f,0x00000000}},	//   _hunden_, _ifite_, _босна_,
  { {0xc394e052,0x6291501a,0x22cae0b0,0x00000000}},	//   _jensen_, _kagame_, _kunden_,
  { {0x7133d0fd,0x4224e021,0x1239e091,0x00000000}},	// [2a0] _регистра, _denken_, _formati_,
  { {0xecd7309e,0xed06e038,0x3e6ae076,0x00000000}},	//   _اعلام_, _carreter, _cancella,
  { {0xa25a5054,0xf2d9c038,0x525ad028,0x00000000}},	//   _belle_, _haver_, _skolas_,
  { {0xecd7309e,0xba885026,0x8c0d0031,0x00000000}},	//   _اعمال_, _kokonais, _propose_,
  { {0xdc74a015,0xb7b78092,0xffbe1055,0x00000000}},	//   _forumet_, _tairisci, _evolucio,
  { {0x36ccc01a,0x2c69206a,0xc3f90001,0x00000000}},	//   _panasoni, _zapravo_, _nebuvo_,
  { {0xed8c7027,0x52a6d00e,0x4d9d600d,0x00000000}},	//   _točke_, _globos_, _sunnunta,
  { {0x9679f07e,0x62fd205a,0x8290f0b0,0x00000000}},	//   _правасла, _aplicar_, _sogar_,
  { {0x67cc6060,0xf9845041,0x429180b2,0x00000000}},	//   _personli, _কদমতলী, _obras_,
  { {0xd5d53090,0xb24a602e,0xd0b0909b,0x00000000}},	//   _туризма_, _firmen_, _digitáln,
  { {0x2ed6805a,0x90438029,0xb5168027,0x00000000}},	//   _opinions_, _קאַװע_, _frizersk,
  { {0x82c94002,0xce394050,0xb2e310aa,0x00000000}},	//   _deporte_, _deportes_, _halinde_,
  { {0x1255a099,0xfc66c0be,0x0c6e1013,0x00000000}},	//   _problémá, _protams_, _gharama_,
  { {0xe2fc902e,0xf2925089,0xcf25b020,0x00000000}},	//   _frage_, _fetare_, _selezion,
  { {0x43eae05e,0x690490ac,0x125b6017,0x00000000}},	//   _lifts_, _сувязі_, _reglur_,
  { {0x63f40062,0x2181406b,0x62b47129,0x00000000}},	//   _gastos_, _रहुवे_, _mince_,
  { {0xe969e037,0xc36c40cb,0xd36aa037,0x00000000}},	// [2b0] _разгляда, _blogeri_, _канкрэтн,
  { {0xc25a500b,0xe928805f,0x691a00fa,0x00000000}},	//   _selle_, _центар_, _последно_,
  { {0x8200c059,0x7af9900a,0xf94cf090,0x00000000}},	//   _kuliko_, _shenzhen_, _принципу_,
  { {0xa291c028,0xbfe00041,0x038d1091,0x00000000}},	//   _savas_, _প্রমান, _proposti_,
  { {0x693d304a,0xa37ca0b9,0x63ea00a1,0x00000000}},	//   _الآخر_, _durante_, _neitt_,
  { {0x13fa5045,0x2b11b04a,0x325be04d,0x00000000}},	//   _futuro_, _أمريكا_, _title_,
  { {0x831640a7,0x78879029,0x225e2036,0x00000000}},	//   _kembali_, _קעסטל_, _kontseil,
  { {0xaf294007,0xe2fc705c,0xfc51b044,0x00000000}},	//   _reporter_, _dinge_, _showbiz_,
  { {0x1201f013,0x83878016,0x5c670086,0x00000000}},	//   _lazima_, _marre_, _storing_,
  { {0x2dc45065,0x5163e033,0x39f3e0d8,0x00000000}},	//   _европейс, _programl, _programe,
  { {0xd26de01d,0xb43ec008,0x32a6a017,0x00000000}},	//   _datos_, _давно_, _pabbi_,
  { {0xd26e60be,0xa9827073,0xc93c2052,0x00000000}},	//   _autors_, _možnost_, _sommerfe,
  { {0x92d9e016,0x92a6201d,0xa3ea712a,0x00000000}},	//   _vetem_, _nombre_, _tento_,
  { {0x326e10c6,0xd7271056,0x02f20067,0x00000000}},	//   _napoli_, _публікац, _mégis_,
  { {0x8324c01a,0xc9da8020,0x5c34502d,0x00000000}},	//   _habyarim, _preferit, _standard_,
  { {0x22fc7059,0x72fea051,0xc201e055,0x00000000}},	//   _bunge_, _methode_, _ketij_,
  { {0x53fba0e9,0x9c143009,0x5200c059,0x00000000}},	// [2c0] _קפיצה_, _سوچنے_, _malipo_,
  { {0x7394004f,0xc395811f,0x6394e0a9,0x00000000}},	//   _prism_, _fyrst_, _exista_,
  { {0x22d9e0ba,0xd8e2f0fd,0x5001e03c,0x00000000}},	//   _later_, _репутаци, _fotogrāf,
  { {0x33ea70b9,0x65d9907e,0x62c01055,0x00000000}},	//   _gente_, _распаўсю, _mëdha_,
  { {0x73f470b0,0xb651502c,0xe4172041,0x00000000}},	//   _besten_, _skrifað_, _হারহান,
  { {0x70743028,0xd29030a7,0xd3730054,0x00000000}},	//   _komentār, _malang_, _domaine_,
  { {0xbaea703f,0x92ca70aa,0x75c1404a,0x00000000}},	//   _bestelle, _bende_, _الربيع_,
  { {0x89472048,0x76e580c1,0x627e0079,0x00000000}},	//   _трудно_, _asociaci, _baint_,
  { {0x3d05109a,0x52267055,0xbace1008,0x00000000}},	//   _instrucc, _perket_, _поведени,
  { {0xf248000d,0x3903f029,0xc26de0b5,0x00000000}},	//   _viime_, _פאָלק_, _dator_,
  { {0x6c8020bd,0xe4155041,0x8c29301b,0x00000000}},	//   _вечер_, _উদাহরণ, _versiyas,
  { {0x762770a8,0x0200f104,0x2290b117,0x00000000}},	//   _رایانه_, _panier_, _dodaje_,
  { {0xf3eae012,0x49d22051,0xdb0c1029,0x00000000}},	//   _dantri_, _geregist, _אלימלך_,
  { {0x529de071,0x46b2f024,0xd5be20c8,0x00000000}},	//   _prijava_, _редактор, _кругу_,
  { {0x08dc50db,0x7262d09e,0x22b47083,0x00000000}},	//   _ازدواج_, _سابقه_, _sunce_,
  { {0x4c4e304a,0x358a108f,0x5792904f,0x00000000}},	//   _بمعنى_, _проблеми, _manteisi,
  { {0xe29030a3,0x617ed04a,0x7616504f,0x00000000}},	// [2d0] _nalang_, _أماكن_, _poblogai,
  { {0xf635806b,0xe2918001,0x12498010,0x00000000}},	//   _सिंधुद, _geras_, _germs_,
  { {0x73a3f047,0x130e402d,0xd2c51061,0x00000000}},	//   _grupa_, _details_, _kellene_,
  { {0x33f8600c,0x52caf04c,0x93eaf02e,0x00000000}},	//   _atout_, _sagde_, _sagte_,
  { {0x3c3e0029,0x32d98074,0x72c47029,0x00000000}},	//   _צוקונפט_, _keres_, _באשיצן_,
  { {0x9fab30ee,0x6248d028,0x8109a029,0x00000000}},	//   _nemovito, _filmas_, _אינגאנצע,
  { {0xa27f1071,0x52da5001,0x396bc088,0x00000000}},	//   _razno_, _europos_, _своето_,
  { {0xa2fb001a,0x4290c02c,0x2b5bc024,0x00000000}},	//   _toshiba_, _undan_, _сказав_,
  { {0x92003010,0x986f2025,0xe200401b,0x00000000}},	//   _galing_, _shoppers_, _kimin_,
  { {0x43d090b7,0x62b4009a,0xaac45054,0x00000000}},	//   _علیرضا_, _inici_, _gouverne,
  { {0x4e73e08e,0xcf246077,0xd2d9e02d,0x00000000}},	//   _मुफ्त_, _quách_, _water_,
  { {0xc3eae005,0xa868c04a,0xca1b906b,0x00000000}},	//   _aantal_, _ليبيا_, _कांबळे,
  { {0x53ebe0d6,0x52d9901d,0x42919002,0x00000000}},	//   _hitta_, _meses_, _mesas_,
  { {0x72d9801b,0xb103a06e,0x82910020,0x00000000}},	//   _aprel_, _לטיול_, _sabato_,
  { {0x5394d0a9,0xefae108d,0xf25a5033,0x00000000}},	//   _acest_, _ласка_, _belli_,
  { {0xa3f9e055,0xe3959020,0x72925093,0x00000000}},	//   _patur_, _possa_, _ostaje_,
  { {0xf2ee5084,0x725be02c,0x5394e032,0x00000000}},	// [2e0] _delfi_, _litla_, _benshi_,
  { {0xa37f3033,0xc248901a,0x3ba6506b,0x00000000}},	//   _zamanda_, _inama_, _कलाकार,
  { {0x42bca0a9,0xe2d980b0,0xe291f012,0x00000000}},	//   _mondial_, _foren_, _thuat_,
  { {0x22003087,0x0c140094,0x207d308f,0x00000000}},	//   _paling_, _gruppen_, _такси_,
  { {0x5248d095,0x20ea20b7,0x0b23a121,0x00000000}},	//   _njemu_, _فراوان_, _האדמו_,
  { {0x327ee040,0xd0d33088,0xcbda6037,0x00000000}},	//   _kennis_, _власт_, _конкурсе_,
  { {0x727e90d6,0x526c80a2,0xfc5a700a,0x00000000}},	//   _bland_, _gukora_, _mentali_,
  { {0xfc00b001,0x9aeda054,0x49eda002,0x00000000}},	//   _miestas_, _actualit, _actualid,
  { {0x0291e093,0x39e4e00b,0xb3fa60c3,0x00000000}},	//   _petak_, _dokumend, _berupa_,
  { {0x1249f043,0xe53240d2,0xb2d460cc,0x00000000}},	//   _nyuma_, _централь, _hardin_,
  { {0xee47a029,0x2386d01a,0x4f4da029,0x00000000}},	//   _העלפט_, _mbere_, _היברו_,
  { {0xd278600c,0x28a4f022,0x8a11800f,0x00000000}},	//   _tounen_, _отсутств, _departme,
  { {0x21c9208f,0x23f820e7,0x32d99075,0x00000000}},	//   _гости_, _hukum_, _leser_,
  { {0x51b2c0f8,0x03f7e0ac,0x42153009,0x00000000}},	//   _সাবেক_, _травень_, _کوائف_,
  { {0x83ea0092,0x72c3712b,0xc3806015,0x00000000}},	//   _leith_, _poslova_, _corren_,
  { {0x322b0060,0xfa43b090,0xa3805051,0x00000000}},	//   _kommune_, _интелиге, _entree_,
  { {0x22e7600c,0x5f9ac06b,0xeeed70c2,0x00000000}},	// [2f0] _trennen_, _बहुतां, _toivotta,
  { {0xe43c5041,0xd291f079,0x33f98067,0x00000000}},	//   _প্লিজ_, _thuas_, _szórakoz,
  { {0x72e2506b,0xe9ddc024,0x0b57f0e2,0x00000000}},	//   _जाणीव_, _оплата_, _kultúra_,
  { {0xe2fc712c,0xf34880a1,0x3eab1038,0x00000000}},	//   _bunga_, _netfang_, _galeries_,
  { {0x197a111e,0xeff21121,0x53454027,0x00000000}},	//   _تقسیم_, _וחדשות_, _naselje_,
  { {0x120070f3,0xe201801b,0xa2d6c020,0x00000000}},	//   _dunia_, _verir_, _secondo_,
  { {0xa4b39029,0xfc394038,0x32d85064,0x00000000}},	//   _ברסלב_, _inscripc, _inlet_,
  { {0xf6397002,0xb386d0d6,0xcc537027,0x00000000}},	//   _aplicaci, _flera_, _kartica_,
  { {0x4950b094,0x2abca065,0x2630b049,0x00000000}},	//   _personer_, _министър_, _personel_,
  { {0x120fc09e,0x62c6b0ba,0x22ca7036,0x00000000}},	//   _محترم_, _verlede_, _handi_,
  { {0x52ca712d,0x9c645059,0x527ed04e,0x00000000}},	//   _kandi_, _wabunge_, _kroner_,
  { {0x8f06c09e,0x9386d12e,0x425af079,0x00000000}},	//   _معروف_, _utorak_, _eagla_,
  { {0xa27e7015,0x8efba06e,0xe2d8b12f,0x00000000}},	//   _denna_, _בהכרח_, _budete_,
  { {0x2201804c,0xce72606f,0x5290703a,0x00000000}},	//   _skriv_, _जेम्स_, _annan_,
  { {0x294e1095,0x2224d016,0x84178130,0x00000000}},	//   _prolazit, _greke_, _presiden_,
  { {0x83cf10e3,0x2342a02d,0x334360b1,0x00000000}},	//   _travay_, _general_, _governo_,
  { {0x3adfb064,0x0760c09e,0x397d1009,0x00000000}},	// [300] _postavit, _منافع_, _ایگزیکٹو_,
  { {0x7c5b8057,0x425db001,0x32d8a055,0x00000000}},	//   _postoji_, _sprendim, _sidomos_,
  { {0x6d0a4027,0x2bae2048,0xf405208e,0x00000000}},	//   _odgovore_, _различни_, _एकादशी,
  { {0x6359e01a,0x73ea0131,0xf25a6007,0x00000000}},	//   _firefox_, _ayiti_, _poole_,
  { {0xa24a7070,0xf075d0be,0x1e3cc003,0x00000000}},	//   _permit_, _materiāl, _مشروط_,
  { {0x127e7031,0x92d98049,0x2c1d1061,0x00000000}},	//   _bonne_, _corel_, _csoport_,
  { {0xc2e3d096,0x6b6f3053,0xf20270a9,0x00000000}},	//   _оценка_, _natureza_, _masina_,
  { {0x531710e2,0x78b2a132,0xf3f0b057,0x00000000}},	//   _fuzzy_, _nejnověj, _bezobraz,
  { {0x43f8700d,0xec1e109b,0xed246027,0x00000000}},	//   _minun_, _redaktor, _avanture_,
  { {0x81e2c08e,0xb4a9600f,0x78a8e07e,0x00000000}},	//   _विवरण_, _national_, _жніўня_,
  { {0xa2890031,0x39b73041,0x03f820aa,0x00000000}},	//   _appartem, _সাবধান, _hukuk_,
  { {0x62007092,0xa2d9a089,0xcd9d700b,0x00000000}},	//   _inniu_, _teper_, _tunnista,
  { {0x35be2065,0x3212b00c,0x129260b0,0x00000000}},	//   _други_, _peche_, _gerade_,
  { {0xb25b7007,0x525a5015,0xb1222027,0x00000000}},	//   _avalda_, _kolla_, _prijavil,
  { {0x126cd10b,0x9237e0c5,0xa917e08f,0x00000000}},	//   _ludom_, _chomika_, _градина_,
  { {0xff155041,0x827ef043,0x2973b06e,0x00000000}},	//   _মুখোমু, _ibintu_, _ברוטב_,
  { {0xf34150b0,0xebd1f042,0x8f352041,0x00000000}},	// [310] _anderen_, _अर्पण_, _গল্পের,
  { {0x827f70e7,0x8237803b,0xe71f1024,0x00000000}},	//   _adanya_, _sarja_, _спортсме,
  { {0x42918050,0x927ed09c,0x53a2d007,0x00000000}},	//   _horas_, _vaenu_, _hoopis_,
  { {0xa2d46064,0xd2b21027,0xcb7d309f,0x00000000}},	//   _studia_, _gradnja_, _finanční_,
  { {0x22ca7055,0x86cef060,0xff45b041,0x00000000}},	//   _vendi_, _behandli, _ইদানিং,
  { {0x73eac061,0xd27f811b,0xb394d0c5,0x00000000}},	//   _voltak_, _warna_, _prostu_,
  { {0x7567e029,0x1396601a,0x8c5ed0f0,0x00000000}},	//   _באַציִונ, _airson_, _kratkim_,
  { {0x23e00067,0x2bf6a06b,0x426db040,0x00000000}},	//   _péter_, _प्रथमच, _geword_,
  { {0xc3cef03a,0x43f8e0ca,0xec36a10b,0x00000000}},	//   _driver_, _minutu_, _kategóri,
  { {0xd2fc7013,0x83ea100c,0xa3eb9092,0x00000000}},	//   _mungu_, _achte_, _casta_,
  { {0xad292047,0x53949066,0x327f4051,0x00000000}},	//   _komputer, _siasa_, _dienst_,
  { {0xe3ea9115,0x38654067,0xa365801a,0x00000000}},	//   _toate_, _tetejére_, _tangazo_,
  { {0x02cae051,0x0397c060,0xa2018038,0x00000000}},	//   _minder_, _medarbej, _morir_,
  { {0x12a66047,0x025a903a,0x2487606f,0x00000000}},	//   _osoby_, _skall_, _बिपाशा,
  { {0x12ed406b,0x52d8f061,0x627f4013,0x00000000}},	//   _नोटीस_, _engem_, _upendo_,
  { {0x23a9d027,0x2533106b,0x0202700c,0x00000000}},	//   _pohvale_, _आजोबा_, _deside_,
  { {0xc2006079,0x6291c0be,0x426d1012,0x00000000}},	// [320] _anois_, _nevar_, _socola_,
  { {0x72cae04b,0x9ecd20a9,0x12ca1091,0x00000000}},	//   _finden_, _cotidian, _reklami_,
  { {0x4317802a,0x12afc04a,0xa2006133,0x00000000}},	//   _marzo_, _نصائح_, _kulit_,
  { {0xbc76502d,0xb29070d6,0x7200d00e,0x00000000}},	//   _results_, _annat_, _toliau_,
  { {0xa2926111,0x528b6064,0x6200c00d,0x00000000}},	//   _berada_, _pomocí_, _tulisi_,
  { {0xc030c134,0xac23807c,0x6c76306f,0x00000000}},	//   _prethodn, _entrevis, _मेट्रो,
  { {0x18c68041,0x1200e036,0x12c4b02a,0x00000000}},	//   _উদ্যোগ, _benito_, _premios_,
  { {0xa3ea9115,0x9b5c40ec,0xb2d900d6,0x00000000}},	//   _poate_, _političk, _arbete_,
  { {0xc27f001a,0x7101305f,0x42fc001d,0x00000000}},	//   _abantu_, _двете_, _amigo_,
  { {0x53ebe0b0,0x427ff04f,0x9c678043,0x00000000}},	//   _hatte_, _ymuno_, _gahunda_,
  { {0xe2cae02e,0xf7a2800c,0x3486e06f,0x00000000}},	//   _kinder_, _kontribi, _हिरासत,
  { {0x33940061,0x127ed135,0xf739c002,0x00000000}},	//   _friss_, _jwenn_, _deportiv,
  { {0x53a30001,0xfdc5b04f,0xf2b53005,0x00000000}},	//   _etapas_, _ffrindia, _huidige_,
  { {0xa3f8700d,0xfa50b041,0x52ca9124,0x00000000}},	//   _sinun_, _রিজভী_, _mladi_,
  { {0x7c66c09a,0xa2ca9136,0x5f1e9072,0x00000000}},	//   _centres_, _ifade_, _основних_,
  { {0x96fd7022,0x0248302e,0x83ead076,0x00000000}},	//   _проблемы_, _kommen_, _mentre_,
  { {0xf3e540f8,0x8f02c037,0xd86a9031,0x00000000}},	// [330] _চমৎকার, _школе_, _politiqu,
  { {0x001ee0b3,0x83ea710b,0x748da001,0x00000000}},	//   _negeseuo, _konta_, _situacij,
  { {0x93050137,0x03807104,0x82cae055,0x00000000}},	//   _béarla_, _heures_, _vendet_,
  { {0xd603b08e,0x72cb004c,0xf386d03a,0x00000000}},	//   _सुंदर_, _grader_, _flere_,
  { {0xf25ad028,0x4212b01d,0xfdbca0cc,0x00000000}},	//   _apollo_, _fecha_, _pilipina,
  { {0x2aeb308b,0x92ef2138,0xab6380ab,0x00000000}},	//   _horregat, _meminta_, _rečenica_,
  { {0x426e609a,0x82d8a00c,0x1c66a060,0x00000000}},	//   _aprova_, _kiben_, _fortsat_,
  { {0x95e2f053,0x7478606b,0x0a7e0043,0x00000000}},	//   _categorí, _हेलिकॉ, _byandits,
  { {0x13f9a014,0x92fce12c,0x938dc10e,0x00000000}},	//   _poput_, _fungsi_, _اشخاص_,
  { {0x87b49041,0xe25af081,0x32d8e08b,0x00000000}},	//   _আজাইরা, _edildi_, _genero_,
  { {0xd26e0109,0xb290201b,0x9ad2901d,0x00000000}},	//   _eisoes_, _imkan_, _contrase,
  { {0xf290203c,0x5c66d001,0xf40d1088,0x00000000}},	//   _tikai_, _centras_, _опрема_,
  { {0xbe57c0ce,0xc127c0bd,0x89b1402a,0x00000000}},	//   _دردشة_, _работи_, _garantía_,
  { {0xbb071088,0xfb5c4139,0x3248013a,0x00000000}},	//   _жители_, _političa, _naime_,
  { {0x53977009,0xa6b7d0d2,0x62d9a025,0x00000000}},	//   _غالباً_, _категорі, _koper_,
  { {0x039580bb,0xe86cf06f,0x8ee92027,0x00000000}},	//   _kurse_, _गतिविध, _parkiran,
  { {0x92d8c04e,0x72fcd095,0xf2852012,0x00000000}},	// [340] _inden_, _bloger_, _vnphoto_,
  { {0x8c0d700d,0xe20150f0,0x92020047,0x00000000}},	//   _tampere_, _regije_, _lipiec_,
  { {0xb486d035,0x029040a9,0x1c536098,0x00000000}},	//   _имена_, _numai_, _tətbiq_,
  { {0x93ac60de,0xab6ab0ff,0xca5b70af,0x00000000}},	//   _gruppe_, _allahın_, _nghênh_,
  { {0x2c6a108e,0x7305c09e,0x3dab2020,0x00000000}},	//   _कृष्णा, _اوراق_, _assicura,
  { {0x03eb9057,0x5224e01c,0x9b72d02f,0x00000000}},	//   _zasto_, _punkti_, _атина_,
  { {0xb27e6012,0xb6cf2059,0x32abc02b,0x00000000}},	//   _joong_, _majadili, _håber_,
  { {0xf3eb8104,0xd201a13b,0xd2cad031,0x00000000}},	//   _carte_, _popis_, _vendre_,
  { {0x0101313c,0xb3ac6103,0x810c006e,0x00000000}},	//   _свети_, _gruppi_, _להרגיש_,
  { {0xc101308f,0x12d8c04e,0xe2eb1020,0x00000000}},	//   _света_, _anden_, _periodo_,
  { {0x22907061,0x32915059,0x828d4020,0x00000000}},	//   _annak_, _ingawa_, _appartam,
  { {0xe1add024,0xa999e095,0x32a06033,0x00000000}},	//   _користув, _reakcija_, _şubat_,
  { {0x7ce90095,0xec5ca04d,0xaf6f3002,0x00000000}},	//   _plastičn, _control_, _demandas_,
  { {0xfb97f067,0xe2fc904d,0x23eb90b1,0x00000000}},	//   _regisztr, _image_, _deste_,
  { {0x1ca6605b,0xd147c065,0xc2257101,0x00000000}},	//   _журналіс, _написа_, _vlakom_,
  { {0xc2918073,0xa2d9e03f,0x62da601a,0x00000000}},	//   _stran_, _beter_, _gereza_,
  { {0x9e14a0c0,0x9329a088,0xf23780b5,0x00000000}},	// [350] _telefona, _прегледа, _varje_,
  { {0x027e901a,0x97113009,0x4c058010,0x00000000}},	//   _cyane_, _جنازہ_, _toothpas,
  { {0xc2cb80b2,0xb20200a4,0x825af00c,0x00000000}},	//   _tarde_, _musisz_, _regle_,
  { {0xa6df504a,0x36a2c037,0x07b3603c,0x00000000}},	//   _أسابيع_, _нібыта_, _situācij,
  { {0x89e3c0bd,0x7851713d,0xc147d096,0x00000000}},	//   _новата_, _recomend, _написал_,
  { {0x62007079,0xcc74300a,0x7149b061,0x00000000}},	//   _minic_, _annulus_, _infotech_,
  { {0x2c74008e,0xd6edb047,0xf9f670fb,0x00000000}},	//   _आवश्यक, _finansow, _atrás_,
  { {0xa3eae061,0x1c50106e,0xdf2ee050,0x00000000}},	//   _fontos_, _למטייל_, _segurida,
  { {0xb98b4020,0x902ec024,0x72b520b1,0x00000000}},	//   _richiest, _назва_, _índice_,
  { {0x127f0052,0x427ee0b5,0x3e3b20c0,0x00000000}},	//   _blandt_, _kvinna_, _remontas_,
  { {0xa96d612c,0x927f700c,0x52d8c05c,0x00000000}},	//   _komputer_, _chante_, _namens_,
  { {0xa248c0ba,0x42cae13e,0xca0d607c,0x00000000}},	//   _sommer_, _bundan_, _computad,
  { {0x39d3b046,0xa3404038,0xe2cad021,0x00000000}},	//   _genedlae, _defensa_, _goede_,
  { {0xd202502a,0x86a88096,0x925ac026,0x00000000}},	//   _artigo_, _значит_, _millon_,
  { {0x23eb9051,0xe291e00c,0x4b2ac065,0x00000000}},	//   _vaste_, _batay_, _основнит,
  { {0x70c30041,0xe319106b,0x73f46060,0x00000000}},	//   _সংগীত_, _उज्ज्व, _morten_,
  { {0x3b6ac05c,0x3b8b90ec,0xd27ad002,0x00000000}},	// [360] _pretoria_, _ministar, _constell,
  { {0x6395f00a,0x9349e00d,0xdc7140d9,0x00000000}},	//   _fluss_, _hotelli_, _maarufu_,
  { {0x5667808e,0x44b3f029,0x7fc8a02f,0x00000000}},	//   _नुकसान, _באָבע_, _промовир,
  { {0x7912e0af,0x32d9c01b,0x3f836006,0x00000000}},	//   _dântrí_, _sovet_, _otázka_,
  { {0x18e6207e,0x5f980029,0xbbabd065,0x00000000}},	//   _частка_, _בעלזער_, _обикнове,
  { {0xc2d9e02e,0x25abf029,0xae39a0bd,0x00000000}},	//   _alter_, _עקאָנאָמ, _занимлив,
  { {0xd2f6213f,0xe347c016,0x729180c0,0x00000000}},	//   _nadimak_, _menduar_, _vyras_,
  { {0xdd05500b,0x49f4c0e2,0x72f50012,0x00000000}},	//   _populaar, _salón_, _vovinam_,
  { {0x679d8088,0xf290300d,0x6201c0b1,0x00000000}},	//   _сообраќа, _jumala_, _envie_,
  { {0x2f9930af,0xcb8c003e,0xcae5b041,0x00000000}},	//   _nhất_, _judiciar, _আর্থিক,
  { {0x962a002e,0xafca0140,0xe1e12047,0x00000000}},	//   _registri, _registro, _oprogram,
  { {0x73087139,0xe27e901a,0x22d9001a,0x00000000}},	//   _trebalo_, _abana_, _kubera_,
  { {0x6e68c0fb,0x327ee092,0x6d30c01d,0x00000000}},	//   _adiciona, _foinse_, _clasific,
  { {0x34e34041,0x52d8c0dd,0x225ae0cc,0x00000000}},	//   _ইকবাল_, _widen_, _drilon_,
  { {0x12da7038,0xf97e2037,0x998170b2,0x00000000}},	//   _escolar_, _групы_, _equipame,
  { {0xd3ead06c,0xa2ca7054,0x72d8c060,0x00000000}},	//   _montre_, _monde_, _andet_,
  { {0x9db4309e,0x018930ce,0xa22a805c,0x00000000}},	// [370] _موضوع_, _مقاطع_, _niemand_,
  { {0x113bb0d5,0x7154106e,0x2a0c1029,0x00000000}},	//   _אלזוז_, _בניגוד_, _בפירוש_,
  { {0xa2d8f0d6,0x82d7d041,0xb200f118,0x00000000}},	//   _ingen_, _দিনকাল, _ingin_,
  { {0x02918036,0xb4a820d1,0xe2b4701e,0x00000000}},	//   _beraz_, _opcional_, _kunci_,
  { {0x22d87020,0x3c528036,0x7e3d3041,0x00000000}},	//   _linea_, _kontuan_, _সাতটি_,
  { {0x43947043,0xf248f0a9,0x72c62024,0x00000000}},	//   _munsi_, _trimis_, _експерти,
  { {0x63874017,0x22903059,0x325a0076,0x00000000}},	//   _hverju_, _kamati_, _utile_,
  { {0x22918101,0xccd1d088,0x53ead007,0x00000000}},	//   _teraz_, _особено_, _rootsi_,
  { {0xae37b036,0xec1f5055,0xadd7304a,0x00000000}},	//   _bidalita, _perandor, _صفحتك_,
  { {0xe27ee092,0x227f4051,0x73ea70b1,0x00000000}},	//   _pointe_, _dienen_, _fonte_,
  { {0x72ca7033,0xb08a10a6,0xd622009b,0x00000000}},	//   _kendi_, _навигаци, _otvoreni,
  { {0x53f4703f,0x22d8f04f,0xa04dc05f,0x00000000}},	//   _kosten_, _angen_, _врати_,
  { {0xe200c0aa,0xab7bf010,0xec7d701c,0x00000000}},	//   _indir_, _pangalan_, _muusika_,
  { {0x32b490c5,0xb3ebf030,0x43eb8055,0x00000000}},	//   _praca_, _cauta_, _larta_,
  { {0xf26d8073,0xe224d001,0x33ead031,0x00000000}},	//   _strom_, _nieko_, _contre_,
  { {0xc25ac04e,0x427bc0da,0x73097047,0x00000000}},	//   _mellem_, _objednáv, _aplikacj,
  { {0x563290d2,0x9197c035,0x52fab064,0x00000000}},	// [380] _можуть_, _такође_, _učinit_,
  { {0x22e3b032,0x028a806f,0xf9b05055,0x00000000}},	//   _देखील_, _ग्लोबल, _menjëher,
  { {0xfd70e141,0x57e54056,0x7fd52047,0x00000000}},	//   _perminta, _актуальн, _materiał,
  { {0x22b4e142,0xe27f7067,0xc28e5073,0x00000000}},	//   _muncul_, _tegnap_, _technet_,
  { {0x93eb000f,0x4942700d,0x5aeed03e,0x00000000}},	//   _states_, _sellaise, _victorie,
  { {0x52d8c0ba,0x556f406b,0xda063009,0x00000000}},	//   _ander_, _सातत्य, _رکھيے_,
  { {0x627e900c,0x62d8c0c5,0x6bf2b0fd,0x00000000}},	//   _chans_, _wideo_, _индивиду,
  { {0x03eb901d,0x22d5a0ff,0xe2a07001,0x00000000}},	//   _hasta_, _millət_, _klubas_,
  { {0x2cb8f0ac,0x5d1e201a,0xd369c0a1,0x00000000}},	//   _запомніц, _genocide_, _tenglar_,
  { {0x12cac015,0x1386d0b3,0xdf10c027,0x00000000}},	//   _bilden_, _storio_, _predsedn,
  { {0xa7544143,0x397f0033,0xef2ed030,0x00000000}},	//   _política_, _makinele, _pictoria,
  { {0xfa0ba04f,0x4394912c,0x92920144,0x00000000}},	//   _asiantae, _biasa_, _porady_,
  { {0x83737031,0x3476f0af,0x7ed6c06f,0x00000000}},	//   _demande_, _textilen_, _निपटने,
  { {0x03960094,0x7b03500d,0x92d250c5,0x00000000}},	//   _passar_, _prosentt, _wczoraj_,
  { {0xdd6f209e,0x526cf04f,0x151d3059,0x00000000}},	//   _احوال_, _digon_, _kuboresh,
  { {0xb3e550ff,0x42d8f03a,0x0ecbb11b,0x00000000}},	//   _hətta_, _eigen_, _launchin,
  { {0xfc90e064,0x134c709a,0x32c89054,0x00000000}},	// [390] _telefonu_, _juvenil_, _octobre_,
  { {0xce89c04a,0xfe00f092,0xd63be041,0x00000000}},	//   _الأكاديم, _fhreasta, _করণীয়,
  { {0x2236a08f,0x8197c035,0xfb84504d,0x00000000}},	//   _благодар, _законе_, _transpor,
  { {0x2a971041,0x08645090,0x02d980df,0x00000000}},	//   _সপ্তাহ, _универзи, _euren_,
  { {0x00f1104a,0x01c9208d,0xf3957012,0x00000000}},	//   _الطعام_, _росту_, _trasua_,
  { {0x63ea9015,0x72da4012,0x5533c08d,0x00000000}},	//   _plats_, _fullbox_, _погляд_,
  { {0x42249035,0x62caf016,0xc3cef0d6,0x00000000}},	//   _ovako_, _mundur_, _blivit_,
  { {0x13ea5076,0xfd8100bb,0x698d3001,0x00000000}},	//   _molti_, _realizua, _įgyvendi,
  { {0xf3954020,0x238660d6,0x02d8f015,0x00000000}},	//   _questa_, _stora_, _inget_,
  { {0x28c35056,0x3ee9d0b0,0xc2907021,0x00000000}},	//   _генераль, _funktion, _vanaf_,
  { {0xb2d9f03b,0x6202500a,0x3ea53002,0x00000000}},	//   _ettei_, _attiva_, _unidades_,
  { {0xa2d84047,0x13954076,0xdaf56026,0x00000000}},	//   _numer_, _queste_, _euroopan_,
  { {0x004dc088,0x35add065,0x92d9f064,0x00000000}},	//   _прати_, _работата_, _muzeum_,
  { {0xbf50c0ab,0x5498f067,0xd75d6032,0x00000000}},	//   _знали_, _lászló_, _गुप्तच,
  { {0x32cad094,0xc3eb9038,0x7c5c1054,0x00000000}},	//   _bilder_, _resta_, _gestion_,
  { {0x73ce8033,0xe386a101,0xa952005c,0x00000000}},	//   _takvim_, _dobre_, _publisee,
  { {0xa3eb90a7,0x72ef9027,0x62366095,0x00000000}},	// [3a0] _pesta_, _kuhinja_, _spoji_,
  { {0xbf492091,0x5c75506b,0x03f820ed,0x00000000}},	//   _kompleta, _विक्री, _cukup_,
  { {0xc3a24031,0xf20800d8,0x8cab90a1,0x00000000}},	//   _temps_, _informác, _miðvikud,
  { {0x52e650c6,0x094db051,0x8e6b0095,0x00000000}},	//   _svenska_, _formulie, _počela_,
  { {0x51778051,0x08fdd041,0xf4537009,0x00000000}},	//   _behandel, _ফলাফল_, _مینڈیٹ_,
  { {0x0eb620bd,0x4601104a,0x103fc01b,0x00000000}},	//   _систем_, _بنفسك_, _sistemin,
  { {0xc39670b1,0x23eb900e,0x43f4d09c,0x00000000}},	//   _cursos_, _rasti_, _lõuna_,
  { {0x027e5099,0xe25a600b,0x1ac3f041,0x00000000}},	//   _volna_, _kooli_, _আলোয়_,
  { {0x0807a041,0x3b8de00a,0xd0270009,0x00000000}},	//   _বুধবার, _fornitur, _باغیوں_,
  { {0xa3ea6059,0x82249035,0xffedd088,0x00000000}},	//   _mtoto_, _svako_, _издание_,
  { {0x73538047,0xb3ebf0b8,0x5be9a04a,0x00000000}},	//   _produkcj, _leute_, _جرينتش_,
  { {0xd290111d,0xb20180a9,0xf387e0a9,0x00000000}},	//   _bahan_, _scris_, _catre_,
  { {0xd2fc9060,0xac60509b,0x0286e053,0x00000000}},	//   _fragt_, _augusta_, _paradigm,
  { {0xc62a1088,0x2e387033,0x81ad304a,0x00000000}},	//   _организи, _galatasa, _البطن_,
  { {0xc33d30b7,0x174c304a,0xf4d7204a,0x00000000}},	//   _ایشان_, _العفو_, _برمجة_,
  { {0x72cae086,0xb2002138,0x37d0c035,0x00000000}},	//   _vinden_, _makin_, _многи_,
  { {0x426e605e,0xa200201b,0x7b6210b5,0x00000000}},	// [3b0] _parole_, _lakin_, _publicer,
  { {0x22fc7094,0x2b5bf04e,0x5224b016,0x00000000}},	//   _lange_, _andersen_, _dicka_,
  { {0x525bf0fb,0xb68cc06f,0x62e5e0df,0x00000000}},	//   _paulo_, _बौछार_, _gainera_,
  { {0x22a770e8,0x629180c5,0x8838f065,0x00000000}},	//   _viable_, _coraz_, _проектир,
  { {0x43019115,0x5200200d,0x6ef7e041,0x00000000}},	//   _trebuie_, _takia_, _সাইফুর,
  { {0xb9403009,0x0278606b,0x41b36041,0x00000000}},	//   _اپريل_, _umuntu_, _রাখেন_,
  { {0x7245810d,0x4fc7c09d,0x72494045,0x00000000}},	//   _rámci_, _дизайн_, _premio_,
  { {0x9f25b0b1,0x17a2008b,0xef32301a,0x00000000}},	//   _qualquer_, _interesg, _amafaran,
  { {0x286d7050,0xed9d80a4,0x49c510dd,0x00000000}},	//   _personas_, _recenzje_, _intestat,
  { {0xdeb780b4,0x72ad109e,0x2f6b2002,0x00000000}},	//   _presente_, _کلمات_, _horarios_,
  { {0xdc72c001,0xd38690e7,0x92a780e8,0x00000000}},	//   _sportas_, _utara_, _verbo_,
  { {0x63eb9057,0x829270a1,0x23f460e3,0x00000000}},	//   _nesto_, _gerast_, _mouton_,
  { {0x226e603e,0x2280b0e3,0xb2009030,0x00000000}},	//   _parola_, _diskite_, _trait_,
  { {0x16840029,0x6e395054,0x373e0008,0x00000000}},	//   _אנפאנג_, _localisa, _подготов,
  { {0x42c7b0b1,0x63877092,0x5b3a20db,0x00000000}},	//   _vídeo_, _bearta_, _برخلاف_,
  { {0x317e0008,0x73877092,0x5fd860ff,0x00000000}},	//   _положени, _cearta_, _keçən_,
  { {0x0b04f00d,0x74102041,0x67cf1015,0x00000000}},	// [3c0] _viestist, _ফারহান, _dessutom_,
  { {0x520160a2,0xc2ee006e,0xa33a1088,0x00000000}},	//   _kugira_, _נונסנס_, _провинци,
  { {0xac290072,0xf3ea707c,0xd380601a,0x00000000}},	//   _пропозиц, _conta_, _uburyo_,
  { {0xe987006b,0xd25b9071,0x4c61b01a,0x00000000}},	//   _देशमुख, _geslo_, _akarere_,
  { {0x2248c075,0xd9bf402c,0xe07a405f,0x00000000}},	//   _kommer_, _fundarge, _временск,
  { {0x7248d06a,0x84929029,0xf2bd606f,0x00000000}},	//   _prema_, _אינגאנצן_, _पुरुष_,
  { {0x6312104d,0x43ea6017,0x0493e0d2,0x00000000}},	//   _members_, _flott_, _стратегі,
  { {0xb4e80029,0xe2026007,0x28dc401a,0x00000000}},	//   _טערמין_, _aprill_, _umuryang,
  { {0x52027068,0x628cd04a,0xa3f8a0d3,0x00000000}},	//   _sosial_, _كلامك_, _gedung_,
  { {0xb290c054,0x430f3083,0x62b55015,0x00000000}},	//   _jamais_, _roditelj, _precis_,
  { {0x3386d028,0xb909207e,0x0386c00b,0x00000000}},	//   _sporta_, _вечара_, _noored_,
  { {0x94be106e,0xc2cb1097,0x362770c5,0x00000000}},	//   _רופאים_, _mozda_, _autorski,
  { {0xf1772088,0xf2c87058,0xf65bf009,0x00000000}},	//   _вести_, _animaux_, _تنخواہ_,
  { {0x82910010,0x33959094,0x3267e035,0x00000000}},	//   _sabado_, _disse_, _мислиш_,
  { {0x1071801b,0xa2b66031,0xe8c35037,0x00000000}},	//   _ibrahimo, _marche_, _нелегаль,
  { {0xd7fcc0d2,0xe38ce037,0xd00b3041,0x00000000}},	//   _блоги_, _музея_, _চাঁপাই,
  { {0x531780c9,0xe795607c,0x43eb8094,0x00000000}},	// [3d0] _verze_, _históric, _verte_,
  { {0x52da5107,0x4ea2f0ae,0xd27e9012,0x00000000}},	//   _hotell_, _parlemen, _ebank_,
  { {0x327f7076,0xb2565042,0x32c38014,0x00000000}},	//   _quanto_, _निवेदन, _ukoliko_,
  { {0x23940092,0x70f3a06b,0x80a0704a,0x00000000}},	//   _naisc_, _भागवत_, _القيام_,
  { {0x71a72003,0x12002010,0x92904044,0x00000000}},	//   _ہڑتال_, _sakin_, _laman_,
  { {0x87a05029,0xd6015034,0xe2015007,0x00000000}},	//   _התעוררות_, _commerci, _logima_,
  { {0x72904083,0x32cb8081,0x26953092,0x00000000}},	//   _odmah_, _yerde_, _fhreagai,
  { {0x23d05076,0xe473c036,0xd2da602d,0x00000000}},	//   _perchè_, _lehendak, _reports_,
  { {0x63869079,0x67a820a9,0x32b4c126,0x00000000}},	//   _ceart_, _februari, _calcio_,
  { {0x42ca7020,0x93fac048,0x43960094,0x00000000}},	//   _mondo_, _вторник_, _passer_,
  { {0x7cd23041,0x658ed01b,0x8c74806b,0x00000000}},	//   _ভাইকে_, _akademiy, _एवढ्या,
  { {0xfff3e027,0xaea7a065,0xeae0504c,0x00000000}},	//   _nepremič, _интереси_, _sundheds,
  { {0x03eb90de,0x0387f070,0x927f40b2,0x00000000}},	//   _beste_, _astro_, _evento_,
  { {0x3a524003,0x13ebe033,0x0394701b,0x00000000}},	//   _مصنوعات_, _hatta_, _minsk_,
  { {0xd2004010,0xc2d8402e,0xdc75206b,0x00000000}},	//   _namin_, _namen_, _सिग्नल,
  { {0x63ea710b,0x0208007c,0xf2a69066,0x00000000}},	//   _konto_, _informát, _klabu_,
  { {0x2ce6506b,0x027eb125,0x43eb70b9,0x00000000}},	// [3e0] _फोटोगॅ, _jednom_, _cuatro_,
  { {0xd29180b9,0x06e8b08f,0x62d80015,0x00000000}},	//   _otras_, _гарантир, _asien_,
  { {0x4404b0af,0x1a5b70af,0x11983035,0x00000000}},	//   _nhuộm_, _nghành_, _потребна_,
  { {0x03420033,0x6c2be0ab,0xf200a0ad,0x00000000}},	//   _gereken_, _ставили_, _ambil_,
  { {0xf201f0bf,0x00c9504a,0x6386602d,0x00000000}},	//   _jezika_, _وبعدها_, _store_,
  { {0x402e102d,0xaa3c706b,0x85a0c041,0x00000000}},	//   _conditio, _बहुजन_, _পাবলিক,
  { {0x22da70b5,0xf224e145,0x1f5d10ff,0x00000000}},	//   _adress_, _bankas_, _kitabxan,
  { {0x51e7306f,0xe2d8c027,0x321c906b,0x00000000}},	//   _आखिरी_, _izleti_, _सोहळा_,
  { {0x1e47a146,0xc3e44025,0x7fc43048,0x00000000}},	//   _העלפן_, _diplomsk, _клетки_,
  { {0x73869079,0x419580be,0x8200d08b,0x00000000}},	//   _fearr_, _rezultāt, _ideia_,
  { {0x03eb9031,0x4236d083,0x852d613d,0x00000000}},	//   _reste_, _svojoj_, _completo_,
  { {0x0f783085,0xcff7906e,0x630ed01d,0x00000000}},	//   _текста_, _בעתיד_, _tambien_,
  { {0x33a3f02c,0xe3eb9030,0xf2fcd036,0x00000000}},	//   _kaupa_, _peste_, _blogak_,
  { {0xc1b1c041,0x32005055,0x69c32002,0x00000000}},	//   _আপডেট_, _dalin_, _desempre,
  { {0xb27f502d,0x238690cf,0xf151906e,0x00000000}},	//   _events_, _klart_, _בכפוף_,
  { {0x02fd7092,0x825a004d,0x72d57038,0x00000000}},	//   _leagan_, _still_, _europea_,
  { {0x5e10c003,0x72904102,0x0b765002,0x00000000}},	// [3f0] _مضمون_, _zaman_, _publicac,
  { {0x13875047,0x956db002,0x28b6d0b7,0x00000000}},	//   _oferty_, _formació, _شرايط_,
  { {0x1855d061,0xceace035,0xa754f02a,0x00000000}},	//   _március_, _користит, _orgánica_,
  { {0xa6dea0ff,0x32fcd0c0,0xfcacc088,0x00000000}},	//   _məsuliyy, _blogas_, _оглед_,
  { {0x326c510a,0x16e6001b,0xc3a2c0e7,0x00000000}},	//   _calon_, _kampaniy, _kampus_,
  { {0x665e1048,0x27b6105c,0xec5be091,0x00000000}},	//   _фирма_, _aparthei, _partiti_,
  { {0x11cc3055,0xd4026015,0x827e9075,0x00000000}},	//   _policisë_, _rubriken_, _blant_,
  { {0xc2240028,0xf29040a9,0x423f906e,0x00000000}},	//   _laika_, _raman_, _במשקל_,
  { {0xf2d940c2,0x02904094,0x72c66016,0x00000000}},	//   _videot_, _saman_, _publike_,
  { {0xde392061,0x8a04c00a,0x43b9a147,0x00000000}},	//   _tapaszta, _dibattit, _serveru_,
  { {0xd097e0c8,0xd343606b,0xa2926062,0x00000000}},	//   _времена_, _हेमंत_, _paraan_,
  { {0xb2fc700b,0x49f22096,0x82d96015,0x00000000}},	//   _mingi_, _форума_, _dagens_,
  { {0xc182e06b,0xc2002044,0x227ef01a,0x00000000}},	//   _अव्वल_, _fikir_, _ibindi_,
  { {0xe27f7032,0xf30a5083,0x8f891088,0x00000000}},	//   _rwanda_, _najnovij, _детали_,
  { {0x191f307f,0x0212006b,0x52480013,0x00000000}},	//   _aistriúc, _igihe_, _daima_,
  { {0x69bce0fa,0xbe35f104,0x92d9e09a,0x00000000}},	//   _коментир, _quelques_, _actes_,

  };
  // table_hash = eb4c-72a5, unused_entries = 1027 (25.07%)

static const uint32 kDeltaOctaChromeInd[328] = {
  // [0000]
  0x00000000, 0x00001642, 0x00002042, 0x00003342,   //  lt......_C00 gl......_C00 ur......_C00
  0x00000c0f, 0x00000306, 0x12004508, 0x0000192d,   // pl......_600 nl......_400 sk.cs..._430 et......_A00
  0x00000e42, 0x0000331c, 0x00004242, 0x00001942,   // ru......_C00 ur......_800 mt......_C00 et......_C00
  0x00008c42, 0x00000442, 0x0000161c, 0x0000012d,   // ht......_C00 fi......_C00 lt......_800 en......_A00
  // [0010]
  0x00002142, 0x00004206, 0x00004342, 0x00003f1c,   // tl......_C00 mt......_400 vi......_C00 sw......_800
  0x1e001d23, 0x00001042, 0x00002e2d, 0x0000141c,   // hr.sr..._880 sv......_C00 sq......_A00 is......_800
  0x0000230f, 0x0000221c, 0x00001a42, 0x00004b42,   // uk......_600 tr......_800 xxx......_C00 az......_C00
  0x0000191c, 0x00000f42, 0x27002908, 0x27002934,   // et......_800 es......_C00 ms.id..._430 ms.id..._A80
  // [0020]
  0x00000842, 0x0000031c, 0x00000e2d, 0x00002e0f,   // it......_C00 nl......_800 ru......_A00 sq......_600
  0x00002342, 0x0000402d, 0x0000042d, 0x00004042,   // uk......_C00 sl......_A00 fi......_A00 sl......_C00
  0x00001542, 0x00005c1c, 0x00002006, 0x00000206,   // lv......_C00 yi......_800 gl......_400 da......_400
  0x0000142d, 0x0000011c, 0x0000062d, 0x0000251c,   // is......_A00 en......_800 de......_A00 mk......_800
  // [0030]
  0x0000172d, 0x0000052d, 0x00001a06, 0x00002242,   // ro......_A00 fr......_A00 xxx......_400 tr......_C00
  0x0000010f, 0x00001e42, 0x00003a42, 0x0000301c,   // en......_600 sr......_C00 eu......_C00 be......_800
  0x00003842, 0x00000c1c, 0x00000b42, 0x0000041c,   // ca......_C00 pl......_800 no......_C00 fi......_800
  0x00001506, 0x00003a0f, 0x0000171c, 0x0000032d,   // lv......_400 eu......_600 ro......_800 nl......_A00
  // [0040]
  0x0000662d, 0x0000261c, 0x00001a01, 0x00001a2d,   // af......_A00 bn......_800 xxx......_200 xxx......_A00
  0x00002942, 0x0000081c, 0x00002b2d, 0x00000c2d,   // ms......_C00 it......_800 cy......_A00 pl......_A00
  0x00001c06, 0x0000272d, 0x0000371c, 0x0000061c,   // bg......_400 id......_A00 ar......_800 de......_800
  0x0000020f, 0x00000142, 0x0000022d, 0x00002b42,   // da......_600 en......_C00 da......_A00 cy......_C00
  // [0050]
  0x00000f2d, 0x00000342, 0x0000021c, 0x0000202d,   // es......_A00 nl......_C00 da......_800 gl......_A00
  0x00000542, 0x00002e42, 0x0000231c, 0x1d001e4d,   // fr......_C00 sq......_C00 uk......_800 sr.hr..._CC0
  0x00000506, 0x00003f42, 0x0000381c, 0x0000300f,   // fr......_400 sw......_C00 ca......_800 be......_600
  0x00006642, 0x00000f06, 0x0000150f, 0x0000252d,   // af......_C00 es......_400 lv......_600 mk......_A00
  // [0060]
  0x00000242, 0x00001842, 0x0000212d, 0x00001206,   // da......_C00 hu......_C00 tl......_A00 cs......_400
  0x0000121c, 0x00001c1c, 0x00003f2d, 0x00001806,   // cs......_800 bg......_800 sw......_A00 hu......_400
  0x00004b1c, 0x27002935, 0x1e001d35, 0x00001a1c,   // az......_800 ms.id..._A90 hr.sr..._A90 xxx......_800
  0x00008c2d, 0x1e001d34, 0x0000071c, 0x0000241c,   // ht......_A00 hr.sr..._A80 iw......_800 hi......_800
  // [0070]
  0x0000291c, 0x0000401c, 0x00002306, 0x00001242,   // ms......_800 sl......_800 uk......_400 cs......_C00
  0x0000180f, 0x00000b2d, 0x0000082d, 0x0000431c,   // hu......_600 no......_A00 it......_A00 vi......_800
  0x1e001d08, 0x00001f2d, 0x1200454b, 0x21008c4d,   // hr.sr..._430 ga......_A00 sk.cs..._CA0 ht.tl..._CC0
  0x00000d2d, 0x45001236, 0x00003006, 0x00001f1c,   // pt......_A00 cs.sk..._AA0 be......_400 ga......_800
  // [0080]
  0x0000181c, 0x00002206, 0x00003f0f, 0x1e001d4d,   // hu......_800 tr......_400 sw......_600 hr.sr..._CC0
  0x0000151c, 0x00001e0f, 0x0000030f, 0x29002734,   // lv......_800 sr......_600 nl......_600 id.ms..._A80
  0x00002542, 0x00002e06, 0x29002712, 0x00003a2d,   // mk......_C00 sq......_400 id.ms..._640 eu......_A00
  0x00004b0f, 0x00003042, 0x00002406, 0x00001c42,   // az......_600 be......_C00 hi......_400 bg......_C00
  // [0090]
  0x00001e2d, 0x0000421c, 0x00001f42, 0x1e001d22,   // sr......_A00 mt......_800 ga......_C00 hr.sr..._870
  0x00000b1c, 0x00001d42, 0x00000e06, 0x1d001e08,   // no......_800 hr......_C00 ru......_400 sr.hr..._430
  0x00004b2d, 0x0000182d, 0x0000382d, 0x00004542,   // az......_A00 hu......_A00 ca......_A00 sk......_C00
  0x00001906, 0x00000e1c, 0x00004e42, 0x45001208,   // et......_400 ru......_800 fa......_C00 cs.sk..._430
  // [00a0]
  0x0e001c10, 0x00001442, 0x00001a0f, 0x0000210f,   // bg.ru..._620 is......_C00 xxx......_600 tl......_600
  0x00000c06, 0x0000262d, 0x00001c2d, 0x00002742,   // pl......_400 bn......_A00 bg......_A00 id......_C00
  0x00004e2d, 0x00001742, 0x0000222d, 0x00001e06,   // fa......_A00 ro......_C00 tr......_A00 sr......_400
  0x0000302d, 0x27002933, 0x0000271c, 0x0000430f,   // be......_A00 ms.id..._A70 id......_800 vi......_600
  // [00b0]
  0x00000642, 0x00000d42, 0x00000d1c, 0x00002b1c,   // de......_C00 pt......_C00 pt......_800 cy......_800
  0x0000080f, 0x0000101c, 0x45001210, 0x00004e1c,   // it......_600 sv......_800 cs.sk..._620 fa......_800
  0x00000606, 0x00000f1c, 0x0000661c, 0x00002e1c,   // de......_400 es......_800 af......_800 sq......_800
  0x0f000d10, 0x00002506, 0x0000152d, 0x1d001e13,   // pt.es..._620 mk......_400 lv......_A00 sr.hr..._650
  // [00c0]
  0x0000162d, 0x0000200f, 0x00000406, 0x00002706,   // lt......_A00 gl......_600 fi......_400 id......_400
  0x0000060f, 0x00000c42, 0x00000b06, 0x00000b01,   // de......_600 pl......_C00 no......_400 no......_200
  0x00001e1c, 0x0000122d, 0x00003a06, 0x1d001e4b,   // sr......_800 cs......_A00 eu......_400 sr.hr..._CA0
  0x0000211c, 0x0000250f, 0x00003706, 0x0000100f,   // tl......_800 mk......_600 ar......_400 sv......_600
  // [00d0]
  0x0000400f, 0x0000380f, 0x0000232d, 0x29002713,   // sl......_600 ca......_600 uk......_A00 id.ms..._650
  0x0000432d, 0x00005c06, 0x0000102d, 0x00005c0f,   // vi......_A00 yi......_400 sv......_A00 yi......_600
  0x0000452d, 0x00003f06, 0x1200454d, 0x00004e06,   // sk......_A00 sw......_400 sk.cs..._CC0 fa......_400
  0x27002910, 0x0000422d, 0x00000b0f, 0x00003a1c,   // ms.id..._620 mt......_A00 no......_600 eu......_800
  // [00e0]
  0x0000332d, 0x00008c01, 0x00004506, 0x00008c1c,   // ur......_A00 ht......_200 sk......_400 ht......_800
  0x00000106, 0x12004513, 0x00006606, 0x29002735,   // en......_400 sk.cs..._650 af......_400 id.ms..._A90
  0x0000201c, 0x00000706, 0x0000292d, 0x00002106,   // gl......_800 iw......_400 ms......_A00 tl......_400
  0x1d001e35, 0x29002707, 0x4500124c, 0x00001606,   // sr.hr..._A90 id.ms..._420 cs.sk..._CB0 lt......_400
  // [00f0]
  0x00004006, 0x29002708, 0x45001222, 0x2900274c,   // sl......_400 id.ms..._430 cs.sk..._870 id.ms..._CB0
  0x00000e01, 0x0000170f, 0x00002906, 0x2700294a,   // ru......_200 ro......_600 ms......_400 ms.id..._C90
  0x00002606, 0x00003742, 0x00001c0f, 0x00000d06,   // bn......_400 ar......_C00 bg......_600 pt......_400
  0x00004e0f, 0x00000e0f, 0x00003806, 0x00004b06,   // fa......_600 ru......_600 ca......_400 az......_400
  // [0100]
  0x0000160f, 0x0000450f, 0x0000290f, 0x0000420f,   // lt......_600 sk......_600 ms......_600 mt......_600
  0x0000051c, 0x1e001d20, 0x27002907, 0x00001006,   // fr......_800 hr.sr..._850 ms.id..._420 sv......_400
  0x00001f06, 0x00002b06, 0x29002722, 0x0000451c,   // ga......_400 cy......_400 id.ms..._870 sk......_800
  0x1e001d13, 0x45001207, 0x00004e01, 0x0000242d,   // hr.sr..._650 cs.sk..._420 fa......_200 hi......_A00
  // [0110]
  0x0000140f, 0x27002921, 0x1e001c10, 0x0000040f,   // is......_600 ms.id..._860 bg.sr..._620 fi......_600
  0x45001211, 0x00001706, 0x12004522, 0x1d001e4c,   // cs.sk..._630 ro......_400 sk.cs..._870 sr.hr..._CB0
  0x27002922, 0x0000370f, 0x1e001d12, 0x2900274d,   // ms.id..._870 ar......_600 hr.sr..._640 id.ms..._CC0
  0x0000660f, 0x29002720, 0x00003306, 0x00001406,   // af......_600 id.ms..._850 ur......_400 is......_400
  // [0120]
  0x1d001e02, 0x00005c01, 0x1a003f07, 0x45001235,   // sr.hr..._220 yi......_200 sw.xxx..._420 cs.sk..._A90
  0x00001d1c, 0x45001232, 0x00000806, 0x1c002510,   // hr......_800 cs.sk..._A60 it......_400 mk.bg..._620
  0x0000270f, 0x1200454c, 0x12004534, 0x1d001e49,   // id......_600 sk.cs..._CB0 sk.cs..._A80 sr.hr..._C80
  0x27002913, 0x29001a49, 0x1e001d14, 0x45001234,   // ms.id..._650 xxx.ms..._C80 hr.sr..._660 cs.sk..._A80
  // [0130]
  0x29002733, 0x00008c06, 0x0000120f, 0x2700294b,   // id.ms..._A70 ht......_400 cs......_600 ms.id..._CA0
  0x1d001e4a, 0x00008c0f, 0x0000220f, 0x00001f01,   // sr.hr..._C90 ht......_600 tr......_600 ga......_200
  0x2700294d, 0x1d001e22, 0x1e001d36, 0x12004523,   // ms.id..._CC0 sr.hr..._870 hr.sr..._AA0 sk.cs..._880
  0x25001e10, 0x00000f0f, 0x22004b11, 0x1e001d4a,   // sr.mk..._620 es......_600 az.tr..._630 hr.sr..._C90
  // [0140]
  0x12004535, 0x29002732, 0x27002923, 0x0f003810,   // sk.cs..._A90 id.ms..._A60 ms.id..._880 ca.es..._620
  0x22000c4d, 0x00001501, 0x00005c2d, 0x45001220,   // pl.tr..._CC0 lv......_200 yi......_A00 cs.sk..._850
                                                    //
  };

COMPILE_ASSERT(328 < (1 << 12), k_indirectbits_too_small);

extern const cld::CLDTableSummary kLongWord8Table_obj = {
  kDeltaOctaChrome,
  kDeltaOctaChromeInd,
  kDeltaOctaChromeSize,
  arraysize(kDeltaOctaChromeInd),
  kDeltaOctaChromeKeyMask,
  kDeltaOctaChromeBuildDate,
};

// End of generated tables
