/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.AffineBicubic2OpImage;
import com.sun.media.jai.opimage.AffineBicubicOpImage;
import com.sun.media.jai.opimage.AffineBilinearOpImage;
import com.sun.media.jai.opimage.AffineGeneralOpImage;
import com.sun.media.jai.opimage.AffineNearestBinaryOpImage;
import com.sun.media.jai.opimage.AffineNearestOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.EnumeratedParameter;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.operator.ShearDescriptor;

public class ShearRIF
implements RenderedImageFactory {
    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        BorderExtender borderExtender = RIFUtil.getBorderExtenderHint(renderingHints);
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        float f = parameterBlock.getFloatParameter(0);
        EnumeratedParameter enumeratedParameter = (EnumeratedParameter)parameterBlock.getObjectParameter(1);
        float f2 = parameterBlock.getFloatParameter(2);
        float f3 = parameterBlock.getFloatParameter(3);
        Object object = parameterBlock.getObjectParameter(4);
        Interpolation interpolation = (Interpolation)object;
        double[] dArray = (double[])parameterBlock.getObjectParameter(5);
        AffineTransform affineTransform = new AffineTransform();
        if (enumeratedParameter.equals(ShearDescriptor.SHEAR_HORIZONTAL)) {
            affineTransform.setTransform(1.0, 0.0, f, 1.0, f2, 0.0);
        } else {
            affineTransform.setTransform(1.0, f, 0.0, 1.0, 0.0, f3);
        }
        if (interpolation instanceof InterpolationNearest) {
            boolean bl;
            SampleModel sampleModel = renderedImage.getSampleModel();
            boolean bl2 = bl = sampleModel instanceof MultiPixelPackedSampleModel && sampleModel.getSampleSize(0) == 1 && (sampleModel.getDataType() == 0 || sampleModel.getDataType() == 1 || sampleModel.getDataType() == 3);
            if (bl) {
                return new AffineNearestBinaryOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, affineTransform, interpolation, dArray);
            }
            return new AffineNearestOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, affineTransform, interpolation, dArray);
        }
        if (interpolation instanceof InterpolationBilinear) {
            return new AffineBilinearOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, affineTransform, interpolation, dArray);
        }
        if (interpolation instanceof InterpolationBicubic) {
            return new AffineBicubicOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, affineTransform, interpolation, dArray);
        }
        if (interpolation instanceof InterpolationBicubic2) {
            return new AffineBicubic2OpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, affineTransform, interpolation, dArray);
        }
        return new AffineGeneralOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, affineTransform, interpolation, dArray);
    }
}

