/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.GroupByColumn;
import org.apache.derby.impl.sql.compile.OrderedColumnList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;

public class GroupByList
extends OrderedColumnList {
    int numGroupingColsAdded = 0;

    public void addGroupByColumn(GroupByColumn groupByColumn) {
        this.addElement(groupByColumn);
    }

    public GroupByColumn getGroupByColumn(int n) {
        return (GroupByColumn)this.elementAt(n);
    }

    public void printSubNodes(int n) {
    }

    public int getNumNeedToAddGroupingCols() {
        return this.numGroupingColsAdded;
    }

    public void bindGroupByColumns(SelectNode selectNode, Vector vector) throws StandardException {
        int n;
        FromList fromList = selectNode.getFromList();
        ResultColumnList resultColumnList = selectNode.getResultColumns();
        SubqueryList subqueryList = (SubqueryList)this.getNodeFactory().getNode(11, this.getContextManager());
        int n2 = 0;
        int n3 = this.size();
        if (n3 > 32677) {
            throw StandardException.newException("54004");
        }
        for (n = 0; n < n3; ++n) {
            GroupByColumn groupByColumn = (GroupByColumn)this.elementAt(n);
            groupByColumn.bindExpression(fromList, subqueryList, vector);
        }
        this.verifyUniqueGroupingColumns();
        for (n = 0; n < n3; ++n) {
            boolean bl = false;
            GroupByColumn groupByColumn = (GroupByColumn)this.elementAt(n);
            String string = groupByColumn.getColumnName();
            int n4 = groupByColumn.getTableNumber();
            ResultColumn resultColumn = groupByColumn.getSource();
            int n5 = resultColumnList.size();
            for (int i = 0; i < n5; ++i) {
                ColumnReference columnReference;
                ResultColumn resultColumn2 = (ResultColumn)resultColumnList.elementAt(i);
                if (!(resultColumn2.getExpression() instanceof ColumnReference) || n4 != (columnReference = (ColumnReference)resultColumn2.getExpression()).getTableNumber() || resultColumn != columnReference.getSource()) continue;
                groupByColumn.setColumnPosition(i + 1);
                resultColumn2.markAsGroupingColumn();
                bl = true;
                break;
            }
            if (bl) continue;
            ResultColumn resultColumn3 = (ResultColumn)this.getNodeFactory().getNode(80, groupByColumn.getColumnName(), groupByColumn.getColumnReference().getClone(), this.getContextManager());
            resultColumn3.setVirtualColumnId(resultColumnList.size() + 1);
            resultColumn3.markGenerated();
            resultColumn3.markAsGroupingColumn();
            resultColumnList.addElement(resultColumn3);
            groupByColumn.setColumnPosition(resultColumnList.size());
            ++n2;
        }
        this.numGroupingColsAdded += n2;
    }

    public void verifyUniqueGroupingColumns() throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            GroupByColumn groupByColumn = (GroupByColumn)this.elementAt(i);
            int n2 = groupByColumn.getTableNumber();
            ResultColumn resultColumn = groupByColumn.getSource();
            String string = groupByColumn.getColumnName();
            String string2 = groupByColumn.getColumnName();
            for (int j = i + 1; j < n; ++j) {
                GroupByColumn groupByColumn2 = (GroupByColumn)this.elementAt(j);
                int n3 = groupByColumn2.getTableNumber();
                ResultColumn resultColumn2 = groupByColumn2.getSource();
                if (n2 != n3 || resultColumn != resultColumn2) continue;
                throw StandardException.newException("42Y19", string2);
            }
        }
    }

    public void addNewGroupingColumnsToRCL(SelectNode selectNode) throws StandardException {
        FromList fromList = selectNode.getFromList();
        int n = this.size();
        ResultColumnList resultColumnList = selectNode.getResultColumns();
        for (int i = 0; i < n; ++i) {
            GroupByColumn groupByColumn = (GroupByColumn)this.elementAt(i);
            if (groupByColumn.getColumnPosition() != -1) continue;
            VirtualColumnNode virtualColumnNode = (VirtualColumnNode)this.getNodeFactory().getNode(107, fromList.getFromTableByResultColumn(groupByColumn.getSource()), groupByColumn.getSource(), ReuseFactory.getInteger(resultColumnList.size() + 2), this.getContextManager());
            virtualColumnNode.setType(groupByColumn.getColumnReference().getTypeServices());
            ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, groupByColumn.getColumnName(), virtualColumnNode, this.getContextManager());
            resultColumn.setType(virtualColumnNode.getTypeServices());
            resultColumn.setVirtualColumnId(resultColumnList.size() + 2);
            resultColumnList.addElement(resultColumn);
            groupByColumn.setColumnPosition(resultColumnList.size());
        }
    }

    public GroupByColumn containsColumnReference(ColumnReference columnReference) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            GroupByColumn groupByColumn = (GroupByColumn)this.elementAt(i);
            if (groupByColumn.getSource() != columnReference.getSource() || groupByColumn.getTableNumber() != columnReference.getTableNumber()) continue;
            return groupByColumn;
        }
        return null;
    }

    public void remapColumnReferencesToExpressions() throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            GroupByColumn groupByColumn = (GroupByColumn)this.elementAt(i);
            ValueNode valueNode = groupByColumn.getColumnReference().remapColumnReferencesToExpressions();
            groupByColumn.setColumnReference((ColumnReference)valueNode);
        }
    }

    public String toString() {
        return "";
    }
}

