/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.quality;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.system.Semaphores;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.quality.AbstractCompleteness;
import org.apache.sis.metadata.iso.quality.AbstractLogicalConsistency;
import org.apache.sis.metadata.iso.quality.AbstractPositionalAccuracy;
import org.apache.sis.metadata.iso.quality.AbstractTemporalAccuracy;
import org.apache.sis.metadata.iso.quality.AbstractThematicAccuracy;
import org.apache.sis.metadata.iso.quality.DefaultUsability;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.quality.Completeness;
import org.opengis.metadata.quality.Element;
import org.opengis.metadata.quality.EvaluationMethodType;
import org.opengis.metadata.quality.LogicalConsistency;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.metadata.quality.Result;
import org.opengis.metadata.quality.TemporalAccuracy;
import org.opengis.metadata.quality.ThematicAccuracy;
import org.opengis.metadata.quality.Usability;
import org.opengis.util.InternationalString;

@XmlType(name="AbstractDQ_Element_Type", propOrder={"namesOfMeasure", "measureIdentification", "measureDescription", "evaluationMethodType", "evaluationMethodDescription", "evaluationProcedure", "dates", "results"})
@XmlRootElement(name="DQ_Element")
@XmlSeeAlso(value={AbstractCompleteness.class, AbstractLogicalConsistency.class, AbstractPositionalAccuracy.class, AbstractThematicAccuracy.class, AbstractTemporalAccuracy.class, DefaultUsability.class})
public class AbstractElement
extends ISOMetadata
implements Element {
    private static final long serialVersionUID = 3963454452767190970L;
    private Collection<InternationalString> namesOfMeasure;
    private Identifier measureIdentification;
    private InternationalString measureDescription;
    private EvaluationMethodType evaluationMethodType;
    private InternationalString evaluationMethodDescription;
    private Citation evaluationProcedure;
    private Dates dates;
    private Collection<Result> results;

    public AbstractElement() {
    }

    public AbstractElement(Result result) {
        this.results = this.singleton(result, Result.class);
    }

    public AbstractElement(Element element) {
        super(element);
        if (element != null) {
            this.namesOfMeasure = this.copyCollection(element.getNamesOfMeasure(), InternationalString.class);
            this.measureIdentification = element.getMeasureIdentification();
            this.measureDescription = element.getMeasureDescription();
            this.evaluationMethodType = element.getEvaluationMethodType();
            this.evaluationMethodDescription = element.getEvaluationMethodDescription();
            this.evaluationProcedure = element.getEvaluationProcedure();
            this.results = this.copyCollection(element.getResults(), Result.class);
            this.writeDates(element.getDates());
        }
    }

    public static AbstractElement castOrCopy(Element element) {
        if (element instanceof PositionalAccuracy) {
            return AbstractPositionalAccuracy.castOrCopy((PositionalAccuracy)element);
        }
        if (element instanceof TemporalAccuracy) {
            return AbstractTemporalAccuracy.castOrCopy((TemporalAccuracy)element);
        }
        if (element instanceof ThematicAccuracy) {
            return AbstractThematicAccuracy.castOrCopy((ThematicAccuracy)element);
        }
        if (element instanceof LogicalConsistency) {
            return AbstractLogicalConsistency.castOrCopy((LogicalConsistency)element);
        }
        if (element instanceof Completeness) {
            return AbstractCompleteness.castOrCopy((Completeness)element);
        }
        if (element instanceof Usability) {
            return DefaultUsability.castOrCopy((Usability)element);
        }
        if (element == null || element instanceof AbstractElement) {
            return (AbstractElement)element;
        }
        return new AbstractElement(element);
    }

    @XmlElement(name="nameOfMeasure")
    public Collection<InternationalString> getNamesOfMeasure() {
        this.namesOfMeasure = this.nonNullCollection(this.namesOfMeasure, InternationalString.class);
        return this.namesOfMeasure;
    }

    public void setNamesOfMeasure(Collection<? extends InternationalString> collection) {
        this.namesOfMeasure = this.writeCollection(collection, this.namesOfMeasure, InternationalString.class);
    }

    @Override
    @XmlElement(name="measureIdentification")
    public Identifier getMeasureIdentification() {
        return this.measureIdentification;
    }

    public void setMeasureIdentification(Identifier identifier) {
        this.checkWritePermission();
        this.measureIdentification = identifier;
    }

    @Override
    @XmlElement(name="measureDescription")
    public InternationalString getMeasureDescription() {
        return this.measureDescription;
    }

    public void setMeasureDescription(InternationalString internationalString) {
        this.checkWritePermission();
        this.measureDescription = internationalString;
    }

    @Override
    @XmlElement(name="evaluationMethodType")
    public EvaluationMethodType getEvaluationMethodType() {
        return this.evaluationMethodType;
    }

    public void setEvaluationMethodType(EvaluationMethodType evaluationMethodType) {
        this.checkWritePermission();
        this.evaluationMethodType = evaluationMethodType;
    }

    @Override
    @XmlElement(name="evaluationMethodDescription")
    public InternationalString getEvaluationMethodDescription() {
        return this.evaluationMethodDescription;
    }

    public void setEvaluationMethodDescription(InternationalString internationalString) {
        this.checkWritePermission();
        this.evaluationMethodDescription = internationalString;
    }

    @Override
    @XmlElement(name="evaluationProcedure")
    public Citation getEvaluationProcedure() {
        return this.evaluationProcedure;
    }

    public void setEvaluationProcedure(Citation citation) {
        this.checkWritePermission();
        this.evaluationProcedure = citation;
    }

    @XmlElement(name="dateTime")
    public Collection<Date> getDates() {
        if (Semaphores.query(1)) {
            return Containers.isNullOrEmpty(this.dates) ? null : this.dates;
        }
        if (this.dates == null) {
            this.dates = new Dates();
        }
        return this.dates;
    }

    public void setDates(Collection<? extends Date> collection) {
        this.checkWritePermission();
        if (collection != this.dates) {
            this.writeDates(collection);
        }
    }

    private void writeDates(Collection<? extends Date> collection) {
        if (Containers.isNullOrEmpty(collection)) {
            this.dates = null;
        } else {
            if (this.dates == null) {
                this.dates = new Dates();
            }
            this.dates.clear();
            this.dates.addAll(collection);
        }
    }

    @XmlElement(name="result", required=true)
    public Collection<Result> getResults() {
        this.results = this.nonNullCollection(this.results, Result.class);
        return this.results;
    }

    public void setResults(Collection<? extends Result> collection) {
        this.results = this.writeCollection(collection, this.results, Result.class);
    }

    private static final class Dates
    extends AbstractList<Date>
    implements CheckedContainer<Date>,
    Cloneable,
    Serializable {
        private static final long serialVersionUID = 1210175223467194009L;
        private long date1;
        private long date2;

        Dates() {
            this.clear();
        }

        @Override
        public Class<Date> getElementType() {
            return Date.class;
        }

        @Override
        public void clear() {
            this.date1 = Long.MIN_VALUE;
            this.date2 = Long.MIN_VALUE;
        }

        @Override
        public int size() {
            if (this.date2 != Long.MIN_VALUE) {
                return 2;
            }
            if (this.date1 != Long.MIN_VALUE) {
                return 1;
            }
            return 0;
        }

        @Override
        public Date get(int n) {
            long l = this.date1;
            switch (n) {
                case 1: {
                    l = this.date2;
                }
                case 0: {
                    if (l == Long.MIN_VALUE) break;
                    return new Date(l);
                }
            }
            throw new IndexOutOfBoundsException(Errors.format((short)71, n));
        }

        @Override
        public Date set(int n, Date date) {
            long l = date.getTime();
            Date date2 = this.get(n);
            switch (n) {
                case 0: {
                    this.date1 = l;
                    break;
                }
                case 1: {
                    this.date2 = l;
                }
            }
            ++this.modCount;
            return date2;
        }

        @Override
        public Date remove(int n) {
            Date date = this.get(n);
            switch (n) {
                case 0: {
                    this.date1 = this.date2;
                }
                case 1: {
                    this.date2 = Long.MIN_VALUE;
                }
            }
            ++this.modCount;
            return date;
        }

        @Override
        public void add(int n, Date date) {
            long l = date.getTime();
            if (this.date2 == Long.MIN_VALUE) {
                switch (n) {
                    case 0: {
                        this.date2 = this.date1;
                        this.date1 = l;
                        ++this.modCount;
                        return;
                    }
                    case 1: {
                        if (this.date1 == Long.MIN_VALUE) break;
                        this.date2 = l;
                        ++this.modCount;
                        return;
                    }
                }
            }
            throw new IndexOutOfBoundsException(Errors.format((short)71, n));
        }

        @Override
        public boolean addAll(Collection<? extends Date> collection) {
            int n = this.modCount++;
            if (collection != null) {
                Iterator<? extends Date> iterator = collection.iterator();
                switch (this.size()) {
                    case 0: {
                        if (!iterator.hasNext()) break;
                        this.date1 = iterator.next().getTime();
                    }
                    case 1: {
                        if (!iterator.hasNext()) break;
                        this.date2 = iterator.next().getTime();
                        ++this.modCount;
                    }
                    default: {
                        if (!iterator.hasNext()) break;
                        throw new IllegalArgumentException(Errors.format((short)35, "dates", 2, collection.size()));
                    }
                }
            }
            return this.modCount != n;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError((Object)cloneNotSupportedException);
            }
        }
    }
}

