/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.factory;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.IllegalClassException;
import org.apache.uima.UIMA_IllegalArgumentException;
import org.apache.uima.fit.factory.ExternalResourceFactory;
import org.apache.uima.fit.factory.ResourceCreationSpecifierFactory;
import org.apache.uima.fit.internal.ReflectionUtil;
import org.apache.uima.fit.internal.propertyeditors.PropertyEditorUtil;
import org.apache.uima.resource.ConfigurableDataResourceSpecifier;
import org.apache.uima.resource.CustomResourceSpecifier;
import org.apache.uima.resource.Parameter;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.impl.Parameter_impl;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.NameValuePair;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.resource.metadata.impl.ConfigurationParameter_impl;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.TypeMismatchException;

public final class ConfigurationParameterFactory {
    private static final Map<String, String> JAVA_UIMA_TYPE_MAP = new HashMap<String, String>();

    private ConfigurationParameterFactory() {
    }

    public static boolean isConfigurationParameterField(Field field) {
        return ReflectionUtil.isAnnotationPresent(field, org.apache.uima.fit.descriptor.ConfigurationParameter.class);
    }

    public static Object getDefaultValue(Field field) {
        if (ConfigurationParameterFactory.isConfigurationParameterField(field)) {
            org.apache.uima.fit.descriptor.ConfigurationParameter annotation = ReflectionUtil.getAnnotation(field, org.apache.uima.fit.descriptor.ConfigurationParameter.class);
            String[] stringValue = annotation.defaultValue();
            if (stringValue.length == 1 && stringValue[0].equals("org.apache.uima.fit.descriptor.ConfigurationParameter.NO_DEFAULT_VALUE")) {
                return null;
            }
            String valueType = ConfigurationParameterFactory.getConfigurationParameterType(field);
            boolean isMultiValued = ConfigurationParameterFactory.isMultiValued(field);
            if (!isMultiValued) {
                if ("Boolean".equals(valueType)) {
                    return Boolean.parseBoolean(stringValue[0]);
                }
                if ("Float".equals(valueType)) {
                    return Float.valueOf(Float.parseFloat(stringValue[0]));
                }
                if ("Integer".equals(valueType)) {
                    return Integer.parseInt(stringValue[0]);
                }
                if ("String".equals(valueType)) {
                    return stringValue[0];
                }
                throw new UIMA_IllegalArgumentException("metadata_attribute_type_mismatch", new Object[]{valueType, "type"});
            }
            if ("Boolean".equals(valueType)) {
                Boolean[] returnValues = new Boolean[stringValue.length];
                for (int i = 0; i < stringValue.length; ++i) {
                    returnValues[i] = Boolean.parseBoolean(stringValue[i]);
                }
                return returnValues;
            }
            if ("Float".equals(valueType)) {
                Float[] returnValues = new Float[stringValue.length];
                for (int i = 0; i < stringValue.length; ++i) {
                    returnValues[i] = Float.valueOf(Float.parseFloat(stringValue[i]));
                }
                return returnValues;
            }
            if ("Integer".equals(valueType)) {
                Integer[] returnValues = new Integer[stringValue.length];
                for (int i = 0; i < stringValue.length; ++i) {
                    returnValues[i] = Integer.parseInt(stringValue[i]);
                }
                return returnValues;
            }
            if ("String".equals(valueType)) {
                return stringValue;
            }
            throw new UIMA_IllegalArgumentException("metadata_attribute_type_mismatch", new Object[]{valueType, "type"});
        }
        throw new IllegalArgumentException("field is not annotated with annotation of type " + org.apache.uima.fit.descriptor.ConfigurationParameter.class.getName());
    }

    private static String getConfigurationParameterType(Field field) {
        String parameterClassName;
        Class<?> parameterClass = field.getType();
        if (parameterClass.isArray()) {
            parameterClassName = parameterClass.getComponentType().getName();
        } else if (Collection.class.isAssignableFrom(parameterClass)) {
            ParameterizedType collectionType = (ParameterizedType)field.getGenericType();
            parameterClassName = ((Class)collectionType.getActualTypeArguments()[0]).getName();
        } else {
            parameterClassName = parameterClass.getName();
        }
        String parameterType = JAVA_UIMA_TYPE_MAP.get(parameterClassName);
        if (parameterType == null) {
            return "String";
        }
        return parameterType;
    }

    private static boolean isMultiValued(Field field) {
        Class<?> parameterClass = field.getType();
        if (parameterClass.isArray()) {
            return true;
        }
        return Collection.class.isAssignableFrom(parameterClass);
    }

    public static String getConfigurationParameterName(Field field) {
        if (ConfigurationParameterFactory.isConfigurationParameterField(field)) {
            org.apache.uima.fit.descriptor.ConfigurationParameter annotation = ReflectionUtil.getAnnotation(field, org.apache.uima.fit.descriptor.ConfigurationParameter.class);
            String name = annotation.name();
            if (name.equals("org.apache.uima.fit.descriptor.ConfigurationParameter.USE_FIELD_NAME")) {
                name = field.getName();
            }
            return name;
        }
        return null;
    }

    public static ConfigurationParameter createPrimitiveParameter(Field field) {
        if (ConfigurationParameterFactory.isConfigurationParameterField(field)) {
            org.apache.uima.fit.descriptor.ConfigurationParameter annotation = ReflectionUtil.getAnnotation(field, org.apache.uima.fit.descriptor.ConfigurationParameter.class);
            String name = ConfigurationParameterFactory.getConfigurationParameterName(field);
            boolean multiValued = ConfigurationParameterFactory.isMultiValued(field);
            String parameterType = ConfigurationParameterFactory.getConfigurationParameterType(field);
            return ConfigurationParameterFactory.createPrimitiveParameter(name, parameterType, annotation.description(), multiValued, annotation.mandatory());
        }
        throw new IllegalArgumentException("field is not annotated with annotation of type " + org.apache.uima.fit.descriptor.ConfigurationParameter.class.getName());
    }

    public static ConfigurationParameter createPrimitiveParameter(String name, Class<?> parameterClass, String parameterDescription, boolean isMandatory) {
        String parameterClassName = parameterClass.isArray() ? parameterClass.getComponentType().getName() : parameterClass.getName();
        String parameterType = JAVA_UIMA_TYPE_MAP.get(parameterClassName);
        if (parameterType == null) {
            parameterType = "String";
        }
        return ConfigurationParameterFactory.createPrimitiveParameter(name, parameterType, parameterDescription, parameterClass.isArray(), isMandatory);
    }

    protected static Object convertParameterValue(ConfigurationParameter param, Object aValue) {
        Object value = aValue;
        if (value.getClass().isArray() && value.getClass().getComponentType().getName().equals("boolean")) {
            value = ArrayUtils.toObject((boolean[])value);
        } else if (value.getClass().isArray() && value.getClass().getComponentType().getName().equals("int")) {
            value = ArrayUtils.toObject((int[])value);
        } else if (value.getClass().isArray() && value.getClass().getComponentType().getName().equals("float")) {
            value = ArrayUtils.toObject((float[])value);
        } else {
            try {
                if (param.getType().equals("String")) {
                    SimpleTypeConverter converter = new SimpleTypeConverter();
                    PropertyEditorUtil.registerUimaFITEditors((PropertyEditorRegistry)converter);
                    value = value.getClass().isArray() || value instanceof Collection ? converter.convertIfNecessary(value, String[].class) : converter.convertIfNecessary(value, String.class);
                }
            }
            catch (TypeMismatchException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        return value;
    }

    public static ConfigurationParameter createPrimitiveParameter(String name, String parameterType, String parameterDescription, boolean isMultiValued, boolean isMandatory) {
        ConfigurationParameter_impl param = new ConfigurationParameter_impl();
        param.setName(name);
        param.setType(parameterType);
        param.setDescription(parameterDescription);
        param.setMultiValued(isMultiValued);
        param.setMandatory(isMandatory);
        return param;
    }

    public static void setParameters(ResourceCreationSpecifier desc, Class<?> componentClass, ConfigurationParameter[] configurationParameters, Object[] configurationValues) {
        ConfigurationData reflectedConfigurationData = ConfigurationParameterFactory.createConfigurationData(componentClass);
        ResourceCreationSpecifierFactory.setConfigurationParameters(desc, reflectedConfigurationData.configurationParameters, reflectedConfigurationData.configurationValues);
        if (configurationParameters != null) {
            ResourceCreationSpecifierFactory.setConfigurationParameters(desc, configurationParameters, configurationValues);
        }
    }

    public static ConfigurationData createConfigurationData(Object ... configurationData) {
        if (configurationData == null) {
            return new ConfigurationData(new ConfigurationParameter[0], new Object[0]);
        }
        ConfigurationParameterFactory.ensureParametersComeInPairs(configurationData);
        int numberOfParameters = configurationData.length / 2;
        ArrayList<ConfigurationParameter> configurationParameters = new ArrayList<ConfigurationParameter>();
        ArrayList<Object> configurationValues = new ArrayList<Object>();
        for (int i = 0; i < numberOfParameters; ++i) {
            String name = (String)configurationData[i * 2];
            Object value = configurationData[i * 2 + 1];
            if (value == null || ExternalResourceFactory.getExternalResourceParameterType(value) != ExternalResourceFactory.ResourceValueType.NO_RESOURCE) continue;
            ConfigurationParameter param = ConfigurationParameterFactory.createPrimitiveParameter(name, value.getClass(), null, false);
            configurationParameters.add(param);
            configurationValues.add(ConfigurationParameterFactory.convertParameterValue(param, value));
        }
        return new ConfigurationData(configurationParameters.toArray(new ConfigurationParameter[configurationParameters.size()]), configurationValues.toArray());
    }

    public static ConfigurationData createConfigurationData(Class<?> componentClass) {
        ArrayList<ConfigurationParameter> configurationParameters = new ArrayList<ConfigurationParameter>();
        ArrayList<Object> configurationValues = new ArrayList<Object>();
        for (Field field : ReflectionUtil.getFields(componentClass)) {
            if (!ConfigurationParameterFactory.isConfigurationParameterField(field)) continue;
            configurationParameters.add(ConfigurationParameterFactory.createPrimitiveParameter(field));
            configurationValues.add(ConfigurationParameterFactory.getDefaultValue(field));
        }
        return new ConfigurationData(configurationParameters.toArray(new ConfigurationParameter[configurationParameters.size()]), configurationValues.toArray(new Object[configurationValues.size()]));
    }

    public static void addConfigurationParameters(ResourceCreationSpecifier specifier, Object ... configurationData) {
        ConfigurationData cdata = ConfigurationParameterFactory.createConfigurationData(configurationData);
        ResourceCreationSpecifierFactory.setConfigurationParameters(specifier, cdata.configurationParameters, cdata.configurationValues);
    }

    public static void addConfigurationParameters(ResourceCreationSpecifier specifier, List<Class<?>> dynamicallyLoadedClasses) {
        for (Class<?> dynamicallyLoadedClass : dynamicallyLoadedClasses) {
            ConfigurationData reflectedConfigurationData = ConfigurationParameterFactory.createConfigurationData(dynamicallyLoadedClass);
            ResourceCreationSpecifierFactory.setConfigurationParameters(specifier, reflectedConfigurationData.configurationParameters, reflectedConfigurationData.configurationValues);
        }
    }

    public static void addConfigurationParameters(ResourceCreationSpecifier specifier, Class<?> ... dynamicallyLoadedClasses) {
        for (Class<?> dynamicallyLoadedClass : dynamicallyLoadedClasses) {
            ConfigurationData reflectedConfigurationData = ConfigurationParameterFactory.createConfigurationData(dynamicallyLoadedClass);
            ResourceCreationSpecifierFactory.setConfigurationParameters(specifier, reflectedConfigurationData.configurationParameters, reflectedConfigurationData.configurationValues);
        }
    }

    public static void addConfigurationParameter(ResourceCreationSpecifier specifier, String name, Object value) {
        ConfigurationData cdata = ConfigurationParameterFactory.createConfigurationData(name, value);
        ResourceCreationSpecifierFactory.setConfigurationParameters(specifier, cdata.configurationParameters, cdata.configurationValues);
    }

    static void ensureParametersComeInPairs(Object[] configurationData) {
        if (configurationData != null && configurationData.length % 2 != 0) {
            throw new IllegalArgumentException("Parameter arguments have to come in key/value pairs, but found odd number of arguments [" + configurationData.length + "]");
        }
    }

    public static Map<String, Object> getParameterSettings(ResourceSpecifier spec) {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        if (spec instanceof CustomResourceSpecifier) {
            for (Parameter p : ((CustomResourceSpecifier)spec).getParameters()) {
                settings.put(p.getName(), p.getValue());
            }
        } else if (spec instanceof ResourceCreationSpecifier) {
            for (NameValuePair p : ((ResourceCreationSpecifier)spec).getMetaData().getConfigurationParameterSettings().getParameterSettings()) {
                settings.put(p.getName(), p.getValue());
            }
        } else if (spec instanceof ConfigurableDataResourceSpecifier) {
            for (NameValuePair p : ((ResourceCreationSpecifier)spec).getMetaData().getConfigurationParameterSettings().getParameterSettings()) {
                settings.put(p.getName(), p.getValue());
            }
        } else {
            throw new IllegalClassException("Unsupported resource specifier class [" + spec.getClass() + "]");
        }
        return settings;
    }

    public static void setParameter(ResourceSpecifier aSpec, String name, Object value) {
        if (aSpec instanceof CustomResourceSpecifier) {
            if (!(value instanceof String) && value != null) {
                throw new IllegalClassException(String.class, value);
            }
            CustomResourceSpecifier spec = (CustomResourceSpecifier)aSpec;
            boolean found = false;
            for (Parameter p : spec.getParameters()) {
                if (!p.getName().equals(name)) continue;
                p.setValue((String)value);
                found = true;
            }
            if (!found) {
                Parameter[] params = new Parameter[spec.getParameters().length + 1];
                System.arraycopy(spec.getParameters(), 0, params, 0, spec.getParameters().length);
                params[params.length - 1] = new Parameter_impl();
                params[params.length - 1].setName(name);
                params[params.length - 1].setValue((String)value);
                spec.setParameters(params);
            }
        } else if (aSpec instanceof ResourceCreationSpecifier) {
            ResourceMetaData md = ((ResourceCreationSpecifier)aSpec).getMetaData();
            ConfigurationParameter param = md.getConfigurationParameterDeclarations().getConfigurationParameter(null, name);
            if (param == null) {
                throw new IllegalArgumentException("Cannot set undeclared parameter [" + name + "]");
            }
            md.getConfigurationParameterSettings().setParameterValue(name, ConfigurationParameterFactory.convertParameterValue(param, value));
        } else if (aSpec instanceof ConfigurableDataResourceSpecifier) {
            ResourceMetaData md = ((ConfigurableDataResourceSpecifier)aSpec).getMetaData();
            ConfigurationParameter param = md.getConfigurationParameterDeclarations().getConfigurationParameter(null, name);
            if (param == null) {
                throw new IllegalArgumentException("Cannot set undeclared parameter [" + name + "]");
            }
            md.getConfigurationParameterSettings().setParameterValue(name, ConfigurationParameterFactory.convertParameterValue(param, value));
        } else {
            throw new IllegalClassException("Unsupported resource specifier class [" + aSpec.getClass() + "]");
        }
    }

    public static boolean canParameterBeSet(ResourceSpecifier aSpec, String name) {
        if (aSpec instanceof CustomResourceSpecifier) {
            return true;
        }
        if (aSpec instanceof ResourceCreationSpecifier) {
            ResourceMetaData md = ((ResourceCreationSpecifier)aSpec).getMetaData();
            return md.getConfigurationParameterDeclarations().getConfigurationParameter(null, name) != null;
        }
        if (aSpec instanceof ConfigurableDataResourceSpecifier) {
            ResourceMetaData md = ((ConfigurableDataResourceSpecifier)aSpec).getMetaData();
            return md.getConfigurationParameterDeclarations().getConfigurationParameter(null, name) != null;
        }
        return false;
    }

    static {
        JAVA_UIMA_TYPE_MAP.put(Boolean.class.getName(), "Boolean");
        JAVA_UIMA_TYPE_MAP.put(Float.class.getName(), "Float");
        JAVA_UIMA_TYPE_MAP.put(Double.class.getName(), "Float");
        JAVA_UIMA_TYPE_MAP.put(Integer.class.getName(), "Integer");
        JAVA_UIMA_TYPE_MAP.put(String.class.getName(), "String");
        JAVA_UIMA_TYPE_MAP.put("boolean", "Boolean");
        JAVA_UIMA_TYPE_MAP.put("float", "Float");
        JAVA_UIMA_TYPE_MAP.put("double", "Float");
        JAVA_UIMA_TYPE_MAP.put("int", "Integer");
    }

    public static class ConfigurationData {
        public ConfigurationParameter[] configurationParameters;
        public Object[] configurationValues;

        public ConfigurationData(ConfigurationParameter[] configurationParameters, Object[] configurationValues) {
            this.configurationParameters = configurationParameters;
            this.configurationValues = configurationValues;
        }
    }
}

