package Color::Library::Dictionary::NBS_ISCC::P;

use strict;
use warnings;

use base qw/Color::Library::Dictionary/;

__PACKAGE__->_register_dictionary;

package Color::Library::Dictionary::NBS_ISCC::P;

=pod

=head1 NAME

Color::Library::Dictionary::NBS_ISCC::P - (NBS/ISCC P) Plochere Color System

=head1 DESCRIPTION

    Kenneth L. Kelly and Deanne B. Judd.
    "Color: Universal Language and Dictionary of Names",
    National Bureau of Standards,
    Spec. Publ. 440, Dec. 1976, 189 pages.


Color Name Dictionary: (P) Plochere Color System

Plochere Color System

This idiosyncratic dictionary for interior decorating has 1246 names mapping to 1606 colors, using 206 of the 267 centroids.

L<http://swissnet.ai.mit.edu/~jaffer/Color/Dictionaries#P>

=head1 COLORS

	absinthe yellow              absintheyellow             #c9ae5d

	abstract blue                abstractblue               #bcd4e6

	abyss                        abyss                      #8da399

	acacia                       acacia                     #5e716a

	acacia gray                  acaciagray                 #7d8984

	acacia green                 acaciagreen                #7d8984

	aden                         aden                       #6aab8e

	admiral                      admiral                    #50404d

	african green                africangreen               #36454f

	african night                africannight               #43302e

	after glow                   afterglow                  #e8ccd7

	agean mist                   ageanmist                  #b2beb5

	ageratum                     ageratum                   #c3a6b1

	air castle blue              aircastleblue              #bcd4e6

	airy cream                   airycream                  #f2f3f4

	aladdin's lamp               aladdinslamp               #cb6d51

	algiers blue                 algiersblue                #367588

	allure                       allure                     #70a3cc

	almond                       almond                     #c19a6b

	almond cream                 almondcream                #fad6a5

	alpine blue                  alpineblue                 #b3bce2

	alpine blue                  alpineblue                 #c0c8e1

	amaranth                     amaranth                   #673147

	amaranth                     amaranth                   #915f6d

	amber coral                  ambercoral                 #d9a6a9

	amber gold                   ambergold                  #c19a6b

	amber gold                   ambergold                  #c2b280

	amber gold                   ambergold                  #a18f60

	ambrosia                     ambrosia                   #b6e5af

	amethyst                     amethyst                   #836479

	amethyst orchid              amethystorchid             #b695c0

	amulet                       amulet                     #317873

	ancestral                    ancestral                  #f2f3f4

	ancestral                    ancestral                  #b9b8b5

	angel blue                   angelblue                  #bcd4e6

	angel wing                   angelwing                  #efbbcc

	angora                       angora                     #fad6a5

	angora                       angora                     #f0ead6

	antique brass                antiquebrass               #ab9144

	antique bronze               antiquebronze              #665d1e

	antique fuchsia              antiquefuchsia             #915c83

	antique yellow               antiqueyellow              #c9ae5d

	apple green                  applegreen                 #8a9a5b

	apricot                      apricot                    #fab57f

	apricot cream                apricotcream               #fad6a5

	apricot cream                apricotcream               #f3e5ab

	apricot ice                  apricotice                 #fad6a5

	apricot sherbet              apricotsherbet             #fbc97f

	apricot tan                  apricottan                 #d99058

	apricot tan                  apricottan                 #e3a857

	april sky                    aprilsky                   #96ded1

	aqua gray                    aquagray                   #8da399

	aquamarine green             aquamarinegreen            #317873

	aqua queen                   aquaqueen                  #96ded1

	aqua sky                     aquasky                    #66ada4

	arbor green                  arborgreen                 #679267

	arcadia                      arcadia                    #beb72e

	arcadia                      arcadia                    #b9b459

	arctic                       arctic                     #536878

	arctic                       arctic                     #36454f

	arno blue                    arnoblue                   #367588

	ashes of roses               ashesofroses               #c08081

	ashes of roses               ashesofroses               #c17e91

	asthetic blue                astheticblue               #66aabc

	atlantis                     atlantis                   #00304e

	atonement                    atonement                  #aa98a9

	aurora pink                  aurorapink                 #e68fac

	aurora pink                  aurorapink                 #d597ae

	aurora yellow                aurorayellow               #f8de7e

	autumn brown                 autumnbrown                #996515

	autumn brown                 autumnbrown                #6c541e

	autumn glory                 autumnglory                #841b2d

	autumn glory                 autumnglory                #9e4732

	autumn glory                 autumnglory                #be8a3d

	autumn gold                  autumngold                 #be8a3d

	autumn tan                   autumntan                  #826644

	avon                         avon                       #7d8984

	azalea                       azalea                     #a8516e

	azurite blue                 azuriteblue                #367588

	azurite blue                 azuriteblue                #536878

	baby blue                    babyblue                   #a1caf1

	baby blue eyes               babyblueeyes               #a1caf1

	baby blue eyes               babyblueeyes               #b3bce2

	bagdad                       bagdad                     #905d5d

	ballad blue                  balladblue                 #8791bf

	ballerina                    ballerina                  #dcd0ff

	balmy air                    balmyair                   #bcd4e6

	balsam green                 balsamgreen                #3a4b47

	baltic                       baltic                     #36454f

	baltic                       baltic                     #222222

	banana                       banana                     #f8de7e

	banshee                      banshee                    #5e716a

	banshee                      banshee                    #3a4b47

	banshee                      banshee                    #317873

	banshee                      banshee                    #004b49

	baronet                      baronet                    #70a3cc

	basic                        basic                      #004b49

	bath stone                   bathstone                  #fad6a5

	bavarian blue                bavarianblue               #00304e

	bay leaf                     bayleaf                    #996515

	bayou                        bayou                      #36454f

	bayou                        bayou                      #222222

	beau blue                    beaublue                   #bcd4e6

	beautiful                    beautiful                  #317873

	beauty pink                  beautypink                 #ffc8d6

	beige gray                   beigegray                  #bfb8a5

	belladonna                   belladonna                 #86608e

	bellflower                   bellflower                 #604e81

	beryl green                  berylgreen                 #66ada4

	best effort                  besteffort                 #ebe8a4

	best effort                  besteffort                 #dadfb7

	bewitch                      bewitch                    #00a693

	bewitching blue              bewitchingblue             #70a3cc

	billiard                     billiard                   #00443f

	billiard                     billiard                   #004b49

	billow                       billow                     #bcd4e6

	birch                        birch                      #dfede8

	bird's-egg-green             birdsegggreen              #8da399

	bird's-egg-green             birdsegggreen              #66ada4

	biscay bay                   biscaybay                  #367588

	biscay bay                   biscaybay                  #536878

	bishop                       bishop                     #604e81

	bison                        bison                      #6c541e

	bisque                       bisque                     #d9a6a9

	bisque                       bisque                     #c7ada3

	bittersweet                  bittersweet                #9e4732

	bittersweet orange           bittersweetorange          #d9603b

	bittersweet orange           bittersweetorange          #ed872d

	blackberry cream             blackberrycream            #d597ae

	black forest                 blackforest                #515744

	black knight                 blackknight                #36454f

	black knight                 blackknight                #51585e

	black water                  blackwater                 #272458

	black water                  blackwater                 #222222

	blanch                       blanch                     #96ded1

	blarney                      blarney                    #008856

	blarney                      blarney                    #007959

	blaze blue                   blazeblue                  #536878

	blaze blue                   blazeblue                  #36454f

	blend                        blend                      #dadfb7

	blithe                       blithe                     #239eba

	blonde green                 blondegreen                #dfede8

	blossom                      blossom                    #ebe8a4

	blue appeal                  blueappeal                 #a1caf1

	blue appeal                  blueappeal                 #bcd4e6

	blue bell                    bluebell                   #8791bf

	blue chill                   bluechill                  #bcd4e6

	blue danube                  bluedanube                 #007791

	blue dash                    bluedash                   #536878

	blue day                     blueday                    #c0c8e1

	blue fog                     bluefog                    #536878

	blue fog                     bluefog                    #81878b

	blue glow                    blueglow                   #bcd4e6

	blue grotto                  bluegrotto                 #66aabc

	blue heaven                  blueheaven                 #4997d0

	blue heaven                  blueheaven                 #a1caf1

	blue heaven                  blueheaven                 #70a3cc

	blue horizon                 bluehorizon                #91a3b0

	blue hour                    bluehour                   #367588

	blue idol                    blueidol                   #317873

	blue light                   bluelight                  #bcd4e6

	blue lightning               bluelightning              #0067a5

	blue mist                    bluemist                   #66aabc

	blue mist                    bluemist                   #91a3b0

	blue prose                   blueprose                  #9cd1dc

	blue ridge                   blueridge                  #a1caf1

	blue ridge                   blueridge                  #b3bce2

	blue shadow                  blueshadow                 #367588

	blue spruce                  bluespruce                 #3b7861

	blue swirl                   blueswirl                  #66aabc

	blue tease                   bluetease                  #9cd1dc

	blue turquoise               blueturquoise              #239eba

	blue waltz                   bluewaltz                  #c7e6d7

	blue waltz                   bluewaltz                  #96ded1

	blue wash                    bluewash                   #e9e9ed

	blush rose                   blushrose                  #915f6d

	blush yellow                 blushyellow                #fbc97f

	blush yellow                 blushyellow                #fad6a5

	bog                          bog                        #8f9779

	bohemian blue                bohemianblue               #436b95

	bonnie blue                  bonnieblue                 #00a1c2

	bonnie blue                  bonnieblue                 #30267a

	bottle green                 bottlegreen                #3b7861

	bottle green                 bottlegreen                #5e716a

	bougainvillea                bougainvillea              #ce4676

	bounding main                boundingmain               #70a3cc

	bouquet green                bouquetgreen               #27a64c

	bouquet green                bouquetgreen               #83d37d

	bouquet orchid               bouquetorchid              #d5badb

	bouquet orchid               bouquetorchid              #d6cadd

	bouquet yellow               bouquetyellow              #f8de7e

	brass                        brass                      #ab9144

	brazil red                   brazilred                  #9e4732

	breath of spring             breathofspring             #ebe8a4

	breath of spring             breathofspring             #c9dc89

	bridesmaid pink              bridesmaidpink             #efbbcc

	bright sun                   brightsun                  #f3c300

	bright sun                   brightsun                  #fada5e

	brilliant green              brilliantgreen             #004b49

	bronze gold                  bronzegold                 #d4af37

	bronze gold                  bronzegold                 #c9ae5d

	bronze mist                  bronzemist                 #867e36

	bronze pink                  bronzepink                 #d9a6a9

	bronze pink                  bronzepink                 #d99058

	bronze sheen                 bronzesheen                #5b5842

	bronzio                      bronzio                    #79443b

	brook green                  brookgreen                 #96ded1

	bruges                       bruges                     #51585e

	buccaneer                    buccaneer                  #bc3f4a

	buckskin tan                 buckskintan                #fad6a5

	buff citron                  buffcitron                 #c2b280

	burnt almond                 burntalmond                #6f4e37

	burnt orange                 burntorange                #ed872d

	burnt yellow                 burntyellow                #e3a857

	butterfly yellow             butterflyyellow            #e9e450

	butterfly yellow             butterflyyellow            #eae679

	cabbage                      cabbage                    #c7e6d7

	caen stone                   caenstone                  #fad6a5

	california gold              californiagold             #e3a857

	california green             californiagreen            #7d8984

	california poppy             californiapoppy            #eaa221

	camelia pink                 cameliapink                #ea9399

	camelia pink                 cameliapink                #f88379

	camelia rose                 cameliarose                #ea9399

	cameo                        cameo                      #f9ccca

	cameo pink                   cameopink                  #ea9399

	cameo pink                   cameopink                  #efbbcc

	canary bronze                canarybronze               #f3c300

	canary yellow                canaryyellow               #f3c300

	canary yellow                canaryyellow               #fada5e

	candida                      candida                    #d597ae

	canton                       canton                     #317873

	caprice lavender             capricelavender            #e8e3e5

	caprice pink                 capricepink                #915c83

	caprice pink                 capricepink                #a8516e

	caramel                      caramel                    #a67b5b

	caramel cream                caramelcream               #fad6a5

	caravan                      caravan                    #977f73

	carnival red                 carnivalred                #be0032

	castilian blue               castilianblue              #0067a5

	cathedral                    cathedral                  #301934

	cathedral                    cathedral                  #291e29

	cedar                        cedar                      #8a9a5b

	cedar bough                  cedarbough                 #8a9a5b

	celestial blue               celestialblue              #4997d0

	celestial blue               celestialblue              #6c79b8

	celestial yellow             celestialyellow            #f8de7e

	celestial yellow             celestialyellow            #f3e5ab

	ceramic                      ceramic                    #367588

	ceramic                      ceramic                    #436b95

	ceres                        ceres                      #f8de7e

	cerise pink                  cerisepink                 #b3446c

	cerise rose                  ceriserose                 #e4717a

	ceylon blue                  ceylonblue                 #536878

	chalk violet                 chalkviolet                #8c82b6

	chalk violet                 chalkviolet                #9690ab

	chamois yellow               chamoisyellow              #e3a857

	chamois yellow               chamoisyellow              #c19a6b

	champagne                    champagne                  #f3e5ab

	champagne buff               champagnebuff              #f3e5ab

	chantilly                    chantilly                  #6aab8e

	charcoal                     charcoal                   #3e322c

	charcoal                     charcoal                   #222222

	charm                        charm                      #ea9399

	charm                        charm                      #f9ccca

	charm                        charm                      #efbbcc

	charm                        charm                      #9cd1dc

	charm pink                   charmpink                  #e68fac

	charm school                 charmschool                #aa8a9e

	charm school                 charmschool                #af868e

	chartreuse green             chartreusegreen            #8db600

	chartreuse green             chartreusegreen            #bdda57

	chartreuse yellow            chartreuseyellow           #e9e450

	chaste                       chaste                     #f2f3f4

	chateau                      chateau                    #66aabc

	cheddar cheese               cheddarcheese              #e3a857

	cheer                        cheer                      #f3c300

	cheerful yellow              cheerfulyellow             #f3e5ab

	cheerful yellow              cheerfulyellow             #f0ead6

	chelsea yellow               chelseayellow              #eae679

	chelsea yellow               chelseayellow              #ebe8a4

	cherry                       cherry                     #be0032

	chili                        chili                      #00a693

	china pink                   chinapink                  #de6fa1

	china pink                   chinapink                  #b3446c

	china rose                   chinarose                  #905d5d

	china sea                    chinasea                   #66aabc

	chive                        chive                      #4a5d23

	chive                        chive                      #355e3b

	christmas green              christmasgreen             #3a4b47

	chrysanthemum yelllow        chrysanthemumyelllow       #f3c300

	chrysolite green             chrysolitegreen            #8a9a5b

	cinderella                   cinderella                 #fada5e

	cineraria                    cineraria                  #915f6d

	cinnamon                     cinnamon                   #ae6938

	cinnamon cream               cinnamoncream              #ecd5c5

	citron bronze                citronbronze               #6c541e

	citron gray                  citrongray                 #967117

	citron gray                  citrongray                 #8c8767

	citron yellow                citronyellow               #f8de7e

	citron yellow                citronyellow               #c9ae5d

	citron yellow                citronyellow               #eae679

	citron yellow                citronyellow               #b9b459

	classic blue                 classicblue                #007791

	classic blue                 classicblue                #436b95

	clementine                   clementine                 #efbbcc

	cleopatra                    cleopatra                  #c7e6d7

	clivia                       clivia                     #d99058

	cloister                     cloister                   #c7e6d7

	cloister                     cloister                   #bcd4e6

	cloud cream                  cloudcream                 #f3e5ab

	cloud cream                  cloudcream                 #f0ead6

	cloud gray                   cloudgray                  #d6cadd

	cloudy blue                  cloudyblue                 #bcd4e6

	clover                       clover                     #c17e91

	cocoa bronze                 cocoabronze                #867e36

	cocoa brown                  cocoabrown                 #a67b5b

	cold morn                    coldmorn                   #9690ab

	cold morn                    coldmorn                   #aa98a9

	colonial blue                colonialblue               #00304e

	colonial cream               colonialcream              #f3e5ab

	colonial exterior green      colonialexteriorgreen      #3b7861

	conclude                     conclude                   #f0ead6

	congo                        congo                      #79443b

	congo blue                   congoblue                  #536878

	congo brown                  congobrown                 #80461b

	congo brown                  congobrown                 #6f4e37

	conifer                      conifer                    #515744

	continental blue             continentalblue            #5d555b

	cool eve                     cooleve                    #8da399

	copper                       copper                     #cb6d51

	copper bronze                copperbronze               #ae6938

	copper cream                 coppercream                #ecd5c5

	coquette                     coquette                   #e8ccd7

	coral                        coral                      #e4717a

	coral blush                  coralblush                 #f9ccca

	coral blush                  coralblush                 #f4c2c2

	coral cloud                  coralcloud                 #f4c2c2

	coral gold                   coralgold                  #cb6d51

	coral pink                   coralpink                  #f88379

	coral rose                   coralrose                  #e4717a

	coronation                   coronation                 #673147

	coronet blue                 coronetblue                #436b95

	corsage pink                 corsagepink                #e8ccd7

	corsair                      corsair                    #36454f

	corydalis                    corydalis                  #c9dc89

	corydalis                    corydalis                  #dadfb7

	cosmic blue                  cosmicblue                 #436b95

	cosmos pink                  cosmospink                 #d5badb

	cosmos pink                  cosmospink                 #d6cadd

	cowslip                      cowslip                    #fab57f

	crab pink                    crabpink                   #f9ccca

	crab pink                    crabpink                   #ead8d7

	cream                        cream                      #f0ead6

	cream blush                  creamblush                 #fad6a5

	cream chant                  creamchant                 #ebe8a4

	cream cheese                 creamcheese                #f0ead6

	cream delight                creamdelight               #ebe8a4

	cream dream                  creamdream                 #f0ead6

	cream gold                   creamgold                  #f8de7e

	cream pearl                  creampearl                 #f0ead6

	cream tone                   creamtone                  #f3e5ab

	cream tone                   creamtone                  #f0ead6

	cream white                  creamwhite                 #f0ead6

	cream yellow                 creamyellow                #f3e5ab

	creole pink                  creolepink                 #ecd5c5

	crest                        crest                      #00a693

	crimson glory                crimsonglory               #be0032

	crisp blue                   crispblue                  #9cd1dc

	crocus rose                  crocusrose                 #efbbcc

	cruise blue                  cruiseblue                 #367588

	cruise blue                  cruiseblue                 #436b95

	crystal blue                 crystalblue                #239eba

	crystal blue                 crystalblue                #9cd1dc

	cuban orchid                 cubanorchid                #b784a7

	cuban orchid                 cubanorchid                #d597ae

	cuban sand                   cubansand                  #c9ae5d

	cuban sand                   cubansand                  #ab9144

	cuddle blue                  cuddleblue                 #bcd4e6

	cuddle blue                  cuddleblue                 #91a3b0

	cupid blue                   cupidblue                  #9cd1dc

	cyan blue                    cyanblue                   #367588

	cypress                      cypress                    #679267

	daphne pink                  daphnepink                 #c17e91

	dark forest                  darkforest                 #3a4b47

	dark fuchsia                 darkfuchsia                #9e4f88

	dawn glow                    dawnglow                   #d6cadd

	dawn glow                    dawnglow                   #e8ccd7

	dawn pink                    dawnpink                   #efbbcc

	daybreak                     daybreak                   #aa98a9

	day dream                    daydream                   #9690ab

	dazzle blue                  dazzleblue                 #007791

	debonair                     debonair                   #91a3b0

	debutante blue               debutanteblue              #9cd1dc

	debutante blue               debutanteblue              #bcd4e6

	debutante pink               debutantepink              #ea9399

	debutante yellow             debutanteyellow            #eae679

	deep hellebore red           deephelleborered           #915f6d

	deep purple                  deeppurple                 #50404d

	deep purple                  deeppurple                 #291e29

	deep purple                  deeppurple                 #242124

	deep ravine                  deepravine                 #6c541e

	deep reverie                 deepreverie                #5d555b

	deep sea                     deepsea                    #317873

	deep twilight                deeptwilight               #8e8279

	deep violet                  deepviolet                 #604e81

	deep violet                  deepviolet                 #2f2140

	deep water                   deepwater                  #436b95

	delectable                   delectable                 #239eba

	delectable                   delectable                 #66aabc

	delectable                   delectable                 #70a3cc

	delight                      delight                    #d6cadd

	del monte                    delmonte                   #796878

	delta                        delta                      #367588

	delusion                     delusion                   #9cd1dc

	demon blue                   demonblue                  #51585e

	demure blue                  demureblue                 #bcd4e6

	depth green                  depthgreen                 #3a4b47

	desert brown                 desertbrown                #f9ccca

	desert dust                  desertdust                 #f3e5ab

	desert dust                  desertdust                 #f0ead6

	desert glass                 desertglass                #b695c0

	desert mist                  desertmist                 #fad6a5

	desert palm                  desertpalm                 #5b5842

	desert pride                 desertpride                #dadfb7

	desert sand                  desertsand                 #c19a6b

	desirable                    desirable                  #c7e6d7

	desire                       desire                     #d5badb

	dewkist                      dewkist                    #b2beb5

	dewkist                      dewkist                    #b9b8b5

	diadem                       diadem                     #aa8a9e

	dignity                      dignity                    #dea5a4

	dignity                      dignity                    #efbbcc

	dignity                      dignity                    #e8ccd7

	distinction                  distinction                #915f6d

	diva blue                    divablue                   #30267a

	diva blue                    divablue                   #6c79b8

	divine blue                  divineblue                 #70a3cc

	dolly varden                 dollyvarden                #f9ccca

	dove gray                    dovegray                   #bfb9bd

	dove gray                    dovegray                   #c3a6b1

	drab olive                   drabolive                  #8a9a5b

	dream blue                   dreamblue                  #a1caf1

	dream cream                  dreamcream                 #dadfb7

	dream fluff                  dreamfluff                 #e8e3e5

	dream stuff                  dreamstuff                 #efbbcc

	dreamy blue                  dreamyblue                 #91a3b0

	dried leaf                   driedleaf                  #f8de7e

	drizzle                      drizzle                    #b2beb5

	dryad                        dryad                      #66ada4

	dryad rose                   dryadrose                  #ecd5c5

	du barry blue                dubarryblue                #00a693

	duckling blue                ducklingblue               #536878

	duckling blue                ducklingblue               #36454f

	dusky blue                   duskyblue                  #91a3b0

	dusky citron                 duskycitron                #8a9a5b

	dusky green                  duskygreen                 #8f9779

	dusty green                  dustygreen                 #8a9a5b

	dusty green                  dustygreen                 #8f9779

	dutch cream                  dutchcream                 #fad6a5

	dutch cream                  dutchcream                 #f0ead6

	dynasty green                dynastygreen               #007a74

	earth brown                  earthbrown                 #6f4e37

	easter bonnet                easterbonnet               #bcd4e6

	easter egg yellow            eastereggyellow            #f8de7e

	ecru                         ecru                       #f3e5ab

	ecru cream                   ecrucream                  #f3e5ab

	ecru cream                   ecrucream                  #f0ead6

	eerie blue                   eerieblue                  #bcd4e6

	egg plant                    eggplant                   #50404d

	egg plant                    eggplant                   #291e29

	egg shell                    eggshell                   #fad6a5

	egg shell                    eggshell                   #f3e5ab

	egyptian red                 egyptianred                #722f37

	eighteenth century citron    eighteenthcenturycitron    #8a9a5b

	eighteenth century green     eighteenthcenturygreen     #8f9779

	eighteenth century tan       eighteenthcenturytan       #ad8884

	eighteenth century turquoise eighteenthcenturyturquoise #367588

	eighteenth century turquoise eighteenthcenturyturquoise #536878

	eighteenth century violet    eighteenthcenturyviolet    #836479

	eighteenth century yellow    eighteenthcenturyyellow    #c2b280

	electra                      electra                    #96ded1

	elf green                    elfgreen                   #8da399

	elf green                    elfgreen                   #66ada4

	elm                          elm                        #8f9779

	emerald green                emeraldgreen               #b6e5af

	emerald isle                 emeraldisle                #008856

	empire yellow                empireyellow               #f3c300

	empire yellow                empireyellow               #fada5e

	empirical blue               empiricalblue              #66ada4

	enchantress                  enchantress                #cb6d51

	enduring                     enduring                   #66ada4

	enduring                     enduring                   #66aabc

	english mist                 englishmist                #7d8984

	erie                         erie                       #317873

	etherial green               etherialgreen              #c9dc89

	etherial green               etherialgreen              #dadfb7

	eucalyptus green             eucalyptusgreen            #8f9779

	eve green                    evegreen                   #83d37d

	eve green                    evegreen                   #44944a

	evening glow                 eveningglow                #f9ccca

	evening haze                 eveninghaze                #dea5a4

	eventide                     eventide                   #c3a6b1

	everglade                    everglade                  #222222

	fable                        fable                      #e8e3e5

	fairy gold                   fairygold                  #eae679

	fairy land                   fairyland                  #c7e6d7

	fairy land                   fairyland                  #96ded1

	fairy princess               fairyprincess              #e9e9ed

	falcon                       falcon                     #5b504f

	fall blue                    fallblue                   #91a3b0

	fall blue                    fallblue                   #8c92ac

	fall bronze                  fallbronze                 #ab9144

	fall leaf                    fallleaf                   #f8de7e

	fall leaf                    fallleaf                   #c9ae5d

	fall yellow                  fallyellow                 #f8de7e

	fall yellow                  fallyellow                 #c9ae5d

	fancy free                   fancyfree                  #c7e6d7

	fanfare                      fanfare                    #007791

	fantasia                     fantasia                   #c7e6d7

	fantasy rose                 fantasyrose                #c7ada3

	fantasy yellow               fantasyyellow              #f3e5ab

	far horizon                  farhorizon                 #4e5755

	favorite                     favorite                   #8da399

	ferndell                     ferndell                   #355e3b

	fernery                      fernery                    #1b4d3e

	fern green                   ferngreen                  #8a9a5b

	fern lane                    fernlane                   #c7e6d7

	festival                     festival                   #3eb489

	festival                     festival                   #00a693

	festive green                festivegreen               #27a64c

	festive green                festivegreen               #83d37d

	festoon                      festoon                    #3eb489

	fidelity                     fidelity                   #c0c8e1

	finesse                      finesse                    #c7ada3

	firecracker                  firecracker                #d9603b

	fire fly                     firefly                    #e4717a

	fir green                    firgreen                   #8a9a5b

	firmament blue               firmamentblue              #545aa7

	firmament gray               firmamentgray              #bcd4e6

	firmament gray               firmamentgray              #e9e9ed

	first lady                   firstlady                  #b784a7

	first lady                   firstlady                  #de6fa1

	flame                        flame                      #be0032

	flame                        flame                      #bc3f4a

	flamingo pink                flamingopink               #ea9399

	flash                        flash                      #bc3f4a

	flax flower blue             flaxflowerblue             #6c79b8

	flemish blue                 flemishblue                #536878

	flesh cream                  fleshcream                 #ecd5c5

	flesh cream                  fleshcream                 #fad6a5

	flesh pink                   fleshpink                  #ecd5c5

	flesh tint                   fleshtint                  #f4c2c2

	flesh tint                   fleshtint                  #ecd5c5

	flint                        flint                      #5c504f

	flirtation                   flirtation                 #aa98a9

	flowerlet                    flowerlet                  #c9dc89

	fog blue                     fogblue                    #8c92ac

	fog green                    foggreen                   #8da399

	fog yellow                   fogyellow                  #a18f60

	foliage                      foliage                    #7e9f2e

	forest shade                 forestshade                #679267

	fortune                      fortune                    #7e73b8

	fountain blue                fountainblue               #c0c8e1

	fountain green               fountaingreen              #83d37d

	fountain green               fountaingreen              #b6e5af

	four-leaf clover             fourleafclover             #355e3b

	french beige                 frenchbeige                #a67b5b

	french blue                  frenchblue                 #8791bf

	french lilac                 frenchlilac                #836479

	french nude                  frenchnude                 #d9a6a9

	frosty night                 frostynight                #e9e9ed

	froth                        froth                      #f0ead6

	frozen dew                   frozendew                  #bcd4e6

	fuchsia                      fuchsia                    #bc3f4a

	fuchsia                      fuchsia                    #b3446c

	fuchsia pink                 fuchsiapink                #e68fac

	fuchsia pink                 fuchsiapink                #de6fa1

	fuchsia pink                 fuchsiapink                #de6fa1

	fuchsia pink                 fuchsiapink                #d597ae

	fuchsia rose                 fuchsiarose                #ce4676

	fuchsia rose                 fuchsiarose                #b3446c

	gale cloud                   galecloud                  #51585e

	gale winds                   galewinds                  #51585e

	garden pool                  gardenpool                 #c7e6d7

	garnet rose                  garnetrose                 #722f37

	gay yellow                   gayyellow                  #e9e450

	gay yellow                   gayyellow                  #eae679

	geneva blue                  genevablue                 #00304e

	geneva blue                  genevablue                 #4c516d

	ghostly blue                 ghostlyblue                #bcd4e6

	ghostly blue                 ghostlyblue                #c0c8e1

	gleam                        gleam                      #eae679

	glint o'gold                 glintogold                 #f8de7e

	glint o'gold                 glintogold                 #c9ae5d

	glory green                  glorygreen                 #bdda57

	glory green-blue             glorygreenblue             #317873

	gold coast                   goldcoast                  #ab9144

	golden apricot               goldenapricot              #fab57f

	golden apricot               goldenapricot              #d99058

	golden brown                 goldenbrown                #ae6938

	golden buff                  goldenbuff                 #f8de7e

	golden cream                 goldencream                #f8de7e

	golden dawn                  goldendawn                 #f8de7e

	golden fleece                goldenfleece               #fad6a5

	golden fleece                goldenfleece               #f3e5ab

	golden fleece                goldenfleece               #c2b280

	golden gem                   goldengem                  #f8de7e

	golden glow                  goldenglow                 #fada5e

	golden mist                  goldenmist                 #b9b57d

	golden mist                  goldenmist                 #c9dc89

	golden mist                  goldenmist                 #dadfb7

	golden peach                 goldenpeach                #e3a857

	golden rapture               goldenrapture              #fada5e

	golden ray                   goldenray                  #fada5e

	golden ray                   goldenray                  #f8de7e

	golden rod                   goldenrod                  #fada5e

	golden sheaf                 goldensheaf                #f3e5ab

	golden sulphur               goldensulphur              #eae679

	golden tan                   goldentan                  #d99058

	golden west                  goldenwest                 #be8a3d

	golden yellow                goldenyellow               #f8de7e

	gold fantasy                 goldfantasy                #fada5e

	gold glow                    goldglow                   #eae679

	gold glow                    goldglow                   #ebe8a4

	gold pheasant                goldpheasant               #ae6938

	gold rush                    goldrush                   #e3a857

	good omen                    goodomen                   #8c82b6

	good omen                    goodomen                   #70a3cc

	gorge                        gorge                      #b2beb5

	gorge                        gorge                      #b9b8b5

	gracious green               graciousgreen              #c7e6d7

	grand canyon                 grandcanyon                #a87c6d

	grand canyon                 grandcanyon                #a67b5b

	granite blue                 graniteblue                #536878

	granite green                granitegreen               #8da399

	grape                        grape                      #2f2140

	grape                        grape                      #50404d

	grapefruit green             grapefruitgreen            #e9e450

	grapefruit green             grapefruitgreen            #beb72e

	grapefruit green             grapefruitgreen            #eae679

	grapefruit green             grapefruitgreen            #b9b459

	grape green                  grapegreen                 #8a9a5b

	gravel                       gravel                     #c2ac99

	gravel                       gravel                     #ae9b82

	gravel                       gravel                     #bfb8a5

	gray blue                    grayblue                   #b4bcc0

	gray dream                   graydream                  #f0ead6

	gray dream                   graydream                  #bfb8a5

	gray drift                   graydrift                  #bcd4e6

	gray drift                   graydrift                  #b4bcc0

	gray green                   graygreen                  #5e716a

	gray lady                    graylady                   #b4bcc0

	gray light                   graylight                  #c1b6b3

	gray light                   graylight                  #b9b8b5

	gray mist                    graymist                   #91a3b0

	gray mist                    graymist                   #b4bcc0

	gray mood                    graymood                   #5d555b

	gray morn                    graymorn                   #8e8279

	gray night                   graynight                  #536878

	gray sand                    graysand                   #c2b280

	gray sand                    graysand                   #bfb8a5

	grecian rose                 grecianrose                #f88379

	grecian rose                 grecianrose                #d9a6a9

	green banana                 greenbanana                #b9b459

	green banana                 greenbanana                #b9b57d

	green black                  greenblack                 #3a4b47

	green black                  greenblack                 #4e5755

	green black                  greenblack                 #555555

	green black                  greenblack                 #222222

	green breath                 greenbreath                #f0ead6

	green charm                  greencharm                 #eae679

	green charm                  greencharm                 #c9dc89

	green dream                  greendream                 #96ded1

	greenery                     greenery                   #8db600

	greenery                     greenery                   #7e9f2e

	green eyes                   greeneyes                  #679267

	green fog                    greenfog                   #8f9779

	green glory                  greenglory                 #007a74

	green glory                  greenglory                 #317873

	green glow                   greenglow                  #c7e6d7

	green grass                  greengrass                 #8a9a5b

	green haze                   greenhaze                  #8f9779

	green ice                    greenice                   #f0ead6

	green ice                    greenice                   #dfede8

	green lily                   greenlily                  #c7e6d7

	green matrix                 greenmatrix                #004b49

	green mist                   greenmist                  #8f9779

	green moss                   greenmoss                  #8a9a5b

	green oasis                  greenoasis                 #98943e

	green oasis                  greenoasis                 #7e9f2e

	green olive                  greenolive                 #8a9a5b

	green pride                  greenpride                 #c9dc89

	green ravine                 greenravine                #5e716a

	green river mist             greenrivermist             #b2beb5

	green slate                  greenslate                 #1e2321

	green spring                 greenspring                #7e9f2e

	green stone                  greenstone                 #dadfb7

	green sulphur                greensulphur               #b9b459

	green tea                    greentea                   #679267

	green tee                    greentee                   #8a9a5b

	growth green                 growthgreen                #bdda57

	guinea green                 guineagreen                #317873

	gull gray                    gullgray                   #8b8589

	gumdrop green                gumdropgreen               #c9dc89

	gun metal                    gunmetal                   #5b504f

	gypsy                        gypsy                      #80461b

	hanging garden               hanginggarden              #27a64c

	hansa yellow                 hansayellow                #f3c300

	happy day                    happyday                   #ebe8a4

	happy day                    happyday                   #dadfb7

	harbor blue                  harborblue                 #bcd4e6

	harem blue                   haremblue                  #bcd4e6

	harmonious blue              harmoniousblue             #536878

	harvest gold                 harvestgold                #f8de7e

	hawk brown                   hawkbrown                  #6c541e

	heart's desire               heartsdesire               #ab4e52

	heavenly charm               heavenlycharm              #f0ead6

	heavenly day                 heavenlyday                #ebe8a4

	heavenly flower              heavenlyflower             #4997d0

	heavenly green               heavenlygreen              #c9dc89

	heavenly orchid              heavenlyorchid             #e8ccd7

	heavenly pink                heavenlypink               #f9ccca

	heliotrope                   heliotrope                 #702963

	heliotrope                   heliotrope                 #5d3954

	heliotrope gray              heliotropegray             #aa98a9

	heliotrope gray              heliotropegray             #aa8a9e

	heliotrope gray              heliotropegray             #c3a6b1

	hemlock                      hemlock                    #93c592

	hemp                         hemp                       #c2b280

	hiawatha green               hiawathagreen              #317873

	highland                     highland                   #3a4b47

	holiday                      holiday                    #96ded1

	holland blue                 hollandblue                #91a3b0

	honey beige                  honeybeige                 #d9a6a9

	horizon                      horizon                    #91a3b0

	hortensia                    hortensia                  #563c5c

	hortensia                    hortensia                  #5d3954

	huckleberry                  huckleberry                #50404d

	huron                        huron                      #66ada4

	hussar                       hussar                     #4c516d

	iceberg green                iceberggreen               #8da399

	iceberg green                iceberggreen               #91a3b0

	ice boat                     iceboat                    #00a693

	ice cap                      icecap                     #66aabc

	ice flow                     iceflow                    #c7e6d7

	iceland blue                 icelandblue                #bcd4e6

	icy green                    icygreen                   #66ada4

	icy morn                     icymorn                    #8ed1b2

	icy morn                     icymorn                    #c7e6d7

	ideal                        ideal                      #9cd1dc

	illusion                     illusion                   #bcd4e6

	illusion                     illusion                   #b4bcc0

	illusive                     illusive                   #d6cadd

	independence                 independence               #2f2140

	independence                 independence               #563c5c

	independence                 independence               #50404d

	indian red                   indianred                  #9e4732

	ink blue                     inkblue                    #00304e

	ink blue                     inkblue                    #36454f

	inspiration                  inspiration                #c7e6d7

	intimate mood                intimatemood               #af868e

	ionian blue                  ionianblue                 #00304e

	ionian blue                  ionianblue                 #36454f

	irish isle                   irishisle                  #27a64c

	iris leaf                    irisleaf                   #515744

	iris orchid                  irisorchid                 #e68fac

	iris orchid                  irisorchid                 #de6fa1

	iron mask                    ironmask                   #36454f

	iron mask                    ironmask                   #222222

	irresistible                 irresistible               #b3446c

	island green                 islandgreen                #8ed1b2

	italian blue                 italianblue                #66aabc

	ivory                        ivory                      #f3e5ab

	ivory white                  ivorywhite                 #f3e5ab

	jade cream                   jadecream                  #ebe8a4

	jade lime                    jadelime                   #bdda57

	jasper                       jasper                     #3a4b47

	jasper                       jasper                     #222222

	jealousy                     jealousy                   #8ed1b2

	jersey cream                 jerseycream                #f3e5ab

	jewel blue                   jewelblue                  #66aabc

	jewel green                  jewelgreen                 #317873

	joy                          joy                        #93c592

	june bud                     junebud                    #bdda57

	june bud                     junebud                    #83d37d

	june green                   junegreen                  #c9dc89

	jungle                       jungle                     #3a4b47

	juniper                      juniper                    #5e716a

	juniper                      juniper                    #3a4b47

	kaffa                        kaffa                      #674c47

	killarney green              killarneygreen             #008856

	king lear                    kinglear                   #604e81

	king neptune                 kingneptune                #70a3cc

	king's ransom                kingsransom                #d99058

	kitten's ear                 kittensear                 #f3e5ab

	lady orchid                  ladyorchid                 #915f6d

	lagoon                       lagoon                     #317873

	lake blue                    lakeblue                   #0067a5

	lake como                    lakecomo                   #436b95

	lake louise                  lakelouise                 #436b95

	lamb's wool                  lambswool                  #f0ead6

	la mer                       lamer                      #8ed1b2

	languid lavender             languidlavender            #c4c3dd

	languid lavender             languidlavender            #d6cadd

	larkspur blue                larkspurblue               #70a3cc

	larkspur purple              larkspurpurple             #604e97

	lava                         lava                       #483c32

	lava                         lava                       #3b3121

	leaf green                   leafgreen                  #27a64c

	lettuce green                lettucegreen               #7e9f2e

	life green                   lifegreen                  #4a5d23

	light hearted                lighthearted               #ebe8a4

	light mauve                  lightmauve                 #dea5a4

	light mauve                  lightmauve                 #d597ae

	light oak                    lightoak                   #c19a6b

	light old rose               lightoldrose               #f88379

	lilac                        lilac                      #b695c0

	lilac gray                   lilacgray                  #796878

	lilac hint                   lilachint                  #d6cadd

	lilac lavender               lilaclavender              #9690ab

	lilac shadow                 lilacshadow                #563c5c

	lilac shadow                 lilacshadow                #796878

	lilting green                liltinggreen               #00a693

	lily green                   lilygreen                  #b9b57d

	lily green                   lilygreen                  #c9dc89

	lime cream                   limecream                  #c9dc89

	lime yellow                  limeyellow                 #e9e450

	lime yellow                  limeyellow                 #beb72e

	lime yellow                  limeyellow                 #bdda57

	london fog                   londonfog                  #8b8589

	love bird                    lovebird                   #bdda57

	love light                   lovelight                  #eae679

	lovely                       lovely                     #6aab8e

	lover's knot                 loversknot                 #efbbcc

	lover's note                 loversnote                 #bcd4e6

	lucerne blue                 lucerneblue                #8791bf

	lullaby                      lullaby                    #dfede8

	lullaby                      lullaby                    #b2beb5

	lullaby                      lullaby                    #f2f3f4

	lullaby                      lullaby                    #b9b8b5

	lush gray                    lushgray                   #317873

	lush green                   lushgreen                  #3eb489

	lustrous yellow              lustrousyellow             #eae679

	lyons blue                   lyonsblue                  #30267a

	lyons blue                   lyonsblue                  #545aa7

	lyre blue                    lyreblue                   #367588

	magenta                      magenta                    #a8516e

	magenta rose                 magentarose                #673147

	magical                      magical                    #e8e3e5

	magic moon                   magicmoon                  #66aabc

	magic moon                   magicmoon                  #91a3b0

	maid of orleans              maidoforleans              #d5badb

	maid of orleans              maidoforleans              #d6cadd

	majolica                     majolica                   #00304e

	mandarin orange              mandarinorange             #d9603b

	mandarin orange              mandarinorange             #ed872d

	marble                       marble                     #3a4b47

	marco polo                   marcopolo                  #367588

	marine blue                  marineblue                 #367588

	marine blue                  marineblue                 #004958

	marine corps blue            marinecorpsblue            #00304e

	marine glow                  marineglow                 #c7e6d7

	market green                 marketgreen                #c7e6d7

	martinique                   martinique                 #b9b459

	mauve decade                 mauvedecade                #915f6d

	mauve mist                   mauvemist                  #c3a6b1

	mauve orchid                 mauveorchid                #af868e

	mauve taupe                  mauvetaupe                 #915f6d

	mauvette                     mauvette                   #e8ccd7

	mayflower                    mayflower                  #de6fa1

	mayflower                    mayflower                  #c17e91

	meadow green                 meadowgreen                #3eb489

	meadow green                 meadowgreen                #6aab8e

	meadow mist                  meadowmist                 #8da399

	mellow buff                  mellowbuff                 #fad6a5

	mellow buff                  mellowbuff                 #f3e5ab

	mellow green                 mellowgreen                #eae679

	mellow mauve                 mellowmauve                #915f6d

	mellow mood                  mellowmood                 #aa98a9

	mellow yellow                mellowyellow               #f8de7e

	mellow yellow                mellowyellow               #f3e5ab

	mellow yellow                mellowyellow               #eae679

	mellow yellow                mellowyellow               #ebe8a4

	melodious                    melodious                  #91a3b0

	memory lane                  memorylane                 #dfede8

	merry green                  merrygreen                 #008856

	midnight                     midnight                   #00304e

	midnight                     midnight                   #36454f

	midnight bronze              midnightbronze             #c1b6b3

	midseason                    midseason                  #d6cadd

	mignonette                   mignonette                 #8a9a5b

	milano blue                  milanoblue                 #536878

	milano blue                  milanoblue                 #8c92ac

	milky green                  milkygreen                 #dfede8

	mince meat                   mincemeat                  #674c47

	ming                         ming                       #007959

	mint lime                    mintlime                   #93c592

	mint lime                    mintlime                   #c7e6d7

	mission white                missionwhite               #ecd5c5

	mission white                missionwhite               #fad6a5

	misted yellow                mistedyellow               #c9ae5d

	mistletoe                    mistletoe                  #8a9a5b

	mistletoe                    mistletoe                  #8f9779

	misty cream                  mistycream                 #f3e5ab

	misty cream                  mistycream                 #f0ead6

	misty green                  mistygreen                 #8f9779

	misty jade                   mistyjade                  #eae679

	misty jade                   mistyjade                  #ebe8a4

	misty jade                   mistyjade                  #c9dc89

	misty lilac                  mistylilac                 #b695c0

	misty lilac                  mistylilac                 #aa98a9

	misty morn                   mistymorn                  #f0ead6

	misty morn                   mistymorn                  #dfede8

	misty morn                   mistymorn                  #f2f3f4

	misty rose                   mistyrose                  #ecd5c5

	modest                       modest                     #b2beb5

	mogul                        mogul                      #8c82b6

	mohawk                       mohawk                     #79443b

	mohawk trail                 mohawktrail                #3a4b47

	monaco                       monaco                     #66ada4

	monastral blue               monastralblue              #00304e

	monastral blue               monastralblue              #4e5180

	monsignor                    monsignor                  #9e4f88

	monticello green             monticellogreen            #355e3b

	monticello rose              monticellorose             #d9a6a9

	montrose yellow              montroseyellow             #bdda57

	mood beige                   moodbeige                  #c2b280

	mood lilac                   moodlilac                  #86608e

	mood violet                  moodviolet                 #796878

	moonbeam                     moonbeam                   #bfb9bd

	moonlight                    moonlight                  #ecd5c5

	moonlight bay                moonlightbay               #96ded1

	moonlit blue                 moonlitblue                #bcd4e6

	moonlit blue                 moonlitblue                #b4bcc0

	moonlit water                moonlitwater               #91a3b0

	moonlit water                moonlitwater               #8c92ac

	moonmist                     moonmist                   #c1b6b3

	morning glory                morningglory               #de6fa1

	morning mist                 morningmist                #c2ac99

	moth                         moth                       #bfb8a5

	moth                         moth                       #dadfb7

	mountain haze                mountainhaze               #dea5a4

	mountain peak blue           mountainpeakblue           #bcd4e6

	mountain top                 mountaintop                #515744

	mountain top                 mountaintop                #31362b

	mulberry                     mulberry                   #796878

	murmur                       murmur                     #f3e5ab

	murmur                       murmur                     #bfb8a5

	muse                         muse                       #c9dc89

	mushroom                     mushroom                   #f3e5ab

	mushroom                     mushroom                   #f0ead6

	mustard                      mustard                    #ab9144

	mustard cream                mustardcream               #f8de7e

	mustard cream                mustardcream               #f3e5ab

	muted yellow                 mutedyellow                #f8de7e

	muted yellow                 mutedyellow                #eae679

	myrtle green                 myrtlegreen                #5e716a

	mystic blue                  mysticblue                 #bcd4e6

	mystic purple                mysticpurple               #915c83

	mystic white                 mysticwhite                #e9e9ed

	myth                         myth                       #d6cadd

	myth blue                    mythblue                   #536878

	myth blue                    mythblue                   #51585e

	nabob                        nabob                      #3a4b47

	nabob                        nabob                      #36454f

	nabob                        nabob                      #51585e

	naid                         naid                       #00a693

	naid                         naid                       #96ded1

	naid                         naid                       #66ada4

	naive                        naive                      #dfede8

	napoleon                     napoleon                   #272458

	nasturtium                   nasturtium                 #ffc14f

	nasturtium buff              nasturtiumbuff             #e3a857

	native blue                  nativeblue                 #004b49

	neon blue                    neonblue                   #239eba

	neopolitan night             neopolitannight            #436b95

	neopolitan night             neopolitannight            #4e5180

	neutral                      neutral                    #f3e5ab

	neutral                      neutral                    #f0ead6

	new blue                     newblue                    #e9e9ed

	niagara                      niagara                    #239eba

	night blue                   nightblue                  #004958

	night cloud                  nightcloud                 #e9e9ed

	night fighter                nightfighter               #51585e

	night fighter                nightfighter               #5d555b

	night fighter                nightfighter               #555555

	night horizon                nighthorizon               #202428

	night horizon                nighthorizon               #222222

	night magic                  nightmagic                 #aa98a9

	nightshade                   nightshade                 #50404d

	nightshade                   nightshade                 #5d555b

	night watch                  nightwatch                 #1a2421

	nil                          nil                        #f2f3f4

	nocturne                     nocturne                   #bfb9bd

	noel                         noel                       #3a4b47

	nomad brown                  nomadbrown                 #3e322c

	norse blue                   norseblue                  #4997d0

	norse blue                   norseblue                  #6c79b8

	north blue                   northblue                  #007791

	northern skies               northernskies              #bcd4e6

	north green                  northgreen                 #5e716a

	north green                  northgreen                 #317873

	north sea                    northsea                   #51585e

	norway pine                  norwaypine                 #679267

	nubian brown                 nubianbrown                #635147

	nymph pink                   nymphpink                  #d597ae

	oak leaf                     oakleaf                    #515744

	ocean wave                   oceanwave                  #66ada4

	octoroon rose                octoroonrose               #905d5d

	octoroon rose                octoroonrose               #977f73

	old coral                    oldcoral                   #ab4e52

	old gold                     oldgold                    #eaa221

	old gold                     oldgold                    #e3a857

	old gold                     oldgold                    #d4af37

	old lavender                 oldlavender                #d6cadd

	old master green             oldmastergreen             #515744

	old rose                     oldrose                    #c08081

	olive glow                   oliveglow                  #ebe8a4

	olive glow                   oliveglow                  #dadfb7

	olive hint                   olivehint                  #ebe8a4

	olive hint                   olivehint                  #dadfb7

	ombre                        ombre                      #36454f

	ombre                        ombre                      #222222

	opal green                   opalgreen                  #317873

	opera blue                   operablue                  #00304e

	opera blue                   operablue                  #4e5180

	opera mauve                  operamauve                 #b784a7

	opera pink                   operapink                  #f4c2c2

	orange                       orange                     #ed872d

	orange blush                 orangeblush                #fad6a5

	orange cream                 orangecream                #f3e5ab

	orchid                       orchid                     #c3a6b1

	orchid lane                  orchidlane                 #d5badb

	orchid leaf                  orchidleaf                 #d6cadd

	orchid mauve                 orchidmauve                #c17e91

	orchid night                 orchidnight                #905d5d

	orchid night                 orchidnight                #915f6d

	orchid pink                  orchidpink                 #f9ccca

	orchid pink                  orchidpink                 #dea5a4

	orchid smoke                 orchidsmoke                #c3a6b1

	oriental bronze              orientalbronze             #6c541e

	oriental sand                orientalsand               #8c8767

	padre brown                  padrebrown                 #3e1d1e

	palace blue                  palaceblue                 #0067a5

	palace blue                  palaceblue                 #436b95

	pale star                    palestar                   #eae679

	pale star                    palestar                   #ebe8a4

	pale water                   palewater                  #8ed1b2

	paloma                       paloma                     #a67b5b

	paloma                       paloma                     #9cd1dc

	pan                          pan                        #5e716a

	pan                          pan                        #317873

	panama blue                  panamablue                 #b3bce2

	pansy purple                 pansypurple                #915c83

	pansy purple                 pansypurple                #5d3954

	pansy yellow                 pansyyellow                #fada5e

	paprica                      paprica                    #9e4732

	paradise green               paradisegreen              #b6e5af

	paradise green               paradisegreen              #93c592

	paramount                    paramount                  #239eba

	paramount                    paramount                  #66aabc

	paramour                     paramour                   #66aabc

	parrakeet                    parrakeet                  #3eb489

	peace                        peace                      #f0ead6

	peace-maker                  peacemaker                 #dfede8

	peach amber                  peachamber                 #d9a6a9

	peach bisque                 peachbisque                #a87c6d

	peach bud                    peachbud                   #f4c2c2

	peach cream                  peachcream                 #fad6a5

	peach gray                   peachgray                  #eae3e1

	peach gray                   peachgray                  #c1b6b3

	peach gray                   peachgray                  #ecd5c5

	peach pink                   peachpink                  #f4c2c2

	peach rust                   peachrust                  #cb6d51

	peach sand                   peachsand                  #c1b6b3

	peach sand                   peachsand                  #8e8279

	peacock blue                 peacockblue                #004958

	pea green                    peagreen                   #8a9a5b

	pearl cream                  pearlcream                 #eae3e1

	pearly gates                 pearlygates                #f0ead6

	peasant blue                 peasantblue                #00304e

	peasant blue                 peasantblue                #36454f

	persian green                persiangreen               #00a693

	persian gulf                 persiangulf                #5e716a

	persian gulf                 persiangulf                #317873

	persian melon                persianmelon               #cb6d51

	persian rose                 persianrose                #ce4676

	persian rose                 persianrose                #b3446c

	personal                     personal                   #e8ccd7

	petunia                      petunia                    #86608e

	pewter                       pewter                     #c1b6b3

	pewter cream                 pewtercream                #eae3e1

	phantom blue                 phantomblue                #9cd1dc

	phantom blue                 phantomblue                #bcd4e6

	phantom green                phantomgreen               #dfede8

	phlox pink                   phloxpink                  #de6fa1

	picturesque                  picturesque                #00a693

	picturesque                  picturesque                #96ded1

	pine frost                   pinefrost                  #8ed1b2

	pink carnation               pinkcarnation              #ffc8d6

	pink dust                    pinkdust                   #f4c2c2

	pink dust                    pinkdust                   #ecd5c5

	pink icing                   pinkicing                  #efbbcc

	pink jewel                   pinkjewel                  #f88379

	pink lavender                pinklavender               #e8ccd7

	pink lily                    pinklily                   #f9ccca

	pink mist                    pinkmist                   #e8ccd7

	pink orchid                  pinkorchid                 #e8ccd7

	pink powder                  pinkpowder                 #ffc8d6

	pink rapture                 pinkrapture                #9e4f88

	pink shock                   pinkshock                  #b3446c

	pinocchio                    pinocchio                  #f4c2c2

	piquant                      piquant                    #96ded1

	piquant green                piquantgreen               #8a9a5b

	pistachio cream              pistachiocream             #bdda57

	placid                       placid                     #e8e3e5

	plantation                   plantation                 #79443b

	plantation yellow            plantationyellow           #fada5e

	platonic                     platonic                   #91a3b0

	plenty bright                plentybright               #007a74

	plumbago blue                plumbagoblue               #bcd4e6

	plumbago blue                plumbagoblue               #c0c8e1

	plume                        plume                      #96ded1

	poet's yellow                poetsyellow                #eae679

	polar bear                   polarbear                  #66aabc

	pom pom                      pompom                     #f8de7e

	pom pom                      pompom                     #eae679

	pool green                   poolgreen                  #00a693

	porcelain green              porcelaingreen             #6aab8e

	pouf de vent                 poufdevent                 #efbbcc

	pouf de vent                 poufdevent                 #e8ccd7

	prairie sunset               prairiesunset              #d9a6a9

	prairie sunset               prairiesunset              #fab57f

	primeval                     primeval                   #3b7861

	primrose yellow              primroseyellow             #e9e450

	princely blue                princelyblue               #b3bce2

	princely blue                princelyblue               #c0c8e1

	princess                     princess                   #8c82b6

	priscilla blue               priscillablue              #367588

	prism pink                   prismpink                  #efbbcc

	prism violet                 prismviolet                #604e97

	profound                     profound                   #722f37

	profound blue                profoundblue               #536878

	profound blue                profoundblue               #8c92ac

	promise                      promise                    #f0ead6

	promised land                promisedland               #3eb489

	promised land                promisedland               #007959

	promised land                promisedland               #00a693

	promised land                promisedland               #007a74

	promise green                promisegreen               #c7e6d7

	prudence                     prudence                   #66ada4

	prudence                     prudence                   #91a3b0

	pumpkin                      pumpkin                    #d99058

	puritan                      puritan                    #536878

	puritan                      puritan                    #51585e

	purple aster                 purpleaster                #915c83

	purple heather               purpleheather              #86608e

	purple lake                  purplelake                 #673147

	purple night                 purplenight                #36454f

	purple ode                   purpleode                  #9690ab

	quail                        quail                      #8e8279

	quaker                       quaker                     #8b8589

	quality                      quality                    #8c82b6

	quality pink                 qualitypink                #e68fac

	quality pink                 qualitypink                #d597ae

	queen anne                   queenanne                  #8a9a5b

	queen blue                   queenblue                  #436b95

	queen coral                  queencoral                 #f88379

	queen coral                  queencoral                 #f4c2c2

	queen pink                   queenpink                  #e8ccd7

	quiet                        quiet                      #dfede8

	radiance                     radiance                   #fada5e

	radiant                      radiant                    #f88379

	radiant                      radiant                    #cb6d51

	radiant orchid               radiantorchid              #d6cadd

	rainbow mist                 rainbowmist                #c7ada3

	raisin                       raisin                     #43302e

	rapture                      rapture                    #ab4e52

	raspberry glace              raspberryglace             #915f6d

	raven                        raven                      #222222

	reed                         reed                       #dadfb7

	reflection                   reflection                 #9cd1dc

	regal orchid                 regalorchid                #b695c0

	remote                       remote                     #5e716a

	repose                       repose                     #8f9779

	restrained blue              restrainedblue             #bcd4e6

	retreat                      retreat                    #91a3b0

	retreat                      retreat                    #81878b

	rhapsody blue                rhapsodyblue               #36454f

	rigi blue                    rigiblue                   #536878

	rill                         rill                       #66ada4

	rio blue                     rioblue                    #91a3b0

	rio grande                   riogrande                  #c2b280

	river mist                   rivermist                  #536878

	river nile                   rivernile                  #317873

	riviera                      riviera                    #436b95

	rivulet blue                 rivuletblue                #66aabc

	robin egg                    robinegg                   #96ded1

	romance                      romance                    #e8ccd7

	romance                      romance                    #9690ab

	romance                      romance                    #796878

	roman purple                 romanpurple                #50404d

	roman purple                 romanpurple                #5d555b

	roman rose                   romanrose                  #43302e

	roman tan                    romantan                   #a87c6d

	romantic blue                romanticblue               #a1caf1

	romantic blue                romanticblue               #70a3cc

	room green                   roomgreen                  #b2beb5

	rosario                      rosario                    #d9a6a9

	rosea                        rosea                      #efbbcc

	rose ash                     roseash                    #eae3e1

	rose ash                     roseash                    #ecd5c5

	rose caroline                rosecaroline               #d9a6a9

	rose castor                  rosecastor                 #905d5d

	rose castor                  rosecastor                 #8f817f

	rose cloud                   rosecloud                  #dea5a4

	rose dust                    rosedust                   #ecd5c5

	rose garden                  rosegarden                 #de6fa1

	rose glory                   roseglory                  #e4717a

	rose leaf                    roseleaf                   #ea9399

	rose marie                   rosemarie                  #de6fa1

	rose mist                    rosemist                   #ad8884

	rose mist                    rosemist                   #c7ada3

	rose morn                    rosemorn                   #f9ccca

	rose morn                    rosemorn                   #ead8d7

	rose morn                    rosemorn                   #f4c2c2

	rose morn                    rosemorn                   #ecd5c5

	rose muse                    rosemuse                   #c7ada3

	rose nude                    rosenude                   #ecd5c5

	rose pearl                   rosepearl                  #ead8d7

	rose pearl                   rosepearl                  #ecd5c5

	rose shadow                  roseshadow                 #ead8d7

	rose shadow                  roseshadow                 #ecd5c5

	rose smoke                   rosesmoke                  #ad8884

	rose smoke                   rosesmoke                  #8f817f

	rose stain                   rosestain                  #905d5d

	rosy pink                    rosypink                   #f9ccca

	royal lilac                  royallilac                 #86608e

	royal robe                   royalrobe                  #2f2140

	royal violet                 royalviolet                #673147

	ruby lake                    rubylake                   #673147

	ruffled petunia              ruffledpetunia             #e68fac

	russet leaf                  russetleaf                 #a18f60

	russet yellow                russetyellow               #c9ae5d

	russian blue                 russianblue                #91a3b0

	russian blue                 russianblue                #81878b

	rust rose                    rustrose                   #ab4e52

	sable                        sable                      #6f4e37

	saga blue                    sagablue                   #91a3b0

	sage                         sage                       #8a9a5b

	sailor                       sailor                     #282022

	salmon buff                  salmonbuff                 #d9a6a9

	salmon flush                 salmonflush                #f4c2c2

	salmon pink                  salmonpink                 #f4c2c2

	salmon rose                  salmonrose                 #f88379

	salome blue                  salomeblue                 #00a693

	salome green                 salomegreen                #3eb489

	salome green                 salomegreen                #8ed1b2

	salome pink                  salomepink                 #ea9399

	sandlewood                   sandlewood                 #a67b5b

	sandrift                     sandrift                   #8e8279

	sand stucco                  sandstucco                 #977f73

	santa anita green            santaanitagreen            #66ada4

	saxe blue                    saxeblue                   #367588

	saxe blue                    saxeblue                   #536878

	scarab                       scarab                     #317873

	scarlet                      scarlet                    #e25822

	scotch blue                  scotchblue                 #554c69

	scotch mist                  scotchmist                 #b2beb5

	scotch mist                  scotchmist                 #bfb8a5

	scotch mist                  scotchmist                 #dadfb7

	sea foam                     seafoam                    #f0ead6

	sea foam                     seafoam                    #dfede8

	sea fog                      seafog                     #d6cadd

	sea fog                      seafog                     #bfb9bd

	sea mist                     seamist                    #dadfb7

	seance                       seance                     #e8ccd7

	seclusion                    seclusion                  #4e5755

	secret                       secret                     #796878

	sentimental mood             sentimentalmood            #bcd4e6

	sentimental mood             sentimentalmood            #c0c8e1

	serene                       serene                     #ecd5c5

	serenity                     serenity                   #d597ae

	seville                      seville                    #8a9a5b

	sevres                       sevres                     #00a1c2

	sevres                       sevres                     #0067a5

	shadow aqua                  shadowaqua                 #5e716a

	shadow beige                 shadowbeige                #967117

	shadow blue                  shadowblue                 #91a3b0

	shadow green                 shadowgreen                #5e716a

	shadow green                 shadowgreen                #3a4b47

	shadow lilac                 shadowlilac                #796878

	shadow lime                  shadowlime                 #c9dc89

	shadow mauve                 shadowmauve                #796878

	shadow olive                 shadowolive                #b9b57d

	shamrock                     shamrock                   #44944a

	shell coral                  shellcoral                 #f4c2c2

	shell coral                  shellcoral                 #ecd5c5

	shine                        shine                      #ebe8a4

	shining                      shining                    #eae679

	shore line                   shoreline                  #536878

	shrimp pink                  shrimppink                 #f88379

	siam sand                    siamsand                   #c2b280

	sierra                       sierra                     #9e4732

	sierra                       sierra                     #80461b

	silent night                 silentnight                #5e716a

	silver blue                  silverblue                 #bcd4e6

	silver blue                  silverblue                 #c0c8e1

	silver cloud                 silvercloud                #bcd4e6

	silver cloud                 silvercloud                #b4bcc0

	silver green                 silvergreen                #dadfb7

	silver lining                silverlining               #bfb8a5

	silver lining                silverlining               #b9b8b5

	silver night                 silvernight                #aa98a9

	silver pine                  silverpine                 #5e716a

	silver pink                  silverpink                 #c4aead

	silver pink                  silverpink                 #c7ada3

	silver salmon                silversalmon               #c7ada3

	silver sky                   silversky                  #e8e3e5

	silver sky                   silversky                  #bfb9bd

	silver wing                  silverwing                 #bfb9bd

	silver wing                  silverwing                 #8b8589

	singing blue                 singingblue                #239eba

	singing blue                 singingblue                #66aabc

	sky                          sky                        #8f9779

	sky cloud                    skycloud                   #b4bcc0

	sky green                    skygreen                   #96ded1

	sky lane                     skylane                    #c7e6d7

	slate                        slate                      #5d555b

	slate                        slate                      #555555

	slate blue                   slateblue                  #536878

	slate blue                   slateblue                  #51585e

	slate citron                 slatecitron                #8a9a5b

	slate green                  slategreen                 #5e716a

	slate orchid                 slateorchid                #796878

	slate rose                   slaterose                  #905d5d

	slate turquoise              slateturquoise             #367588

	slate turquoise              slateturquoise             #536878

	slate violet                 slateviolet                #796878

	sleepy hollow                sleepyhollow               #8da399

	sleepy hollow                sleepyhollow               #91a3b0

	sleigh bells                 sleighbells                #9cd1dc

	sleigh bells                 sleighbells                #bcd4e6

	smile                        smile                      #f0ead6

	smiles                       smiles                     #f4c2c2

	smog                         smog                       #ae9b82

	smoke                        smoke                      #91a3b0

	smoke blue                   smokeblue                  #8c92ac

	smoke pine                   smokepine                  #8f9779

	smoke pine                   smokepine                  #b2beb5

	smoke ring                   smokering                  #91a3b0

	smokestain rose              smokestainrose             #ad8884

	snow green                   snowgreen                  #c7e6d7

	snow green                   snowgreen                  #bcd4e6

	snow green                   snowgreen                  #b4bcc0

	solitary                     solitary                   #dfede8

	solitary                     solitary                   #b2beb5

	solitary                     solitary                   #f2f3f4

	solitary                     solitary                   #b9b8b5

	solitary blue                solitaryblue               #536878

	somber blue                  somberblue                 #536878

	sonata                       sonata                     #f4c2c2

	song of norway               songofnorway               #00a693

	sophisticated lady           sophisticatedlady          #b695c0

	sorcerer                     sorcerer                   #554c69

	sorcerer                     sorcerer                   #796878

	sorcerer                     sorcerer                   #36454f

	sorcerer                     sorcerer                   #202830

	sorcerer                     sorcerer                   #202428

	sorrento                     sorrento                   #317873

	southern rose                southernrose               #a87c6d

	southern sun                 southernsun                #fada5e

	southern sun                 southernsun                #f8de7e

	souvenir                     souvenir                   #c4c3dd

	sovereign blue               sovereignblue              #70a3cc

	sovereign blue               sovereignblue              #8791bf

	spanish blue                 spanishblue                #317873

	spanish gold                 spanishgold                #e3a857

	spanish white                spanishwhite               #fad6a5

	sparkle                      sparkle                    #9cd1dc

	sparrow                      sparrow                    #7e6d5a

	spectra blue                 spectrablue                #30267a

	spectra green                spectragreen               #004b49

	spectra red                  spectrared                 #be0032

	spectra rose                 spectrarose                #ce4676

	spectra yellow               spectrayellow              #f3c300

	spice                        spice                      #ae6938

	spice                        spice                      #a67b5b

	spiritual blue               spiritualblue              #bcd4e6

	spitfire                     spitfire                   #ab4e52

	spray                        spray                      #96ded1

	spring                       spring                     #83d37d

	spring bud                   springbud                  #c9dc89

	spring dream                 springdream                #eae679

	spring dream                 springdream                #ebe8a4

	spring eve                   springeve                  #eae679

	spring eve                   springeve                  #bdda57

	spring eve                   springeve                  #c9dc89

	spring flower                springflower               #e9e450

	spring stream                springstream               #96ded1

	spring yellow                springyellow               #f3e5ab

	starch white                 starchwhite                #bcd4e6

	static                       static                     #91a3b0

	steam blue                   steamblue                  #e9e9ed

	steel blue                   steelblue                  #66aabc

	stellar                      stellar                    #efbbcc

	sterling blue                sterlingblue               #91a3b0

	sterling blue                sterlingblue               #b4bcc0

	stoic                        stoic                      #222222

	storm                        storm                      #536878

	stormy night                 stormynight                #36454f

	stratosphere                 stratosphere               #536878

	stratosphere                 stratosphere               #51585e

	straw yellow                 strawyellow                #f3e5ab

	streamlet                    streamlet                  #96ded1

	streamline                   streamline                 #96ded1

	string                       string                     #f0ead6

	style gray                   stylegray                  #536878

	sublime                      sublime                    #91a3b0

	sublime                      sublime                    #8c92ac

	suet                         suet                       #f0ead6

	suez blue                    suezblue                   #36454f

	suez green                   suezgreen                  #317873

	suggestion                   suggestion                 #96ded1

	sulphate green               sulphategreen              #00a693

	sulphate green               sulphategreen              #66ada4

	sulphur                      sulphur                    #eae679

	sultana                      sultana                    #905d5d

	sultan sand                  sultansand                 #c19a6b

	summer green                 summergreen                #3eb489

	summer green                 summergreen                #8ed1b2

	summer shower                summershower               #c7e6d7

	summer sun                   summersun                  #e9e450

	sunburst                     sunburst                   #fbc97f

	sunburst                     sunburst                   #e3a857

	sunburst                     sunburst                   #fad6a5

	sundown                      sundown                    #f4c2c2

	sundown                      sundown                    #d9a6a9

	sundown                      sundown                    #fad6a5

	sung green                   sunggreen                  #8f9779

	sun glow                     sunglow                    #f8de7e

	sun glow                     sunglow                    #f3e5ab

	sun god                      sungod                     #d9603b

	sun green                    sungreen                   #ebe8a4

	sun rose                     sunrose                    #f9ccca

	sunset cream                 sunsetcream                #f0ead6

	sunshine                     sunshine                   #eae679

	sun yellow                   sunyellow                  #e9e450

	sun yellow                   sunyellow                  #eae679

	superior                     superior                   #317873

	supreme                      supreme                    #4997d0

	surf spray                   surfspray                  #dfede8

	surrender                    surrender                  #b695c0

	sussanqua pink               sussanquapink              #ffc8d6

	sussanqua pink               sussanquapink              #e68fac

	swank                        swank                      #c4c3dd

	swank                        swank                      #d6cadd

	sweet blue                   sweetblue                  #bcd4e6

	sweet lady                   sweetlady                  #8c82b6

	sweet lavender               sweetlavender              #c4c3dd

	sweet pea pink               sweetpeapink               #915f6d

	swiss blue                   swissblue                  #8c92ac

	swiss rose                   swissrose                  #905d5d

	sylvan                       sylvan                     #dadfb7

	tabu                         tabu                       #536878

	talisman                     talisman                   #fab57f

	talisman                     talisman                   #d99058

	tangerine                    tangerine                  #d9603b

	tangerine                    tangerine                  #ed872d

	tango                        tango                      #e4717a

	tapestry beige               tapestrybeige              #977f73

	tapestry red                 tapestryred                #722f37

	taupe rose                   tauperose                  #5c504f

	taupe rose                   tauperose                  #674c47

	taupe sand                   taupesand                  #967117

	teal blue                    tealblue                   #367588

	teen age pink                teenagepink                #efbbcc

	television blue              televisionblue             #36454f

	tempest                      tempest                    #50404d

	tempest blue                 tempestblue                #51585e

	temple                       temple                     #8f9779

	temptation                   temptation                 #d6cadd

	tete-a-tete                  teteatete                  #9cd1dc

	thames river                 thamesriver                #91a3b0

	thames river                 thamesriver                #b4bcc0

	theatrical blue              theatricalblue             #436b95

	thistle bloom                thistlebloom               #a8516e

	thistle down                 thistledown                #e8ccd7

	tobacco brown                tobaccobrown               #674c47

	tomato red                   tomatored                  #be0032

	topaz amber                  topazamber                 #d99058

	torchlight                   torchlight                 #be0032

	torchlight                   torchlight                 #bc3f4a

	toreador                     toreador                   #bc3f4a

	tourmaline green             tourmalinegreen            #c7e6d7

	tourmaline green             tourmalinegreen            #96ded1

	tourmaline pink              tourmalinepink             #ffc8d6

	tourmaline pink              tourmalinepink             #efbbcc

	trade winds                  tradewinds                 #536878

	trail green                  trailgreen                 #1b4d3e

	trail green                  trailgreen                 #3a4b47

	tranquil green               tranquilgreen              #3a4b47

	tranquil green               tranquilgreen              #36454f

	transatlantic blue           transatlanticblue          #202830

	translucent blue             translucentblue            #91a3b0

	transparent yellow           transparentyellow          #f3e5ab

	transparent yellow           transparentyellow          #f0ead6

	trellis                      trellis                    #93c592

	tropic night                 tropicnight                #836479

	troubador                    troubador                  #be0032

	troubador                    troubador                  #bc3f4a

	tulip yellow                 tulipyellow                #fada5e

	tumbleweed                   tumbleweed                 #f3e5ab

	tumbleweed                   tumbleweed                 #bfb8a5

	turf green                   turfgreen                  #44944a

	turf green                   turfgreen                  #679267

	turquoise blue               turquoiseblue              #66ada4

	tuscan sand                  tuscansand                 #967117

	twilight mood                twilightmood               #bcd4e6

	twilight sun                 twilightsun                #f3e5ab

	twilight sun                 twilightsun                #dadfb7

	twinkle                      twinkle                    #bcd4e6

	tyrian blue                  tyrianblue                 #536878

	ultramarine                  ultramarine                #30267a

	uniform blue                 uniformblue                #00304e

	unique                       unique                     #ebe8a4

	universal                    universal                  #36454f

	vagabond                     vagabond                   #317873

	valencia rose                valenciarose               #c08081

	valor green                  valorgreen                 #36454f

	vamp                         vamp                       #efbbcc

	vanda                        vanda                      #aa8a9e

	vanilla custard              vanillacustard             #f8de7e

	vanilla custard              vanillacustard             #f3e5ab

	vapor blue                   vaporblue                  #e9e9ed

	vatican                      vatican                    #673147

	veiled sun                   veiledsun                  #e3a857

	veiled sun                   veiledsun                  #d4af37

	venetian rose                venetianrose               #905d5d

	venetian turquoise           venetianturquoise          #66ada4

	venice                       venice                     #8da399

	venice blue                  veniceblue                 #96ded1

	venus blue                   venusblue                  #bcd4e6

	venus blue                   venusblue                  #e9e9ed

	verbena lavender             verbenalavender            #915c83

	verbena lavender             verbenalavender            #915f6d

	verdant                      verdant                    #8db600

	verdugo                      verdugo                    #bdda57

	verdugo                      verdugo                    #c9dc89

	vermilion                    vermilion                  #d9603b

	vesta                        vesta                      #ea9399

	vesta                        vesta                      #f9ccca

	vesta                        vesta                      #dea5a4

	vibrant green                vibrantgreen               #83d37d

	victoria                     victoria                   #f4c2c2

	viking                       viking                     #36454f

	viola                        viola                      #b695c0

	violet leaf                  violetleaf                 #4a5d23

	violet pansy                 violetpansy                #50404d

	virginia lavender            virginialavender           #e8e3e5

	vista green                  vistagreen                 #8f9779

	vivid                        vivid                      #c17e91

	vivid turquoise              vividturquoise             #007a74

	wafted feather               waftedfeather              #e8e3e5

	wafted feather               waftedfeather              #bfb9bd

	walnut                       walnut                     #a67b5b

	walnut cream                 walnutcream                #fad6a5

	wan blue                     wanblue                    #e9e9ed

	wan blue                     wanblue                    #e8e3e5

	water fall                   waterfall                  #367588

	water green                  watergreen                 #dadfb7

	watteau                      watteau                    #66aabc

	whimsical                    whimsical                  #b695c0

	white clover                 whiteclover                #f0ead6

	white fawn                   whitefawn                  #fad6a5

	white jade                   whitejade                  #f4c2c2

	white jade                   whitejade                  #ecd5c5

	white light                  whitelight                 #bcd4e6

	white mist                   whitemist                  #f4c2c2

	white mist                   whitemist                  #ecd5c5

	white smoke                  whitesmoke                 #b4bcc0

	white swan                   whiteswan                  #bcd4e6

	white swan                   whiteswan                  #c0c8e1

	wild orchid                  wildorchid                 #b784a7

	windflower                   windflower                 #915f6d

	wineberry                    wineberry                  #796878

	wineberry                    wineberry                  #50404d

	winsome                      winsome                    #d6cadd

	winsome blue                 winsomeblue                #66aabc

	winter pear                  winterpear                 #8a9a5b

	winter sky                   wintersky                  #bcd4e6

	winter sun                   wintersun                  #eae679

	winter white                 winterwhite                #e4717a

	winter yellow                winteryellow               #f3e5ab

	winter yellow                winteryellow               #c2b280

	wisteria                     wisteria                   #8c82b6

	wisteria gray                wisteriagray               #796878

	wisteria mist                wisteriamist               #796878

	withered rose                witheredrose               #905d5d

	yale blue                    yaleblue                   #545aa7

	yale blue                    yaleblue                   #272458

	yale blue                    yaleblue                   #4e5180

	yama                         yama                       #66ada4

	yellow bright                yellowbright               #e9e450

	yellow bright                yellowbright               #eae679

	yellow cream                 yellowcream                #f3e5ab

	yellow essence               yellowessence              #ebe8a4

	yellow gem                   yellowgem                  #f3e5ab

	yellow mist                  yellowmist                 #967117

	yellow rose                  yellowrose                 #eae679

	yellow smoke                 yellowsmoke                #c9ae5d

	yellow smoke                 yellowsmoke                #ab9144

	yew green                    yewgreen                   #515744

	youth yellow                 youthyellow                #eae679

	yuletime                     yuletime                   #4a5d23

	yule tree                    yuletree                   #004b49

	zephyr blue                  zephyrblue                 #bcd4e6

	zephyr blue                  zephyrblue                 #91a3b0

	zephyr green                 zephyrgreen                #c7e6d7

	zest pink                    zestpink                   #ea9399

	zinnia gold                  zinniagold                 #fbc97f

	zinnia gold                  zinniagold                 #f8de7e


=cut

sub _load_color_list() {
    return [
['nbs-iscc-p:absintheyellow.87','absintheyellow','absinthe yellow',[201,174,93],'c9ae5d',13217373],
['nbs-iscc-p:abstractblue.184','abstractblue','abstract blue',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:abyss.149','abyss','abyss',[141,163,153],'8da399',9282457],
['nbs-iscc-p:acacia.150','acacia','acacia',[94,113,106],'5e716a',6189418],
['nbs-iscc-p:acaciagray.155','acaciagray','acacia gray',[125,137,132],'7d8984',8227204],
['nbs-iscc-p:acaciagreen.155','acaciagreen','acacia green',[125,137,132],'7d8984',8227204],
['nbs-iscc-p:aden.144','aden','aden',[106,171,142],'6aab8e',6990734],
['nbs-iscc-p:admiral.229','admiral','admiral',[80,64,77],'50404d',5259341],
['nbs-iscc-p:africangreen.187','africangreen','african green',[54,69,79],'36454f',3556687],
['nbs-iscc-p:africannight.47','africannight','african night',[67,48,46],'43302e',4403246],
['nbs-iscc-p:afterglow.252','afterglow','after glow',[232,204,215],'e8ccd7',15256791],
['nbs-iscc-p:ageanmist.154','ageanmist','agean mist',[178,190,181],'b2beb5',11714229],
['nbs-iscc-p:ageratum.253','ageratum','ageratum',[195,166,177],'c3a6b1',12822193],
['nbs-iscc-p:aircastleblue.184','aircastleblue','air castle blue',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:airycream.263','airycream','airy cream',[242,243,244],'f2f3f4',15922164],
['nbs-iscc-p:aladdinslamp.37','aladdinslamp','aladdin\'s lamp',[203,109,81],'cb6d51',13331793],
['nbs-iscc-p:algiersblue.173','algiersblue','algiers blue',[54,117,136],'367588',3569032],
['nbs-iscc-p:allure.181','allure','allure',[112,163,204],'70a3cc',7381964],
['nbs-iscc-p:almond.76','almond','almond',[193,154,107],'c19a6b',12687979],
['nbs-iscc-p:almondcream.73','almondcream','almond cream',[250,214,165],'fad6a5',16438949],
['nbs-iscc-p:alpineblue.198','alpineblue','alpine blue',[179,188,226],'b3bce2',11779298],
['nbs-iscc-p:alpineblue.202','alpineblue','alpine blue',[192,200,225],'c0c8e1',12634337],
['nbs-iscc-p:amaranth.259','amaranth','amaranth',[103,49,71],'673147',6762823],
['nbs-iscc-p:amaranth.262','amaranth','amaranth',[145,95,109],'915f6d',9527149],
['nbs-iscc-p:ambercoral.29','ambercoral','amber coral',[217,166,169],'d9a6a9',14263977],
['nbs-iscc-p:ambergold.76','ambergold','amber gold',[193,154,107],'c19a6b',12687979],
['nbs-iscc-p:ambergold.90','ambergold','amber gold',[194,178,128],'c2b280',12759680],
['nbs-iscc-p:ambergold.91','ambergold','amber gold',[161,143,96],'a18f60',10588000],
['nbs-iscc-p:ambrosia.134','ambrosia','ambrosia',[182,229,175],'b6e5af',11986351],
['nbs-iscc-p:amethyst.245','amethyst','amethyst',[131,100,121],'836479',8610937],
['nbs-iscc-p:amethystorchid.222','amethystorchid','amethyst orchid',[182,149,192],'b695c0',11965888],
['nbs-iscc-p:amulet.164','amulet','amulet',[49,120,115],'317873',3242099],
['nbs-iscc-p:ancestral.263','ancestral','ancestral',[242,243,244],'f2f3f4',15922164],
['nbs-iscc-p:ancestral.264','ancestral','ancestral',[185,184,181],'b9b8b5',12171445],
['nbs-iscc-p:angelblue.184','angelblue','angel blue',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:angelwing.249','angelwing','angel wing',[239,187,204],'efbbcc',15711180],
['nbs-iscc-p:angora.73','angora','angora',[250,214,165],'fad6a5',16438949],
['nbs-iscc-p:angora.92','angora','angora',[240,234,214],'f0ead6',15788758],
['nbs-iscc-p:antiquebrass.88','antiquebrass','antique brass',[171,145,68],'ab9144',11243844],
['nbs-iscc-p:antiquebronze.107','antiquebronze','antique bronze',[102,93,30],'665d1e',6708510],
['nbs-iscc-p:antiquefuchsia.241','antiquefuchsia','antique fuchsia',[145,92,131],'915c83',9526403],
['nbs-iscc-p:antiqueyellow.87','antiqueyellow','antique yellow',[201,174,93],'c9ae5d',13217373],
['nbs-iscc-p:applegreen.120','applegreen','apple green',[138,154,91],'8a9a5b',9083483],
['nbs-iscc-p:apricot.52','apricot','apricot',[250,181,127],'fab57f',16430463],
['nbs-iscc-p:apricotcream.73','apricotcream','apricot cream',[250,214,165],'fad6a5',16438949],
['nbs-iscc-p:apricotcream.89','apricotcream','apricot cream',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:apricotice.73','apricotice','apricot ice',[250,214,165],'fad6a5',16438949],
['nbs-iscc-p:apricotsherbet.70','apricotsherbet','apricot sherbet',[251,201,127],'fbc97f',16501119],
['nbs-iscc-p:apricottan.53','apricottan','apricot tan',[217,144,88],'d99058',14258264],
['nbs-iscc-p:apricottan.71','apricottan','apricot tan',[227,168,87],'e3a857',14919767],
['nbs-iscc-p:aprilsky.162','aprilsky','april sky',[150,222,209],'96ded1',9887441],
['nbs-iscc-p:aquagray.149','aquagray','aqua gray',[141,163,153],'8da399',9282457],
['nbs-iscc-p:aquamarinegreen.164','aquamarinegreen','aquamarine green',[49,120,115],'317873',3242099],
['nbs-iscc-p:aquaqueen.162','aquaqueen','aqua queen',[150,222,209],'96ded1',9887441],
['nbs-iscc-p:aquasky.163','aquasky','aqua sky',[102,173,164],'66ada4',6729124],
['nbs-iscc-p:arborgreen.136','arborgreen','arbor green',[103,146,103],'679267',6787687],
['nbs-iscc-p:arcadia.99','arcadia','arcadia',[190,183,46],'beb72e',12498734],
['nbs-iscc-p:arcadia.102','arcadia','arcadia',[185,180,89],'b9b459',12170329],
['nbs-iscc-p:arctic.186','arctic','arctic',[83,104,120],'536878',5466232],
['nbs-iscc-p:arctic.187','arctic','arctic',[54,69,79],'36454f',3556687],
['nbs-iscc-p:arnoblue.173','arnoblue','arno blue',[54,117,136],'367588',3569032],
['nbs-iscc-p:ashesofroses.6','ashesofroses','ashes of roses ',[192,128,129],'c08081',12615809],
['nbs-iscc-p:ashesofroses.251','ashesofroses','ashes of roses ',[193,126,145],'c17e91',12680849],
['nbs-iscc-p:astheticblue.172','astheticblue','asthetic blue',[102,170,188],'66aabc',6728380],
['nbs-iscc-p:atlantis.183','atlantis','atlantis',[0,48,78],'00304e',12366],
['nbs-iscc-p:atonement.227','atonement','atonement',[170,152,169],'aa98a9',11180201],
['nbs-iscc-p:aurorapink.247','aurorapink','aurora pink',[230,143,172],'e68fac',15110060],
['nbs-iscc-p:aurorapink.250','aurorapink','aurora pink',[213,151,174],'d597ae',13997998],
['nbs-iscc-p:aurorayellow.86','aurorayellow','aurora yellow',[248,222,126],'f8de7e',16309886],
['nbs-iscc-p:autumnbrown.74','autumnbrown','autumn brown',[153,101,21],'996515',10052885],
['nbs-iscc-p:autumnbrown.95','autumnbrown','autumn brown',[108,84,30],'6c541e',7099422],
['nbs-iscc-p:autumnglory.13','autumnglory','autumn glory',[132,27,45],'841b2d',8657709],
['nbs-iscc-p:autumnglory.38','autumnglory','autumn glory',[158,71,50],'9e4732',10372914],
['nbs-iscc-p:autumnglory.72','autumnglory','autumn glory',[190,138,61],'be8a3d',12487229],
['nbs-iscc-p:autumngold.72','autumngold','autumn gold ',[190,138,61],'be8a3d',12487229],
['nbs-iscc-p:autumntan.77','autumntan','autumn tan',[130,102,68],'826644',8545860],
['nbs-iscc-p:avon.155','avon','avon',[125,137,132],'7d8984',8227204],
['nbs-iscc-p:azalea.258','azalea','azalea',[168,81,110],'a8516e',11030894],
['nbs-iscc-p:azuriteblue.173','azuriteblue','azurite blue',[54,117,136],'367588',3569032],
['nbs-iscc-p:azuriteblue.186','azuriteblue','azurite blue',[83,104,120],'536878',5466232],
['nbs-iscc-p:babyblue.180','babyblue','baby blue',[161,202,241],'a1caf1',10603249],
['nbs-iscc-p:babyblueeyes.180','babyblueeyes','baby blue eyes',[161,202,241],'a1caf1',10603249],
['nbs-iscc-p:babyblueeyes.198','babyblueeyes','baby blue eyes',[179,188,226],'b3bce2',11779298],
['nbs-iscc-p:bagdad.19','bagdad','bagdad',[144,93,93],'905d5d',9461085],
['nbs-iscc-p:balladblue.199','balladblue','ballad blue',[135,145,191],'8791bf',8884671],
['nbs-iscc-p:ballerina.209','ballerina','ballerina',[220,208,255],'dcd0ff',14471423],
['nbs-iscc-p:balmyair.184','balmyair','balmy air',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:balsamgreen.151','balsamgreen','balsam green ',[58,75,71],'3a4b47',3820359],
['nbs-iscc-p:baltic.187','baltic','baltic ',[54,69,79],'36454f',3556687],
['nbs-iscc-p:baltic.267','baltic','baltic ',[34,34,34],'222222',2236962],
['nbs-iscc-p:banana.86','banana','banana',[248,222,126],'f8de7e',16309886],
['nbs-iscc-p:banshee.150','banshee','banshee',[94,113,106],'5e716a',6189418],
['nbs-iscc-p:banshee.151','banshee','banshee',[58,75,71],'3a4b47',3820359],
['nbs-iscc-p:banshee.164','banshee','banshee',[49,120,115],'317873',3242099],
['nbs-iscc-p:banshee.165','banshee','banshee',[0,75,73],'004b49',19273],
['nbs-iscc-p:baronet.181','baronet','baronet',[112,163,204],'70a3cc',7381964],
['nbs-iscc-p:basic.165','basic','basic',[0,75,73],'004b49',19273],
['nbs-iscc-p:bathstone.73','bathstone','bath stone',[250,214,165],'fad6a5',16438949],
['nbs-iscc-p:bavarianblue.183','bavarianblue','bavarian blue',[0,48,78],'00304e',12366],
['nbs-iscc-p:bayleaf.74','bayleaf','bay leaf',[153,101,21],'996515',10052885],
['nbs-iscc-p:bayou.187','bayou','bayou',[54,69,79],'36454f',3556687],
['nbs-iscc-p:bayou.267','bayou','bayou',[34,34,34],'222222',2236962],
['nbs-iscc-p:beaublue.184','beaublue','beau blue',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:beautiful.164','beautiful','beautiful',[49,120,115],'317873',3242099],
['nbs-iscc-p:beautypink.246','beautypink','beauty pink',[255,200,214],'ffc8d6',16763094],
['nbs-iscc-p:beigegray.93','beigegray','beige gray',[191,184,165],'bfb8a5',12564645],
['nbs-iscc-p:belladonna.223','belladonna','belladonna',[134,96,142],'86608e',8806542],
['nbs-iscc-p:bellflower.211','bellflower','bellflower',[96,78,129],'604e81',6311553],
['nbs-iscc-p:berylgreen.163','berylgreen','beryl green',[102,173,164],'66ada4',6729124],
['nbs-iscc-p:besteffort.104','besteffort','best effort',[235,232,164],'ebe8a4',15460516],
['nbs-iscc-p:besteffort.121','besteffort','best effort',[218,223,183],'dadfb7',14344119],
['nbs-iscc-p:bewitch.159','bewitch','bewitch',[0,166,147],'00a693',42643],
['nbs-iscc-p:bewitchingblue.181','bewitchingblue','bewitching blue',[112,163,204],'70a3cc',7381964],
['nbs-iscc-p:billiard.161','billiard','billiard',[0,68,63],'00443f',17471],
['nbs-iscc-p:billiard.165','billiard','billiard',[0,75,73],'004b49',19273],
['nbs-iscc-p:billow.184','billow','billow',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:birch.153','birch','birch',[223,237,232],'dfede8',14675432],
['nbs-iscc-p:birdsegggreen.149','birdsegggreen','bird\'s-egg-green',[141,163,153],'8da399',9282457],
['nbs-iscc-p:birdsegggreen.163','birdsegggreen','bird\'s-egg-green',[102,173,164],'66ada4',6729124],
['nbs-iscc-p:biscaybay.173','biscaybay','biscay bay',[54,117,136],'367588',3569032],
['nbs-iscc-p:biscaybay.186','biscaybay','biscay bay',[83,104,120],'536878',5466232],
['nbs-iscc-p:bishop.211','bishop','bishop',[96,78,129],'604e81',6311553],
['nbs-iscc-p:bison.95','bison','bison',[108,84,30],'6c541e',7099422],
['nbs-iscc-p:bisque.29','bisque','bisque',[217,166,169],'d9a6a9',14263977],
['nbs-iscc-p:bisque.32','bisque','bisque',[199,173,163],'c7ada3',13086115],
['nbs-iscc-p:bittersweet.38','bittersweet','bittersweet',[158,71,50],'9e4732',10372914],
['nbs-iscc-p:bittersweetorange.35','bittersweetorange','bittersweet orange',[217,96,59],'d9603b',14245947],
['nbs-iscc-p:bittersweetorange.50','bittersweetorange','bittersweet orange',[237,135,45],'ed872d',15566637],
['nbs-iscc-p:blackberrycream.250','blackberrycream','blackberry cream',[213,151,174],'d597ae',13997998],
['nbs-iscc-p:blackforest.127','blackforest','black forest',[81,87,68],'515744',5330756],
['nbs-iscc-p:blackknight.187','blackknight','black knight',[54,69,79],'36454f',3556687],
['nbs-iscc-p:blackknight.192','blackknight','black knight',[81,88,94],'51585e',5331038],
['nbs-iscc-p:blackwater.187','blackwater','black water',[39,36,88],'272458',2565208],
['nbs-iscc-p:blackwater.267','blackwater','black water',[34,34,34],'222222',2236962],
['nbs-iscc-p:blanch.162','blanch','blanch',[150,222,209],'96ded1',9887441],
['nbs-iscc-p:blarney.139','blarney','blarney',[0,136,86],'008856',34902],
['nbs-iscc-p:blarney.141','blarney','blarney',[0,121,89],'007959',31065],
['nbs-iscc-p:blazeblue.186','blazeblue','blaze blue ',[83,104,120],'536878',5466232],
['nbs-iscc-p:blazeblue.187','blazeblue','blaze blue ',[54,69,79],'36454f',3556687],
['nbs-iscc-p:blend.121','blend','blend',[218,223,183],'dadfb7',14344119],
['nbs-iscc-p:blithe.168','blithe','blithe',[35,158,186],'239eba',2334394],
['nbs-iscc-p:blondegreen.153','blondegreen','blonde green',[223,237,232],'dfede8',14675432],
['nbs-iscc-p:blossom.104','blossom','blossom',[235,232,164],'ebe8a4',15460516],
['nbs-iscc-p:blueappeal.180','blueappeal','blue appeal',[161,202,241],'a1caf1',10603249],
['nbs-iscc-p:blueappeal.184','blueappeal','blue appeal',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:bluebell.199','bluebell','blue bell',[135,145,191],'8791bf',8884671],
['nbs-iscc-p:bluechill.184','bluechill','blue chill',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:bluedanube.169','bluedanube','blue danube',[0,119,145],'007791',30609],
['nbs-iscc-p:bluedash.186','bluedash','blue dash',[83,104,120],'536878',5466232],
['nbs-iscc-p:blueday.202','blueday','blue day',[192,200,225],'c0c8e1',12634337],
['nbs-iscc-p:bluefog.186','bluefog','blue fog',[83,104,120],'536878',5466232],
['nbs-iscc-p:bluefog.191','bluefog','blue fog',[129,135,139],'81878b',8488843],
['nbs-iscc-p:blueglow.184','blueglow','blue glow',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:bluegrotto.172','bluegrotto','blue grotto',[102,170,188],'66aabc',6728380],
['nbs-iscc-p:blueheaven.177','blueheaven','blue heaven',[73,151,208],'4997d0',4822992],
['nbs-iscc-p:blueheaven.180','blueheaven','blue heaven',[161,202,241],'a1caf1',10603249],
['nbs-iscc-p:blueheaven.181','blueheaven','blue heaven',[112,163,204],'70a3cc',7381964],
['nbs-iscc-p:bluehorizon.185','bluehorizon','blue horizon',[145,163,176],'91a3b0',9544624],
['nbs-iscc-p:bluehour.173','bluehour','blue hour',[54,117,136],'367588',3569032],
['nbs-iscc-p:blueidol.164','blueidol','blue idol',[49,120,115],'317873',3242099],
['nbs-iscc-p:bluelight.184','bluelight','blue light',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:bluelightning.178','bluelightning','blue lightning',[0,103,165],'0067a5',26533],
['nbs-iscc-p:bluemist.172','bluemist','blue mist',[102,170,188],'66aabc',6728380],
['nbs-iscc-p:bluemist.185','bluemist','blue mist',[145,163,176],'91a3b0',9544624],
['nbs-iscc-p:blueprose.171','blueprose','blue prose',[156,209,220],'9cd1dc',10277340],
['nbs-iscc-p:blueridge.180','blueridge','blue ridge',[161,202,241],'a1caf1',10603249],
['nbs-iscc-p:blueridge.198','blueridge','blue ridge',[179,188,226],'b3bce2',11779298],
['nbs-iscc-p:blueshadow.173','blueshadow','blue shadow',[54,117,136],'367588',3569032],
['nbs-iscc-p:bluespruce.145','bluespruce','blue spruce',[59,120,97],'3b7861',3897441],
['nbs-iscc-p:blueswirl.172','blueswirl','blue swirl',[102,170,188],'66aabc',6728380],
['nbs-iscc-p:bluetease.171','bluetease','blue tease',[156,209,220],'9cd1dc',10277340],
['nbs-iscc-p:blueturquoise.168','blueturquoise','blue turquoise',[35,158,186],'239eba',2334394],
['nbs-iscc-p:bluewaltz.148','bluewaltz','blue waltz ',[199,230,215],'c7e6d7',13100759],
['nbs-iscc-p:bluewaltz.162','bluewaltz','blue waltz ',[150,222,209],'96ded1',9887441],
['nbs-iscc-p:bluewash.189','bluewash','blue wash',[233,233,237],'e9e9ed',15329773],
['nbs-iscc-p:blushrose.262','blushrose','blush rose',[145,95,109],'915f6d',9527149],
['nbs-iscc-p:blushyellow.70','blushyellow','blush yellow',[251,201,127],'fbc97f',16501119],
['nbs-iscc-p:blushyellow.73','blushyellow','blush yellow',[250,214,165],'fad6a5',16438949],
['nbs-iscc-p:bog.122','bog','bog',[143,151,121],'8f9779',9410425],
['nbs-iscc-p:bohemianblue.182','bohemianblue','bohemian blue',[67,107,149],'436b95',4418453],
['nbs-iscc-p:bonnieblue.176','bonnieblue','bonnie blue',[0,161,194],'00a1c2',41410],
['nbs-iscc-p:bonnieblue.194','bonnieblue','bonnie blue',[48,38,122],'30267a',3155578],
['nbs-iscc-p:bottlegreen.145','bottlegreen','bottle green',[59,120,97],'3b7861',3897441],
['nbs-iscc-p:bottlegreen.150','bottlegreen','bottle green',[94,113,106],'5e716a',6189418],
['nbs-iscc-p:bougainvillea.254','bougainvillea','bougainvillea ',[206,70,118],'ce4676',13518454],
['nbs-iscc-p:boundingmain.181','boundingmain','bounding main',[112,163,204],'70a3cc',7381964],
['nbs-iscc-p:bouquetgreen.129','bouquetgreen','bouquet green',[39,166,76],'27a64c',2598476],
['nbs-iscc-p:bouquetgreen.130','bouquetgreen','bouquet green',[131,211,125],'83d37d',8639357],
['nbs-iscc-p:bouquetorchid.221','bouquetorchid','bouquet orchid',[213,186,219],'d5badb',14007003],
['nbs-iscc-p:bouquetorchid.226','bouquetorchid','bouquet orchid',[214,202,221],'d6cadd',14076637],
['nbs-iscc-p:bouquetyellow.86','bouquetyellow','bouquet yellow',[248,222,126],'f8de7e',16309886],
['nbs-iscc-p:brass.88','brass','brass',[171,145,68],'ab9144',11243844],
['nbs-iscc-p:brazilred.38','brazilred','brazil red',[158,71,50],'9e4732',10372914],
['nbs-iscc-p:breathofspring.104','breathofspring','breath of spring',[235,232,164],'ebe8a4',15460516],
['nbs-iscc-p:breathofspring.119','breathofspring','breath of spring',[201,220,137],'c9dc89',13229193],
['nbs-iscc-p:bridesmaidpink.249','bridesmaidpink','bridesmaid pink',[239,187,204],'efbbcc',15711180],
['nbs-iscc-p:brightsun.82','brightsun','bright sun',[243,195,0],'f3c300',15975168],
['nbs-iscc-p:brightsun.83','brightsun','bright sun',[250,218,94],'fada5e',16439902],
['nbs-iscc-p:brilliantgreen.165','brilliantgreen','brilliant green',[0,75,73],'004b49',19273],
['nbs-iscc-p:bronzegold.84','bronzegold','bronze gold ',[212,175,55],'d4af37',13938487],
['nbs-iscc-p:bronzegold.87','bronzegold','bronze gold ',[201,174,93],'c9ae5d',13217373],
['nbs-iscc-p:bronzemist.106','bronzemist','bronze mist',[134,126,54],'867e36',8814134],
['nbs-iscc-p:bronzepink.29','bronzepink','bronze pink',[217,166,169],'d9a6a9',14263977],
['nbs-iscc-p:bronzepink.53','bronzepink','bronze pink',[217,144,88],'d99058',14258264],
['nbs-iscc-p:bronzesheen.110','bronzesheen','bronze sheen',[91,88,66],'5b5842',5986370],
['nbs-iscc-p:bronzio.43','bronzio','bronzio',[121,68,59],'79443b',7947323],
['nbs-iscc-p:brookgreen.162','brookgreen','brook green',[150,222,209],'96ded1',9887441],
['nbs-iscc-p:bruges.192','bruges','bruges',[81,88,94],'51585e',5331038],
['nbs-iscc-p:buccaneer.12','buccaneer','buccaneer',[188,63,74],'bc3f4a',12336970],
['nbs-iscc-p:buckskintan.73','buckskintan','buckskin tan',[250,214,165],'fad6a5',16438949],
['nbs-iscc-p:buffcitron.90','buffcitron','buff citron',[194,178,128],'c2b280',12759680],
['nbs-iscc-p:burntalmond.58','burntalmond','burnt almond',[111,78,55],'6f4e37',7294519],
['nbs-iscc-p:burntorange.50','burntorange','burnt orange',[237,135,45],'ed872d',15566637],
['nbs-iscc-p:burntyellow.71','burntyellow','burnt yellow',[227,168,87],'e3a857',14919767],
['nbs-iscc-p:butterflyyellow.98','butterflyyellow','butterfly yellow',[233,228,80],'e9e450',15328336],
['nbs-iscc-p:butterflyyellow.101','butterflyyellow','butterfly yellow',[234,230,121],'eae679',15394425],
['nbs-iscc-p:cabbage.148','cabbage','cabbage',[199,230,215],'c7e6d7',13100759],
['nbs-iscc-p:caenstone.73','caenstone','caen stone',[250,214,165],'fad6a5',16438949],
['nbs-iscc-p:californiagold.71','californiagold','california gold',[227,168,87],'e3a857',14919767],
['nbs-iscc-p:californiagreen.155','californiagreen','california green',[125,137,132],'7d8984',8227204],
['nbs-iscc-p:californiapoppy.68','californiapoppy','california poppy',[234,162,33],'eaa221',15376929],
['nbs-iscc-p:cameliapink.2','cameliapink','camelia pink',[234,147,153],'ea9399',15373209],
['nbs-iscc-p:cameliapink.26','cameliapink','camelia pink',[248,131,121],'f88379',16286585],
['nbs-iscc-p:cameliarose.2','cameliarose','camelia rose',[234,147,153],'ea9399',15373209],
['nbs-iscc-p:cameo.4','cameo','cameo',[249,204,202],'f9ccca',16370890],
['nbs-iscc-p:cameopink.2','cameopink','cameo pink',[234,147,153],'ea9399',15373209],
['nbs-iscc-p:cameopink.249','cameopink','cameo pink',[239,187,204],'efbbcc',15711180],
['nbs-iscc-p:canarybronze.82','canarybronze','canary bronze',[243,195,0],'f3c300',15975168],
['nbs-iscc-p:canaryyellow.82','canaryyellow','canary yellow',[243,195,0],'f3c300',15975168],
['nbs-iscc-p:canaryyellow.83','canaryyellow','canary yellow',[250,218,94],'fada5e',16439902],
['nbs-iscc-p:candida.250','candida','candida',[213,151,174],'d597ae',13997998],
['nbs-iscc-p:canton.164','canton','canton',[49,120,115],'317873',3242099],
['nbs-iscc-p:capricelavender.231','capricelavender','caprice lavender',[232,227,229],'e8e3e5',15262693],
['nbs-iscc-p:capricepink.241','capricepink','caprice pink',[145,92,131],'915c83',9526403],
['nbs-iscc-p:capricepink.258','capricepink','caprice pink',[168,81,110],'a8516e',11030894],
['nbs-iscc-p:caramel.57','caramel','caramel',[166,123,91],'a67b5b',10910555],
['nbs-iscc-p:caramelcream.73','caramelcream','caramel cream',[250,214,165],'fad6a5',16438949],
['nbs-iscc-p:caravan.45','caravan','caravan',[151,127,115],'977f73',9928563],
['nbs-iscc-p:carnivalred.11','carnivalred','carnival red',[190,0,50],'be0032',12451890],
['nbs-iscc-p:castilianblue.178','castilianblue','castilian blue',[0,103,165],'0067a5',26533],
['nbs-iscc-p:cathedral.225','cathedral','cathedral',[48,25,52],'301934',3152180],
['nbs-iscc-p:cathedral.230','cathedral','cathedral',[41,30,41],'291e29',2694697],
['nbs-iscc-p:cedar.120','cedar','cedar',[138,154,91],'8a9a5b',9083483],
['nbs-iscc-p:cedarbough.120','cedarbough','cedar bough',[138,154,91],'8a9a5b',9083483],
['nbs-iscc-p:celestialblue.177','celestialblue','celestial blue',[73,151,208],'4997d0',4822992],
['nbs-iscc-p:celestialblue.195','celestialblue','celestial blue',[108,121,184],'6c79b8',7109048],
['nbs-iscc-p:celestialyellow.86','celestialyellow','celestial yellow',[248,222,126],'f8de7e',16309886],
['nbs-iscc-p:celestialyellow.89','celestialyellow','celestial yellow',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:ceramic.173','ceramic','ceramic',[54,117,136],'367588',3569032],
['nbs-iscc-p:ceramic.182','ceramic','ceramic',[67,107,149],'436b95',4418453],
['nbs-iscc-p:ceres.86','ceres','ceres',[248,222,126],'f8de7e',16309886],
['nbs-iscc-p:cerisepink.255','cerisepink','cerise pink',[179,68,108],'b3446c',11748460],
['nbs-iscc-p:ceriserose.3','ceriserose','cerise rose',[228,113,122],'e4717a',14971258],
['nbs-iscc-p:ceylonblue.186','ceylonblue','ceylon blue',[83,104,120],'536878',5466232],
['nbs-iscc-p:chalkviolet.210','chalkviolet','chalk violet',[140,130,182],'8c82b6',9208502],
['nbs-iscc-p:chalkviolet.214','chalkviolet','chalk violet',[150,144,171],'9690ab',9867435],
['nbs-iscc-p:chamoisyellow.71','chamoisyellow','chamois yellow',[227,168,87],'e3a857',14919767],
['nbs-iscc-p:chamoisyellow.76','chamoisyellow','chamois yellow',[193,154,107],'c19a6b',12687979],
['nbs-iscc-p:champagne.89','champagne','champagne',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:champagnebuff.89','champagnebuff','champagne buff',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:chantilly.144','chantilly','chantilly',[106,171,142],'6aab8e',6990734],
['nbs-iscc-p:charcoal.62','charcoal','charcoal',[62,50,44],'3e322c',4076076],
['nbs-iscc-p:charcoal.267','charcoal','charcoal',[34,34,34],'222222',2236962],
['nbs-iscc-p:charm.2','charm','charm',[234,147,153],'ea9399',15373209],
['nbs-iscc-p:charm.4','charm','charm',[249,204,202],'f9ccca',16370890],
['nbs-iscc-p:charm.249','charm','charm',[239,187,204],'efbbcc',15711180],
['nbs-iscc-p:charm.171','charm','charm',[156,209,220],'9cd1dc',10277340],
['nbs-iscc-p:charmpink.247','charmpink','charm pink',[230,143,172],'e68fac',15110060],
['nbs-iscc-p:charmschool.244','charmschool','charm school',[170,138,158],'aa8a9e',11176606],
['nbs-iscc-p:charmschool.261','charmschool','charm school',[175,134,142],'af868e',11503246],
['nbs-iscc-p:chartreusegreen.115','chartreusegreen','chartreuse green',[141,182,0],'8db600',9287168],
['nbs-iscc-p:chartreusegreen.116','chartreusegreen','chartreuse green',[189,218,87],'bdda57',12442199],
['nbs-iscc-p:chartreuseyellow.98','chartreuseyellow','chartreuse yellow',[233,228,80],'e9e450',15328336],
['nbs-iscc-p:chaste.263','chaste','chaste',[242,243,244],'f2f3f4',15922164],
['nbs-iscc-p:chateau.172','chateau','chateau',[102,170,188],'66aabc',6728380],
['nbs-iscc-p:cheddarcheese.71','cheddarcheese','cheddar cheese',[227,168,87],'e3a857',14919767],
['nbs-iscc-p:cheer.82','cheer','cheer',[243,195,0],'f3c300',15975168],
['nbs-iscc-p:cheerfulyellow.89','cheerfulyellow','cheerful yellow',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:cheerfulyellow.92','cheerfulyellow','cheerful yellow',[240,234,214],'f0ead6',15788758],
['nbs-iscc-p:chelseayellow.101','chelseayellow','chelsea yellow',[234,230,121],'eae679',15394425],
['nbs-iscc-p:chelseayellow.104','chelseayellow','chelsea yellow',[235,232,164],'ebe8a4',15460516],
['nbs-iscc-p:cherry.11','cherry','cherry',[190,0,50],'be0032',12451890],
['nbs-iscc-p:chili.159','chili','chili ',[0,166,147],'00a693',42643],
['nbs-iscc-p:chinapink.248','chinapink','china pink',[222,111,161],'de6fa1',14577569],
['nbs-iscc-p:chinapink.255','chinapink','china pink',[179,68,108],'b3446c',11748460],
['nbs-iscc-p:chinarose.19','chinarose','china rose',[144,93,93],'905d5d',9461085],
['nbs-iscc-p:chinasea.172','chinasea','china sea',[102,170,188],'66aabc',6728380],
['nbs-iscc-p:chive.125','chive','chive',[74,93,35],'4a5d23',4873507],
['nbs-iscc-p:chive.137','chive','chive',[53,94,59],'355e3b',3497531],
['nbs-iscc-p:christmasgreen.151','christmasgreen','christmas green',[58,75,71],'3a4b47',3820359],
['nbs-iscc-p:chrysanthemumyelllow.82','chrysanthemumyelllow','chrysanthemum yelllow',[243,195,0],'f3c300',15975168],
['nbs-iscc-p:chrysolitegreen.120','chrysolitegreen','chrysolite green',[138,154,91],'8a9a5b',9083483],
['nbs-iscc-p:cinderella.83','cinderella','cinderella',[250,218,94],'fada5e',16439902],
['nbs-iscc-p:cineraria.262','cineraria','cineraria',[145,95,109],'915f6d',9527149],
['nbs-iscc-p:cinnamon.54','cinnamon','cinnamon',[174,105,56],'ae6938',11430200],
['nbs-iscc-p:cinnamoncream.31','cinnamoncream','cinnamon cream',[236,213,197],'ecd5c5',15521221],
['nbs-iscc-p:citronbronze.95','citronbronze','citron bronze',[108,84,30],'6c541e',7099422],
['nbs-iscc-p:citrongray.94','citrongray','citron gray',[150,113,23],'967117',9859351],
['nbs-iscc-p:citrongray.109','citrongray','citron gray',[140,135,103],'8c8767',9209703],
['nbs-iscc-p:citronyellow.86','citronyellow','citron yellow',[248,222,126],'f8de7e',16309886],
['nbs-iscc-p:citronyellow.87','citronyellow','citron yellow',[201,174,93],'c9ae5d',13217373],
['nbs-iscc-p:citronyellow.101','citronyellow','citron yellow',[234,230,121],'eae679',15394425],
['nbs-iscc-p:citronyellow.102','citronyellow','citron yellow',[185,180,89],'b9b459',12170329],
['nbs-iscc-p:classicblue.169','classicblue','classic blue',[0,119,145],'007791',30609],
['nbs-iscc-p:classicblue.182','classicblue','classic blue',[67,107,149],'436b95',4418453],
['nbs-iscc-p:clementine.249','clementine','clementine',[239,187,204],'efbbcc',15711180],
['nbs-iscc-p:cleopatra.148','cleopatra','cleopatra',[199,230,215],'c7e6d7',13100759],
['nbs-iscc-p:clivia.53','clivia','clivia',[217,144,88],'d99058',14258264],
['nbs-iscc-p:cloister.148','cloister','cloister',[199,230,215],'c7e6d7',13100759],
['nbs-iscc-p:cloister.184','cloister','cloister',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:cloudcream.89','cloudcream','cloud cream',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:cloudcream.92','cloudcream','cloud cream',[240,234,214],'f0ead6',15788758],
['nbs-iscc-p:cloudgray.226','cloudgray','cloud gray',[214,202,221],'d6cadd',14076637],
['nbs-iscc-p:cloudyblue.184','cloudyblue','cloudy blue',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:clover.251','clover','clover',[193,126,145],'c17e91',12680849],
['nbs-iscc-p:cocoabronze.106','cocoabronze','cocoa bronze',[134,126,54],'867e36',8814134],
['nbs-iscc-p:cocoabrown.57','cocoabrown','cocoa brown',[166,123,91],'a67b5b',10910555],
['nbs-iscc-p:coldmorn.214','coldmorn','cold morn',[150,144,171],'9690ab',9867435],
['nbs-iscc-p:coldmorn.227','coldmorn','cold morn',[170,152,169],'aa98a9',11180201],
['nbs-iscc-p:colonialblue.183','colonialblue','colonial blue',[0,48,78],'00304e',12366],
['nbs-iscc-p:colonialcream.89','colonialcream','colonial cream',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:colonialexteriorgreen.145','colonialexteriorgreen','colonial exterior green',[59,120,97],'3b7861',3897441],
['nbs-iscc-p:conclude.92','conclude','conclude',[240,234,214],'f0ead6',15788758],
['nbs-iscc-p:congo.43','congo','congo',[121,68,59],'79443b',7947323],
['nbs-iscc-p:congoblue.186','congoblue','congo blue',[83,104,120],'536878',5466232],
['nbs-iscc-p:congobrown.55','congobrown','congo brown',[128,70,27],'80461b',8406555],
['nbs-iscc-p:congobrown.58','congobrown','congo brown',[111,78,55],'6f4e37',7294519],
['nbs-iscc-p:conifer.127','conifer','conifer',[81,87,68],'515744',5330756],
['nbs-iscc-p:continentalblue.234','continentalblue','continental blue',[93,85,91],'5d555b',6116699],
['nbs-iscc-p:cooleve.149','cooleve','cool eve',[141,163,153],'8da399',9282457],
['nbs-iscc-p:copper.37','copper','copper',[203,109,81],'cb6d51',13331793],
['nbs-iscc-p:copperbronze.54','copperbronze','copper bronze',[174,105,56],'ae6938',11430200],
['nbs-iscc-p:coppercream.31','coppercream','copper cream',[236,213,197],'ecd5c5',15521221],
['nbs-iscc-p:coquette.252','coquette','coquette',[232,204,215],'e8ccd7',15256791],
['nbs-iscc-p:coral.3','coral','coral',[228,113,122],'e4717a',14971258],
['nbs-iscc-p:coralblush.4','coralblush','coral blush',[249,204,202],'f9ccca',16370890],
['nbs-iscc-p:coralblush.28','coralblush','coral blush',[244,194,194],'f4c2c2',16040642],
['nbs-iscc-p:coralcloud.28','coralcloud','coral cloud',[244,194,194],'f4c2c2',16040642],
['nbs-iscc-p:coralgold.37','coralgold','coral gold',[203,109,81],'cb6d51',13331793],
['nbs-iscc-p:coralpink.26','coralpink','coral pink',[248,131,121],'f88379',16286585],
['nbs-iscc-p:coralrose.3','coralrose','coral rose',[228,113,122],'e4717a',14971258],
['nbs-iscc-p:coronation.259','coronation','coronation',[103,49,71],'673147',6762823],
['nbs-iscc-p:coronetblue.182','coronetblue','coronet blue',[67,107,149],'436b95',4418453],
['nbs-iscc-p:corsagepink.252','corsagepink','corsage pink',[232,204,215],'e8ccd7',15256791],
['nbs-iscc-p:corsair.187','corsair','corsair',[54,69,79],'36454f',3556687],
['nbs-iscc-p:corydalis.119','corydalis','corydalis',[201,220,137],'c9dc89',13229193],
['nbs-iscc-p:corydalis.121','corydalis','corydalis',[218,223,183],'dadfb7',14344119],
['nbs-iscc-p:cosmicblue.182','cosmicblue','cosmic blue',[67,107,149],'436b95',4418453],
['nbs-iscc-p:cosmospink.221','cosmospink','cosmos pink',[213,186,219],'d5badb',14007003],
['nbs-iscc-p:cosmospink.226','cosmospink','cosmos pink',[214,202,221],'d6cadd',14076637],
['nbs-iscc-p:cowslip.52','cowslip','cowslip',[250,181,127],'fab57f',16430463],
['nbs-iscc-p:crabpink.4','crabpink','crab pink',[249,204,202],'f9ccca',16370890],
['nbs-iscc-p:crabpink.7','crabpink','crab pink',[234,216,215],'ead8d7',15390935],
['nbs-iscc-p:cream.92','cream','cream',[240,234,214],'f0ead6',15788758],
['nbs-iscc-p:creamblush.73','creamblush','cream blush',[250,214,165],'fad6a5',16438949],
['nbs-iscc-p:creamchant.104','creamchant','cream chant',[235,232,164],'ebe8a4',15460516],
['nbs-iscc-p:creamcheese.92','creamcheese','cream cheese',[240,234,214],'f0ead6',15788758],
['nbs-iscc-p:creamdelight.104','creamdelight','cream delight',[235,232,164],'ebe8a4',15460516],
['nbs-iscc-p:creamdream.92','creamdream','cream dream',[240,234,214],'f0ead6',15788758],
['nbs-iscc-p:creamgold.86','creamgold','cream gold',[248,222,126],'f8de7e',16309886],
['nbs-iscc-p:creampearl.92','creampearl','cream pearl',[240,234,214],'f0ead6',15788758],
['nbs-iscc-p:creamtone.89','creamtone','cream tone',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:creamtone.92','creamtone','cream tone',[240,234,214],'f0ead6',15788758],
['nbs-iscc-p:creamwhite.92','creamwhite','cream white',[240,234,214],'f0ead6',15788758],
['nbs-iscc-p:creamyellow.89','creamyellow','cream yellow',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:creolepink.31','creolepink','creole pink',[236,213,197],'ecd5c5',15521221],
['nbs-iscc-p:crest.159','crest','crest',[0,166,147],'00a693',42643],
['nbs-iscc-p:crimsonglory.11','crimsonglory','crimson glory',[190,0,50],'be0032',12451890],
['nbs-iscc-p:crispblue.171','crispblue','crisp blue',[156,209,220],'9cd1dc',10277340],
['nbs-iscc-p:crocusrose.249','crocusrose','crocus rose',[239,187,204],'efbbcc',15711180],
['nbs-iscc-p:cruiseblue.173','cruiseblue','cruise blue',[54,117,136],'367588',3569032],
['nbs-iscc-p:cruiseblue.182','cruiseblue','cruise blue',[67,107,149],'436b95',4418453],
['nbs-iscc-p:crystalblue.168','crystalblue','crystal blue',[35,158,186],'239eba',2334394],
['nbs-iscc-p:crystalblue.171','crystalblue','crystal blue',[156,209,220],'9cd1dc',10277340],
['nbs-iscc-p:cubanorchid.240','cubanorchid','cuban orchid',[183,132,167],'b784a7',12027047],
['nbs-iscc-p:cubanorchid.250','cubanorchid','cuban orchid',[213,151,174],'d597ae',13997998],
['nbs-iscc-p:cubansand.87','cubansand','cuban sand',[201,174,93],'c9ae5d',13217373],
['nbs-iscc-p:cubansand.88','cubansand','cuban sand',[171,145,68],'ab9144',11243844],
['nbs-iscc-p:cuddleblue.184','cuddleblue','cuddle blue',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:cuddleblue.185','cuddleblue','cuddle blue',[145,163,176],'91a3b0',9544624],
['nbs-iscc-p:cupidblue.171','cupidblue','cupid blue',[156,209,220],'9cd1dc',10277340],
['nbs-iscc-p:cyanblue.173','cyanblue','cyan blue',[54,117,136],'367588',3569032],
['nbs-iscc-p:cypress.136','cypress','cypress',[103,146,103],'679267',6787687],
['nbs-iscc-p:daphnepink.251','daphnepink','daphne pink',[193,126,145],'c17e91',12680849],
['nbs-iscc-p:darkforest.151','darkforest','dark forest',[58,75,71],'3a4b47',3820359],
['nbs-iscc-p:darkfuchsia.237','darkfuchsia','dark fuchsia',[158,79,136],'9e4f88',10375048],
['nbs-iscc-p:dawnglow.226','dawnglow','dawn glow',[214,202,221],'d6cadd',14076637],
['nbs-iscc-p:dawnglow.252','dawnglow','dawn glow',[232,204,215],'e8ccd7',15256791],
['nbs-iscc-p:dawnpink.249','dawnpink','dawn pink',[239,187,204],'efbbcc',15711180],
['nbs-iscc-p:daybreak.227','daybreak','daybreak',[170,152,169],'aa98a9',11180201],
['nbs-iscc-p:daydream.214','daydream','day dream',[150,144,171],'9690ab',9867435],
['nbs-iscc-p:dazzleblue.169','dazzleblue','dazzle blue',[0,119,145],'007791',30609],
['nbs-iscc-p:debonair.185','debonair','debonair',[145,163,176],'91a3b0',9544624],
['nbs-iscc-p:debutanteblue.171','debutanteblue','debutante blue',[156,209,220],'9cd1dc',10277340],
['nbs-iscc-p:debutanteblue.184','debutanteblue','debutante blue',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:debutantepink.2','debutantepink','debutante pink',[234,147,153],'ea9399',15373209],
['nbs-iscc-p:debutanteyellow.101','debutanteyellow','debutante yellow',[234,230,121],'eae679',15394425],
['nbs-iscc-p:deephelleborered.262','deephelleborered','deep hellebore red ',[145,95,109],'915f6d',9527149],
['nbs-iscc-p:deeppurple.229','deeppurple','deep purple',[80,64,77],'50404d',5259341],
['nbs-iscc-p:deeppurple.230','deeppurple','deep purple',[41,30,41],'291e29',2694697],
['nbs-iscc-p:deeppurple.235','deeppurple','deep purple',[36,33,36],'242124',2367780],
['nbs-iscc-p:deepravine.95','deepravine','deep ravine',[108,84,30],'6c541e',7099422],
['nbs-iscc-p:deepreverie.234','deepreverie','deep reverie',[93,85,91],'5d555b',6116699],
['nbs-iscc-p:deepsea.164','deepsea','deep sea',[49,120,115],'317873',3242099],
['nbs-iscc-p:deeptwilight.63','deeptwilight','deep twilight',[142,130,121],'8e8279',9339513],
['nbs-iscc-p:deepviolet.211','deepviolet','deep violet',[96,78,129],'604e81',6311553],
['nbs-iscc-p:deepviolet.212','deepviolet','deep violet',[47,33,64],'2f2140',3088704],
['nbs-iscc-p:deepwater.182','deepwater','deep water',[67,107,149],'436b95',4418453],
['nbs-iscc-p:delectable.168','delectable','delectable',[35,158,186],'239eba',2334394],
['nbs-iscc-p:delectable.172','delectable','delectable',[102,170,188],'66aabc',6728380],
['nbs-iscc-p:delectable.181','delectable','delectable',[112,163,204],'70a3cc',7381964],
['nbs-iscc-p:delight.226','delight','delight',[214,202,221],'d6cadd',14076637],
['nbs-iscc-p:delmonte.228','delmonte','del monte',[121,104,120],'796878',7956600],
['nbs-iscc-p:delta.173','delta','delta',[54,117,136],'367588',3569032],
['nbs-iscc-p:delusion.171','delusion','delusion ',[156,209,220],'9cd1dc',10277340],
['nbs-iscc-p:demonblue.192','demonblue','demon blue',[81,88,94],'51585e',5331038],
['nbs-iscc-p:demureblue.184','demureblue','demure blue',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:depthgreen.151','depthgreen','depth green',[58,75,71],'3a4b47',3820359],
['nbs-iscc-p:desertbrown.4','desertbrown','desert brown',[249,204,202],'f9ccca',16370890],
['nbs-iscc-p:desertdust.89','desertdust','desert dust',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:desertdust.92','desertdust','desert dust',[240,234,214],'f0ead6',15788758],
['nbs-iscc-p:desertglass.222','desertglass','desert glass',[182,149,192],'b695c0',11965888],
['nbs-iscc-p:desertmist.73','desertmist','desert mist',[250,214,165],'fad6a5',16438949],
['nbs-iscc-p:desertpalm.110','desertpalm','desert palm',[91,88,66],'5b5842',5986370],
['nbs-iscc-p:desertpride.121','desertpride','desert pride',[218,223,183],'dadfb7',14344119],
['nbs-iscc-p:desertsand.76','desertsand','desert sand',[193,154,107],'c19a6b',12687979],
['nbs-iscc-p:desirable.148','desirable','desirable',[199,230,215],'c7e6d7',13100759],
['nbs-iscc-p:desire.221','desire','desire',[213,186,219],'d5badb',14007003],
['nbs-iscc-p:dewkist.154','dewkist','dewkist ',[178,190,181],'b2beb5',11714229],
['nbs-iscc-p:dewkist.264','dewkist','dewkist ',[185,184,181],'b9b8b5',12171445],
['nbs-iscc-p:diadem.244','diadem','diadem',[170,138,158],'aa8a9e',11176606],
['nbs-iscc-p:dignity.5','dignity','dignity',[222,165,164],'dea5a4',14591396],
['nbs-iscc-p:dignity.249','dignity','dignity',[239,187,204],'efbbcc',15711180],
['nbs-iscc-p:dignity.252','dignity','dignity',[232,204,215],'e8ccd7',15256791],
['nbs-iscc-p:distinction.262','distinction','distinction',[145,95,109],'915f6d',9527149],
['nbs-iscc-p:divablue.194','divablue','diva blue',[48,38,122],'30267a',3155578],
['nbs-iscc-p:divablue.195','divablue','diva blue',[108,121,184],'6c79b8',7109048],
['nbs-iscc-p:divineblue.181','divineblue','divine blue',[112,163,204],'70a3cc',7381964],
['nbs-iscc-p:dollyvarden.4','dollyvarden','dolly varden',[249,204,202],'f9ccca',16370890],
['nbs-iscc-p:dovegray.232','dovegray','dove gray',[191,185,189],'bfb9bd',12564925],
['nbs-iscc-p:dovegray.253','dovegray','dove gray',[195,166,177],'c3a6b1',12822193],
['nbs-iscc-p:drabolive.120','drabolive','drab olive',[138,154,91],'8a9a5b',9083483],
['nbs-iscc-p:dreamblue.180','dreamblue','dream blue',[161,202,241],'a1caf1',10603249],
['nbs-iscc-p:dreamcream.121','dreamcream','dream cream',[218,223,183],'dadfb7',14344119],
['nbs-iscc-p:dreamfluff.231','dreamfluff','dream fluff',[232,227,229],'e8e3e5',15262693],
['nbs-iscc-p:dreamstuff.249','dreamstuff','dream stuff',[239,187,204],'efbbcc',15711180],
['nbs-iscc-p:dreamyblue.185','dreamyblue','dreamy blue',[145,163,176],'91a3b0',9544624],
['nbs-iscc-p:driedleaf.86','driedleaf','dried leaf',[248,222,126],'f8de7e',16309886],
['nbs-iscc-p:drizzle.154','drizzle','drizzle',[178,190,181],'b2beb5',11714229],
['nbs-iscc-p:dryad.163','dryad','dryad',[102,173,164],'66ada4',6729124],
['nbs-iscc-p:dryadrose.31','dryadrose','dryad rose ',[236,213,197],'ecd5c5',15521221],
['nbs-iscc-p:dubarryblue.159','dubarryblue','du barry blue',[0,166,147],'00a693',42643],
['nbs-iscc-p:ducklingblue.186','ducklingblue','duckling blue',[83,104,120],'536878',5466232],
['nbs-iscc-p:ducklingblue.187','ducklingblue','duckling blue',[54,69,79],'36454f',3556687],
['nbs-iscc-p:duskyblue.185','duskyblue','dusky blue',[145,163,176],'91a3b0',9544624],
['nbs-iscc-p:duskycitron.120','duskycitron','dusky citron',[138,154,91],'8a9a5b',9083483],
['nbs-iscc-p:duskygreen.122','duskygreen','dusky green',[143,151,121],'8f9779',9410425],
['nbs-iscc-p:dustygreen.120','dustygreen','dusty green',[138,154,91],'8a9a5b',9083483],
['nbs-iscc-p:dustygreen.122','dustygreen','dusty green',[143,151,121],'8f9779',9410425],
['nbs-iscc-p:dutchcream.73','dutchcream','dutch cream',[250,214,165],'fad6a5',16438949],
['nbs-iscc-p:dutchcream.92','dutchcream','dutch cream',[240,234,214],'f0ead6',15788758],
['nbs-iscc-p:dynastygreen.160','dynastygreen','dynasty green',[0,122,116],'007a74',31348],
['nbs-iscc-p:earthbrown.58','earthbrown','earth brown',[111,78,55],'6f4e37',7294519],
['nbs-iscc-p:easterbonnet.184','easterbonnet','easter bonnet',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:eastereggyellow.86','eastereggyellow','easter egg yellow',[248,222,126],'f8de7e',16309886],
['nbs-iscc-p:ecru.89','ecru','ecru',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:ecrucream.89','ecrucream','ecru cream',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:ecrucream.92','ecrucream','ecru cream',[240,234,214],'f0ead6',15788758],
['nbs-iscc-p:eerieblue.184','eerieblue','eerie blue',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:eggplant.229','eggplant','egg plant ',[80,64,77],'50404d',5259341],
['nbs-iscc-p:eggplant.230','eggplant','egg plant ',[41,30,41],'291e29',2694697],
['nbs-iscc-p:eggshell.73','eggshell','egg shell',[250,214,165],'fad6a5',16438949],
['nbs-iscc-p:eggshell.89','eggshell','egg shell',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:egyptianred.16','egyptianred','egyptian red',[114,47,55],'722f37',7483191],
['nbs-iscc-p:eighteenthcenturycitron.120','eighteenthcenturycitron','eighteenth century citron',[138,154,91],'8a9a5b',9083483],
['nbs-iscc-p:eighteenthcenturygreen.122','eighteenthcenturygreen','eighteenth century green',[143,151,121],'8f9779',9410425],
['nbs-iscc-p:eighteenthcenturytan.18','eighteenthcenturytan','eighteenth century tan',[173,136,132],'ad8884',11372676],
['nbs-iscc-p:eighteenthcenturyturquoise.173','eighteenthcenturyturquoise','eighteenth century turquoise',[54,117,136],'367588',3569032],
['nbs-iscc-p:eighteenthcenturyturquoise.186','eighteenthcenturyturquoise','eighteenth century turquoise',[83,104,120],'536878',5466232],
['nbs-iscc-p:eighteenthcenturyviolet.245','eighteenthcenturyviolet','eighteenth century violet',[131,100,121],'836479',8610937],
['nbs-iscc-p:eighteenthcenturyyellow.90','eighteenthcenturyyellow','eighteenth century yellow',[194,178,128],'c2b280',12759680],
['nbs-iscc-p:electra.162','electra','electra',[150,222,209],'96ded1',9887441],
['nbs-iscc-p:elfgreen.149','elfgreen','elf green',[141,163,153],'8da399',9282457],
['nbs-iscc-p:elfgreen.163','elfgreen','elf green',[102,173,164],'66ada4',6729124],
['nbs-iscc-p:elm.122','elm','elm',[143,151,121],'8f9779',9410425],
['nbs-iscc-p:emeraldgreen.134','emeraldgreen','emerald green',[182,229,175],'b6e5af',11986351],
['nbs-iscc-p:emeraldisle.139','emeraldisle','emerald isle',[0,136,86],'008856',34902],
['nbs-iscc-p:empireyellow.82','empireyellow','empire yellow',[243,195,0],'f3c300',15975168],
['nbs-iscc-p:empireyellow.83','empireyellow','empire yellow',[250,218,94],'fada5e',16439902],
['nbs-iscc-p:empiricalblue.163','empiricalblue','empirical blue',[102,173,164],'66ada4',6729124],
['nbs-iscc-p:enchantress.37','enchantress','enchantress',[203,109,81],'cb6d51',13331793],
['nbs-iscc-p:enduring.163','enduring','enduring',[102,173,164],'66ada4',6729124],
['nbs-iscc-p:enduring.172','enduring','enduring',[102,170,188],'66aabc',6728380],
['nbs-iscc-p:englishmist.155','englishmist','english mist',[125,137,132],'7d8984',8227204],
['nbs-iscc-p:erie.164','erie','erie',[49,120,115],'317873',3242099],
['nbs-iscc-p:etherialgreen.119','etherialgreen','etherial green',[201,220,137],'c9dc89',13229193],
['nbs-iscc-p:etherialgreen.121','etherialgreen','etherial green',[218,223,183],'dadfb7',14344119],
['nbs-iscc-p:eucalyptusgreen.122','eucalyptusgreen','eucalyptus green ',[143,151,121],'8f9779',9410425],
['nbs-iscc-p:evegreen.130','evegreen','eve green',[131,211,125],'83d37d',8639357],
['nbs-iscc-p:evegreen.131','evegreen','eve green',[68,148,74],'44944a',4494410],
['nbs-iscc-p:eveningglow.4','eveningglow','evening glow',[249,204,202],'f9ccca',16370890],
['nbs-iscc-p:eveninghaze.5','eveninghaze','evening haze',[222,165,164],'dea5a4',14591396],
['nbs-iscc-p:eventide.253','eventide','eventide',[195,166,177],'c3a6b1',12822193],
['nbs-iscc-p:everglade.267','everglade','everglade',[34,34,34],'222222',2236962],
['nbs-iscc-p:fable.231','fable','fable',[232,227,229],'e8e3e5',15262693],
['nbs-iscc-p:fairygold.101','fairygold','fairy gold',[234,230,121],'eae679',15394425],
['nbs-iscc-p:fairyland.148','fairyland','fairy land ',[199,230,215],'c7e6d7',13100759],
['nbs-iscc-p:fairyland.162','fairyland','fairy land ',[150,222,209],'96ded1',9887441],
['nbs-iscc-p:fairyprincess.189','fairyprincess','fairy princess',[233,233,237],'e9e9ed',15329773],
['nbs-iscc-p:falcon.64','falcon','falcon',[91,80,79],'5b504f',5984335],
['nbs-iscc-p:fallblue.185','fallblue','fall blue',[145,163,176],'91a3b0',9544624],
['nbs-iscc-p:fallblue.203','fallblue','fall blue',[140,146,172],'8c92ac',9212588],
['nbs-iscc-p:fallbronze.88','fallbronze','fall bronze',[171,145,68],'ab9144',11243844],
['nbs-iscc-p:fallleaf.86','fallleaf','fall leaf',[248,222,126],'f8de7e',16309886],
['nbs-iscc-p:fallleaf.87','fallleaf','fall leaf',[201,174,93],'c9ae5d',13217373],
['nbs-iscc-p:fallyellow.86','fallyellow','fall yellow',[248,222,126],'f8de7e',16309886],
['nbs-iscc-p:fallyellow.87','fallyellow','fall yellow',[201,174,93],'c9ae5d',13217373],
['nbs-iscc-p:fancyfree.148','fancyfree','fancy free',[199,230,215],'c7e6d7',13100759],
['nbs-iscc-p:fanfare.169','fanfare','fanfare',[0,119,145],'007791',30609],
['nbs-iscc-p:fantasia.148','fantasia','fantasia',[199,230,215],'c7e6d7',13100759],
['nbs-iscc-p:fantasyrose.32','fantasyrose','fantasy rose',[199,173,163],'c7ada3',13086115],
['nbs-iscc-p:fantasyyellow.89','fantasyyellow','fantasy yellow',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:farhorizon.156','farhorizon','far horizon',[78,87,85],'4e5755',5134165],
['nbs-iscc-p:favorite.149','favorite','favorite',[141,163,153],'8da399',9282457],
['nbs-iscc-p:ferndell.137','ferndell','ferndell',[53,94,59],'355e3b',3497531],
['nbs-iscc-p:fernery.146','fernery','fernery',[27,77,62],'1b4d3e',1789246],
['nbs-iscc-p:ferngreen.120','ferngreen','fern green',[138,154,91],'8a9a5b',9083483],
['nbs-iscc-p:fernlane.148','fernlane','fern lane ',[199,230,215],'c7e6d7',13100759],
['nbs-iscc-p:festival.140','festival','festival',[62,180,137],'3eb489',4109449],
['nbs-iscc-p:festival.159','festival','festival',[0,166,147],'00a693',42643],
['nbs-iscc-p:festivegreen.129','festivegreen','festive green',[39,166,76],'27a64c',2598476],
['nbs-iscc-p:festivegreen.130','festivegreen','festive green',[131,211,125],'83d37d',8639357],
['nbs-iscc-p:festoon.140','festoon','festoon',[62,180,137],'3eb489',4109449],
['nbs-iscc-p:fidelity.202','fidelity','fidelity',[192,200,225],'c0c8e1',12634337],
['nbs-iscc-p:finesse.32','finesse','finesse',[199,173,163],'c7ada3',13086115],
['nbs-iscc-p:firecracker.35','firecracker','firecracker',[217,96,59],'d9603b',14245947],
['nbs-iscc-p:firefly.3','firefly','fire fly ',[228,113,122],'e4717a',14971258],
['nbs-iscc-p:firgreen.120','firgreen','fir green',[138,154,91],'8a9a5b',9083483],
['nbs-iscc-p:firmamentblue.196','firmamentblue','firmament blue',[84,90,167],'545aa7',5528231],
['nbs-iscc-p:firmamentgray.184','firmamentgray','firmament gray',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:firmamentgray.189','firmamentgray','firmament gray',[233,233,237],'e9e9ed',15329773],
['nbs-iscc-p:firstlady.240','firstlady','first lady',[183,132,167],'b784a7',12027047],
['nbs-iscc-p:firstlady.248','firstlady','first lady',[222,111,161],'de6fa1',14577569],
['nbs-iscc-p:flame.11','flame','flame',[190,0,50],'be0032',12451890],
['nbs-iscc-p:flame.12','flame','flame',[188,63,74],'bc3f4a',12336970],
['nbs-iscc-p:flamingopink.2','flamingopink','flamingo pink',[234,147,153],'ea9399',15373209],
['nbs-iscc-p:flash.12','flash','flash',[188,63,74],'bc3f4a',12336970],
['nbs-iscc-p:flaxflowerblue.195','flaxflowerblue','flax flower blue ',[108,121,184],'6c79b8',7109048],
['nbs-iscc-p:flemishblue.186','flemishblue','flemish blue',[83,104,120],'536878',5466232],
['nbs-iscc-p:fleshcream.31','fleshcream','flesh cream',[236,213,197],'ecd5c5',15521221],
['nbs-iscc-p:fleshcream.73','fleshcream','flesh cream',[250,214,165],'fad6a5',16438949],
['nbs-iscc-p:fleshpink.31','fleshpink','flesh pink',[236,213,197],'ecd5c5',15521221],
['nbs-iscc-p:fleshtint.28','fleshtint','flesh tint',[244,194,194],'f4c2c2',16040642],
['nbs-iscc-p:fleshtint.31','fleshtint','flesh tint',[236,213,197],'ecd5c5',15521221],
['nbs-iscc-p:flint.23','flint','flint',[92,80,79],'5c504f',6049871],
['nbs-iscc-p:flirtation.227','flirtation','flirtation',[170,152,169],'aa98a9',11180201],
['nbs-iscc-p:flowerlet.119','flowerlet','flowerlet',[201,220,137],'c9dc89',13229193],
['nbs-iscc-p:fogblue.203','fogblue','fog blue',[140,146,172],'8c92ac',9212588],
['nbs-iscc-p:foggreen.149','foggreen','fog green',[141,163,153],'8da399',9282457],
['nbs-iscc-p:fogyellow.91','fogyellow','fog yellow',[161,143,96],'a18f60',10588000],
['nbs-iscc-p:foliage.117','foliage','foliage',[126,159,46],'7e9f2e',8298286],
['nbs-iscc-p:forestshade.136','forestshade','forest shade',[103,146,103],'679267',6787687],
['nbs-iscc-p:fortune.206','fortune','fortune',[126,115,184],'7e73b8',8287160],
['nbs-iscc-p:fountainblue.202','fountainblue','fountain blue',[192,200,225],'c0c8e1',12634337],
['nbs-iscc-p:fountaingreen.130','fountaingreen','fountain green',[131,211,125],'83d37d',8639357],
['nbs-iscc-p:fountaingreen.134','fountaingreen','fountain green',[182,229,175],'b6e5af',11986351],
['nbs-iscc-p:fourleafclover.137','fourleafclover','four-leaf clover',[53,94,59],'355e3b',3497531],
['nbs-iscc-p:frenchbeige.57','frenchbeige','french beige',[166,123,91],'a67b5b',10910555],
['nbs-iscc-p:frenchblue.199','frenchblue','french blue',[135,145,191],'8791bf',8884671],
['nbs-iscc-p:frenchlilac.245','frenchlilac','french lilac',[131,100,121],'836479',8610937],
['nbs-iscc-p:frenchnude.29','frenchnude','french nude',[217,166,169],'d9a6a9',14263977],
['nbs-iscc-p:frostynight.189','frostynight','frosty night',[233,233,237],'e9e9ed',15329773],
['nbs-iscc-p:froth.92','froth','froth',[240,234,214],'f0ead6',15788758],
['nbs-iscc-p:frozendew.184','frozendew','frozen dew',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:fuchsia.12','fuchsia','fuchsia',[188,63,74],'bc3f4a',12336970],
['nbs-iscc-p:fuchsia.255','fuchsia','fuchsia',[179,68,108],'b3446c',11748460],
['nbs-iscc-p:fuchsiapink.247','fuchsiapink','fuchsia pink',[230,143,172],'e68fac',15110060],
['nbs-iscc-p:fuchsiapink.248','fuchsiapink','fuchsia pink',[222,111,161],'de6fa1',14577569],
['nbs-iscc-p:fuchsiapink.248','fuchsiapink','fuchsia pink',[222,111,161],'de6fa1',14577569],
['nbs-iscc-p:fuchsiapink.250','fuchsiapink','fuchsia pink',[213,151,174],'d597ae',13997998],
['nbs-iscc-p:fuchsiarose.254','fuchsiarose','fuchsia rose',[206,70,118],'ce4676',13518454],
['nbs-iscc-p:fuchsiarose.255','fuchsiarose','fuchsia rose',[179,68,108],'b3446c',11748460],
['nbs-iscc-p:galecloud.192','galecloud','gale cloud',[81,88,94],'51585e',5331038],
['nbs-iscc-p:galewinds.192','galewinds','gale winds',[81,88,94],'51585e',5331038],
['nbs-iscc-p:gardenpool.148','gardenpool','garden pool',[199,230,215],'c7e6d7',13100759],
['nbs-iscc-p:garnetrose.16','garnetrose','garnet rose',[114,47,55],'722f37',7483191],
['nbs-iscc-p:gayyellow.98','gayyellow','gay yellow',[233,228,80],'e9e450',15328336],
['nbs-iscc-p:gayyellow.101','gayyellow','gay yellow',[234,230,121],'eae679',15394425],
['nbs-iscc-p:genevablue.183','genevablue','geneva blue',[0,48,78],'00304e',12366],
['nbs-iscc-p:genevablue.204','genevablue','geneva blue',[76,81,109],'4c516d',5001581],
['nbs-iscc-p:ghostlyblue.184','ghostlyblue','ghostly blue',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:ghostlyblue.202','ghostlyblue','ghostly blue',[192,200,225],'c0c8e1',12634337],
['nbs-iscc-p:gleam.101','gleam','gleam',[234,230,121],'eae679',15394425],
['nbs-iscc-p:glintogold.86','glintogold','glint o\'gold',[248,222,126],'f8de7e',16309886],
['nbs-iscc-p:glintogold.87','glintogold','glint o\'gold',[201,174,93],'c9ae5d',13217373],
['nbs-iscc-p:glorygreen.116','glorygreen','glory green',[189,218,87],'bdda57',12442199],
['nbs-iscc-p:glorygreenblue.164','glorygreenblue','glory green-blue',[49,120,115],'317873',3242099],
['nbs-iscc-p:goldcoast.88','goldcoast','gold coast',[171,145,68],'ab9144',11243844],
['nbs-iscc-p:goldenapricot.52','goldenapricot','golden apricot',[250,181,127],'fab57f',16430463],
['nbs-iscc-p:goldenapricot.53','goldenapricot','golden apricot',[217,144,88],'d99058',14258264],
['nbs-iscc-p:goldenbrown.54','goldenbrown','golden brown',[174,105,56],'ae6938',11430200],
['nbs-iscc-p:goldenbuff.86','goldenbuff','golden buff',[248,222,126],'f8de7e',16309886],
['nbs-iscc-p:goldencream.86','goldencream','golden cream',[248,222,126],'f8de7e',16309886],
['nbs-iscc-p:goldendawn.86','goldendawn','golden dawn',[248,222,126],'f8de7e',16309886],
['nbs-iscc-p:goldenfleece.73','goldenfleece','golden fleece',[250,214,165],'fad6a5',16438949],
['nbs-iscc-p:goldenfleece.89','goldenfleece','golden fleece',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:goldenfleece.90','goldenfleece','golden fleece',[194,178,128],'c2b280',12759680],
['nbs-iscc-p:goldengem.86','goldengem','golden gem',[248,222,126],'f8de7e',16309886],
['nbs-iscc-p:goldenglow.83','goldenglow','golden glow',[250,218,94],'fada5e',16439902],
['nbs-iscc-p:goldenmist.105','goldenmist','golden mist',[185,181,125],'b9b57d',12170621],
['nbs-iscc-p:goldenmist.119','goldenmist','golden mist',[201,220,137],'c9dc89',13229193],
['nbs-iscc-p:goldenmist.121','goldenmist','golden mist',[218,223,183],'dadfb7',14344119],
['nbs-iscc-p:goldenpeach.71','goldenpeach','golden peach',[227,168,87],'e3a857',14919767],
['nbs-iscc-p:goldenrapture.83','goldenrapture','golden rapture',[250,218,94],'fada5e',16439902],
['nbs-iscc-p:goldenray.83','goldenray','golden ray',[250,218,94],'fada5e',16439902],
['nbs-iscc-p:goldenray.86','goldenray','golden ray',[248,222,126],'f8de7e',16309886],
['nbs-iscc-p:goldenrod.83','goldenrod','golden rod',[250,218,94],'fada5e',16439902],
['nbs-iscc-p:goldensheaf.89','goldensheaf','golden sheaf',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:goldensulphur.101','goldensulphur','golden sulphur',[234,230,121],'eae679',15394425],
['nbs-iscc-p:goldentan.53','goldentan','golden tan',[217,144,88],'d99058',14258264],
['nbs-iscc-p:goldenwest.72','goldenwest','golden west',[190,138,61],'be8a3d',12487229],
['nbs-iscc-p:goldenyellow.86','goldenyellow','golden yellow',[248,222,126],'f8de7e',16309886],
['nbs-iscc-p:goldfantasy.83','goldfantasy','gold fantasy',[250,218,94],'fada5e',16439902],
['nbs-iscc-p:goldglow.101','goldglow','gold glow',[234,230,121],'eae679',15394425],
['nbs-iscc-p:goldglow.104','goldglow','gold glow',[235,232,164],'ebe8a4',15460516],
['nbs-iscc-p:goldpheasant.54','goldpheasant','gold pheasant',[174,105,56],'ae6938',11430200],
['nbs-iscc-p:goldrush.71','goldrush','gold rush',[227,168,87],'e3a857',14919767],
['nbs-iscc-p:goodomen.210','goodomen','good omen',[140,130,182],'8c82b6',9208502],
['nbs-iscc-p:goodomen.181','goodomen','good omen',[112,163,204],'70a3cc',7381964],
['nbs-iscc-p:gorge.154','gorge','gorge',[178,190,181],'b2beb5',11714229],
['nbs-iscc-p:gorge.264','gorge','gorge',[185,184,181],'b9b8b5',12171445],
['nbs-iscc-p:graciousgreen.148','graciousgreen','gracious green',[199,230,215],'c7e6d7',13100759],
['nbs-iscc-p:grandcanyon.42','grandcanyon','grand canyon',[168,124,109],'a87c6d',11041901],
['nbs-iscc-p:grandcanyon.57','grandcanyon','grand canyon',[166,123,91],'a67b5b',10910555],
['nbs-iscc-p:graniteblue.186','graniteblue','granite blue',[83,104,120],'536878',5466232],
['nbs-iscc-p:granitegreen.149','granitegreen','granite green',[141,163,153],'8da399',9282457],
['nbs-iscc-p:grape.212','grape','grape',[47,33,64],'2f2140',3088704],
['nbs-iscc-p:grape.229','grape','grape',[80,64,77],'50404d',5259341],
['nbs-iscc-p:grapefruitgreen.98','grapefruitgreen','grapefruit green',[233,228,80],'e9e450',15328336],
['nbs-iscc-p:grapefruitgreen.99','grapefruitgreen','grapefruit green',[190,183,46],'beb72e',12498734],
['nbs-iscc-p:grapefruitgreen.101','grapefruitgreen','grapefruit green',[234,230,121],'eae679',15394425],
['nbs-iscc-p:grapefruitgreen.102','grapefruitgreen','grapefruit green',[185,180,89],'b9b459',12170329],
['nbs-iscc-p:grapegreen.120','grapegreen','grape green',[138,154,91],'8a9a5b',9083483],
['nbs-iscc-p:gravel.33','gravel','gravel',[194,172,153],'c2ac99',12758169],
['nbs-iscc-p:gravel.79','gravel','gravel',[174,155,130],'ae9b82',11443074],
['nbs-iscc-p:gravel.93','gravel','gravel',[191,184,165],'bfb8a5',12564645],
['nbs-iscc-p:grayblue.190','grayblue','gray blue',[180,188,192],'b4bcc0',11844800],
['nbs-iscc-p:graydream.92','graydream','gray dream',[240,234,214],'f0ead6',15788758],
['nbs-iscc-p:graydream.93','graydream','gray dream',[191,184,165],'bfb8a5',12564645],
['nbs-iscc-p:graydrift.184','graydrift','gray drift',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:graydrift.190','graydrift','gray drift',[180,188,192],'b4bcc0',11844800],
['nbs-iscc-p:graygreen.150','graygreen','gray green',[94,113,106],'5e716a',6189418],
['nbs-iscc-p:graylady.190','graylady','gray lady',[180,188,192],'b4bcc0',11844800],
['nbs-iscc-p:graylight.10','graylight','gray light',[193,182,179],'c1b6b3',12695219],
['nbs-iscc-p:graylight.264','graylight','gray light',[185,184,181],'b9b8b5',12171445],
['nbs-iscc-p:graymist.185','graymist','gray mist',[145,163,176],'91a3b0',9544624],
['nbs-iscc-p:graymist.190','graymist','gray mist',[180,188,192],'b4bcc0',11844800],
['nbs-iscc-p:graymood.234','graymood','gray mood',[93,85,91],'5d555b',6116699],
['nbs-iscc-p:graymorn.63','graymorn','gray morn',[142,130,121],'8e8279',9339513],
['nbs-iscc-p:graynight.186','graynight','gray night',[83,104,120],'536878',5466232],
['nbs-iscc-p:graysand.90','graysand','gray sand',[194,178,128],'c2b280',12759680],
['nbs-iscc-p:graysand.93','graysand','gray sand',[191,184,165],'bfb8a5',12564645],
['nbs-iscc-p:grecianrose.26','grecianrose','grecian rose',[248,131,121],'f88379',16286585],
['nbs-iscc-p:grecianrose.29','grecianrose','grecian rose',[217,166,169],'d9a6a9',14263977],
['nbs-iscc-p:greenbanana.102','greenbanana','green banana',[185,180,89],'b9b459',12170329],
['nbs-iscc-p:greenbanana.105','greenbanana','green banana',[185,181,125],'b9b57d',12170621],
['nbs-iscc-p:greenblack.151','greenblack','green black',[58,75,71],'3a4b47',3820359],
['nbs-iscc-p:greenblack.156','greenblack','green black',[78,87,85],'4e5755',5134165],
['nbs-iscc-p:greenblack.266','greenblack','green black',[85,85,85],'555555',5592405],
['nbs-iscc-p:greenblack.267','greenblack','green black',[34,34,34],'222222',2236962],
['nbs-iscc-p:greenbreath.92','greenbreath','green breath',[240,234,214],'f0ead6',15788758],
['nbs-iscc-p:greencharm.101','greencharm','green charm',[234,230,121],'eae679',15394425],
['nbs-iscc-p:greencharm.119','greencharm','green charm',[201,220,137],'c9dc89',13229193],
['nbs-iscc-p:greendream.162','greendream','green dream',[150,222,209],'96ded1',9887441],
['nbs-iscc-p:greenery.115','greenery','greenery',[141,182,0],'8db600',9287168],
['nbs-iscc-p:greenery.117','greenery','greenery',[126,159,46],'7e9f2e',8298286],
['nbs-iscc-p:greeneyes.136','greeneyes','green eyes',[103,146,103],'679267',6787687],
['nbs-iscc-p:greenfog.122','greenfog','green fog',[143,151,121],'8f9779',9410425],
['nbs-iscc-p:greenglory.160','greenglory','green glory',[0,122,116],'007a74',31348],
['nbs-iscc-p:greenglory.164','greenglory','green glory',[49,120,115],'317873',3242099],
['nbs-iscc-p:greenglow.148','greenglow','green glow',[199,230,215],'c7e6d7',13100759],
['nbs-iscc-p:greengrass.120','greengrass','green grass',[138,154,91],'8a9a5b',9083483],
['nbs-iscc-p:greenhaze.122','greenhaze','green haze',[143,151,121],'8f9779',9410425],
['nbs-iscc-p:greenice.92','greenice','green ice',[240,234,214],'f0ead6',15788758],
['nbs-iscc-p:greenice.153','greenice','green ice',[223,237,232],'dfede8',14675432],
['nbs-iscc-p:greenlily.148','greenlily','green lily',[199,230,215],'c7e6d7',13100759],
['nbs-iscc-p:greenmatrix.165','greenmatrix','green matrix',[0,75,73],'004b49',19273],
['nbs-iscc-p:greenmist.122','greenmist','green mist',[143,151,121],'8f9779',9410425],
['nbs-iscc-p:greenmoss.120','greenmoss','green moss',[138,154,91],'8a9a5b',9083483],
['nbs-iscc-p:greenoasis.103','greenoasis','green oasis',[152,148,62],'98943e',9999422],
['nbs-iscc-p:greenoasis.117','greenoasis','green oasis',[126,159,46],'7e9f2e',8298286],
['nbs-iscc-p:greenolive.120','greenolive','green olive ',[138,154,91],'8a9a5b',9083483],
['nbs-iscc-p:greenpride.119','greenpride','green pride',[201,220,137],'c9dc89',13229193],
['nbs-iscc-p:greenravine.150','greenravine','green ravine',[94,113,106],'5e716a',6189418],
['nbs-iscc-p:greenrivermist.154','greenrivermist','green river mist',[178,190,181],'b2beb5',11714229],
['nbs-iscc-p:greenslate.157','greenslate','green slate',[30,35,33],'1e2321',1975073],
['nbs-iscc-p:greenspring.117','greenspring','green spring',[126,159,46],'7e9f2e',8298286],
['nbs-iscc-p:greenstone.121','greenstone','green stone',[218,223,183],'dadfb7',14344119],
['nbs-iscc-p:greensulphur.102','greensulphur','green sulphur',[185,180,89],'b9b459',12170329],
['nbs-iscc-p:greentea.136','greentea','green tea',[103,146,103],'679267',6787687],
['nbs-iscc-p:greentee.120','greentee','green tee ',[138,154,91],'8a9a5b',9083483],
['nbs-iscc-p:growthgreen.116','growthgreen','growth green',[189,218,87],'bdda57',12442199],
['nbs-iscc-p:guineagreen.164','guineagreen','guinea green',[49,120,115],'317873',3242099],
['nbs-iscc-p:gullgray.233','gullgray','gull gray',[139,133,137],'8b8589',9143689],
['nbs-iscc-p:gumdropgreen.119','gumdropgreen','gumdrop green',[201,220,137],'c9dc89',13229193],
['nbs-iscc-p:gunmetal.64','gunmetal','gun metal',[91,80,79],'5b504f',5984335],
['nbs-iscc-p:gypsy.55','gypsy','gypsy',[128,70,27],'80461b',8406555],
['nbs-iscc-p:hanginggarden.129','hanginggarden','hanging garden',[39,166,76],'27a64c',2598476],
['nbs-iscc-p:hansayellow.82','hansayellow','hansa yellow',[243,195,0],'f3c300',15975168],
['nbs-iscc-p:happyday.104','happyday','happy day',[235,232,164],'ebe8a4',15460516],
['nbs-iscc-p:happyday.121','happyday','happy day',[218,223,183],'dadfb7',14344119],
['nbs-iscc-p:harborblue.184','harborblue','harbor blue',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:haremblue.184','haremblue','harem blue',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:harmoniousblue.186','harmoniousblue','harmonious blue',[83,104,120],'536878',5466232],
['nbs-iscc-p:harvestgold.86','harvestgold','harvest gold',[248,222,126],'f8de7e',16309886],
['nbs-iscc-p:hawkbrown.95','hawkbrown','hawk brown',[108,84,30],'6c541e',7099422],
['nbs-iscc-p:heartsdesire.15','heartsdesire','heart\'s desire',[171,78,82],'ab4e52',11226706],
['nbs-iscc-p:heavenlycharm.92','heavenlycharm','heavenly charm',[240,234,214],'f0ead6',15788758],
['nbs-iscc-p:heavenlyday.104','heavenlyday','heavenly day',[235,232,164],'ebe8a4',15460516],
['nbs-iscc-p:heavenlyflower.177','heavenlyflower','heavenly flower',[73,151,208],'4997d0',4822992],
['nbs-iscc-p:heavenlygreen.119','heavenlygreen','heavenly green',[201,220,137],'c9dc89',13229193],
['nbs-iscc-p:heavenlyorchid.252','heavenlyorchid','heavenly orchid',[232,204,215],'e8ccd7',15256791],
['nbs-iscc-p:heavenlypink.4','heavenlypink','heavenly pink',[249,204,202],'f9ccca',16370890],
['nbs-iscc-p:heliotrope.238','heliotrope','heliotrope',[112,41,99],'702963',7350627],
['nbs-iscc-p:heliotrope.242','heliotrope','heliotrope',[93,57,84],'5d3954',6109524],
['nbs-iscc-p:heliotropegray.227','heliotropegray','heliotrope gray',[170,152,169],'aa98a9',11180201],
['nbs-iscc-p:heliotropegray.244','heliotropegray','heliotrope gray',[170,138,158],'aa8a9e',11176606],
['nbs-iscc-p:heliotropegray.253','heliotropegray','heliotrope gray',[195,166,177],'c3a6b1',12822193],
['nbs-iscc-p:hemlock.135','hemlock','hemlock',[147,197,146],'93c592',9684370],
['nbs-iscc-p:hemp.90','hemp','hemp',[194,178,128],'c2b280',12759680],
['nbs-iscc-p:hiawathagreen.164','hiawathagreen','hiawatha green',[49,120,115],'317873',3242099],
['nbs-iscc-p:highland.151','highland','highland',[58,75,71],'3a4b47',3820359],
['nbs-iscc-p:holiday.162','holiday','holiday',[150,222,209],'96ded1',9887441],
['nbs-iscc-p:hollandblue.185','hollandblue','holland blue',[145,163,176],'91a3b0',9544624],
['nbs-iscc-p:honeybeige.29','honeybeige','honey beige',[217,166,169],'d9a6a9',14263977],
['nbs-iscc-p:horizon.185','horizon','horizon',[145,163,176],'91a3b0',9544624],
['nbs-iscc-p:hortensia.224','hortensia','hortensia',[86,60,92],'563c5c',5651548],
['nbs-iscc-p:hortensia.242','hortensia','hortensia',[93,57,84],'5d3954',6109524],
['nbs-iscc-p:huckleberry.229','huckleberry','huckleberry',[80,64,77],'50404d',5259341],
['nbs-iscc-p:huron.163','huron','huron',[102,173,164],'66ada4',6729124],
['nbs-iscc-p:hussar.204','hussar','hussar',[76,81,109],'4c516d',5001581],
['nbs-iscc-p:iceberggreen.149','iceberggreen','iceberg green',[141,163,153],'8da399',9282457],
['nbs-iscc-p:iceberggreen.185','iceberggreen','iceberg green',[145,163,176],'91a3b0',9544624],
['nbs-iscc-p:iceboat.159','iceboat','ice boat',[0,166,147],'00a693',42643],
['nbs-iscc-p:icecap.172','icecap','ice cap',[102,170,188],'66aabc',6728380],
['nbs-iscc-p:iceflow.148','iceflow','ice flow',[199,230,215],'c7e6d7',13100759],
['nbs-iscc-p:icelandblue.184','icelandblue','iceland blue',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:icygreen.163','icygreen','icy green',[102,173,164],'66ada4',6729124],
['nbs-iscc-p:icymorn.143','icymorn','icy morn',[142,209,178],'8ed1b2',9359794],
['nbs-iscc-p:icymorn.148','icymorn','icy morn',[199,230,215],'c7e6d7',13100759],
['nbs-iscc-p:ideal.171','ideal','ideal',[156,209,220],'9cd1dc',10277340],
['nbs-iscc-p:illusion.184','illusion','illusion',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:illusion.190','illusion','illusion',[180,188,192],'b4bcc0',11844800],
['nbs-iscc-p:illusive.226','illusive','illusive',[214,202,221],'d6cadd',14076637],
['nbs-iscc-p:independence.212','independence','independence',[47,33,64],'2f2140',3088704],
['nbs-iscc-p:independence.224','independence','independence',[86,60,92],'563c5c',5651548],
['nbs-iscc-p:independence.229','independence','independence',[80,64,77],'50404d',5259341],
['nbs-iscc-p:indianred.38','indianred','indian red',[158,71,50],'9e4732',10372914],
['nbs-iscc-p:inkblue.183','inkblue','ink blue',[0,48,78],'00304e',12366],
['nbs-iscc-p:inkblue.187','inkblue','ink blue',[54,69,79],'36454f',3556687],
['nbs-iscc-p:inspiration.148','inspiration','inspiration',[199,230,215],'c7e6d7',13100759],
['nbs-iscc-p:intimatemood.261','intimatemood','intimate mood',[175,134,142],'af868e',11503246],
['nbs-iscc-p:ionianblue.183','ionianblue','ionian blue',[0,48,78],'00304e',12366],
['nbs-iscc-p:ionianblue.187','ionianblue','ionian blue',[54,69,79],'36454f',3556687],
['nbs-iscc-p:irishisle.129','irishisle','irish isle',[39,166,76],'27a64c',2598476],
['nbs-iscc-p:irisleaf.127','irisleaf','iris leaf',[81,87,68],'515744',5330756],
['nbs-iscc-p:irisorchid.247','irisorchid','iris orchid',[230,143,172],'e68fac',15110060],
['nbs-iscc-p:irisorchid.248','irisorchid','iris orchid',[222,111,161],'de6fa1',14577569],
['nbs-iscc-p:ironmask.187','ironmask','iron mask',[54,69,79],'36454f',3556687],
['nbs-iscc-p:ironmask.267','ironmask','iron mask',[34,34,34],'222222',2236962],
['nbs-iscc-p:irresistible.255','irresistible','irresistible',[179,68,108],'b3446c',11748460],
['nbs-iscc-p:islandgreen.143','islandgreen','island green',[142,209,178],'8ed1b2',9359794],
['nbs-iscc-p:italianblue.172','italianblue','italian blue',[102,170,188],'66aabc',6728380],
['nbs-iscc-p:ivory.89','ivory','ivory',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:ivorywhite.89','ivorywhite','ivory white',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:jadecream.104','jadecream','jade cream',[235,232,164],'ebe8a4',15460516],
['nbs-iscc-p:jadelime.116','jadelime','jade lime',[189,218,87],'bdda57',12442199],
['nbs-iscc-p:jasper.151','jasper','jasper',[58,75,71],'3a4b47',3820359],
['nbs-iscc-p:jasper.267','jasper','jasper',[34,34,34],'222222',2236962],
['nbs-iscc-p:jealousy.143','jealousy','jealousy',[142,209,178],'8ed1b2',9359794],
['nbs-iscc-p:jerseycream.89','jerseycream','jersey cream',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:jewelblue.172','jewelblue','jewel blue',[102,170,188],'66aabc',6728380],
['nbs-iscc-p:jewelgreen.164','jewelgreen','jewel green',[49,120,115],'317873',3242099],
['nbs-iscc-p:joy.135','joy','joy',[147,197,146],'93c592',9684370],
['nbs-iscc-p:junebud.116','junebud','june bud',[189,218,87],'bdda57',12442199],
['nbs-iscc-p:junebud.130','junebud','june bud',[131,211,125],'83d37d',8639357],
['nbs-iscc-p:junegreen.119','junegreen','june green',[201,220,137],'c9dc89',13229193],
['nbs-iscc-p:jungle.151','jungle','jungle',[58,75,71],'3a4b47',3820359],
['nbs-iscc-p:juniper.150','juniper','juniper',[94,113,106],'5e716a',6189418],
['nbs-iscc-p:juniper.151','juniper','juniper',[58,75,71],'3a4b47',3820359],
['nbs-iscc-p:kaffa.46','kaffa','kaffa',[103,76,71],'674c47',6769735],
['nbs-iscc-p:killarneygreen.139','killarneygreen','killarney green ',[0,136,86],'008856',34902],
['nbs-iscc-p:kinglear.211','kinglear','king lear',[96,78,129],'604e81',6311553],
['nbs-iscc-p:kingneptune.181','kingneptune','king neptune',[112,163,204],'70a3cc',7381964],
['nbs-iscc-p:kingsransom.53','kingsransom','king\'s ransom',[217,144,88],'d99058',14258264],
['nbs-iscc-p:kittensear.89','kittensear','kitten\'s ear',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:ladyorchid.262','ladyorchid','lady orchid',[145,95,109],'915f6d',9527149],
['nbs-iscc-p:lagoon.164','lagoon','lagoon',[49,120,115],'317873',3242099],
['nbs-iscc-p:lakeblue.178','lakeblue','lake blue',[0,103,165],'0067a5',26533],
['nbs-iscc-p:lakecomo.182','lakecomo','lake como',[67,107,149],'436b95',4418453],
['nbs-iscc-p:lakelouise.182','lakelouise','lake louise',[67,107,149],'436b95',4418453],
['nbs-iscc-p:lambswool.92','lambswool','lamb\'s wool',[240,234,214],'f0ead6',15788758],
['nbs-iscc-p:lamer.143','lamer','la mer',[142,209,178],'8ed1b2',9359794],
['nbs-iscc-p:languidlavender.213','languidlavender','languid lavender',[196,195,221],'c4c3dd',12895197],
['nbs-iscc-p:languidlavender.226','languidlavender','languid lavender',[214,202,221],'d6cadd',14076637],
['nbs-iscc-p:larkspurblue.181','larkspurblue','larkspur blue',[112,163,204],'70a3cc',7381964],
['nbs-iscc-p:larkspurpurple.207','larkspurpurple','larkspur purple',[96,78,151],'604e97',6311575],
['nbs-iscc-p:lava.81','lava','lava',[72,60,50],'483c32',4734002],
['nbs-iscc-p:lava.96','lava','lava',[59,49,33],'3b3121',3879201],
['nbs-iscc-p:leafgreen.129','leafgreen','leaf green',[39,166,76],'27a64c',2598476],
['nbs-iscc-p:lettucegreen.117','lettucegreen','lettuce green',[126,159,46],'7e9f2e',8298286],
['nbs-iscc-p:lifegreen.125','lifegreen','life green',[74,93,35],'4a5d23',4873507],
['nbs-iscc-p:lighthearted.104','lighthearted','light hearted',[235,232,164],'ebe8a4',15460516],
['nbs-iscc-p:lightmauve.5','lightmauve','light mauve',[222,165,164],'dea5a4',14591396],
['nbs-iscc-p:lightmauve.250','lightmauve','light mauve',[213,151,174],'d597ae',13997998],
['nbs-iscc-p:lightoak.76','lightoak','light oak',[193,154,107],'c19a6b',12687979],
['nbs-iscc-p:lightoldrose.26','lightoldrose','light old rose',[248,131,121],'f88379',16286585],
['nbs-iscc-p:lilac.222','lilac','lilac',[182,149,192],'b695c0',11965888],
['nbs-iscc-p:lilacgray.228','lilacgray','lilac gray',[121,104,120],'796878',7956600],
['nbs-iscc-p:lilachint.226','lilachint','lilac hint',[214,202,221],'d6cadd',14076637],
['nbs-iscc-p:lilaclavender.214','lilaclavender','lilac lavender',[150,144,171],'9690ab',9867435],
['nbs-iscc-p:lilacshadow.224','lilacshadow','lilac shadow',[86,60,92],'563c5c',5651548],
['nbs-iscc-p:lilacshadow.228','lilacshadow','lilac shadow',[121,104,120],'796878',7956600],
['nbs-iscc-p:liltinggreen.159','liltinggreen','lilting green',[0,166,147],'00a693',42643],
['nbs-iscc-p:lilygreen.105','lilygreen','lily green',[185,181,125],'b9b57d',12170621],
['nbs-iscc-p:lilygreen.119','lilygreen','lily green',[201,220,137],'c9dc89',13229193],
['nbs-iscc-p:limecream.119','limecream','lime cream',[201,220,137],'c9dc89',13229193],
['nbs-iscc-p:limeyellow.98','limeyellow','lime yellow',[233,228,80],'e9e450',15328336],
['nbs-iscc-p:limeyellow.99','limeyellow','lime yellow',[190,183,46],'beb72e',12498734],
['nbs-iscc-p:limeyellow.116','limeyellow','lime yellow',[189,218,87],'bdda57',12442199],
['nbs-iscc-p:londonfog.233','londonfog','london fog',[139,133,137],'8b8589',9143689],
['nbs-iscc-p:lovebird.116','lovebird','love bird',[189,218,87],'bdda57',12442199],
['nbs-iscc-p:lovelight.101','lovelight','love light',[234,230,121],'eae679',15394425],
['nbs-iscc-p:lovely.144','lovely','lovely',[106,171,142],'6aab8e',6990734],
['nbs-iscc-p:loversknot.249','loversknot','lover\'s knot',[239,187,204],'efbbcc',15711180],
['nbs-iscc-p:loversnote.184','loversnote','lover\'s note',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:lucerneblue.199','lucerneblue','lucerne blue',[135,145,191],'8791bf',8884671],
['nbs-iscc-p:lullaby.153','lullaby','lullaby',[223,237,232],'dfede8',14675432],
['nbs-iscc-p:lullaby.154','lullaby','lullaby',[178,190,181],'b2beb5',11714229],
['nbs-iscc-p:lullaby.263','lullaby','lullaby',[242,243,244],'f2f3f4',15922164],
['nbs-iscc-p:lullaby.264','lullaby','lullaby',[185,184,181],'b9b8b5',12171445],
['nbs-iscc-p:lushgray.164','lushgray','lush gray',[49,120,115],'317873',3242099],
['nbs-iscc-p:lushgreen.140','lushgreen','lush green',[62,180,137],'3eb489',4109449],
['nbs-iscc-p:lustrousyellow.101','lustrousyellow','lustrous yellow',[234,230,121],'eae679',15394425],
['nbs-iscc-p:lyonsblue.194','lyonsblue','lyons blue',[48,38,122],'30267a',3155578],
['nbs-iscc-p:lyonsblue.196','lyonsblue','lyons blue',[84,90,167],'545aa7',5528231],
['nbs-iscc-p:lyreblue.173','lyreblue','lyre blue',[54,117,136],'367588',3569032],
['nbs-iscc-p:magenta.258','magenta','magenta',[168,81,110],'a8516e',11030894],
['nbs-iscc-p:magentarose.259','magentarose','magenta rose',[103,49,71],'673147',6762823],
['nbs-iscc-p:magical.231','magical','magical',[232,227,229],'e8e3e5',15262693],
['nbs-iscc-p:magicmoon.172','magicmoon','magic moon',[102,170,188],'66aabc',6728380],
['nbs-iscc-p:magicmoon.185','magicmoon','magic moon',[145,163,176],'91a3b0',9544624],
['nbs-iscc-p:maidoforleans.221','maidoforleans','maid of orleans',[213,186,219],'d5badb',14007003],
['nbs-iscc-p:maidoforleans.226','maidoforleans','maid of orleans',[214,202,221],'d6cadd',14076637],
['nbs-iscc-p:majolica.183','majolica','majolica',[0,48,78],'00304e',12366],
['nbs-iscc-p:mandarinorange.35','mandarinorange','mandarin orange',[217,96,59],'d9603b',14245947],
['nbs-iscc-p:mandarinorange.50','mandarinorange','mandarin orange',[237,135,45],'ed872d',15566637],
['nbs-iscc-p:marble.151','marble','marble',[58,75,71],'3a4b47',3820359],
['nbs-iscc-p:marcopolo.173','marcopolo','marco polo',[54,117,136],'367588',3569032],
['nbs-iscc-p:marineblue.173','marineblue','marine blue',[54,117,136],'367588',3569032],
['nbs-iscc-p:marineblue.174','marineblue','marine blue',[0,73,88],'004958',18776],
['nbs-iscc-p:marinecorpsblue.183','marinecorpsblue','marine corps blue',[0,48,78],'00304e',12366],
['nbs-iscc-p:marineglow.148','marineglow','marine glow',[199,230,215],'c7e6d7',13100759],
['nbs-iscc-p:marketgreen.148','marketgreen','market green ',[199,230,215],'c7e6d7',13100759],
['nbs-iscc-p:martinique.102','martinique','martinique',[185,180,89],'b9b459',12170329],
['nbs-iscc-p:mauvedecade.262','mauvedecade','mauve decade',[145,95,109],'915f6d',9527149],
['nbs-iscc-p:mauvemist.253','mauvemist','mauve mist',[195,166,177],'c3a6b1',12822193],
['nbs-iscc-p:mauveorchid.261','mauveorchid','mauve orchid',[175,134,142],'af868e',11503246],
['nbs-iscc-p:mauvetaupe.262','mauvetaupe','mauve taupe',[145,95,109],'915f6d',9527149],
['nbs-iscc-p:mauvette.252','mauvette','mauvette',[232,204,215],'e8ccd7',15256791],
['nbs-iscc-p:mayflower.248','mayflower','mayflower',[222,111,161],'de6fa1',14577569],
['nbs-iscc-p:mayflower.251','mayflower','mayflower',[193,126,145],'c17e91',12680849],
['nbs-iscc-p:meadowgreen.140','meadowgreen','meadow green',[62,180,137],'3eb489',4109449],
['nbs-iscc-p:meadowgreen.144','meadowgreen','meadow green',[106,171,142],'6aab8e',6990734],
['nbs-iscc-p:meadowmist.149','meadowmist','meadow mist',[141,163,153],'8da399',9282457],
['nbs-iscc-p:mellowbuff.73','mellowbuff','mellow buff',[250,214,165],'fad6a5',16438949],
['nbs-iscc-p:mellowbuff.89','mellowbuff','mellow buff',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:mellowgreen.101','mellowgreen','mellow green',[234,230,121],'eae679',15394425],
['nbs-iscc-p:mellowmauve.262','mellowmauve','mellow mauve',[145,95,109],'915f6d',9527149],
['nbs-iscc-p:mellowmood.227','mellowmood','mellow mood',[170,152,169],'aa98a9',11180201],
['nbs-iscc-p:mellowyellow.86','mellowyellow','mellow yellow',[248,222,126],'f8de7e',16309886],
['nbs-iscc-p:mellowyellow.89','mellowyellow','mellow yellow',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:mellowyellow.101','mellowyellow','mellow yellow',[234,230,121],'eae679',15394425],
['nbs-iscc-p:mellowyellow.104','mellowyellow','mellow yellow',[235,232,164],'ebe8a4',15460516],
['nbs-iscc-p:melodious.185','melodious','melodious',[145,163,176],'91a3b0',9544624],
['nbs-iscc-p:memorylane.153','memorylane','memory lane ',[223,237,232],'dfede8',14675432],
['nbs-iscc-p:merrygreen.139','merrygreen','merry green ',[0,136,86],'008856',34902],
['nbs-iscc-p:midnight.183','midnight','midnight ',[0,48,78],'00304e',12366],
['nbs-iscc-p:midnight.187','midnight','midnight ',[54,69,79],'36454f',3556687],
['nbs-iscc-p:midnightbronze.10','midnightbronze','midnight bronze ',[193,182,179],'c1b6b3',12695219],
['nbs-iscc-p:midseason.226','midseason','midseason ',[214,202,221],'d6cadd',14076637],
['nbs-iscc-p:mignonette.120','mignonette','mignonette ',[138,154,91],'8a9a5b',9083483],
['nbs-iscc-p:milanoblue.186','milanoblue','milano blue ',[83,104,120],'536878',5466232],
['nbs-iscc-p:milanoblue.203','milanoblue','milano blue ',[140,146,172],'8c92ac',9212588],
['nbs-iscc-p:milkygreen.153','milkygreen','milky green ',[223,237,232],'dfede8',14675432],
['nbs-iscc-p:mincemeat.46','mincemeat','mince meat ',[103,76,71],'674c47',6769735],
['nbs-iscc-p:ming.141','ming','ming ',[0,121,89],'007959',31065],
['nbs-iscc-p:mintlime.135','mintlime','mint lime ',[147,197,146],'93c592',9684370],
['nbs-iscc-p:mintlime.148','mintlime','mint lime ',[199,230,215],'c7e6d7',13100759],
['nbs-iscc-p:missionwhite.31','missionwhite','mission white ',[236,213,197],'ecd5c5',15521221],
['nbs-iscc-p:missionwhite.73','missionwhite','mission white ',[250,214,165],'fad6a5',16438949],
['nbs-iscc-p:mistedyellow.87','mistedyellow','misted yellow ',[201,174,93],'c9ae5d',13217373],
['nbs-iscc-p:mistletoe.120','mistletoe','mistletoe ',[138,154,91],'8a9a5b',9083483],
['nbs-iscc-p:mistletoe.122','mistletoe','mistletoe ',[143,151,121],'8f9779',9410425],
['nbs-iscc-p:mistycream.89','mistycream','misty cream ',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:mistycream.92','mistycream','misty cream ',[240,234,214],'f0ead6',15788758],
['nbs-iscc-p:mistygreen.122','mistygreen','misty green ',[143,151,121],'8f9779',9410425],
['nbs-iscc-p:mistyjade.101','mistyjade','misty jade ',[234,230,121],'eae679',15394425],
['nbs-iscc-p:mistyjade.104','mistyjade','misty jade ',[235,232,164],'ebe8a4',15460516],
['nbs-iscc-p:mistyjade.119','mistyjade','misty jade ',[201,220,137],'c9dc89',13229193],
['nbs-iscc-p:mistylilac.222','mistylilac','misty lilac ',[182,149,192],'b695c0',11965888],
['nbs-iscc-p:mistylilac.227','mistylilac','misty lilac ',[170,152,169],'aa98a9',11180201],
['nbs-iscc-p:mistymorn.92','mistymorn','misty morn ',[240,234,214],'f0ead6',15788758],
['nbs-iscc-p:mistymorn.153','mistymorn','misty morn ',[223,237,232],'dfede8',14675432],
['nbs-iscc-p:mistymorn.263','mistymorn','misty morn ',[242,243,244],'f2f3f4',15922164],
['nbs-iscc-p:mistyrose.31','mistyrose','misty rose ',[236,213,197],'ecd5c5',15521221],
['nbs-iscc-p:modest.154','modest','modest ',[178,190,181],'b2beb5',11714229],
['nbs-iscc-p:mogul.210','mogul','mogul ',[140,130,182],'8c82b6',9208502],
['nbs-iscc-p:mohawk.43','mohawk','mohawk ',[121,68,59],'79443b',7947323],
['nbs-iscc-p:mohawktrail.151','mohawktrail','mohawk trail ',[58,75,71],'3a4b47',3820359],
['nbs-iscc-p:monaco.163','monaco','monaco ',[102,173,164],'66ada4',6729124],
['nbs-iscc-p:monastralblue.183','monastralblue','monastral blue ',[0,48,78],'00304e',12366],
['nbs-iscc-p:monastralblue.200','monastralblue','monastral blue ',[78,81,128],'4e5180',5132672],
['nbs-iscc-p:monsignor.237','monsignor','monsignor ',[158,79,136],'9e4f88',10375048],
['nbs-iscc-p:monticellogreen.137','monticellogreen','monticello green ',[53,94,59],'355e3b',3497531],
['nbs-iscc-p:monticellorose.29','monticellorose','monticello rose ',[217,166,169],'d9a6a9',14263977],
['nbs-iscc-p:montroseyellow.116','montroseyellow','montrose yellow ',[189,218,87],'bdda57',12442199],
['nbs-iscc-p:moodbeige.90','moodbeige','mood beige ',[194,178,128],'c2b280',12759680],
['nbs-iscc-p:moodlilac.223','moodlilac','mood lilac ',[134,96,142],'86608e',8806542],
['nbs-iscc-p:moodviolet.228','moodviolet','mood violet ',[121,104,120],'796878',7956600],
['nbs-iscc-p:moonbeam.232','moonbeam','moonbeam ',[191,185,189],'bfb9bd',12564925],
['nbs-iscc-p:moonlight.31','moonlight','moonlight ',[236,213,197],'ecd5c5',15521221],
['nbs-iscc-p:moonlightbay.162','moonlightbay','moonlight bay ',[150,222,209],'96ded1',9887441],
['nbs-iscc-p:moonlitblue.184','moonlitblue','moonlit blue ',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:moonlitblue.190','moonlitblue','moonlit blue ',[180,188,192],'b4bcc0',11844800],
['nbs-iscc-p:moonlitwater.185','moonlitwater','moonlit water ',[145,163,176],'91a3b0',9544624],
['nbs-iscc-p:moonlitwater.203','moonlitwater','moonlit water ',[140,146,172],'8c92ac',9212588],
['nbs-iscc-p:moonmist.10','moonmist','moonmist ',[193,182,179],'c1b6b3',12695219],
['nbs-iscc-p:morningglory.248','morningglory','morning glory ',[222,111,161],'de6fa1',14577569],
['nbs-iscc-p:morningmist.33','morningmist','morning mist ',[194,172,153],'c2ac99',12758169],
['nbs-iscc-p:moth.93','moth','moth ',[191,184,165],'bfb8a5',12564645],
['nbs-iscc-p:moth.121','moth','moth ',[218,223,183],'dadfb7',14344119],
['nbs-iscc-p:mountainhaze.5','mountainhaze','mountain haze ',[222,165,164],'dea5a4',14591396],
['nbs-iscc-p:mountainpeakblue.184','mountainpeakblue','mountain peak blue ',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:mountaintop.127','mountaintop','mountain top ',[81,87,68],'515744',5330756],
['nbs-iscc-p:mountaintop.128','mountaintop','mountain top ',[49,54,43],'31362b',3225131],
['nbs-iscc-p:mulberry.228','mulberry','mulberry ',[121,104,120],'796878',7956600],
['nbs-iscc-p:murmur.89','murmur','murmur ',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:murmur.93','murmur','murmur ',[191,184,165],'bfb8a5',12564645],
['nbs-iscc-p:muse.119','muse','muse ',[201,220,137],'c9dc89',13229193],
['nbs-iscc-p:mushroom.89','mushroom','mushroom ',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:mushroom.92','mushroom','mushroom ',[240,234,214],'f0ead6',15788758],
['nbs-iscc-p:mustard.88','mustard','mustard ',[171,145,68],'ab9144',11243844],
['nbs-iscc-p:mustardcream.86','mustardcream','mustard cream ',[248,222,126],'f8de7e',16309886],
['nbs-iscc-p:mustardcream.89','mustardcream','mustard cream ',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:mutedyellow.86','mutedyellow','muted yellow ',[248,222,126],'f8de7e',16309886],
['nbs-iscc-p:mutedyellow.101','mutedyellow','muted yellow ',[234,230,121],'eae679',15394425],
['nbs-iscc-p:myrtlegreen.150','myrtlegreen','myrtle green ',[94,113,106],'5e716a',6189418],
['nbs-iscc-p:mysticblue.184','mysticblue','mystic blue ',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:mysticpurple.241','mysticpurple','mystic purple ',[145,92,131],'915c83',9526403],
['nbs-iscc-p:mysticwhite.189','mysticwhite','mystic white ',[233,233,237],'e9e9ed',15329773],
['nbs-iscc-p:myth.226','myth','myth ',[214,202,221],'d6cadd',14076637],
['nbs-iscc-p:mythblue.186','mythblue','myth blue ',[83,104,120],'536878',5466232],
['nbs-iscc-p:mythblue.192','mythblue','myth blue ',[81,88,94],'51585e',5331038],
['nbs-iscc-p:nabob.151','nabob','nabob ',[58,75,71],'3a4b47',3820359],
['nbs-iscc-p:nabob.187','nabob','nabob ',[54,69,79],'36454f',3556687],
['nbs-iscc-p:nabob.192','nabob','nabob ',[81,88,94],'51585e',5331038],
['nbs-iscc-p:naid.159','naid','naid ',[0,166,147],'00a693',42643],
['nbs-iscc-p:naid.162','naid','naid ',[150,222,209],'96ded1',9887441],
['nbs-iscc-p:naid.163','naid','naid ',[102,173,164],'66ada4',6729124],
['nbs-iscc-p:naive.153','naive','naive ',[223,237,232],'dfede8',14675432],
['nbs-iscc-p:napoleon.197','napoleon','napoleon ',[39,36,88],'272458',2565208],
['nbs-iscc-p:nasturtium.67','nasturtium','nasturtium ',[255,193,79],'ffc14f',16761167],
['nbs-iscc-p:nasturtiumbuff.71','nasturtiumbuff','nasturtium buff ',[227,168,87],'e3a857',14919767],
['nbs-iscc-p:nativeblue.165','nativeblue','native blue',[0,75,73],'004b49',19273],
['nbs-iscc-p:neonblue.168','neonblue','neon blue',[35,158,186],'239eba',2334394],
['nbs-iscc-p:neopolitannight.182','neopolitannight','neopolitan night ',[67,107,149],'436b95',4418453],
['nbs-iscc-p:neopolitannight.200','neopolitannight','neopolitan night ',[78,81,128],'4e5180',5132672],
['nbs-iscc-p:neutral.89','neutral','neutral',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:neutral.92','neutral','neutral',[240,234,214],'f0ead6',15788758],
['nbs-iscc-p:newblue.189','newblue','new blue',[233,233,237],'e9e9ed',15329773],
['nbs-iscc-p:niagara.168','niagara','niagara',[35,158,186],'239eba',2334394],
['nbs-iscc-p:nightblue.174','nightblue','night blue',[0,73,88],'004958',18776],
['nbs-iscc-p:nightcloud.189','nightcloud','night cloud',[233,233,237],'e9e9ed',15329773],
['nbs-iscc-p:nightfighter.192','nightfighter','night fighter',[81,88,94],'51585e',5331038],
['nbs-iscc-p:nightfighter.234','nightfighter','night fighter',[93,85,91],'5d555b',6116699],
['nbs-iscc-p:nightfighter.266','nightfighter','night fighter',[85,85,85],'555555',5592405],
['nbs-iscc-p:nighthorizon.193','nighthorizon','night horizon',[32,36,40],'202428',2106408],
['nbs-iscc-p:nighthorizon.267','nighthorizon','night horizon',[34,34,34],'222222',2236962],
['nbs-iscc-p:nightmagic.227','nightmagic','night magic',[170,152,169],'aa98a9',11180201],
['nbs-iscc-p:nightshade.229','nightshade','nightshade',[80,64,77],'50404d',5259341],
['nbs-iscc-p:nightshade.234','nightshade','nightshade',[93,85,91],'5d555b',6116699],
['nbs-iscc-p:nightwatch.152','nightwatch','night watch',[26,36,33],'1a2421',1713185],
['nbs-iscc-p:nil.263','nil','nil',[242,243,244],'f2f3f4',15922164],
['nbs-iscc-p:nocturne.232','nocturne','nocturne',[191,185,189],'bfb9bd',12564925],
['nbs-iscc-p:noel.151','noel','noel',[58,75,71],'3a4b47',3820359],
['nbs-iscc-p:nomadbrown.62','nomadbrown','nomad brown',[62,50,44],'3e322c',4076076],
['nbs-iscc-p:norseblue.177','norseblue','norse blue',[73,151,208],'4997d0',4822992],
['nbs-iscc-p:norseblue.195','norseblue','norse blue',[108,121,184],'6c79b8',7109048],
['nbs-iscc-p:northblue.169','northblue','north blue',[0,119,145],'007791',30609],
['nbs-iscc-p:northernskies.184','northernskies','northern skies',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:northgreen.150','northgreen','north green',[94,113,106],'5e716a',6189418],
['nbs-iscc-p:northgreen.164','northgreen','north green',[49,120,115],'317873',3242099],
['nbs-iscc-p:northsea.192','northsea','north sea',[81,88,94],'51585e',5331038],
['nbs-iscc-p:norwaypine.136','norwaypine','norway pine',[103,146,103],'679267',6787687],
['nbs-iscc-p:nubianbrown.61','nubianbrown','nubian brown',[99,81,71],'635147',6508871],
['nbs-iscc-p:nymphpink.250','nymphpink','nymph pink',[213,151,174],'d597ae',13997998],
['nbs-iscc-p:oakleaf.127','oakleaf','oak leaf',[81,87,68],'515744',5330756],
['nbs-iscc-p:oceanwave.163','oceanwave','ocean wave',[102,173,164],'66ada4',6729124],
['nbs-iscc-p:octoroonrose.19','octoroonrose','octoroon rose',[144,93,93],'905d5d',9461085],
['nbs-iscc-p:octoroonrose.45','octoroonrose','octoroon rose',[151,127,115],'977f73',9928563],
['nbs-iscc-p:oldcoral.15','oldcoral','old coral',[171,78,82],'ab4e52',11226706],
['nbs-iscc-p:oldgold.68','oldgold','old gold',[234,162,33],'eaa221',15376929],
['nbs-iscc-p:oldgold.71','oldgold','old gold',[227,168,87],'e3a857',14919767],
['nbs-iscc-p:oldgold.84','oldgold','old gold',[212,175,55],'d4af37',13938487],
['nbs-iscc-p:oldlavender.226','oldlavender','old lavender',[214,202,221],'d6cadd',14076637],
['nbs-iscc-p:oldmastergreen.127','oldmastergreen','old master green',[81,87,68],'515744',5330756],
['nbs-iscc-p:oldrose.6','oldrose','old rose',[192,128,129],'c08081',12615809],
['nbs-iscc-p:oliveglow.104','oliveglow','olive glow',[235,232,164],'ebe8a4',15460516],
['nbs-iscc-p:oliveglow.121','oliveglow','olive glow',[218,223,183],'dadfb7',14344119],
['nbs-iscc-p:olivehint.104','olivehint','olive hint',[235,232,164],'ebe8a4',15460516],
['nbs-iscc-p:olivehint.121','olivehint','olive hint',[218,223,183],'dadfb7',14344119],
['nbs-iscc-p:ombre.187','ombre','ombre',[54,69,79],'36454f',3556687],
['nbs-iscc-p:ombre.267','ombre','ombre',[34,34,34],'222222',2236962],
['nbs-iscc-p:opalgreen.164','opalgreen','opal green',[49,120,115],'317873',3242099],
['nbs-iscc-p:operablue.183','operablue','opera blue',[0,48,78],'00304e',12366],
['nbs-iscc-p:operablue.200','operablue','opera blue',[78,81,128],'4e5180',5132672],
['nbs-iscc-p:operamauve.240','operamauve','opera mauve',[183,132,167],'b784a7',12027047],
['nbs-iscc-p:operapink.28','operapink','opera pink',[244,194,194],'f4c2c2',16040642],
['nbs-iscc-p:orange.50','orange','orange',[237,135,45],'ed872d',15566637],
['nbs-iscc-p:orangeblush.73','orangeblush','orange blush',[250,214,165],'fad6a5',16438949],
['nbs-iscc-p:orangecream.89','orangecream','orange cream',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:orchid.253','orchid','orchid',[195,166,177],'c3a6b1',12822193],
['nbs-iscc-p:orchidlane.221','orchidlane','orchid lane',[213,186,219],'d5badb',14007003],
['nbs-iscc-p:orchidleaf.226','orchidleaf','orchid leaf',[214,202,221],'d6cadd',14076637],
['nbs-iscc-p:orchidmauve.251','orchidmauve','orchid mauve',[193,126,145],'c17e91',12680849],
['nbs-iscc-p:orchidnight.19','orchidnight','orchid night',[144,93,93],'905d5d',9461085],
['nbs-iscc-p:orchidnight.262','orchidnight','orchid night',[145,95,109],'915f6d',9527149],
['nbs-iscc-p:orchidpink.4','orchidpink','orchid pink',[249,204,202],'f9ccca',16370890],
['nbs-iscc-p:orchidpink.5','orchidpink','orchid pink',[222,165,164],'dea5a4',14591396],
['nbs-iscc-p:orchidsmoke.253','orchidsmoke','orchid smoke',[195,166,177],'c3a6b1',12822193],
['nbs-iscc-p:orientalbronze.95','orientalbronze','oriental bronze',[108,84,30],'6c541e',7099422],
['nbs-iscc-p:orientalsand.109','orientalsand','oriental sand',[140,135,103],'8c8767',9209703],
['nbs-iscc-p:padrebrown.44','padrebrown','padre brown',[62,29,30],'3e1d1e',4070686],
['nbs-iscc-p:palaceblue.178','palaceblue','palace blue',[0,103,165],'0067a5',26533],
['nbs-iscc-p:palaceblue.182','palaceblue','palace blue',[67,107,149],'436b95',4418453],
['nbs-iscc-p:palestar.101','palestar','pale star',[234,230,121],'eae679',15394425],
['nbs-iscc-p:palestar.104','palestar','pale star',[235,232,164],'ebe8a4',15460516],
['nbs-iscc-p:palewater.143','palewater','pale water',[142,209,178],'8ed1b2',9359794],
['nbs-iscc-p:paloma.57','paloma','paloma',[166,123,91],'a67b5b',10910555],
['nbs-iscc-p:paloma.171','paloma','paloma',[156,209,220],'9cd1dc',10277340],
['nbs-iscc-p:pan.150','pan','pan',[94,113,106],'5e716a',6189418],
['nbs-iscc-p:pan.164','pan','pan',[49,120,115],'317873',3242099],
['nbs-iscc-p:panamablue.198','panamablue','panama blue',[179,188,226],'b3bce2',11779298],
['nbs-iscc-p:pansypurple.241','pansypurple','pansy purple',[145,92,131],'915c83',9526403],
['nbs-iscc-p:pansypurple.242','pansypurple','pansy purple',[93,57,84],'5d3954',6109524],
['nbs-iscc-p:pansyyellow.83','pansyyellow','pansy yellow',[250,218,94],'fada5e',16439902],
['nbs-iscc-p:paprica.38','paprica','paprica',[158,71,50],'9e4732',10372914],
['nbs-iscc-p:paradisegreen.134','paradisegreen','paradise green',[182,229,175],'b6e5af',11986351],
['nbs-iscc-p:paradisegreen.135','paradisegreen','paradise green',[147,197,146],'93c592',9684370],
['nbs-iscc-p:paramount.168','paramount','paramount',[35,158,186],'239eba',2334394],
['nbs-iscc-p:paramount.172','paramount','paramount',[102,170,188],'66aabc',6728380],
['nbs-iscc-p:paramour.172','paramour','paramour',[102,170,188],'66aabc',6728380],
['nbs-iscc-p:parrakeet.140','parrakeet','parrakeet',[62,180,137],'3eb489',4109449],
['nbs-iscc-p:peace.92','peace','peace',[240,234,214],'f0ead6',15788758],
['nbs-iscc-p:peacemaker.153','peacemaker','peace-maker',[223,237,232],'dfede8',14675432],
['nbs-iscc-p:peachamber.29','peachamber','peach amber',[217,166,169],'d9a6a9',14263977],
['nbs-iscc-p:peachbisque.42','peachbisque','peach bisque',[168,124,109],'a87c6d',11041901],
['nbs-iscc-p:peachbud.28','peachbud','peach bud',[244,194,194],'f4c2c2',16040642],
['nbs-iscc-p:peachcream.73','peachcream','peach cream',[250,214,165],'fad6a5',16438949],
['nbs-iscc-p:peachgray.9','peachgray','peach gray',[234,227,225],'eae3e1',15393761],
['nbs-iscc-p:peachgray.10','peachgray','peach gray',[193,182,179],'c1b6b3',12695219],
['nbs-iscc-p:peachgray.31','peachgray','peach gray',[236,213,197],'ecd5c5',15521221],
['nbs-iscc-p:peachpink.28','peachpink','peach pink',[244,194,194],'f4c2c2',16040642],
['nbs-iscc-p:peachrust.37','peachrust','peach rust',[203,109,81],'cb6d51',13331793],
['nbs-iscc-p:peachsand.10','peachsand','peach sand',[193,182,179],'c1b6b3',12695219],
['nbs-iscc-p:peachsand.63','peachsand','peach sand',[142,130,121],'8e8279',9339513],
['nbs-iscc-p:peacockblue.174','peacockblue','peacock blue',[0,73,88],'004958',18776],
['nbs-iscc-p:peagreen.120','peagreen','pea green',[138,154,91],'8a9a5b',9083483],
['nbs-iscc-p:pearlcream.9','pearlcream','pearl cream',[234,227,225],'eae3e1',15393761],
['nbs-iscc-p:pearlygates.92','pearlygates','pearly gates ',[240,234,214],'f0ead6',15788758],
['nbs-iscc-p:peasantblue.183','peasantblue','peasant blue',[0,48,78],'00304e',12366],
['nbs-iscc-p:peasantblue.187','peasantblue','peasant blue',[54,69,79],'36454f',3556687],
['nbs-iscc-p:persiangreen.159','persiangreen','persian green',[0,166,147],'00a693',42643],
['nbs-iscc-p:persiangulf.150','persiangulf','persian gulf',[94,113,106],'5e716a',6189418],
['nbs-iscc-p:persiangulf.164','persiangulf','persian gulf',[49,120,115],'317873',3242099],
['nbs-iscc-p:persianmelon.37','persianmelon','persian melon',[203,109,81],'cb6d51',13331793],
['nbs-iscc-p:persianrose.254','persianrose','persian rose',[206,70,118],'ce4676',13518454],
['nbs-iscc-p:persianrose.255','persianrose','persian rose',[179,68,108],'b3446c',11748460],
['nbs-iscc-p:personal.252','personal','personal',[232,204,215],'e8ccd7',15256791],
['nbs-iscc-p:petunia.223','petunia','petunia',[134,96,142],'86608e',8806542],
['nbs-iscc-p:pewter.10','pewter','pewter',[193,182,179],'c1b6b3',12695219],
['nbs-iscc-p:pewtercream.9','pewtercream','pewter cream',[234,227,225],'eae3e1',15393761],
['nbs-iscc-p:phantomblue.171','phantomblue','phantom blue',[156,209,220],'9cd1dc',10277340],
['nbs-iscc-p:phantomblue.184','phantomblue','phantom blue',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:phantomgreen.153','phantomgreen','phantom green',[223,237,232],'dfede8',14675432],
['nbs-iscc-p:phloxpink.248','phloxpink','phlox pink',[222,111,161],'de6fa1',14577569],
['nbs-iscc-p:picturesque.159','picturesque','picturesque',[0,166,147],'00a693',42643],
['nbs-iscc-p:picturesque.162','picturesque','picturesque',[150,222,209],'96ded1',9887441],
['nbs-iscc-p:pinefrost.143','pinefrost','pine frost',[142,209,178],'8ed1b2',9359794],
['nbs-iscc-p:pinkcarnation.246','pinkcarnation','pink carnation',[255,200,214],'ffc8d6',16763094],
['nbs-iscc-p:pinkdust.28','pinkdust','pink dust',[244,194,194],'f4c2c2',16040642],
['nbs-iscc-p:pinkdust.31','pinkdust','pink dust',[236,213,197],'ecd5c5',15521221],
['nbs-iscc-p:pinkicing.249','pinkicing','pink icing',[239,187,204],'efbbcc',15711180],
['nbs-iscc-p:pinkjewel.26','pinkjewel','pink jewel',[248,131,121],'f88379',16286585],
['nbs-iscc-p:pinklavender.252','pinklavender','pink lavender',[232,204,215],'e8ccd7',15256791],
['nbs-iscc-p:pinklily.4','pinklily','pink lily',[249,204,202],'f9ccca',16370890],
['nbs-iscc-p:pinkmist.252','pinkmist','pink mist',[232,204,215],'e8ccd7',15256791],
['nbs-iscc-p:pinkorchid.252','pinkorchid','pink orchid',[232,204,215],'e8ccd7',15256791],
['nbs-iscc-p:pinkpowder.246','pinkpowder','pink powder',[255,200,214],'ffc8d6',16763094],
['nbs-iscc-p:pinkrapture.237','pinkrapture','pink rapture',[158,79,136],'9e4f88',10375048],
['nbs-iscc-p:pinkshock.255','pinkshock','pink shock',[179,68,108],'b3446c',11748460],
['nbs-iscc-p:pinocchio.28','pinocchio','pinocchio',[244,194,194],'f4c2c2',16040642],
['nbs-iscc-p:piquant.162','piquant','piquant',[150,222,209],'96ded1',9887441],
['nbs-iscc-p:piquantgreen.120','piquantgreen','piquant green',[138,154,91],'8a9a5b',9083483],
['nbs-iscc-p:pistachiocream.116','pistachiocream','pistachio cream',[189,218,87],'bdda57',12442199],
['nbs-iscc-p:placid.231','placid','placid',[232,227,229],'e8e3e5',15262693],
['nbs-iscc-p:plantation.43','plantation','plantation',[121,68,59],'79443b',7947323],
['nbs-iscc-p:plantationyellow.83','plantationyellow','plantation yellow',[250,218,94],'fada5e',16439902],
['nbs-iscc-p:platonic.185','platonic','platonic',[145,163,176],'91a3b0',9544624],
['nbs-iscc-p:plentybright.160','plentybright','plenty bright',[0,122,116],'007a74',31348],
['nbs-iscc-p:plumbagoblue.184','plumbagoblue','plumbago blue',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:plumbagoblue.202','plumbagoblue','plumbago blue',[192,200,225],'c0c8e1',12634337],
['nbs-iscc-p:plume.162','plume','plume',[150,222,209],'96ded1',9887441],
['nbs-iscc-p:poetsyellow.101','poetsyellow','poet\'s yellow',[234,230,121],'eae679',15394425],
['nbs-iscc-p:polarbear.172','polarbear','polar bear',[102,170,188],'66aabc',6728380],
['nbs-iscc-p:pompom.86','pompom','pom pom',[248,222,126],'f8de7e',16309886],
['nbs-iscc-p:pompom.101','pompom','pom pom',[234,230,121],'eae679',15394425],
['nbs-iscc-p:poolgreen.159','poolgreen','pool green',[0,166,147],'00a693',42643],
['nbs-iscc-p:porcelaingreen.144','porcelaingreen','porcelain green',[106,171,142],'6aab8e',6990734],
['nbs-iscc-p:poufdevent.249','poufdevent','pouf de vent',[239,187,204],'efbbcc',15711180],
['nbs-iscc-p:poufdevent.252','poufdevent','pouf de vent',[232,204,215],'e8ccd7',15256791],
['nbs-iscc-p:prairiesunset.29','prairiesunset','prairie sunset',[217,166,169],'d9a6a9',14263977],
['nbs-iscc-p:prairiesunset.52','prairiesunset','prairie sunset',[250,181,127],'fab57f',16430463],
['nbs-iscc-p:primeval.145','primeval','primeval',[59,120,97],'3b7861',3897441],
['nbs-iscc-p:primroseyellow.98','primroseyellow','primrose yellow',[233,228,80],'e9e450',15328336],
['nbs-iscc-p:princelyblue.198','princelyblue','princely blue',[179,188,226],'b3bce2',11779298],
['nbs-iscc-p:princelyblue.202','princelyblue','princely blue',[192,200,225],'c0c8e1',12634337],
['nbs-iscc-p:princess.210','princess','princess',[140,130,182],'8c82b6',9208502],
['nbs-iscc-p:priscillablue.173','priscillablue','priscilla blue',[54,117,136],'367588',3569032],
['nbs-iscc-p:prismpink.249','prismpink','prism pink',[239,187,204],'efbbcc',15711180],
['nbs-iscc-p:prismviolet.207','prismviolet','prism violet',[96,78,151],'604e97',6311575],
['nbs-iscc-p:profound.16','profound','profound',[114,47,55],'722f37',7483191],
['nbs-iscc-p:profoundblue.186','profoundblue','profound blue',[83,104,120],'536878',5466232],
['nbs-iscc-p:profoundblue.203','profoundblue','profound blue',[140,146,172],'8c92ac',9212588],
['nbs-iscc-p:promise.92','promise','promise ',[240,234,214],'f0ead6',15788758],
['nbs-iscc-p:promisedland.140','promisedland','promised land',[62,180,137],'3eb489',4109449],
['nbs-iscc-p:promisedland.141','promisedland','promised land',[0,121,89],'007959',31065],
['nbs-iscc-p:promisedland.159','promisedland','promised land',[0,166,147],'00a693',42643],
['nbs-iscc-p:promisedland.160','promisedland','promised land',[0,122,116],'007a74',31348],
['nbs-iscc-p:promisegreen.148','promisegreen','promise green',[199,230,215],'c7e6d7',13100759],
['nbs-iscc-p:prudence.163','prudence','prudence',[102,173,164],'66ada4',6729124],
['nbs-iscc-p:prudence.185','prudence','prudence',[145,163,176],'91a3b0',9544624],
['nbs-iscc-p:pumpkin.53','pumpkin','pumpkin',[217,144,88],'d99058',14258264],
['nbs-iscc-p:puritan.186','puritan','puritan',[83,104,120],'536878',5466232],
['nbs-iscc-p:puritan.192','puritan','puritan',[81,88,94],'51585e',5331038],
['nbs-iscc-p:purpleaster.241','purpleaster','purple aster',[145,92,131],'915c83',9526403],
['nbs-iscc-p:purpleheather.223','purpleheather','purple heather',[134,96,142],'86608e',8806542],
['nbs-iscc-p:purplelake.259','purplelake','purple lake',[103,49,71],'673147',6762823],
['nbs-iscc-p:purplenight.187','purplenight','purple night',[54,69,79],'36454f',3556687],
['nbs-iscc-p:purpleode.214','purpleode','purple ode',[150,144,171],'9690ab',9867435],
['nbs-iscc-p:quail.63','quail','quail',[142,130,121],'8e8279',9339513],
['nbs-iscc-p:quaker.233','quaker','quaker',[139,133,137],'8b8589',9143689],
['nbs-iscc-p:quality.210','quality','quality',[140,130,182],'8c82b6',9208502],
['nbs-iscc-p:qualitypink.247','qualitypink','quality pink',[230,143,172],'e68fac',15110060],
['nbs-iscc-p:qualitypink.250','qualitypink','quality pink',[213,151,174],'d597ae',13997998],
['nbs-iscc-p:queenanne.120','queenanne','queen anne',[138,154,91],'8a9a5b',9083483],
['nbs-iscc-p:queenblue.182','queenblue','queen blue',[67,107,149],'436b95',4418453],
['nbs-iscc-p:queencoral.26','queencoral','queen coral',[248,131,121],'f88379',16286585],
['nbs-iscc-p:queencoral.28','queencoral','queen coral',[244,194,194],'f4c2c2',16040642],
['nbs-iscc-p:queenpink.252','queenpink','queen pink',[232,204,215],'e8ccd7',15256791],
['nbs-iscc-p:quiet.153','quiet','quiet',[223,237,232],'dfede8',14675432],
['nbs-iscc-p:radiance.83','radiance','radiance',[250,218,94],'fada5e',16439902],
['nbs-iscc-p:radiant.26','radiant','radiant',[248,131,121],'f88379',16286585],
['nbs-iscc-p:radiant.37','radiant','radiant',[203,109,81],'cb6d51',13331793],
['nbs-iscc-p:radiantorchid.226','radiantorchid','radiant orchid',[214,202,221],'d6cadd',14076637],
['nbs-iscc-p:rainbowmist.32','rainbowmist','rainbow mist',[199,173,163],'c7ada3',13086115],
['nbs-iscc-p:raisin.47','raisin','raisin',[67,48,46],'43302e',4403246],
['nbs-iscc-p:rapture.15','rapture','rapture',[171,78,82],'ab4e52',11226706],
['nbs-iscc-p:raspberryglace.262','raspberryglace','raspberry glace ',[145,95,109],'915f6d',9527149],
['nbs-iscc-p:raven.267','raven','raven',[34,34,34],'222222',2236962],
['nbs-iscc-p:reed.121','reed','reed',[218,223,183],'dadfb7',14344119],
['nbs-iscc-p:reflection.171','reflection','reflection',[156,209,220],'9cd1dc',10277340],
['nbs-iscc-p:regalorchid.222','regalorchid','regal orchid',[182,149,192],'b695c0',11965888],
['nbs-iscc-p:remote.150','remote','remote',[94,113,106],'5e716a',6189418],
['nbs-iscc-p:repose.122','repose','repose',[143,151,121],'8f9779',9410425],
['nbs-iscc-p:restrainedblue.184','restrainedblue','restrained blue',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:retreat.185','retreat','retreat',[145,163,176],'91a3b0',9544624],
['nbs-iscc-p:retreat.191','retreat','retreat',[129,135,139],'81878b',8488843],
['nbs-iscc-p:rhapsodyblue.187','rhapsodyblue','rhapsody blue',[54,69,79],'36454f',3556687],
['nbs-iscc-p:rigiblue.186','rigiblue','rigi blue ',[83,104,120],'536878',5466232],
['nbs-iscc-p:rill.163','rill','rill',[102,173,164],'66ada4',6729124],
['nbs-iscc-p:rioblue.185','rioblue','rio blue',[145,163,176],'91a3b0',9544624],
['nbs-iscc-p:riogrande.90','riogrande','rio grande',[194,178,128],'c2b280',12759680],
['nbs-iscc-p:rivermist.186','rivermist','river mist',[83,104,120],'536878',5466232],
['nbs-iscc-p:rivernile.164','rivernile','river nile',[49,120,115],'317873',3242099],
['nbs-iscc-p:riviera.182','riviera','riviera',[67,107,149],'436b95',4418453],
['nbs-iscc-p:rivuletblue.172','rivuletblue','rivulet blue',[102,170,188],'66aabc',6728380],
['nbs-iscc-p:robinegg.162','robinegg','robin egg',[150,222,209],'96ded1',9887441],
['nbs-iscc-p:romance.252','romance','romance',[232,204,215],'e8ccd7',15256791],
['nbs-iscc-p:romance.214','romance','romance',[150,144,171],'9690ab',9867435],
['nbs-iscc-p:romance.228','romance','romance',[121,104,120],'796878',7956600],
['nbs-iscc-p:romanpurple.229','romanpurple','roman purple',[80,64,77],'50404d',5259341],
['nbs-iscc-p:romanpurple.234','romanpurple','roman purple',[93,85,91],'5d555b',6116699],
['nbs-iscc-p:romanrose.47','romanrose','roman rose',[67,48,46],'43302e',4403246],
['nbs-iscc-p:romantan.42','romantan','roman tan',[168,124,109],'a87c6d',11041901],
['nbs-iscc-p:romanticblue.180','romanticblue','romantic blue',[161,202,241],'a1caf1',10603249],
['nbs-iscc-p:romanticblue.181','romanticblue','romantic blue',[112,163,204],'70a3cc',7381964],
['nbs-iscc-p:roomgreen.154','roomgreen','room green',[178,190,181],'b2beb5',11714229],
['nbs-iscc-p:rosario.29','rosario','rosario',[217,166,169],'d9a6a9',14263977],
['nbs-iscc-p:rosea.249','rosea','rosea ',[239,187,204],'efbbcc',15711180],
['nbs-iscc-p:roseash.9','roseash','rose ash',[234,227,225],'eae3e1',15393761],
['nbs-iscc-p:roseash.31','roseash','rose ash',[236,213,197],'ecd5c5',15521221],
['nbs-iscc-p:rosecaroline.29','rosecaroline','rose caroline',[217,166,169],'d9a6a9',14263977],
['nbs-iscc-p:rosecastor.19','rosecastor','rose castor',[144,93,93],'905d5d',9461085],
['nbs-iscc-p:rosecastor.22','rosecastor','rose castor',[143,129,127],'8f817f',9404799],
['nbs-iscc-p:rosecloud.5','rosecloud','rose cloud',[222,165,164],'dea5a4',14591396],
['nbs-iscc-p:rosedust.31','rosedust','rose dust ',[236,213,197],'ecd5c5',15521221],
['nbs-iscc-p:rosegarden.248','rosegarden','rose garden',[222,111,161],'de6fa1',14577569],
['nbs-iscc-p:roseglory.3','roseglory','rose glory',[228,113,122],'e4717a',14971258],
['nbs-iscc-p:roseleaf.2','roseleaf','rose leaf',[234,147,153],'ea9399',15373209],
['nbs-iscc-p:rosemarie.248','rosemarie','rose marie',[222,111,161],'de6fa1',14577569],
['nbs-iscc-p:rosemist.18','rosemist','rose mist',[173,136,132],'ad8884',11372676],
['nbs-iscc-p:rosemist.32','rosemist','rose mist',[199,173,163],'c7ada3',13086115],
['nbs-iscc-p:rosemorn.4','rosemorn','rose morn',[249,204,202],'f9ccca',16370890],
['nbs-iscc-p:rosemorn.7','rosemorn','rose morn',[234,216,215],'ead8d7',15390935],
['nbs-iscc-p:rosemorn.28','rosemorn','rose morn',[244,194,194],'f4c2c2',16040642],
['nbs-iscc-p:rosemorn.31','rosemorn','rose morn',[236,213,197],'ecd5c5',15521221],
['nbs-iscc-p:rosemuse.32','rosemuse','rose muse',[199,173,163],'c7ada3',13086115],
['nbs-iscc-p:rosenude.31','rosenude','rose nude',[236,213,197],'ecd5c5',15521221],
['nbs-iscc-p:rosepearl.7','rosepearl','rose pearl',[234,216,215],'ead8d7',15390935],
['nbs-iscc-p:rosepearl.31','rosepearl','rose pearl',[236,213,197],'ecd5c5',15521221],
['nbs-iscc-p:roseshadow.7','roseshadow','rose shadow',[234,216,215],'ead8d7',15390935],
['nbs-iscc-p:roseshadow.31','roseshadow','rose shadow',[236,213,197],'ecd5c5',15521221],
['nbs-iscc-p:rosesmoke.18','rosesmoke','rose smoke',[173,136,132],'ad8884',11372676],
['nbs-iscc-p:rosesmoke.22','rosesmoke','rose smoke',[143,129,127],'8f817f',9404799],
['nbs-iscc-p:rosestain.19','rosestain','rose stain',[144,93,93],'905d5d',9461085],
['nbs-iscc-p:rosypink.4','rosypink','rosy pink',[249,204,202],'f9ccca',16370890],
['nbs-iscc-p:royallilac.223','royallilac','royal lilac',[134,96,142],'86608e',8806542],
['nbs-iscc-p:royalrobe.212','royalrobe','royal robe',[47,33,64],'2f2140',3088704],
['nbs-iscc-p:royalviolet.259','royalviolet','royal violet',[103,49,71],'673147',6762823],
['nbs-iscc-p:rubylake.259','rubylake','ruby lake',[103,49,71],'673147',6762823],
['nbs-iscc-p:ruffledpetunia.247','ruffledpetunia','ruffled petunia',[230,143,172],'e68fac',15110060],
['nbs-iscc-p:russetleaf.91','russetleaf','russet leaf',[161,143,96],'a18f60',10588000],
['nbs-iscc-p:russetyellow.87','russetyellow','russet yellow',[201,174,93],'c9ae5d',13217373],
['nbs-iscc-p:russianblue.185','russianblue','russian blue',[145,163,176],'91a3b0',9544624],
['nbs-iscc-p:russianblue.191','russianblue','russian blue',[129,135,139],'81878b',8488843],
['nbs-iscc-p:rustrose.15','rustrose','rust rose',[171,78,82],'ab4e52',11226706],
['nbs-iscc-p:sable.58','sable','sable',[111,78,55],'6f4e37',7294519],
['nbs-iscc-p:sagablue.185','sagablue','saga blue',[145,163,176],'91a3b0',9544624],
['nbs-iscc-p:sage.120','sage','sage',[138,154,91],'8a9a5b',9083483],
['nbs-iscc-p:sailor.24','sailor','sailor',[40,32,34],'282022',2629666],
['nbs-iscc-p:salmonbuff.29','salmonbuff','salmon buff',[217,166,169],'d9a6a9',14263977],
['nbs-iscc-p:salmonflush.28','salmonflush','salmon flush',[244,194,194],'f4c2c2',16040642],
['nbs-iscc-p:salmonpink.28','salmonpink','salmon pink ',[244,194,194],'f4c2c2',16040642],
['nbs-iscc-p:salmonrose.26','salmonrose','salmon rose',[248,131,121],'f88379',16286585],
['nbs-iscc-p:salomeblue.159','salomeblue','salome blue',[0,166,147],'00a693',42643],
['nbs-iscc-p:salomegreen.140','salomegreen','salome green',[62,180,137],'3eb489',4109449],
['nbs-iscc-p:salomegreen.143','salomegreen','salome green',[142,209,178],'8ed1b2',9359794],
['nbs-iscc-p:salomepink.2','salomepink','salome pink',[234,147,153],'ea9399',15373209],
['nbs-iscc-p:sandlewood.57','sandlewood','sandlewood',[166,123,91],'a67b5b',10910555],
['nbs-iscc-p:sandrift.63','sandrift','sandrift',[142,130,121],'8e8279',9339513],
['nbs-iscc-p:sandstucco.45','sandstucco','sand stucco',[151,127,115],'977f73',9928563],
['nbs-iscc-p:santaanitagreen.163','santaanitagreen','santa anita green',[102,173,164],'66ada4',6729124],
['nbs-iscc-p:saxeblue.173','saxeblue','saxe blue',[54,117,136],'367588',3569032],
['nbs-iscc-p:saxeblue.186','saxeblue','saxe blue',[83,104,120],'536878',5466232],
['nbs-iscc-p:scarab.164','scarab','scarab',[49,120,115],'317873',3242099],
['nbs-iscc-p:scarlet.34','scarlet','scarlet',[226,88,34],'e25822',14833698],
['nbs-iscc-p:scotchblue.215','scotchblue','scotch blue',[85,76,105],'554c69',5590121],
['nbs-iscc-p:scotchmist.154','scotchmist','scotch mist',[178,190,181],'b2beb5',11714229],
['nbs-iscc-p:scotchmist.93','scotchmist','scotch mist',[191,184,165],'bfb8a5',12564645],
['nbs-iscc-p:scotchmist.121','scotchmist','scotch mist',[218,223,183],'dadfb7',14344119],
['nbs-iscc-p:seafoam.92','seafoam','sea foam ',[240,234,214],'f0ead6',15788758],
['nbs-iscc-p:seafoam.153','seafoam','sea foam ',[223,237,232],'dfede8',14675432],
['nbs-iscc-p:seafog.226','seafog','sea fog',[214,202,221],'d6cadd',14076637],
['nbs-iscc-p:seafog.232','seafog','sea fog',[191,185,189],'bfb9bd',12564925],
['nbs-iscc-p:seamist.121','seamist','sea mist',[218,223,183],'dadfb7',14344119],
['nbs-iscc-p:seance.252','seance','seance',[232,204,215],'e8ccd7',15256791],
['nbs-iscc-p:seclusion.156','seclusion','seclusion',[78,87,85],'4e5755',5134165],
['nbs-iscc-p:secret.228','secret','secret',[121,104,120],'796878',7956600],
['nbs-iscc-p:sentimentalmood.184','sentimentalmood','sentimental mood',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:sentimentalmood.202','sentimentalmood','sentimental mood',[192,200,225],'c0c8e1',12634337],
['nbs-iscc-p:serene.31','serene','serene',[236,213,197],'ecd5c5',15521221],
['nbs-iscc-p:serenity.250','serenity','serenity',[213,151,174],'d597ae',13997998],
['nbs-iscc-p:seville.120','seville','seville',[138,154,91],'8a9a5b',9083483],
['nbs-iscc-p:sevres.176','sevres','sevres',[0,161,194],'00a1c2',41410],
['nbs-iscc-p:sevres.178','sevres','sevres',[0,103,165],'0067a5',26533],
['nbs-iscc-p:shadowaqua.150','shadowaqua','shadow aqua',[94,113,106],'5e716a',6189418],
['nbs-iscc-p:shadowbeige.94','shadowbeige','shadow beige',[150,113,23],'967117',9859351],
['nbs-iscc-p:shadowblue.185','shadowblue','shadow blue',[145,163,176],'91a3b0',9544624],
['nbs-iscc-p:shadowgreen.150','shadowgreen','shadow green',[94,113,106],'5e716a',6189418],
['nbs-iscc-p:shadowgreen.151','shadowgreen','shadow green',[58,75,71],'3a4b47',3820359],
['nbs-iscc-p:shadowlilac.228','shadowlilac','shadow lilac',[121,104,120],'796878',7956600],
['nbs-iscc-p:shadowlime.119','shadowlime','shadow lime',[201,220,137],'c9dc89',13229193],
['nbs-iscc-p:shadowmauve.228','shadowmauve','shadow mauve',[121,104,120],'796878',7956600],
['nbs-iscc-p:shadowolive.105','shadowolive','shadow olive',[185,181,125],'b9b57d',12170621],
['nbs-iscc-p:shamrock.131','shamrock','shamrock',[68,148,74],'44944a',4494410],
['nbs-iscc-p:shellcoral.28','shellcoral','shell coral',[244,194,194],'f4c2c2',16040642],
['nbs-iscc-p:shellcoral.31','shellcoral','shell coral',[236,213,197],'ecd5c5',15521221],
['nbs-iscc-p:shine.104','shine','shine',[235,232,164],'ebe8a4',15460516],
['nbs-iscc-p:shining.101','shining','shining',[234,230,121],'eae679',15394425],
['nbs-iscc-p:shoreline.186','shoreline','shore line',[83,104,120],'536878',5466232],
['nbs-iscc-p:shrimppink.26','shrimppink','shrimp pink',[248,131,121],'f88379',16286585],
['nbs-iscc-p:siamsand.90','siamsand','siam sand',[194,178,128],'c2b280',12759680],
['nbs-iscc-p:sierra.38','sierra','sierra',[158,71,50],'9e4732',10372914],
['nbs-iscc-p:sierra.55','sierra','sierra',[128,70,27],'80461b',8406555],
['nbs-iscc-p:silentnight.150','silentnight','silent night',[94,113,106],'5e716a',6189418],
['nbs-iscc-p:silverblue.184','silverblue','silver blue',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:silverblue.202','silverblue','silver blue',[192,200,225],'c0c8e1',12634337],
['nbs-iscc-p:silvercloud.184','silvercloud','silver cloud',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:silvercloud.190','silvercloud','silver cloud',[180,188,192],'b4bcc0',11844800],
['nbs-iscc-p:silvergreen.121','silvergreen','silver green',[218,223,183],'dadfb7',14344119],
['nbs-iscc-p:silverlining.93','silverlining','silver lining',[191,184,165],'bfb8a5',12564645],
['nbs-iscc-p:silverlining.264','silverlining','silver lining',[185,184,181],'b9b8b5',12171445],
['nbs-iscc-p:silvernight.227','silvernight','silver night',[170,152,169],'aa98a9',11180201],
['nbs-iscc-p:silverpine.150','silverpine','silver pine ',[94,113,106],'5e716a',6189418],
['nbs-iscc-p:silverpink.8','silverpink','silver pink',[196,174,173],'c4aead',12889773],
['nbs-iscc-p:silverpink.32','silverpink','silver pink',[199,173,163],'c7ada3',13086115],
['nbs-iscc-p:silversalmon.32','silversalmon','silver salmon',[199,173,163],'c7ada3',13086115],
['nbs-iscc-p:silversky.231','silversky','silver sky',[232,227,229],'e8e3e5',15262693],
['nbs-iscc-p:silversky.232','silversky','silver sky',[191,185,189],'bfb9bd',12564925],
['nbs-iscc-p:silverwing.232','silverwing','silver wing ',[191,185,189],'bfb9bd',12564925],
['nbs-iscc-p:silverwing.233','silverwing','silver wing ',[139,133,137],'8b8589',9143689],
['nbs-iscc-p:singingblue.168','singingblue','singing blue',[35,158,186],'239eba',2334394],
['nbs-iscc-p:singingblue.172','singingblue','singing blue',[102,170,188],'66aabc',6728380],
['nbs-iscc-p:sky.122','sky','sky',[143,151,121],'8f9779',9410425],
['nbs-iscc-p:skycloud.190','skycloud','sky cloud',[180,188,192],'b4bcc0',11844800],
['nbs-iscc-p:skygreen.162','skygreen','sky green',[150,222,209],'96ded1',9887441],
['nbs-iscc-p:skylane.148','skylane','sky lane',[199,230,215],'c7e6d7',13100759],
['nbs-iscc-p:slate.234','slate','slate',[93,85,91],'5d555b',6116699],
['nbs-iscc-p:slate.266','slate','slate',[85,85,85],'555555',5592405],
['nbs-iscc-p:slateblue.186','slateblue','slate blue',[83,104,120],'536878',5466232],
['nbs-iscc-p:slateblue.192','slateblue','slate blue',[81,88,94],'51585e',5331038],
['nbs-iscc-p:slatecitron.120','slatecitron','slate citron',[138,154,91],'8a9a5b',9083483],
['nbs-iscc-p:slategreen.150','slategreen','slate green ',[94,113,106],'5e716a',6189418],
['nbs-iscc-p:slateorchid.228','slateorchid','slate orchid',[121,104,120],'796878',7956600],
['nbs-iscc-p:slaterose.19','slaterose','slate rose',[144,93,93],'905d5d',9461085],
['nbs-iscc-p:slateturquoise.173','slateturquoise','slate turquoise',[54,117,136],'367588',3569032],
['nbs-iscc-p:slateturquoise.186','slateturquoise','slate turquoise',[83,104,120],'536878',5466232],
['nbs-iscc-p:slateviolet.228','slateviolet','slate violet ',[121,104,120],'796878',7956600],
['nbs-iscc-p:sleepyhollow.149','sleepyhollow','sleepy hollow',[141,163,153],'8da399',9282457],
['nbs-iscc-p:sleepyhollow.185','sleepyhollow','sleepy hollow',[145,163,176],'91a3b0',9544624],
['nbs-iscc-p:sleighbells.171','sleighbells','sleigh bells',[156,209,220],'9cd1dc',10277340],
['nbs-iscc-p:sleighbells.184','sleighbells','sleigh bells',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:smile.92','smile','smile',[240,234,214],'f0ead6',15788758],
['nbs-iscc-p:smiles.28','smiles','smiles',[244,194,194],'f4c2c2',16040642],
['nbs-iscc-p:smog.79','smog','smog',[174,155,130],'ae9b82',11443074],
['nbs-iscc-p:smoke.185','smoke','smoke',[145,163,176],'91a3b0',9544624],
['nbs-iscc-p:smokeblue.203','smokeblue','smoke blue',[140,146,172],'8c92ac',9212588],
['nbs-iscc-p:smokepine.122','smokepine','smoke pine',[143,151,121],'8f9779',9410425],
['nbs-iscc-p:smokepine.154','smokepine','smoke pine',[178,190,181],'b2beb5',11714229],
['nbs-iscc-p:smokering.185','smokering','smoke ring',[145,163,176],'91a3b0',9544624],
['nbs-iscc-p:smokestainrose.18','smokestainrose','smokestain rose',[173,136,132],'ad8884',11372676],
['nbs-iscc-p:snowgreen.148','snowgreen','snow green',[199,230,215],'c7e6d7',13100759],
['nbs-iscc-p:snowgreen.184','snowgreen','snow green',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:snowgreen.190','snowgreen','snow green',[180,188,192],'b4bcc0',11844800],
['nbs-iscc-p:solitary.153','solitary','solitary',[223,237,232],'dfede8',14675432],
['nbs-iscc-p:solitary.154','solitary','solitary',[178,190,181],'b2beb5',11714229],
['nbs-iscc-p:solitary.263','solitary','solitary',[242,243,244],'f2f3f4',15922164],
['nbs-iscc-p:solitary.264','solitary','solitary',[185,184,181],'b9b8b5',12171445],
['nbs-iscc-p:solitaryblue.186','solitaryblue','solitary blue',[83,104,120],'536878',5466232],
['nbs-iscc-p:somberblue.186','somberblue','somber blue',[83,104,120],'536878',5466232],
['nbs-iscc-p:sonata.28','sonata','sonata',[244,194,194],'f4c2c2',16040642],
['nbs-iscc-p:songofnorway.159','songofnorway','song of norway',[0,166,147],'00a693',42643],
['nbs-iscc-p:sophisticatedlady.222','sophisticatedlady','sophisticated lady',[182,149,192],'b695c0',11965888],
['nbs-iscc-p:sorcerer.215','sorcerer','sorcerer',[85,76,105],'554c69',5590121],
['nbs-iscc-p:sorcerer.228','sorcerer','sorcerer',[121,104,120],'796878',7956600],
['nbs-iscc-p:sorcerer.187','sorcerer','sorcerer',[54,69,79],'36454f',3556687],
['nbs-iscc-p:sorcerer.188','sorcerer','sorcerer',[32,40,48],'202830',2107440],
['nbs-iscc-p:sorcerer.193','sorcerer','sorcerer',[32,36,40],'202428',2106408],
['nbs-iscc-p:sorrento.164','sorrento','sorrento',[49,120,115],'317873',3242099],
['nbs-iscc-p:southernrose.42','southernrose','southern rose',[168,124,109],'a87c6d',11041901],
['nbs-iscc-p:southernsun.83','southernsun','southern sun',[250,218,94],'fada5e',16439902],
['nbs-iscc-p:southernsun.86','southernsun','southern sun',[248,222,126],'f8de7e',16309886],
['nbs-iscc-p:souvenir.213','souvenir','souvenir',[196,195,221],'c4c3dd',12895197],
['nbs-iscc-p:sovereignblue.181','sovereignblue','sovereign blue',[112,163,204],'70a3cc',7381964],
['nbs-iscc-p:sovereignblue.199','sovereignblue','sovereign blue',[135,145,191],'8791bf',8884671],
['nbs-iscc-p:spanishblue.164','spanishblue','spanish blue',[49,120,115],'317873',3242099],
['nbs-iscc-p:spanishgold.71','spanishgold','spanish gold',[227,168,87],'e3a857',14919767],
['nbs-iscc-p:spanishwhite.73','spanishwhite','spanish white',[250,214,165],'fad6a5',16438949],
['nbs-iscc-p:sparkle.171','sparkle','sparkle',[156,209,220],'9cd1dc',10277340],
['nbs-iscc-p:sparrow.80','sparrow','sparrow',[126,109,90],'7e6d5a',8285530],
['nbs-iscc-p:spectrablue.194','spectrablue','spectra blue',[48,38,122],'30267a',3155578],
['nbs-iscc-p:spectragreen.165','spectragreen','spectra green',[0,75,73],'004b49',19273],
['nbs-iscc-p:spectrared.11','spectrared','spectra red',[190,0,50],'be0032',12451890],
['nbs-iscc-p:spectrarose.254','spectrarose','spectra rose',[206,70,118],'ce4676',13518454],
['nbs-iscc-p:spectrayellow.82','spectrayellow','spectra yellow',[243,195,0],'f3c300',15975168],
['nbs-iscc-p:spice.54','spice','spice',[174,105,56],'ae6938',11430200],
['nbs-iscc-p:spice.57','spice','spice',[166,123,91],'a67b5b',10910555],
['nbs-iscc-p:spiritualblue.184','spiritualblue','spiritual blue',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:spitfire.15','spitfire','spitfire',[171,78,82],'ab4e52',11226706],
['nbs-iscc-p:spray.162','spray','spray',[150,222,209],'96ded1',9887441],
['nbs-iscc-p:spring.130','spring','spring',[131,211,125],'83d37d',8639357],
['nbs-iscc-p:springbud.119','springbud','spring bud',[201,220,137],'c9dc89',13229193],
['nbs-iscc-p:springdream.101','springdream','spring dream',[234,230,121],'eae679',15394425],
['nbs-iscc-p:springdream.104','springdream','spring dream',[235,232,164],'ebe8a4',15460516],
['nbs-iscc-p:springeve.101','springeve','spring eve',[234,230,121],'eae679',15394425],
['nbs-iscc-p:springeve.116','springeve','spring eve',[189,218,87],'bdda57',12442199],
['nbs-iscc-p:springeve.119','springeve','spring eve',[201,220,137],'c9dc89',13229193],
['nbs-iscc-p:springflower.98','springflower','spring flower ',[233,228,80],'e9e450',15328336],
['nbs-iscc-p:springstream.162','springstream','spring stream',[150,222,209],'96ded1',9887441],
['nbs-iscc-p:springyellow.89','springyellow','spring yellow',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:starchwhite.184','starchwhite','starch white',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:static.185','static','static',[145,163,176],'91a3b0',9544624],
['nbs-iscc-p:steamblue.189','steamblue','steam blue',[233,233,237],'e9e9ed',15329773],
['nbs-iscc-p:steelblue.172','steelblue','steel blue',[102,170,188],'66aabc',6728380],
['nbs-iscc-p:stellar.249','stellar','stellar',[239,187,204],'efbbcc',15711180],
['nbs-iscc-p:sterlingblue.185','sterlingblue','sterling blue',[145,163,176],'91a3b0',9544624],
['nbs-iscc-p:sterlingblue.190','sterlingblue','sterling blue',[180,188,192],'b4bcc0',11844800],
['nbs-iscc-p:stoic.267','stoic','stoic',[34,34,34],'222222',2236962],
['nbs-iscc-p:storm.186','storm','storm',[83,104,120],'536878',5466232],
['nbs-iscc-p:stormynight.187','stormynight','stormy night',[54,69,79],'36454f',3556687],
['nbs-iscc-p:stratosphere.186','stratosphere','stratosphere',[83,104,120],'536878',5466232],
['nbs-iscc-p:stratosphere.192','stratosphere','stratosphere',[81,88,94],'51585e',5331038],
['nbs-iscc-p:strawyellow.89','strawyellow','straw yellow',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:streamlet.162','streamlet','streamlet',[150,222,209],'96ded1',9887441],
['nbs-iscc-p:streamline.162','streamline','streamline',[150,222,209],'96ded1',9887441],
['nbs-iscc-p:string.92','string','string',[240,234,214],'f0ead6',15788758],
['nbs-iscc-p:stylegray.186','stylegray','style gray',[83,104,120],'536878',5466232],
['nbs-iscc-p:sublime.185','sublime','sublime',[145,163,176],'91a3b0',9544624],
['nbs-iscc-p:sublime.203','sublime','sublime',[140,146,172],'8c92ac',9212588],
['nbs-iscc-p:suet.92','suet','suet',[240,234,214],'f0ead6',15788758],
['nbs-iscc-p:suezblue.187','suezblue','suez blue',[54,69,79],'36454f',3556687],
['nbs-iscc-p:suezgreen.164','suezgreen','suez green',[49,120,115],'317873',3242099],
['nbs-iscc-p:suggestion.162','suggestion','suggestion',[150,222,209],'96ded1',9887441],
['nbs-iscc-p:sulphategreen.159','sulphategreen','sulphate green',[0,166,147],'00a693',42643],
['nbs-iscc-p:sulphategreen.163','sulphategreen','sulphate green',[102,173,164],'66ada4',6729124],
['nbs-iscc-p:sulphur.101','sulphur','sulphur',[234,230,121],'eae679',15394425],
['nbs-iscc-p:sultana.19','sultana','sultana',[144,93,93],'905d5d',9461085],
['nbs-iscc-p:sultansand.76','sultansand','sultan sand',[193,154,107],'c19a6b',12687979],
['nbs-iscc-p:summergreen.140','summergreen','summer green',[62,180,137],'3eb489',4109449],
['nbs-iscc-p:summergreen.143','summergreen','summer green',[142,209,178],'8ed1b2',9359794],
['nbs-iscc-p:summershower.148','summershower','summer shower',[199,230,215],'c7e6d7',13100759],
['nbs-iscc-p:summersun.98','summersun','summer sun',[233,228,80],'e9e450',15328336],
['nbs-iscc-p:sunburst.70','sunburst','sunburst',[251,201,127],'fbc97f',16501119],
['nbs-iscc-p:sunburst.71','sunburst','sunburst',[227,168,87],'e3a857',14919767],
['nbs-iscc-p:sunburst.73','sunburst','sunburst',[250,214,165],'fad6a5',16438949],
['nbs-iscc-p:sundown.28','sundown','sundown',[244,194,194],'f4c2c2',16040642],
['nbs-iscc-p:sundown.29','sundown','sundown',[217,166,169],'d9a6a9',14263977],
['nbs-iscc-p:sundown.73','sundown','sundown',[250,214,165],'fad6a5',16438949],
['nbs-iscc-p:sunggreen.122','sunggreen','sung green',[143,151,121],'8f9779',9410425],
['nbs-iscc-p:sunglow.86','sunglow','sun glow ',[248,222,126],'f8de7e',16309886],
['nbs-iscc-p:sunglow.89','sunglow','sun glow ',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:sungod.35','sungod','sun god ',[217,96,59],'d9603b',14245947],
['nbs-iscc-p:sungreen.104','sungreen','sun green',[235,232,164],'ebe8a4',15460516],
['nbs-iscc-p:sunrose.4','sunrose','sun rose',[249,204,202],'f9ccca',16370890],
['nbs-iscc-p:sunsetcream.92','sunsetcream','sunset cream',[240,234,214],'f0ead6',15788758],
['nbs-iscc-p:sunshine.101','sunshine','sunshine',[234,230,121],'eae679',15394425],
['nbs-iscc-p:sunyellow.98','sunyellow','sun yellow',[233,228,80],'e9e450',15328336],
['nbs-iscc-p:sunyellow.101','sunyellow','sun yellow',[234,230,121],'eae679',15394425],
['nbs-iscc-p:superior.164','superior','superior',[49,120,115],'317873',3242099],
['nbs-iscc-p:supreme.177','supreme','supreme',[73,151,208],'4997d0',4822992],
['nbs-iscc-p:surfspray.153','surfspray','surf spray',[223,237,232],'dfede8',14675432],
['nbs-iscc-p:surrender.222','surrender','surrender',[182,149,192],'b695c0',11965888],
['nbs-iscc-p:sussanquapink.246','sussanquapink','sussanqua pink',[255,200,214],'ffc8d6',16763094],
['nbs-iscc-p:sussanquapink.247','sussanquapink','sussanqua pink',[230,143,172],'e68fac',15110060],
['nbs-iscc-p:swank.213','swank','swank',[196,195,221],'c4c3dd',12895197],
['nbs-iscc-p:swank.226','swank','swank',[214,202,221],'d6cadd',14076637],
['nbs-iscc-p:sweetblue.184','sweetblue','sweet blue',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:sweetlady.210','sweetlady','sweet lady',[140,130,182],'8c82b6',9208502],
['nbs-iscc-p:sweetlavender.213','sweetlavender','sweet lavender',[196,195,221],'c4c3dd',12895197],
['nbs-iscc-p:sweetpeapink.262','sweetpeapink','sweet pea pink',[145,95,109],'915f6d',9527149],
['nbs-iscc-p:swissblue.203','swissblue','swiss blue',[140,146,172],'8c92ac',9212588],
['nbs-iscc-p:swissrose.19','swissrose','swiss rose',[144,93,93],'905d5d',9461085],
['nbs-iscc-p:sylvan.121','sylvan','sylvan',[218,223,183],'dadfb7',14344119],
['nbs-iscc-p:tabu.186','tabu','tabu',[83,104,120],'536878',5466232],
['nbs-iscc-p:talisman.52','talisman','talisman',[250,181,127],'fab57f',16430463],
['nbs-iscc-p:talisman.53','talisman','talisman',[217,144,88],'d99058',14258264],
['nbs-iscc-p:tangerine.35','tangerine','tangerine',[217,96,59],'d9603b',14245947],
['nbs-iscc-p:tangerine.50','tangerine','tangerine',[237,135,45],'ed872d',15566637],
['nbs-iscc-p:tango.3','tango','tango',[228,113,122],'e4717a',14971258],
['nbs-iscc-p:tapestrybeige.45','tapestrybeige','tapestry beige',[151,127,115],'977f73',9928563],
['nbs-iscc-p:tapestryred.16','tapestryred','tapestry red',[114,47,55],'722f37',7483191],
['nbs-iscc-p:tauperose.23','tauperose','taupe rose',[92,80,79],'5c504f',6049871],
['nbs-iscc-p:tauperose.46','tauperose','taupe rose',[103,76,71],'674c47',6769735],
['nbs-iscc-p:taupesand.94','taupesand','taupe sand',[150,113,23],'967117',9859351],
['nbs-iscc-p:tealblue.173','tealblue','teal blue',[54,117,136],'367588',3569032],
['nbs-iscc-p:teenagepink.249','teenagepink','teen age pink',[239,187,204],'efbbcc',15711180],
['nbs-iscc-p:televisionblue.187','televisionblue','television blue',[54,69,79],'36454f',3556687],
['nbs-iscc-p:tempest.229','tempest','tempest',[80,64,77],'50404d',5259341],
['nbs-iscc-p:tempestblue.192','tempestblue','tempest blue',[81,88,94],'51585e',5331038],
['nbs-iscc-p:temple.122','temple','temple',[143,151,121],'8f9779',9410425],
['nbs-iscc-p:temptation.226','temptation','temptation',[214,202,221],'d6cadd',14076637],
['nbs-iscc-p:teteatete.171','teteatete','tete-a-tete',[156,209,220],'9cd1dc',10277340],
['nbs-iscc-p:thamesriver.185','thamesriver','thames river',[145,163,176],'91a3b0',9544624],
['nbs-iscc-p:thamesriver.190','thamesriver','thames river',[180,188,192],'b4bcc0',11844800],
['nbs-iscc-p:theatricalblue.182','theatricalblue','theatrical blue',[67,107,149],'436b95',4418453],
['nbs-iscc-p:thistlebloom.258','thistlebloom','thistle bloom',[168,81,110],'a8516e',11030894],
['nbs-iscc-p:thistledown.252','thistledown','thistle down',[232,204,215],'e8ccd7',15256791],
['nbs-iscc-p:tobaccobrown.46','tobaccobrown','tobacco brown',[103,76,71],'674c47',6769735],
['nbs-iscc-p:tomatored.11','tomatored','tomato red',[190,0,50],'be0032',12451890],
['nbs-iscc-p:topazamber.53','topazamber','topaz amber',[217,144,88],'d99058',14258264],
['nbs-iscc-p:torchlight.11','torchlight','torchlight',[190,0,50],'be0032',12451890],
['nbs-iscc-p:torchlight.12','torchlight','torchlight',[188,63,74],'bc3f4a',12336970],
['nbs-iscc-p:toreador.12','toreador','toreador',[188,63,74],'bc3f4a',12336970],
['nbs-iscc-p:tourmalinegreen.148','tourmalinegreen','tourmaline green',[199,230,215],'c7e6d7',13100759],
['nbs-iscc-p:tourmalinegreen.162','tourmalinegreen','tourmaline green',[150,222,209],'96ded1',9887441],
['nbs-iscc-p:tourmalinepink.246','tourmalinepink','tourmaline pink',[255,200,214],'ffc8d6',16763094],
['nbs-iscc-p:tourmalinepink.249','tourmalinepink','tourmaline pink',[239,187,204],'efbbcc',15711180],
['nbs-iscc-p:tradewinds.186','tradewinds','trade winds',[83,104,120],'536878',5466232],
['nbs-iscc-p:trailgreen.146','trailgreen','trail green',[27,77,62],'1b4d3e',1789246],
['nbs-iscc-p:trailgreen.151','trailgreen','trail green',[58,75,71],'3a4b47',3820359],
['nbs-iscc-p:tranquilgreen.151','tranquilgreen','tranquil green',[58,75,71],'3a4b47',3820359],
['nbs-iscc-p:tranquilgreen.187','tranquilgreen','tranquil green',[54,69,79],'36454f',3556687],
['nbs-iscc-p:transatlanticblue.188','transatlanticblue','transatlantic blue',[32,40,48],'202830',2107440],
['nbs-iscc-p:translucentblue.185','translucentblue','translucent blue',[145,163,176],'91a3b0',9544624],
['nbs-iscc-p:transparentyellow.89','transparentyellow','transparent yellow',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:transparentyellow.92','transparentyellow','transparent yellow',[240,234,214],'f0ead6',15788758],
['nbs-iscc-p:trellis.135','trellis','trellis',[147,197,146],'93c592',9684370],
['nbs-iscc-p:tropicnight.245','tropicnight','tropic night',[131,100,121],'836479',8610937],
['nbs-iscc-p:troubador.11','troubador','troubador',[190,0,50],'be0032',12451890],
['nbs-iscc-p:troubador.12','troubador','troubador',[188,63,74],'bc3f4a',12336970],
['nbs-iscc-p:tulipyellow.83','tulipyellow','tulip yellow',[250,218,94],'fada5e',16439902],
['nbs-iscc-p:tumbleweed.89','tumbleweed','tumbleweed',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:tumbleweed.93','tumbleweed','tumbleweed',[191,184,165],'bfb8a5',12564645],
['nbs-iscc-p:turfgreen.131','turfgreen','turf green',[68,148,74],'44944a',4494410],
['nbs-iscc-p:turfgreen.136','turfgreen','turf green',[103,146,103],'679267',6787687],
['nbs-iscc-p:turquoiseblue.163','turquoiseblue','turquoise blue',[102,173,164],'66ada4',6729124],
['nbs-iscc-p:tuscansand.94','tuscansand','tuscan sand',[150,113,23],'967117',9859351],
['nbs-iscc-p:twilightmood.184','twilightmood','twilight mood',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:twilightsun.89','twilightsun','twilight sun',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:twilightsun.121','twilightsun','twilight sun',[218,223,183],'dadfb7',14344119],
['nbs-iscc-p:twinkle.184','twinkle','twinkle',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:tyrianblue.186','tyrianblue','tyrian blue',[83,104,120],'536878',5466232],
['nbs-iscc-p:ultramarine.194','ultramarine','ultramarine',[48,38,122],'30267a',3155578],
['nbs-iscc-p:uniformblue.183','uniformblue','uniform blue',[0,48,78],'00304e',12366],
['nbs-iscc-p:unique.104','unique','unique',[235,232,164],'ebe8a4',15460516],
['nbs-iscc-p:universal.187','universal','universal',[54,69,79],'36454f',3556687],
['nbs-iscc-p:vagabond.164','vagabond','vagabond',[49,120,115],'317873',3242099],
['nbs-iscc-p:valenciarose.6','valenciarose','valencia rose',[192,128,129],'c08081',12615809],
['nbs-iscc-p:valorgreen.187','valorgreen','valor green',[54,69,79],'36454f',3556687],
['nbs-iscc-p:vamp.249','vamp','vamp',[239,187,204],'efbbcc',15711180],
['nbs-iscc-p:vanda.244','vanda','vanda',[170,138,158],'aa8a9e',11176606],
['nbs-iscc-p:vanillacustard.86','vanillacustard','vanilla custard',[248,222,126],'f8de7e',16309886],
['nbs-iscc-p:vanillacustard.89','vanillacustard','vanilla custard',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:vaporblue.189','vaporblue','vapor blue',[233,233,237],'e9e9ed',15329773],
['nbs-iscc-p:vatican.259','vatican','vatican',[103,49,71],'673147',6762823],
['nbs-iscc-p:veiledsun.71','veiledsun','veiled sun',[227,168,87],'e3a857',14919767],
['nbs-iscc-p:veiledsun.84','veiledsun','veiled sun',[212,175,55],'d4af37',13938487],
['nbs-iscc-p:venetianrose.19','venetianrose','venetian rose',[144,93,93],'905d5d',9461085],
['nbs-iscc-p:venetianturquoise.163','venetianturquoise','venetian turquoise',[102,173,164],'66ada4',6729124],
['nbs-iscc-p:venice.149','venice','venice',[141,163,153],'8da399',9282457],
['nbs-iscc-p:veniceblue.162','veniceblue','venice blue',[150,222,209],'96ded1',9887441],
['nbs-iscc-p:venusblue.184','venusblue','venus blue',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:venusblue.189','venusblue','venus blue',[233,233,237],'e9e9ed',15329773],
['nbs-iscc-p:verbenalavender.241','verbenalavender','verbena lavender',[145,92,131],'915c83',9526403],
['nbs-iscc-p:verbenalavender.262','verbenalavender','verbena lavender',[145,95,109],'915f6d',9527149],
['nbs-iscc-p:verdant.115','verdant','verdant',[141,182,0],'8db600',9287168],
['nbs-iscc-p:verdugo.116','verdugo','verdugo',[189,218,87],'bdda57',12442199],
['nbs-iscc-p:verdugo.119','verdugo','verdugo',[201,220,137],'c9dc89',13229193],
['nbs-iscc-p:vermilion.35','vermilion','vermilion',[217,96,59],'d9603b',14245947],
['nbs-iscc-p:vesta.2','vesta','vesta',[234,147,153],'ea9399',15373209],
['nbs-iscc-p:vesta.4','vesta','vesta',[249,204,202],'f9ccca',16370890],
['nbs-iscc-p:vesta.5','vesta','vesta',[222,165,164],'dea5a4',14591396],
['nbs-iscc-p:vibrantgreen.130','vibrantgreen','vibrant green',[131,211,125],'83d37d',8639357],
['nbs-iscc-p:victoria.28','victoria','victoria',[244,194,194],'f4c2c2',16040642],
['nbs-iscc-p:viking.187','viking','viking',[54,69,79],'36454f',3556687],
['nbs-iscc-p:viola.222','viola','viola',[182,149,192],'b695c0',11965888],
['nbs-iscc-p:violetleaf.125','violetleaf','violet leaf',[74,93,35],'4a5d23',4873507],
['nbs-iscc-p:violetpansy.229','violetpansy','violet pansy',[80,64,77],'50404d',5259341],
['nbs-iscc-p:virginialavender.231','virginialavender','virginia lavender',[232,227,229],'e8e3e5',15262693],
['nbs-iscc-p:vistagreen.122','vistagreen','vista green',[143,151,121],'8f9779',9410425],
['nbs-iscc-p:vivid.251','vivid','vivid',[193,126,145],'c17e91',12680849],
['nbs-iscc-p:vividturquoise.160','vividturquoise','vivid turquoise',[0,122,116],'007a74',31348],
['nbs-iscc-p:waftedfeather.231','waftedfeather','wafted feather',[232,227,229],'e8e3e5',15262693],
['nbs-iscc-p:waftedfeather.232','waftedfeather','wafted feather',[191,185,189],'bfb9bd',12564925],
['nbs-iscc-p:walnut.57','walnut','walnut',[166,123,91],'a67b5b',10910555],
['nbs-iscc-p:walnutcream.73','walnutcream','walnut cream',[250,214,165],'fad6a5',16438949],
['nbs-iscc-p:wanblue.189','wanblue','wan blue',[233,233,237],'e9e9ed',15329773],
['nbs-iscc-p:wanblue.231','wanblue','wan blue',[232,227,229],'e8e3e5',15262693],
['nbs-iscc-p:waterfall.173','waterfall','water fall ',[54,117,136],'367588',3569032],
['nbs-iscc-p:watergreen.121','watergreen','water green',[218,223,183],'dadfb7',14344119],
['nbs-iscc-p:watteau.172','watteau','watteau',[102,170,188],'66aabc',6728380],
['nbs-iscc-p:whimsical.222','whimsical','whimsical',[182,149,192],'b695c0',11965888],
['nbs-iscc-p:whiteclover.92','whiteclover','white clover',[240,234,214],'f0ead6',15788758],
['nbs-iscc-p:whitefawn.73','whitefawn','white fawn',[250,214,165],'fad6a5',16438949],
['nbs-iscc-p:whitejade.28','whitejade','white jade',[244,194,194],'f4c2c2',16040642],
['nbs-iscc-p:whitejade.31','whitejade','white jade',[236,213,197],'ecd5c5',15521221],
['nbs-iscc-p:whitelight.184','whitelight','white light',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:whitemist.28','whitemist','white mist',[244,194,194],'f4c2c2',16040642],
['nbs-iscc-p:whitemist.31','whitemist','white mist',[236,213,197],'ecd5c5',15521221],
['nbs-iscc-p:whitesmoke.190','whitesmoke','white smoke',[180,188,192],'b4bcc0',11844800],
['nbs-iscc-p:whiteswan.184','whiteswan','white swan',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:whiteswan.202','whiteswan','white swan',[192,200,225],'c0c8e1',12634337],
['nbs-iscc-p:wildorchid.240','wildorchid','wild orchid',[183,132,167],'b784a7',12027047],
['nbs-iscc-p:windflower.262','windflower','windflower',[145,95,109],'915f6d',9527149],
['nbs-iscc-p:wineberry.228','wineberry','wineberry',[121,104,120],'796878',7956600],
['nbs-iscc-p:wineberry.229','wineberry','wineberry',[80,64,77],'50404d',5259341],
['nbs-iscc-p:winsome.226','winsome','winsome',[214,202,221],'d6cadd',14076637],
['nbs-iscc-p:winsomeblue.172','winsomeblue','winsome blue',[102,170,188],'66aabc',6728380],
['nbs-iscc-p:winterpear.120','winterpear','winter pear',[138,154,91],'8a9a5b',9083483],
['nbs-iscc-p:wintersky.184','wintersky','winter sky',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:wintersun.101','wintersun','winter sun ',[234,230,121],'eae679',15394425],
['nbs-iscc-p:winterwhite.3','winterwhite','winter white',[228,113,122],'e4717a',14971258],
['nbs-iscc-p:winteryellow.89','winteryellow','winter yellow',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:winteryellow.90','winteryellow','winter yellow',[194,178,128],'c2b280',12759680],
['nbs-iscc-p:wisteria.210','wisteria','wisteria',[140,130,182],'8c82b6',9208502],
['nbs-iscc-p:wisteriagray.228','wisteriagray','wisteria gray',[121,104,120],'796878',7956600],
['nbs-iscc-p:wisteriamist.228','wisteriamist','wisteria mist',[121,104,120],'796878',7956600],
['nbs-iscc-p:witheredrose.19','witheredrose','withered rose',[144,93,93],'905d5d',9461085],
['nbs-iscc-p:yaleblue.196','yaleblue','yale blue',[84,90,167],'545aa7',5528231],
['nbs-iscc-p:yaleblue.197','yaleblue','yale blue',[39,36,88],'272458',2565208],
['nbs-iscc-p:yaleblue.200','yaleblue','yale blue',[78,81,128],'4e5180',5132672],
['nbs-iscc-p:yama.163','yama','yama',[102,173,164],'66ada4',6729124],
['nbs-iscc-p:yellowbright.98','yellowbright','yellow bright',[233,228,80],'e9e450',15328336],
['nbs-iscc-p:yellowbright.101','yellowbright','yellow bright',[234,230,121],'eae679',15394425],
['nbs-iscc-p:yellowcream.89','yellowcream','yellow cream',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:yellowessence.104','yellowessence','yellow essence',[235,232,164],'ebe8a4',15460516],
['nbs-iscc-p:yellowgem.89','yellowgem','yellow gem',[243,229,171],'f3e5ab',15984043],
['nbs-iscc-p:yellowmist.94','yellowmist','yellow mist',[150,113,23],'967117',9859351],
['nbs-iscc-p:yellowrose.101','yellowrose','yellow rose',[234,230,121],'eae679',15394425],
['nbs-iscc-p:yellowsmoke.87','yellowsmoke','yellow smoke',[201,174,93],'c9ae5d',13217373],
['nbs-iscc-p:yellowsmoke.88','yellowsmoke','yellow smoke',[171,145,68],'ab9144',11243844],
['nbs-iscc-p:yewgreen.127','yewgreen','yew green',[81,87,68],'515744',5330756],
['nbs-iscc-p:youthyellow.101','youthyellow','youth yellow',[234,230,121],'eae679',15394425],
['nbs-iscc-p:yuletime.125','yuletime','yuletime',[74,93,35],'4a5d23',4873507],
['nbs-iscc-p:yuletree.165','yuletree','yule tree',[0,75,73],'004b49',19273],
['nbs-iscc-p:zephyrblue.184','zephyrblue','zephyr blue',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-p:zephyrblue.185','zephyrblue','zephyr blue',[145,163,176],'91a3b0',9544624],
['nbs-iscc-p:zephyrgreen.148','zephyrgreen','zephyr green',[199,230,215],'c7e6d7',13100759],
['nbs-iscc-p:zestpink.2','zestpink','zest pink',[234,147,153],'ea9399',15373209],
['nbs-iscc-p:zinniagold.70','zinniagold','zinnia gold',[251,201,127],'fbc97f',16501119],
['nbs-iscc-p:zinniagold.86','zinniagold','zinnia gold',[248,222,126],'f8de7e',16309886]
    ];
}

sub _description {
    return {
          'subtitle' => 'Plochere Color System',
          'title' => 'NBS/ISCC P',
          'description' => '    Kenneth L. Kelly and Deanne B. Judd.
    "Color: Universal Language and Dictionary of Names",
    National Bureau of Standards,
    Spec. Publ. 440, Dec. 1976, 189 pages.


Color Name Dictionary: (P) Plochere Color System

Plochere Color System

This idiosyncratic dictionary for interior decorating has 1246 names mapping to 1606 colors, using 206 of the 267 centroids.

[http://swissnet.ai.mit.edu/~jaffer/Color/Dictionaries#P]
'
        }

}

1;
