package Shipment::UPS::WSDL::TrackTypes::CarrierActivityInformationType;
$Shipment::UPS::WSDL::TrackTypes::CarrierActivityInformationType::VERSION = '3.01';
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns {'http://www.ups.com/XMLSchema/XOLTWS/Track/v2.0'}

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{    # BLOCK to scope variables

    my %CarrierId_of : ATTR(:get<CarrierId>);
    my %Description_of : ATTR(:get<Description>);
    my %Status_of : ATTR(:get<Status>);
    my %Arrival_of : ATTR(:get<Arrival>);
    my %Departure_of : ATTR(:get<Departure>);
    my %OriginPort_of : ATTR(:get<OriginPort>);
    my %DestinationPort_of : ATTR(:get<DestinationPort>);

    __PACKAGE__->_factory(
        [   qw(        CarrierId
              Description
              Status
              Arrival
              Departure
              OriginPort
              DestinationPort

              )
        ],
        {   'CarrierId'       => \%CarrierId_of,
            'Description'     => \%Description_of,
            'Status'          => \%Status_of,
            'Arrival'         => \%Arrival_of,
            'Departure'       => \%Departure_of,
            'OriginPort'      => \%OriginPort_of,
            'DestinationPort' => \%DestinationPort_of,
        },
        {   'CarrierId'   => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'Description' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'Status'      => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'Arrival'     => 'Shipment::UPS::WSDL::TrackTypes::DateTimeType',
            'Departure'   => 'Shipment::UPS::WSDL::TrackTypes::DateTimeType',
            'OriginPort'  => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'DestinationPort' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        },
        {

            'CarrierId'       => 'CarrierId',
            'Description'     => 'Description',
            'Status'          => 'Status',
            'Arrival'         => 'Arrival',
            'Departure'       => 'Departure',
            'OriginPort'      => 'OriginPort',
            'DestinationPort' => 'DestinationPort',
        }
    );

}    # end BLOCK


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Shipment::UPS::WSDL::TrackTypes::CarrierActivityInformationType

=head1 VERSION

version 3.01

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
CarrierActivityInformationType from the namespace http://www.ups.com/XMLSchema/XOLTWS/Track/v2.0.

=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * CarrierId

=item * Description

=item * Status

=item * Arrival

=item * Departure

=item * OriginPort

=item * DestinationPort

=back

=head1 NAME

Shipment::UPS::WSDL::TrackTypes::CarrierActivityInformationType

=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Shipment::UPS::WSDL::TrackTypes::CarrierActivityInformationType
   CarrierId =>  $some_value, # string
   Description =>  $some_value, # string
   Status =>  $some_value, # string
   Arrival =>  { # Shipment::UPS::WSDL::TrackTypes::DateTimeType
     Date =>  $some_value, # string
     Time =>  $some_value, # string
   },
   Departure =>  { # Shipment::UPS::WSDL::TrackTypes::DateTimeType
     Date =>  $some_value, # string
     Time =>  $some_value, # string
   },
   OriginPort =>  $some_value, # string
   DestinationPort =>  $some_value, # string
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=head1 AUTHOR

Andrew Baerg <baergaj@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Andrew Baerg.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
