.\" $RCSfile: gsh.man,v $$Revision: 4.1 $$Date: 92/08/07 17:20:22 $
.TH GSH 8 "13 May 1988"
.SH NAME
gsh \- global shell
.SH SYNOPSIS
.B gsh
[options]
.I host
[options] 
.I command
.SH DESCRIPTION
.I gsh
works just like rsh(1C) except that you may specify a set of hosts to execute
the command on.
The host sets are defined in the file /etc/ghosts.
(An individual host name can be used as a set containing one member.)
You can give a command like

	gsh sun /etc/mungmotd

to run /etc/mungmotd on all your Suns.
.P
You may specify the union of two or more sets by using + as follows:

	gsh 750+mc /etc/mungmotd

which will run mungmotd on all 750's and Masscomps.
.P
Commonly used sets should be defined in /etc/ghosts.
For example, you could add a line that says

	pep=manny+moe+jack

Another way to do that would be to add the word "pep" after each of the host
entries:

	manny	sun3 pep
.br
	moe		sun3 pep
.br
	jack		sun3 pep

Hosts and sets of host can also be excluded:

	foo=sun-sun2

Any host so excluded will never be included, even if a subsequent set on the
line includes it:

	foo=abc+def
	bar=xyz-abc+foo

comes out to xyz+def.

You can define private host sets by creating .ghosts in your current directory
with entries just like /etc/ghosts.
Also, if there is a file .grem, it defines "rem" to be the remaining hosts
from the last gsh or gcp that didn't succeed everywhere.

Options include all those defined by rsh, as well as

.IP "\-d" 8
Causes gsh to collect input till end of file, and then distribute that input
to each invokation of rsh.
.IP "\-h" 8
Rather than print out the command followed by the output, merely prepends the
host name to each line of output.
.IP "\-s" 8
Do work silently.
.PP
Interrupting with a SIGINT will cause the rsh to the current host to be skipped
and execution resumed with the next host.
To stop completely, send a SIGQUIT.
.SH SEE ALSO
rsh(1C)
.SH BUGS
All the bugs of rsh, since it calls rsh.

Also, will not properly return data from the remote execution that contains
null characters.
