#!perl -T

use Test::More 'tests' => 136;
use Path::Trim;

my $pt = Path::Trim->new();
$pt->set_directory_separator('/');

is( $pt->get_current_directory(),    '.',  'get_current_directory() --> .' );
is( $pt->set_current_directory(':'), ':',  'set_current_directory() --> :' );
is( $pt->get_current_directory(),    ':',  'get_current_directory() --> :' );
is( $pt->set_current_directory('.'), '.',  'set_current_directory() --> .' );
is( $pt->get_parent_directory(),     '..', 'get_parent_directory() --> ..' );
is( $pt->set_parent_directory('::'), '::', 'set_parent_directory() --> ::' );
is( $pt->get_parent_directory(),     '::', 'get_parent_directory() --> ::' );
is( $pt->set_parent_directory('..'), '..', 'set_parent_directory() --> ..' );

is( $pt->trim_path('.'),         '.', '. => .' );
is( $pt->trim_path('./.'),       '.', './. => .' );
is( $pt->trim_path('./a'),       'a', './a => a' );
is( $pt->trim_path('./a/.'),     'a', './a/. => a' );
is( $pt->trim_path('././a'),     'a', '././a => a' );
is( $pt->trim_path('././a/.'),   'a', '././a/. => a' );
is( $pt->trim_path('././a/./.'), 'a', '././a/./. => a' );

is( $pt->trim_path('/.'),         '/.', '/. => /.' );
is( $pt->trim_path('/./.'),       '/.', '/./. => /.' );
is( $pt->trim_path('/./a'),       '/a', '/./a => /a' );
is( $pt->trim_path('/./a/.'),     '/a', '/./a/. => /a' );
is( $pt->trim_path('/././a'),     '/a', '/././a => /a' );
is( $pt->trim_path('/././a/.'),   '/a', '/././a/. => /a' );
is( $pt->trim_path('/././a/./.'), '/a', '/././a/./. => /a' );

is( $pt->trim_path('./'),         './', './ => ./' );
is( $pt->trim_path('././'),       './', '././ => ./' );
is( $pt->trim_path('./a/'),       'a/', './a/ => a/' );
is( $pt->trim_path('./a/./'),     'a/', './a/./ => a/' );
is( $pt->trim_path('././a/'),     'a/', '././a/ => a/' );
is( $pt->trim_path('././a/./'),   'a/', '././a/./ => a/' );
is( $pt->trim_path('././a/././'), 'a/', '././a/././ => a/' );

is( $pt->trim_path('/./'),         '/./', '/./ => /./' );
is( $pt->trim_path('/././'),       '/./', '/././ => /./' );
is( $pt->trim_path('/./a/'),       '/a/', '/./a/ => /a/' );
is( $pt->trim_path('/./a/./'),     '/a/', '/./a/./ => /a/' );
is( $pt->trim_path('/././a/'),     '/a/', '/././a/ => /a/' );
is( $pt->trim_path('/././a/./'),   '/a/', '/././a/./ => /a/' );
is( $pt->trim_path('/././a/././'), '/a/', '/././a/././ => /a/' );

is( $pt->trim_path('..'),            '..',       '.. => ..' );
is( $pt->trim_path('../..'),         '../..',    '../.. => ../..' );
is( $pt->trim_path('../../..'),      '../../..', '../../.. => ../../..' );
is( $pt->trim_path('../a'),          '../a',     '../a => ../a' );
is( $pt->trim_path('../a/..'),       '..',       '../a/.. => .. ' );
is( $pt->trim_path('../../a'),       '../../a',  '../../a => ../../a' );
is( $pt->trim_path('../../a/..'),    '../..',    '../../a/.. => ../..' );
is( $pt->trim_path('../../a/../..'), '../../..', '../../a/../.. => ../../..' );

is( $pt->trim_path('/..'),         '/..',       '/.. => /..' );
is( $pt->trim_path('/../..'),      '/../..',    '/../.. => /../..' );
is( $pt->trim_path('/../../..'),   '/../../..', '/../../.. => /../../..' );
is( $pt->trim_path('/../a'),       '/../a',     '/../a => /../a' );
is( $pt->trim_path('/../a/..'),    '/..',       '/../a/.. => /.. ' );
is( $pt->trim_path('/../../a'),    '/../../a',  '/../../a => /../../a' );
is( $pt->trim_path('/../../a/..'), '/../..',    '/../../a/.. => /../..' );
is( $pt->trim_path('/../../a/../..'),
    '/../../..', '/../../a/../.. => /../../..' );

is( $pt->trim_path('../'),         '../',       '../ => ../' );
is( $pt->trim_path('../../'),      '../../',    '../../ => ../../' );
is( $pt->trim_path('../../../'),   '../../../', '../../../ => ../../../' );
is( $pt->trim_path('../a/'),       '../a/',     '../a/ => ../a/' );
is( $pt->trim_path('../a/../'),    '../',       '../a/../ => ../ ' );
is( $pt->trim_path('../../a/'),    '../../a/',  '../../a/ => ../../a/' );
is( $pt->trim_path('../../a/../'), '../../',    '../../a/../ => ../../' );
is( $pt->trim_path('../../a/../../'),
    '../../../', '../../a/../../ => ../../../' );

is( $pt->trim_path('/../'),         '/../',       '/../ => /../' );
is( $pt->trim_path('/../../'),      '/../../',    '/../../ => /../../' );
is( $pt->trim_path('/../../../'),   '/../../../', '/../../../ => /../../../' );
is( $pt->trim_path('/../a/'),       '/../a/',     '/../a/ => /../a/' );
is( $pt->trim_path('/../a/../'),    '/../',       '/../a/../ => /../ ' );
is( $pt->trim_path('/../../a/'),    '/../../a/',  '/../../a/ => /../../a/' );
is( $pt->trim_path('/../../a/../'), '/../../',    '/../../a/../ => /../../' );
is( $pt->trim_path('/../../a/../../'),
    '/../../../', '/../../a/../../ => /../../../' );

is( $pt->trim_path('a/b/../.././c/d'), 'c/d', 'a/b/../.././c/d => c/d' );

is( $pt->trim_path('/a/b/../.././c/d'), '/c/d', '/a/b/../.././c/d => /c/d' );

is( $pt->trim_path('a/b/../.././c/d/'), 'c/d/', 'a/b/../.././c/d/ => c/d/' );

is( $pt->trim_path('/a/b/../.././c/d/'), '/c/d/',
    '/a/b/../.././c/d/ => /c/d/' );

$pt->set_directory_separator('\\');

is( $pt->trim_path('.'),             '.', '. => .' );
is( $pt->trim_path('.\\.'),          '.', '.\\. => .' );
is( $pt->trim_path('.\\a'),          'a', '.\a => a' );
is( $pt->trim_path('.\\a\\.'),       'a', '.\\a\\. => a' );
is( $pt->trim_path('.\\.\\a'),       'a', '.\\.\\a => a' );
is( $pt->trim_path('.\\.\\a\\.'),    'a', '.\\.\\a\\. => a' );
is( $pt->trim_path('.\\.\\a\\.\\.'), 'a', '.\\.\\a\\.\\. => a' );

is( $pt->trim_path('\\.'),             '\\.', '\\. => \\.' );
is( $pt->trim_path('\\.\\.'),          '\\.', '\\.\\. => \\.' );
is( $pt->trim_path('\\.\\a'),          '\\a', '\\.\a => \\a' );
is( $pt->trim_path('\\.\\a\\.'),       '\\a', '\\.\\a\\. => \\a' );
is( $pt->trim_path('\\.\\.\\a'),       '\\a', '\\.\\.\\a => \\a' );
is( $pt->trim_path('\\.\\.\\a\\.'),    '\\a', '\\.\\.\\a\\. => \\a' );
is( $pt->trim_path('\\.\\.\\a\\.\\.'), '\\a', '\\.\\.\\a\\.\\. => \\a' );

is( $pt->trim_path('.\\'),             '.\\', '.\\ => .\\' );
is( $pt->trim_path('.\\.\\'),          '.\\', '.\\.\\ => .\\' );
is( $pt->trim_path('.\\a\\'),          'a\\', '.\\a\\ => a\\' );
is( $pt->trim_path('.\\a\\.\\'),       'a\\', '.\\a\\. => a\\' );
is( $pt->trim_path('.\\.\\a\\'),       'a\\', '.\\.\\a => a\\' );
is( $pt->trim_path('.\\.\\a\\.\\'),    'a\\', '.\\.\\a\\. => a\\' );
is( $pt->trim_path('.\\.\\a\\.\\.\\'), 'a\\', '.\\.\\a\\.\\. => a\\' );

is( $pt->trim_path('\\.\\'),             '\\.\\', '\\.\\ => \\.\\' );
is( $pt->trim_path('\\.\\.\\'),          '\\.\\', '\\.\\.\\ => \\.\\' );
is( $pt->trim_path('\\.\\a\\'),          '\\a\\', '\\.\\a\\ => \\a\\' );
is( $pt->trim_path('\\.\\a\\.\\'),       '\\a\\', '\\.\\a\\. => \\a\\' );
is( $pt->trim_path('\\.\\.\\a\\'),       '\\a\\', '\\.\\.\\a => \\a\\' );
is( $pt->trim_path('\\.\\.\\a\\.\\'),    '\\a\\', '\\.\\.\\a\\. => \\a\\' );
is( $pt->trim_path('\\.\\.\\a\\.\\.\\'), '\\a\\', '\\.\\.\\a\\.\\. => \\a\\' );

is( $pt->trim_path('..'),            '..',         '.. => ..' );
is( $pt->trim_path('..\\..'),        '..\\..',     '..\\.. => ..\\..' );
is( $pt->trim_path('..\\..\\..'),    '..\\..\\..', '..\\..\\.. => ..\\..\\..' );
is( $pt->trim_path('..\\a'),         '..\\a',      '..\\a => ..\\a' );
is( $pt->trim_path('..\\a\\..'),     '..',         '..\\a\\.. => .. ' );
is( $pt->trim_path('..\\..\\a'),     '..\\..\\a',  '..\\..\\a => ..\\..\\a' );
is( $pt->trim_path('..\\..\\a\\..'), '..\\..',     '..\\..\\a\\.. => ..\\..' );
is( $pt->trim_path('..\\..\\a\\..\\..'),
    '..\\..\\..', '..\\..\\a\\..\\.. => ..\\..\\..' );

is( $pt->trim_path('\\..'),     '\\..',     '\\.. => \\..' );
is( $pt->trim_path('\\..\\..'), '\\..\\..', '\\..\\.. => \\..\\..' );
is( $pt->trim_path('\\..\\..\\..'),
    '\\..\\..\\..', '\\..\\..\\.. => \\..\\..\\..' );
is( $pt->trim_path('\\..\\a'),     '\\..\\a', '\\..\\a => \\..\\a' );
is( $pt->trim_path('\\..\\a\\..'), '\\..',    '\\..\\a\\.. => \\.. ' );
is( $pt->trim_path('\\..\\..\\a'), '\\..\\..\\a',
    '\\..\\..\\a => \\..\\..\\a' );
is( $pt->trim_path('\\..\\..\\a\\..'),
    '\\..\\..', '\\..\\..\\a\\.. => \\..\\..' );
is( $pt->trim_path('\\..\\..\\a\\..\\..'),
    '\\..\\..\\..', '\\..\\..\\a\\..\\.. => \\..\\..\\..' );

is( $pt->trim_path('..\\'),     '..\\',     '..\\ => ..\\' );
is( $pt->trim_path('..\\..\\'), '..\\..\\', '..\\..\\ => ..\\..\\' );
is( $pt->trim_path('..\\..\\..\\'),
    '..\\..\\..\\', '..\\..\\..\\ => ..\\..\\..\\' );
is( $pt->trim_path('..\\a\\'),     '..\\a\\', '..\\a\\ => ..\\a\\' );
is( $pt->trim_path('..\\a\\..\\'), '..\\',    '..\\a\\..\\ => ..\\ ' );
is( $pt->trim_path('..\\..\\a\\'), '..\\..\\a\\',
    '..\\..\\a\\ => ..\\..\\a\\' );
is( $pt->trim_path('..\\..\\a\\..\\'),
    '..\\..\\', '..\\..\\a\\..\\ => ..\\..\\' );
is( $pt->trim_path('..\\..\\a\\..\\..\\'),
    '..\\..\\..\\', '..\\..\\a\\..\\..\\ => ..\\..\\..\\' );

is( $pt->trim_path('\\..\\'),     '\\..\\',     '\\..\\ => \\..\\' );
is( $pt->trim_path('\\..\\..\\'), '\\..\\..\\', '\\..\\..\\ => \\..\\..\\' );
is( $pt->trim_path('\\..\\..\\..\\'),
    '\\..\\..\\..\\', '\\..\\..\\..\\ => \\..\\..\\..\\' );
is( $pt->trim_path('\\..\\a\\'),     '\\..\\a\\', '\\..\\a\\ => \\..\\a\\' );
is( $pt->trim_path('\\..\\a\\..\\'), '\\..\\',    '\\..\\a\\..\\ => \\..\\ ' );
is( $pt->trim_path('\\..\\..\\a\\'),
    '\\..\\..\\a\\', '\\..\\..\\a\\ => \\..\\..\\a\\' );
is( $pt->trim_path('\\..\\..\\a\\..\\'),
    '\\..\\..\\', '\\..\\..\\a\\..\\ => \\..\\..\\' );
is( $pt->trim_path('\\..\\..\\a\\..\\..\\'),
    '\\..\\..\\..\\', '\\..\\..\\a\\..\\..\\ => \\..\\..\\..\\' );

is( $pt->trim_path('a\\b\\..\\..\\.\\c\\d'),
    'c\\d', 'a\\b\\..\\..\\.\\c\\d => c\\d' );

is( $pt->trim_path('\\a\\b\\..\\..\\.\\c\\d'),
    '\\c\\d', '\\a\\b\\..\\..\\.\\c\\d => \\c\\d' );

is( $pt->trim_path('a\\b\\..\\..\\.\\c\\d\\'),
    'c\\d\\', 'a\\b\\..\\..\\.\\c\\d\\ => c\\d\\' );

is( $pt->trim_path('\\a\\b\\..\\..\\.\\c\\d\\'),
    '\\c\\d\\', '\\a\\b\\..\\..\\.\\c\\d\\ => \\c\\d\\' );
