# Generated by default/object.tt
package Paws::SageMaker::DataCatalogConfig;
  use Moose;
  has Catalog => (is => 'ro', isa => 'Str', required => 1);
  has Database => (is => 'ro', isa => 'Str', required => 1);
  has TableName => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::DataCatalogConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::DataCatalogConfig object:

  $service_obj->Method(Att1 => { Catalog => $value, ..., TableName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::DataCatalogConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->Catalog

=head1 DESCRIPTION

The meta data of the Glue table which serves as data catalog for the
C<OfflineStore>.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Catalog => Str

The name of the Glue table catalog.


=head2 B<REQUIRED> Database => Str

The name of the Glue table database.


=head2 B<REQUIRED> TableName => Str

The name of the Glue table.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

