# Copyright (c) 2005 - 2006 Hans Jeuken. All rights reserved.
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.

# This file was generated from the 'php.xml' file of the syntax highlight
# engine of the kate text editor (http://www.kate-editor.org

#kate xml version 1.25
#kate version 2.4
#generated: Sun Feb  3 22:02:06 2008, localtime

package Syntax::Highlight::Engine::Kate::PHP_PHP;

our $VERSION = '0.16';

use strict;
use warnings;
use base('Syntax::Highlight::Engine::Kate::Template');

sub new {
   my $proto = shift;
   my $class = ref($proto) || $proto;
   my $self = $class->SUPER::new(@_);
   $self->attributes({
      'Backslash Code' => 'BString',
      'Comment' => 'Comment',
      'Control Structures' => 'Operator',
      'Decimal' => 'DecVal',
      'Float' => 'Float',
      'Function' => 'Function',
      'HTML Comment' => 'Comment',
      'HTML Tag' => 'Keyword',
      'Hex' => 'BaseN',
      'Identifier' => 'Others',
      'Keyword' => 'Keyword',
      'Normal Text' => 'Normal',
      'Octal' => 'BaseN',
      'Other' => 'Others',
      'PHP Text' => 'Normal',
      'String' => 'String',
      'Types' => 'DataType',
      'Variable' => 'Variable',
   });
   $self->listAdd('control structures',
      'as',
      'break',
      'case',
      'continue',
      'declare',
      'do',
      'else',
      'elseif',
      'for',
      'foreach',
      'if',
      'include',
      'include_once',
      'require',
      'require_once',
      'return',
      'switch',
      'while',
   );
   $self->listAdd('functions',
      'abs',
      'acos',
      'acosh',
      'addcslashes',
      'addslashes',
      'apache_get_modules',
      'apache_get_version',
      'apache_getenv',
      'apache_lookup_uri',
      'apache_note',
      'apache_request_headers',
      'apache_response_headers',
      'apache_setenv',
      'array',
      'array_change_key_case',
      'array_chunk',
      'array_combine',
      'array_count_values',
      'array_diff',
      'array_diff',
      'array_diff_assoc',
      'array_diff_key',
      'array_diff_uassoc',
      'array_diff_ukey',
      'array_fill',
      'array_filter',
      'array_flip',
      'array_intersect',
      'array_intersect',
      'array_intersect_assoc',
      'array_intersect_key',
      'array_intersect_uassoc',
      'array_intersect_ukey',
      'array_key_exists',
      'array_keys',
      'array_map',
      'array_merge',
      'array_merge_recursive',
      'array_multisort',
      'array_pad',
      'array_pop',
      'array_product',
      'array_push',
      'array_rand',
      'array_reduce',
      'array_reverse',
      'array_search',
      'array_shift',
      'array_slice',
      'array_splice',
      'array_sum',
      'array_udiff',
      'array_udiff_assoc',
      'array_udiff_uassoc',
      'array_uintersect',
      'array_uintersect',
      'array_uintersect_assoc',
      'array_uintersect_uassoc',
      'array_unique',
      'array_unshift',
      'array_values',
      'array_walk',
      'array_walk_recursive',
      'arsort',
      'ascii2ebcdic',
      'asin',
      'asinh',
      'asort',
      'aspell_check',
      'aspell_check_raw',
      'aspell_new',
      'aspell_suggest',
      'assert',
      'assert_options',
      'atan',
      'atan2',
      'atanh',
      'base64_decode',
      'base64_encode',
      'base_convert',
      'basename',
      'bcadd',
      'bccomp',
      'bcdiv',
      'bcmod',
      'bcmul',
      'bcpow',
      'bcpowmod',
      'bcscale',
      'bcsqrt',
      'bcsub',
      'bin2hex',
      'bind_textdomain_codeset',
      'bindec',
      'bindtextdomain',
      'bzclose',
      'bzcompress',
      'bzdecompress',
      'bzerrno',
      'bzerror',
      'bzerrstr',
      'bzflush',
      'bzopen',
      'bzread',
      'bzwrite',
      'cal_days_in_month',
      'cal_from_jd',
      'cal_info',
      'cal_to_jd',
      'call_user_func',
      'call_user_func_array',
      'call_user_method',
      'call_user_method_array',
      'ccvs_add',
      'ccvs_auth',
      'ccvs_command',
      'ccvs_count',
      'ccvs_delete',
      'ccvs_done',
      'ccvs_init',
      'ccvs_lookup',
      'ccvs_new',
      'ccvs_report',
      'ccvs_return',
      'ccvs_reverse',
      'ccvs_sale',
      'ccvs_status',
      'ccvs_textvalue',
      'ccvs_void',
      'ceil',
      'chdir',
      'checkdate',
      'checkdnsrr',
      'chgrp',
      'chmod',
      'chop',
      'chown',
      'chr',
      'chroot',
      'chunk_split',
      'class_exists',
      'class_implements',
      'class_parents',
      'clearstatcache',
      'closedir',
      'closelog',
      'com',
      'com_addref',
      'com_get',
      'com_invoke',
      'com_isenum',
      'com_load',
      'com_load_typelib',
      'com_propget',
      'com_propput',
      'com_propset',
      'com_release',
      'com_set',
      'compact',
      'connection_aborted',
      'connection_status',
      'connection_timeout',
      'constant',
      'convert_cyr_string',
      'convert_uudecode',
      'convert_uuencode',
      'copy',
      'cos',
      'cosh',
      'count',
      'count_chars',
      'cpdf_add_annotation',
      'cpdf_add_outline',
      'cpdf_arc',
      'cpdf_begin_text',
      'cpdf_circle',
      'cpdf_clip',
      'cpdf_close',
      'cpdf_closepath',
      'cpdf_closepath_fill_stroke',
      'cpdf_closepath_stroke',
      'cpdf_continue_text',
      'cpdf_curveto',
      'cpdf_end_text',
      'cpdf_fill',
      'cpdf_fill_stroke',
      'cpdf_finalize',
      'cpdf_finalize_page',
      'cpdf_global_set_document_limits',
      'cpdf_import_jpeg',
      'cpdf_lineto',
      'cpdf_moveto',
      'cpdf_newpath',
      'cpdf_open',
      'cpdf_output_buffer',
      'cpdf_page_init',
      'cpdf_place_inline_image',
      'cpdf_rect',
      'cpdf_restore',
      'cpdf_rlineto',
      'cpdf_rmoveto',
      'cpdf_rotate',
      'cpdf_rotate_text',
      'cpdf_save',
      'cpdf_save_to_file',
      'cpdf_scale',
      'cpdf_set_action_url',
      'cpdf_set_char_spacing',
      'cpdf_set_creator',
      'cpdf_set_current_page',
      'cpdf_set_font',
      'cpdf_set_font_directories',
      'cpdf_set_font_map_file',
      'cpdf_set_horiz_scaling',
      'cpdf_set_keywords',
      'cpdf_set_leading',
      'cpdf_set_page_animation',
      'cpdf_set_subject',
      'cpdf_set_text_matrix',
      'cpdf_set_text_pos',
      'cpdf_set_text_rendering',
      'cpdf_set_text_rise',
      'cpdf_set_title',
      'cpdf_set_viewer_preferences',
      'cpdf_set_word_spacing',
      'cpdf_setdash',
      'cpdf_setflat',
      'cpdf_setgray',
      'cpdf_setgray_fill',
      'cpdf_setgray_stroke',
      'cpdf_setlinecap',
      'cpdf_setlinejoin',
      'cpdf_setlinewidth',
      'cpdf_setmiterlimit',
      'cpdf_setrgbcolor',
      'cpdf_setrgbcolor_fill',
      'cpdf_setrgbcolor_stroke',
      'cpdf_show',
      'cpdf_show_xy',
      'cpdf_stringwidth',
      'cpdf_stroke',
      'cpdf_text',
      'cpdf_translate',
      'crack_check',
      'crack_closedict',
      'crack_getlastmessage',
      'crack_opendict',
      'crc32',
      'create_function',
      'crypt',
      'ctype_alnum',
      'ctype_alpha',
      'ctype_cntrl',
      'ctype_digit',
      'ctype_graph',
      'ctype_lower',
      'ctype_print',
      'ctype_punct',
      'ctype_space',
      'ctype_upper',
      'ctype_xdigit',
      'curl_close',
      'curl_copy_handle',
      'curl_errno',
      'curl_error',
      'curl_exec',
      'curl_getinfo',
      'curl_init',
      'curl_multi_add_handle',
      'curl_multi_close',
      'curl_multi_exec',
      'curl_multi_getcontent',
      'curl_multi_info_read',
      'curl_multi_init',
      'curl_multi_remove_handle',
      'curl_multi_select',
      'curl_setopt',
      'curl_version',
      'current',
      'cybercash_base64_decode',
      'cybercash_base64_encode',
      'cybercash_decr',
      'cybercash_encr',
      'cybermut_creerformulairecm',
      'cybermut_creerreponsecm',
      'cybermut_testmac',
      'cyrus_authenticate',
      'cyrus_bind',
      'cyrus_close',
      'cyrus_connect',
      'cyrus_query',
      'cyrus_unbind',
      'date',
      'date_sunrise',
      'date_sunset',
      'dba_close',
      'dba_delete',
      'dba_exists',
      'dba_fetch',
      'dba_firstkey',
      'dba_handlers',
      'dba_insert',
      'dba_key_split',
      'dba_list',
      'dba_nextkey',
      'dba_open',
      'dba_optimize',
      'dba_popen',
      'dba_replace',
      'dba_sync',
      'dbase_add_record',
      'dbase_close',
      'dbase_create',
      'dbase_delete_record',
      'dbase_get_header_info',
      'dbase_get_record',
      'dbase_get_record_with_names',
      'dbase_numfields',
      'dbase_numrecords',
      'dbase_open',
      'dbase_pack',
      'dbase_replace_record',
      'dblist',
      'dbmclose',
      'dbmdelete',
      'dbmexists',
      'dbmfetch',
      'dbmfirstkey',
      'dbminsert',
      'dbmnextkey',
      'dbmopen',
      'dbmreplace',
      'dbplus_add',
      'dbplus_aql',
      'dbplus_chdir',
      'dbplus_close',
      'dbplus_curr',
      'dbplus_errcode',
      'dbplus_errno',
      'dbplus_find',
      'dbplus_first',
      'dbplus_flush',
      'dbplus_freealllocks',
      'dbplus_freelock',
      'dbplus_freerlocks',
      'dbplus_getlock',
      'dbplus_getunique',
      'dbplus_info',
      'dbplus_last',
      'dbplus_lockrel',
      'dbplus_next',
      'dbplus_open',
      'dbplus_prev',
      'dbplus_rchperm',
      'dbplus_rcreate',
      'dbplus_rcrtexact',
      'dbplus_rcrtlike',
      'dbplus_resolve',
      'dbplus_restorepos',
      'dbplus_rkeys',
      'dbplus_ropen',
      'dbplus_rquery',
      'dbplus_rrename',
      'dbplus_rsecindex',
      'dbplus_runlink',
      'dbplus_rzap',
      'dbplus_savepos',
      'dbplus_setindex',
      'dbplus_setindexbynumber',
      'dbplus_sql',
      'dbplus_tcl',
      'dbplus_tremove',
      'dbplus_undo',
      'dbplus_undoprepare',
      'dbplus_unlockrel',
      'dbplus_unselect',
      'dbplus_update',
      'dbplus_xlockrel',
      'dbplus_xunlockrel',
      'dbx_close',
      'dbx_compare',
      'dbx_connect',
      'dbx_error',
      'dbx_escape_string',
      'dbx_fetch_row',
      'dbx_query',
      'dbx_sort',
      'dcgettext',
      'dcgettext',
      'dcngettext',
      'dcngettext',
      'debug_backtrace',
      'debug_print_backtrace',
      'debug_zval_dump',
      'debugger_off',
      'debugger_on',
      'decbin',
      'dechex',
      'decoct',
      'define',
      'define_syslog_variables',
      'defined',
      'deg2rad',
      'delete',
      'dgettext',
      'die',
      'dio_close',
      'dio_fcntl',
      'dio_open',
      'dio_read',
      'dio_seek',
      'dio_stat',
      'dio_tcsetattr',
      'dio_truncate',
      'dio_write',
      'dir',
      'dirname',
      'disk_free_space',
      'disk_total_space',
      'diskfreespace',
      'dl',
      'dngettext',
      'dngettext',
      'dns_check_record',
      'dns_get_mx',
      'dns_get_record',
      'dom_import_simplexml',
      'domxml_add_root',
      'domxml_attributes',
      'domxml_children',
      'domxml_dumpmem',
      'domxml_get_attribute',
      'domxml_new_child',
      'domxml_new_xmldoc',
      'domxml_node',
      'domxml_node_set_content',
      'domxml_node_unlink_node',
      'domxml_root',
      'domxml_set_attribute',
      'domxml_version',
      'dotnet_load',
      'doubleval',
      'each',
      'easter_date',
      'easter_days',
      'ebcdic2ascii',
      'echo',
      'empty',
      'end',
      'ereg',
      'ereg_replace',
      'eregi',
      'eregi_replace',
      'error_log',
      'error_reporting',
      'escapeshellarg',
      'escapeshellcmd',
      'eval',
      'exec',
      'exif_imagetype',
      'exif_read_data',
      'exif_tagname',
      'exif_thumbnail',
      'exit',
      'exp',
      'explode',
      'expm1',
      'extension_loaded',
      'extract',
      'ezmlm_hash',
      'fam_cancel_monitor',
      'fam_close',
      'fam_monitor_collection',
      'fam_monitor_directory',
      'fam_monitor_file',
      'fam_next_event',
      'fam_open',
      'fam_pending',
      'fam_resume_monitor',
      'fam_suspend_monitor',
      'fbsql_affected_rows',
      'fbsql_autocommit',
      'fbsql_change_user',
      'fbsql_close',
      'fbsql_commit',
      'fbsql_connect',
      'fbsql_create_blob',
      'fbsql_create_clob',
      'fbsql_create_db',
      'fbsql_data_seek',
      'fbsql_database',
      'fbsql_database_password',
      'fbsql_db_query',
      'fbsql_db_status',
      'fbsql_drop_db',
      'fbsql_errno',
      'fbsql_error',
      'fbsql_fetch_array',
      'fbsql_fetch_assoc',
      'fbsql_fetch_field',
      'fbsql_fetch_lengths',
      'fbsql_fetch_object',
      'fbsql_fetch_row',
      'fbsql_field_flags',
      'fbsql_field_len',
      'fbsql_field_name',
      'fbsql_field_seek',
      'fbsql_field_table',
      'fbsql_field_type',
      'fbsql_free_result',
      'fbsql_get_autostart_info',
      'fbsql_hostname',
      'fbsql_insert_id',
      'fbsql_list_dbs',
      'fbsql_list_fields',
      'fbsql_list_tables',
      'fbsql_next_result',
      'fbsql_num_fields',
      'fbsql_num_rows',
      'fbsql_password',
      'fbsql_pconnect',
      'fbsql_query',
      'fbsql_read_blob',
      'fbsql_read_clob',
      'fbsql_result',
      'fbsql_rollback',
      'fbsql_select_db',
      'fbsql_set_lob_mode',
      'fbsql_set_transaction',
      'fbsql_start_db',
      'fbsql_stop_db',
      'fbsql_tablename',
      'fbsql_username',
      'fbsql_warnings',
      'fclose',
      'fdf_add_template',
      'fdf_close',
      'fdf_create',
      'fdf_get_file',
      'fdf_get_status',
      'fdf_get_value',
      'fdf_next_field_name',
      'fdf_open',
      'fdf_save',
      'fdf_set_ap',
      'fdf_set_encoding',
      'fdf_set_file',
      'fdf_set_flags',
      'fdf_set_javascript_action',
      'fdf_set_opt',
      'fdf_set_status',
      'fdf_set_submit_form_action',
      'fdf_set_value',
      'feof',
      'fflush',
      'fgetc',
      'fgetcsv',
      'fgets',
      'fgetss',
      'fgetwrapperdata',
      'file',
      'file_exists',
      'file_get_contents',
      'file_put_contents',
      'fileatime',
      'filectime',
      'filegroup',
      'fileinode',
      'filemtime',
      'fileowner',
      'fileperms',
      'filepro',
      'filepro_fieldcount',
      'filepro_fieldname',
      'filepro_fieldtype',
      'filepro_fieldwidth',
      'filepro_retrieve',
      'filepro_rowcount',
      'filesize',
      'filetype',
      'floatval',
      'flock',
      'floor',
      'flush',
      'fmod',
      'fnmatch',
      'fopen',
      'fpassthru',
      'fprintf',
      'fputs',
      'fread',
      'frenchtojd',
      'fribidi_log2vis',
      'fscanf',
      'fseek',
      'fsockopen',
      'fstat',
      'ftell',
      'ftok',
      'ftp_alloc',
      'ftp_cdup',
      'ftp_chdir',
      'ftp_chmod',
      'ftp_close',
      'ftp_connect',
      'ftp_delete',
      'ftp_exec',
      'ftp_fget',
      'ftp_fput',
      'ftp_get',
      'ftp_get_option',
      'ftp_login',
      'ftp_mdtm',
      'ftp_mkdir',
      'ftp_nb_continue',
      'ftp_nb_fget',
      'ftp_nb_fput',
      'ftp_nb_get',
      'ftp_nb_put',
      'ftp_nlist',
      'ftp_pasv',
      'ftp_put',
      'ftp_pwd',
      'ftp_quit',
      'ftp_raw',
      'ftp_rawlist',
      'ftp_rename',
      'ftp_rmdir',
      'ftp_set_option',
      'ftp_site',
      'ftp_size',
      'ftp_ssl_connect',
      'ftp_systype',
      'ftruncate',
      'func_get_arg',
      'func_get_args',
      'func_num_args',
      'function_exists',
      'fwrite',
      'gd_info',
      'get_browser',
      'get_cfg_var',
      'get_class',
      'get_class_methods',
      'get_class_vars',
      'get_current_user',
      'get_declared_classes',
      'get_declared_interfaces',
      'get_defined_constants',
      'get_defined_functions',
      'get_defined_vars',
      'get_extension_funcs',
      'get_headers',
      'get_html_translation_table',
      'get_include_path',
      'get_included_files',
      'get_loaded_extensions',
      'get_magic_quotes_gpc',
      'get_magic_quotes_runtime',
      'get_meta_tags',
      'get_object_vars',
      'get_parent_class',
      'get_required_files',
      'get_resource_type',
      'getallheaders',
      'getcwd',
      'getdate',
      'getenv',
      'gethostbyaddr',
      'gethostbyname',
      'gethostbynamel',
      'getimagesize',
      'getlastmod',
      'getmxrr',
      'getmygid',
      'getmyinode',
      'getmypid',
      'getmyuid',
      'getopt',
      'getprotobyname',
      'getprotobynumber',
      'getrandmax',
      'getrusage',
      'getservbyname',
      'getservbyport',
      'gettext',
      'gettimeofday',
      'gettype',
      'glob',
      'global',
      'gmdate',
      'gmmktime',
      'gmp_abs',
      'gmp_add',
      'gmp_and',
      'gmp_clrbit',
      'gmp_cmp',
      'gmp_com',
      'gmp_div',
      'gmp_div_q',
      'gmp_div_qr',
      'gmp_div_r',
      'gmp_divexact',
      'gmp_fact',
      'gmp_gcd',
      'gmp_gcdext',
      'gmp_hamdist',
      'gmp_init',
      'gmp_intval',
      'gmp_invert',
      'gmp_jacobi',
      'gmp_legendre',
      'gmp_mod',
      'gmp_mul',
      'gmp_neg',
      'gmp_or',
      'gmp_perfect_square',
      'gmp_popcount',
      'gmp_pow',
      'gmp_powm',
      'gmp_prob_prime',
      'gmp_random',
      'gmp_scan0',
      'gmp_scan1',
      'gmp_setbit',
      'gmp_sign',
      'gmp_sqrt',
      'gmp_sqrtrem',
      'gmp_strval',
      'gmp_sub',
      'gmp_xor',
      'gmstrftime',
      'gregoriantojd',
      'gzclose',
      'gzcompress',
      'gzdeflate',
      'gzencode',
      'gzeof',
      'gzfile',
      'gzgetc',
      'gzgets',
      'gzgetss',
      'gzinflate',
      'gzopen',
      'gzpassthru',
      'gzputs',
      'gzread',
      'gzrewind',
      'gzseek',
      'gztell',
      'gzuncompress',
      'gzwrite',
      'header',
      'headers_list',
      'headers_sent',
      'hebrev',
      'hebrevc',
      'hexdec',
      'highlight_file',
      'highlight_string',
      'html_entity_decode',
      'htmlentities',
      'htmlspecialchars',
      'http_build_query',
      'hw_array2objrec',
      'hw_changeobject',
      'hw_children',
      'hw_childrenobj',
      'hw_close',
      'hw_connect',
      'hw_connection_info',
      'hw_cp',
      'hw_deleteobject',
      'hw_docbyanchor',
      'hw_docbyanchorobj',
      'hw_document_attributes',
      'hw_document_bodytag',
      'hw_document_content',
      'hw_document_setcontent',
      'hw_document_size',
      'hw_dummy',
      'hw_edittext',
      'hw_error',
      'hw_errormsg',
      'hw_free_document',
      'hw_getanchors',
      'hw_getanchorsobj',
      'hw_getandlock',
      'hw_getchildcoll',
      'hw_getchildcollobj',
      'hw_getchilddoccoll',
      'hw_getchilddoccollobj',
      'hw_getobject',
      'hw_getobjectbyquery',
      'hw_getobjectbyquerycoll',
      'hw_getobjectbyquerycollobj',
      'hw_getobjectbyqueryobj',
      'hw_getparents',
      'hw_getparentsobj',
      'hw_getrellink',
      'hw_getremote',
      'hw_getremotechildren',
      'hw_getsrcbydestobj',
      'hw_gettext',
      'hw_getusername',
      'hw_identify',
      'hw_incollections',
      'hw_info',
      'hw_inscoll',
      'hw_insdoc',
      'hw_insertanchors',
      'hw_insertdocument',
      'hw_insertobject',
      'hw_mapid',
      'hw_modifyobject',
      'hw_mv',
      'hw_new_document',
      'hw_objrec2array',
      'hw_output_document',
      'hw_pconnect',
      'hw_pipedocument',
      'hw_root',
      'hw_setlinkroot',
      'hw_stat',
      'hw_unlock',
      'hw_who',
      'hypot',
      'ibase_blob_add',
      'ibase_blob_cancel',
      'ibase_blob_close',
      'ibase_blob_create',
      'ibase_blob_echo',
      'ibase_blob_get',
      'ibase_blob_import',
      'ibase_blob_info',
      'ibase_blob_open',
      'ibase_close',
      'ibase_commit',
      'ibase_connect',
      'ibase_errmsg',
      'ibase_execute',
      'ibase_fetch_object',
      'ibase_fetch_row',
      'ibase_field_info',
      'ibase_free_query',
      'ibase_free_result',
      'ibase_num_fields',
      'ibase_pconnect',
      'ibase_prepare',
      'ibase_query',
      'ibase_rollback',
      'ibase_timefmt',
      'ibase_trans',
      'icap_close',
      'icap_create_calendar',
      'icap_delete_calendar',
      'icap_delete_event',
      'icap_fetch_event',
      'icap_list_alarms',
      'icap_list_events',
      'icap_open',
      'icap_rename_calendar',
      'icap_reopen',
      'icap_snooze',
      'icap_store_event',
      'iconv',
      'iconv_get_encoding',
      'iconv_mime_decode',
      'iconv_mime_decode_headers',
      'iconv_mime_encode',
      'iconv_set_encoding',
      'idate',
      'ifx_affected_rows',
      'ifx_blobinfile_mode',
      'ifx_byteasvarchar',
      'ifx_close',
      'ifx_connect',
      'ifx_copy_blob',
      'ifx_create_blob',
      'ifx_create_char',
      'ifx_do',
      'ifx_error',
      'ifx_errormsg',
      'ifx_fetch_row',
      'ifx_fieldproperties',
      'ifx_fieldtypes',
      'ifx_free_blob',
      'ifx_free_char',
      'ifx_free_result',
      'ifx_get_blob',
      'ifx_get_char',
      'ifx_getsqlca',
      'ifx_htmltbl_result',
      'ifx_nullformat',
      'ifx_num_fields',
      'ifx_num_rows',
      'ifx_pconnect',
      'ifx_prepare',
      'ifx_query',
      'ifx_textasvarchar',
      'ifx_update_blob',
      'ifx_update_char',
      'ifxus_close_slob',
      'ifxus_create_slob',
      'ifxus_free_slob',
      'ifxus_open_slob',
      'ifxus_read_slob',
      'ifxus_seek_slob',
      'ifxus_tell_slob',
      'ifxus_write_slob',
      'ignore_user_abort',
      'image2wbmp',
      'image_type_to_mime_type',
      'imagealphablending',
      'imageantialias',
      'imagearc',
      'imagechar',
      'imagecharup',
      'imagecolorallocate',
      'imagecolorallocatealpha',
      'imagecolorat',
      'imagecolorclosest',
      'imagecolorclosestalpha',
      'imagecolorclosesthwb',
      'imagecolordeallocate',
      'imagecolorexact',
      'imagecolorexactalpha',
      'imagecolormatch',
      'imagecolorresolve',
      'imagecolorresolvealpha',
      'imagecolorset',
      'imagecolorsforindex',
      'imagecolorstotal',
      'imagecolortransparent',
      'imagecopy',
      'imagecopymerge',
      'imagecopymergegray',
      'imagecopyresampled',
      'imagecopyresized',
      'imagecreate',
      'imagecreatefromgd',
      'imagecreatefromgd2',
      'imagecreatefromgd2part',
      'imagecreatefromgif',
      'imagecreatefromjpeg',
      'imagecreatefrompng',
      'imagecreatefromstring',
      'imagecreatefromwbmp',
      'imagecreatefromxbm',
      'imagecreatefromxpm',
      'imagecreatetruecolor',
      'imagedashedline',
      'imagedestroy',
      'imageellipse',
      'imagefill',
      'imagefilledarc',
      'imagefilledellipse',
      'imagefilledpolygon',
      'imagefilledrectangle',
      'imagefilltoborder',
      'imagefilter',
      'imagefontheight',
      'imagefontwidth',
      'imageftbbox',
      'imagefttext',
      'imagegammacorrect',
      'imagegd',
      'imagegd2',
      'imagegif',
      'imageinterlace',
      'imageistruecolor',
      'imagejpeg',
      'imagelayereffect',
      'imageline',
      'imageloadfont',
      'imagepalettecopy',
      'imagepng',
      'imagepolygon',
      'imagepsbbox',
      'imagepsencodefont',
      'imagepsextendfont',
      'imagepsfreefont',
      'imagepsloadfont',
      'imagepsslantfont',
      'imagepstext',
      'imagerectangle',
      'imagerotate',
      'imagesavealpha',
      'imagesetbrush',
      'imagesetpixel',
      'imagesetstyle',
      'imagesetthickness',
      'imagesettile',
      'imagestring',
      'imagestringup',
      'imagesx',
      'imagesy',
      'imagetruecolortopalette',
      'imagettfbbox',
      'imagettftext',
      'imagetypes',
      'imagewbmp',
      'imagexbm',
      'imap_8bit',
      'imap_alerts',
      'imap_append',
      'imap_base64',
      'imap_binary',
      'imap_body',
      'imap_bodystruct',
      'imap_check',
      'imap_clearflag_full',
      'imap_close',
      'imap_create',
      'imap_createmailbox',
      'imap_delete',
      'imap_deletemailbox',
      'imap_errors',
      'imap_expunge',
      'imap_fetch_overview',
      'imap_fetchbody',
      'imap_fetchheader',
      'imap_fetchstructure',
      'imap_fetchtext',
      'imap_get_quota',
      'imap_get_quotaroot',
      'imap_getacl',
      'imap_getmailboxes',
      'imap_getsubscribed',
      'imap_header',
      'imap_headerinfo',
      'imap_headers',
      'imap_last_error',
      'imap_list',
      'imap_listmailbox',
      'imap_listsubscribed',
      'imap_lsub',
      'imap_mail',
      'imap_mail_compose',
      'imap_mail_copy',
      'imap_mail_move',
      'imap_mailboxmsginfo',
      'imap_mime_header_decode',
      'imap_msgno',
      'imap_num_msg',
      'imap_num_recent',
      'imap_open',
      'imap_ping',
      'imap_popen',
      'imap_qprint',
      'imap_rename',
      'imap_renamemailbox',
      'imap_reopen',
      'imap_rfc822_parse_adrlist',
      'imap_rfc822_parse_headers',
      'imap_rfc822_write_address',
      'imap_scan',
      'imap_scanmailbox',
      'imap_search',
      'imap_set_quota',
      'imap_setacl',
      'imap_setflag_full',
      'imap_sort',
      'imap_status',
      'imap_subscribe',
      'imap_thread',
      'imap_timeout',
      'imap_uid',
      'imap_undelete',
      'imap_unsubscribe',
      'imap_utf7_decode',
      'imap_utf7_encode',
      'imap_utf8',
      'implode',
      'import_request_variables',
      'in_array',
      'include',
      'include_once',
      'ingres_autocommit',
      'ingres_close',
      'ingres_commit',
      'ingres_connect',
      'ingres_fetch_array',
      'ingres_fetch_object',
      'ingres_fetch_row',
      'ingres_field_length',
      'ingres_field_name',
      'ingres_field_nullable',
      'ingres_field_precision',
      'ingres_field_scale',
      'ingres_field_type',
      'ingres_num_fields',
      'ingres_num_rows',
      'ingres_pconnect',
      'ingres_query',
      'ingres_rollback',
      'ini_alter',
      'ini_get',
      'ini_get_all',
      'ini_restore',
      'ini_set',
      'interface_exists',
      'intval',
      'ip2long',
      'iptcembed',
      'iptcparse',
      'ircg_channel_mode',
      'ircg_disconnect',
      'ircg_fetch_error_msg',
      'ircg_get_username',
      'ircg_html_encode',
      'ircg_ignore_add',
      'ircg_ignore_del',
      'ircg_is_conn_alive',
      'ircg_join',
      'ircg_kick',
      'ircg_lookup_format_messages',
      'ircg_msg',
      'ircg_nick',
      'ircg_nickname_escape',
      'ircg_nickname_unescape',
      'ircg_notice',
      'ircg_part',
      'ircg_pconnect',
      'ircg_register_format_messages',
      'ircg_set_current',
      'ircg_set_file',
      'ircg_set_on_die',
      'ircg_topic',
      'ircg_whois',
      'is_a',
      'is_array',
      'is_bool',
      'is_callable',
      'is_dir',
      'is_double',
      'is_executable',
      'is_file',
      'is_finite',
      'is_float',
      'is_infinite',
      'is_int',
      'is_integer',
      'is_link',
      'is_long',
      'is_nan',
      'is_null',
      'is_numeric',
      'is_object',
      'is_readable',
      'is_real',
      'is_resource',
      'is_scalar',
      'is_string',
      'is_subclass_of',
      'is_uploaded_file',
      'is_writable',
      'is_writeable',
      'isset',
      'java_last_exception_clear',
      'java_last_exception_get',
      'jddayofweek',
      'jdmonthname',
      'jdtofrench',
      'jdtogregorian',
      'jdtojewish',
      'jdtojulian',
      'jdtounix',
      'jewishtojd',
      'join',
      'jpeg2wbmp',
      'juliantojd',
      'key',
      'key_exists',
      'krsort',
      'ksort',
      'lcg_value',
      'ldap_8859_to_t61',
      'ldap_add',
      'ldap_bind',
      'ldap_close',
      'ldap_compare',
      'ldap_connect',
      'ldap_count_entries',
      'ldap_delete',
      'ldap_dn2ufn',
      'ldap_err2str',
      'ldap_errno',
      'ldap_error',
      'ldap_explode_dn',
      'ldap_first_attribute',
      'ldap_first_entry',
      'ldap_first_reference',
      'ldap_free_result',
      'ldap_get_attributes',
      'ldap_get_dn',
      'ldap_get_entries',
      'ldap_get_option',
      'ldap_get_values',
      'ldap_get_values_len',
      'ldap_list',
      'ldap_mod_add',
      'ldap_mod_del',
      'ldap_mod_replace',
      'ldap_modify',
      'ldap_next_attribute',
      'ldap_next_entry',
      'ldap_next_reference',
      'ldap_parse_reference',
      'ldap_parse_result',
      'ldap_read',
      'ldap_rename',
      'ldap_search',
      'ldap_set_option',
      'ldap_set_rebind_proc',
      'ldap_sort',
      'ldap_start_tls',
      'ldap_t61_to_8859',
      'ldap_unbind',
      'leak',
      'levenshtein',
      'libxml_set_streams_context',
      'link',
      'linkinfo',
      'list',
      'localeconv',
      'localtime',
      'log',
      'log10',
      'log1p',
      'long2ip',
      'lstat',
      'ltrim',
      'magic_quotes_runtime',
      'mail',
      'mailparse_determine_best_xfer_encoding',
      'mailparse_msg_create',
      'mailparse_msg_extract_part',
      'mailparse_msg_extract_part_file',
      'mailparse_msg_free',
      'mailparse_msg_get_part',
      'mailparse_msg_get_part_data',
      'mailparse_msg_get_structure',
      'mailparse_msg_parse',
      'mailparse_msg_parse_file',
      'mailparse_rfc822_parse_addresses',
      'mailparse_stream_encode',
      'mailparse_uudecode_all',
      'max',
      'mb_convert_case',
      'mb_convert_encoding',
      'mb_convert_kana',
      'mb_convert_variables',
      'mb_decode_mimeheader',
      'mb_decode_numericentity',
      'mb_detect_encoding',
      'mb_detect_order',
      'mb_encode_mimeheader',
      'mb_encode_numericentity',
      'mb_ereg',
      'mb_ereg_match',
      'mb_ereg_replace',
      'mb_ereg_search',
      'mb_ereg_search_getpos',
      'mb_ereg_search_getregs',
      'mb_ereg_search_init',
      'mb_ereg_search_pos',
      'mb_ereg_search_regs',
      'mb_ereg_search_setpos',
      'mb_eregi',
      'mb_eregi_replace',
      'mb_get_info',
      'mb_http_input',
      'mb_http_output',
      'mb_internal_encoding',
      'mb_language',
      'mb_output_handler',
      'mb_parse_str',
      'mb_preferred_mime_name',
      'mb_regex_encoding',
      'mb_regex_set_options',
      'mb_send_mail',
      'mb_split',
      'mb_strcut',
      'mb_strimwidth',
      'mb_strlen',
      'mb_strpos',
      'mb_strrpos',
      'mb_strtolower',
      'mb_strtoupper',
      'mb_strwidth',
      'mb_substitute_character',
      'mb_substr',
      'mcal_append_event',
      'mcal_close',
      'mcal_create_calendar',
      'mcal_date_compare',
      'mcal_date_valid',
      'mcal_day_of_week',
      'mcal_day_of_year',
      'mcal_days_in_month',
      'mcal_delete_calendar',
      'mcal_delete_event',
      'mcal_event_add_attribute',
      'mcal_event_init',
      'mcal_event_set_alarm',
      'mcal_event_set_category',
      'mcal_event_set_class',
      'mcal_event_set_description',
      'mcal_event_set_end',
      'mcal_event_set_recur_daily',
      'mcal_event_set_recur_monthly_mday',
      'mcal_event_set_recur_monthly_wday',
      'mcal_event_set_recur_none',
      'mcal_event_set_recur_weekly',
      'mcal_event_set_recur_yearly',
      'mcal_event_set_start',
      'mcal_event_set_title',
      'mcal_expunge',
      'mcal_fetch_current_stream_event',
      'mcal_fetch_event',
      'mcal_is_leap_year',
      'mcal_list_alarms',
      'mcal_list_events',
      'mcal_next_recurrence',
      'mcal_open',
      'mcal_popen',
      'mcal_rename_calendar',
      'mcal_reopen',
      'mcal_snooze',
      'mcal_store_event',
      'mcal_time_valid',
      'mcal_week_of_year',
      'mcrypt_cbc',
      'mcrypt_cfb',
      'mcrypt_create_iv',
      'mcrypt_decrypt',
      'mcrypt_ecb',
      'mcrypt_enc_get_algorithms_name',
      'mcrypt_enc_get_block_size',
      'mcrypt_enc_get_iv_size',
      'mcrypt_enc_get_key_size',
      'mcrypt_enc_get_modes_name',
      'mcrypt_enc_get_supported_key_sizes',
      'mcrypt_enc_is_block_algorithm',
      'mcrypt_enc_is_block_algorithm_mode',
      'mcrypt_enc_is_block_mode',
      'mcrypt_enc_self_test',
      'mcrypt_encrypt',
      'mcrypt_generic',
      'mcrypt_generic_deinit',
      'mcrypt_generic_end',
      'mcrypt_generic_init',
      'mcrypt_get_block_size',
      'mcrypt_get_cipher_name',
      'mcrypt_get_iv_size',
      'mcrypt_get_key_size',
      'mcrypt_list_algorithms',
      'mcrypt_list_modes',
      'mcrypt_module_close',
      'mcrypt_module_get_algo_block_size',
      'mcrypt_module_get_algo_key_size',
      'mcrypt_module_get_supported_key_sizes',
      'mcrypt_module_is_block_algorithm',
      'mcrypt_module_is_block_algorithm_mode',
      'mcrypt_module_is_block_mode',
      'mcrypt_module_open',
      'mcrypt_module_self_test',
      'mcrypt_ofb',
      'md5',
      'md5_file',
      'mdecrypt_generic',
      'memory_get_usage',
      'metaphone',
      'method_exists',
      'mhash',
      'mhash_count',
      'mhash_get_block_size',
      'mhash_get_hash_name',
      'mhash_keygen_s2k',
      'microtime',
      'min',
      'ming_setcubicthreshold',
      'ming_setscale',
      'ming_useswfversion',
      'mkdir',
      'mktime',
      'money_format',
      'move_uploaded_file',
      'msession_connect',
      'msession_count',
      'msession_create',
      'msession_destroy',
      'msession_disconnect',
      'msession_find',
      'msession_get',
      'msession_get_array',
      'msession_getdata',
      'msession_inc',
      'msession_list',
      'msession_listvar',
      'msession_lock',
      'msession_plugin',
      'msession_randstr',
      'msession_set',
      'msession_set_array',
      'msession_setdata',
      'msession_timeout',
      'msession_uniq',
      'msession_unlock',
      'msg_get_queue',
      'msg_receive',
      'msg_remove_queue',
      'msg_send',
      'msg_set_queue',
      'msg_stat_queue',
      'msql',
      'msql_affected_rows',
      'msql_close',
      'msql_connect',
      'msql_create_db',
      'msql_createdb',
      'msql_data_seek',
      'msql_dbname',
      'msql_drop_db',
      'msql_dropdb',
      'msql_error',
      'msql_fetch_array',
      'msql_fetch_field',
      'msql_fetch_object',
      'msql_fetch_row',
      'msql_field_seek',
      'msql_fieldflags',
      'msql_fieldlen',
      'msql_fieldname',
      'msql_fieldtable',
      'msql_fieldtype',
      'msql_free_result',
      'msql_freeresult',
      'msql_list_dbs',
      'msql_list_fields',
      'msql_list_tables',
      'msql_listdbs',
      'msql_listfields',
      'msql_listtables',
      'msql_num_fields',
      'msql_num_rows',
      'msql_numfields',
      'msql_numrows',
      'msql_pconnect',
      'msql_query',
      'msql_regcase',
      'msql_result',
      'msql_select_db',
      'msql_selectdb',
      'msql_tablename',
      'mssql_bind',
      'mssql_close',
      'mssql_connect',
      'mssql_data_seek',
      'mssql_execute',
      'mssql_fetch_array',
      'mssql_fetch_assoc',
      'mssql_fetch_batch',
      'mssql_fetch_field',
      'mssql_fetch_object',
      'mssql_fetch_row',
      'mssql_field_length',
      'mssql_field_name',
      'mssql_field_seek',
      'mssql_field_type',
      'mssql_free_result',
      'mssql_get_last_message',
      'mssql_guid_string',
      'mssql_init',
      'mssql_min_error_severity',
      'mssql_min_message_severity',
      'mssql_next_result',
      'mssql_num_fields',
      'mssql_num_rows',
      'mssql_pconnect',
      'mssql_query',
      'mssql_result',
      'mssql_rows_affected',
      'mssql_select_db',
      'mt_getrandmax',
      'mt_rand',
      'mt_srand',
      'muscat_close',
      'muscat_get',
      'muscat_give',
      'muscat_setup',
      'muscat_setup_net',
      'mysql',
      'mysql_affected_rows',
      'mysql_change_user',
      'mysql_character_set_name',
      'mysql_client_encoding',
      'mysql_close',
      'mysql_connect',
      'mysql_create_db',
      'mysql_data_seek',
      'mysql_db_name',
      'mysql_db_query',
      'mysql_dbname',
      'mysql_drop_db',
      'mysql_errno',
      'mysql_error',
      'mysql_escape_string',
      'mysql_fetch_array',
      'mysql_fetch_assoc',
      'mysql_fetch_field',
      'mysql_fetch_lengths',
      'mysql_fetch_object',
      'mysql_fetch_row',
      'mysql_field_flags',
      'mysql_field_len',
      'mysql_field_name',
      'mysql_field_seek',
      'mysql_field_table',
      'mysql_field_type',
      'mysql_fieldflags',
      'mysql_fieldlen',
      'mysql_fieldname',
      'mysql_fieldtable',
      'mysql_fieldtype',
      'mysql_free_result',
      'mysql_freeresult',
      'mysql_get_client_info',
      'mysql_get_host_info',
      'mysql_get_proto_info',
      'mysql_get_server_info',
      'mysql_info',
      'mysql_insert_id',
      'mysql_list_dbs',
      'mysql_list_fields',
      'mysql_list_processes',
      'mysql_list_tables',
      'mysql_listdbs',
      'mysql_listfields',
      'mysql_listtables',
      'mysql_num_fields',
      'mysql_num_rows',
      'mysql_numfields',
      'mysql_numrows',
      'mysql_pconnect',
      'mysql_ping',
      'mysql_query',
      'mysql_real_escape_string',
      'mysql_result',
      'mysql_select_db',
      'mysql_selectdb',
      'mysql_stat',
      'mysql_table_name',
      'mysql_tablename',
      'mysql_thread_id',
      'mysql_unbuffered_query',
      'mysqli_affected_rows',
      'mysqli_autocommit',
      'mysqli_bind_param',
      'mysqli_bind_result',
      'mysqli_change_user',
      'mysqli_character_set_name',
      'mysqli_client_encoding',
      'mysqli_close',
      'mysqli_commit',
      'mysqli_connect',
      'mysqli_connect_errno',
      'mysqli_connect_error',
      'mysqli_data_seek',
      'mysqli_debug',
      'mysqli_disable_reads_from_master',
      'mysqli_disable_rpl_parse',
      'mysqli_dump_debug_info',
      'mysqli_enable_reads_from_master',
      'mysqli_enable_rpl_parse',
      'mysqli_errno',
      'mysqli_error',
      'mysqli_escape_string',
      'mysqli_execute',
      'mysqli_fetch',
      'mysqli_fetch_array',
      'mysqli_fetch_assoc',
      'mysqli_fetch_field',
      'mysqli_fetch_field_direct',
      'mysqli_fetch_fields',
      'mysqli_fetch_lengths',
      'mysqli_fetch_object',
      'mysqli_fetch_row',
      'mysqli_field_count',
      'mysqli_field_seek',
      'mysqli_field_tell',
      'mysqli_free_result',
      'mysqli_get_client_info',
      'mysqli_get_client_version',
      'mysqli_get_host_info',
      'mysqli_get_metadata',
      'mysqli_get_proto_info',
      'mysqli_get_server_info',
      'mysqli_get_server_version',
      'mysqli_info',
      'mysqli_init',
      'mysqli_insert_id',
      'mysqli_kill',
      'mysqli_master_query',
      'mysqli_more_results',
      'mysqli_multi_query',
      'mysqli_next_result',
      'mysqli_num_fields',
      'mysqli_num_rows',
      'mysqli_options',
      'mysqli_param_count',
      'mysqli_ping',
      'mysqli_prepare',
      'mysqli_query',
      'mysqli_real_connect',
      'mysqli_real_escape_string',
      'mysqli_real_query',
      'mysqli_report',
      'mysqli_rollback',
      'mysqli_rpl_parse_enabled',
      'mysqli_rpl_probe',
      'mysqli_rpl_query_type',
      'mysqli_select_db',
      'mysqli_send_long_data',
      'mysqli_send_query',
      'mysqli_set_local_infile_default',
      'mysqli_set_local_infile_handler',
      'mysqli_set_opt',
      'mysqli_slave_query',
      'mysqli_sqlstate',
      'mysqli_ssl_set',
      'mysqli_stat',
      'mysqli_stmt_affected_rows',
      'mysqli_stmt_attr_get',
      'mysqli_stmt_attr_set',
      'mysqli_stmt_bind_param',
      'mysqli_stmt_bind_result',
      'mysqli_stmt_close',
      'mysqli_stmt_data_seek',
      'mysqli_stmt_errno',
      'mysqli_stmt_error',
      'mysqli_stmt_execute',
      'mysqli_stmt_fetch',
      'mysqli_stmt_field_count',
      'mysqli_stmt_free_result',
      'mysqli_stmt_init',
      'mysqli_stmt_insert_id',
      'mysqli_stmt_num_rows',
      'mysqli_stmt_param_count',
      'mysqli_stmt_prepare',
      'mysqli_stmt_reset',
      'mysqli_stmt_result_metadata',
      'mysqli_stmt_send_long_data',
      'mysqli_stmt_sqlstate',
      'mysqli_stmt_store_result',
      'mysqli_store_result',
      'mysqli_thread_id',
      'mysqli_thread_safe',
      'mysqli_use_result',
      'mysqli_warning_count',
      'natcasesort',
      'natsort',
      'ncurses_addch',
      'ncurses_addchnstr',
      'ncurses_addchstr',
      'ncurses_addnstr',
      'ncurses_addstr',
      'ncurses_assume_default_colors',
      'ncurses_attroff',
      'ncurses_attron',
      'ncurses_attrset',
      'ncurses_baudrate',
      'ncurses_beep',
      'ncurses_bkgd',
      'ncurses_bkgdset',
      'ncurses_border',
      'ncurses_bottom_panel',
      'ncurses_can_change_color',
      'ncurses_cbreak',
      'ncurses_clear',
      'ncurses_clrtobot',
      'ncurses_clrtoeol',
      'ncurses_color_content',
      'ncurses_color_set',
      'ncurses_curs_set',
      'ncurses_def_prog_mode',
      'ncurses_def_shell_mode',
      'ncurses_define_key',
      'ncurses_del_panel',
      'ncurses_delay_output',
      'ncurses_delch',
      'ncurses_deleteln',
      'ncurses_delwin',
      'ncurses_doupdate',
      'ncurses_echo',
      'ncurses_echochar',
      'ncurses_end',
      'ncurses_erase',
      'ncurses_erasechar',
      'ncurses_filter',
      'ncurses_flash',
      'ncurses_flushinp',
      'ncurses_getch',
      'ncurses_getmaxyx',
      'ncurses_getmouse',
      'ncurses_getyx',
      'ncurses_halfdelay',
      'ncurses_has_colors',
      'ncurses_has_ic',
      'ncurses_has_il',
      'ncurses_has_key',
      'ncurses_hide_panel',
      'ncurses_hline',
      'ncurses_inch',
      'ncurses_init',
      'ncurses_init_color',
      'ncurses_init_pair',
      'ncurses_insch',
      'ncurses_insdelln',
      'ncurses_insertln',
      'ncurses_insstr',
      'ncurses_instr',
      'ncurses_isendwin',
      'ncurses_keyok',
      'ncurses_keypad',
      'ncurses_killchar',
      'ncurses_longname',
      'ncurses_meta',
      'ncurses_mouse_trafo',
      'ncurses_mouseinterval',
      'ncurses_mousemask',
      'ncurses_move',
      'ncurses_move_panel',
      'ncurses_mvaddch',
      'ncurses_mvaddchnstr',
      'ncurses_mvaddchstr',
      'ncurses_mvaddnstr',
      'ncurses_mvaddstr',
      'ncurses_mvcur',
      'ncurses_mvdelch',
      'ncurses_mvgetch',
      'ncurses_mvhline',
      'ncurses_mvinch',
      'ncurses_mvvline',
      'ncurses_mvwaddstr',
      'ncurses_napms',
      'ncurses_new_panel',
      'ncurses_newpad',
      'ncurses_newwin',
      'ncurses_nl',
      'ncurses_nocbreak',
      'ncurses_noecho',
      'ncurses_nonl',
      'ncurses_noqiflush',
      'ncurses_noraw',
      'ncurses_pair_content',
      'ncurses_panel_above',
      'ncurses_panel_below',
      'ncurses_panel_window',
      'ncurses_pnoutrefresh',
      'ncurses_prefresh',
      'ncurses_putp',
      'ncurses_qiflush',
      'ncurses_raw',
      'ncurses_refresh',
      'ncurses_replace_panel',
      'ncurses_reset_prog_mode',
      'ncurses_reset_shell_mode',
      'ncurses_resetty',
      'ncurses_savetty',
      'ncurses_scr_dump',
      'ncurses_scr_init',
      'ncurses_scr_restore',
      'ncurses_scr_set',
      'ncurses_scrl',
      'ncurses_show_panel',
      'ncurses_slk_attr',
      'ncurses_slk_attroff',
      'ncurses_slk_attron',
      'ncurses_slk_attrset',
      'ncurses_slk_clear',
      'ncurses_slk_color',
      'ncurses_slk_init',
      'ncurses_slk_noutrefresh',
      'ncurses_slk_refresh',
      'ncurses_slk_restore',
      'ncurses_slk_set',
      'ncurses_slk_touch',
      'ncurses_standend',
      'ncurses_standout',
      'ncurses_start_color',
      'ncurses_termattrs',
      'ncurses_termname',
      'ncurses_timeout',
      'ncurses_top_panel',
      'ncurses_typeahead',
      'ncurses_ungetch',
      'ncurses_ungetmouse',
      'ncurses_update_panels',
      'ncurses_use_default_colors',
      'ncurses_use_env',
      'ncurses_use_extended_names',
      'ncurses_vidattr',
      'ncurses_vline',
      'ncurses_waddch',
      'ncurses_waddstr',
      'ncurses_wattroff',
      'ncurses_wattron',
      'ncurses_wattrset',
      'ncurses_wborder',
      'ncurses_wclear',
      'ncurses_wcolor_set',
      'ncurses_werase',
      'ncurses_wgetch',
      'ncurses_whline',
      'ncurses_wmouse_trafo',
      'ncurses_wmove',
      'ncurses_wnoutrefresh',
      'ncurses_wrefresh',
      'ncurses_wstandend',
      'ncurses_wstandout',
      'ncurses_wvline',
      'next',
      'ngettext',
      'nl2br',
      'nl_langinfo',
      'notes_body',
      'notes_copy_db',
      'notes_create_db',
      'notes_create_note',
      'notes_drop_db',
      'notes_find_note',
      'notes_header_info',
      'notes_list_msgs',
      'notes_mark_read',
      'notes_mark_unread',
      'notes_nav_create',
      'notes_search',
      'notes_unread',
      'notes_version',
      'number_format',
      'ob_clean',
      'ob_end_clean',
      'ob_end_flush',
      'ob_flush',
      'ob_get_clean',
      'ob_get_contents',
      'ob_get_flush',
      'ob_get_length',
      'ob_get_level',
      'ob_get_status',
      'ob_gzhandler',
      'ob_iconv_handler',
      'ob_implicit_flush',
      'ob_list_handlers',
      'ob_start',
      'ocibindbyname',
      'ocicancel',
      'ocicollappend',
      'ocicollassign',
      'ocicollassignelem',
      'ocicollgetelem',
      'ocicollmax',
      'ocicollsize',
      'ocicolltrim',
      'ocicolumnisnull',
      'ocicolumnname',
      'ocicolumnprecision',
      'ocicolumnscale',
      'ocicolumnsize',
      'ocicolumntype',
      'ocicolumntyperaw',
      'ocicommit',
      'ocidefinebyname',
      'ocierror',
      'ociexecute',
      'ocifetch',
      'ocifetchinto',
      'ocifetchstatement',
      'ocifreecollection',
      'ocifreecursor',
      'ocifreedesc',
      'ocifreestatement',
      'ociinternaldebug',
      'ociloadlob',
      'ocilogoff',
      'ocilogon',
      'ocinewcollection',
      'ocinewcursor',
      'ocinewdescriptor',
      'ocinlogon',
      'ocinumcols',
      'ociparse',
      'ociplogon',
      'ociresult',
      'ocirollback',
      'ocirowcount',
      'ocisavelob',
      'ocisavelobfile',
      'ociserverversion',
      'ocisetprefetch',
      'ocistatementtype',
      'ociwritelobtofile',
      'octdec',
      'odbc_autocommit',
      'odbc_binmode',
      'odbc_close',
      'odbc_close_all',
      'odbc_columnprivileges',
      'odbc_columns',
      'odbc_commit',
      'odbc_connect',
      'odbc_cursor',
      'odbc_data_source',
      'odbc_do',
      'odbc_error',
      'odbc_errormsg',
      'odbc_exec',
      'odbc_execute',
      'odbc_fetch_array',
      'odbc_fetch_into',
      'odbc_fetch_object',
      'odbc_fetch_row',
      'odbc_field_len',
      'odbc_field_name',
      'odbc_field_num',
      'odbc_field_precision',
      'odbc_field_scale',
      'odbc_field_type',
      'odbc_foreignkeys',
      'odbc_free_result',
      'odbc_gettypeinfo',
      'odbc_longreadlen',
      'odbc_next_result',
      'odbc_num_fields',
      'odbc_num_rows',
      'odbc_pconnect',
      'odbc_prepare',
      'odbc_primarykeys',
      'odbc_procedurecolumns',
      'odbc_procedures',
      'odbc_result',
      'odbc_result_all',
      'odbc_rollback',
      'odbc_setoption',
      'odbc_specialcolumns',
      'odbc_statistics',
      'odbc_tableprivileges',
      'odbc_tables',
      'opendir',
      'openlog',
      'openssl_csr_export',
      'openssl_csr_export_to_file',
      'openssl_csr_new',
      'openssl_csr_sign',
      'openssl_error_string',
      'openssl_free_key',
      'openssl_get_privatekey',
      'openssl_get_publickey',
      'openssl_open',
      'openssl_pkcs7_decrypt',
      'openssl_pkcs7_encrypt',
      'openssl_pkcs7_sign',
      'openssl_pkcs7_verify',
      'openssl_pkey_export',
      'openssl_pkey_export_to_file',
      'openssl_pkey_free',
      'openssl_pkey_get_private',
      'openssl_pkey_get_public',
      'openssl_pkey_new',
      'openssl_private_decrypt',
      'openssl_private_encrypt',
      'openssl_public_decrypt',
      'openssl_public_encrypt',
      'openssl_seal',
      'openssl_sign',
      'openssl_verify',
      'openssl_x509_check_private_key',
      'openssl_x509_checkpurpose',
      'openssl_x509_export',
      'openssl_x509_export_to_file',
      'openssl_x509_free',
      'openssl_x509_parse',
      'openssl_x509_read',
      'ora_bind',
      'ora_close',
      'ora_columnname',
      'ora_columnsize',
      'ora_columntype',
      'ora_commit',
      'ora_commitoff',
      'ora_commiton',
      'ora_do',
      'ora_error',
      'ora_errorcode',
      'ora_exec',
      'ora_fetch',
      'ora_fetch_into',
      'ora_getcolumn',
      'ora_logoff',
      'ora_logon',
      'ora_numcols',
      'ora_numrows',
      'ora_open',
      'ora_parse',
      'ora_plogon',
      'ora_rollback',
      'ord',
      'output_add_rewrite_var',
      'output_reset_rewrite_vars',
      'overload',
      'ovrimos_close',
      'ovrimos_commit',
      'ovrimos_connect',
      'ovrimos_cursor',
      'ovrimos_exec',
      'ovrimos_execute',
      'ovrimos_fetch_into',
      'ovrimos_fetch_row',
      'ovrimos_field_len',
      'ovrimos_field_name',
      'ovrimos_field_num',
      'ovrimos_field_type',
      'ovrimos_free_result',
      'ovrimos_longreadlen',
      'ovrimos_num_fields',
      'ovrimos_num_rows',
      'ovrimos_prepare',
      'ovrimos_result',
      'ovrimos_result_all',
      'ovrimos_rollback',
      'pack',
      'parse_ini_file',
      'parse_str',
      'parse_url',
      'passthru',
      'pathinfo',
      'pclose',
      'pcntl_alarm',
      'pcntl_exec',
      'pcntl_fork',
      'pcntl_getpriority',
      'pcntl_setpriority',
      'pcntl_signal',
      'pcntl_wait',
      'pcntl_waitpid',
      'pcntl_wexitstatus',
      'pcntl_wifexited',
      'pcntl_wifsignaled',
      'pcntl_wifstopped',
      'pcntl_wstopsig',
      'pcntl_wtermsig',
      'pdf_add_annotation',
      'pdf_add_bookmark',
      'pdf_add_launchlink',
      'pdf_add_locallink',
      'pdf_add_note',
      'pdf_add_outline',
      'pdf_add_pdflink',
      'pdf_add_thumbnail',
      'pdf_add_weblink',
      'pdf_arc',
      'pdf_arcn',
      'pdf_attach_file',
      'pdf_begin_page',
      'pdf_begin_pattern',
      'pdf_begin_template',
      'pdf_circle',
      'pdf_clip',
      'pdf_close',
      'pdf_close_image',
      'pdf_close_pdi',
      'pdf_close_pdi_page',
      'pdf_closepath',
      'pdf_closepath_fill_stroke',
      'pdf_closepath_stroke',
      'pdf_concat',
      'pdf_continue_text',
      'pdf_curveto',
      'pdf_delete',
      'pdf_end_page',
      'pdf_end_pattern',
      'pdf_end_template',
      'pdf_endpath',
      'pdf_fill',
      'pdf_fill_stroke',
      'pdf_findfont',
      'pdf_get_buffer',
      'pdf_get_font',
      'pdf_get_fontname',
      'pdf_get_fontsize',
      'pdf_get_image_height',
      'pdf_get_image_width',
      'pdf_get_majorversion',
      'pdf_get_minorversion',
      'pdf_get_parameter',
      'pdf_get_pdi_parameter',
      'pdf_get_pdi_value',
      'pdf_get_value',
      'pdf_initgraphics',
      'pdf_lineto',
      'pdf_makespotcolor',
      'pdf_moveto',
      'pdf_new',
      'pdf_open',
      'pdf_open_ccitt',
      'pdf_open_file',
      'pdf_open_gif',
      'pdf_open_image',
      'pdf_open_image_file',
      'pdf_open_jpeg',
      'pdf_open_memory_image',
      'pdf_open_pdi',
      'pdf_open_pdi_page',
      'pdf_open_png',
      'pdf_open_tiff',
      'pdf_place_image',
      'pdf_place_pdi_page',
      'pdf_rect',
      'pdf_restore',
      'pdf_rotate',
      'pdf_save',
      'pdf_scale',
      'pdf_set_border_color',
      'pdf_set_border_dash',
      'pdf_set_border_style',
      'pdf_set_char_spacing',
      'pdf_set_duration',
      'pdf_set_font',
      'pdf_set_horiz_scaling',
      'pdf_set_info',
      'pdf_set_info_author',
      'pdf_set_info_creator',
      'pdf_set_info_keywords',
      'pdf_set_info_subject',
      'pdf_set_info_title',
      'pdf_set_leading',
      'pdf_set_parameter',
      'pdf_set_text_pos',
      'pdf_set_text_rendering',
      'pdf_set_text_rise',
      'pdf_set_transition',
      'pdf_set_value',
      'pdf_set_word_spacing',
      'pdf_setcolor',
      'pdf_setdash',
      'pdf_setflat',
      'pdf_setfont',
      'pdf_setgray',
      'pdf_setgray_fill',
      'pdf_setgray_stroke',
      'pdf_setlinecap',
      'pdf_setlinejoin',
      'pdf_setlinewidth',
      'pdf_setmatrix',
      'pdf_setmiterlimit',
      'pdf_setpolydash',
      'pdf_setrgbcolor',
      'pdf_setrgbcolor_fill',
      'pdf_setrgbcolor_stroke',
      'pdf_show',
      'pdf_show_boxed',
      'pdf_show_xy',
      'pdf_skew',
      'pdf_stringwidth',
      'pdf_stroke',
      'pdf_translate',
      'pfpro_cleanup',
      'pfpro_init',
      'pfpro_process',
      'pfpro_process_raw',
      'pfpro_version',
      'pfsockopen',
      'pg_affected_rows',
      'pg_cancel_query',
      'pg_client_encoding',
      'pg_clientencoding',
      'pg_close',
      'pg_cmdtuples',
      'pg_connect',
      'pg_connection_busy',
      'pg_connection_reset',
      'pg_connection_status',
      'pg_convert',
      'pg_copy_from',
      'pg_copy_to',
      'pg_dbname',
      'pg_delete',
      'pg_end_copy',
      'pg_errormessage',
      'pg_escape_bytea',
      'pg_escape_string',
      'pg_exec',
      'pg_fetch_all',
      'pg_fetch_array',
      'pg_fetch_assoc',
      'pg_fetch_object',
      'pg_fetch_result',
      'pg_fetch_row',
      'pg_field_is_null',
      'pg_field_name',
      'pg_field_num',
      'pg_field_prtlen',
      'pg_field_size',
      'pg_field_type',
      'pg_fieldisnull',
      'pg_fieldname',
      'pg_fieldnum',
      'pg_fieldprtlen',
      'pg_fieldsize',
      'pg_fieldtype',
      'pg_free_result',
      'pg_freeresult',
      'pg_get_notify',
      'pg_get_pid',
      'pg_get_result',
      'pg_getlastoid',
      'pg_host',
      'pg_insert',
      'pg_last_error',
      'pg_last_notice',
      'pg_last_oid',
      'pg_lo_close',
      'pg_lo_create',
      'pg_lo_export',
      'pg_lo_import',
      'pg_lo_open',
      'pg_lo_read',
      'pg_lo_read_all',
      'pg_lo_seek',
      'pg_lo_tell',
      'pg_lo_unlink',
      'pg_lo_write',
      'pg_loclose',
      'pg_locreate',
      'pg_loexport',
      'pg_loimport',
      'pg_loopen',
      'pg_loread',
      'pg_loreadall',
      'pg_lounlink',
      'pg_lowrite',
      'pg_meta_data',
      'pg_num_fields',
      'pg_num_rows',
      'pg_numfields',
      'pg_numrows',
      'pg_options',
      'pg_parameter_status',
      'pg_pconnect',
      'pg_ping',
      'pg_port',
      'pg_put_line',
      'pg_query',
      'pg_result',
      'pg_result_error',
      'pg_result_seek',
      'pg_result_status',
      'pg_select',
      'pg_send_query',
      'pg_set_client_encoding',
      'pg_setclientencoding',
      'pg_trace',
      'pg_tty',
      'pg_unescape_bytea',
      'pg_untrace',
      'pg_update',
      'pg_version',
      'php_check_syntax',
      'php_egg_logo_guid',
      'php_ini_scanned_files',
      'php_logo_guid',
      'php_real_logo_guid',
      'php_sapi_name',
      'php_strip_whitespace',
      'php_uname',
      'phpcredits',
      'phpinfo',
      'phpversion',
      'pi',
      'png2wbmp',
      'popen',
      'pos',
      'posix_ctermid',
      'posix_errno',
      'posix_get_last_error',
      'posix_getcwd',
      'posix_getegid',
      'posix_geteuid',
      'posix_getgid',
      'posix_getgrgid',
      'posix_getgrnam',
      'posix_getgroups',
      'posix_getlogin',
      'posix_getpgid',
      'posix_getpgrp',
      'posix_getpid',
      'posix_getppid',
      'posix_getpwnam',
      'posix_getpwuid',
      'posix_getrlimit',
      'posix_getsid',
      'posix_getuid',
      'posix_isatty',
      'posix_kill',
      'posix_mkfifo',
      'posix_setegid',
      'posix_seteuid',
      'posix_setgid',
      'posix_setpgid',
      'posix_setsid',
      'posix_setuid',
      'posix_strerror',
      'posix_times',
      'posix_ttyname',
      'posix_uname',
      'pow',
      'preg_grep',
      'preg_match',
      'preg_match_all',
      'preg_quote',
      'preg_replace',
      'preg_replace_callback',
      'preg_split',
      'prev',
      'print',
      'print_r',
      'printer_abort',
      'printer_close',
      'printer_create_brush',
      'printer_create_dc',
      'printer_create_font',
      'printer_create_pen',
      'printer_delete_brush',
      'printer_delete_dc',
      'printer_delete_font',
      'printer_delete_pen',
      'printer_draw_bmp',
      'printer_draw_chord',
      'printer_draw_elipse',
      'printer_draw_line',
      'printer_draw_pie',
      'printer_draw_rectangle',
      'printer_draw_roundrect',
      'printer_draw_text',
      'printer_end_doc',
      'printer_end_page',
      'printer_get_option',
      'printer_list',
      'printer_logical_fontheight',
      'printer_open',
      'printer_select_brush',
      'printer_select_font',
      'printer_select_pen',
      'printer_set_option',
      'printer_start_doc',
      'printer_start_page',
      'printer_write',
      'printf',
      'proc_close',
      'proc_get_status',
      'proc_nice',
      'proc_open',
      'proc_terminate',
      'pspell_add_to_personal',
      'pspell_add_to_session',
      'pspell_check',
      'pspell_clear_session',
      'pspell_config_create',
      'pspell_config_ignore',
      'pspell_config_mode',
      'pspell_config_personal',
      'pspell_config_repl',
      'pspell_config_runtogether',
      'pspell_config_save_repl',
      'pspell_new',
      'pspell_new_config',
      'pspell_new_personal',
      'pspell_save_wordlist',
      'pspell_store_replacement',
      'pspell_suggest',
      'putenv',
      'qdom_error',
      'qdom_tree',
      'quoted_printable_decode',
      'quotemeta',
      'rad2deg',
      'rand',
      'range',
      'rawurldecode',
      'rawurlencode',
      'read_exif_data',
      'readdir',
      'readfile',
      'readgzfile',
      'readline',
      'readline_add_history',
      'readline_clear_history',
      'readline_completion_function',
      'readline_info',
      'readline_list_history',
      'readline_read_history',
      'readline_write_history',
      'readlink',
      'realpath',
      'recode',
      'recode_file',
      'recode_string',
      'register_shutdown_function',
      'register_tick_function',
      'rename',
      'require',
      'require_once',
      'reset',
      'restore_error_handler',
      'restore_exception_handler',
      'restore_include_path',
      'rewind',
      'rewinddir',
      'rmdir',
      'round',
      'rsort',
      'rtrim',
      'scandir',
      'sem_acquire',
      'sem_get',
      'sem_release',
      'sem_remove',
      'serialize',
      'sesam_affected_rows',
      'sesam_commit',
      'sesam_connect',
      'sesam_diagnostic',
      'sesam_disconnect',
      'sesam_errormsg',
      'sesam_execimm',
      'sesam_fetch_array',
      'sesam_fetch_result',
      'sesam_fetch_row',
      'sesam_field_array',
      'sesam_field_name',
      'sesam_free_result',
      'sesam_num_fields',
      'sesam_query',
      'sesam_rollback',
      'sesam_seek_row',
      'sesam_settransaction',
      'session_cache_expire',
      'session_cache_limiter',
      'session_commit',
      'session_decode',
      'session_destroy',
      'session_encode',
      'session_get_cookie_params',
      'session_id',
      'session_is_registered',
      'session_module_name',
      'session_name',
      'session_regenerate_id',
      'session_register',
      'session_save_path',
      'session_set_cookie_params',
      'session_set_save_handler',
      'session_start',
      'session_unregister',
      'session_unset',
      'session_write_close',
      'set_error_handler',
      'set_exception_handler',
      'set_file_buffer',
      'set_include_path',
      'set_magic_quotes_runtime',
      'set_socket_blocking',
      'set_time_limit',
      'setcookie',
      'setlocale',
      'setrawcookie',
      'settype',
      'sha1',
      'sha1_file',
      'shell_exec',
      'shm_attach',
      'shm_detach',
      'shm_get_var',
      'shm_put_var',
      'shm_remove',
      'shm_remove_var',
      'shmop_close',
      'shmop_delete',
      'shmop_open',
      'shmop_read',
      'shmop_size',
      'shmop_write',
      'show_source',
      'shuffle',
      'similar_text',
      'simplexml_load_file',
      'simplexml_load_string',
      'sin',
      'sinh',
      'sizeof',
      'sleep',
      'snmp3_get',
      'snmp3_getnext',
      'snmp3_real_walk',
      'snmp3_set',
      'snmp3_walk',
      'snmp_get_quick_print',
      'snmp_get_valueretrieval',
      'snmp_read_mib',
      'snmp_set_enum_print',
      'snmp_set_oid_numeric_print',
      'snmp_set_quick_print',
      'snmp_set_valueretrieval',
      'snmpget',
      'snmpgetnext',
      'snmprealwalk',
      'snmpset',
      'snmpwalk',
      'snmpwalkoid',
      'socket_accept',
      'socket_bind',
      'socket_clear_error',
      'socket_close',
      'socket_connect',
      'socket_create',
      'socket_create_listen',
      'socket_create_pair',
      'socket_get_option',
      'socket_get_status',
      'socket_getopt',
      'socket_getpeername',
      'socket_getsockname',
      'socket_iovec_add',
      'socket_iovec_alloc',
      'socket_iovec_delete',
      'socket_iovec_fetch',
      'socket_iovec_free',
      'socket_iovec_set',
      'socket_last_error',
      'socket_listen',
      'socket_read',
      'socket_readv',
      'socket_recv',
      'socket_recvfrom',
      'socket_recvmsg',
      'socket_select',
      'socket_send',
      'socket_sendmsg',
      'socket_sendto',
      'socket_set_block',
      'socket_set_blocking',
      'socket_set_nonblock',
      'socket_set_option',
      'socket_set_timeout',
      'socket_setopt',
      'socket_shutdown',
      'socket_strerror',
      'socket_write',
      'socket_writev',
      'sort',
      'soundex',
      'spl_classes',
      'split',
      'spliti',
      'sprintf',
      'sql_regcase',
      'sqlite_array_query',
      'sqlite_busy_timeout',
      'sqlite_changes',
      'sqlite_close',
      'sqlite_column',
      'sqlite_create_aggregate',
      'sqlite_create_function',
      'sqlite_current',
      'sqlite_error_string',
      'sqlite_escape_string',
      'sqlite_exec',
      'sqlite_factory',
      'sqlite_fetch_all',
      'sqlite_fetch_array',
      'sqlite_fetch_column_types',
      'sqlite_fetch_object',
      'sqlite_fetch_single',
      'sqlite_fetch_string',
      'sqlite_field_name',
      'sqlite_has_more',
      'sqlite_has_prev',
      'sqlite_last_error',
      'sqlite_last_insert_rowid',
      'sqlite_libencoding',
      'sqlite_libversion',
      'sqlite_next',
      'sqlite_num_fields',
      'sqlite_num_rows',
      'sqlite_open',
      'sqlite_popen',
      'sqlite_prev',
      'sqlite_query',
      'sqlite_rewind',
      'sqlite_seek',
      'sqlite_single_query',
      'sqlite_udf_decode_binary',
      'sqlite_udf_encode_binary',
      'sqlite_unbuffered_query',
      'sqlite_valid',
      'sqrt',
      'srand',
      'sscanf',
      'stat',
      'str_ireplace',
      'str_pad',
      'str_repeat',
      'str_replace',
      'str_rot13',
      'str_shuffle',
      'str_split',
      'str_word_count',
      'strcasecmp',
      'strchr',
      'strcmp',
      'strcoll',
      'strcspn',
      'stream_bucket_append',
      'stream_bucket_make_writeable',
      'stream_bucket_new',
      'stream_bucket_prepend',
      'stream_context_create',
      'stream_context_get_options',
      'stream_context_set_option',
      'stream_context_set_params',
      'stream_copy_to_stream',
      'stream_filter_append',
      'stream_filter_prepend',
      'stream_filter_register',
      'stream_get_contents',
      'stream_get_filters',
      'stream_get_line',
      'stream_get_meta_data',
      'stream_get_transports',
      'stream_get_wrappers',
      'stream_register_wrapper',
      'stream_select',
      'stream_set_blocking',
      'stream_set_timeout',
      'stream_set_write_buffer',
      'stream_socket_accept',
      'stream_socket_client',
      'stream_socket_get_name',
      'stream_socket_recvfrom',
      'stream_socket_sendto',
      'stream_socket_server',
      'stream_wrapper_register',
      'strftime',
      'strip_tags',
      'stripcslashes',
      'stripos',
      'stripslashes',
      'stristr',
      'strlen',
      'strnatcasecmp',
      'strnatcmp',
      'strncasecmp',
      'strncmp',
      'strpbrk',
      'strpos',
      'strrchr',
      'strrev',
      'strripos',
      'strrpos',
      'strspn',
      'strstr',
      'strtok',
      'strtolower',
      'strtotime',
      'strtoupper',
      'strtr',
      'strval',
      'substr',
      'substr_compare',
      'substr_count',
      'substr_replace',
      'swf_actiongeturl',
      'swf_actiongotoframe',
      'swf_actiongotolabel',
      'swf_actionnextframe',
      'swf_actionplay',
      'swf_actionprevframe',
      'swf_actionsettarget',
      'swf_actionstop',
      'swf_actiontogglequality',
      'swf_actionwaitforframe',
      'swf_addbuttonrecord',
      'swf_addcolor',
      'swf_closefile',
      'swf_definebitmap',
      'swf_definefont',
      'swf_defineline',
      'swf_definepoly',
      'swf_definerect',
      'swf_definetext',
      'swf_endbutton',
      'swf_enddoaction',
      'swf_endshape',
      'swf_endsymbol',
      'swf_fontsize',
      'swf_fontslant',
      'swf_fonttracking',
      'swf_getbitmapinfo',
      'swf_getfontinfo',
      'swf_getframe',
      'swf_labelframe',
      'swf_lookat',
      'swf_modifyobject',
      'swf_mulcolor',
      'swf_nextid',
      'swf_oncondition',
      'swf_openfile',
      'swf_ortho',
      'swf_ortho2',
      'swf_perspective',
      'swf_placeobject',
      'swf_polarview',
      'swf_popmatrix',
      'swf_posround',
      'swf_pushmatrix',
      'swf_removeobject',
      'swf_rotate',
      'swf_scale',
      'swf_setfont',
      'swf_setframe',
      'swf_shapearc',
      'swf_shapecurveto',
      'swf_shapecurveto3',
      'swf_shapefillbitmapclip',
      'swf_shapefillbitmaptile',
      'swf_shapefilloff',
      'swf_shapefillsolid',
      'swf_shapelinesolid',
      'swf_shapelineto',
      'swf_shapemoveto',
      'swf_showframe',
      'swf_startbutton',
      'swf_startdoaction',
      'swf_startshape',
      'swf_startsymbol',
      'swf_textwidth',
      'swf_translate',
      'swf_viewport',
      'swfaction',
      'swfbitmap',
      'swfbitmap.getheight',
      'swfbitmap.getwidth',
      'swfbutton',
      'swfbutton.addaction',
      'swfbutton.addshape',
      'swfbutton.setaction',
      'swfbutton.setdown',
      'swfbutton.sethit',
      'swfbutton.setover',
      'swfbutton.setup',
      'swfbutton_keypress',
      'swfdisplayitem',
      'swfdisplayitem.addcolor',
      'swfdisplayitem.move',
      'swfdisplayitem.moveto',
      'swfdisplayitem.multcolor',
      'swfdisplayitem.remove',
      'swfdisplayitem.rotate',
      'swfdisplayitem.rotateto',
      'swfdisplayitem.scale',
      'swfdisplayitem.scaleto',
      'swfdisplayitem.setdepth',
      'swfdisplayitem.setname',
      'swfdisplayitem.setratio',
      'swfdisplayitem.skewx',
      'swfdisplayitem.skewxto',
      'swfdisplayitem.skewy',
      'swfdisplayitem.skewyto',
      'swffill',
      'swffill.moveto',
      'swffill.rotateto',
      'swffill.scaleto',
      'swffill.skewxto',
      'swffill.skewyto',
      'swffont',
      'swffont.getwidth',
      'swfgradient',
      'swfgradient.addentry',
      'swfmorph',
      'swfmorph.getshape1',
      'swfmorph.getshape2',
      'swfmovie',
      'swfmovie.add',
      'swfmovie.nextframe',
      'swfmovie.output',
      'swfmovie.remove',
      'swfmovie.save',
      'swfmovie.setbackground',
      'swfmovie.setdimension',
      'swfmovie.setframes',
      'swfmovie.setrate',
      'swfmovie.streammp3',
      'swfshape',
      'swfshape.addfill',
      'swfshape.drawcurve',
      'swfshape.drawcurveto',
      'swfshape.drawline',
      'swfshape.drawlineto',
      'swfshape.movepen',
      'swfshape.movepento',
      'swfshape.setleftfill',
      'swfshape.setline',
      'swfshape.setrightfill',
      'swfsprite',
      'swfsprite.add',
      'swfsprite.nextframe',
      'swfsprite.remove',
      'swfsprite.setframes',
      'swftext',
      'swftext.addstring',
      'swftext.getwidth',
      'swftext.moveto',
      'swftext.setcolor',
      'swftext.setfont',
      'swftext.setheight',
      'swftext.setspacing',
      'swftextfield',
      'swftextfield.addstring',
      'swftextfield.align',
      'swftextfield.setbounds',
      'swftextfield.setcolor',
      'swftextfield.setfont',
      'swftextfield.setheight',
      'swftextfield.setindentation',
      'swftextfield.setleftmargin',
      'swftextfield.setlinespacing',
      'swftextfield.setmargins',
      'swftextfield.setname',
      'swftextfield.setrightmargin',
      'sybase_affected_rows',
      'sybase_close',
      'sybase_connect',
      'sybase_data_seek',
      'sybase_fetch_array',
      'sybase_fetch_field',
      'sybase_fetch_object',
      'sybase_fetch_row',
      'sybase_field_seek',
      'sybase_free_result',
      'sybase_get_last_message',
      'sybase_min_client_severity',
      'sybase_min_error_severity',
      'sybase_min_message_severity',
      'sybase_min_server_severity',
      'sybase_num_fields',
      'sybase_num_rows',
      'sybase_pconnect',
      'sybase_query',
      'sybase_result',
      'sybase_select_db',
      'symlink',
      'syslog',
      'system',
      'tan',
      'tanh',
      'tempnam',
      'textdomain',
      'time',
      'time_nanosleep',
      'tmpfile',
      'token_get_all',
      'token_name',
      'touch',
      'trigger_error',
      'trim',
      'uasort',
      'ucfirst',
      'ucwords',
      'udm_add_search_limit',
      'udm_alloc_agent',
      'udm_api_version',
      'udm_cat_list',
      'udm_cat_path',
      'udm_check_charset',
      'udm_check_stored',
      'udm_clear_search_limits',
      'udm_close_stored',
      'udm_crc32',
      'udm_errno',
      'udm_error',
      'udm_find',
      'udm_free_agent',
      'udm_free_ispell_data',
      'udm_free_res',
      'udm_get_doc_count',
      'udm_get_res_field',
      'udm_get_res_param',
      'udm_load_ispell_data',
      'udm_open_stored',
      'udm_set_agent_param',
      'uksort',
      'umask',
      'uniqid',
      'unixtojd',
      'unlink',
      'unpack',
      'unregister_tick_function',
      'unserialize',
      'unset',
      'urldecode',
      'urlencode',
      'use_soap_error_handler',
      'user_error',
      'usleep',
      'usort',
      'utf8_decode',
      'utf8_encode',
      'var_dump',
      'var_export',
      'variant',
      'version_compare',
      'vfprintf',
      'virtual',
      'vpopmail_add_alias_domain',
      'vpopmail_add_alias_domain_ex',
      'vpopmail_add_domain',
      'vpopmail_add_domain_ex',
      'vpopmail_add_user',
      'vpopmail_alias_add',
      'vpopmail_alias_del',
      'vpopmail_alias_del_domain',
      'vpopmail_alias_get',
      'vpopmail_alias_get_all',
      'vpopmail_auth_user',
      'vpopmail_del_domain',
      'vpopmail_del_domain_ex',
      'vpopmail_del_user',
      'vpopmail_error',
      'vpopmail_passwd',
      'vpopmail_set_user_quota',
      'vprintf',
      'vsprintf',
      'w32api_deftype',
      'w32api_init_dtype',
      'w32api_invoke_function',
      'w32api_register_function',
      'w32api_set_call_method',
      'wddx_add_vars',
      'wddx_deserialize',
      'wddx_packet_end',
      'wddx_packet_start',
      'wddx_serialize_value',
      'wddx_serialize_vars',
      'wordwrap',
      'xml_error_string',
      'xml_get_current_byte_index',
      'xml_get_current_column_number',
      'xml_get_current_line_number',
      'xml_get_error_code',
      'xml_parse',
      'xml_parse_into_struct',
      'xml_parser_create',
      'xml_parser_create_ns',
      'xml_parser_free',
      'xml_parser_get_option',
      'xml_parser_set_option',
      'xml_set_character_data_handler',
      'xml_set_default_handler',
      'xml_set_element_handler',
      'xml_set_end_namespace_decl_handler',
      'xml_set_external_entity_ref_handler',
      'xml_set_notation_decl_handler',
      'xml_set_object',
      'xml_set_processing_instruction_handler',
      'xml_set_start_namespace_decl_handler',
      'xml_set_unparsed_entity_decl_handler',
      'xmldoc',
      'xmldocfile',
      'xmlrpc_decode',
      'xmlrpc_decode_request',
      'xmlrpc_encode',
      'xmlrpc_encode_request',
      'xmlrpc_get_type',
      'xmlrpc_is_fault',
      'xmlrpc_parse_method_descriptions',
      'xmlrpc_server_add_introspection_data',
      'xmlrpc_server_call_method',
      'xmlrpc_server_create',
      'xmlrpc_server_destroy',
      'xmlrpc_server_register_introspection_callback',
      'xmlrpc_server_register_method',
      'xmlrpc_set_type',
      'xmltree',
      'xpath_eval',
      'xpath_eval_expression',
      'xpath_new_context',
      'xptr_eval',
      'xptr_new_context',
      'xslt_create',
      'xslt_errno',
      'xslt_error',
      'xslt_free',
      'xslt_process',
      'xslt_set_base',
      'xslt_set_encoding',
      'xslt_set_error_handler',
      'xslt_set_log',
      'xslt_set_sax_handler',
      'xslt_set_sax_handlers',
      'xslt_set_scheme_handler',
      'xslt_set_scheme_handlers',
      'yaz_addinfo',
      'yaz_ccl_conf',
      'yaz_ccl_parse',
      'yaz_close',
      'yaz_connect',
      'yaz_database',
      'yaz_element',
      'yaz_errno',
      'yaz_error',
      'yaz_hits',
      'yaz_itemorder',
      'yaz_present',
      'yaz_range',
      'yaz_record',
      'yaz_scan',
      'yaz_scan_result',
      'yaz_search',
      'yaz_sort',
      'yaz_syntax',
      'yaz_wait',
      'yp_all',
      'yp_cat',
      'yp_err_string',
      'yp_errno',
      'yp_first',
      'yp_get_default_domain',
      'yp_master',
      'yp_match',
      'yp_next',
      'yp_order',
      'zend_logo_guid',
      'zend_version',
      'zip_close',
      'zip_entry_close',
      'zip_entry_compressedsize',
      'zip_entry_compressionmethod',
      'zip_entry_filesize',
      'zip_entry_name',
      'zip_entry_open',
      'zip_entry_read',
      'zip_open',
      'zip_read',
      'zlib_get_coding_type',
   );
   $self->listAdd('keywords',
      'ABDAY_1',
      'ABDAY_1',
      'ABDAY_2',
      'ABDAY_2',
      'ABDAY_3',
      'ABDAY_3',
      'ABDAY_4',
      'ABDAY_4',
      'ABDAY_5',
      'ABDAY_5',
      'ABDAY_6',
      'ABDAY_6',
      'ABDAY_7',
      'ABDAY_7',
      'ABMON_1',
      'ABMON_1',
      'ABMON_10',
      'ABMON_10',
      'ABMON_11',
      'ABMON_11',
      'ABMON_12',
      'ABMON_12',
      'ABMON_2',
      'ABMON_2',
      'ABMON_3',
      'ABMON_3',
      'ABMON_4',
      'ABMON_4',
      'ABMON_5',
      'ABMON_5',
      'ABMON_6',
      'ABMON_6',
      'ABMON_7',
      'ABMON_7',
      'ABMON_8',
      'ABMON_8',
      'ABMON_9',
      'ABMON_9',
      'AF_INET',
      'AF_INET',
      'AF_INET6',
      'AF_INET6',
      'AF_UNIX',
      'AF_UNIX',
      'ALT_DIGITS',
      'ALT_DIGITS',
      'AM_STR',
      'AM_STR',
      'ASSERT_ACTIVE',
      'ASSERT_ACTIVE',
      'ASSERT_BAIL',
      'ASSERT_BAIL',
      'ASSERT_CALLBACK',
      'ASSERT_CALLBACK',
      'ASSERT_QUIET_EVAL',
      'ASSERT_QUIET_EVAL',
      'ASSERT_WARNING',
      'ASSERT_WARNING',
      'CAL_DOW_DAYNO',
      'CAL_DOW_DAYNO',
      'CAL_DOW_LONG',
      'CAL_DOW_LONG',
      'CAL_DOW_SHORT',
      'CAL_DOW_SHORT',
      'CAL_EASTER_ALWAYS_GREGORIAN',
      'CAL_EASTER_ALWAYS_GREGORIAN',
      'CAL_EASTER_ALWAYS_JULIAN',
      'CAL_EASTER_ALWAYS_JULIAN',
      'CAL_EASTER_DEFAULT',
      'CAL_EASTER_DEFAULT',
      'CAL_EASTER_ROMAN',
      'CAL_EASTER_ROMAN',
      'CAL_FRENCH',
      'CAL_FRENCH',
      'CAL_GREGORIAN',
      'CAL_GREGORIAN',
      'CAL_JEWISH',
      'CAL_JEWISH',
      'CAL_JEWISH_ADD_ALAFIM',
      'CAL_JEWISH_ADD_ALAFIM',
      'CAL_JEWISH_ADD_ALAFIM_GERESH',
      'CAL_JEWISH_ADD_ALAFIM_GERESH',
      'CAL_JEWISH_ADD_GERESHAYIM',
      'CAL_JEWISH_ADD_GERESHAYIM',
      'CAL_JULIAN',
      'CAL_JULIAN',
      'CAL_MONTH_FRENCH',
      'CAL_MONTH_FRENCH',
      'CAL_MONTH_GREGORIAN_LONG',
      'CAL_MONTH_GREGORIAN_LONG',
      'CAL_MONTH_GREGORIAN_SHORT',
      'CAL_MONTH_GREGORIAN_SHORT',
      'CAL_MONTH_JEWISH',
      'CAL_MONTH_JEWISH',
      'CAL_MONTH_JULIAN_LONG',
      'CAL_MONTH_JULIAN_LONG',
      'CAL_MONTH_JULIAN_SHORT',
      'CAL_MONTH_JULIAN_SHORT',
      'CAL_NUM_CALS',
      'CAL_NUM_CALS',
      'CASE_LOWER',
      'CASE_LOWER',
      'CASE_UPPER',
      'CASE_UPPER',
      'CHAR_MAX',
      'CHAR_MAX',
      'CIT_CALL_TOSTRING',
      'CIT_CALL_TOSTRING',
      'CIT_CATCH_GET_CHILD',
      'CIT_CATCH_GET_CHILD',
      'CL_EXPUNGE',
      'CL_EXPUNGE',
      'CODESET',
      'CODESET',
      'CONNECTION_ABORTED',
      'CONNECTION_ABORTED',
      'CONNECTION_NORMAL',
      'CONNECTION_NORMAL',
      'CONNECTION_TIMEOUT',
      'CONNECTION_TIMEOUT',
      'COUNT_NORMAL',
      'COUNT_NORMAL',
      'COUNT_RECURSIVE',
      'COUNT_RECURSIVE',
      'CP_MOVE',
      'CP_MOVE',
      'CP_UID',
      'CP_UID',
      'CREDITS_ALL',
      'CREDITS_ALL',
      'CREDITS_DOCS',
      'CREDITS_DOCS',
      'CREDITS_FULLPAGE',
      'CREDITS_FULLPAGE',
      'CREDITS_GENERAL',
      'CREDITS_GENERAL',
      'CREDITS_GROUP',
      'CREDITS_GROUP',
      'CREDITS_MODULES',
      'CREDITS_MODULES',
      'CREDITS_QA',
      'CREDITS_QA',
      'CREDITS_SAPI',
      'CREDITS_SAPI',
      'CRNCYSTR',
      'CRNCYSTR',
      'CRYPT_BLOWFISH',
      'CRYPT_BLOWFISH',
      'CRYPT_EXT_DES',
      'CRYPT_EXT_DES',
      'CRYPT_MD5',
      'CRYPT_MD5',
      'CRYPT_SALT_LENGTH',
      'CRYPT_SALT_LENGTH',
      'CRYPT_STD_DES',
      'CRYPT_STD_DES',
      'CURLAUTH_ANY',
      'CURLAUTH_ANY',
      'CURLAUTH_ANYSAFE',
      'CURLAUTH_ANYSAFE',
      'CURLAUTH_BASIC',
      'CURLAUTH_BASIC',
      'CURLAUTH_DIGEST',
      'CURLAUTH_DIGEST',
      'CURLAUTH_GSSNEGOTIATE',
      'CURLAUTH_GSSNEGOTIATE',
      'CURLAUTH_NTLM',
      'CURLAUTH_NTLM',
      'CURLCLOSEPOLICY_CALLBACK',
      'CURLCLOSEPOLICY_CALLBACK',
      'CURLCLOSEPOLICY_LEAST_RECENTLY_USED',
      'CURLCLOSEPOLICY_LEAST_RECENTLY_USED',
      'CURLCLOSEPOLICY_LEAST_TRAFFIC',
      'CURLCLOSEPOLICY_LEAST_TRAFFIC',
      'CURLCLOSEPOLICY_OLDEST',
      'CURLCLOSEPOLICY_OLDEST',
      'CURLCLOSEPOLICY_SLOWEST',
      'CURLCLOSEPOLICY_SLOWEST',
      'CURLE_ABORTED_BY_CALLBACK',
      'CURLE_ABORTED_BY_CALLBACK',
      'CURLE_BAD_CALLING_ORDER',
      'CURLE_BAD_CALLING_ORDER',
      'CURLE_BAD_CONTENT_ENCODING',
      'CURLE_BAD_CONTENT_ENCODING',
      'CURLE_BAD_FUNCTION_ARGUMENT',
      'CURLE_BAD_FUNCTION_ARGUMENT',
      'CURLE_BAD_PASSWORD_ENTERED',
      'CURLE_BAD_PASSWORD_ENTERED',
      'CURLE_COULDNT_CONNECT',
      'CURLE_COULDNT_CONNECT',
      'CURLE_COULDNT_RESOLVE_HOST',
      'CURLE_COULDNT_RESOLVE_HOST',
      'CURLE_COULDNT_RESOLVE_PROXY',
      'CURLE_COULDNT_RESOLVE_PROXY',
      'CURLE_FAILED_INIT',
      'CURLE_FAILED_INIT',
      'CURLE_FILE_COULDNT_READ_FILE',
      'CURLE_FILE_COULDNT_READ_FILE',
      'CURLE_FTP_ACCESS_DENIED',
      'CURLE_FTP_ACCESS_DENIED',
      'CURLE_FTP_BAD_DOWNLOAD_RESUME',
      'CURLE_FTP_BAD_DOWNLOAD_RESUME',
      'CURLE_FTP_CANT_GET_HOST',
      'CURLE_FTP_CANT_GET_HOST',
      'CURLE_FTP_CANT_RECONNECT',
      'CURLE_FTP_CANT_RECONNECT',
      'CURLE_FTP_COULDNT_GET_SIZE',
      'CURLE_FTP_COULDNT_GET_SIZE',
      'CURLE_FTP_COULDNT_RETR_FILE',
      'CURLE_FTP_COULDNT_RETR_FILE',
      'CURLE_FTP_COULDNT_SET_ASCII',
      'CURLE_FTP_COULDNT_SET_ASCII',
      'CURLE_FTP_COULDNT_SET_BINARY',
      'CURLE_FTP_COULDNT_SET_BINARY',
      'CURLE_FTP_COULDNT_STOR_FILE',
      'CURLE_FTP_COULDNT_STOR_FILE',
      'CURLE_FTP_COULDNT_USE_REST',
      'CURLE_FTP_COULDNT_USE_REST',
      'CURLE_FTP_PORT_FAILED',
      'CURLE_FTP_PORT_FAILED',
      'CURLE_FTP_QUOTE_ERROR',
      'CURLE_FTP_QUOTE_ERROR',
      'CURLE_FTP_USER_PASSWORD_INCORRECT',
      'CURLE_FTP_USER_PASSWORD_INCORRECT',
      'CURLE_FTP_WEIRD_227_FORMAT',
      'CURLE_FTP_WEIRD_227_FORMAT',
      'CURLE_FTP_WEIRD_PASS_REPLY',
      'CURLE_FTP_WEIRD_PASS_REPLY',
      'CURLE_FTP_WEIRD_PASV_REPLY',
      'CURLE_FTP_WEIRD_PASV_REPLY',
      'CURLE_FTP_WEIRD_SERVER_REPLY',
      'CURLE_FTP_WEIRD_SERVER_REPLY',
      'CURLE_FTP_WEIRD_USER_REPLY',
      'CURLE_FTP_WEIRD_USER_REPLY',
      'CURLE_FTP_WRITE_ERROR',
      'CURLE_FTP_WRITE_ERROR',
      'CURLE_FUNCTION_NOT_FOUND',
      'CURLE_FUNCTION_NOT_FOUND',
      'CURLE_GOT_NOTHING',
      'CURLE_GOT_NOTHING',
      'CURLE_HTTP_NOT_FOUND',
      'CURLE_HTTP_NOT_FOUND',
      'CURLE_HTTP_PORT_FAILED',
      'CURLE_HTTP_PORT_FAILED',
      'CURLE_HTTP_POST_ERROR',
      'CURLE_HTTP_POST_ERROR',
      'CURLE_HTTP_RANGE_ERROR',
      'CURLE_HTTP_RANGE_ERROR',
      'CURLE_LDAP_CANNOT_BIND',
      'CURLE_LDAP_CANNOT_BIND',
      'CURLE_LDAP_SEARCH_FAILED',
      'CURLE_LDAP_SEARCH_FAILED',
      'CURLE_LIBRARY_NOT_FOUND',
      'CURLE_LIBRARY_NOT_FOUND',
      'CURLE_MALFORMAT_USER',
      'CURLE_MALFORMAT_USER',
      'CURLE_OBSOLETE',
      'CURLE_OBSOLETE',
      'CURLE_OK',
      'CURLE_OK',
      'CURLE_OPERATION_TIMEOUTED',
      'CURLE_OPERATION_TIMEOUTED',
      'CURLE_OUT_OF_MEMORY',
      'CURLE_OUT_OF_MEMORY',
      'CURLE_PARTIAL_FILE',
      'CURLE_PARTIAL_FILE',
      'CURLE_READ_ERROR',
      'CURLE_READ_ERROR',
      'CURLE_RECV_ERROR',
      'CURLE_RECV_ERROR',
      'CURLE_SEND_ERROR',
      'CURLE_SEND_ERROR',
      'CURLE_SHARE_IN_USE',
      'CURLE_SHARE_IN_USE',
      'CURLE_SSL_CACERT',
      'CURLE_SSL_CACERT',
      'CURLE_SSL_CERTPROBLEM',
      'CURLE_SSL_CERTPROBLEM',
      'CURLE_SSL_CIPHER',
      'CURLE_SSL_CIPHER',
      'CURLE_SSL_CONNECT_ERROR',
      'CURLE_SSL_CONNECT_ERROR',
      'CURLE_SSL_ENGINE_NOTFOUND',
      'CURLE_SSL_ENGINE_NOTFOUND',
      'CURLE_SSL_ENGINE_SETFAILED',
      'CURLE_SSL_ENGINE_SETFAILED',
      'CURLE_SSL_PEER_CERTIFICATE',
      'CURLE_SSL_PEER_CERTIFICATE',
      'CURLE_TELNET_OPTION_SYNTAX',
      'CURLE_TELNET_OPTION_SYNTAX',
      'CURLE_TOO_MANY_REDIRECTS',
      'CURLE_TOO_MANY_REDIRECTS',
      'CURLE_UNKNOWN_TELNET_OPTION',
      'CURLE_UNKNOWN_TELNET_OPTION',
      'CURLE_UNSUPPORTED_PROTOCOL',
      'CURLE_UNSUPPORTED_PROTOCOL',
      'CURLE_URL_MALFORMAT',
      'CURLE_URL_MALFORMAT',
      'CURLE_URL_MALFORMAT_USER',
      'CURLE_URL_MALFORMAT_USER',
      'CURLE_WRITE_ERROR',
      'CURLE_WRITE_ERROR',
      'CURLINFO_CONNECT_TIME',
      'CURLINFO_CONNECT_TIME',
      'CURLINFO_CONTENT_LENGTH_DOWNLOAD',
      'CURLINFO_CONTENT_LENGTH_DOWNLOAD',
      'CURLINFO_CONTENT_LENGTH_UPLOAD',
      'CURLINFO_CONTENT_LENGTH_UPLOAD',
      'CURLINFO_CONTENT_TYPE',
      'CURLINFO_CONTENT_TYPE',
      'CURLINFO_EFFECTIVE_URL',
      'CURLINFO_EFFECTIVE_URL',
      'CURLINFO_FILETIME',
      'CURLINFO_FILETIME',
      'CURLINFO_HEADER_SIZE',
      'CURLINFO_HEADER_SIZE',
      'CURLINFO_HTTP_CODE',
      'CURLINFO_HTTP_CODE',
      'CURLINFO_NAMELOOKUP_TIME',
      'CURLINFO_NAMELOOKUP_TIME',
      'CURLINFO_PRETRANSFER_TIME',
      'CURLINFO_PRETRANSFER_TIME',
      'CURLINFO_REDIRECT_COUNT',
      'CURLINFO_REDIRECT_COUNT',
      'CURLINFO_REDIRECT_TIME',
      'CURLINFO_REDIRECT_TIME',
      'CURLINFO_REQUEST_SIZE',
      'CURLINFO_REQUEST_SIZE',
      'CURLINFO_SIZE_DOWNLOAD',
      'CURLINFO_SIZE_DOWNLOAD',
      'CURLINFO_SIZE_UPLOAD',
      'CURLINFO_SIZE_UPLOAD',
      'CURLINFO_SPEED_DOWNLOAD',
      'CURLINFO_SPEED_DOWNLOAD',
      'CURLINFO_SPEED_UPLOAD',
      'CURLINFO_SPEED_UPLOAD',
      'CURLINFO_SSL_VERIFYRESULT',
      'CURLINFO_SSL_VERIFYRESULT',
      'CURLINFO_STARTTRANSFER_TIME',
      'CURLINFO_STARTTRANSFER_TIME',
      'CURLINFO_TOTAL_TIME',
      'CURLINFO_TOTAL_TIME',
      'CURLMSG_DONE',
      'CURLMSG_DONE',
      'CURLM_BAD_EASY_HANDLE',
      'CURLM_BAD_EASY_HANDLE',
      'CURLM_BAD_HANDLE',
      'CURLM_BAD_HANDLE',
      'CURLM_CALL_MULTI_PERFORM',
      'CURLM_CALL_MULTI_PERFORM',
      'CURLM_INTERNAL_ERROR',
      'CURLM_INTERNAL_ERROR',
      'CURLM_OK',
      'CURLM_OK',
      'CURLM_OUT_OF_MEMORY',
      'CURLM_OUT_OF_MEMORY',
      'CURLOPT_BINARYTRANSFER',
      'CURLOPT_BINARYTRANSFER',
      'CURLOPT_BUFFERSIZE',
      'CURLOPT_BUFFERSIZE',
      'CURLOPT_CAINFO',
      'CURLOPT_CAINFO',
      'CURLOPT_CAPATH',
      'CURLOPT_CAPATH',
      'CURLOPT_CLOSEPOLICY',
      'CURLOPT_CLOSEPOLICY',
      'CURLOPT_CONNECTTIMEOUT',
      'CURLOPT_CONNECTTIMEOUT',
      'CURLOPT_COOKIE',
      'CURLOPT_COOKIE',
      'CURLOPT_COOKIEFILE',
      'CURLOPT_COOKIEFILE',
      'CURLOPT_COOKIEJAR',
      'CURLOPT_COOKIEJAR',
      'CURLOPT_CRLF',
      'CURLOPT_CRLF',
      'CURLOPT_CUSTOMREQUEST',
      'CURLOPT_CUSTOMREQUEST',
      'CURLOPT_DNS_CACHE_TIMEOUT',
      'CURLOPT_DNS_CACHE_TIMEOUT',
      'CURLOPT_DNS_USE_GLOBAL_CACHE',
      'CURLOPT_DNS_USE_GLOBAL_CACHE',
      'CURLOPT_EGDSOCKET',
      'CURLOPT_EGDSOCKET',
      'CURLOPT_ENCODING',
      'CURLOPT_ENCODING',
      'CURLOPT_FAILONERROR',
      'CURLOPT_FAILONERROR',
      'CURLOPT_FILE',
      'CURLOPT_FILE',
      'CURLOPT_FILETIME',
      'CURLOPT_FILETIME',
      'CURLOPT_FOLLOWLOCATION',
      'CURLOPT_FOLLOWLOCATION',
      'CURLOPT_FORBID_REUSE',
      'CURLOPT_FORBID_REUSE',
      'CURLOPT_FRESH_CONNECT',
      'CURLOPT_FRESH_CONNECT',
      'CURLOPT_FTPAPPEND',
      'CURLOPT_FTPAPPEND',
      'CURLOPT_FTPASCII',
      'CURLOPT_FTPASCII',
      'CURLOPT_FTPLISTONLY',
      'CURLOPT_FTPLISTONLY',
      'CURLOPT_FTPPORT',
      'CURLOPT_FTPPORT',
      'CURLOPT_FTP_USE_EPRT',
      'CURLOPT_FTP_USE_EPRT',
      'CURLOPT_FTP_USE_EPSV',
      'CURLOPT_FTP_USE_EPSV',
      'CURLOPT_HEADER',
      'CURLOPT_HEADER',
      'CURLOPT_HEADERFUNCTION',
      'CURLOPT_HEADERFUNCTION',
      'CURLOPT_HTTP200ALIASES',
      'CURLOPT_HTTP200ALIASES',
      'CURLOPT_HTTPAUTH',
      'CURLOPT_HTTPAUTH',
      'CURLOPT_HTTPGET',
      'CURLOPT_HTTPGET',
      'CURLOPT_HTTPHEADER',
      'CURLOPT_HTTPHEADER',
      'CURLOPT_HTTPPROXYTUNNEL',
      'CURLOPT_HTTPPROXYTUNNEL',
      'CURLOPT_HTTP_VERSION',
      'CURLOPT_HTTP_VERSION',
      'CURLOPT_INFILE',
      'CURLOPT_INFILE',
      'CURLOPT_INFILESIZE',
      'CURLOPT_INFILESIZE',
      'CURLOPT_INTERFACE',
      'CURLOPT_INTERFACE',
      'CURLOPT_KRB4LEVEL',
      'CURLOPT_KRB4LEVEL',
      'CURLOPT_LOW_SPEED_LIMIT',
      'CURLOPT_LOW_SPEED_LIMIT',
      'CURLOPT_LOW_SPEED_TIME',
      'CURLOPT_LOW_SPEED_TIME',
      'CURLOPT_MAXCONNECTS',
      'CURLOPT_MAXCONNECTS',
      'CURLOPT_MAXREDIRS',
      'CURLOPT_MAXREDIRS',
      'CURLOPT_MUTE',
      'CURLOPT_MUTE',
      'CURLOPT_NETRC',
      'CURLOPT_NETRC',
      'CURLOPT_NOBODY',
      'CURLOPT_NOBODY',
      'CURLOPT_NOPROGRESS',
      'CURLOPT_NOPROGRESS',
      'CURLOPT_NOSIGNAL',
      'CURLOPT_NOSIGNAL',
      'CURLOPT_PASSWDFUNCTION',
      'CURLOPT_PASSWDFUNCTION',
      'CURLOPT_PORT',
      'CURLOPT_PORT',
      'CURLOPT_POST',
      'CURLOPT_POST',
      'CURLOPT_POSTFIELDS',
      'CURLOPT_POSTFIELDS',
      'CURLOPT_POSTQUOTE',
      'CURLOPT_POSTQUOTE',
      'CURLOPT_PROXY',
      'CURLOPT_PROXY',
      'CURLOPT_PROXYAUTH',
      'CURLOPT_PROXYAUTH',
      'CURLOPT_PROXYPORT',
      'CURLOPT_PROXYPORT',
      'CURLOPT_PROXYTYPE',
      'CURLOPT_PROXYTYPE',
      'CURLOPT_PROXYUSERPWD',
      'CURLOPT_PROXYUSERPWD',
      'CURLOPT_PUT',
      'CURLOPT_PUT',
      'CURLOPT_QUOTE',
      'CURLOPT_QUOTE',
      'CURLOPT_RANDOM_FILE',
      'CURLOPT_RANDOM_FILE',
      'CURLOPT_RANGE',
      'CURLOPT_RANGE',
      'CURLOPT_READDATA',
      'CURLOPT_READDATA',
      'CURLOPT_READFUNCTION',
      'CURLOPT_READFUNCTION',
      'CURLOPT_REFERER',
      'CURLOPT_REFERER',
      'CURLOPT_RESUME_FROM',
      'CURLOPT_RESUME_FROM',
      'CURLOPT_RETURNTRANSFER',
      'CURLOPT_RETURNTRANSFER',
      'CURLOPT_SSLCERT',
      'CURLOPT_SSLCERT',
      'CURLOPT_SSLCERTPASSWD',
      'CURLOPT_SSLCERTPASSWD',
      'CURLOPT_SSLCERTTYPE',
      'CURLOPT_SSLCERTTYPE',
      'CURLOPT_SSLENGINE',
      'CURLOPT_SSLENGINE',
      'CURLOPT_SSLENGINE_DEFAULT',
      'CURLOPT_SSLENGINE_DEFAULT',
      'CURLOPT_SSLKEY',
      'CURLOPT_SSLKEY',
      'CURLOPT_SSLKEYPASSWD',
      'CURLOPT_SSLKEYPASSWD',
      'CURLOPT_SSLKEYTYPE',
      'CURLOPT_SSLKEYTYPE',
      'CURLOPT_SSLVERSION',
      'CURLOPT_SSLVERSION',
      'CURLOPT_SSL_CIPHER_LIST',
      'CURLOPT_SSL_CIPHER_LIST',
      'CURLOPT_SSL_VERIFYHOST',
      'CURLOPT_SSL_VERIFYHOST',
      'CURLOPT_SSL_VERIFYPEER',
      'CURLOPT_SSL_VERIFYPEER',
      'CURLOPT_STDERR',
      'CURLOPT_STDERR',
      'CURLOPT_TIMECONDITION',
      'CURLOPT_TIMECONDITION',
      'CURLOPT_TIMEOUT',
      'CURLOPT_TIMEOUT',
      'CURLOPT_TIMEVALUE',
      'CURLOPT_TIMEVALUE',
      'CURLOPT_TRANSFERTEXT',
      'CURLOPT_TRANSFERTEXT',
      'CURLOPT_UNRESTRICTED_AUTH',
      'CURLOPT_UNRESTRICTED_AUTH',
      'CURLOPT_UPLOAD',
      'CURLOPT_UPLOAD',
      'CURLOPT_URL',
      'CURLOPT_URL',
      'CURLOPT_USERAGENT',
      'CURLOPT_USERAGENT',
      'CURLOPT_USERPWD',
      'CURLOPT_USERPWD',
      'CURLOPT_VERBOSE',
      'CURLOPT_VERBOSE',
      'CURLOPT_WRITEFUNCTION',
      'CURLOPT_WRITEFUNCTION',
      'CURLOPT_WRITEHEADER',
      'CURLOPT_WRITEHEADER',
      'CURLPROXY_HTTP',
      'CURLPROXY_HTTP',
      'CURLPROXY_SOCKS5',
      'CURLPROXY_SOCKS5',
      'CURLVERSION_NOW',
      'CURLVERSION_NOW',
      'CURL_HTTP_VERSION_1_0',
      'CURL_HTTP_VERSION_1_0',
      'CURL_HTTP_VERSION_1_1',
      'CURL_HTTP_VERSION_1_1',
      'CURL_HTTP_VERSION_NONE',
      'CURL_HTTP_VERSION_NONE',
      'CURL_NETRC_IGNORED',
      'CURL_NETRC_IGNORED',
      'CURL_NETRC_OPTIONAL',
      'CURL_NETRC_OPTIONAL',
      'CURL_NETRC_REQUIRED',
      'CURL_NETRC_REQUIRED',
      'CURL_TIMECOND_IFMODSINCE',
      'CURL_TIMECOND_IFMODSINCE',
      'CURL_TIMECOND_IFUNMODSINCE',
      'CURL_TIMECOND_IFUNMODSINCE',
      'CURL_TIMECOND_LASTMOD',
      'CURL_TIMECOND_LASTMOD',
      'CURL_VERSION_IPV6',
      'CURL_VERSION_IPV6',
      'CURL_VERSION_KERBEROS4',
      'CURL_VERSION_KERBEROS4',
      'CURL_VERSION_LIBZ',
      'CURL_VERSION_LIBZ',
      'CURL_VERSION_SSL',
      'CURL_VERSION_SSL',
      'C_EXPLICIT_ABSTRACT',
      'C_EXPLICIT_ABSTRACT',
      'C_FINAL',
      'C_FINAL',
      'C_IMPLICIT_ABSTRACT',
      'C_IMPLICIT_ABSTRACT',
      'DAY_1',
      'DAY_1',
      'DAY_2',
      'DAY_2',
      'DAY_3',
      'DAY_3',
      'DAY_4',
      'DAY_4',
      'DAY_5',
      'DAY_5',
      'DAY_6',
      'DAY_6',
      'DAY_7',
      'DAY_7',
      'DBX_CMP_ASC',
      'DBX_CMP_ASC',
      'DBX_CMP_DESC',
      'DBX_CMP_DESC',
      'DBX_CMP_NATIVE',
      'DBX_CMP_NATIVE',
      'DBX_CMP_NUMBER',
      'DBX_CMP_NUMBER',
      'DBX_CMP_TEXT',
      'DBX_CMP_TEXT',
      'DBX_COLNAMES_LOWERCASE',
      'DBX_COLNAMES_LOWERCASE',
      'DBX_COLNAMES_UNCHANGED',
      'DBX_COLNAMES_UNCHANGED',
      'DBX_COLNAMES_UPPERCASE',
      'DBX_COLNAMES_UPPERCASE',
      'DBX_FBSQL',
      'DBX_FBSQL',
      'DBX_MSSQL',
      'DBX_MSSQL',
      'DBX_MYSQL',
      'DBX_MYSQL',
      'DBX_OCI8',
      'DBX_OCI8',
      'DBX_ODBC',
      'DBX_ODBC',
      'DBX_PERSISTENT',
      'DBX_PERSISTENT',
      'DBX_PGSQL',
      'DBX_PGSQL',
      'DBX_RESULT_ASSOC',
      'DBX_RESULT_ASSOC',
      'DBX_RESULT_INDEX',
      'DBX_RESULT_INDEX',
      'DBX_RESULT_INFO',
      'DBX_RESULT_INFO',
      'DBX_RESULT_UNBUFFERED',
      'DBX_RESULT_UNBUFFERED',
      'DBX_SQLITE',
      'DBX_SQLITE',
      'DBX_SYBASECT',
      'DBX_SYBASECT',
      'DEFAULT_INCLUDE_PATH',
      'DEFAULT_INCLUDE_PATH',
      'DIRECTORY_SEPARATOR',
      'DIRECTORY_SEPARATOR',
      'DNS_A',
      'DNS_A',
      'DNS_AAAA',
      'DNS_AAAA',
      'DNS_ALL',
      'DNS_ALL',
      'DNS_ANY',
      'DNS_ANY',
      'DNS_CNAME',
      'DNS_CNAME',
      'DNS_HINFO',
      'DNS_HINFO',
      'DNS_MX',
      'DNS_MX',
      'DNS_NAPTR',
      'DNS_NAPTR',
      'DNS_NS',
      'DNS_NS',
      'DNS_PTR',
      'DNS_PTR',
      'DNS_SOA',
      'DNS_SOA',
      'DNS_SRV',
      'DNS_SRV',
      'DNS_TXT',
      'DNS_TXT',
      'DOMSTRING_SIZE_ERR',
      'DOMSTRING_SIZE_ERR',
      'DOM_HIERARCHY_REQUEST_ERR',
      'DOM_HIERARCHY_REQUEST_ERR',
      'DOM_INDEX_SIZE_ERR',
      'DOM_INDEX_SIZE_ERR',
      'DOM_INUSE_ATTRIBUTE_ERR',
      'DOM_INUSE_ATTRIBUTE_ERR',
      'DOM_INVALID_ACCESS_ERR',
      'DOM_INVALID_ACCESS_ERR',
      'DOM_INVALID_CHARACTER_ERR',
      'DOM_INVALID_CHARACTER_ERR',
      'DOM_INVALID_MODIFICATION_ERR',
      'DOM_INVALID_MODIFICATION_ERR',
      'DOM_INVALID_STATE_ERR',
      'DOM_INVALID_STATE_ERR',
      'DOM_NAMESPACE_ERR',
      'DOM_NAMESPACE_ERR',
      'DOM_NOT_FOUND_ERR',
      'DOM_NOT_FOUND_ERR',
      'DOM_NOT_SUPPORTED_ERR',
      'DOM_NOT_SUPPORTED_ERR',
      'DOM_NO_DATA_ALLOWED_ERR',
      'DOM_NO_DATA_ALLOWED_ERR',
      'DOM_NO_MODIFICATION_ALLOWED_ERR',
      'DOM_NO_MODIFICATION_ALLOWED_ERR',
      'DOM_PHP_ERR',
      'DOM_PHP_ERR',
      'DOM_SYNTAX_ERR',
      'DOM_SYNTAX_ERR',
      'DOM_VALIDATION_ERR',
      'DOM_VALIDATION_ERR',
      'DOM_WRONG_DOCUMENT_ERR',
      'DOM_WRONG_DOCUMENT_ERR',
      'D_FMT',
      'D_FMT',
      'D_T_FMT',
      'D_T_FMT',
      'ENC7BIT',
      'ENC7BIT',
      'ENC8BIT',
      'ENC8BIT',
      'ENCBASE64',
      'ENCBASE64',
      'ENCBINARY',
      'ENCBINARY',
      'ENCOTHER',
      'ENCOTHER',
      'ENCQUOTEDPRINTABLE',
      'ENCQUOTEDPRINTABLE',
      'ENT_COMPAT',
      'ENT_COMPAT',
      'ENT_NOQUOTES',
      'ENT_NOQUOTES',
      'ENT_QUOTES',
      'ENT_QUOTES',
      'ERA',
      'ERA',
      'ERA_D_FMT',
      'ERA_D_FMT',
      'ERA_D_T_FMT',
      'ERA_D_T_FMT',
      'ERA_T_FMT',
      'ERA_T_FMT',
      'EXIF_USE_MBSTRING',
      'EXIF_USE_MBSTRING',
      'EXTR_IF_EXISTS',
      'EXTR_IF_EXISTS',
      'EXTR_OVERWRITE',
      'EXTR_OVERWRITE',
      'EXTR_PREFIX_ALL',
      'EXTR_PREFIX_ALL',
      'EXTR_PREFIX_IF_EXISTS',
      'EXTR_PREFIX_IF_EXISTS',
      'EXTR_PREFIX_INVALID',
      'EXTR_PREFIX_INVALID',
      'EXTR_PREFIX_SAME',
      'EXTR_PREFIX_SAME',
      'EXTR_REFS',
      'EXTR_REFS',
      'EXTR_SKIP',
      'EXTR_SKIP',
      'E_ALL',
      'E_ALL',
      'E_COMPILE_ERROR',
      'E_COMPILE_ERROR',
      'E_COMPILE_WARNING',
      'E_COMPILE_WARNING',
      'E_CORE_ERROR',
      'E_CORE_ERROR',
      'E_CORE_WARNING',
      'E_CORE_WARNING',
      'E_ERROR',
      'E_ERROR',
      'E_NOTICE',
      'E_NOTICE',
      'E_PARSE',
      'E_PARSE',
      'E_STRICT',
      'E_STRICT',
      'E_USER_ERROR',
      'E_USER_ERROR',
      'E_USER_NOTICE',
      'E_USER_NOTICE',
      'E_USER_WARNING',
      'E_USER_WARNING',
      'E_WARNING',
      'E_WARNING',
      'FALSE',
      'FALSE',
      'FAMAcknowledge',
      'FAMAcknowledge',
      'FAMChanged',
      'FAMChanged',
      'FAMCreated',
      'FAMCreated',
      'FAMDeleted',
      'FAMDeleted',
      'FAMEndExist',
      'FAMEndExist',
      'FAMExists',
      'FAMExists',
      'FAMMoved',
      'FAMMoved',
      'FAMStartExecuting',
      'FAMStartExecuting',
      'FAMStopExecuting',
      'FAMStopExecuting',
      'FILE_APPEND',
      'FILE_APPEND',
      'FILE_IGNORE_NEW_LINES',
      'FILE_IGNORE_NEW_LINES',
      'FILE_NO_DEFAULT_CONTEXT',
      'FILE_NO_DEFAULT_CONTEXT',
      'FILE_SKIP_EMPTY_LINES',
      'FILE_SKIP_EMPTY_LINES',
      'FILE_USE_INCLUDE_PATH',
      'FILE_USE_INCLUDE_PATH',
      'FNM_CASEFOLD',
      'FNM_CASEFOLD',
      'FNM_NOESCAPE',
      'FNM_NOESCAPE',
      'FNM_PATHNAME',
      'FNM_PATHNAME',
      'FNM_PERIOD',
      'FNM_PERIOD',
      'FORCE_DEFLATE',
      'FORCE_DEFLATE',
      'FORCE_GZIP',
      'FORCE_GZIP',
      'FTP_ASCII',
      'FTP_ASCII',
      'FTP_AUTORESUME',
      'FTP_AUTORESUME',
      'FTP_AUTOSEEK',
      'FTP_AUTOSEEK',
      'FTP_BINARY',
      'FTP_BINARY',
      'FTP_FAILED',
      'FTP_FAILED',
      'FTP_FINISHED',
      'FTP_FINISHED',
      'FTP_IMAGE',
      'FTP_IMAGE',
      'FTP_MOREDATA',
      'FTP_MOREDATA',
      'FTP_TEXT',
      'FTP_TEXT',
      'FTP_TIMEOUT_SEC',
      'FTP_TIMEOUT_SEC',
      'FT_INTERNAL',
      'FT_INTERNAL',
      'FT_NOT',
      'FT_NOT',
      'FT_PEEK',
      'FT_PEEK',
      'FT_PREFETCHTEXT',
      'FT_PREFETCHTEXT',
      'FT_UID',
      'FT_UID',
      'F_DUPFD',
      'F_DUPFD',
      'F_GETFD',
      'F_GETFD',
      'F_GETFL',
      'F_GETFL',
      'F_GETLK',
      'F_GETLK',
      'F_GETOWN',
      'F_GETOWN',
      'F_RDLCK',
      'F_RDLCK',
      'F_SETFL',
      'F_SETFL',
      'F_SETLK',
      'F_SETLK',
      'F_SETLKW',
      'F_SETLKW',
      'F_SETOWN',
      'F_SETOWN',
      'F_UNLCK',
      'F_UNLCK',
      'F_WRLCK',
      'F_WRLCK',
      'GD_BUNDLED',
      'GD_BUNDLED',
      'GLOB_BRACE',
      'GLOB_BRACE',
      'GLOB_MARK',
      'GLOB_MARK',
      'GLOB_NOCHECK',
      'GLOB_NOCHECK',
      'GLOB_NOESCAPE',
      'GLOB_NOESCAPE',
      'GLOB_NOSORT',
      'GLOB_NOSORT',
      'GLOB_ONLYDIR',
      'GLOB_ONLYDIR',
      'GMP_ROUND_MINUSINF',
      'GMP_ROUND_MINUSINF',
      'GMP_ROUND_PLUSINF',
      'GMP_ROUND_PLUSINF',
      'GMP_ROUND_ZERO',
      'GMP_ROUND_ZERO',
      'HTML_ENTITIES',
      'HTML_ENTITIES',
      'HTML_SPECIALCHARS',
      'HTML_SPECIALCHARS',
      'ICONV_IMPL',
      'ICONV_IMPL',
      'ICONV_MIME_DECODE_CONTINUE_ON_ERROR',
      'ICONV_MIME_DECODE_CONTINUE_ON_ERROR',
      'ICONV_MIME_DECODE_STRICT',
      'ICONV_MIME_DECODE_STRICT',
      'ICONV_VERSION',
      'ICONV_VERSION',
      'IMAGETYPE_BMP',
      'IMAGETYPE_BMP',
      'IMAGETYPE_GIF',
      'IMAGETYPE_GIF',
      'IMAGETYPE_IFF',
      'IMAGETYPE_IFF',
      'IMAGETYPE_JB2',
      'IMAGETYPE_JB2',
      'IMAGETYPE_JP2',
      'IMAGETYPE_JP2',
      'IMAGETYPE_JPC',
      'IMAGETYPE_JPC',
      'IMAGETYPE_JPEG',
      'IMAGETYPE_JPEG',
      'IMAGETYPE_JPEG2000',
      'IMAGETYPE_JPEG2000',
      'IMAGETYPE_JPX',
      'IMAGETYPE_JPX',
      'IMAGETYPE_PNG',
      'IMAGETYPE_PNG',
      'IMAGETYPE_PSD',
      'IMAGETYPE_PSD',
      'IMAGETYPE_SWF',
      'IMAGETYPE_SWF',
      'IMAGETYPE_TIFF_II',
      'IMAGETYPE_TIFF_II',
      'IMAGETYPE_TIFF_MM',
      'IMAGETYPE_TIFF_MM',
      'IMAGETYPE_WBMP',
      'IMAGETYPE_WBMP',
      'IMAGETYPE_XBM',
      'IMAGETYPE_XBM',
      'IMAP_CLOSETIMEOUT',
      'IMAP_CLOSETIMEOUT',
      'IMAP_OPENTIMEOUT',
      'IMAP_OPENTIMEOUT',
      'IMAP_READTIMEOUT',
      'IMAP_READTIMEOUT',
      'IMAP_WRITETIMEOUT',
      'IMAP_WRITETIMEOUT',
      'IMG_ARC_CHORD',
      'IMG_ARC_CHORD',
      'IMG_ARC_EDGED',
      'IMG_ARC_EDGED',
      'IMG_ARC_NOFILL',
      'IMG_ARC_NOFILL',
      'IMG_ARC_PIE',
      'IMG_ARC_PIE',
      'IMG_ARC_ROUNDED',
      'IMG_ARC_ROUNDED',
      'IMG_COLOR_BRUSHED',
      'IMG_COLOR_BRUSHED',
      'IMG_COLOR_STYLED',
      'IMG_COLOR_STYLED',
      'IMG_COLOR_STYLEDBRUSHED',
      'IMG_COLOR_STYLEDBRUSHED',
      'IMG_COLOR_TILED',
      'IMG_COLOR_TILED',
      'IMG_COLOR_TRANSPARENT',
      'IMG_COLOR_TRANSPARENT',
      'IMG_EFFECT_ALPHABLEND',
      'IMG_EFFECT_ALPHABLEND',
      'IMG_EFFECT_NORMAL',
      'IMG_EFFECT_NORMAL',
      'IMG_EFFECT_OVERLAY',
      'IMG_EFFECT_OVERLAY',
      'IMG_EFFECT_REPLACE',
      'IMG_EFFECT_REPLACE',
      'IMG_FILTER_BRIGHTNESS',
      'IMG_FILTER_BRIGHTNESS',
      'IMG_FILTER_COLORIZE',
      'IMG_FILTER_COLORIZE',
      'IMG_FILTER_CONTRAST',
      'IMG_FILTER_CONTRAST',
      'IMG_FILTER_EDGEDETECT',
      'IMG_FILTER_EDGEDETECT',
      'IMG_FILTER_EMBOSS',
      'IMG_FILTER_EMBOSS',
      'IMG_FILTER_GAUSSIAN_BLUR',
      'IMG_FILTER_GAUSSIAN_BLUR',
      'IMG_FILTER_GRAYSCALE',
      'IMG_FILTER_GRAYSCALE',
      'IMG_FILTER_MEAN_REMOVAL',
      'IMG_FILTER_MEAN_REMOVAL',
      'IMG_FILTER_NEGATE',
      'IMG_FILTER_NEGATE',
      'IMG_FILTER_SELECTIVE_BLUR',
      'IMG_FILTER_SELECTIVE_BLUR',
      'IMG_FILTER_SMOOTH',
      'IMG_FILTER_SMOOTH',
      'IMG_GD2_COMPRESSED',
      'IMG_GD2_COMPRESSED',
      'IMG_GD2_RAW',
      'IMG_GD2_RAW',
      'IMG_GIF',
      'IMG_GIF',
      'IMG_JPEG',
      'IMG_JPEG',
      'IMG_JPG',
      'IMG_JPG',
      'IMG_PNG',
      'IMG_PNG',
      'IMG_WBMP',
      'IMG_WBMP',
      'IMG_XPM',
      'IMG_XPM',
      'INF',
      'INF',
      'INFO_ALL',
      'INFO_ALL',
      'INFO_CONFIGURATION',
      'INFO_CONFIGURATION',
      'INFO_CREDITS',
      'INFO_CREDITS',
      'INFO_ENVIRONMENT',
      'INFO_ENVIRONMENT',
      'INFO_GENERAL',
      'INFO_GENERAL',
      'INFO_LICENSE',
      'INFO_LICENSE',
      'INFO_MODULES',
      'INFO_MODULES',
      'INFO_VARIABLES',
      'INFO_VARIABLES',
      'INI_ALL',
      'INI_ALL',
      'INI_PERDIR',
      'INI_PERDIR',
      'INI_SYSTEM',
      'INI_SYSTEM',
      'INI_USER',
      'INI_USER',
      'LATT_HASCHILDREN',
      'LATT_HASCHILDREN',
      'LATT_HASNOCHILDREN',
      'LATT_HASNOCHILDREN',
      'LATT_MARKED',
      'LATT_MARKED',
      'LATT_NOINFERIORS',
      'LATT_NOINFERIORS',
      'LATT_NOSELECT',
      'LATT_NOSELECT',
      'LATT_REFERRAL',
      'LATT_REFERRAL',
      'LATT_UNMARKED',
      'LATT_UNMARKED',
      'LC_ALL',
      'LC_ALL',
      'LC_COLLATE',
      'LC_COLLATE',
      'LC_CTYPE',
      'LC_CTYPE',
      'LC_MESSAGES',
      'LC_MESSAGES',
      'LC_MONETARY',
      'LC_MONETARY',
      'LC_NUMERIC',
      'LC_NUMERIC',
      'LC_TIME',
      'LC_TIME',
      'LDAP_DEREF_ALWAYS',
      'LDAP_DEREF_ALWAYS',
      'LDAP_DEREF_FINDING',
      'LDAP_DEREF_FINDING',
      'LDAP_DEREF_NEVER',
      'LDAP_DEREF_NEVER',
      'LDAP_DEREF_SEARCHING',
      'LDAP_DEREF_SEARCHING',
      'LDAP_OPT_CLIENT_CONTROLS',
      'LDAP_OPT_CLIENT_CONTROLS',
      'LDAP_OPT_DEBUG_LEVEL',
      'LDAP_OPT_DEBUG_LEVEL',
      'LDAP_OPT_DEREF',
      'LDAP_OPT_DEREF',
      'LDAP_OPT_ERROR_NUMBER',
      'LDAP_OPT_ERROR_NUMBER',
      'LDAP_OPT_ERROR_STRING',
      'LDAP_OPT_ERROR_STRING',
      'LDAP_OPT_HOST_NAME',
      'LDAP_OPT_HOST_NAME',
      'LDAP_OPT_MATCHED_DN',
      'LDAP_OPT_MATCHED_DN',
      'LDAP_OPT_PROTOCOL_VERSION',
      'LDAP_OPT_PROTOCOL_VERSION',
      'LDAP_OPT_REFERRALS',
      'LDAP_OPT_REFERRALS',
      'LDAP_OPT_RESTART',
      'LDAP_OPT_RESTART',
      'LDAP_OPT_SERVER_CONTROLS',
      'LDAP_OPT_SERVER_CONTROLS',
      'LDAP_OPT_SIZELIMIT',
      'LDAP_OPT_SIZELIMIT',
      'LDAP_OPT_TIMELIMIT',
      'LDAP_OPT_TIMELIMIT',
      'LOCK_EX',
      'LOCK_EX',
      'LOCK_NB',
      'LOCK_NB',
      'LOCK_SH',
      'LOCK_SH',
      'LOCK_UN',
      'LOCK_UN',
      'LOG_ALERT',
      'LOG_ALERT',
      'LOG_AUTH',
      'LOG_AUTH',
      'LOG_AUTHPRIV',
      'LOG_AUTHPRIV',
      'LOG_CONS',
      'LOG_CONS',
      'LOG_CRIT',
      'LOG_CRIT',
      'LOG_CRON',
      'LOG_CRON',
      'LOG_DAEMON',
      'LOG_DAEMON',
      'LOG_DEBUG',
      'LOG_DEBUG',
      'LOG_EMERG',
      'LOG_EMERG',
      'LOG_ERR',
      'LOG_ERR',
      'LOG_INFO',
      'LOG_INFO',
      'LOG_KERN',
      'LOG_KERN',
      'LOG_LOCAL0',
      'LOG_LOCAL0',
      'LOG_LOCAL1',
      'LOG_LOCAL1',
      'LOG_LOCAL2',
      'LOG_LOCAL2',
      'LOG_LOCAL3',
      'LOG_LOCAL3',
      'LOG_LOCAL4',
      'LOG_LOCAL4',
      'LOG_LOCAL5',
      'LOG_LOCAL5',
      'LOG_LOCAL6',
      'LOG_LOCAL6',
      'LOG_LOCAL7',
      'LOG_LOCAL7',
      'LOG_LPR',
      'LOG_LPR',
      'LOG_MAIL',
      'LOG_MAIL',
      'LOG_NDELAY',
      'LOG_NDELAY',
      'LOG_NEWS',
      'LOG_NEWS',
      'LOG_NOTICE',
      'LOG_NOTICE',
      'LOG_NOWAIT',
      'LOG_NOWAIT',
      'LOG_ODELAY',
      'LOG_ODELAY',
      'LOG_PERROR',
      'LOG_PERROR',
      'LOG_PID',
      'LOG_PID',
      'LOG_SYSLOG',
      'LOG_SYSLOG',
      'LOG_USER',
      'LOG_USER',
      'LOG_UUCP',
      'LOG_UUCP',
      'LOG_WARNING',
      'LOG_WARNING',
      'MB_CASE_LOWER',
      'MB_CASE_LOWER',
      'MB_CASE_TITLE',
      'MB_CASE_TITLE',
      'MB_CASE_UPPER',
      'MB_CASE_UPPER',
      'MB_OVERLOAD_MAIL',
      'MB_OVERLOAD_MAIL',
      'MB_OVERLOAD_REGEX',
      'MB_OVERLOAD_REGEX',
      'MB_OVERLOAD_STRING',
      'MB_OVERLOAD_STRING',
      'MCRYPT_3DES',
      'MCRYPT_3DES',
      'MCRYPT_ARCFOUR',
      'MCRYPT_ARCFOUR',
      'MCRYPT_ARCFOUR_IV',
      'MCRYPT_ARCFOUR_IV',
      'MCRYPT_BLOWFISH',
      'MCRYPT_BLOWFISH',
      'MCRYPT_BLOWFISH_COMPAT',
      'MCRYPT_BLOWFISH_COMPAT',
      'MCRYPT_CAST_128',
      'MCRYPT_CAST_128',
      'MCRYPT_CAST_256',
      'MCRYPT_CAST_256',
      'MCRYPT_CRYPT',
      'MCRYPT_CRYPT',
      'MCRYPT_DECRYPT',
      'MCRYPT_DECRYPT',
      'MCRYPT_DES',
      'MCRYPT_DES',
      'MCRYPT_DEV_RANDOM',
      'MCRYPT_DEV_RANDOM',
      'MCRYPT_DEV_URANDOM',
      'MCRYPT_DEV_URANDOM',
      'MCRYPT_ENCRYPT',
      'MCRYPT_ENCRYPT',
      'MCRYPT_ENIGNA',
      'MCRYPT_ENIGNA',
      'MCRYPT_GOST',
      'MCRYPT_GOST',
      'MCRYPT_IDEA',
      'MCRYPT_IDEA',
      'MCRYPT_LOKI97',
      'MCRYPT_LOKI97',
      'MCRYPT_MARS',
      'MCRYPT_MARS',
      'MCRYPT_MODE_CBC',
      'MCRYPT_MODE_CBC',
      'MCRYPT_MODE_CFB',
      'MCRYPT_MODE_CFB',
      'MCRYPT_MODE_ECB',
      'MCRYPT_MODE_ECB',
      'MCRYPT_MODE_NOFB',
      'MCRYPT_MODE_NOFB',
      'MCRYPT_MODE_OFB',
      'MCRYPT_MODE_OFB',
      'MCRYPT_MODE_STREAM',
      'MCRYPT_MODE_STREAM',
      'MCRYPT_PANAMA',
      'MCRYPT_PANAMA',
      'MCRYPT_RAND',
      'MCRYPT_RAND',
      'MCRYPT_RC2',
      'MCRYPT_RC2',
      'MCRYPT_RC6',
      'MCRYPT_RC6',
      'MCRYPT_RIJNDAEL_128',
      'MCRYPT_RIJNDAEL_128',
      'MCRYPT_RIJNDAEL_192',
      'MCRYPT_RIJNDAEL_192',
      'MCRYPT_RIJNDAEL_256',
      'MCRYPT_RIJNDAEL_256',
      'MCRYPT_SAFER128',
      'MCRYPT_SAFER128',
      'MCRYPT_SAFER64',
      'MCRYPT_SAFER64',
      'MCRYPT_SAFERPLUS',
      'MCRYPT_SAFERPLUS',
      'MCRYPT_SERPENT',
      'MCRYPT_SERPENT',
      'MCRYPT_SKIPJACK',
      'MCRYPT_SKIPJACK',
      'MCRYPT_THREEWAY',
      'MCRYPT_THREEWAY',
      'MCRYPT_TRIPLEDES',
      'MCRYPT_TRIPLEDES',
      'MCRYPT_TWOFISH',
      'MCRYPT_TWOFISH',
      'MCRYPT_WAKE',
      'MCRYPT_WAKE',
      'MCRYPT_XTEA',
      'MCRYPT_XTEA',
      'MHASH_ADLER32',
      'MHASH_ADLER32',
      'MHASH_CRC32',
      'MHASH_CRC32',
      'MHASH_CRC32B',
      'MHASH_CRC32B',
      'MHASH_GOST',
      'MHASH_GOST',
      'MHASH_HAVAL128',
      'MHASH_HAVAL128',
      'MHASH_HAVAL160',
      'MHASH_HAVAL160',
      'MHASH_HAVAL192',
      'MHASH_HAVAL192',
      'MHASH_HAVAL224',
      'MHASH_HAVAL224',
      'MHASH_HAVAL256',
      'MHASH_HAVAL256',
      'MHASH_MD2',
      'MHASH_MD2',
      'MHASH_MD4',
      'MHASH_MD4',
      'MHASH_MD5',
      'MHASH_MD5',
      'MHASH_RIPEMD128',
      'MHASH_RIPEMD128',
      'MHASH_RIPEMD160',
      'MHASH_RIPEMD160',
      'MHASH_RIPEMD256',
      'MHASH_RIPEMD256',
      'MHASH_RIPEMD320',
      'MHASH_RIPEMD320',
      'MHASH_SHA1',
      'MHASH_SHA1',
      'MHASH_SHA224',
      'MHASH_SHA224',
      'MHASH_SHA256',
      'MHASH_SHA256',
      'MHASH_SHA384',
      'MHASH_SHA384',
      'MHASH_SHA512',
      'MHASH_SHA512',
      'MHASH_SNEFRU128',
      'MHASH_SNEFRU128',
      'MHASH_SNEFRU256',
      'MHASH_SNEFRU256',
      'MHASH_TIGER',
      'MHASH_TIGER',
      'MHASH_TIGER128',
      'MHASH_TIGER128',
      'MHASH_TIGER160',
      'MHASH_TIGER160',
      'MHASH_WHIRLPOOL',
      'MHASH_WHIRLPOOL',
      'MON_1',
      'MON_1',
      'MON_10',
      'MON_10',
      'MON_11',
      'MON_11',
      'MON_12',
      'MON_12',
      'MON_2',
      'MON_2',
      'MON_3',
      'MON_3',
      'MON_4',
      'MON_4',
      'MON_5',
      'MON_5',
      'MON_6',
      'MON_6',
      'MON_7',
      'MON_7',
      'MON_8',
      'MON_8',
      'MON_9',
      'MON_9',
      'MSG_DONTROUTE',
      'MSG_DONTROUTE',
      'MSG_EXCEPT',
      'MSG_EXCEPT',
      'MSG_IPC_NOWAIT',
      'MSG_IPC_NOWAIT',
      'MSG_NOERROR',
      'MSG_NOERROR',
      'MSG_OOB',
      'MSG_OOB',
      'MSG_PEEK',
      'MSG_PEEK',
      'MSG_WAITALL',
      'MSG_WAITALL',
      'MYSQLI_ASSOC',
      'MYSQLI_ASSOC',
      'MYSQLI_AUTO_INCREMENT_FLAG',
      'MYSQLI_AUTO_INCREMENT_FLAG',
      'MYSQLI_BLOB_FLAG',
      'MYSQLI_BLOB_FLAG',
      'MYSQLI_BOTH',
      'MYSQLI_BOTH',
      'MYSQLI_CLIENT_COMPRESS',
      'MYSQLI_CLIENT_COMPRESS',
      'MYSQLI_CLIENT_FOUND_ROWS',
      'MYSQLI_CLIENT_FOUND_ROWS',
      'MYSQLI_CLIENT_IGNORE_SPACE',
      'MYSQLI_CLIENT_IGNORE_SPACE',
      'MYSQLI_CLIENT_INTERACTIVE',
      'MYSQLI_CLIENT_INTERACTIVE',
      'MYSQLI_CLIENT_NO_SCHEMA',
      'MYSQLI_CLIENT_NO_SCHEMA',
      'MYSQLI_CLIENT_SSL',
      'MYSQLI_CLIENT_SSL',
      'MYSQLI_GROUP_FLAG',
      'MYSQLI_GROUP_FLAG',
      'MYSQLI_INIT_COMMAND',
      'MYSQLI_INIT_COMMAND',
      'MYSQLI_MULTIPLE_KEY_FLAG',
      'MYSQLI_MULTIPLE_KEY_FLAG',
      'MYSQLI_NOT_NULL_FLAG',
      'MYSQLI_NOT_NULL_FLAG',
      'MYSQLI_NO_DATA',
      'MYSQLI_NO_DATA',
      'MYSQLI_NUM',
      'MYSQLI_NUM',
      'MYSQLI_NUM_FLAG',
      'MYSQLI_NUM_FLAG',
      'MYSQLI_OPT_CONNECT_TIMEOUT',
      'MYSQLI_OPT_CONNECT_TIMEOUT',
      'MYSQLI_OPT_LOCAL_INFILE',
      'MYSQLI_OPT_LOCAL_INFILE',
      'MYSQLI_PART_KEY_FLAG',
      'MYSQLI_PART_KEY_FLAG',
      'MYSQLI_PRI_KEY_FLAG',
      'MYSQLI_PRI_KEY_FLAG',
      'MYSQLI_READ_DEFAULT_FILE',
      'MYSQLI_READ_DEFAULT_FILE',
      'MYSQLI_READ_DEFAULT_GROUP',
      'MYSQLI_READ_DEFAULT_GROUP',
      'MYSQLI_REPORT_ALL',
      'MYSQLI_REPORT_ALL',
      'MYSQLI_REPORT_ERROR',
      'MYSQLI_REPORT_ERROR',
      'MYSQLI_REPORT_INDEX',
      'MYSQLI_REPORT_INDEX',
      'MYSQLI_REPORT_OFF',
      'MYSQLI_REPORT_OFF',
      'MYSQLI_RPL_ADMIN',
      'MYSQLI_RPL_ADMIN',
      'MYSQLI_RPL_MASTER',
      'MYSQLI_RPL_MASTER',
      'MYSQLI_RPL_SLAVE',
      'MYSQLI_RPL_SLAVE',
      'MYSQLI_SET_FLAG',
      'MYSQLI_SET_FLAG',
      'MYSQLI_STMT_ATTR_UPDATE_MAX_LENGTH',
      'MYSQLI_STMT_ATTR_UPDATE_MAX_LENGTH',
      'MYSQLI_STORE_RESULT',
      'MYSQLI_STORE_RESULT',
      'MYSQLI_TIMESTAMP_FLAG',
      'MYSQLI_TIMESTAMP_FLAG',
      'MYSQLI_TYPE_BLOB',
      'MYSQLI_TYPE_BLOB',
      'MYSQLI_TYPE_CHAR',
      'MYSQLI_TYPE_CHAR',
      'MYSQLI_TYPE_DATE',
      'MYSQLI_TYPE_DATE',
      'MYSQLI_TYPE_DATETIME',
      'MYSQLI_TYPE_DATETIME',
      'MYSQLI_TYPE_DECIMAL',
      'MYSQLI_TYPE_DECIMAL',
      'MYSQLI_TYPE_DOUBLE',
      'MYSQLI_TYPE_DOUBLE',
      'MYSQLI_TYPE_ENUM',
      'MYSQLI_TYPE_ENUM',
      'MYSQLI_TYPE_FLOAT',
      'MYSQLI_TYPE_FLOAT',
      'MYSQLI_TYPE_GEOMETRY',
      'MYSQLI_TYPE_GEOMETRY',
      'MYSQLI_TYPE_INT24',
      'MYSQLI_TYPE_INT24',
      'MYSQLI_TYPE_INTERVAL',
      'MYSQLI_TYPE_INTERVAL',
      'MYSQLI_TYPE_LONG',
      'MYSQLI_TYPE_LONG',
      'MYSQLI_TYPE_LONGLONG',
      'MYSQLI_TYPE_LONGLONG',
      'MYSQLI_TYPE_LONG_BLOB',
      'MYSQLI_TYPE_LONG_BLOB',
      'MYSQLI_TYPE_MEDIUM_BLOB',
      'MYSQLI_TYPE_MEDIUM_BLOB',
      'MYSQLI_TYPE_NEWDATE',
      'MYSQLI_TYPE_NEWDATE',
      'MYSQLI_TYPE_NULL',
      'MYSQLI_TYPE_NULL',
      'MYSQLI_TYPE_SET',
      'MYSQLI_TYPE_SET',
      'MYSQLI_TYPE_SHORT',
      'MYSQLI_TYPE_SHORT',
      'MYSQLI_TYPE_STRING',
      'MYSQLI_TYPE_STRING',
      'MYSQLI_TYPE_TIME',
      'MYSQLI_TYPE_TIME',
      'MYSQLI_TYPE_TIMESTAMP',
      'MYSQLI_TYPE_TIMESTAMP',
      'MYSQLI_TYPE_TINY',
      'MYSQLI_TYPE_TINY',
      'MYSQLI_TYPE_TINY_BLOB',
      'MYSQLI_TYPE_TINY_BLOB',
      'MYSQLI_TYPE_VAR_STRING',
      'MYSQLI_TYPE_VAR_STRING',
      'MYSQLI_TYPE_YEAR',
      'MYSQLI_TYPE_YEAR',
      'MYSQLI_UNIQUE_KEY_FLAG',
      'MYSQLI_UNIQUE_KEY_FLAG',
      'MYSQLI_UNSIGNED_FLAG',
      'MYSQLI_UNSIGNED_FLAG',
      'MYSQLI_USE_RESULT',
      'MYSQLI_USE_RESULT',
      'MYSQLI_ZEROFILL_FLAG',
      'MYSQLI_ZEROFILL_FLAG',
      'MYSQL_ASSOC',
      'MYSQL_ASSOC',
      'MYSQL_BOTH',
      'MYSQL_BOTH',
      'MYSQL_CLIENT_COMPRESS',
      'MYSQL_CLIENT_COMPRESS',
      'MYSQL_CLIENT_IGNORE_SPACE',
      'MYSQL_CLIENT_IGNORE_SPACE',
      'MYSQL_CLIENT_INTERACTIVE',
      'MYSQL_CLIENT_INTERACTIVE',
      'MYSQL_CLIENT_SSL',
      'MYSQL_CLIENT_SSL',
      'MYSQL_NUM',
      'MYSQL_NUM',
      'M_1_PI',
      'M_1_PI',
      'M_2_PI',
      'M_2_PI',
      'M_2_SQRTPI',
      'M_2_SQRTPI',
      'M_ABSTRACT',
      'M_ABSTRACT',
      'M_E',
      'M_E',
      'M_FINAL',
      'M_FINAL',
      'M_LN10',
      'M_LN10',
      'M_LN2',
      'M_LN2',
      'M_LOG10E',
      'M_LOG10E',
      'M_LOG2E',
      'M_LOG2E',
      'M_PI',
      'M_PI',
      'M_PI_2',
      'M_PI_2',
      'M_PI_4',
      'M_PI_4',
      'M_PRIVATE',
      'M_PRIVATE',
      'M_PROTECTED',
      'M_PROTECTED',
      'M_PUBLIC',
      'M_PUBLIC',
      'M_SQRT1_2',
      'M_SQRT1_2',
      'M_SQRT2',
      'M_SQRT2',
      'M_STATIC',
      'M_STATIC',
      'NAN',
      'NAN',
      'NCURSES_ALL_MOUSE_EVENTS',
      'NCURSES_ALL_MOUSE_EVENTS',
      'NCURSES_A_ALTCHARSET',
      'NCURSES_A_ALTCHARSET',
      'NCURSES_A_BLINK',
      'NCURSES_A_BLINK',
      'NCURSES_A_BOLD',
      'NCURSES_A_BOLD',
      'NCURSES_A_CHARTEXT',
      'NCURSES_A_CHARTEXT',
      'NCURSES_A_DIM',
      'NCURSES_A_DIM',
      'NCURSES_A_INVIS',
      'NCURSES_A_INVIS',
      'NCURSES_A_NORMAL',
      'NCURSES_A_NORMAL',
      'NCURSES_A_PROTECT',
      'NCURSES_A_PROTECT',
      'NCURSES_A_REVERSE',
      'NCURSES_A_REVERSE',
      'NCURSES_A_STANDOUT',
      'NCURSES_A_STANDOUT',
      'NCURSES_A_UNDERLINE',
      'NCURSES_A_UNDERLINE',
      'NCURSES_BUTTON1_CLICKED',
      'NCURSES_BUTTON1_CLICKED',
      'NCURSES_BUTTON1_DOUBLE_CLICKED',
      'NCURSES_BUTTON1_DOUBLE_CLICKED',
      'NCURSES_BUTTON1_PRESSED',
      'NCURSES_BUTTON1_PRESSED',
      'NCURSES_BUTTON1_RELEASED',
      'NCURSES_BUTTON1_RELEASED',
      'NCURSES_BUTTON1_TRIPLE_CLICKED',
      'NCURSES_BUTTON1_TRIPLE_CLICKED',
      'NCURSES_BUTTON2_CLICKED',
      'NCURSES_BUTTON2_CLICKED',
      'NCURSES_BUTTON2_DOUBLE_CLICKED',
      'NCURSES_BUTTON2_DOUBLE_CLICKED',
      'NCURSES_BUTTON2_PRESSED',
      'NCURSES_BUTTON2_PRESSED',
      'NCURSES_BUTTON2_RELEASED',
      'NCURSES_BUTTON2_RELEASED',
      'NCURSES_BUTTON2_TRIPLE_CLICKED',
      'NCURSES_BUTTON2_TRIPLE_CLICKED',
      'NCURSES_BUTTON3_CLICKED',
      'NCURSES_BUTTON3_CLICKED',
      'NCURSES_BUTTON3_DOUBLE_CLICKED',
      'NCURSES_BUTTON3_DOUBLE_CLICKED',
      'NCURSES_BUTTON3_PRESSED',
      'NCURSES_BUTTON3_PRESSED',
      'NCURSES_BUTTON3_RELEASED',
      'NCURSES_BUTTON3_RELEASED',
      'NCURSES_BUTTON3_TRIPLE_CLICKED',
      'NCURSES_BUTTON3_TRIPLE_CLICKED',
      'NCURSES_BUTTON4_CLICKED',
      'NCURSES_BUTTON4_CLICKED',
      'NCURSES_BUTTON4_DOUBLE_CLICKED',
      'NCURSES_BUTTON4_DOUBLE_CLICKED',
      'NCURSES_BUTTON4_PRESSED',
      'NCURSES_BUTTON4_PRESSED',
      'NCURSES_BUTTON4_RELEASED',
      'NCURSES_BUTTON4_RELEASED',
      'NCURSES_BUTTON4_TRIPLE_CLICKED',
      'NCURSES_BUTTON4_TRIPLE_CLICKED',
      'NCURSES_BUTTON_ALT',
      'NCURSES_BUTTON_ALT',
      'NCURSES_BUTTON_CTRL',
      'NCURSES_BUTTON_CTRL',
      'NCURSES_BUTTON_SHIFT',
      'NCURSES_BUTTON_SHIFT',
      'NCURSES_COLOR_BLACK',
      'NCURSES_COLOR_BLACK',
      'NCURSES_COLOR_BLUE',
      'NCURSES_COLOR_BLUE',
      'NCURSES_COLOR_CYAN',
      'NCURSES_COLOR_CYAN',
      'NCURSES_COLOR_GREEN',
      'NCURSES_COLOR_GREEN',
      'NCURSES_COLOR_MAGENTA',
      'NCURSES_COLOR_MAGENTA',
      'NCURSES_COLOR_RED',
      'NCURSES_COLOR_RED',
      'NCURSES_COLOR_WHITE',
      'NCURSES_COLOR_WHITE',
      'NCURSES_COLOR_YELLOW',
      'NCURSES_COLOR_YELLOW',
      'NCURSES_KEY_A1',
      'NCURSES_KEY_A1',
      'NCURSES_KEY_A3',
      'NCURSES_KEY_A3',
      'NCURSES_KEY_B2',
      'NCURSES_KEY_B2',
      'NCURSES_KEY_BACKSPACE',
      'NCURSES_KEY_BACKSPACE',
      'NCURSES_KEY_BEG',
      'NCURSES_KEY_BEG',
      'NCURSES_KEY_BTAB',
      'NCURSES_KEY_BTAB',
      'NCURSES_KEY_C1',
      'NCURSES_KEY_C1',
      'NCURSES_KEY_C3',
      'NCURSES_KEY_C3',
      'NCURSES_KEY_CANCEL',
      'NCURSES_KEY_CANCEL',
      'NCURSES_KEY_CATAB',
      'NCURSES_KEY_CATAB',
      'NCURSES_KEY_CLEAR',
      'NCURSES_KEY_CLEAR',
      'NCURSES_KEY_CLOSE',
      'NCURSES_KEY_CLOSE',
      'NCURSES_KEY_COMMAND',
      'NCURSES_KEY_COMMAND',
      'NCURSES_KEY_COPY',
      'NCURSES_KEY_COPY',
      'NCURSES_KEY_CREATE',
      'NCURSES_KEY_CREATE',
      'NCURSES_KEY_CTAB',
      'NCURSES_KEY_CTAB',
      'NCURSES_KEY_DC',
      'NCURSES_KEY_DC',
      'NCURSES_KEY_DL',
      'NCURSES_KEY_DL',
      'NCURSES_KEY_DOWN',
      'NCURSES_KEY_DOWN',
      'NCURSES_KEY_EIC',
      'NCURSES_KEY_EIC',
      'NCURSES_KEY_END',
      'NCURSES_KEY_END',
      'NCURSES_KEY_ENTER',
      'NCURSES_KEY_ENTER',
      'NCURSES_KEY_EOL',
      'NCURSES_KEY_EOL',
      'NCURSES_KEY_EOS',
      'NCURSES_KEY_EOS',
      'NCURSES_KEY_EXIT',
      'NCURSES_KEY_EXIT',
      'NCURSES_KEY_F0',
      'NCURSES_KEY_F0',
      'NCURSES_KEY_F1',
      'NCURSES_KEY_F1',
      'NCURSES_KEY_F10',
      'NCURSES_KEY_F10',
      'NCURSES_KEY_F11',
      'NCURSES_KEY_F11',
      'NCURSES_KEY_F12',
      'NCURSES_KEY_F12',
      'NCURSES_KEY_F2',
      'NCURSES_KEY_F2',
      'NCURSES_KEY_F3',
      'NCURSES_KEY_F3',
      'NCURSES_KEY_F4',
      'NCURSES_KEY_F4',
      'NCURSES_KEY_F5',
      'NCURSES_KEY_F5',
      'NCURSES_KEY_F6',
      'NCURSES_KEY_F6',
      'NCURSES_KEY_F7',
      'NCURSES_KEY_F7',
      'NCURSES_KEY_F8',
      'NCURSES_KEY_F8',
      'NCURSES_KEY_F9',
      'NCURSES_KEY_F9',
      'NCURSES_KEY_FIND',
      'NCURSES_KEY_FIND',
      'NCURSES_KEY_HELP',
      'NCURSES_KEY_HELP',
      'NCURSES_KEY_IC',
      'NCURSES_KEY_IC',
      'NCURSES_KEY_IL',
      'NCURSES_KEY_IL',
      'NCURSES_KEY_LEFT',
      'NCURSES_KEY_LEFT',
      'NCURSES_KEY_LL',
      'NCURSES_KEY_LL',
      'NCURSES_KEY_MARK',
      'NCURSES_KEY_MARK',
      'NCURSES_KEY_MESSAGE',
      'NCURSES_KEY_MESSAGE',
      'NCURSES_KEY_MOUSE',
      'NCURSES_KEY_MOUSE',
      'NCURSES_KEY_MOVE',
      'NCURSES_KEY_MOVE',
      'NCURSES_KEY_NEXT',
      'NCURSES_KEY_NEXT',
      'NCURSES_KEY_NPAGE',
      'NCURSES_KEY_NPAGE',
      'NCURSES_KEY_OPEN',
      'NCURSES_KEY_OPEN',
      'NCURSES_KEY_OPTIONS',
      'NCURSES_KEY_OPTIONS',
      'NCURSES_KEY_PPAGE',
      'NCURSES_KEY_PPAGE',
      'NCURSES_KEY_PREVIOUS',
      'NCURSES_KEY_PREVIOUS',
      'NCURSES_KEY_PRINT',
      'NCURSES_KEY_PRINT',
      'NCURSES_KEY_REDO',
      'NCURSES_KEY_REDO',
      'NCURSES_KEY_REFERENCE',
      'NCURSES_KEY_REFERENCE',
      'NCURSES_KEY_REFRESH',
      'NCURSES_KEY_REFRESH',
      'NCURSES_KEY_REPLACE',
      'NCURSES_KEY_REPLACE',
      'NCURSES_KEY_RESET',
      'NCURSES_KEY_RESET',
      'NCURSES_KEY_RESIZE',
      'NCURSES_KEY_RESIZE',
      'NCURSES_KEY_RESTART',
      'NCURSES_KEY_RESTART',
      'NCURSES_KEY_RESUME',
      'NCURSES_KEY_RESUME',
      'NCURSES_KEY_RIGHT',
      'NCURSES_KEY_RIGHT',
      'NCURSES_KEY_SAVE',
      'NCURSES_KEY_SAVE',
      'NCURSES_KEY_SBEG',
      'NCURSES_KEY_SBEG',
      'NCURSES_KEY_SCANCEL',
      'NCURSES_KEY_SCANCEL',
      'NCURSES_KEY_SCOMMAND',
      'NCURSES_KEY_SCOMMAND',
      'NCURSES_KEY_SCOPY',
      'NCURSES_KEY_SCOPY',
      'NCURSES_KEY_SCREATE',
      'NCURSES_KEY_SCREATE',
      'NCURSES_KEY_SDC',
      'NCURSES_KEY_SDC',
      'NCURSES_KEY_SDL',
      'NCURSES_KEY_SDL',
      'NCURSES_KEY_SELECT',
      'NCURSES_KEY_SELECT',
      'NCURSES_KEY_SEND',
      'NCURSES_KEY_SEND',
      'NCURSES_KEY_SEOL',
      'NCURSES_KEY_SEOL',
      'NCURSES_KEY_SEXIT',
      'NCURSES_KEY_SEXIT',
      'NCURSES_KEY_SF',
      'NCURSES_KEY_SF',
      'NCURSES_KEY_SFIND',
      'NCURSES_KEY_SFIND',
      'NCURSES_KEY_SHELP',
      'NCURSES_KEY_SHELP',
      'NCURSES_KEY_SHOME',
      'NCURSES_KEY_SHOME',
      'NCURSES_KEY_SIC',
      'NCURSES_KEY_SIC',
      'NCURSES_KEY_SLEFT',
      'NCURSES_KEY_SLEFT',
      'NCURSES_KEY_SMESSAGE',
      'NCURSES_KEY_SMESSAGE',
      'NCURSES_KEY_SMOVE',
      'NCURSES_KEY_SMOVE',
      'NCURSES_KEY_SNEXT',
      'NCURSES_KEY_SNEXT',
      'NCURSES_KEY_SOPTIONS',
      'NCURSES_KEY_SOPTIONS',
      'NCURSES_KEY_SPREVIOUS',
      'NCURSES_KEY_SPREVIOUS',
      'NCURSES_KEY_SPRINT',
      'NCURSES_KEY_SPRINT',
      'NCURSES_KEY_SR',
      'NCURSES_KEY_SR',
      'NCURSES_KEY_SREDO',
      'NCURSES_KEY_SREDO',
      'NCURSES_KEY_SREPLACE',
      'NCURSES_KEY_SREPLACE',
      'NCURSES_KEY_SRESET',
      'NCURSES_KEY_SRESET',
      'NCURSES_KEY_SRIGHT',
      'NCURSES_KEY_SRIGHT',
      'NCURSES_KEY_SRSUME',
      'NCURSES_KEY_SRSUME',
      'NCURSES_KEY_SSAVE',
      'NCURSES_KEY_SSAVE',
      'NCURSES_KEY_SSUSPEND',
      'NCURSES_KEY_SSUSPEND',
      'NCURSES_KEY_STAB',
      'NCURSES_KEY_STAB',
      'NCURSES_KEY_SUNDO',
      'NCURSES_KEY_SUNDO',
      'NCURSES_KEY_SUSPEND',
      'NCURSES_KEY_SUSPEND',
      'NCURSES_KEY_UNDO',
      'NCURSES_KEY_UNDO',
      'NCURSES_KEY_UP',
      'NCURSES_KEY_UP',
      'NCURSES_REPORT_MOUSE_POSITION',
      'NCURSES_REPORT_MOUSE_POSITION',
      'NIL',
      'NIL',
      'NOEXPR',
      'NOEXPR',
      'NULL',
      'NULL',
      'ODBC_BINMODE_CONVERT',
      'ODBC_BINMODE_CONVERT',
      'ODBC_BINMODE_PASSTHRU',
      'ODBC_BINMODE_PASSTHRU',
      'ODBC_BINMODE_RETURN',
      'ODBC_BINMODE_RETURN',
      'ODBC_TYPE',
      'ODBC_TYPE',
      'OPENSSL_ALGO_MD2',
      'OPENSSL_ALGO_MD2',
      'OPENSSL_ALGO_MD4',
      'OPENSSL_ALGO_MD4',
      'OPENSSL_ALGO_MD5',
      'OPENSSL_ALGO_MD5',
      'OPENSSL_ALGO_SHA1',
      'OPENSSL_ALGO_SHA1',
      'OPENSSL_CIPHER_3DES',
      'OPENSSL_CIPHER_3DES',
      'OPENSSL_CIPHER_DES',
      'OPENSSL_CIPHER_DES',
      'OPENSSL_CIPHER_RC2_128',
      'OPENSSL_CIPHER_RC2_128',
      'OPENSSL_CIPHER_RC2_40',
      'OPENSSL_CIPHER_RC2_40',
      'OPENSSL_CIPHER_RC2_64',
      'OPENSSL_CIPHER_RC2_64',
      'OPENSSL_KEYTYPE_DH',
      'OPENSSL_KEYTYPE_DH',
      'OPENSSL_KEYTYPE_DSA',
      'OPENSSL_KEYTYPE_DSA',
      'OPENSSL_KEYTYPE_RSA',
      'OPENSSL_KEYTYPE_RSA',
      'OPENSSL_NO_PADDING',
      'OPENSSL_NO_PADDING',
      'OPENSSL_PKCS1_OAEP_PADDING',
      'OPENSSL_PKCS1_OAEP_PADDING',
      'OPENSSL_PKCS1_PADDING',
      'OPENSSL_PKCS1_PADDING',
      'OPENSSL_SSLV23_PADDING',
      'OPENSSL_SSLV23_PADDING',
      'OP_ANONYMOUS',
      'OP_ANONYMOUS',
      'OP_DEBUG',
      'OP_DEBUG',
      'OP_EXPUNGE',
      'OP_EXPUNGE',
      'OP_HALFOPEN',
      'OP_HALFOPEN',
      'OP_PROTOTYPE',
      'OP_PROTOTYPE',
      'OP_READONLY',
      'OP_READONLY',
      'OP_SECURE',
      'OP_SECURE',
      'OP_SHORTCACHE',
      'OP_SHORTCACHE',
      'OP_SILENT',
      'OP_SILENT',
      'O_APPEND',
      'O_APPEND',
      'O_ASYNC',
      'O_ASYNC',
      'O_CREAT',
      'O_CREAT',
      'O_EXCL',
      'O_EXCL',
      'O_NDELAY',
      'O_NDELAY',
      'O_NOCTTY',
      'O_NOCTTY',
      'O_NONBLOCK',
      'O_NONBLOCK',
      'O_RDONLY',
      'O_RDONLY',
      'O_RDWR',
      'O_RDWR',
      'O_SYNC',
      'O_SYNC',
      'O_TRUNC',
      'O_TRUNC',
      'O_WRONLY',
      'O_WRONLY',
      'PATHINFO_BASENAME',
      'PATHINFO_BASENAME',
      'PATHINFO_DIRNAME',
      'PATHINFO_DIRNAME',
      'PATHINFO_EXTENSION',
      'PATHINFO_EXTENSION',
      'PATH_SEPARATOR',
      'PATH_SEPARATOR',
      'PEAR_EXTENSION_DIR',
      'PEAR_EXTENSION_DIR',
      'PEAR_INSTALL_DIR',
      'PEAR_INSTALL_DIR',
      'PGSQL_ASSOC',
      'PGSQL_ASSOC',
      'PGSQL_BAD_RESPONSE',
      'PGSQL_BAD_RESPONSE',
      'PGSQL_BOTH',
      'PGSQL_BOTH',
      'PGSQL_COMMAND_OK',
      'PGSQL_COMMAND_OK',
      'PGSQL_CONNECTION_BAD',
      'PGSQL_CONNECTION_BAD',
      'PGSQL_CONNECTION_OK',
      'PGSQL_CONNECTION_OK',
      'PGSQL_CONNECT_FORCE_NEW',
      'PGSQL_CONNECT_FORCE_NEW',
      'PGSQL_CONV_FORCE_NULL',
      'PGSQL_CONV_FORCE_NULL',
      'PGSQL_CONV_IGNORE_DEFAULT',
      'PGSQL_CONV_IGNORE_DEFAULT',
      'PGSQL_CONV_IGNORE_NOT_NULL',
      'PGSQL_CONV_IGNORE_NOT_NULL',
      'PGSQL_COPY_IN',
      'PGSQL_COPY_IN',
      'PGSQL_COPY_OUT',
      'PGSQL_COPY_OUT',
      'PGSQL_DML_ASYNC',
      'PGSQL_DML_ASYNC',
      'PGSQL_DML_EXEC',
      'PGSQL_DML_EXEC',
      'PGSQL_DML_NO_CONV',
      'PGSQL_DML_NO_CONV',
      'PGSQL_DML_STRING',
      'PGSQL_DML_STRING',
      'PGSQL_EMPTY_QUERY',
      'PGSQL_EMPTY_QUERY',
      'PGSQL_FATAL_ERROR',
      'PGSQL_FATAL_ERROR',
      'PGSQL_NONFATAL_ERROR',
      'PGSQL_NONFATAL_ERROR',
      'PGSQL_NUM',
      'PGSQL_NUM',
      'PGSQL_SEEK_CUR',
      'PGSQL_SEEK_CUR',
      'PGSQL_SEEK_END',
      'PGSQL_SEEK_END',
      'PGSQL_SEEK_SET',
      'PGSQL_SEEK_SET',
      'PGSQL_STATUS_LONG',
      'PGSQL_STATUS_LONG',
      'PGSQL_STATUS_STRING',
      'PGSQL_STATUS_STRING',
      'PGSQL_TUPLES_OK',
      'PGSQL_TUPLES_OK',
      'PHP_BINARY_READ',
      'PHP_BINARY_READ',
      'PHP_BINDIR',
      'PHP_BINDIR',
      'PHP_CONFIG_FILE_PATH',
      'PHP_CONFIG_FILE_PATH',
      'PHP_CONFIG_FILE_SCAN_DIR',
      'PHP_CONFIG_FILE_SCAN_DIR',
      'PHP_DATADIR',
      'PHP_DATADIR',
      'PHP_EOL',
      'PHP_EOL',
      'PHP_EXTENSION_DIR',
      'PHP_EXTENSION_DIR',
      'PHP_LIBDIR',
      'PHP_LIBDIR',
      'PHP_LOCALSTATEDIR',
      'PHP_LOCALSTATEDIR',
      'PHP_NORMAL_READ',
      'PHP_NORMAL_READ',
      'PHP_OS',
      'PHP_OS',
      'PHP_OUTPUT_HANDLER_CONT',
      'PHP_OUTPUT_HANDLER_CONT',
      'PHP_OUTPUT_HANDLER_END',
      'PHP_OUTPUT_HANDLER_END',
      'PHP_OUTPUT_HANDLER_START',
      'PHP_OUTPUT_HANDLER_START',
      'PHP_PREFIX',
      'PHP_PREFIX',
      'PHP_SAPI',
      'PHP_SAPI',
      'PHP_SHLIB_SUFFIX',
      'PHP_SHLIB_SUFFIX',
      'PHP_SYSCONFDIR',
      'PHP_SYSCONFDIR',
      'PHP_VERSION',
      'PHP_VERSION',
      'PKCS7_BINARY',
      'PKCS7_BINARY',
      'PKCS7_DETACHED',
      'PKCS7_DETACHED',
      'PKCS7_NOATTR',
      'PKCS7_NOATTR',
      'PKCS7_NOCERTS',
      'PKCS7_NOCERTS',
      'PKCS7_NOCHAIN',
      'PKCS7_NOCHAIN',
      'PKCS7_NOINTERN',
      'PKCS7_NOINTERN',
      'PKCS7_NOSIGS',
      'PKCS7_NOSIGS',
      'PKCS7_NOVERIFY',
      'PKCS7_NOVERIFY',
      'PKCS7_TEXT',
      'PKCS7_TEXT',
      'PM_STR',
      'PM_STR',
      'PREG_GREP_INVERT',
      'PREG_GREP_INVERT',
      'PREG_OFFSET_CAPTURE',
      'PREG_OFFSET_CAPTURE',
      'PREG_PATTERN_ORDER',
      'PREG_PATTERN_ORDER',
      'PREG_SET_ORDER',
      'PREG_SET_ORDER',
      'PREG_SPLIT_DELIM_CAPTURE',
      'PREG_SPLIT_DELIM_CAPTURE',
      'PREG_SPLIT_NO_EMPTY',
      'PREG_SPLIT_NO_EMPTY',
      'PREG_SPLIT_OFFSET_CAPTURE',
      'PREG_SPLIT_OFFSET_CAPTURE',
      'PRIO_PGRP',
      'PRIO_PGRP',
      'PRIO_PROCESS',
      'PRIO_PROCESS',
      'PRIO_USER',
      'PRIO_USER',
      'PSFS_ERR_FATAL',
      'PSFS_ERR_FATAL',
      'PSFS_FEED_ME',
      'PSFS_FEED_ME',
      'PSFS_FLAG_FLUSH_CLOSE',
      'PSFS_FLAG_FLUSH_CLOSE',
      'PSFS_FLAG_FLUSH_INC',
      'PSFS_FLAG_FLUSH_INC',
      'PSFS_FLAG_NORMAL',
      'PSFS_FLAG_NORMAL',
      'PSFS_PASS_ON',
      'PSFS_PASS_ON',
      'P_PRIVATE',
      'P_PRIVATE',
      'P_PROTECTED',
      'P_PROTECTED',
      'P_PUBLIC',
      'P_PUBLIC',
      'P_STATIC',
      'P_STATIC',
      'RADIXCHAR',
      'RADIXCHAR',
      'RIT_CHILD_FIRST',
      'RIT_CHILD_FIRST',
      'RIT_LEAVES_ONLY',
      'RIT_LEAVES_ONLY',
      'RIT_SELF_FIRST',
      'RIT_SELF_FIRST',
      'SA_ALL',
      'SA_ALL',
      'SA_MESSAGES',
      'SA_MESSAGES',
      'SA_RECENT',
      'SA_RECENT',
      'SA_UIDNEXT',
      'SA_UIDNEXT',
      'SA_UIDVALIDITY',
      'SA_UIDVALIDITY',
      'SA_UNSEEN',
      'SA_UNSEEN',
      'SEEK_CUR',
      'SEEK_CUR',
      'SEEK_END',
      'SEEK_END',
      'SEEK_SET',
      'SEEK_SET',
      'SE_FREE',
      'SE_FREE',
      'SE_NOPREFETCH',
      'SE_NOPREFETCH',
      'SE_UID',
      'SE_UID',
      'SIGABRT',
      'SIGABRT',
      'SIGALRM',
      'SIGALRM',
      'SIGBABY',
      'SIGBABY',
      'SIGBUS',
      'SIGBUS',
      'SIGCHLD',
      'SIGCHLD',
      'SIGCLD',
      'SIGCLD',
      'SIGCONT',
      'SIGCONT',
      'SIGFPE',
      'SIGFPE',
      'SIGHUP',
      'SIGHUP',
      'SIGILL',
      'SIGILL',
      'SIGINT',
      'SIGINT',
      'SIGIO',
      'SIGIO',
      'SIGIOT',
      'SIGIOT',
      'SIGKILL',
      'SIGKILL',
      'SIGPIPE',
      'SIGPIPE',
      'SIGPOLL',
      'SIGPOLL',
      'SIGPROF',
      'SIGPROF',
      'SIGPWR',
      'SIGPWR',
      'SIGQUIT',
      'SIGQUIT',
      'SIGSEGV',
      'SIGSEGV',
      'SIGSTKFLT',
      'SIGSTKFLT',
      'SIGSTOP',
      'SIGSTOP',
      'SIGSYS',
      'SIGSYS',
      'SIGTERM',
      'SIGTERM',
      'SIGTRAP',
      'SIGTRAP',
      'SIGTSTP',
      'SIGTSTP',
      'SIGTTIN',
      'SIGTTIN',
      'SIGTTOU',
      'SIGTTOU',
      'SIGURG',
      'SIGURG',
      'SIGUSR1',
      'SIGUSR1',
      'SIGUSR2',
      'SIGUSR2',
      'SIGVTALRM',
      'SIGVTALRM',
      'SIGWINCH',
      'SIGWINCH',
      'SIGXCPU',
      'SIGXCPU',
      'SIGXFSZ',
      'SIGXFSZ',
      'SIG_DFL',
      'SIG_DFL',
      'SIG_ERR',
      'SIG_ERR',
      'SIG_IGN',
      'SIG_IGN',
      'SNMP_BIT_STR',
      'SNMP_BIT_STR',
      'SNMP_COUNTER',
      'SNMP_COUNTER',
      'SNMP_COUNTER64',
      'SNMP_COUNTER64',
      'SNMP_INTEGER',
      'SNMP_INTEGER',
      'SNMP_IPADDRESS',
      'SNMP_IPADDRESS',
      'SNMP_NULL',
      'SNMP_NULL',
      'SNMP_OBJECT_ID',
      'SNMP_OBJECT_ID',
      'SNMP_OCTET_STR',
      'SNMP_OCTET_STR',
      'SNMP_OPAQUE',
      'SNMP_OPAQUE',
      'SNMP_TIMETICKS',
      'SNMP_TIMETICKS',
      'SNMP_UINTEGER',
      'SNMP_UINTEGER',
      'SNMP_UNSIGNED',
      'SNMP_UNSIGNED',
      'SNMP_VALUE_LIBRARY',
      'SNMP_VALUE_LIBRARY',
      'SNMP_VALUE_OBJECT',
      'SNMP_VALUE_OBJECT',
      'SNMP_VALUE_PLAIN',
      'SNMP_VALUE_PLAIN',
      'SOAP_1_1',
      'SOAP_1_1',
      'SOAP_1_2',
      'SOAP_1_2',
      'SOAP_ACTOR_NEXT',
      'SOAP_ACTOR_NEXT',
      'SOAP_ACTOR_NONE',
      'SOAP_ACTOR_NONE',
      'SOAP_ACTOR_UNLIMATERECEIVER',
      'SOAP_ACTOR_UNLIMATERECEIVER',
      'SOAP_COMPRESSION_ACCEPT',
      'SOAP_COMPRESSION_ACCEPT',
      'SOAP_COMPRESSION_DEFLATE',
      'SOAP_COMPRESSION_DEFLATE',
      'SOAP_COMPRESSION_GZIP',
      'SOAP_COMPRESSION_GZIP',
      'SOAP_DOCUMENT',
      'SOAP_DOCUMENT',
      'SOAP_ENCODED',
      'SOAP_ENCODED',
      'SOAP_ENC_ARRAY',
      'SOAP_ENC_ARRAY',
      'SOAP_ENC_OBJECT',
      'SOAP_ENC_OBJECT',
      'SOAP_FUNCTIONS_ALL',
      'SOAP_FUNCTIONS_ALL',
      'SOAP_LITERAL',
      'SOAP_LITERAL',
      'SOAP_PERSISTENCE_REQUEST',
      'SOAP_PERSISTENCE_REQUEST',
      'SOAP_PERSISTENCE_SESSION',
      'SOAP_PERSISTENCE_SESSION',
      'SOAP_RPC',
      'SOAP_RPC',
      'SOCKET_E2BIG',
      'SOCKET_E2BIG',
      'SOCKET_EACCES',
      'SOCKET_EACCES',
      'SOCKET_EADDRINUSE',
      'SOCKET_EADDRINUSE',
      'SOCKET_EADDRNOTAVAIL',
      'SOCKET_EADDRNOTAVAIL',
      'SOCKET_EADV',
      'SOCKET_EADV',
      'SOCKET_EAFNOSUPPORT',
      'SOCKET_EAFNOSUPPORT',
      'SOCKET_EAGAIN',
      'SOCKET_EAGAIN',
      'SOCKET_EALREADY',
      'SOCKET_EALREADY',
      'SOCKET_EBADE',
      'SOCKET_EBADE',
      'SOCKET_EBADF',
      'SOCKET_EBADF',
      'SOCKET_EBADFD',
      'SOCKET_EBADFD',
      'SOCKET_EBADMSG',
      'SOCKET_EBADMSG',
      'SOCKET_EBADR',
      'SOCKET_EBADR',
      'SOCKET_EBADRQC',
      'SOCKET_EBADRQC',
      'SOCKET_EBADSLT',
      'SOCKET_EBADSLT',
      'SOCKET_EBUSY',
      'SOCKET_EBUSY',
      'SOCKET_ECHRNG',
      'SOCKET_ECHRNG',
      'SOCKET_ECOMM',
      'SOCKET_ECOMM',
      'SOCKET_ECONNABORTED',
      'SOCKET_ECONNABORTED',
      'SOCKET_ECONNREFUSED',
      'SOCKET_ECONNREFUSED',
      'SOCKET_ECONNRESET',
      'SOCKET_ECONNRESET',
      'SOCKET_EDESTADDRREQ',
      'SOCKET_EDESTADDRREQ',
      'SOCKET_EDQUOT',
      'SOCKET_EDQUOT',
      'SOCKET_EEXIST',
      'SOCKET_EEXIST',
      'SOCKET_EFAULT',
      'SOCKET_EFAULT',
      'SOCKET_EHOSTDOWN',
      'SOCKET_EHOSTDOWN',
      'SOCKET_EHOSTUNREACH',
      'SOCKET_EHOSTUNREACH',
      'SOCKET_EIDRM',
      'SOCKET_EIDRM',
      'SOCKET_EINPROGRESS',
      'SOCKET_EINPROGRESS',
      'SOCKET_EINTR',
      'SOCKET_EINTR',
      'SOCKET_EINVAL',
      'SOCKET_EINVAL',
      'SOCKET_EIO',
      'SOCKET_EIO',
      'SOCKET_EISCONN',
      'SOCKET_EISCONN',
      'SOCKET_EISDIR',
      'SOCKET_EISDIR',
      'SOCKET_EISNAM',
      'SOCKET_EISNAM',
      'SOCKET_EL2HLT',
      'SOCKET_EL2HLT',
      'SOCKET_EL2NSYNC',
      'SOCKET_EL2NSYNC',
      'SOCKET_EL3HLT',
      'SOCKET_EL3HLT',
      'SOCKET_EL3RST',
      'SOCKET_EL3RST',
      'SOCKET_ELNRNG',
      'SOCKET_ELNRNG',
      'SOCKET_ELOOP',
      'SOCKET_ELOOP',
      'SOCKET_EMEDIUMTYPE',
      'SOCKET_EMEDIUMTYPE',
      'SOCKET_EMFILE',
      'SOCKET_EMFILE',
      'SOCKET_EMLINK',
      'SOCKET_EMLINK',
      'SOCKET_EMSGSIZE',
      'SOCKET_EMSGSIZE',
      'SOCKET_EMULTIHOP',
      'SOCKET_EMULTIHOP',
      'SOCKET_ENAMETOOLONG',
      'SOCKET_ENAMETOOLONG',
      'SOCKET_ENETDOWN',
      'SOCKET_ENETDOWN',
      'SOCKET_ENETRESET',
      'SOCKET_ENETRESET',
      'SOCKET_ENETUNREACH',
      'SOCKET_ENETUNREACH',
      'SOCKET_ENFILE',
      'SOCKET_ENFILE',
      'SOCKET_ENOANO',
      'SOCKET_ENOANO',
      'SOCKET_ENOBUFS',
      'SOCKET_ENOBUFS',
      'SOCKET_ENOCSI',
      'SOCKET_ENOCSI',
      'SOCKET_ENODATA',
      'SOCKET_ENODATA',
      'SOCKET_ENODEV',
      'SOCKET_ENODEV',
      'SOCKET_ENOENT',
      'SOCKET_ENOENT',
      'SOCKET_ENOLCK',
      'SOCKET_ENOLCK',
      'SOCKET_ENOLINK',
      'SOCKET_ENOLINK',
      'SOCKET_ENOMEDIUM',
      'SOCKET_ENOMEDIUM',
      'SOCKET_ENOMEM',
      'SOCKET_ENOMEM',
      'SOCKET_ENOMSG',
      'SOCKET_ENOMSG',
      'SOCKET_ENONET',
      'SOCKET_ENONET',
      'SOCKET_ENOPROTOOPT',
      'SOCKET_ENOPROTOOPT',
      'SOCKET_ENOSPC',
      'SOCKET_ENOSPC',
      'SOCKET_ENOSR',
      'SOCKET_ENOSR',
      'SOCKET_ENOSTR',
      'SOCKET_ENOSTR',
      'SOCKET_ENOSYS',
      'SOCKET_ENOSYS',
      'SOCKET_ENOTBLK',
      'SOCKET_ENOTBLK',
      'SOCKET_ENOTCONN',
      'SOCKET_ENOTCONN',
      'SOCKET_ENOTDIR',
      'SOCKET_ENOTDIR',
      'SOCKET_ENOTEMPTY',
      'SOCKET_ENOTEMPTY',
      'SOCKET_ENOTSOCK',
      'SOCKET_ENOTSOCK',
      'SOCKET_ENOTTY',
      'SOCKET_ENOTTY',
      'SOCKET_ENOTUNIQ',
      'SOCKET_ENOTUNIQ',
      'SOCKET_ENXIO',
      'SOCKET_ENXIO',
      'SOCKET_EOPNOTSUPP',
      'SOCKET_EOPNOTSUPP',
      'SOCKET_EPERM',
      'SOCKET_EPERM',
      'SOCKET_EPFNOSUPPORT',
      'SOCKET_EPFNOSUPPORT',
      'SOCKET_EPIPE',
      'SOCKET_EPIPE',
      'SOCKET_EPROTO',
      'SOCKET_EPROTO',
      'SOCKET_EPROTONOSUPPORT',
      'SOCKET_EPROTONOSUPPORT',
      'SOCKET_EPROTOTYPE',
      'SOCKET_EPROTOTYPE',
      'SOCKET_EREMCHG',
      'SOCKET_EREMCHG',
      'SOCKET_EREMOTE',
      'SOCKET_EREMOTE',
      'SOCKET_EREMOTEIO',
      'SOCKET_EREMOTEIO',
      'SOCKET_ERESTART',
      'SOCKET_ERESTART',
      'SOCKET_EROFS',
      'SOCKET_EROFS',
      'SOCKET_ESHUTDOWN',
      'SOCKET_ESHUTDOWN',
      'SOCKET_ESOCKTNOSUPPORT',
      'SOCKET_ESOCKTNOSUPPORT',
      'SOCKET_ESPIPE',
      'SOCKET_ESPIPE',
      'SOCKET_ESRMNT',
      'SOCKET_ESRMNT',
      'SOCKET_ESTRPIPE',
      'SOCKET_ESTRPIPE',
      'SOCKET_ETIME',
      'SOCKET_ETIME',
      'SOCKET_ETIMEDOUT',
      'SOCKET_ETIMEDOUT',
      'SOCKET_ETOOMANYREFS',
      'SOCKET_ETOOMANYREFS',
      'SOCKET_EUNATCH',
      'SOCKET_EUNATCH',
      'SOCKET_EUSERS',
      'SOCKET_EUSERS',
      'SOCKET_EWOULDBLOCK',
      'SOCKET_EWOULDBLOCK',
      'SOCKET_EXDEV',
      'SOCKET_EXDEV',
      'SOCKET_EXFULL',
      'SOCKET_EXFULL',
      'SOCK_DGRAM',
      'SOCK_DGRAM',
      'SOCK_RAW',
      'SOCK_RAW',
      'SOCK_RDM',
      'SOCK_RDM',
      'SOCK_SEQPACKET',
      'SOCK_SEQPACKET',
      'SOCK_STREAM',
      'SOCK_STREAM',
      'SOL_SOCKET',
      'SOL_SOCKET',
      'SOL_TCP',
      'SOL_TCP',
      'SOL_UDP',
      'SOL_UDP',
      'SOMAXCONN',
      'SOMAXCONN',
      'SORTARRIVAL',
      'SORTARRIVAL',
      'SORTCC',
      'SORTCC',
      'SORTDATE',
      'SORTDATE',
      'SORTFROM',
      'SORTFROM',
      'SORTSIZE',
      'SORTSIZE',
      'SORTSUBJECT',
      'SORTSUBJECT',
      'SORTTO',
      'SORTTO',
      'SORT_ASC',
      'SORT_ASC',
      'SORT_DESC',
      'SORT_DESC',
      'SORT_LOCALE_STRING',
      'SORT_LOCALE_STRING',
      'SORT_NUMERIC',
      'SORT_NUMERIC',
      'SORT_REGULAR',
      'SORT_REGULAR',
      'SORT_STRING',
      'SORT_STRING',
      'SO_BROADCAST',
      'SO_BROADCAST',
      'SO_DEBUG',
      'SO_DEBUG',
      'SO_DONTROUTE',
      'SO_DONTROUTE',
      'SO_ERROR',
      'SO_ERROR',
      'SO_FREE',
      'SO_FREE',
      'SO_KEEPALIVE',
      'SO_KEEPALIVE',
      'SO_LINGER',
      'SO_LINGER',
      'SO_NOSERVER',
      'SO_NOSERVER',
      'SO_OOBINLINE',
      'SO_OOBINLINE',
      'SO_RCVBUF',
      'SO_RCVBUF',
      'SO_RCVLOWAT',
      'SO_RCVLOWAT',
      'SO_RCVTIMEO',
      'SO_RCVTIMEO',
      'SO_REUSEADDR',
      'SO_REUSEADDR',
      'SO_SNDBUF',
      'SO_SNDBUF',
      'SO_SNDLOWAT',
      'SO_SNDLOWAT',
      'SO_SNDTIMEO',
      'SO_SNDTIMEO',
      'SO_TYPE',
      'SO_TYPE',
      'SQLITE_ABORT',
      'SQLITE_ABORT',
      'SQLITE_ASSOC',
      'SQLITE_ASSOC',
      'SQLITE_AUTH',
      'SQLITE_AUTH',
      'SQLITE_BOTH',
      'SQLITE_BOTH',
      'SQLITE_BUSY',
      'SQLITE_BUSY',
      'SQLITE_CANTOPEN',
      'SQLITE_CANTOPEN',
      'SQLITE_CONSTRAINT',
      'SQLITE_CONSTRAINT',
      'SQLITE_CORRUPT',
      'SQLITE_CORRUPT',
      'SQLITE_DONE',
      'SQLITE_DONE',
      'SQLITE_EMPTY',
      'SQLITE_EMPTY',
      'SQLITE_ERROR',
      'SQLITE_ERROR',
      'SQLITE_FORMAT',
      'SQLITE_FORMAT',
      'SQLITE_FULL',
      'SQLITE_FULL',
      'SQLITE_INTERNAL',
      'SQLITE_INTERNAL',
      'SQLITE_INTERRUPT',
      'SQLITE_INTERRUPT',
      'SQLITE_IOERR',
      'SQLITE_IOERR',
      'SQLITE_LOCKED',
      'SQLITE_LOCKED',
      'SQLITE_MISMATCH',
      'SQLITE_MISMATCH',
      'SQLITE_MISUSE',
      'SQLITE_MISUSE',
      'SQLITE_NOLFS',
      'SQLITE_NOLFS',
      'SQLITE_NOMEM',
      'SQLITE_NOMEM',
      'SQLITE_NOTFOUND',
      'SQLITE_NOTFOUND',
      'SQLITE_NUM',
      'SQLITE_NUM',
      'SQLITE_OK',
      'SQLITE_OK',
      'SQLITE_PERM',
      'SQLITE_PERM',
      'SQLITE_PROTOCOL',
      'SQLITE_PROTOCOL',
      'SQLITE_READONLY',
      'SQLITE_READONLY',
      'SQLITE_ROW',
      'SQLITE_ROW',
      'SQLITE_SCHEMA',
      'SQLITE_SCHEMA',
      'SQLITE_TOOBIG',
      'SQLITE_TOOBIG',
      'SQL_BIGINT',
      'SQL_BIGINT',
      'SQL_BINARY',
      'SQL_BINARY',
      'SQL_BIT',
      'SQL_BIT',
      'SQL_CHAR',
      'SQL_CHAR',
      'SQL_CONCURRENCY',
      'SQL_CONCURRENCY',
      'SQL_CONCUR_LOCK',
      'SQL_CONCUR_LOCK',
      'SQL_CONCUR_READ_ONLY',
      'SQL_CONCUR_READ_ONLY',
      'SQL_CONCUR_ROWVER',
      'SQL_CONCUR_ROWVER',
      'SQL_CONCUR_VALUES',
      'SQL_CONCUR_VALUES',
      'SQL_CURSOR_DYNAMIC',
      'SQL_CURSOR_DYNAMIC',
      'SQL_CURSOR_FORWARD_ONLY',
      'SQL_CURSOR_FORWARD_ONLY',
      'SQL_CURSOR_KEYSET_DRIVEN',
      'SQL_CURSOR_KEYSET_DRIVEN',
      'SQL_CURSOR_STATIC',
      'SQL_CURSOR_STATIC',
      'SQL_CURSOR_TYPE',
      'SQL_CURSOR_TYPE',
      'SQL_CUR_USE_DRIVER',
      'SQL_CUR_USE_DRIVER',
      'SQL_CUR_USE_IF_NEEDED',
      'SQL_CUR_USE_IF_NEEDED',
      'SQL_CUR_USE_ODBC',
      'SQL_CUR_USE_ODBC',
      'SQL_DATE',
      'SQL_DATE',
      'SQL_DECIMAL',
      'SQL_DECIMAL',
      'SQL_DOUBLE',
      'SQL_DOUBLE',
      'SQL_FETCH_FIRST',
      'SQL_FETCH_FIRST',
      'SQL_FETCH_NEXT',
      'SQL_FETCH_NEXT',
      'SQL_FLOAT',
      'SQL_FLOAT',
      'SQL_INTEGER',
      'SQL_INTEGER',
      'SQL_KEYSET_SIZE',
      'SQL_KEYSET_SIZE',
      'SQL_LONGVARBINARY',
      'SQL_LONGVARBINARY',
      'SQL_LONGVARCHAR',
      'SQL_LONGVARCHAR',
      'SQL_NUMERIC',
      'SQL_NUMERIC',
      'SQL_ODBC_CURSORS',
      'SQL_ODBC_CURSORS',
      'SQL_REAL',
      'SQL_REAL',
      'SQL_SMALLINT',
      'SQL_SMALLINT',
      'SQL_TIME',
      'SQL_TIME',
      'SQL_TIMESTAMP',
      'SQL_TIMESTAMP',
      'SQL_TINYINT',
      'SQL_TINYINT',
      'SQL_VARBINARY',
      'SQL_VARBINARY',
      'SQL_VARCHAR',
      'SQL_VARCHAR',
      'STREAM_CLIENT_ASYNC_CONNECT',
      'STREAM_CLIENT_ASYNC_CONNECT',
      'STREAM_CLIENT_CONNECT',
      'STREAM_CLIENT_CONNECT',
      'STREAM_CLIENT_PERSISTENT',
      'STREAM_CLIENT_PERSISTENT',
      'STREAM_ENFORCE_SAFE_MODE',
      'STREAM_ENFORCE_SAFE_MODE',
      'STREAM_FILTER_ALL',
      'STREAM_FILTER_ALL',
      'STREAM_FILTER_READ',
      'STREAM_FILTER_READ',
      'STREAM_FILTER_WRITE',
      'STREAM_FILTER_WRITE',
      'STREAM_IGNORE_URL',
      'STREAM_IGNORE_URL',
      'STREAM_MKDIR_RECURSIVE',
      'STREAM_MKDIR_RECURSIVE',
      'STREAM_MUST_SEEK',
      'STREAM_MUST_SEEK',
      'STREAM_NOTIFY_AUTH_REQUIRED',
      'STREAM_NOTIFY_AUTH_REQUIRED',
      'STREAM_NOTIFY_AUTH_RESULT',
      'STREAM_NOTIFY_AUTH_RESULT',
      'STREAM_NOTIFY_COMPLETED',
      'STREAM_NOTIFY_COMPLETED',
      'STREAM_NOTIFY_CONNECT',
      'STREAM_NOTIFY_CONNECT',
      'STREAM_NOTIFY_FAILURE',
      'STREAM_NOTIFY_FAILURE',
      'STREAM_NOTIFY_FILE_SIZE_IS',
      'STREAM_NOTIFY_FILE_SIZE_IS',
      'STREAM_NOTIFY_MIME_TYPE_IS',
      'STREAM_NOTIFY_MIME_TYPE_IS',
      'STREAM_NOTIFY_PROGRESS',
      'STREAM_NOTIFY_PROGRESS',
      'STREAM_NOTIFY_REDIRECTED',
      'STREAM_NOTIFY_REDIRECTED',
      'STREAM_NOTIFY_RESOLVE',
      'STREAM_NOTIFY_RESOLVE',
      'STREAM_NOTIFY_SEVERITY_ERR',
      'STREAM_NOTIFY_SEVERITY_ERR',
      'STREAM_NOTIFY_SEVERITY_INFO',
      'STREAM_NOTIFY_SEVERITY_INFO',
      'STREAM_NOTIFY_SEVERITY_WARN',
      'STREAM_NOTIFY_SEVERITY_WARN',
      'STREAM_OOB',
      'STREAM_OOB',
      'STREAM_PEEK',
      'STREAM_PEEK',
      'STREAM_REPORT_ERRORS',
      'STREAM_REPORT_ERRORS',
      'STREAM_SERVER_BIND',
      'STREAM_SERVER_BIND',
      'STREAM_SERVER_LISTEN',
      'STREAM_SERVER_LISTEN',
      'STREAM_URL_STAT_LINK',
      'STREAM_URL_STAT_LINK',
      'STREAM_URL_STAT_QUIET',
      'STREAM_URL_STAT_QUIET',
      'STREAM_USE_PATH',
      'STREAM_USE_PATH',
      'STR_PAD_BOTH',
      'STR_PAD_BOTH',
      'STR_PAD_LEFT',
      'STR_PAD_LEFT',
      'STR_PAD_RIGHT',
      'STR_PAD_RIGHT',
      'ST_SET',
      'ST_SET',
      'ST_SILENT',
      'ST_SILENT',
      'ST_UID',
      'ST_UID',
      'SUNFUNCS_RET_DOUBLE',
      'SUNFUNCS_RET_DOUBLE',
      'SUNFUNCS_RET_STRING',
      'SUNFUNCS_RET_STRING',
      'SUNFUNCS_RET_TIMESTAMP',
      'SUNFUNCS_RET_TIMESTAMP',
      'S_IRGRP',
      'S_IRGRP',
      'S_IROTH',
      'S_IROTH',
      'S_IRUSR',
      'S_IRUSR',
      'S_IRWXG',
      'S_IRWXG',
      'S_IRWXO',
      'S_IRWXO',
      'S_IRWXU',
      'S_IRWXU',
      'S_IWGRP',
      'S_IWGRP',
      'S_IWOTH',
      'S_IWOTH',
      'S_IWUSR',
      'S_IWUSR',
      'S_IXGRP',
      'S_IXGRP',
      'S_IXOTH',
      'S_IXOTH',
      'S_IXUSR',
      'S_IXUSR',
      'THOUSEP',
      'THOUSEP',
      'TRUE',
      'TRUE',
      'TYPEAPPLICATION',
      'TYPEAPPLICATION',
      'TYPEAUDIO',
      'TYPEAUDIO',
      'TYPEIMAGE',
      'TYPEIMAGE',
      'TYPEMESSAGE',
      'TYPEMESSAGE',
      'TYPEMODEL',
      'TYPEMODEL',
      'TYPEMULTIPART',
      'TYPEMULTIPART',
      'TYPEOTHER',
      'TYPEOTHER',
      'TYPETEXT',
      'TYPETEXT',
      'TYPEVIDEO',
      'TYPEVIDEO',
      'T_ABSTRACT',
      'T_ABSTRACT',
      'T_AND_EQUAL',
      'T_AND_EQUAL',
      'T_ARRAY',
      'T_ARRAY',
      'T_ARRAY_CAST',
      'T_ARRAY_CAST',
      'T_AS',
      'T_AS',
      'T_BAD_CHARACTER',
      'T_BAD_CHARACTER',
      'T_BOOLEAN_AND',
      'T_BOOLEAN_AND',
      'T_BOOLEAN_OR',
      'T_BOOLEAN_OR',
      'T_BOOL_CAST',
      'T_BOOL_CAST',
      'T_BREAK',
      'T_BREAK',
      'T_CASE',
      'T_CASE',
      'T_CATCH',
      'T_CATCH',
      'T_CHARACTER',
      'T_CHARACTER',
      'T_CLASS',
      'T_CLASS',
      'T_CLASS_C',
      'T_CLASS_C',
      'T_CLONE',
      'T_CLONE',
      'T_CLOSE_TAG',
      'T_CLOSE_TAG',
      'T_COMMENT',
      'T_COMMENT',
      'T_CONCAT_EQUAL',
      'T_CONCAT_EQUAL',
      'T_CONST',
      'T_CONST',
      'T_CONSTANT_ENCAPSED_STRING',
      'T_CONSTANT_ENCAPSED_STRING',
      'T_CONTINUE',
      'T_CONTINUE',
      'T_CURLY_OPEN',
      'T_CURLY_OPEN',
      'T_DEC',
      'T_DEC',
      'T_DECLARE',
      'T_DECLARE',
      'T_DEFAULT',
      'T_DEFAULT',
      'T_DIV_EQUAL',
      'T_DIV_EQUAL',
      'T_DNUMBER',
      'T_DNUMBER',
      'T_DO',
      'T_DO',
      'T_DOC_COMMENT',
      'T_DOC_COMMENT',
      'T_DOLLAR_OPEN_CURLY_BRACES',
      'T_DOLLAR_OPEN_CURLY_BRACES',
      'T_DOUBLE_ARROW',
      'T_DOUBLE_ARROW',
      'T_DOUBLE_CAST',
      'T_DOUBLE_CAST',
      'T_DOUBLE_COLON',
      'T_DOUBLE_COLON',
      'T_ECHO',
      'T_ECHO',
      'T_ELSE',
      'T_ELSE',
      'T_ELSEIF',
      'T_ELSEIF',
      'T_EMPTY',
      'T_EMPTY',
      'T_ENCAPSED_AND_WHITESPACE',
      'T_ENCAPSED_AND_WHITESPACE',
      'T_ENDDECLARE',
      'T_ENDDECLARE',
      'T_ENDFOR',
      'T_ENDFOR',
      'T_ENDFOREACH',
      'T_ENDFOREACH',
      'T_ENDIF',
      'T_ENDIF',
      'T_ENDSWITCH',
      'T_ENDSWITCH',
      'T_ENDWHILE',
      'T_ENDWHILE',
      'T_END_HEREDOC',
      'T_END_HEREDOC',
      'T_EVAL',
      'T_EVAL',
      'T_EXIT',
      'T_EXIT',
      'T_EXTENDS',
      'T_EXTENDS',
      'T_FILE',
      'T_FILE',
      'T_FINAL',
      'T_FINAL',
      'T_FMT',
      'T_FMT',
      'T_FMT_AMPM',
      'T_FMT_AMPM',
      'T_FOR',
      'T_FOR',
      'T_FOREACH',
      'T_FOREACH',
      'T_FUNCTION',
      'T_FUNCTION',
      'T_FUNC_C',
      'T_FUNC_C',
      'T_GLOBAL',
      'T_GLOBAL',
      'T_IF',
      'T_IF',
      'T_IMPLEMENTS',
      'T_IMPLEMENTS',
      'T_INC',
      'T_INC',
      'T_INCLUDE',
      'T_INCLUDE',
      'T_INCLUDE_ONCE',
      'T_INCLUDE_ONCE',
      'T_INLINE_HTML',
      'T_INLINE_HTML',
      'T_INSTANCEOF',
      'T_INSTANCEOF',
      'T_INTERFACE',
      'T_INTERFACE',
      'T_INT_CAST',
      'T_INT_CAST',
      'T_ISSET',
      'T_ISSET',
      'T_IS_EQUAL',
      'T_IS_EQUAL',
      'T_IS_GREATER_OR_EQUAL',
      'T_IS_GREATER_OR_EQUAL',
      'T_IS_IDENTICAL',
      'T_IS_IDENTICAL',
      'T_IS_NOT_EQUAL',
      'T_IS_NOT_EQUAL',
      'T_IS_NOT_IDENTICAL',
      'T_IS_NOT_IDENTICAL',
      'T_IS_SMALLER_OR_EQUAL',
      'T_IS_SMALLER_OR_EQUAL',
      'T_LINE',
      'T_LINE',
      'T_LIST',
      'T_LIST',
      'T_LNUMBER',
      'T_LNUMBER',
      'T_LOGICAL_AND',
      'T_LOGICAL_AND',
      'T_LOGICAL_OR',
      'T_LOGICAL_OR',
      'T_LOGICAL_XOR',
      'T_LOGICAL_XOR',
      'T_METHOD_C',
      'T_METHOD_C',
      'T_MINUS_EQUAL',
      'T_MINUS_EQUAL',
      'T_MOD_EQUAL',
      'T_MOD_EQUAL',
      'T_MUL_EQUAL',
      'T_MUL_EQUAL',
      'T_NEW',
      'T_NEW',
      'T_NUM_STRING',
      'T_NUM_STRING',
      'T_OBJECT_CAST',
      'T_OBJECT_CAST',
      'T_OBJECT_OPERATOR',
      'T_OBJECT_OPERATOR',
      'T_OPEN_TAG',
      'T_OPEN_TAG',
      'T_OPEN_TAG_WITH_ECHO',
      'T_OPEN_TAG_WITH_ECHO',
      'T_OR_EQUAL',
      'T_OR_EQUAL',
      'T_PAAMAYIM_NEKUDOTAYIM',
      'T_PAAMAYIM_NEKUDOTAYIM',
      'T_PLUS_EQUAL',
      'T_PLUS_EQUAL',
      'T_PRINT',
      'T_PRINT',
      'T_PRIVATE',
      'T_PRIVATE',
      'T_PROTECTED',
      'T_PROTECTED',
      'T_PUBLIC',
      'T_PUBLIC',
      'T_REQUIRE',
      'T_REQUIRE',
      'T_REQUIRE_ONCE',
      'T_REQUIRE_ONCE',
      'T_RETURN',
      'T_RETURN',
      'T_SL',
      'T_SL',
      'T_SL_EQUAL',
      'T_SL_EQUAL',
      'T_SR',
      'T_SR',
      'T_SR_EQUAL',
      'T_SR_EQUAL',
      'T_START_HEREDOC',
      'T_START_HEREDOC',
      'T_STATIC',
      'T_STATIC',
      'T_STRING',
      'T_STRING',
      'T_STRING_CAST',
      'T_STRING_CAST',
      'T_STRING_VARNAME',
      'T_STRING_VARNAME',
      'T_SWITCH',
      'T_SWITCH',
      'T_THROW',
      'T_THROW',
      'T_TRY',
      'T_TRY',
      'T_UNSET',
      'T_UNSET',
      'T_UNSET_CAST',
      'T_UNSET_CAST',
      'T_USE',
      'T_USE',
      'T_VAR',
      'T_VAR',
      'T_VARIABLE',
      'T_VARIABLE',
      'T_WHILE',
      'T_WHILE',
      'T_WHITESPACE',
      'T_WHITESPACE',
      'T_XOR_EQUAL',
      'T_XOR_EQUAL',
      'UNKNOWN_TYPE',
      'UNKNOWN_TYPE',
      'UPLOAD_ERR_FORM_SIZE',
      'UPLOAD_ERR_FORM_SIZE',
      'UPLOAD_ERR_INI_SIZE',
      'UPLOAD_ERR_INI_SIZE',
      'UPLOAD_ERR_NO_FILE',
      'UPLOAD_ERR_NO_FILE',
      'UPLOAD_ERR_NO_TMP_DIR',
      'UPLOAD_ERR_NO_TMP_DIR',
      'UPLOAD_ERR_OK',
      'UPLOAD_ERR_OK',
      'UPLOAD_ERR_PARTIAL',
      'UPLOAD_ERR_PARTIAL',
      'WNOHANG',
      'WNOHANG',
      'WUNTRACED',
      'WUNTRACED',
      'X509_PURPOSE_ANY',
      'X509_PURPOSE_ANY',
      'X509_PURPOSE_CRL_SIGN',
      'X509_PURPOSE_CRL_SIGN',
      'X509_PURPOSE_NS_SSL_SERVER',
      'X509_PURPOSE_NS_SSL_SERVER',
      'X509_PURPOSE_SMIME_ENCRYPT',
      'X509_PURPOSE_SMIME_ENCRYPT',
      'X509_PURPOSE_SMIME_SIGN',
      'X509_PURPOSE_SMIME_SIGN',
      'X509_PURPOSE_SSL_CLIENT',
      'X509_PURPOSE_SSL_CLIENT',
      'X509_PURPOSE_SSL_SERVER',
      'X509_PURPOSE_SSL_SERVER',
      'XML_ATTRIBUTE_CDATA',
      'XML_ATTRIBUTE_CDATA',
      'XML_ATTRIBUTE_DECL_NODE',
      'XML_ATTRIBUTE_DECL_NODE',
      'XML_ATTRIBUTE_ENTITY',
      'XML_ATTRIBUTE_ENTITY',
      'XML_ATTRIBUTE_ENUMERATION',
      'XML_ATTRIBUTE_ENUMERATION',
      'XML_ATTRIBUTE_ID',
      'XML_ATTRIBUTE_ID',
      'XML_ATTRIBUTE_IDREF',
      'XML_ATTRIBUTE_IDREF',
      'XML_ATTRIBUTE_IDREFS',
      'XML_ATTRIBUTE_IDREFS',
      'XML_ATTRIBUTE_NMTOKEN',
      'XML_ATTRIBUTE_NMTOKEN',
      'XML_ATTRIBUTE_NMTOKENS',
      'XML_ATTRIBUTE_NMTOKENS',
      'XML_ATTRIBUTE_NODE',
      'XML_ATTRIBUTE_NODE',
      'XML_ATTRIBUTE_NOTATION',
      'XML_ATTRIBUTE_NOTATION',
      'XML_CDATA_SECTION_NODE',
      'XML_CDATA_SECTION_NODE',
      'XML_COMMENT_NODE',
      'XML_COMMENT_NODE',
      'XML_DOCUMENT_FRAG_NODE',
      'XML_DOCUMENT_FRAG_NODE',
      'XML_DOCUMENT_NODE',
      'XML_DOCUMENT_NODE',
      'XML_DOCUMENT_TYPE_NODE',
      'XML_DOCUMENT_TYPE_NODE',
      'XML_DTD_NODE',
      'XML_DTD_NODE',
      'XML_ELEMENT_DECL_NODE',
      'XML_ELEMENT_DECL_NODE',
      'XML_ELEMENT_NODE',
      'XML_ELEMENT_NODE',
      'XML_ENTITY_DECL_NODE',
      'XML_ENTITY_DECL_NODE',
      'XML_ENTITY_NODE',
      'XML_ENTITY_NODE',
      'XML_ENTITY_REF_NODE',
      'XML_ENTITY_REF_NODE',
      'XML_ERROR_ASYNC_ENTITY',
      'XML_ERROR_ASYNC_ENTITY',
      'XML_ERROR_ATTRIBUTE_EXTERNAL_ENTITY_REF',
      'XML_ERROR_ATTRIBUTE_EXTERNAL_ENTITY_REF',
      'XML_ERROR_BAD_CHAR_REF',
      'XML_ERROR_BAD_CHAR_REF',
      'XML_ERROR_BINARY_ENTITY_REF',
      'XML_ERROR_BINARY_ENTITY_REF',
      'XML_ERROR_DUPLICATE_ATTRIBUTE',
      'XML_ERROR_DUPLICATE_ATTRIBUTE',
      'XML_ERROR_EXTERNAL_ENTITY_HANDLING',
      'XML_ERROR_EXTERNAL_ENTITY_HANDLING',
      'XML_ERROR_INCORRECT_ENCODING',
      'XML_ERROR_INCORRECT_ENCODING',
      'XML_ERROR_INVALID_TOKEN',
      'XML_ERROR_INVALID_TOKEN',
      'XML_ERROR_JUNK_AFTER_DOC_ELEMENT',
      'XML_ERROR_JUNK_AFTER_DOC_ELEMENT',
      'XML_ERROR_MISPLACED_XML_PI',
      'XML_ERROR_MISPLACED_XML_PI',
      'XML_ERROR_NONE',
      'XML_ERROR_NONE',
      'XML_ERROR_NO_ELEMENTS',
      'XML_ERROR_NO_ELEMENTS',
      'XML_ERROR_NO_MEMORY',
      'XML_ERROR_NO_MEMORY',
      'XML_ERROR_PARAM_ENTITY_REF',
      'XML_ERROR_PARAM_ENTITY_REF',
      'XML_ERROR_PARTIAL_CHAR',
      'XML_ERROR_PARTIAL_CHAR',
      'XML_ERROR_RECURSIVE_ENTITY_REF',
      'XML_ERROR_RECURSIVE_ENTITY_REF',
      'XML_ERROR_SYNTAX',
      'XML_ERROR_SYNTAX',
      'XML_ERROR_TAG_MISMATCH',
      'XML_ERROR_TAG_MISMATCH',
      'XML_ERROR_UNCLOSED_CDATA_SECTION',
      'XML_ERROR_UNCLOSED_CDATA_SECTION',
      'XML_ERROR_UNCLOSED_TOKEN',
      'XML_ERROR_UNCLOSED_TOKEN',
      'XML_ERROR_UNDEFINED_ENTITY',
      'XML_ERROR_UNDEFINED_ENTITY',
      'XML_ERROR_UNKNOWN_ENCODING',
      'XML_ERROR_UNKNOWN_ENCODING',
      'XML_HTML_DOCUMENT_NODE',
      'XML_HTML_DOCUMENT_NODE',
      'XML_LOCAL_NAMESPACE',
      'XML_LOCAL_NAMESPACE',
      'XML_NAMESPACE_DECL_NODE',
      'XML_NAMESPACE_DECL_NODE',
      'XML_NOTATION_NODE',
      'XML_NOTATION_NODE',
      'XML_OPTION_CASE_FOLDING',
      'XML_OPTION_CASE_FOLDING',
      'XML_OPTION_SKIP_TAGSTART',
      'XML_OPTION_SKIP_TAGSTART',
      'XML_OPTION_SKIP_WHITE',
      'XML_OPTION_SKIP_WHITE',
      'XML_OPTION_TARGET_ENCODING',
      'XML_OPTION_TARGET_ENCODING',
      'XML_PI_NODE',
      'XML_PI_NODE',
      'XML_SAX_IMPL',
      'XML_SAX_IMPL',
      'XML_TEXT_NODE',
      'XML_TEXT_NODE',
      'XSD_1999_NAMESPACE',
      'XSD_1999_NAMESPACE',
      'XSD_1999_TIMEINSTANT',
      'XSD_1999_TIMEINSTANT',
      'XSD_ANYTYPE',
      'XSD_ANYTYPE',
      'XSD_ANYURI',
      'XSD_ANYURI',
      'XSD_BASE64BINARY',
      'XSD_BASE64BINARY',
      'XSD_BOOLEAN',
      'XSD_BOOLEAN',
      'XSD_BYTE',
      'XSD_BYTE',
      'XSD_DATE',
      'XSD_DATE',
      'XSD_DATETIME',
      'XSD_DATETIME',
      'XSD_DECIMAL',
      'XSD_DECIMAL',
      'XSD_DOUBLE',
      'XSD_DOUBLE',
      'XSD_DURATION',
      'XSD_DURATION',
      'XSD_ENTITIES',
      'XSD_ENTITIES',
      'XSD_ENTITY',
      'XSD_ENTITY',
      'XSD_FLOAT',
      'XSD_FLOAT',
      'XSD_GDAY',
      'XSD_GDAY',
      'XSD_GMONTH',
      'XSD_GMONTH',
      'XSD_GMONTHDAY',
      'XSD_GMONTHDAY',
      'XSD_GYEAR',
      'XSD_GYEAR',
      'XSD_GYEARMONTH',
      'XSD_GYEARMONTH',
      'XSD_HEXBINARY',
      'XSD_HEXBINARY',
      'XSD_ID',
      'XSD_ID',
      'XSD_IDREF',
      'XSD_IDREF',
      'XSD_IDREFS',
      'XSD_IDREFS',
      'XSD_INT',
      'XSD_INT',
      'XSD_INTEGER',
      'XSD_INTEGER',
      'XSD_LANGUAGE',
      'XSD_LANGUAGE',
      'XSD_LONG',
      'XSD_LONG',
      'XSD_NAME',
      'XSD_NAME',
      'XSD_NAMESPACE',
      'XSD_NAMESPACE',
      'XSD_NCNAME',
      'XSD_NCNAME',
      'XSD_NEGATIVEINTEGER',
      'XSD_NEGATIVEINTEGER',
      'XSD_NMTOKEN',
      'XSD_NMTOKEN',
      'XSD_NMTOKENS',
      'XSD_NMTOKENS',
      'XSD_NONNEGATIVEINTEGER',
      'XSD_NONNEGATIVEINTEGER',
      'XSD_NONPOSITIVEINTEGER',
      'XSD_NONPOSITIVEINTEGER',
      'XSD_NORMALIZEDSTRING',
      'XSD_NORMALIZEDSTRING',
      'XSD_NOTATION',
      'XSD_NOTATION',
      'XSD_POSITIVEINTEGER',
      'XSD_POSITIVEINTEGER',
      'XSD_QNAME',
      'XSD_QNAME',
      'XSD_SHORT',
      'XSD_SHORT',
      'XSD_STRING',
      'XSD_STRING',
      'XSD_TIME',
      'XSD_TIME',
      'XSD_TOKEN',
      'XSD_TOKEN',
      'XSD_UNSIGNEDBYTE',
      'XSD_UNSIGNEDBYTE',
      'XSD_UNSIGNEDINT',
      'XSD_UNSIGNEDINT',
      'XSD_UNSIGNEDLONG',
      'XSD_UNSIGNEDLONG',
      'XSD_UNSIGNEDSHORT',
      'XSD_UNSIGNEDSHORT',
      'XSL_CLONE_ALWAYS',
      'XSL_CLONE_ALWAYS',
      'XSL_CLONE_AUTO',
      'XSL_CLONE_AUTO',
      'XSL_CLONE_NEVER',
      'XSL_CLONE_NEVER',
      'YESEXPR',
      'YESEXPR',
      'YPERR_BADARGS',
      'YPERR_BADARGS',
      'YPERR_BADDB',
      'YPERR_BADDB',
      'YPERR_BUSY',
      'YPERR_BUSY',
      'YPERR_DOMAIN',
      'YPERR_DOMAIN',
      'YPERR_KEY',
      'YPERR_KEY',
      'YPERR_MAP',
      'YPERR_MAP',
      'YPERR_NODOM',
      'YPERR_NODOM',
      'YPERR_NOMORE',
      'YPERR_NOMORE',
      'YPERR_PMAP',
      'YPERR_PMAP',
      'YPERR_RESRC',
      'YPERR_RESRC',
      'YPERR_RPC',
      'YPERR_RPC',
      'YPERR_VERS',
      'YPERR_VERS',
      'YPERR_YPBIND',
      'YPERR_YPBIND',
      'YPERR_YPERR',
      'YPERR_YPERR',
      'YPERR_YPSERV',
      'YPERR_YPSERV',
      'ZEND_THREAD_SAFE',
      'ZEND_THREAD_SAFE',
      '__FILE__',
      '__LINE__',
      '__autoload',
      '__construct',
      '__destruct',
      '__get',
      '__set',
      'abstract',
      'catch',
      'class',
      'const',
      'default',
      'extends',
      'final',
      'function',
      'implements',
      'interface',
      'new',
      'parent',
      'private',
      'protected',
      'public',
      'self',
      'static',
      'throw',
      'try',
      'var',
   );
   $self->contextdata({
      'doblequotestring' => {
         callback => \&parsedoblequotestring,
         attribute => 'String',
      },
      'heredoc' => {
         callback => \&parseheredoc,
         attribute => 'String',
         dynamic => 1,
      },
      'onelinecomment' => {
         callback => \&parseonelinecomment,
         attribute => 'Comment',
         lineending => '#pop',
      },
      'phpsource' => {
         callback => \&parsephpsource,
         attribute => 'PHP Text',
      },
      'singlequotestring' => {
         callback => \&parsesinglequotestring,
         attribute => 'String',
      },
      'start' => {
         callback => \&parsestart,
         attribute => 'Normal Text',
      },
      'twolinecomment' => {
         callback => \&parsetwolinecomment,
         attribute => 'Comment',
      },
   });
   $self->deliminators('\\s||\\.|\\(|\\)|:|\\!|\\+|,|-|<|=|>|\\%|\\&|\\*|\\/|;|\\?|\\[|\\]|\\^|\\{|\\||\\}|\\~|\\\\');
   $self->basecontext('start');
   $self->keywordscase(0);
   $self->initialize;
   bless ($self, $class);
   return $self;
}

sub language {
   return 'PHP/PHP';
}

sub parsedoblequotestring {
   my ($self, $text) = @_;
   # attribute => 'Backslash Code'
   # char => '\'
   # char1 => '"'
   # context => '#stay'
   # type => 'Detect2Chars'
   if ($self->testDetect2Chars($text, '\\', '"', 0, 0, 0, undef, 0, '#stay', 'Backslash Code')) {
      return 1
   }
   # attribute => 'Backslash Code'
   # char => '\'
   # char1 => '\'
   # context => '#stay'
   # type => 'Detect2Chars'
   if ($self->testDetect2Chars($text, '\\', '\\', 0, 0, 0, undef, 0, '#stay', 'Backslash Code')) {
      return 1
   }
   # attribute => 'Backslash Code'
   # char => '\'
   # char1 => 'n'
   # context => '#stay'
   # type => 'Detect2Chars'
   if ($self->testDetect2Chars($text, '\\', 'n', 0, 0, 0, undef, 0, '#stay', 'Backslash Code')) {
      return 1
   }
   # attribute => 'Backslash Code'
   # char => '\'
   # char1 => 'r'
   # context => '#stay'
   # type => 'Detect2Chars'
   if ($self->testDetect2Chars($text, '\\', 'r', 0, 0, 0, undef, 0, '#stay', 'Backslash Code')) {
      return 1
   }
   # attribute => 'Backslash Code'
   # char => '\'
   # char1 => 't'
   # context => '#stay'
   # type => 'Detect2Chars'
   if ($self->testDetect2Chars($text, '\\', 't', 0, 0, 0, undef, 0, '#stay', 'Backslash Code')) {
      return 1
   }
   # attribute => 'Backslash Code'
   # char => '\'
   # char1 => '$'
   # context => '#stay'
   # type => 'Detect2Chars'
   if ($self->testDetect2Chars($text, '\\', '$', 0, 0, 0, undef, 0, '#stay', 'Backslash Code')) {
      return 1
   }
   # String => '\\[0-7]{1,3}'
   # attribute => 'Backslash Code'
   # context => '#stay'
   # type => 'RegExpr'
   if ($self->testRegExpr($text, '\\\\[0-7]{1,3}', 0, 0, 0, undef, 0, '#stay', 'Backslash Code')) {
      return 1
   }
   # String => '\\x[0-9A-Fa-f]{1,2}'
   # attribute => 'Backslash Code'
   # context => '#stay'
   # type => 'RegExpr'
   if ($self->testRegExpr($text, '\\\\x[0-9A-Fa-f]{1,2}', 0, 0, 0, undef, 0, '#stay', 'Backslash Code')) {
      return 1
   }
   # String => '\$[a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*(\[[a-zA-Z0-9_]*\])*'
   # attribute => 'Variable'
   # context => '#stay'
   # type => 'RegExpr'
   if ($self->testRegExpr($text, '\\$[a-zA-Z_\\x7f-\\xff][a-zA-Z0-9_\\x7f-\\xff]*(\\[[a-zA-Z0-9_]*\\])*', 0, 0, 0, undef, 0, '#stay', 'Variable')) {
      return 1
   }
   # String => '\$\{[a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*(\[[a-zA-Z0-9_]*\])*\}'
   # attribute => 'Variable'
   # context => '#stay'
   # type => 'RegExpr'
   if ($self->testRegExpr($text, '\\$\\{[a-zA-Z_\\x7f-\\xff][a-zA-Z0-9_\\x7f-\\xff]*(\\[[a-zA-Z0-9_]*\\])*\\}', 0, 0, 0, undef, 0, '#stay', 'Variable')) {
      return 1
   }
   # String => '\{\$[a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*(\[([0-9]*|"[^"]*")|'[^']*'|\])*(->[a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*(\[[a-zA-Z0-9_]*\])*(\[([0-9]*|"[a-zA-Z_]*")|'[a-zA-Z_]*'|\])*)*\}'
   # attribute => 'Variable'
   # context => '#stay'
   # type => 'RegExpr'
   if ($self->testRegExpr($text, '\\{\\$[a-zA-Z_\\x7f-\\xff][a-zA-Z0-9_\\x7f-\\xff]*(\\[([0-9]*|"[^"]*")|\'[^\']*\'|\\])*(->[a-zA-Z_\\x7f-\\xff][a-zA-Z0-9_\\x7f-\\xff]*(\\[[a-zA-Z0-9_]*\\])*(\\[([0-9]*|"[a-zA-Z_]*")|\'[a-zA-Z_]*\'|\\])*)*\\}', 0, 0, 0, undef, 0, '#stay', 'Variable')) {
      return 1
   }
   # attribute => 'String'
   # char => '"'
   # context => '#pop'
   # type => 'DetectChar'
   if ($self->testDetectChar($text, '"', 0, 0, 0, undef, 0, '#pop', 'String')) {
      return 1
   }
   return 0;
};

sub parseheredoc {
   my ($self, $text) = @_;
   # String => '^%1;?$'
   # attribute => 'Backslash Code'
   # context => '#pop'
   # dynamic => 'true'
   # type => 'RegExpr'
   if ($self->testRegExpr($text, '^%1;?$', 0, 1, 0, undef, 0, '#pop', 'Backslash Code')) {
      return 1
   }
   # String => '\$[a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*(\[[a-zA-Z0-9_]*\])*'
   # attribute => 'Variable'
   # context => '#stay'
   # type => 'RegExpr'
   if ($self->testRegExpr($text, '\\$[a-zA-Z_\\x7f-\\xff][a-zA-Z0-9_\\x7f-\\xff]*(\\[[a-zA-Z0-9_]*\\])*', 0, 0, 0, undef, 0, '#stay', 'Variable')) {
      return 1
   }
   # String => '\$\{[a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*(\[[a-zA-Z0-9_]*\])*\}'
   # attribute => 'Variable'
   # context => '#stay'
   # type => 'RegExpr'
   if ($self->testRegExpr($text, '\\$\\{[a-zA-Z_\\x7f-\\xff][a-zA-Z0-9_\\x7f-\\xff]*(\\[[a-zA-Z0-9_]*\\])*\\}', 0, 0, 0, undef, 0, '#stay', 'Variable')) {
      return 1
   }
   # String => '\{\$[a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*(\[([0-9]*|"[a-zA-Z_]*")|'[a-zA-Z_]*'|\])*(->[a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*(\[[a-zA-Z0-9_]*\])*(\[([0-9]*|"[a-zA-Z_]*")|'[a-zA-Z_]*'|\])*)*\}'
   # attribute => 'Variable'
   # context => '#stay'
   # type => 'RegExpr'
   if ($self->testRegExpr($text, '\\{\\$[a-zA-Z_\\x7f-\\xff][a-zA-Z0-9_\\x7f-\\xff]*(\\[([0-9]*|"[a-zA-Z_]*")|\'[a-zA-Z_]*\'|\\])*(->[a-zA-Z_\\x7f-\\xff][a-zA-Z0-9_\\x7f-\\xff]*(\\[[a-zA-Z0-9_]*\\])*(\\[([0-9]*|"[a-zA-Z_]*")|\'[a-zA-Z_]*\'|\\])*)*\\}', 0, 0, 0, undef, 0, '#stay', 'Variable')) {
      return 1
   }
   return 0;
};

sub parseonelinecomment {
   my ($self, $text) = @_;
   # String => '?>'
   # attribute => 'Keyword'
   # context => '#pop'
   # lookAhead => 'true'
   # type => 'StringDetect'
   if ($self->testStringDetect($text, '?>', 0, 0, 1, undef, 0, '#pop', 'Keyword')) {
      return 1
   }
   return 0;
};

sub parsephpsource {
   my ($self, $text) = @_;
   # type => 'DetectSpaces'
   if ($self->testDetectSpaces($text, 0, undef, 0, '#stay', undef)) {
      return 1
   }
   # String => '?>'
   # attribute => 'Keyword'
   # context => '#pop#pop'
   # endRegion => 'php'
   # type => 'StringDetect'
   if ($self->testStringDetect($text, '?>', 0, 0, 0, undef, 0, '#pop#pop', 'Keyword')) {
      return 1
   }
   # attribute => 'Comment'
   # char => '#'
   # context => 'onelinecomment'
   # type => 'DetectChar'
   if ($self->testDetectChar($text, '#', 0, 0, 0, undef, 0, 'onelinecomment', 'Comment')) {
      return 1
   }
   # context => '##Doxygen'
   # type => 'IncludeRules'
   if ($self->includePlugin('Doxygen', $text)) {
      return 1
   }
   # attribute => 'Comment'
   # char => '/'
   # char1 => '/'
   # context => 'onelinecomment'
   # type => 'Detect2Chars'
   if ($self->testDetect2Chars($text, '/', '/', 0, 0, 0, undef, 0, 'onelinecomment', 'Comment')) {
      return 1
   }
   # attribute => 'Comment'
   # beginRegion => 'Comment'
   # char => '/'
   # char1 => '*'
   # context => 'twolinecomment'
   # type => 'Detect2Chars'
   if ($self->testDetect2Chars($text, '/', '*', 0, 0, 0, undef, 0, 'twolinecomment', 'Comment')) {
      return 1
   }
   # String => 'control structures'
   # attribute => 'Control Structures'
   # context => '#stay'
   # type => 'keyword'
   if ($self->testKeyword($text, 'control structures', 0, undef, 0, '#stay', 'Control Structures')) {
      return 1
   }
   # String => 'keywords'
   # attribute => 'Keyword'
   # context => '#stay'
   # type => 'keyword'
   if ($self->testKeyword($text, 'keywords', 0, undef, 0, '#stay', 'Keyword')) {
      return 1
   }
   # String => 'functions'
   # attribute => 'Function'
   # context => '#stay'
   # type => 'keyword'
   if ($self->testKeyword($text, 'functions', 0, undef, 0, '#stay', 'Function')) {
      return 1
   }
   # type => 'DetectIdentifier'
   if ($self->testDetectIdentifier($text, 0, undef, 0, '#stay', undef)) {
      return 1
   }
   # attribute => 'String'
   # char => '"'
   # context => 'doblequotestring'
   # type => 'DetectChar'
   if ($self->testDetectChar($text, '"', 0, 0, 0, undef, 0, 'doblequotestring', 'String')) {
      return 1
   }
   # attribute => 'String'
   # char => '''
   # context => 'singlequotestring'
   # type => 'DetectChar'
   if ($self->testDetectChar($text, '\'', 0, 0, 0, undef, 0, 'singlequotestring', 'String')) {
      return 1
   }
   # String => '<<<([A-Za-z_][A-Za-z0-9_]*)'
   # attribute => 'Backslash Code'
   # context => 'heredoc'
   # type => 'RegExpr'
   if ($self->testRegExpr($text, '<<<([A-Za-z_][A-Za-z0-9_]*)', 0, 0, 0, undef, 0, 'heredoc', 'Backslash Code')) {
      return 1
   }
   # String => '\$+[a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*'
   # attribute => 'Variable'
   # context => '#stay'
   # type => 'RegExpr'
   if ($self->testRegExpr($text, '\\$+[a-zA-Z_\\x7f-\\xff][a-zA-Z0-9_\\x7f-\\xff]*', 0, 0, 0, undef, 0, '#stay', 'Variable')) {
      return 1
   }
   # String => '[0123456789]*\.\.\.[0123456789]*'
   # attribute => 'String'
   # context => '#stay'
   # type => 'RegExpr'
   if ($self->testRegExpr($text, '[0123456789]*\\.\\.\\.[0123456789]*', 0, 0, 0, undef, 0, '#stay', 'String')) {
      return 1
   }
   # attribute => 'Octal'
   # context => '#stay'
   # type => 'HlCOct'
   if ($self->testHlCOct($text, 0, undef, 0, '#stay', 'Octal')) {
      return 1
   }
   # attribute => 'Hex'
   # context => '#stay'
   # type => 'HlCHex'
   if ($self->testHlCHex($text, 0, undef, 0, '#stay', 'Hex')) {
      return 1
   }
   # attribute => 'Float'
   # context => '#stay'
   # type => 'Float'
   if ($self->testFloat($text, 0, undef, 0, '#stay', 'Float')) {
      return 1
   }
   # attribute => 'Decimal'
   # context => '#stay'
   # type => 'Int'
   if ($self->testInt($text, 0, undef, 0, '#stay', 'Decimal')) {
      return 1
   }
   # attribute => 'Normal Text'
   # beginRegion => 'Brace1'
   # char => '{'
   # context => '#stay'
   # type => 'DetectChar'
   if ($self->testDetectChar($text, '{', 0, 0, 0, undef, 0, '#stay', 'Normal Text')) {
      return 1
   }
   # attribute => 'Normal Text'
   # char => '}'
   # context => '#stay'
   # endRegion => 'Brace1'
   # type => 'DetectChar'
   if ($self->testDetectChar($text, '}', 0, 0, 0, undef, 0, '#stay', 'Normal Text')) {
      return 1
   }
   # String => ';()}{:,[]'
   # attribute => 'Other'
   # context => '#stay'
   # type => 'AnyChar'
   if ($self->testAnyChar($text, ';()}{:,[]', 0, 0, undef, 0, '#stay', 'Other')) {
      return 1
   }
   return 0;
};

sub parsesinglequotestring {
   my ($self, $text) = @_;
   # attribute => 'Backslash Code'
   # char => '\'
   # char1 => '''
   # context => '#stay'
   # type => 'Detect2Chars'
   if ($self->testDetect2Chars($text, '\\', '\'', 0, 0, 0, undef, 0, '#stay', 'Backslash Code')) {
      return 1
   }
   # attribute => 'Backslash Code'
   # char => '\'
   # char1 => '\'
   # context => '#stay'
   # type => 'Detect2Chars'
   if ($self->testDetect2Chars($text, '\\', '\\', 0, 0, 0, undef, 0, '#stay', 'Backslash Code')) {
      return 1
   }
   # attribute => 'String'
   # char => '''
   # context => '#pop'
   # type => 'DetectChar'
   if ($self->testDetectChar($text, '\'', 0, 0, 0, undef, 0, '#pop', 'String')) {
      return 1
   }
   return 0;
};

sub parsestart {
   my ($self, $text) = @_;
   # String => '<\?(?:=|php)?'
   # attribute => 'Keyword'
   # beginRegion => 'php'
   # context => 'phpsource'
   # type => 'RegExpr'
   if ($self->testRegExpr($text, '<\\?(?:=|php)?', 0, 0, 0, undef, 0, 'phpsource', 'Keyword')) {
      return 1
   }
   return 0;
};

sub parsetwolinecomment {
   my ($self, $text) = @_;
   # attribute => 'Comment'
   # char => '*'
   # char1 => '/'
   # context => '#pop'
   # endRegion => 'Comment'
   # type => 'Detect2Chars'
   if ($self->testDetect2Chars($text, '*', '/', 0, 0, 0, undef, 0, '#pop', 'Comment')) {
      return 1
   }
   return 0;
};


1;

__END__

=head1 NAME

Syntax::Highlight::Engine::Kate::PHP_PHP - a Plugin for PHP/PHP syntax highlighting

=head1 SYNOPSIS

 require Syntax::Highlight::Engine::Kate::PHP_PHP;
 my $sh = new Syntax::Highlight::Engine::Kate::PHP_PHP([
 ]);

=head1 DESCRIPTION

Syntax::Highlight::Engine::Kate::PHP_PHP is a  plugin module that provides syntax highlighting
for PHP/PHP to the Syntax::Haghlight::Engine::Kate highlighting engine.

This code is generated from the syntax definition files used
by the Kate project.
It works quite fine, but can use refinement and optimization.

It inherits Syntax::Higlight::Engine::Kate::Template. See also there.

=head1 AUTHOR

Hans Jeuken (haje <at> toneel <dot> demon <dot> nl)

=head1 BUGS

Unknown. If you find any, please contact the author