## no critic: TestingAndDebugging::RequireStrict
package Sah::SchemaR::date::dow_name::id;

our $DATE = '2022-10-20'; # DATE
our $VERSION = '0.008'; # VERSION

our $rschema = do{my$var={base=>"cistr",clsets_after_base=>[{description=>"\nSee also related schemas for other locales, e.g.\n<pm:Sah::Schema::date::dow_name::en> (English),\n<pm:Sah::Schema::date::dow_name::en_or_id> (English/Indonesian), etc.\n\n",examples=>[{summary=>"Empty string",valid=>0,value=>""},{valid=>1,value=>"mg"},{valid=>1,value=>"min"},{valid=>1,value=>"minggu"},{summary=>"English",valid=>0,value=>"sun"},{summary=>"Not a name",valid=>0,value=>1}],in=>["mg","sn","sl","rb","km","jm","sb","min","sen","sel","rab","kam","jum","sab","minggu","senin","selasa","rabu","kamis","jumat","sabtu"],summary=>"Day-of-week name (abbreviated or full, in Indonesian), e.g. \"min\" or \"Sabtu\""}],clsets_after_type=>['$var->{clsets_after_base}[0]'],"clsets_after_type.alt.merge.merged"=>['$var->{clsets_after_base}[0]'],resolve_path=>["cistr"],type=>"cistr",v=>2};$var->{clsets_after_type}[0]=$var->{clsets_after_base}[0];$var->{"clsets_after_type.alt.merge.merged"}[0]=$var->{clsets_after_base}[0];$var};

1;
# ABSTRACT: Day-of-week name (abbreviated or full, in Indonesian), e.g. "min" or "Sabtu"

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::date::dow_name::id - Day-of-week name (abbreviated or full, in Indonesian), e.g. "min" or "Sabtu"

=head1 VERSION

This document describes version 0.008 of Sah::SchemaR::date::dow_name::id (from Perl distribution Sah-Schemas-Date-ID), released on 2022-10-20.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::Schemas during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-Date-ID>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-Date-ID>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2022, 2020, 2019 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-Date-ID>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
