use strict;
use warnings;
use Test::More tests => 68;
use Digest::ECHO qw(echo_512 echo_512_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::ECHO->new(512)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            echo_512_hex($data), $digest,
            "echo_512_hex: $len bits of $msg"
        );
        ok(
            echo_512($data) eq pack('H*', $digest),
            "echo_512: $len bits of $msg"
        );
    }

    my $md = Digest::ECHO->new(512)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $msg");
}
continue { $len++ }

__DATA__
00|158F58CC79D300A9AA292515049275D051A28AB931726D0EC44BDD9FAEF4A702C36DB9E7922FFF077402236465833C5CC76AF4EFC352B4B44C7FA15AA0EF234E
00|E7DC9285A0A9E429DA818FFACCC8DA0AEB2FFB17FD509927690EC5A496626C1EBDA5C252953F5843E478117BE9E7C96943497F836277317792B53AC30AA84A29
C0|9CFA4A6A9848C41C25E182B18C23376AC87E76D6B89E0EE90250B8F6F0A58740E0631848D310A8E7BF350AAF0141CB0052FA9D52D785D6DE74A252A422D796D2
C0|5FE65EC2334E81A7CCCF7FA972880658AAD254C4AB7E5418EC481746D5F2F344E5BDF7EBE7EAB3532E44B15F4B8DF00204BA44AB48EE059DB4BC3CE7EA3F0571
80|132A7D05F85B04AF38D27953FE44DECA2C50E7EF387332A08DD51C1C16B70D9149630756A018358B289DBB59AEC0C91D50518D8254CCDA4171C1B62724AE26A3
48|E2F279E2B54CC9A4AA545BF70FD7947CCB4D310A8D66F948DDD8CF7F4784153CEE5D665BC0B2772D1090313163772B72C5841287491F3E2204D95C695CAC3CD0
50|4F7F8122BD69788B08742A7E35EDD8B67E2EE777D330DED361FACD24B21D345901631696059EA59D670BECFB8DDCFA60CB9654021CAD6CB5C6D51452F69A7CB9
98|36BADC91E3A58F12545C280596A5ECD930D99798F24C222AC37F1D1C7225B874DB13CF118BBEF3415A8A4CC33B4AAB241429DE9F29F67038DF1429291FBD3655
CC|DFCE37CA6F32BA4C3A72E77BCA20E511A39B31A6075815F083DB2ECFD5C32CFD6A4E0DD9BD51921199758EDD2FE8ED0FA31E06AA821C7030653D15408E8728DD
9800|FA9F84163C497F63B27F2AC63B270FF55DB9E8D9939375622A2C172F1DA4897CBEC187CA35E579307CCCE084AD56B3310BE39BF56121E799D9E304159CE7A485
9D40|607EFBF08C1B11763584D07A1CDEE567CF890DCF05A6E3310A825AEB2CA27670D393E9BBEC665D6ACAB81B49CB787EBC643DD7CEB9F1BF6E778C1B32A829D0EE
AA80|9CB5104DF745894AE37928E8FD9C65EB5D2159CC1B2FBF0C228D51E9A8CB245EB39845404FC300CC17C5C2726CD07FFA189525640FA7F0FF599C5512C2539C7A
9830|1EFFA6C999CCB1D2C64DB1A7A82D8006B6396B38087E62B21A246C80C2EA665CA0199A8626E4E6D49094F2EA613A9A43CEEC676507D0D9EEEEA2CD6267E641D2
5030|529E7DEBC07619614184AA8D3255B68D720067F7130DC075E8D36FD57A50F3434F62AEC407BB6F28845D4C773977627285B36ACF95C218FD43F6D67EA644102A
4D24|B91C3C259987C6B43A903C7D8EC89F183F8E62B4EDAC66D073913E7768CCBDBF028A748C86F877BBF9492A301BA0B94A986706CFF4B27113F73CB7E2C799DA57
CBDE|0AC60B9C393A6CBB6667403303D3C02150797EE0769CD6F2243DC28D1F8DACF4BACABD0B4642672288B81029A8C957BA54E4BFF09C5C0FE13CBC11A7FE7D00C3
41FB|ED784A0FAD759BAA6504C30C46ACE26A24CC982F1DF81D3833EB7FA0B9D82AFE4BC33A211BDEC1E4B29CE0A30FC9E2D71B947B2EC1B23D4787AD3578836B8481
4FF400|AD85707CE486ED7AA9143F40131BC3E36053B07FAAD86CA76468D21B9B9467177D88BD481F76C874F2DC41C3A37F1CE1D5D0FC8EA1D8F19B0F82C1AB03734AEB
FD0440|A0DE2A3CDA5FE819AB7002E774A367F853C80E107E02BC145B3CE1718A1DAEF51611F25A45B1FD60A3DAF60FE96E0576186580209F8F31A0D2093F6A2CFAB305
424D00|731D69AE98D3D606EC802DA6F9CF978F3A924AE7B523997ED3B88247E5931AC3E35EAAF7BF137DC2D686D485584CE74F227DAD8F76E73640535BA5AB84B9073C
3FDEE0|BF33B81A72426A51B88FAE0A422F09E034B88362EE7C23634D3D85C5276426888E5A2C94F6CE592F83DB3FA4CCAA9E6A18079E1507CCB1C792751BB96491C13D
335768|8B1A49B52383A04FCBD012FE3C086A216D5A1CECDBBD474B8274771970E53D06C0F3877DB54C053885599298DCA228A39BFCB5844E1E6F7E635502F58EB9EB68
051E7C|28FA8301FC7826C54A3065EF3F677CA05DAFD7869EF37008D87E1F6E8F40762DCB7FCD4AFF4A602B03801DD4B1B7D0164E3856541C86C18F4910D91DFB41BD0B
717F8C|E088F4DB4D31AC789AC50E58056A13B1E0E4CCA8237B4C9A9C3A31D3C23C5E3A1F8972340BE4806693D78BEB95216E05D4FCD27828975377048926D66C59A84B
1F877C|98F61FCD1E1305994C9AF873B9AEC05D27AA301C5A7974C9C63A3C71758B92E5510DA8E652CA7A27FCE4F7D8C74183467CCB1ADDEB1F8C6DE87584CA31BB7367
EB35CF80|FFCC190134BA8D2A4C1255C9BDCDD89C7D9E03E50F89D3C1852A77BB808860371EEA9902B8810E0086397C78456111243261ABEE2E75EED8ED23C07E9722C620
B406C480|CE54748C0FBC1545800EFB3A0055938B9AFAB6EC63743CF30A3BAE581A3DF223A6BE1890D85B50E8847E1B9849F62E7122CF7EEA7C9B30AADC98BE6F4266C4FF
CEE88040|F02F18036BCA08B3FEB1BEAC5C9C059ACF5A943A55D73D92C5B66BCE6117C01646BF94DBBFC5EF1F0B5A20F03A667B5711B17930F52EACA496DE26F48015FE0F
C584DB70|A4FBE1DA6F46EB5FE6D06EAA24303CACABD95B573E2D91D9FB22E502548161831EECA27AFDFA7AC3B7BDF6007942D24BD12226FC238A11E35939410D0751D4F1
53587BC8|8D54EA010C29A15ADFE3166B18B2E1683399F485B59FBB44DD3F1EBC66EBBA5157657555164DCCB4C4989E4709850E87BFFCB7B3F9FDFEBF12B505C6065258F8
69A305B0|D7FD60C49469712F0701F7433D2663DC9188B0D22F458A9E78B48098DDE63C43A7B263838380FB2028ED1C4C73F06B832A495E7769D7E6F4FD57C4D5FF638FD4
C9375ECE|BED84DB8287A3B6BF50BBEBEB0189228BFE0F19271A07526ABBED7B92E692E13CD528E3D7B1C1F17E6EF7E8990BC898F8F82B2EF0A3D598C25FE2EA06EE7A46B
C1ECFDFC|13DB296F38DFE5C337AFE6F595717E600A4CC61CF0A5AC90BCB357C43A68042BBA2559C2DB2EB5D096D77883396D69E25DD96805FF6D160CD81D0268BFB3B32D
8D73E8A280|EA6944ACDA3855781B6D79C8226819D0DC122862A7C3F0AFE86A696B0B9B7DB0DA074835D56FEB3EB5DAD50A5E7845445F89C33710720BFC8C7B2014C6781E89
06F2522080|A627093647E32FBC1BDF695F739CB333A34D88644504437988DA685E23ED01BB490CD1919BDAC3740E50DC7CFBB69328AB610574C7D7E44F695E7F18FBB53F2D
3EF6C36F20|7E88136B21EF76BB045830781AC3D2487A9724DD600E53155BE91E188F7D841D87D5630118088950CDAB2288306F2D19D03AEB4C14926C022C882015FFE8AF52
0127A1D340|75A4C5E47AD6D14E0039453540444257E7E17B27A6BECDF85A6974A19073514051700F70511BCFDC792CA8AD68651DD919EE060270DB559E3955CBFD8CBC4821
6A6AB6C210|D7B44184CE7414FCB9AC56AD6E3C9C78E1D1F8D6F51C299ECDA47EF35CED4E53C0CDA092FCA3431096D527DEC9C84A59AEB8076F2036C9C86CC71D3D4FF9C3D5
AF3175E160|7C57A1B32CED4D9E1B237B996BE6095F188819524C3D153F67BD2862F2277E956769439E739736A2B32AA9884EE09AFE8945C3860F2D3407A72D2E6F70D7F130
B66609ED86|9467F7173557764D1E0978DDF21A49CF6950BB13B68F02121D05BCFDA373314875945F463A6C54101CC39D72C947BA3D22994B7B2FB604604A21A62E33DF7B7B
21F134AC57|53309F9DD4CC670F6D1AB9A21F4E5177A6AFBE7F5F3F1F65F195B03ABF5A3ACD7737E5AFA368D3A50E9E845AED2C2A0EA3BB52246A8FC553E767AD265A278C6B
3DC2AADFFC80|4A65E997B638E0C38526C2F8D52AEFDD2148FD612D9F004CCF01A7C597C55753731015CEFD2E4E72D968900F3C3E952131D4F6257FA31A3155152037967D2C90
9202736D2240|EA733B80F77AD5A52AA2302225F1F0583633EBE8BF414CE4F058099A40C3F73319A9AEA4C065F6315ED0630F5C5978B31FB940C9B2DBE1F9CF679CA11F4269EF
F219BD629820|2D1906D523CE39EBE848662F588C23BF2E1834063835FED13EBE26E73C68A5FC831505FA9AC975F69F5F43258A51E3A5C20F6ADF8DC0C3E99709299B335788C8
F3511EE2C4B0|F994DC80B25CC9F7822279BCA24686FDE6EA558CFB6FB249E1A114294B3F799349777A4A52220BE5997C014FEE894C90ACAAD805F5C1492F4B9E7D968CAD2768
3ECAB6BF7720|B92FF326CF22BFE48C5D82083842286706452F159C5E8342FD5F9EF5A5833400CD8D010CDCC02ACE1062C854DDFC46D6E38BA186F2BC96777ED43A357E2A2B27
CD62F688F498|85D8AD213BA92C14A4B3841387B028176FC854CB71123A287850917238EDDF6C844F726E3AE0404F9E6C49A2163DC16E7168E0A573A2918014F49EDC93E02165
C2CBAA33A9F8|0253CDECCC6334F308547F9C202A248AEA083712F4E25E0F09F018844DB4EDBB1A90084FB4CC340B6F5D9352E1F7811DEBABE590994B3F09821E02586C203B8B
C6F50BB74E29|CC134791739799D501D8D1084972246C5DC84397562CFA4746B59474BA9958111125B3F186D3243D4F889C176F7580A63C6421B63D521BB869B38265003CDA31
79F1B4CCC62A00|99984EED14053E5FCB67E001451182CE543A0DF3AB32E151F1E10FEE7402A85439FD9423595104E53DE2D44374EDF9B928E9BE7FC91DAD23BD993988B65FC97E
