# Generated by default/object.tt
package Paws::SecurityHub::AwsIamInstanceProfile;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str');
  has CreateDate => (is => 'ro', isa => 'Str');
  has InstanceProfileId => (is => 'ro', isa => 'Str');
  has InstanceProfileName => (is => 'ro', isa => 'Str');
  has Path => (is => 'ro', isa => 'Str');
  has Roles => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsIamInstanceProfileRole]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsIamInstanceProfile

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsIamInstanceProfile object:

  $service_obj->Method(Att1 => { Arn => $value, ..., Roles => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsIamInstanceProfile object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

Information about an instance profile.

=head1 ATTRIBUTES


=head2 Arn => Str

The ARN of the instance profile.


=head2 CreateDate => Str

Indicates when the instance profile was created.

Uses the C<date-time> format specified in RFC 3339 section 5.6,
Internet Date/Time Format
(https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
contain spaces. For example, C<2020-03-22T13:22:13.933Z>.


=head2 InstanceProfileId => Str

The identifier of the instance profile.


=head2 InstanceProfileName => Str

The name of the instance profile.


=head2 Path => Str

The path to the instance profile.


=head2 Roles => ArrayRef[L<Paws::SecurityHub::AwsIamInstanceProfileRole>]

The roles associated with the instance profile.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

