/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser.guide.decision;

import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.feature.FeatureModel;
import org.maltparser.core.feature.FeatureVector;
import org.maltparser.core.syntaxgraph.DependencyStructure;
import org.maltparser.parser.DependencyParserConfig;
import org.maltparser.parser.guide.ClassifierGuide;
import org.maltparser.parser.guide.GuideException;
import org.maltparser.parser.guide.decision.DecisionModel;
import org.maltparser.parser.guide.instance.AtomicModel;
import org.maltparser.parser.guide.instance.FeatureDivideModel;
import org.maltparser.parser.guide.instance.InstanceModel;
import org.maltparser.parser.history.action.GuideDecision;
import org.maltparser.parser.history.action.MultipleDecision;
import org.maltparser.parser.history.action.SingleDecision;

public class OneDecisionModel
implements DecisionModel {
    private ClassifierGuide guide;
    private String modelName;
    private FeatureModel featureModel;
    private InstanceModel instanceModel;
    private int decisionIndex;
    private DecisionModel prevDecisionModel;
    private String branchedDecisionSymbols;
    private int nIteration;

    public OneDecisionModel(ClassifierGuide guide, FeatureModel featureModel) throws MaltChainedException {
        this.branchedDecisionSymbols = "";
        this.setGuide(guide);
        this.setFeatureModel(featureModel);
        this.setDecisionIndex(0);
        if (guide.getGuideName() == null || guide.getGuideName().equals("")) {
            this.setModelName("odm" + this.decisionIndex);
        } else {
            this.setModelName(guide.getGuideName() + ".odm" + this.decisionIndex);
        }
        this.setPrevDecisionModel(null);
    }

    public OneDecisionModel(ClassifierGuide guide, DecisionModel prevDecisionModel, String branchedDecisionSymbol) throws MaltChainedException {
        this.branchedDecisionSymbols = branchedDecisionSymbol != null && branchedDecisionSymbol.length() > 0 ? branchedDecisionSymbol : "";
        this.setGuide(guide);
        this.setFeatureModel(prevDecisionModel.getFeatureModel());
        this.setDecisionIndex(prevDecisionModel.getDecisionIndex() + 1);
        this.setPrevDecisionModel(prevDecisionModel);
        if (this.branchedDecisionSymbols != null && this.branchedDecisionSymbols.length() > 0) {
            this.setModelName("odm" + this.decisionIndex + this.branchedDecisionSymbols);
        } else {
            this.setModelName("odm" + this.decisionIndex);
        }
    }

    public void updateFeatureModel() throws MaltChainedException {
        this.featureModel.update();
    }

    public void updateCardinality() throws MaltChainedException {
        this.featureModel.updateCardinality();
    }

    public void finalizeSentence(DependencyStructure dependencyGraph) throws MaltChainedException {
        if (this.instanceModel != null) {
            this.instanceModel.finalizeSentence(dependencyGraph);
        }
    }

    public void noMoreInstances() throws MaltChainedException {
        if (this.guide.getGuideMode() == ClassifierGuide.GuideMode.CLASSIFY) {
            throw new GuideException("The decision model could not create it's model. ");
        }
        this.featureModel.updateCardinality();
        if (this.instanceModel != null) {
            this.instanceModel.noMoreInstances();
            this.instanceModel.train();
        }
    }

    public void terminate() throws MaltChainedException {
        if (this.instanceModel != null) {
            this.instanceModel.terminate();
            this.instanceModel = null;
        }
    }

    public void addInstance(GuideDecision decision) throws MaltChainedException {
        SingleDecision singleDecision;
        this.updateFeatureModel();
        SingleDecision singleDecision2 = singleDecision = decision instanceof SingleDecision ? (SingleDecision)decision : ((MultipleDecision)decision).getSingleDecision(this.decisionIndex);
        if (this.instanceModel == null) {
            this.initInstanceModel(singleDecision.getTableContainer().getTableContainerName());
        }
        this.instanceModel.addInstance(singleDecision);
    }

    public boolean predict(GuideDecision decision) throws MaltChainedException {
        SingleDecision singleDecision;
        this.updateFeatureModel();
        SingleDecision singleDecision2 = singleDecision = decision instanceof SingleDecision ? (SingleDecision)decision : ((MultipleDecision)decision).getSingleDecision(this.decisionIndex);
        if (this.instanceModel == null) {
            this.initInstanceModel(singleDecision.getTableContainer().getTableContainerName());
        }
        return this.instanceModel.predict(singleDecision);
    }

    public FeatureVector predictExtract(GuideDecision decision) throws MaltChainedException {
        SingleDecision singleDecision;
        this.updateFeatureModel();
        SingleDecision singleDecision2 = singleDecision = decision instanceof SingleDecision ? (SingleDecision)decision : ((MultipleDecision)decision).getSingleDecision(this.decisionIndex);
        if (this.instanceModel == null) {
            this.initInstanceModel(singleDecision.getTableContainer().getTableContainerName());
        }
        return this.instanceModel.predictExtract(singleDecision);
    }

    public FeatureVector extract() throws MaltChainedException {
        this.updateFeatureModel();
        return this.instanceModel.extract();
    }

    public boolean predictFromKBestList(GuideDecision decision) throws MaltChainedException {
        if (decision instanceof SingleDecision) {
            return ((SingleDecision)decision).updateFromKBestList();
        }
        return ((MultipleDecision)decision).getSingleDecision(this.decisionIndex).updateFromKBestList();
    }

    public ClassifierGuide getGuide() {
        return this.guide;
    }

    public String getModelName() {
        return this.modelName;
    }

    public FeatureModel getFeatureModel() {
        return this.featureModel;
    }

    public int getDecisionIndex() {
        return this.decisionIndex;
    }

    public DecisionModel getPrevDecisionModel() {
        return this.prevDecisionModel;
    }

    private void setPrevDecisionModel(DecisionModel prevDecisionModel) {
        this.prevDecisionModel = prevDecisionModel;
    }

    private void setFeatureModel(FeatureModel featureModel) {
        this.featureModel = featureModel;
    }

    private void setDecisionIndex(int decisionIndex) {
        this.decisionIndex = decisionIndex;
    }

    private void setModelName(String modelName) {
        this.modelName = modelName;
    }

    private void setGuide(ClassifierGuide guide) {
        this.guide = guide;
    }

    private final void initInstanceModel(String subModelName) throws MaltChainedException {
        DependencyParserConfig c;
        FeatureVector fv = this.featureModel.getFeatureVector(this.branchedDecisionSymbols + "." + subModelName);
        if (fv == null) {
            fv = this.featureModel.getFeatureVector(subModelName);
        }
        if (fv == null) {
            fv = this.featureModel.getMainFeatureVector();
        }
        this.instanceModel = (c = this.guide.getConfiguration()).getOptionValue("guide", "data_split_column").toString().length() == 0 ? new AtomicModel(-1, fv, this) : new FeatureDivideModel(fv, this);
    }

    public String toString() {
        return this.modelName;
    }
}

