/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grok.preprocess.sentdetect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import opennlp.common.util.Pair;
import opennlp.maxent.ContextGenerator;

public class SDContextGenerator
implements ContextGenerator {
    private StringBuffer buf = new StringBuffer();
    private List collectFeats = new ArrayList();
    private Set inducedAbbreviations;

    public SDContextGenerator() {
        this(Collections.EMPTY_SET);
    }

    public SDContextGenerator(Set inducedAbbreviations) {
        this.inducedAbbreviations = inducedAbbreviations;
    }

    public String[] getContext(Object o) {
        String next;
        String suffix;
        String prefix;
        String previous;
        Object first = ((Pair)o).a;
        int position = (Integer)((Pair)o).b;
        if (first instanceof String[]) {
            String[] $_ = (String[])first;
            previous = $_[0];
            String current = $_[1];
            prefix = current.substring(0, position);
            suffix = current.substring(position + 1);
            next = $_[2];
        } else {
            StringBuffer sb = (StringBuffer)((Pair)o).a;
            int lastIndex = sb.length() - 1;
            int prefixStart = SDContextGenerator.previousSpaceIndex(sb, position);
            int c = position;
            while (--c > prefixStart) {
                if (sb.charAt(c) != '.') continue;
                prefixStart = c;
                break;
            }
            int prevStart = SDContextGenerator.previousSpaceIndex(sb, prefixStart);
            int suffixEnd = SDContextGenerator.nextSpaceIndex(sb, position, lastIndex);
            c = position;
            while (++c < suffixEnd) {
                if (sb.charAt(c) != '.') continue;
                suffixEnd = c;
                break;
            }
            int nextEnd = SDContextGenerator.nextSpaceIndex(sb, suffixEnd, lastIndex);
            prefix = sb.substring(prefixStart, position).trim();
            previous = sb.substring(prevStart, prefixStart).trim();
            if (position == lastIndex) {
                suffix = "";
                next = "";
            } else {
                suffix = sb.substring(position + 1, suffixEnd).trim();
                next = sb.substring(suffixEnd, nextEnd).trim();
            }
        }
        if (!prefix.equals("")) {
            this.buf.append("x=");
            this.buf.append(prefix);
            this.collectFeats.add(this.buf.toString());
            this.buf.setLength(0);
            this.collectFeats.add(Integer.toString(prefix.length()));
            if (SDContextGenerator.isFirstUpper(prefix)) {
                this.collectFeats.add("xcap");
            }
            if (this.inducedAbbreviations.contains(prefix)) {
                this.collectFeats.add("xabbrev");
            }
        }
        if (!previous.equals("")) {
            this.buf.append("v=");
            this.buf.append(previous);
            this.collectFeats.add(this.buf.toString());
            this.buf.setLength(0);
            if (SDContextGenerator.isFirstUpper(previous)) {
                this.collectFeats.add("vcap");
            }
            if (this.inducedAbbreviations.contains(previous)) {
                this.collectFeats.add("vabbrev");
            }
        }
        if (!suffix.equals("")) {
            this.buf.append("s=");
            this.buf.append(suffix);
            this.collectFeats.add(this.buf.toString());
            this.buf.setLength(0);
            if (SDContextGenerator.isFirstUpper(suffix)) {
                this.collectFeats.add("scap");
            }
            if (this.inducedAbbreviations.contains(suffix)) {
                this.collectFeats.add("sabbrev");
            }
        }
        if (!next.equals("")) {
            this.buf.append("n=");
            this.buf.append(next);
            this.collectFeats.add(this.buf.toString());
            this.buf.setLength(0);
            if (SDContextGenerator.isFirstUpper(next)) {
                this.collectFeats.add("ncap");
            }
            if (this.inducedAbbreviations.contains(next)) {
                this.collectFeats.add("nabbrev");
            }
        }
        String[] context = new String[this.collectFeats.size()];
        context = this.collectFeats.toArray(context);
        this.collectFeats.clear();
        return context;
    }

    private static final boolean isFirstUpper(String s) {
        return Character.isUpperCase(s.charAt(0));
    }

    private static final int previousSpaceIndex(StringBuffer sb, int seek) {
        --seek;
        while (seek > 0) {
            if (sb.charAt(seek) == ' ') {
                while (seek > 0 && sb.charAt(seek - 1) == ' ') {
                    --seek;
                }
                return seek;
            }
            --seek;
        }
        return 0;
    }

    private static final int nextSpaceIndex(StringBuffer sb, int seek, int lastIndex) {
        ++seek;
        while (seek < lastIndex) {
            char c = sb.charAt(seek);
            if (c == ' ' || c == '\n') {
                while (sb.length() > seek + 1 && sb.charAt(seek + 1) == ' ') {
                    ++seek;
                }
                return seek;
            }
            ++seek;
        }
        return lastIndex;
    }
}

