#########################################################################################
# Package        HiPi::Graphics::BitmapFont::Sans15
# Description  : Monochrome OLED Font
# License      : This is free software; you can redistribute it and/or modify it under
#                the same terms as the Perl 5 programming language system itself.
#########################################################################################

package HiPi::Graphics::BitmapFont::Sans15;

#########################################################################################

use utf8;
use strict;
use warnings;
use parent qw( HiPi::Graphics::BitmapFont);

our $VERSION ='0.01';

my $gap_width = 0;
my $char_height = 15;
my $line_spacing = 1;
my $name = 'Sans 15';
my $space_width = 4;
 
my $symbols = {
    '33' => {    # '!'
        'width'    => 1, 
        'xoffset'  => 2, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x00, ##   
            0x80, ##  0
            0x80, ##  0
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '34' => {    # '"'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '35' => {    # '#'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x09, 0x00, ##      0  0  
            0x09, 0x00, ##      0  0  
            0x09, 0x00, ##      0  0  
            0x7F, 0xC0, ##   000000000
            0x12, 0x00, ##     0  0   
            0x12, 0x00, ##     0  0   
            0xFF, 0x80, ##  000000000 
            0x24, 0x00, ##    0  0    
            0x24, 0x00, ##    0  0    
            0x24, 0x00, ##    0  0    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '36' => {    # '$'
        'width'    => 6, 
        'xoffset'  => 1, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x10, ##     0  
            0x10, ##     0  
            0x7C, ##   00000
            0x94, ##  0  0 0
            0x90, ##  0  0  
            0xD0, ##  00 0  
            0x78, ##   0000 
            0x14, ##     0 0
            0x14, ##     0 0
            0x94, ##  0  0 0
            0xF8, ##  00000 
            0x10, ##     0  
            0x10, ##     0  
            0x00, ##  
        ], 
    }, 
    '37' => {    # '%'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x70, 0x80, ##   000    0   
            0x88, 0x80, ##  0   0   0   
            0x89, 0x00, ##  0   0  0    
            0x8B, 0x00, ##  0   0 00    
            0x72, 0xE0, ##   000  0 000 
            0x05, 0x10, ##       0 0   0
            0x0D, 0x10, ##      00 0   0
            0x09, 0x10, ##      0  0   0
            0x11, 0x10, ##     0   0   0
            0x10, 0xE0, ##     0    000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '38' => {    # '&'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3C, 0x00, ##    0000    
            0x40, 0x00, ##   0        
            0x40, 0x00, ##   0        
            0x60, 0x00, ##   00       
            0x70, 0x00, ##   000      
            0x98, 0x80, ##  0  00   0 
            0x8C, 0x80, ##  0   00  0 
            0x87, 0x00, ##  0    000  
            0xC3, 0x00, ##  00    00  
            0x3C, 0x80, ##    0000  0 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '39' => {    # '''
        'width'    => 1, 
        'xoffset'  => 1, 
        'xadvance' => 3, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '40' => {    # '('
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x60, ##   00
            0x40, ##   0 
            0x40, ##   0 
            0x80, ##  0  
            0x80, ##  0  
            0x80, ##  0  
            0x80, ##  0  
            0x80, ##  0  
            0x80, ##  0  
            0x80, ##  0  
            0x40, ##   0 
            0x40, ##   0 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '41' => {    # ')'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0xC0, ##  00 
            0x40, ##   0 
            0x40, ##   0 
            0x20, ##    0
            0x20, ##    0
            0x20, ##    0
            0x20, ##    0
            0x20, ##    0
            0x20, ##    0
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '42' => {    # '*'
        'width'    => 7, 
        'xoffset'  => 0, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x10, ##     0   
            0x92, ##  0  0  0
            0x7C, ##   00000 
            0x38, ##    000  
            0xD6, ##  00 0 00
            0x10, ##     0   
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '43' => {    # '+'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x08, 0x00, ##      0    
            0x08, 0x00, ##      0    
            0x08, 0x00, ##      0    
            0x08, 0x00, ##      0    
            0xFF, 0x80, ##  000000000
            0x08, 0x00, ##      0    
            0x08, 0x00, ##      0    
            0x08, 0x00, ##      0    
            0x08, 0x00, ##      0    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '44' => {    # ','
        'width'    => 2, 
        'xoffset'  => 1, 
        'xadvance' => 4, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x40, ##   0
            0x40, ##   0
            0x80, ##  0 
            0x00, ##  
        ], 
    }, 
    '45' => {    # '-'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '46' => {    # '.'
        'width'    => 1, 
        'xoffset'  => 1, 
        'xadvance' => 4, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x80, ##  0
            0x80, ##  0
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '47' => {    # '/'
        'width'    => 5, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x18, ##     00
            0x10, ##     0 
            0x10, ##     0 
            0x30, ##    00 
            0x20, ##    0  
            0x20, ##    0  
            0x20, ##    0  
            0x40, ##   0   
            0x40, ##   0   
            0x40, ##   0   
            0x80, ##  0    
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '48' => {    # '0'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x38, ##    000  
            0x44, ##   0   0 
            0x82, ##  0     0
            0x82, ##  0     0
            0x82, ##  0     0
            0x82, ##  0     0
            0x82, ##  0     0
            0x82, ##  0     0
            0x44, ##   0   0 
            0x38, ##    000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '49' => {    # '1'
        'width'    => 6, 
        'xoffset'  => 2, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000  
            0x90, ##  0  0  
            0x10, ##     0  
            0x10, ##     0  
            0x10, ##     0  
            0x10, ##     0  
            0x10, ##     0  
            0x10, ##     0  
            0x10, ##     0  
            0xFC, ##  000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '50' => {    # '2'
        'width'    => 6, 
        'xoffset'  => 1, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xF8, ##  00000 
            0x8C, ##  0   00
            0x04, ##       0
            0x04, ##       0
            0x0C, ##      00
            0x18, ##     00 
            0x30, ##    00  
            0x60, ##   00   
            0xC0, ##  00    
            0xFC, ##  000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '51' => {    # '3'
        'width'    => 6, 
        'xoffset'  => 1, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xF8, ##  00000 
            0x04, ##       0
            0x04, ##       0
            0x04, ##       0
            0x78, ##   0000 
            0x0C, ##      00
            0x04, ##       0
            0x04, ##       0
            0x0C, ##      00
            0xF8, ##  00000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '52' => {    # '4'
        'width'    => 6, 
        'xoffset'  => 1, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x18, ##     00 
            0x18, ##     00 
            0x28, ##    0 0 
            0x48, ##   0  0 
            0xC8, ##  00  0 
            0x88, ##  0   0 
            0xFC, ##  000000
            0x08, ##      0 
            0x08, ##      0 
            0x08, ##      0 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '53' => {    # '5'
        'width'    => 6, 
        'xoffset'  => 2, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xF8, ##  00000 
            0x80, ##  0     
            0x80, ##  0     
            0xF0, ##  0000  
            0x08, ##      0 
            0x04, ##       0
            0x04, ##       0
            0x04, ##       0
            0x08, ##      0 
            0xF0, ##  0000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '54' => {    # '6'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x3E, ##    00000
            0x40, ##   0     
            0x80, ##  0      
            0xB8, ##  0 000  
            0xC4, ##  00   0 
            0x82, ##  0     0
            0x82, ##  0     0
            0x82, ##  0     0
            0x46, ##   0   00
            0x38, ##    000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '55' => {    # '7'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xFE, ##  0000000
            0x06, ##       00
            0x04, ##       0 
            0x0C, ##      00 
            0x08, ##      0  
            0x18, ##     00  
            0x18, ##     00  
            0x10, ##     0   
            0x30, ##    00   
            0x20, ##    0    
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '56' => {    # '8'
        'width'    => 6, 
        'xoffset'  => 1, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x78, ##   0000 
            0x84, ##  0    0
            0x84, ##  0    0
            0x84, ##  0    0
            0x78, ##   0000 
            0xCC, ##  00  00
            0x84, ##  0    0
            0x84, ##  0    0
            0xCC, ##  00  00
            0x78, ##   0000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '57' => {    # '9'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x78, ##   0000  
            0xC4, ##  00   0 
            0x82, ##  0     0
            0x82, ##  0     0
            0xC6, ##  00   00
            0x7A, ##   0000 0
            0x02, ##        0
            0x06, ##       00
            0x84, ##  0    0 
            0xF8, ##  00000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '58' => {    # ':'
        'width'    => 1, 
        'xoffset'  => 2, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x80, ##  0
            0x80, ##  0
            0x00, ##   
            0x00, ##   
            0x00, ##   
            0x80, ##  0
            0x80, ##  0
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '59' => {    # ';'
        'width'    => 2, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x40, ##   0
            0x40, ##   0
            0x00, ##    
            0x00, ##    
            0x00, ##    
            0x00, ##    
            0x40, ##   0
            0x40, ##   0
            0x80, ##  0 
            0x00, ##  
        ], 
    }, 
    '60' => {    # '<'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x01, 0x80, ##         00
            0x0F, 0x00, ##      0000 
            0x78, 0x00, ##   0000    
            0xC0, 0x00, ##  00       
            0x78, 0x00, ##   0000    
            0x0E, 0x00, ##      000  
            0x01, 0x80, ##         00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '61' => {    # '='
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0x80, ##  000000000
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0xFF, 0x80, ##  000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '62' => {    # '>'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0x00, ##  00       
            0x78, 0x00, ##   0000    
            0x0F, 0x00, ##      0000 
            0x01, 0x80, ##         00
            0x0F, 0x00, ##      0000 
            0x38, 0x00, ##    000    
            0xC0, 0x00, ##  00       
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '63' => {    # '?'
        'width'    => 5, 
        'xoffset'  => 1, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000 
            0x08, ##      0
            0x08, ##      0
            0x10, ##     0 
            0x20, ##    0  
            0x40, ##   0   
            0x40, ##   0   
            0x00, ##       
            0x40, ##   0   
            0x40, ##   0   
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '64' => {    # '@'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x0F, 0x80, ##      00000   
            0x30, 0xC0, ##    00    00  
            0x60, 0x20, ##   00       0 
            0x40, 0x30, ##   0        00
            0x8E, 0x90, ##  0   000 0  0
            0x99, 0x90, ##  0  00  00  0
            0x90, 0x90, ##  0  0    0  0
            0x90, 0x90, ##  0  0    0  0
            0x99, 0xA0, ##  0  00  00 0 
            0x4E, 0xC0, ##   0  000 00  
            0x60, 0x00, ##   00         
            0x30, 0xC0, ##    00    00  
            0x0F, 0x80, ##      00000   
            0x00, 0x00, ##  
        ], 
    }, 
    '65' => {    # 'A'
        'width'    => 9, 
        'xoffset'  => 0, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0C, 0x00, ##      00   
            0x1C, 0x00, ##     000   
            0x16, 0x00, ##     0 00  
            0x12, 0x00, ##     0  0  
            0x22, 0x00, ##    0   0  
            0x23, 0x00, ##    0   00 
            0x7F, 0x00, ##   0000000 
            0x41, 0x00, ##   0     0 
            0x40, 0x80, ##   0      0
            0xC0, 0x80, ##  00      0
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '66' => {    # 'B'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xFC, ##  000000 
            0x82, ##  0     0
            0x82, ##  0     0
            0x86, ##  0    00
            0xFC, ##  000000 
            0x86, ##  0    00
            0x82, ##  0     0
            0x82, ##  0     0
            0x86, ##  0    00
            0xFC, ##  000000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '67' => {    # 'C'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x1E, ##     0000 
            0x61, ##   00    0
            0xC0, ##  00      
            0x80, ##  0       
            0x80, ##  0       
            0x80, ##  0       
            0x80, ##  0       
            0xC0, ##  00      
            0x61, ##   00    0
            0x3E, ##    00000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '68' => {    # 'D'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xF8, ##  00000   
            0x86, ##  0    00 
            0x83, ##  0     00
            0x81, ##  0      0
            0x81, ##  0      0
            0x81, ##  0      0
            0x81, ##  0      0
            0x83, ##  0     00
            0x86, ##  0    00 
            0xFC, ##  000000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '69' => {    # 'E'
        'width'    => 6, 
        'xoffset'  => 1, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xFC, ##  000000
            0x80, ##  0     
            0x80, ##  0     
            0x80, ##  0     
            0xFC, ##  000000
            0x80, ##  0     
            0x80, ##  0     
            0x80, ##  0     
            0x80, ##  0     
            0xFC, ##  000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '70' => {    # 'F'
        'width'    => 5, 
        'xoffset'  => 1, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xF8, ##  00000
            0x80, ##  0    
            0x80, ##  0    
            0x80, ##  0    
            0xF8, ##  00000
            0x80, ##  0    
            0x80, ##  0    
            0x80, ##  0    
            0x80, ##  0    
            0x80, ##  0    
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '71' => {    # 'G'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0x00, ##     00000 
            0x60, 0x80, ##   00     0
            0x40, 0x00, ##   0       
            0x80, 0x00, ##  0        
            0x87, 0x80, ##  0    0000
            0x80, 0x80, ##  0       0
            0x80, 0x80, ##  0       0
            0xC0, 0x80, ##  00      0
            0x60, 0x80, ##   00     0
            0x1F, 0x00, ##     00000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '72' => {    # 'H'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x81, ##  0      0
            0x81, ##  0      0
            0x81, ##  0      0
            0x81, ##  0      0
            0xFF, ##  00000000
            0x81, ##  0      0
            0x81, ##  0      0
            0x81, ##  0      0
            0x81, ##  0      0
            0x81, ##  0      0
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '73' => {    # 'I'
        'width'    => 1, 
        'xoffset'  => 1, 
        'xadvance' => 3, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '74' => {    # 'J'
        'width'    => 3, 
        'xoffset'  => -1, 
        'xadvance' => 3, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x20, ##    0
            0x20, ##    0
            0x20, ##    0
            0x20, ##    0
            0x20, ##    0
            0x20, ##    0
            0x20, ##    0
            0x20, ##    0
            0x20, ##    0
            0x20, ##    0
            0x20, ##    0
            0x20, ##    0
            0xC0, ##  00 
        ], 
    }, 
    '75' => {    # 'K'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x86, ##  0    00 
            0x8C, ##  0   00  
            0x98, ##  0  00   
            0xB0, ##  0 00    
            0xC0, ##  00      
            0xE0, ##  000     
            0xB0, ##  0 00    
            0x98, ##  0  00   
            0x8C, ##  0   00  
            0x86, ##  0    00 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '76' => {    # 'L'
        'width'    => 6, 
        'xoffset'  => 1, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x80, ##  0     
            0x80, ##  0     
            0x80, ##  0     
            0x80, ##  0     
            0x80, ##  0     
            0x80, ##  0     
            0x80, ##  0     
            0x80, ##  0     
            0x80, ##  0     
            0xFC, ##  000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '77' => {    # 'M'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xA3, 0x80, ##  0 0   000
            0xA2, 0x80, ##  0 0   0 0
            0xB6, 0x80, ##  0 00 00 0
            0x94, 0x80, ##  0  0 0  0
            0x94, 0x80, ##  0  0 0  0
            0x88, 0x80, ##  0   0   0
            0x80, 0x80, ##  0       0
            0x80, 0x80, ##  0       0
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '78' => {    # 'N'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xC1, ##  00     0
            0xE1, ##  000    0
            0xA1, ##  0 0    0
            0xB1, ##  0 00   0
            0x99, ##  0  00  0
            0x99, ##  0  00  0
            0x8D, ##  0   00 0
            0x85, ##  0    0 0
            0x87, ##  0    000
            0x83, ##  0     00
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '79' => {    # 'O'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3E, 0x00, ##    00000  
            0x63, 0x00, ##   00   00 
            0xC1, 0x00, ##  00     0 
            0x80, 0x80, ##  0       0
            0x80, 0x80, ##  0       0
            0x80, 0x80, ##  0       0
            0x80, 0x80, ##  0       0
            0xC1, 0x80, ##  00     00
            0x63, 0x00, ##   00   00 
            0x3E, 0x00, ##    00000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '80' => {    # 'P'
        'width'    => 6, 
        'xoffset'  => 1, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xF8, ##  00000 
            0x8C, ##  0   00
            0x84, ##  0    0
            0x84, ##  0    0
            0x8C, ##  0   00
            0xF8, ##  00000 
            0x80, ##  0     
            0x80, ##  0     
            0x80, ##  0     
            0x80, ##  0     
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '81' => {    # 'Q'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3E, 0x00, ##    00000  
            0x63, 0x00, ##   00   00 
            0xC1, 0x00, ##  00     0 
            0x80, 0x80, ##  0       0
            0x80, 0x80, ##  0       0
            0x80, 0x80, ##  0       0
            0x80, 0x80, ##  0       0
            0xC1, 0x80, ##  00     00
            0x63, 0x00, ##   00   00 
            0x3E, 0x00, ##    00000  
            0x02, 0x00, ##        0  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '82' => {    # 'R'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xF8, ##  00000  
            0x8C, ##  0   00 
            0x84, ##  0    0 
            0x84, ##  0    0 
            0x8C, ##  0   00 
            0xF8, ##  00000  
            0x8C, ##  0   00 
            0x84, ##  0    0 
            0x86, ##  0    00
            0x82, ##  0     0
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '83' => {    # 'S'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x7E, ##   000000
            0xC2, ##  00    0
            0x80, ##  0      
            0x80, ##  0      
            0x78, ##   0000  
            0x1C, ##     000 
            0x02, ##        0
            0x02, ##        0
            0x86, ##  0    00
            0xFC, ##  000000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '84' => {    # 'T'
        'width'    => 9, 
        'xoffset'  => 0, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0x80, ##  000000000
            0x08, 0x00, ##      0    
            0x08, 0x00, ##      0    
            0x08, 0x00, ##      0    
            0x08, 0x00, ##      0    
            0x08, 0x00, ##      0    
            0x08, 0x00, ##      0    
            0x08, 0x00, ##      0    
            0x08, 0x00, ##      0    
            0x08, 0x00, ##      0    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '85' => {    # 'U'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x81, ##  0      0
            0x81, ##  0      0
            0x81, ##  0      0
            0x81, ##  0      0
            0x81, ##  0      0
            0x81, ##  0      0
            0x81, ##  0      0
            0x81, ##  0      0
            0x42, ##   0    0 
            0x3C, ##    0000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '86' => {    # 'V'
        'width'    => 9, 
        'xoffset'  => 0, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0x80, ##  00      0
            0x41, 0x80, ##   0     00
            0x61, 0x80, ##   00    00
            0x61, 0x00, ##   00    0 
            0x23, 0x00, ##    0   00 
            0x32, 0x00, ##    00  0  
            0x12, 0x00, ##     0  0  
            0x16, 0x00, ##     0 00  
            0x1C, 0x00, ##     000   
            0x0C, 0x00, ##      00   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '87' => {    # 'W'
        'width'    => 13, 
        'xoffset'  => 0, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x43, 0x08, ##   0    00    0
            0x43, 0x08, ##   0    00    0
            0x47, 0x18, ##   0   000   00
            0x65, 0x98, ##   00  0 00  00
            0x24, 0x90, ##    0  0  0  0 
            0x24, 0x90, ##    0  0  0  0 
            0x3C, 0xB0, ##    0000  0 00 
            0x38, 0xE0, ##    000   000  
            0x18, 0x60, ##     00    00  
            0x18, 0x60, ##     00    00  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '88' => {    # 'X'
        'width'    => 9, 
        'xoffset'  => 0, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x61, 0x80, ##   00    00
            0x23, 0x00, ##    0   00 
            0x12, 0x00, ##     0  0  
            0x1E, 0x00, ##     0000  
            0x0C, 0x00, ##      00   
            0x1C, 0x00, ##     000   
            0x16, 0x00, ##     0 00  
            0x32, 0x00, ##    00  0  
            0x61, 0x00, ##   00    0 
            0x41, 0x80, ##   0     00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '89' => {    # 'Y'
        'width'    => 9, 
        'xoffset'  => 0, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x41, 0x00, ##   0     0 
            0x63, 0x00, ##   00   00 
            0x22, 0x00, ##    0   0  
            0x14, 0x00, ##     0 0   
            0x1C, 0x00, ##     000   
            0x08, 0x00, ##      0    
            0x08, 0x00, ##      0    
            0x08, 0x00, ##      0    
            0x08, 0x00, ##      0    
            0x08, 0x00, ##      0    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '90' => {    # 'Z'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xFF, ##  00000000
            0x03, ##        00
            0x06, ##       00 
            0x0C, ##      00  
            0x08, ##      0   
            0x10, ##     0    
            0x30, ##    00    
            0x60, ##   00     
            0xC0, ##  00      
            0xFF, ##  00000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '91' => {    # '['
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0xE0, ##  000
            0x80, ##  0  
            0x80, ##  0  
            0x80, ##  0  
            0x80, ##  0  
            0x80, ##  0  
            0x80, ##  0  
            0x80, ##  0  
            0x80, ##  0  
            0x80, ##  0  
            0x80, ##  0  
            0x80, ##  0  
            0xE0, ##  000
            0x00, ##  
        ], 
    }, 
    '92' => {    # '\'
        'width'    => 5, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x80, ##  0    
            0xC0, ##  00   
            0x40, ##   0   
            0x40, ##   0   
            0x60, ##   00  
            0x20, ##    0  
            0x20, ##    0  
            0x20, ##    0  
            0x10, ##     0 
            0x10, ##     0 
            0x10, ##     0 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '93' => {    # ']'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0xE0, ##  000
            0x20, ##    0
            0x20, ##    0
            0x20, ##    0
            0x20, ##    0
            0x20, ##    0
            0x20, ##    0
            0x20, ##    0
            0x20, ##    0
            0x20, ##    0
            0x20, ##    0
            0x20, ##    0
            0xE0, ##  000
            0x00, ##  
        ], 
    }, 
    '94' => {    # '^'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x0C, 0x00, ##      00   
            0x1E, 0x00, ##     0000  
            0x23, 0x00, ##    0   00 
            0x41, 0x80, ##   0     00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '95' => {    # '_'
        'width'    => 7, 
        'xoffset'  => 0, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFE, ##  0000000
        ], 
    }, 
    '96' => {    # '`'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0xC0, ##  00 
            0x40, ##   0 
            0x20, ##    0
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '97' => {    # 'a'
        'width'    => 6, 
        'xoffset'  => 1, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF8, ##  00000 
            0x8C, ##  0   00
            0x04, ##       0
            0x7C, ##   00000
            0x84, ##  0    0
            0x84, ##  0    0
            0x8C, ##  0   00
            0x74, ##   000 0
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '98' => {    # 'b'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x80, ##  0      
            0x80, ##  0      
            0x80, ##  0      
            0xB8, ##  0 000  
            0xC4, ##  00   0 
            0x82, ##  0     0
            0x82, ##  0     0
            0x82, ##  0     0
            0x82, ##  0     0
            0xC4, ##  00   0 
            0xB8, ##  0 000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '99' => {    # 'c'
        'width'    => 6, 
        'xoffset'  => 1, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x3C, ##    0000
            0x40, ##   0    
            0x80, ##  0     
            0x80, ##  0     
            0x80, ##  0     
            0x80, ##  0     
            0x40, ##   0    
            0x3C, ##    0000
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '100' => {    # 'd'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x02, ##        0
            0x02, ##        0
            0x02, ##        0
            0x3A, ##    000 0
            0x46, ##   0   00
            0x82, ##  0     0
            0x82, ##  0     0
            0x82, ##  0     0
            0x82, ##  0     0
            0x46, ##   0   00
            0x3A, ##    000 0
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '101' => {    # 'e'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x3C, ##    0000 
            0x46, ##   0   00
            0x82, ##  0     0
            0xFE, ##  0000000
            0x80, ##  0      
            0x80, ##  0      
            0x42, ##   0    0
            0x3E, ##    00000
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '102' => {    # 'f'
        'width'    => 5, 
        'xoffset'  => 1, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x38, ##    000
            0x40, ##   0   
            0x40, ##   0   
            0xF8, ##  00000
            0x40, ##   0   
            0x40, ##   0   
            0x40, ##   0   
            0x40, ##   0   
            0x40, ##   0   
            0x40, ##   0   
            0x40, ##   0   
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '103' => {    # 'g'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x3A, ##    000 0
            0x46, ##   0   00
            0x82, ##  0     0
            0x82, ##  0     0
            0x82, ##  0     0
            0x82, ##  0     0
            0x46, ##   0   00
            0x3A, ##    000 0
            0x02, ##        0
            0x04, ##       0 
            0x78, ##   0000  
        ], 
    }, 
    '104' => {    # 'h'
        'width'    => 6, 
        'xoffset'  => 1, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x80, ##  0     
            0x80, ##  0     
            0x80, ##  0     
            0xB8, ##  0 000 
            0xCC, ##  00  00
            0x84, ##  0    0
            0x84, ##  0    0
            0x84, ##  0    0
            0x84, ##  0    0
            0x84, ##  0    0
            0x84, ##  0    0
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '105' => {    # 'i'
        'width'    => 1, 
        'xoffset'  => 1, 
        'xadvance' => 3, 
        'bitmap'   => [ 
            0x00, ##  
            0x80, ##  0
            0x00, ##   
            0x00, ##   
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '106' => {    # 'j'
        'width'    => 2, 
        'xoffset'  => 0, 
        'xadvance' => 3, 
        'bitmap'   => [ 
            0x00, ##  
            0x40, ##   0
            0x00, ##    
            0x00, ##    
            0x40, ##   0
            0x40, ##   0
            0x40, ##   0
            0x40, ##   0
            0x40, ##   0
            0x40, ##   0
            0x40, ##   0
            0x40, ##   0
            0x40, ##   0
            0x40, ##   0
            0x80, ##  0 
        ], 
    }, 
    '107' => {    # 'k'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x80, ##  0      
            0x80, ##  0      
            0x80, ##  0      
            0x8C, ##  0   00 
            0x98, ##  0  00  
            0xB0, ##  0 00   
            0xE0, ##  000    
            0xE0, ##  000    
            0xB0, ##  0 00   
            0x98, ##  0  00  
            0x8C, ##  0   00 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '108' => {    # 'l'
        'width'    => 1, 
        'xoffset'  => 1, 
        'xadvance' => 3, 
        'bitmap'   => [ 
            0x00, ##  
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '109' => {    # 'm'
        'width'    => 11, 
        'xoffset'  => 1, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xB9, 0xC0, ##  0 000  000 
            0xC6, 0x20, ##  00   00   0
            0x84, 0x20, ##  0    0    0
            0x84, 0x20, ##  0    0    0
            0x84, 0x20, ##  0    0    0
            0x84, 0x20, ##  0    0    0
            0x84, 0x20, ##  0    0    0
            0x84, 0x20, ##  0    0    0
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '110' => {    # 'n'
        'width'    => 6, 
        'xoffset'  => 1, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xB8, ##  0 000 
            0xCC, ##  00  00
            0x84, ##  0    0
            0x84, ##  0    0
            0x84, ##  0    0
            0x84, ##  0    0
            0x84, ##  0    0
            0x84, ##  0    0
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '111' => {    # 'o'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x38, ##    000  
            0x44, ##   0   0 
            0x82, ##  0     0
            0x82, ##  0     0
            0x82, ##  0     0
            0x82, ##  0     0
            0x44, ##   0   0 
            0x38, ##    000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '112' => {    # 'p'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xB8, ##  0 000  
            0xC4, ##  00   0 
            0x82, ##  0     0
            0x82, ##  0     0
            0x82, ##  0     0
            0x82, ##  0     0
            0xC4, ##  00   0 
            0xB8, ##  0 000  
            0x80, ##  0      
            0x80, ##  0      
            0x80, ##  0      
        ], 
    }, 
    '113' => {    # 'q'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x3A, ##    000 0
            0x46, ##   0   00
            0x82, ##  0     0
            0x82, ##  0     0
            0x82, ##  0     0
            0x82, ##  0     0
            0x46, ##   0   00
            0x3A, ##    000 0
            0x02, ##        0
            0x02, ##        0
            0x02, ##        0
        ], 
    }, 
    '114' => {    # 'r'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xB0, ##  0 00
            0xC0, ##  00  
            0x80, ##  0   
            0x80, ##  0   
            0x80, ##  0   
            0x80, ##  0   
            0x80, ##  0   
            0x80, ##  0   
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '115' => {    # 's'
        'width'    => 6, 
        'xoffset'  => 1, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x7C, ##   00000
            0x80, ##  0     
            0x80, ##  0     
            0xF0, ##  0000  
            0x1C, ##     000
            0x04, ##       0
            0x84, ##  0    0
            0xF8, ##  00000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '116' => {    # 't'
        'width'    => 5, 
        'xoffset'  => 1, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x40, ##   0   
            0x40, ##   0   
            0xF8, ##  00000
            0x40, ##   0   
            0x40, ##   0   
            0x40, ##   0   
            0x40, ##   0   
            0x40, ##   0   
            0x40, ##   0   
            0x38, ##    000
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '117' => {    # 'u'
        'width'    => 6, 
        'xoffset'  => 1, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x84, ##  0    0
            0x84, ##  0    0
            0x84, ##  0    0
            0x84, ##  0    0
            0x84, ##  0    0
            0x84, ##  0    0
            0xCC, ##  00  00
            0x74, ##   000 0
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '118' => {    # 'v'
        'width'    => 8, 
        'xoffset'  => 0, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x43, ##   0    00
            0x42, ##   0    0 
            0x62, ##   00   0 
            0x26, ##    0  00 
            0x24, ##    0  0  
            0x34, ##    00 0  
            0x1C, ##     000  
            0x18, ##     00   
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '119' => {    # 'w'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x8C, 0xC0, ##  0   00  00
            0x8C, 0x80, ##  0   00  0 
            0x94, 0x80, ##  0  0 0  0 
            0xD4, 0x80, ##  00 0 0  0 
            0x57, 0x80, ##   0 0 0000 
            0x53, 0x00, ##   0 0  00  
            0x63, 0x00, ##   00   00  
            0x63, 0x00, ##   00   00  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '120' => {    # 'x'
        'width'    => 8, 
        'xoffset'  => 0, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x62, ##   00   0 
            0x26, ##    0  00 
            0x3C, ##    0000  
            0x18, ##     00   
            0x18, ##     00   
            0x34, ##    00 0  
            0x66, ##   00  00 
            0x42, ##   0    0 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '121' => {    # 'y'
        'width'    => 8, 
        'xoffset'  => 0, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x43, ##   0    00
            0x42, ##   0    0 
            0x66, ##   00  00 
            0x24, ##    0  0  
            0x24, ##    0  0  
            0x3C, ##    0000  
            0x18, ##     00   
            0x18, ##     00   
            0x10, ##     0    
            0x10, ##     0    
            0x60, ##   00     
        ], 
    }, 
    '122' => {    # 'z'
        'width'    => 6, 
        'xoffset'  => 1, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFC, ##  000000
            0x0C, ##      00
            0x18, ##     00 
            0x10, ##     0  
            0x20, ##    0   
            0x60, ##   00   
            0xC0, ##  00    
            0xFC, ##  000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '123' => {    # '{'
        'width'    => 6, 
        'xoffset'  => 2, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x1C, ##     000
            0x20, ##    0   
            0x20, ##    0   
            0x20, ##    0   
            0x20, ##    0   
            0x20, ##    0   
            0xC0, ##  00    
            0x20, ##    0   
            0x20, ##    0   
            0x20, ##    0   
            0x20, ##    0   
            0x20, ##    0   
            0x1C, ##     000
            0x00, ##  
        ], 
    }, 
    '124' => {    # '|'
        'width'    => 1, 
        'xoffset'  => 2, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
        ], 
    }, 
    '125' => {    # '}'
        'width'    => 6, 
        'xoffset'  => 2, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0xC0, ##  00    
            0x20, ##    0   
            0x20, ##    0   
            0x20, ##    0   
            0x20, ##    0   
            0x20, ##    0   
            0x1C, ##     000
            0x20, ##    0   
            0x20, ##    0   
            0x20, ##    0   
            0x20, ##    0   
            0x20, ##    0   
            0xC0, ##  00    
            0x00, ##  
        ], 
    }, 
    '126' => {    # '~'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x78, 0x80, ##   0000   0
            0x8F, 0x00, ##  0   0000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '176' => {    # '°'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x60, ##   00 
            0x90, ##  0  0
            0x90, ##  0  0
            0x60, ##   00 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
};
 
my $kerning = {
    '33' => { },  # !
    '34' => { },  # "
    '35' => { },  # #
    '36' => { },  # $
    '37' => { },  # %
    '38' => { },  # &
    '39' => { },  # '
    '40' => { },  # (
    '41' => { },  # )
    '42' => { },  # *
    '43' => { },  # +
    '44' => { },  # ,
    '45' => { '84' => -1, '89' => -1, },  # -
    '46' => { },  # .
    '47' => { },  # /
    '48' => { },  # 0
    '49' => { },  # 1
    '50' => { },  # 2
    '51' => { },  # 3
    '52' => { },  # 4
    '53' => { },  # 5
    '54' => { },  # 6
    '55' => { },  # 7
    '56' => { },  # 8
    '57' => { },  # 9
    '58' => { },  # :
    '59' => { },  # ;
    '60' => { },  # <
    '61' => { },  # =
    '62' => { },  # >
    '63' => { },  # ?
    '64' => { },  # @
    '65' => { '84' => -1, '89' => -1, '121' => -1, },  # A
    '66' => { },  # B
    '67' => { },  # C
    '68' => { },  # D
    '69' => { },  # E
    '70' => { '46' => -1, '58' => -1, '65' => -1, '97' => -1, '105' => -1, '114' => -1, '121' => -1, },  # F
    '71' => { },  # G
    '72' => { },  # H
    '73' => { },  # I
    '74' => { },  # J
    '75' => { '45' => -1, '84' => -1, '121' => -1, },  # K
    '76' => { '84' => -1, '86' => -1, '87' => -1, '89' => -1, '121' => -1, },  # L
    '77' => { },  # M
    '78' => { },  # N
    '79' => { },  # O
    '80' => { '46' => -1, },  # P
    '81' => { },  # Q
    '82' => { '84' => -1, },  # R
    '83' => { },  # S
    '84' => { '45' => -1, '46' => -1, '58' => -1, '65' => -1, '97' => -1, '99' => -1, '101' => -1, '111' => -1, '114' => -1, '115' => -1, '117' => -1, '119' => -1, '121' => -1, },  # T
    '85' => { },  # U
    '86' => { '46' => -1, '58' => -1, '97' => -1, '101' => -1, '111' => -1, '117' => -1, },  # V
    '87' => { '46' => -1, },  # W
    '88' => { '67' => -1, },  # X
    '89' => { '45' => -1, '46' => -2, '58' => -1, '65' => -1, '97' => -1, '101' => -1, '111' => -1, '117' => -1, },  # Y
    '90' => { },  # Z
    '91' => { },  # [
    '92' => { },  # \
    '93' => { },  # ]
    '94' => { },  # ^
    '95' => { },  # _
    '96' => { },  # `
    '97' => { },  # a
    '98' => { },  # b
    '99' => { },  # c
    '100' => { },  # d
    '101' => { },  # e
    '102' => { '46' => -1, },  # f
    '103' => { },  # g
    '104' => { },  # h
    '105' => { },  # i
    '106' => { },  # j
    '107' => { },  # k
    '108' => { },  # l
    '109' => { },  # m
    '110' => { },  # n
    '111' => { },  # o
    '112' => { },  # p
    '113' => { },  # q
    '114' => { '46' => -1, },  # r
    '115' => { },  # s
    '116' => { },  # t
    '117' => { },  # u
    '118' => { '46' => -1, },  # v
    '119' => { '46' => -1, },  # w
    '120' => { },  # x
    '121' => { '46' => -1, '58' => -1, },  # y
    '122' => { },  # z
    '123' => { },  # {
    '124' => { },  # |
    '125' => { },  # }
    '126' => { },  # ~
    '176' => { },  # °
};


sub new {
    my($class) = @_;
    
    my $self = $class->SUPER::new(
        name        => $name,
        char_height => $char_height,
        space_width => $space_width,
        gap_width   => $gap_width,
        symbols     => $symbols,
        kerning     => $kerning,
        line_spacing => $line_spacing,
        class       => 'hipi_2',
    );
    
    return $self;
}

1;

__END__
