#!/usr/bin/perl

package eBay::API::XML::DataType::FlatRateInsuranceRangeCostType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. FlatRateInsuranceRangeCostType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::FlatRateInsuranceRangeCostType

=head1 DESCRIPTION

A pairing of range and insurance cost.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::FlatRateInsuranceRangeCostType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::AmountType;
use eBay::API::XML::DataType::Enum::FlatRateInsuranceRangeCodeType;


my @gaProperties = ( [ 'FlatRateInsuranceRange', 'ns:FlatRateInsuranceRangeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::FlatRateInsuranceRangeCodeType', '' ]
	, [ 'InsuranceCost', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setFlatRateInsuranceRange()

The price range for the shipment for which the insurance cost is being specified.

  Calls: SetShippingDiscountProfiles
         SetUserPreferences
  RequiredInput: No

#    Argument: 'ns:FlatRateInsuranceRangeCodeType'

=cut

sub setFlatRateInsuranceRange {
  my $self = shift;
  $self->{'FlatRateInsuranceRange'} = shift
}

=head2 getFlatRateInsuranceRange()

  Calls: GetShippingDiscountProfiles
         GetUserPreferences
  Returned: Conditionally

#    Returns: 'ns:FlatRateInsuranceRangeCodeType'

=cut

sub getFlatRateInsuranceRange {
  my $self = shift;
  return $self->{'FlatRateInsuranceRange'};
}


=head2 setInsuranceCost()

The cost of insurance for the specified price range.

  Calls: SetShippingDiscountProfiles
         SetUserPreferences
  RequiredInput: No

#    Argument: 'ns:AmountType'

=cut

sub setInsuranceCost {
  my $self = shift;
  $self->{'InsuranceCost'} = shift
}

=head2 getInsuranceCost()

  Calls: GetShippingDiscountProfiles
         GetUserPreferences
  Returned: Conditionally

#    Returns: 'ns:AmountType'

=cut

sub getInsuranceCost {
  my $self = shift;
  return $self->_getDataTypeInstance( 'InsuranceCost'
		,'eBay::API::XML::DataType::AmountType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
