/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.resources.api.share;

import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.security.resources.ResourceAccessHandler;
import org.opensearch.security.resources.api.share.ShareRequest;
import org.opensearch.security.resources.api.share.ShareResponse;
import org.opensearch.security.resources.sharing.ResourceSharing;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class ShareTransportAction
extends HandledTransportAction<ShareRequest, ShareResponse> {
    private final ResourceAccessHandler resourceAccessHandler;

    @Inject
    public ShareTransportAction(TransportService transportService, ActionFilters actionFilters, ResourceAccessHandler resourceAccessHandler) {
        super("cluster:admin/security/resource/share", transportService, actionFilters, ShareRequest::new);
        this.resourceAccessHandler = resourceAccessHandler;
    }

    protected void doExecute(Task task, ShareRequest request, ActionListener<ShareResponse> listener) {
        ActionListener sharingInfoListener = ActionListener.wrap(resourceSharing -> listener.onResponse((Object)new ShareResponse((ResourceSharing)resourceSharing)), arg_0 -> listener.onFailure(arg_0));
        switch (request.getMethod()) {
            case GET: {
                this.resourceAccessHandler.getSharingInfo(request.id(), request.type(), (ActionListener<ResourceSharing>)sharingInfoListener);
                return;
            }
            case PATCH: 
            case POST: {
                this.resourceAccessHandler.patchSharingInfo(request.id(), request.type(), request.getAdd(), request.getRevoke(), (ActionListener<ResourceSharing>)sharingInfoListener);
                break;
            }
            case PUT: {
                this.resourceAccessHandler.share(request.id(), request.type(), request.getShareWith(), (ActionListener<ResourceSharing>)sharingInfoListener);
            }
        }
    }
}

