/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import java.io.IOException;
import org.jruby.ParseResult;
import org.jruby.RubyInstanceConfig;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.builder.IRBuilder;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.persistence.IRWriter;
import org.jruby.ir.persistence.IRWriterStream;
import org.jruby.ir.persistence.util.IRFileExpert;
import org.jruby.runtime.ThreadContext;

public abstract class IRTranslator<R, S> {
    public R execute(ThreadContext context, ParseResult result2, S specificObject) {
        IRScriptBody scope;
        if (result2 instanceof IRScriptBody) {
            scope = (IRScriptBody)result2;
        } else {
            InterpreterContext ic = IRBuilder.buildRoot(context.runtime.getIRManager(), result2);
            scope = (IRScriptBody)ic.getScope();
            scope.setScriptDynamicScope(result2.getDynamicScope());
            if (RubyInstanceConfig.IR_WRITING) {
                try {
                    IRWriter.persist(new IRWriterStream(IRFileExpert.getIRPersistedFile(scope.getFile())), scope);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
        }
        return this.execute(context, scope, specificObject);
    }

    protected abstract R execute(ThreadContext var1, IRScriptBody var2, S var3);
}

