/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.jsampler.CC;
import org.jsampler.JSPrefs;
import org.jsampler.view.std.JSChannelsDefaultSettingsPane;
import org.jsampler.view.std.StdI18n;
import org.linuxsampler.lscp.AudioOutputDriver;
import org.linuxsampler.lscp.MidiInputDriver;

public class JSDefaultsPropsPane
extends JPanel {
    private final ChannelDefaultsPane channelDefaultsPane;
    private final DefaultMidiDriverPane defaultMidiDriverPane = new DefaultMidiDriverPane();
    private final DefaultAudioDriverPane defaultAudioDriverPane = new DefaultAudioDriverPane();

    public JSDefaultsPropsPane(Dialog dialog, Icon icon) {
        this(dialog, icon, false);
    }

    public JSDefaultsPropsPane(Dialog dialog, Icon icon, boolean bl) {
        this.channelDefaultsPane = new ChannelDefaultsPane(dialog, icon, bl);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.channelDefaultsPane);
        this.add(Box.createRigidArea(new Dimension(0, 6)));
        this.add(this.defaultMidiDriverPane);
        this.add(Box.createRigidArea(new Dimension(0, 6)));
        this.add(this.defaultAudioDriverPane);
    }

    private static JSPrefs preferences() {
        return CC.getViewConfig().preferences();
    }

    public void apply() {
        this.channelDefaultsPane.apply();
        this.defaultMidiDriverPane.apply();
        this.defaultAudioDriverPane.apply();
    }

    public static class DefaultAudioDriverPane
    extends JPanel {
        private final JComboBox cbDriver = new JComboBox();

        public DefaultAudioDriverPane() {
            this.setLayout(new BoxLayout(this, 1));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            this.cbDriver.setAlignmentX(0.0f);
            int n = this.cbDriver.getPreferredSize().height;
            this.cbDriver.setMaximumSize(new Dimension(Short.MAX_VALUE, n));
            jPanel.add(this.cbDriver);
            jPanel.setAlignmentX(0.0f);
            jPanel.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
            this.add(jPanel);
            String string = StdI18n.i18n.getLabel("JSDefaultsPropsPane.titleAudioDriver");
            this.setBorder(BorderFactory.createTitledBorder(string));
            this.setAlignmentX(0.0f);
            if (CC.getSamplerModel().getAudioOutputDrivers() == null) {
                return;
            }
            for (AudioOutputDriver audioOutputDriver : CC.getSamplerModel().getAudioOutputDrivers()) {
                this.cbDriver.addItem(audioOutputDriver);
            }
            String string2 = JSDefaultsPropsPane.preferences().getStringProperty("defaultAudioDriver");
            for (AudioOutputDriver audioOutputDriver : CC.getSamplerModel().getAudioOutputDrivers()) {
                if (!audioOutputDriver.getName().equals(string2)) continue;
                this.cbDriver.setSelectedItem(audioOutputDriver);
                break;
            }
        }

        public void apply() {
            if (CC.getSamplerModel().getAudioOutputDrivers() == null) {
                return;
            }
            Object object = this.cbDriver.getSelectedItem();
            if (object == null) {
                JSDefaultsPropsPane.preferences().setStringProperty("defaultAudioDriver", null);
                return;
            }
            String string = ((AudioOutputDriver)object).getName();
            JSDefaultsPropsPane.preferences().setStringProperty("defaultAudioDriver", string);
        }
    }

    public static class DefaultMidiDriverPane
    extends JPanel {
        private final JComboBox cbDriver = new JComboBox();

        public DefaultMidiDriverPane() {
            this.setLayout(new BoxLayout(this, 1));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            this.cbDriver.setAlignmentX(0.0f);
            int n = this.cbDriver.getPreferredSize().height;
            this.cbDriver.setMaximumSize(new Dimension(Short.MAX_VALUE, n));
            jPanel.add(this.cbDriver);
            jPanel.setAlignmentX(0.0f);
            jPanel.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
            this.add(jPanel);
            String string = StdI18n.i18n.getLabel("JSDefaultsPropsPane.titleMidiDriver");
            this.setBorder(BorderFactory.createTitledBorder(string));
            this.setAlignmentX(0.0f);
            if (CC.getSamplerModel().getMidiInputDrivers() == null) {
                return;
            }
            for (MidiInputDriver midiInputDriver : CC.getSamplerModel().getMidiInputDrivers()) {
                this.cbDriver.addItem(midiInputDriver);
            }
            String string2 = JSDefaultsPropsPane.preferences().getStringProperty("defaultMidiDriver");
            for (MidiInputDriver midiInputDriver : CC.getSamplerModel().getMidiInputDrivers()) {
                if (!midiInputDriver.getName().equals(string2)) continue;
                this.cbDriver.setSelectedItem(midiInputDriver);
                break;
            }
        }

        public void apply() {
            if (CC.getSamplerModel().getMidiInputDrivers() == null) {
                return;
            }
            Object object = this.cbDriver.getSelectedItem();
            if (object == null) {
                JSDefaultsPropsPane.preferences().setStringProperty("defaultMidiDriver", null);
                return;
            }
            String string = ((MidiInputDriver)object).getName();
            JSDefaultsPropsPane.preferences().setStringProperty("defaultMidiDriver", string);
        }
    }

    public static class ChannelViewDefaultsPane
    extends JPanel {
        private final ComboBox cbDefaultView = new ComboBox();
        private final ComboBox cbMouseOverView = new ComboBox();
        private final JCheckBox checkMouseOverView = new JCheckBox(StdI18n.i18n.getLabel("JSDefaultsPropsPane.checkMouseOverView"));

        ChannelViewDefaultsPane() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            gridBagConstraints.fill = 0;
            String string = StdI18n.i18n.getLabel("JSDefaultsPropsPane.lDefaultChannelView");
            JLabel jLabel = new JLabel(string);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.add(jLabel);
            int n = JSDefaultsPropsPane.preferences().getIntProperty("defaultChannelView");
            this.cbDefaultView.setView(n);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.cbDefaultView, gridBagConstraints);
            this.add(this.cbDefaultView);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets = new Insets(9, 3, 3, 3);
            gridBagLayout.setConstraints(this.checkMouseOverView, gridBagConstraints);
            this.add(this.checkMouseOverView);
            n = JSDefaultsPropsPane.preferences().getIntProperty("channelViewOnMouseOver");
            this.cbMouseOverView.setView(n);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.insets = new Insets(0, 3, 5, 3);
            gridBagLayout.setConstraints(this.cbMouseOverView, gridBagConstraints);
            this.add(this.cbMouseOverView);
            this.setAlignmentX(0.0f);
            this.checkMouseOverView.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    cbMouseOverView.setEnabled(checkMouseOverView.isSelected());
                }
            });
            this.cbMouseOverView.setEnabled(false);
            if (JSDefaultsPropsPane.preferences().getBoolProperty("differentChannelViewOnMO")) {
                this.checkMouseOverView.doClick(0);
            }
        }

        public void apply() {
            int n = this.cbDefaultView.getSelectedIndex();
            JSDefaultsPropsPane.preferences().setIntProperty("defaultChannelView", n);
            boolean bl = this.checkMouseOverView.isSelected();
            JSDefaultsPropsPane.preferences().setBoolProperty("differentChannelViewOnMO", bl);
            n = this.cbMouseOverView.getSelectedIndex();
            JSDefaultsPropsPane.preferences().setIntProperty("channelViewOnMouseOver", n);
        }

        class ComboBox
        extends JComboBox {
            ComboBox() {
                String string = StdI18n.i18n.getLabel("JSDefaultsPropsPane.lSmallView");
                this.addItem(string);
                string = StdI18n.i18n.getLabel("JSDefaultsPropsPane.lNormalView");
                this.addItem(string);
            }

            public void setView(int n) {
                if (n < 0 || n >= this.getItemCount()) {
                    n = 1;
                }
                this.setSelectedIndex(n);
            }
        }
    }

    public static class ChannelDefaultsPane
    extends JPanel {
        private final Dialog owner;
        private final JCheckBox checkChannelDefaults = new JCheckBox(StdI18n.i18n.getLabel("JSDefaultsPropsPane.checkChannelDefaults"));
        private final JButton btnChannelDefaults;
        private ChannelViewDefaultsPane channelViewDefaultsPane = null;
        private final boolean showDefaultView;

        public ChannelDefaultsPane(Dialog dialog, Icon icon) {
            this(dialog, icon, false);
        }

        public ChannelDefaultsPane(Dialog dialog, Icon icon, boolean bl) {
            this.owner = dialog;
            this.showDefaultView = bl;
            this.btnChannelDefaults = new JButton(icon);
            this.btnChannelDefaults.setEnabled(false);
            this.btnChannelDefaults.setMargin(new Insets(0, 0, 0, 0));
            this.setLayout(new BoxLayout(this, 1));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.add(this.checkChannelDefaults);
            jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            jPanel.add(this.btnChannelDefaults);
            jPanel.setAlignmentX(0.0f);
            jPanel.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
            this.add(jPanel);
            String string = StdI18n.i18n.getLabel("JSDefaultsPropsPane.titleChannels");
            this.setBorder(BorderFactory.createTitledBorder(string));
            this.setAlignmentX(0.0f);
            this.checkChannelDefaults.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    btnChannelDefaults.setEnabled(checkChannelDefaults.isSelected());
                }
            });
            if (JSDefaultsPropsPane.preferences().getBoolProperty("samplerChannel.useDefaultActions")) {
                this.checkChannelDefaults.doClick(0);
            }
            this.btnChannelDefaults.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.editChannelDefaults();
                }
            });
            if (bl) {
                this.add(Box.createRigidArea(new Dimension(0, 6)));
                this.add(new JSeparator());
                this.add(Box.createRigidArea(new Dimension(0, 6)));
                this.channelViewDefaultsPane = new ChannelViewDefaultsPane();
                this.add(this.channelViewDefaultsPane);
            }
            this.setMaximumSize(new Dimension(Short.MAX_VALUE, this.getPreferredSize().height));
        }

        public void apply() {
            boolean bl = this.checkChannelDefaults.isSelected();
            JSDefaultsPropsPane.preferences().setBoolProperty("samplerChannel.useDefaultActions", bl);
            if (this.showDefaultView) {
                this.channelViewDefaultsPane.apply();
            }
        }

        protected void editChannelDefaults() {
            JDialog jDialog = new JSChannelsDefaultSettingsPane().createDialog(this.owner);
            jDialog.setVisible(true);
        }
    }
}

