/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.fantasia;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.jsampler.CC;
import org.jsampler.OrchestraModel;
import org.jsampler.event.ListEvent;
import org.jsampler.event.ListListener;
import org.jsampler.event.OrchestraAdapter;
import org.jsampler.event.OrchestraEvent;
import org.jsampler.view.fantasia.FantasiaI18n;
import org.jsampler.view.fantasia.FantasiaPrefs;
import org.jsampler.view.fantasia.FantasiaUtils;
import org.jsampler.view.fantasia.Res;
import org.jsampler.view.fantasia.ToolbarButton;
import org.jsampler.view.fantasia.basic.FantasiaPanel;
import org.jsampler.view.fantasia.basic.FantasiaSubPanel;
import org.jsampler.view.fantasia.basic.FantasiaTaskPane;
import org.jsampler.view.std.JSManageOrchestrasPane;
import org.jsampler.view.std.JSOrchestraPane;

public class OrchestrasPane
extends JPanel {
    private final JPanel taskPaneContainer = new JPanel();
    private final FantasiaTaskPane orchestrasTaskPane = new FantasiaTaskPane();
    private ManageOrchestrasPane manageOrchestrasPane = new ManageOrchestrasPane();
    private final JComboBox cbOrchestras = new JComboBox();
    private final OrchestraPane orchestraPane = new OrchestraPane();
    private int orchIdx;
    private final Handler eventHandler = new Handler();

    public OrchestrasPane() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.orchestrasTaskPane.setTitle(FantasiaI18n.i18n.getLabel("OrchestrasPane.orchestrasTaskPane"));
        FantasiaSubPanel fantasiaSubPanel = new FantasiaSubPanel(false, true, false);
        fantasiaSubPanel.add(this.manageOrchestrasPane);
        this.orchestrasTaskPane.add(fantasiaSubPanel);
        this.orchestrasTaskPane.setAnimated(FantasiaPrefs.preferences().getBoolProperty("animated"));
        boolean bl = FantasiaPrefs.preferences().getBoolProperty("OrchestrasPane.orchestrasTaskPane.expanded");
        this.orchestrasTaskPane.setCollapsed(!bl);
        FantasiaPrefs.preferences().addPropertyChangeListener("animated", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = FantasiaPrefs.preferences().getBoolProperty("animated");
                OrchestrasPane.this.orchestrasTaskPane.setAnimated(bl);
            }
        });
        this.taskPaneContainer.setOpaque(false);
        this.taskPaneContainer.setLayout(new BorderLayout());
        this.taskPaneContainer.add(this.orchestrasTaskPane);
        this.taskPaneContainer.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.taskPaneContainer, "North");
        this.add(new InstrumentsPane());
        this.orchIdx = FantasiaPrefs.preferences().getIntProperty("OrchestrasPane.OrchestraIndex", 0);
        this.cbOrchestras.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrchestrasPane.this.orchestraChanged();
            }
        });
        for (int i = 0; i < CC.getOrchestras().getOrchestraCount(); ++i) {
            this.cbOrchestras.addItem(CC.getOrchestras().getOrchestra(i));
        }
        CC.getOrchestras().addOrchestraListListener(this.getHandler());
        this.cbOrchestras.setEnabled(this.cbOrchestras.getItemCount() != 0);
        if (CC.getOrchestras().getOrchestraCount() > this.orchIdx) {
            this.cbOrchestras.setSelectedIndex(this.orchIdx);
            this.orchIdx = -1;
        }
    }

    public void savePreferences() {
        boolean bl = !this.orchestrasTaskPane.isCollapsed();
        FantasiaPrefs.preferences().setBoolProperty("OrchestrasPane.orchestrasTaskPane.expanded", bl);
    }

    private void orchestraChanged() {
        int n;
        OrchestraModel orchestraModel = (OrchestraModel)this.cbOrchestras.getSelectedItem();
        this.orchestraPane.setOrchestra(orchestraModel);
        if (orchestraModel != null) {
            String string = orchestraModel.getDescription();
            if (string != null && string.length() == 0) {
                string = null;
            }
            this.cbOrchestras.setToolTipText(string);
        }
        if ((n = this.cbOrchestras.getSelectedIndex()) >= 0) {
            FantasiaPrefs.preferences().setIntProperty("OrchestrasPane.OrchestraIndex", n);
        }
    }

    private Handler getHandler() {
        return this.eventHandler;
    }

    private class Handler
    extends OrchestraAdapter
    implements ListListener<OrchestraModel> {
        private Handler() {
        }

        @Override
        public void entryAdded(ListEvent<OrchestraModel> listEvent) {
            if (OrchestrasPane.this.cbOrchestras.getItemCount() == 0) {
                OrchestrasPane.this.cbOrchestras.setEnabled(true);
            }
            OrchestrasPane.this.cbOrchestras.addItem(listEvent.getEntry());
            if (OrchestrasPane.this.orchIdx != -1 && OrchestrasPane.this.cbOrchestras.getItemCount() > OrchestrasPane.this.orchIdx) {
                OrchestrasPane.this.cbOrchestras.setSelectedIndex(OrchestrasPane.this.orchIdx);
                OrchestrasPane.this.orchIdx = -1;
            }
        }

        @Override
        public void entryRemoved(ListEvent<OrchestraModel> listEvent) {
            OrchestrasPane.this.cbOrchestras.removeItem(listEvent.getEntry());
            if (OrchestrasPane.this.cbOrchestras.getItemCount() == 0) {
                OrchestrasPane.this.cbOrchestras.setEnabled(false);
            }
            if (OrchestrasPane.this.orchIdx != -1) {
                OrchestrasPane.this.orchIdx = -1;
            }
        }

        @Override
        public void nameChanged(OrchestraEvent orchestraEvent) {
        }

        @Override
        public void descriptionChanged(OrchestraEvent orchestraEvent) {
        }
    }

    class OrchestraPane
    extends JSOrchestraPane {
        OrchestraPane() {
            this.actionAddInstrument.putValue("SmallIcon", Res.iconNew16);
            this.actionEditInstrument.putValue("SmallIcon", Res.iconEdit16);
            this.actionDeleteInstrument.putValue("SmallIcon", Res.iconDelete16);
            this.removeAll();
            JToolBar jToolBar = FantasiaUtils.createSubToolBar();
            jToolBar.add(new ToolbarButton(this.actionAddInstrument));
            jToolBar.add(new ToolbarButton(this.actionEditInstrument));
            jToolBar.add(new ToolbarButton(this.actionDeleteInstrument));
            jToolBar.setFloatable(false);
            this.add((Component)jToolBar, "North");
            JScrollPane jScrollPane = new JScrollPane(this.instrumentTable);
            Dimension dimension = new Dimension(jScrollPane.getMinimumSize().width, jScrollPane.getPreferredSize().height);
            jScrollPane.setPreferredSize(dimension);
            JPanel jPanel = FantasiaUtils.createBottomSubPane();
            jPanel.add(jScrollPane);
            this.add(jPanel);
        }
    }

    class ManageOrchestrasPane
    extends JSManageOrchestrasPane {
        ManageOrchestrasPane() {
            this.actionAddOrchestra.putValue("SmallIcon", Res.iconNew16);
            this.actionEditOrchestra.putValue("SmallIcon", Res.iconEdit16);
            this.actionDeleteOrchestra.putValue("SmallIcon", Res.iconDelete16);
            this.removeAll();
            JToolBar jToolBar = FantasiaUtils.createSubToolBar();
            jToolBar.add(new ToolbarButton(this.actionAddOrchestra));
            jToolBar.add(new ToolbarButton(this.actionEditOrchestra));
            jToolBar.add(new ToolbarButton(this.actionDeleteOrchestra));
            this.add((Component)jToolBar, "North");
            JScrollPane jScrollPane = new JScrollPane(this.orchestraTable);
            jScrollPane.setPreferredSize(new Dimension(120, 130));
            JPanel jPanel = FantasiaUtils.createBottomSubPane();
            jPanel.add(jScrollPane);
            this.add(jPanel);
        }
    }

    class InstrumentsPane
    extends JPanel {
        InstrumentsPane() {
            this.setOpaque(false);
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
            FantasiaSubPanel fantasiaSubPanel = new FantasiaSubPanel(true, false);
            fantasiaSubPanel.setLayout(new BoxLayout(fantasiaSubPanel, 1));
            fantasiaSubPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            FantasiaPanel fantasiaPanel = new FantasiaPanel();
            fantasiaPanel.setOpaque(false);
            fantasiaPanel.setLayout(new BoxLayout(fantasiaPanel, 0));
            fantasiaPanel.add(OrchestrasPane.this.cbOrchestras);
            fantasiaPanel.setBorder(BorderFactory.createEmptyBorder(3, 1, 5, 1));
            fantasiaSubPanel.add(fantasiaPanel);
            FantasiaSubPanel fantasiaSubPanel2 = new FantasiaSubPanel(false, true, false);
            fantasiaSubPanel2.add(OrchestrasPane.this.orchestraPane);
            fantasiaSubPanel.add(fantasiaSubPanel2);
            this.add(fantasiaSubPanel);
        }
    }
}

