/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.earproject.EarActionProvider;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class EarProjectOperations
implements DeleteOperationImplementation,
CopyOperationImplementation,
MoveOperationImplementation {
    private final EarProject project;
    private String libraryPath;
    private File libraryFile;
    private boolean libraryWithinProject;
    private String absolutesRelPath;

    public EarProjectOperations(EarProject project) {
        this.project = project;
    }

    private static void addFile(FileObject projectDirectory, String fileName, List<FileObject> result) {
        FileObject file = projectDirectory.getFileObject(fileName);
        if (file != null) {
            result.add(file);
        }
    }

    public List<FileObject> getMetadataFiles() {
        FileObject projectDirectory = this.project.getProjectDirectory();
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        EarProjectOperations.addFile(projectDirectory, "nbproject", files);
        EarProjectOperations.addFile(projectDirectory, "build.xml", files);
        EarProjectOperations.addFile(projectDirectory, "src", files);
        EarProjectOperations.addFile(projectDirectory, ".cvsignore", files);
        return files;
    }

    public List<FileObject> getDataFiles() {
        File f;
        AntProjectHelper helper = this.project.getAntProjectHelper();
        if (helper.getLibrariesLocation() != null && (f = helper.resolveFile(helper.getLibrariesLocation())) != null && f.exists()) {
            FileObject libFolder = FileUtil.toFileObject((File)f).getParent();
            if (FileUtil.isParentOf((FileObject)this.project.getProjectDirectory(), (FileObject)libFolder)) {
                return Collections.singletonList(libFolder);
            }
        }
        return Collections.emptyList();
    }

    public void notifyDeleting() throws IOException {
        EarActionProvider ap = (EarActionProvider)this.project.getLookup().lookup(EarActionProvider.class);
        assert (ap != null);
        Lookup context = Lookups.fixed((Object[])new Object[0]);
        Properties p = new Properties();
        String[] targetNames = ap.getTargetNames("clean", context, p);
        FileObject buildXML = this.project.getProjectDirectory().getFileObject("build.xml");
        assert (targetNames != null);
        assert (targetNames.length > 0);
        ActionUtils.runTarget((FileObject)buildXML, (String[])targetNames, (Properties)p).waitFinished();
    }

    public void notifyDeleted() throws IOException {
        this.project.getAntProjectHelper().notifyDeleted();
    }

    public void notifyCopying() {
        this.rememberLibraryLocation();
    }

    public void notifyCopied(Project original, File originalPath, String nueName) {
        if (original == null) {
            return;
        }
        EarProjectOperations origOperations = (EarProjectOperations)original.getLookup().lookup(EarProjectOperations.class);
        this.fixLibraryLocation(origOperations);
        this.project.setName(nueName);
    }

    public void notifyMoving() throws IOException {
        this.rememberLibraryLocation();
        this.notifyDeleting();
    }

    public void notifyMoved(Project original, File originalPath, final String newName) {
        if (original == null) {
            this.project.getAntProjectHelper().notifyDeleted();
            return;
        }
        EarProjectOperations origOperations = (EarProjectOperations)original.getLookup().lookup(EarProjectOperations.class);
        this.fixLibraryLocation(origOperations);
        final String oldProjectName = ((ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class)).getName();
        this.project.setName(newName);
        ProjectManager.mutex().writeAccess(new Runnable(){
            final /* synthetic */ EarProjectOperations this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                AntProjectHelper helper = this.this$0.project.getAntProjectHelper();
                EditableProperties projectProps = helper.getProperties("nbproject/project.properties");
                String earName = projectProps.get((Object)"jar.name");
                String oldName = earName.substring(0, earName.length() - 4);
                if (earName.endsWith(".ear") && oldName.equals(oldProjectName)) {
                    projectProps.put("jar.name", newName + ".ear");
                }
                helper.putProperties("nbproject/project.properties", projectProps);
            }
        });
    }

    private void fixLibraryLocation(EarProjectOperations original) throws IllegalArgumentException {
        String libPath = original.libraryPath;
        if (libPath != null) {
            if (!new File(libPath).isAbsolute()) {
                if (!original.libraryWithinProject) {
                    File file = original.libraryFile;
                    if (file == null) {
                        return;
                    }
                    String relativized = PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (File)file);
                    if (relativized != null) {
                        this.project.getAntProjectHelper().setLibrariesLocation(relativized);
                    } else {
                        this.project.getAntProjectHelper().setLibrariesLocation(file.getAbsolutePath());
                    }
                }
            } else if (original.libraryWithinProject && original.absolutesRelPath != null) {
                this.project.getAntProjectHelper().setLibrariesLocation(PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (String)original.absolutesRelPath).getAbsolutePath());
            }
        }
    }

    private void rememberLibraryLocation() {
        this.libraryWithinProject = false;
        this.absolutesRelPath = null;
        this.libraryPath = this.project.getAntProjectHelper().getLibrariesLocation();
        if (this.libraryPath != null) {
            File prjRoot = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
            this.libraryFile = PropertyUtils.resolveFile((File)prjRoot, (String)this.libraryPath);
            if (FileOwnerQuery.getOwner((URI)this.libraryFile.toURI()) == this.project && this.libraryFile.getAbsolutePath().startsWith(prjRoot.getAbsolutePath())) {
                this.libraryWithinProject = true;
                FileObject fo = FileUtil.toFileObject((File)this.libraryFile);
                if (new File(this.libraryPath).isAbsolute() && fo != null) {
                    this.absolutesRelPath = FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)fo);
                }
            }
        }
    }
}

