/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.launch;

import com.sun.jdi.VirtualMachine;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.jshell.spi.ExecutionControl;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.jshell.launch.AgentGenerator;
import org.netbeans.modules.jshell.launch.Bundle;
import org.netbeans.modules.jshell.launch.DebugExecutionEnvironment;
import org.netbeans.modules.jshell.launch.JShellConnection;
import org.netbeans.modules.jshell.launch.RemoteJShellAccessor;
import org.netbeans.modules.jshell.launch.RunExecutionEnvironment;
import org.netbeans.modules.jshell.launch.ShellLaunchEvent;
import org.netbeans.modules.jshell.launch.ShellLaunchManager;
import org.netbeans.modules.jshell.project.ShellProjectUtils;
import org.openide.windows.InputOutput;

public final class ShellAgent {
    private static final Logger LOG = Logger.getLogger(ShellAgent.class.getName());
    private final ShellLaunchManager mgr;
    private final Project project;
    private final ServerSocket handshakeSocket;
    private final boolean expectDebugger;
    private final String authorizationKey;
    private Session debuggerSession;
    private VirtualMachine debuggerMachine;
    private InetSocketAddress connectAddress;
    private InputOutput io;
    private volatile boolean closed;
    private String displayName;
    private List<JShellConnection> connections = new ArrayList<JShellConnection>();

    public ShellAgent(ShellLaunchManager mgr, Project project, ServerSocket handshakeSocket, String authKey, boolean expectDebugger) {
        this.mgr = mgr;
        this.authorizationKey = authKey;
        this.project = project;
        this.handshakeSocket = handshakeSocket;
        this.expectDebugger = expectDebugger;
        LOG.log(Level.FINE, "ShellAgent allocated. Project = {0}, socket = {1}, authKey = {2}, debugger = {3}", new Object[]{project, handshakeSocket, authKey, expectDebugger});
    }

    ServerSocket getHandshakeSocket() {
        return this.handshakeSocket;
    }

    public synchronized InputOutput getIO() {
        return this.io;
    }

    public synchronized void setIO(InputOutput io, String displayName) {
        if (!this.connections.isEmpty() || this.connectAddress != null) {
            throw new IllegalStateException("Cannot set I/O on already active agent");
        }
        this.io = io;
        this.displayName = displayName;
    }

    public synchronized String getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        String dn = ProjectUtils.getInformation((Project)this.project).getDisplayName();
        if (dn != null) {
            return dn;
        }
        return Bundle.LBL_ProjectShellName(this.project.getProjectDirectory().getPath());
    }

    public Project getProject() {
        return this.project;
    }

    public synchronized Session getDebuggerSession() {
        return this.debuggerSession;
    }

    public synchronized VirtualMachine getDebuggerMachine() {
        return this.debuggerMachine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() throws IOException {
        ArrayList<JShellConnection> conns;
        LOG.log(Level.FINE, "ShellAgent destroyed: authKey = {0}, socket = {1}", new Object[]{this.authorizationKey, this.handshakeSocket});
        ShellAgent shellAgent = this;
        synchronized (shellAgent) {
            this.handshakeSocket.close();
            if (this.closed) {
                return;
            }
            this.closed = true;
            conns = new ArrayList<JShellConnection>(this.connections);
        }
        for (JShellConnection c : conns) {
            this.disconnect(c, true);
        }
    }

    public InetSocketAddress getHandshakeAddress() {
        return (InetSocketAddress)this.handshakeSocket.getLocalSocketAddress();
    }

    public String getAuthorizationKey() {
        return this.authorizationKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void target(InetSocketAddress addr) throws IOException {
        Session curSession;
        ShellAgent shellAgent = this;
        synchronized (shellAgent) {
            if (this.connectAddress != null) {
                throw new IOException("Duplicated handshake from agent {0}: " + String.valueOf(addr));
            }
            this.connectAddress = addr;
            curSession = this.debuggerSession;
        }
        if (this.expectDebugger) {
            LOG.log(Level.FINE, "Agent authorized with {0}, expecting debuggger, have: {1}", new Object[]{this.authorizationKey, curSession});
            if (curSession == null) {
                Session debSession = this.mgr.findWaitingDebugger(this.authorizationKey);
                LOG.log(Level.FINE, "Searched for debugger session, got: {0}", debSession);
                this.attachDebugger(debSession);
                return;
            }
        }
        ShellLaunchEvent ev = new ShellLaunchEvent(this.mgr, this);
        this.mgr.fire(l -> l.handshakeCompleted(ev));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void attachDebugger(Session s) {
        boolean complete;
        if (s == null) {
            return;
        }
        ShellAgent shellAgent = this;
        synchronized (shellAgent) {
            if (this.debuggerSession != null && s != this.debuggerSession) {
                throw new IllegalStateException("Debugger already attached");
            }
            LOG.log(Level.FINE, "Attaching debugger session {0}, current session = {1}, connectAddress = {2}", new Object[]{s, this.debuggerSession, this.connectAddress});
            if (this.debuggerSession == s) {
                return;
            }
            this.debuggerSession = s;
            JPDADebugger dbg = (JPDADebugger)s.lookupFirst(null, JPDADebugger.class);
            this.debuggerMachine = ((JPDADebuggerImpl)dbg).getVirtualMachine();
            dbg.addPropertyChangeListener("state", e -> {
                if (dbg.getState() == 4) {
                    ShellLaunchManager.queueTask(() -> this.mgr.destroyAgent(this.authorizationKey), 5000);
                }
            });
            complete = this.connectAddress != null;
        }
        if (complete) {
            LOG.log(Level.FINE, "Firing handshake complete for {0}", this);
            ShellLaunchEvent ev = new ShellLaunchEvent(this.mgr, this);
            this.mgr.fire(l -> l.handshakeCompleted(ev));
        }
    }

    public void closeConnection(JShellConnection c) {
        this.disconnect(c, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect(JShellConnection c, boolean remote) {
        LOG.log(Level.FINE, "Connection closing: {0}, remove = {1}", new Object[]{c, remote});
        ShellAgent shellAgent = this;
        synchronized (shellAgent) {
            if (c == null || !this.connections.contains(c)) {
                return;
            }
            this.connections.remove(c);
        }
        c.shutDown();
        if (this.closed) {
            return;
        }
        if (this.handshakeSocket.isClosed()) {
            this.mgr.destroyAgent(this.authorizationKey);
        } else {
            ShellLaunchEvent ev = new ShellLaunchEvent(this.mgr, c, remote);
            this.mgr.fire(l -> l.connectionClosed(ev));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JShellConnection createConnection() throws IOException {
        ShellAgent shellAgent = this;
        synchronized (shellAgent) {
            if (this.closed) {
                throw new IOException(Bundle.MSG_AgentConnectionBroken());
            }
            if (this.expectDebugger && this.debuggerMachine == null) {
                return null;
            }
        }
        SocketChannel sc = SocketChannel.open();
        sc.configureBlocking(true);
        Socket sock = sc.socket();
        sock.connect(this.connectAddress, 5000000);
        sc.configureBlocking(false);
        boolean notify = false;
        JShellConnection con = new JShellConnection(this, sock.getChannel());
        ShellAgent shellAgent2 = this;
        synchronized (shellAgent2) {
            this.connections.add(con);
        }
        if (notify) {
            ShellLaunchEvent ev = new ShellLaunchEvent(this.mgr, con, false);
            this.mgr.fire(l -> l.connectionInitiated(ev));
        }
        return con;
    }

    public RemoteJShellAccessor createRemoteService() throws IOException {
        String targetSpec;
        JavaPlatform plat = ShellProjectUtils.findPlatform(this.project);
        String string = targetSpec = plat == null || plat == JavaPlatform.getDefault() ? null : plat.getSpecification().getVersion().toString();
        if (this.expectDebugger) {
            if (this.debuggerSession == null) {
                throw new IOException("Debugger unavailable");
            }
            return new Debug(this, targetSpec);
        }
        try {
            return new Runtime(this, targetSpec);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public synchronized boolean isReady() {
        if (this.closed) {
            return false;
        }
        return this.connectAddress != null && (!this.expectDebugger || this.debuggerSession != null);
    }

    static class Debug
    extends AgentGenerator {
        public Debug(ShellAgent agent, String targetSpec) {
            super(agent, targetSpec);
        }

        @Override
        public String name() {
            return this.getClass().getName();
        }

        @Override
        protected ExecutionControl createExecControl(ShellAgent agent, ObjectOutput out, ObjectInput in, JShellConnection c) {
            return new DebugExecutionEnvironment(agent, out, in, c.getVirtualMachine(), c);
        }
    }

    static class Runtime
    extends AgentGenerator {
        private final String targetSpec;

        public Runtime(ShellAgent agent, String targetSpec) {
            super(agent, targetSpec);
            this.targetSpec = targetSpec;
        }

        @Override
        public String name() {
            return this.getClass().getName();
        }

        @Override
        protected ExecutionControl createExecControl(ShellAgent agent, ObjectOutput out, ObjectInput in, JShellConnection c) {
            return new RunExecutionEnvironment(agent, out, in, this.targetSpec, c);
        }
    }
}

