/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.java.lexer.JavadocTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.spi.editor.bracesmatching.BracesMatcher;
import org.netbeans.spi.editor.bracesmatching.BracesMatcherFactory;
import org.netbeans.spi.editor.bracesmatching.MatcherContext;
import org.netbeans.spi.editor.bracesmatching.support.BracesMatcherSupport;

public final class JavadocBracesMatcher
implements BracesMatcher,
BracesMatcherFactory {
    private static final Logger LOG = Logger.getLogger(JavadocBracesMatcher.class.getName());
    private static final Collection<String> VOID_TAGS = new HashSet<String>(Arrays.asList("<area>", "<base>", "<br>", "<col>", "<command>", "<embed>", "<hr>", "<img>", "<input>", "<keygen>", "<link>", "<meta>", "<param>", "<source>", "<track>", "<wbr>"));
    private final MatcherContext context;
    private TokenSequence<? extends TokenId> jdocSeq;
    private int jdocStart;
    private int jdocEnd;
    private BracesMatcher defaultMatcher;

    public JavadocBracesMatcher() {
        this(null);
    }

    private JavadocBracesMatcher(MatcherContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findOrigin() throws BadLocationException, InterruptedException {
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            int caretOffset = this.context.getSearchOffset();
            boolean backward = this.context.isSearchingBackward();
            TokenHierarchy th = TokenHierarchy.get((Document)this.context.getDocument());
            List sequences = th.embeddedTokenSequences(caretOffset, backward);
            for (int i = sequences.size() - 1; i >= 0; --i) {
                TokenSequence seq = (TokenSequence)sequences.get(i);
                if (seq.language() != JavadocTokenId.language()) continue;
                this.jdocSeq = seq;
                if (i > 0) {
                    TokenSequence javaSeq = (TokenSequence)sequences.get(i - 1);
                    this.jdocStart = javaSeq.offset();
                    this.jdocEnd = javaSeq.offset() + javaSeq.token().length();
                    break;
                }
                this.jdocStart = 0;
                this.jdocEnd = this.context.getDocument().getLength();
                break;
            }
            if (this.jdocSeq == null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Not javadoc TokenSequence.");
                }
                int[] nArray = null;
                return nArray;
            }
            this.jdocSeq.move(caretOffset);
            if (this.jdocSeq.moveNext()) {
                if (!(!JavadocBracesMatcher.isTag((Token<? extends TokenId>)this.jdocSeq.token()) || JavadocBracesMatcher.isTypeParameterTag(this.jdocSeq) || JavadocBracesMatcher.isUninterpretedTag(this.jdocSeq) || this.jdocSeq.offset() >= caretOffset && backward)) {
                    int[] nArray = JavadocBracesMatcher.prepareOffsets(this.jdocSeq, true);
                    return nArray;
                }
                while (this.moveTheSequence(this.jdocSeq, backward, this.context.getLimitOffset())) {
                    if (!JavadocBracesMatcher.isTag((Token<? extends TokenId>)this.jdocSeq.token())) continue;
                    if (JavadocBracesMatcher.isTypeParameterTag(this.jdocSeq) || JavadocBracesMatcher.isUninterpretedTag(this.jdocSeq)) break;
                    int[] nArray = JavadocBracesMatcher.prepareOffsets(this.jdocSeq, true);
                    return nArray;
                }
            }
            this.defaultMatcher = BracesMatcherSupport.defaultMatcher((MatcherContext)this.context, (int)this.jdocStart, (int)this.jdocEnd);
            int[] nArray = this.defaultMatcher.findOrigin();
            return nArray;
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findMatches() throws InterruptedException, BadLocationException {
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            if (this.defaultMatcher != null) {
                int[] nArray = this.defaultMatcher.findMatches();
                return nArray;
            }
            assert (this.jdocSeq != null) : "No javadoc token sequence";
            Token tag = this.jdocSeq.token();
            assert (tag.id() == JavadocTokenId.HTML_TAG) : "Wrong token";
            if (JavadocBracesMatcher.isSingleTag((Token<? extends TokenId>)tag) || JavadocBracesMatcher.isVoidTag((Token<? extends TokenId>)tag)) {
                int[] nArray = new int[]{this.jdocSeq.offset(), this.jdocSeq.offset() + this.jdocSeq.token().length()};
                return nArray;
            }
            boolean backward = !JavadocBracesMatcher.isOpeningTag((Token<? extends TokenId>)tag);
            int cnt = 0;
            while (this.moveTheSequence(this.jdocSeq, backward, -1)) {
                if (!JavadocBracesMatcher.isTag((Token<? extends TokenId>)this.jdocSeq.token()) || !JavadocBracesMatcher.matchTags((Token<? extends TokenId>)tag, (Token<? extends TokenId>)this.jdocSeq.token())) continue;
                if (backward && !JavadocBracesMatcher.isOpeningTag((Token<? extends TokenId>)this.jdocSeq.token()) || !backward && JavadocBracesMatcher.isOpeningTag((Token<? extends TokenId>)this.jdocSeq.token())) {
                    ++cnt;
                    continue;
                }
                if (cnt == 0) {
                    int[] nArray = JavadocBracesMatcher.prepareOffsets(this.jdocSeq, false);
                    return nArray;
                }
                --cnt;
            }
            int[] nArray = null;
            return nArray;
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
    }

    private boolean moveTheSequence(TokenSequence<? extends TokenId> seq, boolean backward, int offsetLimit) {
        if (backward) {
            if (seq.movePrevious()) {
                int e = seq.offset() + seq.token().length();
                return offsetLimit == -1 ? true : e > offsetLimit;
            }
        } else if (seq.moveNext()) {
            int s = seq.offset();
            return offsetLimit == -1 ? true : s < offsetLimit;
        }
        return false;
    }

    private static boolean isTag(Token<? extends TokenId> tag) {
        boolean b;
        CharSequence s = tag.text();
        int l = s.length();
        boolean bl = b = tag.id() == JavadocTokenId.HTML_TAG && l >= 3 && s.charAt(0) == '<' && s.charAt(l - 1) == '>';
        if (b) {
            b = s.charAt(1) == '/' ? l >= 4 && Character.isLetterOrDigit(s.charAt(2)) : Character.isLetterOrDigit(s.charAt(1));
        }
        return b;
    }

    private static boolean isSingleTag(Token<? extends TokenId> tag) {
        return TokenUtilities.endsWith((CharSequence)tag.text(), (CharSequence)"/>");
    }

    private static boolean isVoidTag(Token<? extends TokenId> tag) {
        return VOID_TAGS.contains(tag.text().toString());
    }

    private static boolean isOpeningTag(Token<? extends TokenId> tag) {
        return !TokenUtilities.startsWith((CharSequence)tag.text(), (CharSequence)"</");
    }

    private static boolean isTypeParameterTag(TokenSequence<? extends TokenId> seq) {
        int index = seq.index();
        try {
            if (!seq.movePrevious() || seq.token().id() != JavadocTokenId.OTHER_TEXT) {
                boolean bl = false;
                return bl;
            }
            boolean bl = seq.movePrevious() && seq.token().id() == JavadocTokenId.TAG && "@param".contentEquals(seq.token().text());
            return bl;
        }
        finally {
            seq.moveIndex(index);
            seq.moveNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isUninterpretedTag(TokenSequence<? extends TokenId> seq) {
        int index = seq.index();
        try {
            boolean lastCheck = false;
            while (seq.movePrevious()) {
                Token token = seq.token();
                if (token.id() == JavadocTokenId.OTHER_TEXT) {
                    if (lastCheck) {
                        boolean bl = token.text().charAt(token.length() - 1) == '{';
                        return bl;
                    }
                    if (TokenUtilities.indexOf((CharSequence)token.text(), (int)125) >= 0) {
                        boolean bl = false;
                        return bl;
                    }
                }
                if (token.id() != JavadocTokenId.TAG) continue;
                CharSequence text = token.text();
                lastCheck = "@literal".contentEquals(text) || "@code".contentEquals(text);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            seq.moveIndex(index);
            seq.moveNext();
        }
    }

    private static boolean matchTags(Token<? extends TokenId> t1, Token<? extends TokenId> t2) {
        assert (t1.length() >= 2 && t1.text().charAt(0) == '<') : String.valueOf(t1) + " is not a tag.";
        assert (t2.length() >= 2 && t2.text().charAt(0) == '<') : String.valueOf(t2) + " is not a tag.";
        int idx1 = 1;
        int idx2 = 1;
        if (t1.text().charAt(1) == '/') {
            ++idx1;
        }
        if (t2.text().charAt(1) == '/') {
            ++idx2;
        }
        while (idx1 < t1.length() && idx2 < t2.length()) {
            char ch2;
            char ch1 = t1.text().charAt(idx1);
            if (ch1 != (ch2 = t2.text().charAt(idx2))) {
                return !Character.isLetterOrDigit(ch1) || !Character.isLetterOrDigit(ch2);
            }
            if (!Character.isLetterOrDigit(ch1)) {
                return true;
            }
            ++idx1;
            ++idx2;
        }
        return false;
    }

    private static int[] prepareOffsets(TokenSequence<? extends TokenId> seq, boolean includeToken) {
        int s = seq.offset();
        int e = seq.offset() + seq.token().length();
        CharSequence token = seq.token().text();
        if (token.charAt(1) == '/') {
            return new int[]{s, e};
        }
        int he = e;
        for (int i = 1; i < token.length(); ++i) {
            char ch = token.charAt(i);
            if (Character.isLetterOrDigit(ch) || ch == '>') continue;
            he = s + i;
            break;
        }
        if (includeToken) {
            return new int[]{s, e, s, he};
        }
        return new int[]{s, he};
    }

    public BracesMatcher createMatcher(MatcherContext context) {
        return new JavadocBracesMatcher(context);
    }
}

