/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.execute;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.extexecution.base.ExplicitProcessParameters;
import org.netbeans.api.extexecution.startup.StartupExtender;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.java.api.ProjectActions;
import org.netbeans.modules.gradle.spi.actions.ReplaceTokenProvider;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class JavaExecTokenProvider
implements ReplaceTokenProvider {
    public static String TOKEN_JAVAEXEC_JVMARGS = ProjectActions.TOKEN_JAVAEXEC_JVMARGS;
    public static String TOKEN_JAVAEXEC_ARGS = ProjectActions.TOKEN_JAVAEXEC_ARGS;
    public static String TOKEN_JAVAEXEC_CWD = ProjectActions.TOKEN_JAVAEXEC_CWD;
    public static String TOKEN_JAVAEXEC_ENV = ProjectActions.TOKEN_JAVAEXEC_ENV;
    public static String TOKEN_JAVA_ARGS = "java.args";
    public static String TOKEN_JAVA_JVMARGS = "java.jvmArgs";
    public static String TOKEN_JAVA_CWD = "java.workingDir";
    public static String TOKEN_JAVA_ENV = "java.environment";
    private static final Set<String> TOKENS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(TOKEN_JAVAEXEC_ARGS, TOKEN_JAVAEXEC_JVMARGS, TOKEN_JAVA_ARGS, TOKEN_JAVA_JVMARGS)));
    private final Project project;

    public JavaExecTokenProvider(Project project) {
        this.project = project;
    }

    public Set<String> getSupportedTokens() {
        return this.isEnabled() ? TOKENS : Collections.emptySet();
    }

    private boolean isEnabled() {
        Set plugins = GradleBaseProject.get((Project)this.project).getPlugins();
        return plugins.contains("java");
    }

    public Map<String, String> createReplacements(String action, Lookup context) {
        String prop;
        List params;
        if (!this.isEnabled()) {
            return Collections.emptyMap();
        }
        StartupExtender.StartMode mode = switch (action) {
            case "run", "run.single" -> StartupExtender.StartMode.NORMAL;
            case "debug", "debug.single" -> StartupExtender.StartMode.DEBUG;
            case "profile", "profile.single" -> StartupExtender.StartMode.PROFILE;
            case "test", "test.single" -> StartupExtender.StartMode.TEST_NORMAL;
            case "debug.test.single" -> StartupExtender.StartMode.TEST_DEBUG;
            case "profile.test.single" -> StartupExtender.StartMode.TEST_PROFILE;
            default -> null;
        };
        InstanceContent ic = new InstanceContent();
        if (this.project != null) {
            ic.add((Object)this.project);
        }
        ArrayList extraArgs = new ArrayList();
        if (mode != null) {
            for (StartupExtender group : StartupExtender.getExtenders((Lookup)new AbstractLookup((AbstractLookup.Content)ic), (StartupExtender.StartMode)mode)) {
                extraArgs.addAll(group.getRawArguments());
            }
        }
        ExplicitProcessParameters contextParams = ExplicitProcessParameters.buildExplicitParameters((Lookup)context);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(TOKEN_JAVAEXEC_ARGS, "");
        result.put(TOKEN_JAVAEXEC_JVMARGS, "");
        result.put(TOKEN_JAVAEXEC_CWD, "");
        result.put(TOKEN_JAVAEXEC_ENV, "");
        result.put(TOKEN_JAVA_ARGS, "");
        result.put(TOKEN_JAVA_JVMARGS, "");
        result.put(TOKEN_JAVA_CWD, "");
        result.put(TOKEN_JAVA_ENV, "");
        if (extraArgs.isEmpty() && contextParams.isEmpty()) {
            return result;
        }
        ExplicitProcessParameters changedParams = ExplicitProcessParameters.builder().combine(contextParams).build();
        if (changedParams.getLauncherArguments() != null) {
            params = changedParams.getLauncherArguments();
            String jvmArgs = Utilities.escapeParameters((String[])params.toArray(new String[0]));
            result.put(TOKEN_JAVA_JVMARGS, jvmArgs);
            prop = Utilities.escapeParameters((String[])new String[]{"-PrunJvmArgs=" + jvmArgs});
            result.put(TOKEN_JAVAEXEC_JVMARGS, prop);
        }
        if (changedParams.getArguments() != null && !changedParams.getArguments().isEmpty()) {
            params = changedParams.getArguments();
            String args = Utilities.escapeParameters((String[])params.toArray(new String[0]));
            prop = Utilities.escapeParameters((String[])new String[]{args});
            result.put(TOKEN_JAVA_ARGS, args);
            result.put(TOKEN_JAVAEXEC_ARGS, "--args " + prop);
        }
        if (changedParams.getWorkingDirectory() != null) {
            String wd = Utilities.escapeParameters((String[])new String[]{changedParams.getWorkingDirectory().getAbsolutePath()});
            result.put(TOKEN_JAVA_CWD, wd);
            String prop2 = Utilities.escapeParameters((String[])new String[]{"-PrunWorkingDir=" + wd});
            result.put(TOKEN_JAVAEXEC_CWD, prop2);
        }
        if (!changedParams.getEnvironmentVariables().isEmpty()) {
            ArrayList<CallSite> envParams = new ArrayList<CallSite>(changedParams.getEnvironmentVariables().size());
            for (Map.Entry entry : changedParams.getEnvironmentVariables().entrySet()) {
                if (entry.getValue() != null) {
                    envParams.add((CallSite)((Object)((String)entry.getKey() + "=" + (String)entry.getValue())));
                    continue;
                }
                envParams.add((CallSite)((Object)("!" + (String)entry.getKey())));
            }
            String env = Utilities.escapeParameters((String[])envParams.toArray(new String[0]));
            result.put(TOKEN_JAVA_ENV, env);
            prop = Utilities.escapeParameters((String[])new String[]{"-PrunEnvironment=" + env});
            result.put(TOKEN_JAVAEXEC_ENV, prop);
        }
        return result;
    }
}

