/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene90;

import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.lucene.codecs.compressing.CompressionMode;
import org.apache.lucene.codecs.compressing.Compressor;
import org.apache.lucene.codecs.compressing.Decompressor;
import org.apache.lucene.codecs.lucene90.BugfixDeflater_JDK8252739;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.store.ByteBuffersDataInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;

public final class DeflateWithPresetDictCompressionMode
extends CompressionMode {
    private static final int NUM_SUB_BLOCKS = 10;
    private static final int DICT_SIZE_FACTOR = 6;

    @Override
    public Compressor newCompressor() {
        return new DeflateWithPresetDictCompressor(6);
    }

    @Override
    public Decompressor newDecompressor() {
        return new DeflateWithPresetDictDecompressor();
    }

    public String toString() {
        return "BEST_COMPRESSION";
    }

    private static class DeflateWithPresetDictCompressor
    extends Compressor {
        final Deflater compressor;
        final BugfixDeflater_JDK8252739 deflaterBugfix;
        byte[] compressed;
        boolean closed;
        byte[] buffer;

        DeflateWithPresetDictCompressor(int level) {
            this.compressor = new Deflater(level, true);
            this.deflaterBugfix = BugfixDeflater_JDK8252739.createBugfix(this.compressor);
            this.compressed = new byte[64];
            this.buffer = BytesRef.EMPTY_BYTES;
        }

        private void doCompress(byte[] bytes, int off, int len, DataOutput out) throws IOException {
            if (len == 0) {
                out.writeVInt(0);
                return;
            }
            this.compressor.setInput(bytes, off, len);
            this.compressor.finish();
            if (this.compressor.needsInput()) {
                throw new IllegalStateException();
            }
            int totalCount = 0;
            while (true) {
                int count = this.compressor.deflate(this.compressed, totalCount, this.compressed.length - totalCount);
                assert ((totalCount += count) <= this.compressed.length);
                if (this.compressor.finished()) break;
                this.compressed = ArrayUtil.grow(this.compressed);
            }
            out.writeVInt(totalCount);
            out.writeBytes(this.compressed, totalCount);
        }

        @Override
        public void compress(ByteBuffersDataInput buffersInput, DataOutput out) throws IOException {
            int len = (int)(buffersInput.size() - buffersInput.position());
            int dictLength = len / 60;
            int blockLength = (len - dictLength + 10 - 1) / 10;
            out.writeVInt(dictLength);
            out.writeVInt(blockLength);
            this.compressor.reset();
            this.buffer = ArrayUtil.growNoCopy(this.buffer, dictLength + blockLength);
            buffersInput.readBytes(this.buffer, 0, dictLength);
            this.doCompress(this.buffer, 0, dictLength, out);
            for (int start = dictLength; start < len; start += blockLength) {
                this.compressor.reset();
                this.deflaterBugfix.setDictionary(this.buffer, 0, dictLength);
                int l = Math.min(blockLength, len - start);
                buffersInput.readBytes(this.buffer, dictLength, l);
                this.doCompress(this.buffer, dictLength, l, out);
            }
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                this.compressor.end();
                this.closed = true;
            }
        }
    }

    private static final class DeflateWithPresetDictDecompressor
    extends Decompressor {
        byte[] compressed = new byte[0];

        DeflateWithPresetDictDecompressor() {
        }

        private void doDecompress(DataInput in, Inflater decompressor, BytesRef bytes) throws IOException {
            int compressedLength = in.readVInt();
            if (compressedLength == 0) {
                return;
            }
            int paddedLength = compressedLength + 1;
            this.compressed = ArrayUtil.growNoCopy(this.compressed, paddedLength);
            in.readBytes(this.compressed, 0, compressedLength);
            this.compressed[compressedLength] = 0;
            decompressor.setInput(this.compressed, 0, paddedLength);
            try {
                bytes.length += decompressor.inflate(bytes.bytes, bytes.length, bytes.bytes.length - bytes.length);
            }
            catch (DataFormatException e) {
                throw new IOException(e);
            }
            if (!decompressor.finished()) {
                throw new CorruptIndexException("Invalid decoder state: needsInput=" + decompressor.needsInput() + ", needsDict=" + decompressor.needsDictionary(), in);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void decompress(DataInput in, int originalLength, int offset, int length, BytesRef bytes) throws IOException {
            assert (offset + length <= originalLength);
            if (length == 0) {
                bytes.length = 0;
                return;
            }
            int dictLength = in.readVInt();
            int blockLength = in.readVInt();
            bytes.bytes = ArrayUtil.growNoCopy(bytes.bytes, dictLength);
            bytes.length = 0;
            bytes.offset = 0;
            Inflater decompressor = new Inflater(true);
            try {
                this.doDecompress(in, decompressor, bytes);
                if (dictLength != bytes.length) {
                    throw new CorruptIndexException("Unexpected dict length", in);
                }
                int offsetInBlock = dictLength;
                int offsetInBytesRef = offset;
                while (offsetInBlock + blockLength < offset) {
                    int compressedLength = in.readVInt();
                    in.skipBytes(compressedLength);
                    offsetInBlock += blockLength;
                    offsetInBytesRef -= blockLength;
                }
                while (offsetInBlock < offset + length) {
                    bytes.bytes = ArrayUtil.grow(bytes.bytes, bytes.length + blockLength);
                    decompressor.reset();
                    decompressor.setDictionary(bytes.bytes, 0, dictLength);
                    this.doDecompress(in, decompressor, bytes);
                    offsetInBlock += blockLength;
                }
                bytes.offset = offsetInBytesRef;
                bytes.length = length;
                assert (bytes.isValid());
            }
            finally {
                decompressor.end();
            }
        }

        @Override
        public Decompressor clone() {
            return new DeflateWithPresetDictDecompressor();
        }
    }
}

