/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.dnd;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.core.windows.options.WinSysPrefs;
import org.netbeans.swing.tabcontrol.customtabs.Tabbed;

class DragWindow
extends JWindow {
    private static final float NO_DROP_ALPHA = 0.5f;
    private static final int DPI_SCALE = 2;
    private final Tabbed container;
    private final Rectangle tabRectangle;
    private final BufferedImage tabImage;
    private final BufferedImage contentImage;
    private boolean dropEnabled = true;

    public DragWindow(Tabbed container, Rectangle tabRectangle, Dimension contentSize, Component content) {
        this.tabRectangle = tabRectangle;
        this.container = container;
        this.setAlwaysOnTop(true);
        this.tabImage = this.createTabImage();
        this.contentImage = this.createContentImage(content, contentSize);
        this.setBackground(UIManager.getColor("Panel.background"));
        PainterPanel panel = new PainterPanel();
        JRootPane rootPane = this.getRootPane();
        rootPane.setLayout(new BorderLayout());
        rootPane.add((Component)panel, "Center");
    }

    private BufferedImage createTabImage() {
        GraphicsConfiguration config = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        Window parentWindow = SwingUtilities.getWindowAncestor(this.container.getComponent());
        Rectangle rect = SwingUtilities.convertRectangle(this.container.getComponent(), this.tabRectangle, parentWindow);
        BufferedImage res = config.createCompatibleImage(this.tabRectangle.width * 2, this.tabRectangle.height * 2);
        Graphics2D g = res.createGraphics();
        g.scale(2.0, 2.0);
        g.translate(-rect.x, -rect.y);
        g.setClip(rect);
        parentWindow.paint(g);
        return res;
    }

    private BufferedImage createContentImage(Component c, Dimension contentSize) {
        GraphicsConfiguration config = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage res = config.createCompatibleImage(contentSize.width * 2, contentSize.height * 2);
        Graphics2D g = res.createGraphics();
        g.scale(2.0, 2.0);
        g.setColor(this.getBackground());
        g.fillRect(0, 0, contentSize.width, contentSize.height);
        if (WinSysPrefs.HANDLER.getBoolean("dnd.smallwindows", true) && c.getWidth() > 0 && c.getHeight() > 0) {
            double xScale = contentSize.getWidth() / (double)c.getWidth();
            double yScale = contentSize.getHeight() / (double)c.getHeight();
            g.scale(xScale, yScale);
        }
        c.paint(g);
        return res;
    }

    private static void drawImageScaled(Graphics2D g2d, Image image, int x, int y) {
        AffineTransform oldTransform = g2d.getTransform();
        g2d.translate(x, y);
        g2d.scale(0.5, 0.5);
        g2d.drawImage(image, 0, 0, null);
        g2d.setTransform(oldTransform);
    }

    public void setDropFeedback(boolean dropEnabled) {
        if (this.dropEnabled == dropEnabled) {
            return;
        }
        this.dropEnabled = dropEnabled;
        this.repaint();
    }

    void abort() {
        this.setDropFeedback(true);
    }

    private class PainterPanel
    extends JPanel {
        private PainterPanel() {
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.setColor(DragWindow.this.getBackground());
            g2d.fillRect(0, 0, this.getWidth(), ((DragWindow)DragWindow.this).tabRectangle.height);
            if (!DragWindow.this.dropEnabled) {
                g2d.setComposite(AlphaComposite.getInstance(3, 0.5f));
            }
            g2d.setColor(Color.gray);
            g2d.drawRect(0, ((DragWindow)DragWindow.this).tabRectangle.height, this.getWidth() - 1, this.getHeight() - ((DragWindow)DragWindow.this).tabRectangle.height - 1);
            if (WinSysPrefs.HANDLER.getBoolean("dnd.smallwindows", true)) {
                DragWindow.drawImageScaled(g2d, DragWindow.this.tabImage, 0, 0);
            } else {
                DragWindow.drawImageScaled(g2d, DragWindow.this.tabImage, ((DragWindow)DragWindow.this).tabRectangle.x, ((DragWindow)DragWindow.this).tabRectangle.y);
            }
            g2d.setColor(Color.black);
            g2d.fillRect(1, ((DragWindow)DragWindow.this).tabRectangle.height + 1, this.getWidth() - 2, this.getHeight() - ((DragWindow)DragWindow.this).tabRectangle.height - 2);
            DragWindow.drawImageScaled(g2d, DragWindow.this.contentImage, 1, ((DragWindow)DragWindow.this).tabRectangle.height + 1);
            g2d.dispose();
        }
    }
}

