/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.loaders.BuildPropertiesImplementation;

public final class BuildPropertiesSupport {
    private final List<BuildPropertiesImplementation> impls;
    public static final String EXTENSION = "extension";
    public static final String TASK = "task";

    BuildPropertiesSupport(List<BuildPropertiesImplementation> impls) {
        this.impls = impls;
    }

    public static BuildPropertiesSupport get(Project p) {
        NbGradleProject nbgp = NbGradleProject.get(p);
        if (nbgp == null) {
            return null;
        }
        ArrayList<BuildPropertiesImplementation> impls = new ArrayList<BuildPropertiesImplementation>(nbgp.refreshableProjectLookup().lookupAll(BuildPropertiesImplementation.class));
        return impls.isEmpty() ? null : new BuildPropertiesSupport(impls);
    }

    public Property findExtensionProperty(String extensionName, String propertyPath) {
        for (BuildPropertiesImplementation impl : this.impls) {
            Property p = impl.findProperty(new Property(null, EXTENSION, extensionName, PropertyKind.MAP, null, null), propertyPath);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    public Property findTaskProperty(String taskName, String propertyPath) {
        for (BuildPropertiesImplementation impl : this.impls) {
            Property p = impl.findProperty(new Property(null, TASK, taskName, PropertyKind.MAP, null, null), propertyPath);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    public Iterable<Property> items(final Property owner, final String path) {
        if (owner.getKind() != PropertyKind.LIST) {
            return Collections.emptyList();
        }
        return new Iterable<Property>(){
            final /* synthetic */ BuildPropertiesSupport this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Iterator<Property> iterator() {
                class It
                implements Iterator<Property> {
                    Iterator<BuildPropertiesImplementation> containers;
                    Iterator<Property> del;
                    final /* synthetic */ Property val$owner;
                    final /* synthetic */ String val$path;
                    final /* synthetic */ BuildPropertiesSupport this$0;

                    It() {
                        this.val$owner = property;
                        this.val$path = string;
                        this.this$0 = this$0;
                        this.containers = this.this$0.impls.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.del != null && !this.del.hasNext()) {
                            this.del = null;
                        }
                        while (this.del == null) {
                            if (!this.containers.hasNext()) {
                                return false;
                            }
                            this.del = this.containers.next().items(this.val$owner, this.val$path);
                            if (this.del == null || this.del.hasNext()) continue;
                            this.del = null;
                        }
                        return this.del.hasNext();
                    }

                    @Override
                    public Property next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return this.del.next();
                    }
                }
                return new It(this.this$0, owner, path);
            }
        };
    }

    @NonNull
    public Collection<String> keys(Property owner) {
        if (owner.getKind() != PropertyKind.STRUCTURE && owner.getKind() != PropertyKind.MAP) {
            return Collections.emptyList();
        }
        LinkedHashSet<String> s = new LinkedHashSet<String>();
        for (BuildPropertiesImplementation impl : this.impls) {
            Collection<String> keys = impl.keys(owner);
            if (keys == null) continue;
            s.addAll(keys);
        }
        return s;
    }

    @CheckForNull
    public Property get(Property base, String key, String path) {
        if (base.getKind() != PropertyKind.MAP) {
            return null;
        }
        for (BuildPropertiesImplementation impl : this.impls) {
            Property p = impl.get(base, key, path);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    public static final class Property {
        private final Object id;
        private final String scope;
        private final PropertyKind kind;
        private final String type;
        private final String value;
        private final String name;

        public Property(Object id, String scope, String propertyName, PropertyKind kind, String type, String value) {
            this.id = id;
            this.scope = scope;
            this.kind = kind;
            this.type = type;
            this.value = value;
            this.name = propertyName;
        }

        @NonNull
        public Object getId() {
            return this.id;
        }

        public String getScope() {
            return this.scope;
        }

        public PropertyKind getKind() {
            return this.kind;
        }

        public String getName() {
            return this.name;
        }

        @CheckForNull
        public String getType() {
            return this.type;
        }

        public boolean isList() {
            return this.kind == PropertyKind.LIST;
        }

        public boolean isMap() {
            return this.kind == PropertyKind.MAP;
        }

        @CheckForNull
        public String getStringValue() {
            return this.value;
        }
    }

    public static enum PropertyKind {
        PRIMITIVE,
        STRUCTURE,
        MAP,
        LIST,
        EXISTS;

    }
}

