/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.projects;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntBuildExtender;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.openide.filesystems.FileObject;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public class AntFilesHelper {
    public static final int CURRENT_DEPENDECIES_VERSION = 5;
    public static final String REST_ANT_EXT_NAME_BASE = "rest";
    public static final String REST_ANT_EXT_NAME = AntFilesHelper.getExtensionVersionString(5);
    public static final String REST_BUILD_XSL = "org/netbeans/modules/websvc/rest/resources/rest-build.xsl";
    public static final String REST_BUILD_XML_PATH = "nbproject/rest-build.xml";
    private AntProjectHelper projectHelper;
    private Project project;
    private AntBuildExtender extender;

    public AntFilesHelper(RestSupport restSupport) {
        this(restSupport.getProject(), restSupport.getAntProjectHelper());
    }

    public AntFilesHelper(Project project, AntProjectHelper helper) {
        this.projectHelper = helper;
        this.project = project;
        this.extender = (AntBuildExtender)project.getLookup().lookup(AntBuildExtender.class);
        if (this.extender == null) {
            throw new IllegalArgumentException("Given project does not allow extension");
        }
    }

    public void initRestBuildExtension() throws IOException {
        AntBuildExtender.Extension extension;
        boolean restBuildScriptRefreshed = this.refreshRestBuildXml();
        boolean saveProjectXml = false;
        boolean changed = false;
        FileObject restBuildScript = this.project.getProjectDirectory().getFileObject(REST_BUILD_XML_PATH);
        if (restBuildScript != null && (extension = this.extender.getExtension(REST_ANT_EXT_NAME)) == null) {
            extension = this.extender.addExtension(REST_ANT_EXT_NAME, restBuildScript);
            changed = true;
            saveProjectXml = true;
        }
        if (this.cleanupLastExtensionVersions()) {
            saveProjectXml = true;
        }
        if (saveProjectXml) {
            ProjectManager.getDefault().saveProject(this.project);
        }
        if (changed && !restBuildScriptRefreshed) {
            try {
                final GeneratedFilesHelper helper = new GeneratedFilesHelper(this.projectHelper);
                ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){
                    final /* synthetic */ AntFilesHelper this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public Boolean run() throws IOException {
                        URL xslURL = this.getClass().getClassLoader().getResource(AntFilesHelper.REST_BUILD_XSL);
                        helper.generateBuildScriptFromStylesheet(AntFilesHelper.REST_BUILD_XML_PATH, xslURL);
                        return true;
                    }
                });
            }
            catch (MutexException e) {
                throw (IOException)e.getException();
            }
        }
    }

    public boolean refreshRestBuildXml() throws IOException {
        URL xslURL = this.getClass().getClassLoader().getResource(REST_BUILD_XSL);
        GeneratedFilesHelper helper = new GeneratedFilesHelper(this.projectHelper);
        return helper.refreshBuildScript(REST_BUILD_XML_PATH, xslURL, true);
    }

    private static String getExtensionVersionString(int version) {
        return "rest." + version;
    }

    public boolean cleanupLastExtensionVersions() {
        ArrayList<String> extensionNames = new ArrayList<String>();
        String lastVersion = REST_ANT_EXT_NAME_BASE;
        if (this.extender.getExtension(lastVersion) != null) {
            extensionNames.add(lastVersion);
        }
        for (int version = 0; version < 5; ++version) {
            lastVersion = AntFilesHelper.getExtensionVersionString(version);
            if (this.extender.getExtension(lastVersion) == null) continue;
            extensionNames.add(lastVersion);
        }
        for (String name : extensionNames) {
            this.extender.removeExtension(name);
        }
        return extensionNames.size() > 0;
    }
}

