/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.versioning.core.VersioningManager;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSVisibilityQuery;
import org.netbeans.modules.versioning.core.util.VCSSystemProvider;
import org.netbeans.spi.queries.VisibilityQueryChangeEvent;
import org.netbeans.spi.queries.VisibilityQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

public class VcsVisibilityQueryImplementation
implements VisibilityQueryImplementation2 {
    private final InvisibleFiles cache = new InvisibleFiles(25);
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private static VcsVisibilityQueryImplementation instance;
    private static RequestProcessor rp;
    private RequestProcessor.Task refreshTask = rp.create((Runnable)new RefreshTask());
    private VisibilityChangedTask vsChangedTask = new VisibilityChangedTask();
    private final HashMap<VCSFileProxy, Boolean> refreshedFiles = new LinkedHashMap<VCSFileProxy, Boolean>(20);
    private static final int MAX_CACHE_SIZE = 500;
    private static final Logger LOG;
    private static final Pattern hgmetadataPattern;
    private static final Pattern cvsmetadataPattern;
    private static final Pattern gitmetadatapattern;

    public VcsVisibilityQueryImplementation() {
        instance = this;
    }

    public static VcsVisibilityQueryImplementation getInstance() {
        return instance;
    }

    public static void visibilityChanged() {
        if (instance != null) {
            instance.fireVisibilityChanged((FileObject[])null);
        }
    }

    public static void visibilityChanged(VCSFileProxy ... files) {
        if (instance != null) {
            instance.fireVisibilityChanged(files);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVisible(File file) {
        boolean bl;
        block3: {
            boolean ret = true;
            try {
                bl = ret = this.isVisible(VCSFileProxy.createFileProxy(file));
                if ((ret || !LOG.isLoggable(Level.FINER)) && !LOG.isLoggable(Level.FINEST)) break block3;
            }
            catch (Throwable throwable) {
                if (!ret && LOG.isLoggable(Level.FINER) || LOG.isLoggable(Level.FINEST)) {
                    LOG.log(Level.FINE, "VCS returned visibility {0} for {1}", new Object[]{ret, file});
                }
                throw throwable;
            }
            LOG.log(Level.FINE, "VCS returned visibility {0} for {1}", new Object[]{ret, file});
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVisible(VCSFileProxy file) {
        boolean refresh;
        boolean visible;
        VCSSystemProvider.VersioningSystem[] systems;
        for (VCSSystemProvider.VersioningSystem versioningSystem : systems = VersioningManager.getInstance().getVersioningSystems()) {
            if (!versioningSystem.isMetadataFile(file)) continue;
            return false;
        }
        if (this.isHiddenMetadata(file)) {
            return false;
        }
        InvisibleFiles invisibleFiles = this.cache;
        synchronized (invisibleFiles) {
            this.cache.clearOldValues();
            visible = !this.cache.containsKey(file);
        }
        HashMap<VCSFileProxy, Boolean> hashMap = this.refreshedFiles;
        synchronized (hashMap) {
            refresh = this.refreshedFiles.isEmpty();
            this.refreshedFiles.put(file, visible);
        }
        if (refresh) {
            this.refreshTask.schedule(100);
        }
        return visible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVisible(FileObject fileObject) {
        boolean bl;
        block6: {
            VCSFileProxy file;
            boolean ret;
            block4: {
                boolean bl2;
                block5: {
                    ret = true;
                    try {
                        file = VCSFileProxy.createFileProxy(fileObject);
                        if (file != null) break block4;
                        bl2 = true;
                        if ((ret || !LOG.isLoggable(Level.FINER)) && !LOG.isLoggable(Level.FINEST)) break block5;
                    }
                    catch (Throwable throwable) {
                        if (!ret && LOG.isLoggable(Level.FINER) || LOG.isLoggable(Level.FINEST)) {
                            LOG.log(Level.FINE, "VCS returned visibility {0} for {1}", new Object[]{ret, fileObject});
                        }
                        throw throwable;
                    }
                    LOG.log(Level.FINE, "VCS returned visibility {0} for {1}", new Object[]{ret, fileObject});
                }
                return bl2;
            }
            bl = ret = this.isVisible(file);
            if ((ret || !LOG.isLoggable(Level.FINER)) && !LOG.isLoggable(Level.FINEST)) break block6;
            LOG.log(Level.FINE, "VCS returned visibility {0} for {1}", new Object[]{ret, fileObject});
        }
        return bl;
    }

    public synchronized void addChangeListener(ChangeListener l) {
        ArrayList<ChangeListener> newList = new ArrayList<ChangeListener>(this.listeners);
        newList.add(l);
        this.listeners = newList;
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        ArrayList<ChangeListener> newList = new ArrayList<ChangeListener>(this.listeners);
        newList.remove(l);
        this.listeners = newList;
    }

    private void fireVisibilityChanged(VCSFileProxy[] proxies) {
        LinkedHashSet<FileObject> fileObjects = new LinkedHashSet<FileObject>(proxies.length);
        for (VCSFileProxy proxy : proxies) {
            FileObject fo = this.findExistingFileObject(proxy);
            if (fo != null) {
                fileObjects.add(fo);
                continue;
            }
            LOG.log(Level.WARNING, "VCS visibility did not fire because of {0} which returns no FileObject", proxy);
        }
        this.fireVisibilityChanged(fileObjects.toArray(new FileObject[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireVisibilityChanged(FileObject[] files) {
        ChangeListener[] ls;
        VcsVisibilityQueryImplementation vcsVisibilityQueryImplementation = this;
        synchronized (vcsVisibilityQueryImplementation) {
            ls = this.listeners.toArray(new ChangeListener[0]);
        }
        ChangeEvent event = files == null ? new ChangeEvent(this) : new VisibilityQueryChangeEvent((Object)this, files);
        for (ChangeListener l : ls) {
            l.stateChanged(event);
        }
        if (files != null && LOG.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder();
            for (FileObject fo : files) {
                sb.append("\n\t");
                sb.append(fo.toString());
            }
            LOG.log(Level.FINE, "VCS fired visibility change for: {0}", sb.toString());
        }
    }

    private boolean isHiddenMetadata(VCSFileProxy file) {
        return hgmetadataPattern.matcher(file.getPath()).matches() || cvsmetadataPattern.matcher(file.getPath()).matches() || gitmetadatapattern.matcher(file.getPath()).matches();
    }

    private FileObject findExistingFileObject(VCSFileProxy proxy) {
        FileObject fo = null;
        while (proxy != null && (fo = proxy.toFileObject()) == null) {
            proxy = proxy.getParentFile();
        }
        return fo;
    }

    static {
        rp = new RequestProcessor(VcsVisibilityQueryImplementation.class.getName(), 1, false, false);
        LOG = Logger.getLogger(VcsVisibilityQueryImplementation.class.getName());
        hgmetadataPattern = Pattern.compile(".*\\" + File.separatorChar + "(\\.)hg(\\" + File.separatorChar + ".*|$)");
        cvsmetadataPattern = Pattern.compile(".*\\" + File.separatorChar + "CVS(\\" + File.separatorChar + ".*|$)");
        gitmetadatapattern = Pattern.compile(".*\\" + File.separatorChar + "(\\.)git(\\" + File.separatorChar + ".*|$)");
    }

    private static class InvisibleFiles
    extends LinkedHashMap<VCSFileProxy, Long> {
        public InvisibleFiles(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<VCSFileProxy, Long> eldest) {
            return this.size() >= 500;
        }

        public void clearOldValues() {
            if (this.size() > 125) {
                Iterator it = this.entrySet().iterator();
                long threshold = System.currentTimeMillis() - 1800000L;
                while (it.hasNext() && (Long)it.next().getValue() < threshold) {
                    it.remove();
                }
            }
        }
    }

    private class RefreshTask
    implements Runnable {
        private RefreshTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            VCSFileProxy file = null;
            boolean originalValue = false;
            HashMap<VCSFileProxy, Boolean> hashMap = VcsVisibilityQueryImplementation.this.refreshedFiles;
            synchronized (hashMap) {
                Iterator<Map.Entry<VCSFileProxy, Boolean>> it = VcsVisibilityQueryImplementation.this.refreshedFiles.entrySet().iterator();
                if (it.hasNext()) {
                    Map.Entry<VCSFileProxy, Boolean> e = it.next();
                    file = e.getKey();
                    originalValue = e.getValue();
                    it.remove();
                }
            }
            if (file == null) {
                return;
            }
            boolean visible = true;
            VCSSystemProvider.VersioningSystem system = VersioningManager.getInstance().getOwner(file, !file.isDirectory());
            if (system != null) {
                VCSVisibilityQuery vqi = system.getVisibilityQuery();
                visible = vqi == null ? true : vqi.isVisible(file);
            }
            InvisibleFiles invisibleFiles = VcsVisibilityQueryImplementation.this.cache;
            synchronized (invisibleFiles) {
                VcsVisibilityQueryImplementation.this.cache.remove(file);
                if (!visible) {
                    VcsVisibilityQueryImplementation.this.cache.put(file, System.currentTimeMillis());
                }
            }
            if (originalValue != visible) {
                VcsVisibilityQueryImplementation.this.vsChangedTask.schedule(file);
            }
            VcsVisibilityQueryImplementation.this.refreshTask.schedule(0);
        }
    }

    private class VisibilityChangedTask
    implements Runnable {
        private final List<VCSFileProxy> files = new LinkedList<VCSFileProxy>();
        private RequestProcessor.Task task;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            VCSFileProxy[] filesArray;
            List<VCSFileProxy> list = this.files;
            synchronized (list) {
                filesArray = this.files.toArray(new VCSFileProxy[0]);
                this.files.clear();
            }
            VcsVisibilityQueryImplementation.this.fireVisibilityChanged(filesArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void schedule(VCSFileProxy file) {
            List<VCSFileProxy> list = this.files;
            synchronized (list) {
                this.files.add(file);
            }
            this.getTask().schedule(1000);
        }

        private synchronized RequestProcessor.Task getTask() {
            if (this.task == null) {
                this.task = rp.create((Runnable)this);
            }
            return this.task;
        }
    }
}

