/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.tag;

import java.io.File;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitTag;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.ui.output.OutputLogger;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.ui.tag.CreateTag;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.util.NbBundle;

public class CreateTagAction
extends SingleRepositoryAction {
    private static final Logger LOG = Logger.getLogger(CreateTagAction.class.getName());
    private static final String ICON_RESOURCE = "org/netbeans/modules/git/resources/icons/tag.png";

    public CreateTagAction() {
        super(ICON_RESOURCE);
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected void performAction(File repository, File[] roots, VCSContext context) {
        RepositoryInfo info = RepositoryInfo.getInstance(repository);
        this.createTag(repository, info.getActiveBranch().getName().equals("(no branch)") ? "HEAD" : info.getActiveBranch().getName());
    }

    public void createTag(File repository, String preselectedRevision) {
        final CreateTag createTag = new CreateTag(repository, preselectedRevision, "");
        if (createTag.show()) {
            GitProgressSupport supp = new GitProgressSupport(this){
                final /* synthetic */ CreateTagAction this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                protected void perform() {
                    try {
                        new CreateTagProcess(createTag, this, this.getClient()).call();
                    }
                    catch (GitException ex) {
                        GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                    }
                }
            };
            supp.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(CreateTagAction.class, (String)"LBL_CreateTagAction.progressName"));
        }
    }

    static class CreateTagProcess
    implements Callable<GitTag> {
        private final GitProgressSupport supp;
        private final CreateTag createTag;
        private final GitClient client;

        public CreateTagProcess(CreateTag createTag, GitProgressSupport supp, GitClient client) {
            this.supp = supp;
            this.createTag = createTag;
            this.client = client;
        }

        @Override
        public GitTag call() {
            try {
                LOG.log(Level.FINE, "Creating a tag: {0}/{1}", new Object[]{this.createTag.getTagName(), this.createTag.getRevision()});
                GitTag tag = this.client.createTag(this.createTag.getTagName(), this.createTag.getRevision(), this.createTag.getTagMessage(), false, this.createTag.isForceUpdate(), this.supp.getProgressMonitor());
                this.log(tag);
                return tag;
            }
            catch (GitException ex) {
                GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                return null;
            }
        }

        private void log(GitTag tag) {
            OutputLogger logger = this.supp.getLogger();
            logger.outputLine(NbBundle.getMessage(CreateTagAction.class, (String)"MSG_CreateTagAction.tagCreated", (Object[])new Object[]{tag.getTagName(), tag.getTaggedObjectId(), tag.getTagId(), tag.getTagger().toString(), tag.getMessage()}));
        }
    }
}

