/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.ui.wizard;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.maven.api.archetype.Archetype;
import org.netbeans.modules.maven.api.archetype.ArchetypeWizards;
import org.netbeans.modules.maven.api.archetype.ProjectInfo;
import org.netbeans.modules.maven.j2ee.ui.wizard.BaseWizardIterator;
import org.netbeans.modules.maven.j2ee.ui.wizard.Bundle;
import org.netbeans.modules.maven.j2ee.ui.wizard.EELevelPanel;
import org.netbeans.modules.maven.j2ee.ui.wizard.archetype.J2eeArchetypeFactory;
import org.netbeans.modules.maven.j2ee.utils.MavenProjectSupport;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class EEWizardIterator
extends BaseWizardIterator {
    public static final String PROP_EE_LEVEL = "eeLevel";
    private J2eeModule.Type projectType;
    private final String titleName;

    private EEWizardIterator(J2eeModule.Type projectType, String titleName) {
        this.projectType = projectType;
        this.titleName = titleName;
    }

    public static EEWizardIterator createWebAppIterator() {
        return new EEWizardIterator(J2eeModule.Type.WAR, Bundle.template_WebApp());
    }

    public static EEWizardIterator createEJBIterator() {
        return new EEWizardIterator(J2eeModule.Type.EJB, Bundle.template_EJB());
    }

    public static EEWizardIterator createAppClientIterator() {
        return new EEWizardIterator(J2eeModule.Type.CAR, Bundle.template_APPCLIENT());
    }

    public Set<FileObject> instantiate() throws IOException {
        ProjectInfo vi = new ProjectInfo((String)this.wiz.getProperty("groupId"), (String)this.wiz.getProperty("artifactId"), (String)this.wiz.getProperty("version"), (String)this.wiz.getProperty("package"));
        Profile profile = (Profile)this.wiz.getProperty(PROP_EE_LEVEL);
        Archetype archetype = J2eeArchetypeFactory.getInstance().findArchetypeFor(this.projectType, profile);
        ArchetypeWizards.logUsage((String)archetype.getGroupId(), (String)archetype.getArtifactId(), (String)archetype.getVersion());
        File rootFile = FileUtil.normalizeFile((File)((File)this.wiz.getProperty("projdir")));
        ArchetypeWizards.createFromArchetype((File)rootFile, (ProjectInfo)vi, (Archetype)archetype, null, (boolean)true);
        Set projects = ArchetypeWizards.openProjects((File)rootFile, (File)rootFile);
        for (FileObject projectFile : projects) {
            Project project = ProjectManager.getDefault().findProject(projectFile);
            if (project == null) continue;
            this.saveSettingsToNbConfiguration(project);
            MavenProjectSupport.changeServer(project, true);
        }
        return projects;
    }

    @Override
    public void initialize(WizardDescriptor wiz) {
        super.initialize(wiz);
        wiz.putProperty("NewProjectWizard_Title", (Object)this.titleName);
    }

    @Override
    protected WizardDescriptor.Panel[] createPanels(ValidationGroup vg) {
        return new WizardDescriptor.Panel[]{ArchetypeWizards.basicWizardPanel((ValidationGroup)vg, (boolean)false, null), new EELevelPanel(this.projectType)};
    }
}

