/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.zend2.editor;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.api.editor.PhpBaseElement;
import org.netbeans.modules.php.api.editor.PhpClass;
import org.netbeans.modules.php.api.editor.PhpType;
import org.netbeans.modules.php.api.editor.PhpVariable;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.elements.InterfaceElement;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.Occurence;
import org.netbeans.modules.php.editor.model.OccurencesSupport;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayElement;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.ReturnStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.StaticDispatch;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.VariableBase;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.spi.editor.EditorExtender;
import org.netbeans.modules.php.zend2.util.Zend2Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class Zend2EditorExtender
extends EditorExtender {
    private static final Logger LOGGER = Logger.getLogger(Zend2EditorExtender.class.getName());

    public List<PhpBaseElement> getElementsForCodeCompletion(FileObject fo) {
        File file = FileUtil.toFile((FileObject)fo);
        if (Zend2Utils.isView(file)) {
            return new ArrayList<PhpVariable>(this.parseAction(file));
        }
        return Collections.emptyList();
    }

    private Set<PhpVariable> parseAction(final File view) {
        assert (Zend2Utils.isView(view)) : "Not a view: " + view;
        File controller = Zend2Utils.getController(view);
        if (controller == null) {
            return Collections.emptySet();
        }
        FileObject fo = FileUtil.toFileObject((File)controller);
        final Set<PhpVariable> phpVariables = Collections.synchronizedSet(new HashSet());
        try {
            ParserManager.parse(Collections.singleton(Source.create((FileObject)fo)), (UserTask)new UserTask(this){
                final /* synthetic */ Zend2EditorExtender this$0;
                {
                    this.this$0 = this$0;
                }

                public void run(ResultIterator resultIterator) throws Exception {
                    PHPParseResult parseResult = (PHPParseResult)resultIterator.getParserResult();
                    PhpVariable viewVariable = new ViewResolver(parseResult).getView();
                    phpVariables.add(viewVariable);
                    ControllerVisitor controllerVisitor = new ControllerVisitor(view);
                    controllerVisitor.scan((ASTNode)Utils.getRoot((ParserResult)parseResult));
                    FileObject controller = parseResult.getSnapshot().getSource().getFileObject();
                    Model model = parseResult.getModel();
                    ArrayVisitor arrayVisitor = new ArrayVisitor(controller, model);
                    ObjectVisitor objectVisitor = new ObjectVisitor(controller, model);
                    for (ASTNode actionDeclaration : controllerVisitor.getActionDeclarations()) {
                        arrayVisitor.setActionMethod(actionDeclaration);
                        actionDeclaration.accept((Visitor)arrayVisitor);
                        this.addViewVariables(viewVariable, phpVariables, arrayVisitor.getVariables());
                        objectVisitor.setActionMethod(actionDeclaration);
                        actionDeclaration.accept((Visitor)objectVisitor);
                        this.addViewVariables(viewVariable, phpVariables, objectVisitor.getVariables());
                    }
                }

                private void addViewVariables(PhpVariable viewVariable, Set<PhpVariable> allVariables, Set<PhpVariable> newVariables) {
                    allVariables.addAll(newVariables);
                    PhpType type = viewVariable.getType();
                    assert (type != null);
                    if (type instanceof PhpClass) {
                        PhpClass phpClass = (PhpClass)type;
                        for (PhpVariable variable : newVariables) {
                            phpClass.addField(variable.getName().substring(1), variable.getType(), variable.getFile(), variable.getOffset());
                        }
                    }
                }
            });
        }
        catch (ParseException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        return phpVariables;
    }

    private static abstract class ZendVisitor
    extends DefaultVisitor {
        private final Set<PhpVariable> variables = new HashSet<PhpVariable>();
        protected final FileObject controller;
        protected final Model model;
        protected ASTNode actionDeclaration;

        public ZendVisitor(FileObject controller, Model model) {
            assert (controller != null);
            assert (model != null);
            this.controller = controller;
            this.model = model;
        }

        protected void addPhpVariable(String varName, Expression value, int offset) {
            TypeScope firstType;
            PhpClass phpClass = null;
            Collection types = null;
            if (value instanceof VariableBase) {
                types = ModelUtils.resolveType((Model)this.model, (VariableBase)((VariableBase)value), (boolean)false);
            } else if (value instanceof Assignment) {
                types = ModelUtils.resolveType((Model)this.model, (Assignment)((Assignment)value));
            } else if (value instanceof StaticDispatch) {
                types = ModelUtils.resolveType((Model)this.model, (StaticDispatch)((StaticDispatch)value));
            }
            if (types != null && (firstType = (TypeScope)ModelUtils.getFirst((Collection)types)) != null) {
                String typeName = firstType.getName();
                String fqName = firstType.getFullyQualifiedName().toString();
                phpClass = new PhpClass(typeName, fqName);
            }
            this.variables.add(new PhpVariable("$" + varName, phpClass, this.controller, offset));
        }

        protected void process(ArrayCreation arrayCreation) {
            List elements = arrayCreation.getElements();
            for (ArrayElement arrayElement : elements) {
                if (!(arrayElement.getKey() instanceof Scalar)) continue;
                Scalar scalar = (Scalar)arrayElement.getKey();
                String stringValue = scalar.getStringValue();
                String varName = stringValue.substring(1, stringValue.length() - 1);
                Expression value = arrayElement.getValue();
                this.addPhpVariable(varName, value, scalar.getStartOffset());
            }
        }

        public Set<PhpVariable> getVariables() {
            return this.variables;
        }

        public void setActionMethod(ASTNode actionDeclaration) {
            this.actionDeclaration = actionDeclaration;
        }
    }

    private static final class ObjectVisitor
    extends ZendVisitor {
        private static final List<String> VIEW_MODEL_SEGMENTS = Arrays.asList("Zend", "View", "Model", "ViewModel");
        private final Map<String, Set<Assignment>> fieldAssigments = new HashMap<String, Set<Assignment>>();

        public ObjectVisitor(FileObject controller, Model model) {
            super(controller, model);
        }

        public void visit(Assignment node) {
            VariableBase dispatcher;
            VariableBase leftHandSide = node.getLeftHandSide();
            if (leftHandSide instanceof FieldAccess && (dispatcher = ((FieldAccess)leftHandSide).getDispatcher()) instanceof Variable) {
                String name = CodeUtils.extractVariableName((Variable)((Variable)dispatcher));
                Set<Assignment> assignments = this.fieldAssigments.get(name);
                if (assignments == null) {
                    assignments = new HashSet<Assignment>();
                    this.fieldAssigments.put(name, assignments);
                }
                assignments.add(node);
            }
        }

        public void visit(ReturnStatement node) {
            Expression expression = node.getExpression();
            if (expression instanceof Variable) {
                Collection gotoDeclarations;
                PhpElement variableDeclaration;
                OccurencesSupport occurencesSupport = this.model.getOccurencesSupport(expression.getStartOffset() + 1);
                Occurence occurence = occurencesSupport.getOccurence();
                if (occurence != null && (variableDeclaration = (PhpElement)ModelUtils.getFirst((Collection)(gotoDeclarations = occurence.gotoDeclarations()))) != null) {
                    ASTNode[] nodeHierarchyAtOffset;
                    for (ASTNode parentNode : nodeHierarchyAtOffset = Utils.getNodeHierarchyAtOffset((ASTNode)this.actionDeclaration, (int)variableDeclaration.getOffset())) {
                        ClassInstanceCreation instanceCreation;
                        Expression className;
                        if (!(parentNode instanceof Assignment)) continue;
                        Assignment assignment = (Assignment)parentNode;
                        Expression rightHandSide = assignment.getRightHandSide();
                        if (!(rightHandSide instanceof ClassInstanceCreation) || !((className = (instanceCreation = (ClassInstanceCreation)rightHandSide).getClassName().getName()) instanceof NamespaceName) || !this.isViewModel(((NamespaceName)className).getSegments())) break;
                        this.process(instanceCreation);
                        break;
                    }
                }
                String varName = CodeUtils.extractVariableName((Variable)((Variable)expression));
                this.process(this.fieldAssigments.get(varName));
            }
        }

        private boolean isViewModel(List<Identifier> segments) {
            int i = segments.size() - 1;
            for (int j = VIEW_MODEL_SEGMENTS.size() - 1; i >= 0 && j >= 0; --i, --j) {
                if (segments.get(i).getName().equals(VIEW_MODEL_SEGMENTS.get(j))) continue;
                return false;
            }
            return true;
        }

        private void process(ClassInstanceCreation instanceCreation) {
            List ctorParams = instanceCreation.ctorParams();
            if (ctorParams.isEmpty()) {
                return;
            }
            Expression firstParam = (Expression)ctorParams.get(0);
            if (firstParam instanceof ArrayCreation) {
                this.process((ArrayCreation)firstParam);
            }
        }

        private void process(Set<Assignment> assignments) {
            if (assignments == null) {
                return;
            }
            for (Assignment assignment : assignments) {
                Variable field = ((FieldAccess)assignment.getLeftHandSide()).getField();
                String varName = CodeUtils.extractVariableName((Variable)field);
                Expression value = assignment.getRightHandSide();
                this.addPhpVariable(varName, value, field.getStartOffset());
            }
        }
    }

    private static final class ArrayVisitor
    extends ZendVisitor {
        private final Map<String, Set<Assignment>> arrayAssigments = new HashMap<String, Set<Assignment>>();

        public ArrayVisitor(FileObject controller, Model model) {
            super(controller, model);
        }

        public void visit(Assignment node) {
            VariableBase leftHandSide = node.getLeftHandSide();
            if (leftHandSide instanceof ArrayAccess) {
                Set<Assignment> assignments;
                ArrayAccess arrayAccess = (ArrayAccess)leftHandSide;
                String name = null;
                VariableBase variableBase = arrayAccess.getName();
                if (variableBase instanceof Variable) {
                    name = CodeUtils.extractVariableName((Variable)((Variable)variableBase));
                }
                if ((assignments = this.arrayAssigments.get(name)) == null) {
                    assignments = new HashSet<Assignment>();
                    this.arrayAssigments.put(name, assignments);
                }
                assignments.add(node);
            }
        }

        public void visit(ReturnStatement node) {
            Expression expression = node.getExpression();
            if (expression instanceof Variable) {
                Collection gotoDeclarations;
                PhpElement variableDeclaration;
                OccurencesSupport occurencesSupport = this.model.getOccurencesSupport(expression.getStartOffset() + 1);
                Occurence occurence = occurencesSupport.getOccurence();
                if (occurence != null && (variableDeclaration = (PhpElement)ModelUtils.getFirst((Collection)(gotoDeclarations = occurence.gotoDeclarations()))) != null) {
                    ASTNode[] nodeHierarchyAtOffset;
                    for (ASTNode parentNode : nodeHierarchyAtOffset = Utils.getNodeHierarchyAtOffset((ASTNode)this.actionDeclaration, (int)variableDeclaration.getOffset())) {
                        if (!(parentNode instanceof Assignment)) continue;
                        Assignment assignment = (Assignment)parentNode;
                        Expression rightHandSide = assignment.getRightHandSide();
                        if (!(rightHandSide instanceof ArrayCreation)) break;
                        this.process((ArrayCreation)rightHandSide);
                        break;
                    }
                }
                String varName = CodeUtils.extractVariableName((Variable)((Variable)expression));
                this.process(this.arrayAssigments.get(varName));
            }
        }

        private void process(Set<Assignment> assignments) {
            if (assignments == null) {
                return;
            }
            for (Assignment assignment : assignments) {
                ArrayAccess arrayAccess = (ArrayAccess)assignment.getLeftHandSide();
                Expression index = arrayAccess.getDimension().getIndex();
                if (!(index instanceof Scalar)) continue;
                Scalar scalar = (Scalar)index;
                String stringValue = scalar.getStringValue();
                String varName = stringValue.substring(1, stringValue.length() - 1);
                Expression value = assignment.getRightHandSide();
                this.addPhpVariable(varName, value, scalar.getStartOffset());
            }
        }
    }

    private static final class ControllerVisitor
    extends DefaultVisitor {
        private final Set<ASTNode> actionDeclarations = new HashSet<ASTNode>();
        private final String action;

        public ControllerVisitor(File viewFile) {
            assert (viewFile != null);
            this.action = Zend2Utils.getActionName(viewFile);
        }

        public void visit(ClassDeclaration node) {
            if (CodeUtils.extractClassName((ClassDeclaration)node).toLowerCase().endsWith("Controller".toLowerCase())) {
                super.visit(node);
            }
        }

        public void visit(MethodDeclaration node) {
            if (CodeUtils.extractMethodName((MethodDeclaration)node).equalsIgnoreCase(this.action)) {
                this.actionDeclarations.add((ASTNode)node);
            }
        }

        public Set<ASTNode> getActionDeclarations() {
            return this.actionDeclarations;
        }
    }

    private static final class ViewResolver {
        private final PhpVariable view;

        public ViewResolver(PHPParseResult actionParseResult) {
            PhpClass phpClass;
            assert (actionParseResult != null);
            ElementQuery.Index index = actionParseResult.getModel().getIndexScope().getIndex();
            Set interfaces = index.getInterfaces((NameKind)NameKind.exact((String)"\\Zend\\View\\Renderer\\RendererInterface"));
            if (interfaces.size() > 0) {
                InterfaceElement zendViewIface = (InterfaceElement)interfaces.iterator().next();
                phpClass = new PhpClass("RendererInterface", "\\Zend\\View\\Renderer\\RendererInterface", zendViewIface.getOffset());
                phpClass.setFile(zendViewIface.getFileObject());
            } else {
                phpClass = new PhpClass("RendererInterface", "\\Zend\\View\\Renderer\\RendererInterface");
            }
            this.view = new PhpVariable("$this", phpClass);
            FileObject file = phpClass.getFile();
            if (file != null) {
                this.view.setFile(file);
            }
        }

        public PhpVariable getView() {
            return this.view;
        }
    }
}

